---
title: Build a website
subtitle: Create beautiful websites from your MyST project.
subject: Quickstart tutorial
---

:::{important} Objective
The goal of this tutorial is to explore the ways in which the MyST Document Engine can be used to create rich websites.
:::

## Running `jupyter book start`

Jupyter Book ships with a built-in server that renders your book as a locally-served website. The server can easily be started by running the `jupyter book start` command. Once the server is runnning, Jupyter Book will report the URL at which it can be found (see [](#code:start-server)):

```{code} shell
:linenos:
:emphasize-lines: 9
:name: code:start-server

$ jupyter book start
🔍 Querying template metadata from https://api.mystmd.org/templates/site/myst/book-theme
🐕 Fetching template from https://github.com/myst-templates/book-theme/archive/refs/heads/main.zip
💾 Saved template to path _build/templates/site/myst/book-theme
...
🔌 Server started on port 3000!  🥳 🎉


	👉  http://localhost:3000  👈
```

Navigating to that URL in your web-browser will load a website which updates as you modify your book, such as adding new files or changing prose. Try e.g. changing the title of [`intro.md`](#tutorial:creating-new-file).

## Declaring a table of contents

By default, Jupyter Book will attempt to find the important files that comprise your book, and {term}`deterministically order them <Deterministic Ordering>`. Once a project becomes more complex, we should look to add our files to the table of contents (TOC). Although the MyST Document Engine is clever enough to find and organise documents in your project folder, using an explicit TOC makes it easier for new contributors to understand the structure of your book. Let's update our [`myst.yml` from the previous section](./init.md#code:myst-yml). Jupyter Book defines a `--write-toc` argument to the `init` command that automatically populates a table of contents from the files MyST-MD finds in the project folder.

```{code} yaml
:filename: myst.yml
:caption: The `myst.yml` produced by running `jupyter book init --write-toc`.
:name: code:myst-yml-toc
:linenos:
:emphasize-lines: 12, 13, 14

# See docs at: https://mystmd.org/guide/frontmatter
version: 1
project:
  id: 4da9cb15-177c-41f5-8c4e-6a24b4e87eab
  title: An example Jupyter Book
  description: A collection of files that build up a book
  keywords:
    - jupyter-book
    - something-else
  github: captain-jupyter/my-book
  # To autogenerate a table of contents, run "jupyter book init --write-toc"
  toc:
    # Auto-generated by `myst init --write-toc`
    - file: intro.md
site:
  template: book-theme
  # options:
  #   favicon: favicon.ico
  #   logo: site_logo.png
```

The entries within a table of contents can be nested under titles and/or other pages. See [the MyST-MD guide](xref:guide/table-of-contents#nesting-pages-and-dropdowns) for more.
