from typing import List, Optional, Union

class Language:
    def iso_code_639_1(self) -> str: ...
    def iso_code_639_3(self) -> str: ...
    @staticmethod
    def all() -> List["Language"]: ...
    @staticmethod
    def all_spoken_ones() -> List["Language"]: ...
    @staticmethod
    def all_with_arabic_script() -> List["Language"]: ...
    @staticmethod
    def all_with_cyrillic_script() -> List["Language"]: ...
    @staticmethod
    def all_with_devanagari_script() -> List["Language"]: ...
    @staticmethod
    def all_with_latin_script() -> List["Language"]: ...

class LanguageDetector:
    def __init__(
        self,
        languages: List[Union[Language, str]] = [],
        preload: bool = False,
        minimum_relative_distance: float = 0.0,
    ): ...
    def detect(self, text: str) -> Optional[Language]: ...
    def confidence(self, text: str) -> Optional[Language]: ...
