"""
Synqed - A simplified wrapper around A2A for multi-agent systems.

This module provides high-level abstractions for creating, managing,
and coordinating AI agents using the A2A protocol.
"""

import asyncio
import aiohttp

from synqed.agent import Agent
from synqed.agent_card import AgentCardBuilder
from synqed.client import Client
from synqed.delegator import TaskDelegator
from synqed.orchestrator import (
    Orchestrator,
    LLMProvider,
    AgentSelection,
    OrchestrationResult,
)
from synqed.server import AgentServer

__version__ = "1.0.0"

__all__ = [
    "Agent",
    "AgentCardBuilder",
    "AgentServer",
    "Client",
    "TaskDelegator",
    "Orchestrator",
    "LLMProvider",
    "AgentSelection",
    "OrchestrationResult",
    "asyncio",
    "aiohttp",
]

