"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WindowsEKSCluster = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class WindowsEKSCluster extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        props.eksSsmParameters = props.eksSsmParameters ?? {};
        props.eksSsmParameters.clusterNamePointer =
            props.eksSsmParameters.clusterNamePointer ?? 'windows-eks-cluster-name';
        if (props.eksSsmParameters.namespace) {
            props.eksSsmParameters.namespace = `${props.eksSsmParameters.namespace}/compute/eks`;
        }
        else {
            props.eksSsmParameters.namespace = 'cdk-skylight/compute/eks';
        }
        const eks_role = new aws_cdk_lib_1.aws_iam.Role(this, 'eks-instance-role', {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('ec2.amazonaws.com'),
            roleName: 'eks-node-role' + id,
            managedPolicies: [
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'),
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonEKSWorkerNodePolicy'),
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonEC2ContainerRegistryReadOnly'),
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonEKS_CNI_Policy'),
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMDirectoryServiceAccess'),
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AWSKeyManagementServicePowerUser'),
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonEKSClusterPolicy'),
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonEKSVPCResourceController'),
            ],
        });
        this.eksCluster = new aws_cdk_lib_1.aws_eks.Cluster(this, 'WindowsEKSCluster', {
            version: aws_cdk_lib_1.aws_eks.KubernetesVersion.V1_21,
            vpc: props.vpc,
        });
        this.eksCluster.awsAuth.addRoleMapping(eks_role, {
            groups: ['system:bootstrappers', 'system:nodes'],
            username: 'system:node:{{EC2PrivateDNSName}}',
        });
        // https://docs.aws.amazon.com/eks/latest/userguide/windows-support.html#enable-windows-support
        const yaml_file = {
            apiVersion: 'v1',
            kind: 'ConfigMap',
            metadata: {
                name: 'amazon-vpc-cni',
                namespace: 'kube-system',
            },
            data: {
                'enable-windows-ipam': 'true',
            },
        };
        this.eksCluster.addManifest('WindowsSupport', yaml_file);
        new aws_cdk_lib_1.aws_ssm.StringParameter(this, 'clusterNamePointer', {
            parameterName: `/${props.eksSsmParameters.namespace}/${props.eksSsmParameters.clusterNamePointer}`,
            stringValue: this.eksCluster.clusterName,
        });
    }
}
exports.WindowsEKSCluster = WindowsEKSCluster;
_a = JSII_RTTI_SYMBOL_1;
WindowsEKSCluster[_a] = { fqn: "cdk-skylight.compute.WindowsEKSCluster", version: "1.1.492" };
//# sourceMappingURL=data:application/json;base64,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