# 
# Generated by the nebius.base.protos.compiler.  DO NOT EDIT!
# 

import builtins as builtins
import collections.abc as abc
import google.protobuf.descriptor as descriptor_1
import google.protobuf.message as message_1
import grpc as grpc
import nebius.aio.client as client
import nebius.aio.request as request_1
import nebius.api.nebius.billing.v1alpha1.calculator_pb2 as calculator_pb2
import nebius.api.nebius.billing.v1alpha1.calculator_service_pb2 as calculator_service_pb2
import nebius.api.nebius.billing.v1alpha1.offer_type_pb2 as offer_type_pb2
import nebius.api.nebius.compute.v1 as v1_1
import nebius.api.nebius.compute.v1.disk_service_pb2 as disk_service_pb2
import nebius.api.nebius.compute.v1.filesystem_service_pb2 as filesystem_service_pb2
import nebius.api.nebius.compute.v1.instance_service_pb2 as instance_service_pb2
import nebius.base.protos.descriptor as descriptor
import nebius.base.protos.pb_classes as pb_classes
import nebius.base.protos.pb_enum as pb_enum
import nebius.base.protos.unset as unset
import typing as typing
#@ local imports here @#

# file: nebius/billing/v1alpha1/calculator.proto
class ResourceSpec(pb_classes.Message):
    """
    Resource specification for cost estimation.
    Contains the specifications for creating and updating different types of resources.
    """
    
    __PB2_CLASS__ = calculator_pb2.ResourceSpec
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.billing.v1alpha1.ResourceSpec",calculator_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    class __OneOfClass_resource_spec__(pb_classes.OneOf):
        name: builtins.str= "resource_spec"
        
        def __init__(self, msg: "ResourceSpec") -> None:
            super().__init__()
            self._message: "ResourceSpec" = msg
    
    class __OneOfClass_resource_spec_compute_instance_spec__(__OneOfClass_resource_spec__):
        field: typing.Literal["compute_instance_spec"] = "compute_instance_spec"
        
        def __init__(self, msg: "ResourceSpec") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "v1_1.CreateInstanceRequest":
            return self._message.compute_instance_spec
    
    class __OneOfClass_resource_spec_compute_instance_update_spec__(__OneOfClass_resource_spec__):
        field: typing.Literal["compute_instance_update_spec"] = "compute_instance_update_spec"
        
        def __init__(self, msg: "ResourceSpec") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "v1_1.UpdateInstanceRequest":
            return self._message.compute_instance_update_spec
    
    class __OneOfClass_resource_spec_compute_disk_spec__(__OneOfClass_resource_spec__):
        field: typing.Literal["compute_disk_spec"] = "compute_disk_spec"
        
        def __init__(self, msg: "ResourceSpec") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "v1_1.CreateDiskRequest":
            return self._message.compute_disk_spec
    
    class __OneOfClass_resource_spec_compute_disk_update_spec__(__OneOfClass_resource_spec__):
        field: typing.Literal["compute_disk_update_spec"] = "compute_disk_update_spec"
        
        def __init__(self, msg: "ResourceSpec") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "v1_1.UpdateDiskRequest":
            return self._message.compute_disk_update_spec
    
    class __OneOfClass_resource_spec_compute_filesystem_spec__(__OneOfClass_resource_spec__):
        field: typing.Literal["compute_filesystem_spec"] = "compute_filesystem_spec"
        
        def __init__(self, msg: "ResourceSpec") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "v1_1.CreateFilesystemRequest":
            return self._message.compute_filesystem_spec
    
    class __OneOfClass_resource_spec_compute_filesystem_update_spec__(__OneOfClass_resource_spec__):
        field: typing.Literal["compute_filesystem_update_spec"] = "compute_filesystem_update_spec"
        
        def __init__(self, msg: "ResourceSpec") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "v1_1.UpdateFilesystemRequest":
            return self._message.compute_filesystem_update_spec
    
    @builtins.property
    def resource_spec(self) -> __OneOfClass_resource_spec_compute_instance_spec__|__OneOfClass_resource_spec_compute_instance_update_spec__|__OneOfClass_resource_spec_compute_disk_spec__|__OneOfClass_resource_spec_compute_disk_update_spec__|__OneOfClass_resource_spec_compute_filesystem_spec__|__OneOfClass_resource_spec_compute_filesystem_update_spec__|None:
        field_name_1: str|None = super().which_field_in_oneof("resource_spec")
        match field_name_1:
            case "compute_instance_spec":
                return self.__OneOfClass_resource_spec_compute_instance_spec__(self)
            case "compute_instance_update_spec":
                return self.__OneOfClass_resource_spec_compute_instance_update_spec__(self)
            case "compute_disk_spec":
                return self.__OneOfClass_resource_spec_compute_disk_spec__(self)
            case "compute_disk_update_spec":
                return self.__OneOfClass_resource_spec_compute_disk_update_spec__(self)
            case "compute_filesystem_spec":
                return self.__OneOfClass_resource_spec_compute_filesystem_spec__(self)
            case "compute_filesystem_update_spec":
                return self.__OneOfClass_resource_spec_compute_filesystem_update_spec__(self)
            case None:
                return None
            case _:
                raise pb_classes.OneOfMatchError(field_name_1)
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        compute_instance_spec: "v1_1.CreateInstanceRequest|instance_service_pb2.CreateInstanceRequest|None|unset.UnsetType" = unset.Unset,
        compute_instance_update_spec: "v1_1.UpdateInstanceRequest|instance_service_pb2.UpdateInstanceRequest|None|unset.UnsetType" = unset.Unset,
        compute_disk_spec: "v1_1.CreateDiskRequest|disk_service_pb2.CreateDiskRequest|None|unset.UnsetType" = unset.Unset,
        compute_disk_update_spec: "v1_1.UpdateDiskRequest|disk_service_pb2.UpdateDiskRequest|None|unset.UnsetType" = unset.Unset,
        compute_filesystem_spec: "v1_1.CreateFilesystemRequest|filesystem_service_pb2.CreateFilesystemRequest|None|unset.UnsetType" = unset.Unset,
        compute_filesystem_update_spec: "v1_1.UpdateFilesystemRequest|filesystem_service_pb2.UpdateFilesystemRequest|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(compute_instance_spec, unset.UnsetType):
            self.compute_instance_spec = compute_instance_spec
        if not isinstance(compute_instance_update_spec, unset.UnsetType):
            self.compute_instance_update_spec = compute_instance_update_spec
        if not isinstance(compute_disk_spec, unset.UnsetType):
            self.compute_disk_spec = compute_disk_spec
        if not isinstance(compute_disk_update_spec, unset.UnsetType):
            self.compute_disk_update_spec = compute_disk_update_spec
        if not isinstance(compute_filesystem_spec, unset.UnsetType):
            self.compute_filesystem_spec = compute_filesystem_spec
        if not isinstance(compute_filesystem_update_spec, unset.UnsetType):
            self.compute_filesystem_update_spec = compute_filesystem_update_spec
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "compute_instance_spec",
            "compute_instance_update_spec",
            "compute_disk_spec",
            "compute_disk_update_spec",
            "compute_filesystem_spec",
            "compute_filesystem_update_spec",
            "resource_spec",
        ]
    
    @builtins.property
    def compute_instance_spec(self) -> "v1_1.CreateInstanceRequest|None":
        return super()._get_field("compute_instance_spec", explicit_presence=True,
        wrap=v1_1.CreateInstanceRequest,
        )
    @compute_instance_spec.setter
    def compute_instance_spec(self, value: "v1_1.CreateInstanceRequest|instance_service_pb2.CreateInstanceRequest|None") -> None:
        return super()._set_field("compute_instance_spec",value,explicit_presence=True,
        )
    
    @builtins.property
    def compute_instance_update_spec(self) -> "v1_1.UpdateInstanceRequest|None":
        return super()._get_field("compute_instance_update_spec", explicit_presence=True,
        wrap=v1_1.UpdateInstanceRequest,
        )
    @compute_instance_update_spec.setter
    def compute_instance_update_spec(self, value: "v1_1.UpdateInstanceRequest|instance_service_pb2.UpdateInstanceRequest|None") -> None:
        return super()._set_field("compute_instance_update_spec",value,explicit_presence=True,
        )
    
    @builtins.property
    def compute_disk_spec(self) -> "v1_1.CreateDiskRequest|None":
        return super()._get_field("compute_disk_spec", explicit_presence=True,
        wrap=v1_1.CreateDiskRequest,
        )
    @compute_disk_spec.setter
    def compute_disk_spec(self, value: "v1_1.CreateDiskRequest|disk_service_pb2.CreateDiskRequest|None") -> None:
        return super()._set_field("compute_disk_spec",value,explicit_presence=True,
        )
    
    @builtins.property
    def compute_disk_update_spec(self) -> "v1_1.UpdateDiskRequest|None":
        return super()._get_field("compute_disk_update_spec", explicit_presence=True,
        wrap=v1_1.UpdateDiskRequest,
        )
    @compute_disk_update_spec.setter
    def compute_disk_update_spec(self, value: "v1_1.UpdateDiskRequest|disk_service_pb2.UpdateDiskRequest|None") -> None:
        return super()._set_field("compute_disk_update_spec",value,explicit_presence=True,
        )
    
    @builtins.property
    def compute_filesystem_spec(self) -> "v1_1.CreateFilesystemRequest|None":
        return super()._get_field("compute_filesystem_spec", explicit_presence=True,
        wrap=v1_1.CreateFilesystemRequest,
        )
    @compute_filesystem_spec.setter
    def compute_filesystem_spec(self, value: "v1_1.CreateFilesystemRequest|filesystem_service_pb2.CreateFilesystemRequest|None") -> None:
        return super()._set_field("compute_filesystem_spec",value,explicit_presence=True,
        )
    
    @builtins.property
    def compute_filesystem_update_spec(self) -> "v1_1.UpdateFilesystemRequest|None":
        return super()._get_field("compute_filesystem_update_spec", explicit_presence=True,
        wrap=v1_1.UpdateFilesystemRequest,
        )
    @compute_filesystem_update_spec.setter
    def compute_filesystem_update_spec(self, value: "v1_1.UpdateFilesystemRequest|filesystem_service_pb2.UpdateFilesystemRequest|None") -> None:
        return super()._set_field("compute_filesystem_update_spec",value,explicit_presence=True,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "compute_instance_spec":"compute_instance_spec",
        "compute_instance_update_spec":"compute_instance_update_spec",
        "compute_disk_spec":"compute_disk_spec",
        "compute_disk_update_spec":"compute_disk_update_spec",
        "compute_filesystem_spec":"compute_filesystem_spec",
        "compute_filesystem_update_spec":"compute_filesystem_update_spec",
        "resource_spec":"resource_spec",
    }
    
class ResourceGroupCost(pb_classes.Message):
    """
    Cost information for a group of resources.
    """
    
    __PB2_CLASS__ = calculator_pb2.ResourceGroupCost
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.billing.v1alpha1.ResourceGroupCost",calculator_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    class __OneOfClass_cost_type__(pb_classes.OneOf):
        name: builtins.str= "cost_type"
        
        def __init__(self, msg: "ResourceGroupCost") -> None:
            super().__init__()
            self._message: "ResourceGroupCost" = msg
    
    class __OneOfClass_cost_type_general__(__OneOfClass_cost_type__):
        field: typing.Literal["general"] = "general"
        
        def __init__(self, msg: "ResourceGroupCost") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "GeneralTotalCost":
            return self._message.general
    
    @builtins.property
    def cost_type(self) -> __OneOfClass_cost_type_general__|None:
        field_name_1: str|None = super().which_field_in_oneof("cost_type")
        match field_name_1:
            case "general":
                return self.__OneOfClass_cost_type_general__(self)
            case None:
                return None
            case _:
                raise pb_classes.OneOfMatchError(field_name_1)
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        general: "GeneralTotalCost|calculator_pb2.GeneralTotalCost|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(general, unset.UnsetType):
            self.general = general
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "general",
            "cost_type",
        ]
    
    @builtins.property
    def general(self) -> "GeneralTotalCost|None":
        """
        Fixed total cost calculation.
        Used when the total cost is deterministic and doesn't vary.
        """
        
        return super()._get_field("general", explicit_presence=True,
        wrap=GeneralTotalCost,
        )
    @general.setter
    def general(self, value: "GeneralTotalCost|calculator_pb2.GeneralTotalCost|None") -> None:
        return super()._set_field("general",value,explicit_presence=True,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "general":"general",
        "cost_type":"cost_type",
    }
    
class GeneralTotalCost(pb_classes.Message):
    """
    General total cost with a single fixed amount.
    Used for resources with predictable, non-variable pricing.
    """
    
    __PB2_CLASS__ = calculator_pb2.GeneralTotalCost
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.billing.v1alpha1.GeneralTotalCost",calculator_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        total: "CostBreakdown|calculator_pb2.CostBreakdown|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(total, unset.UnsetType):
            self.total = total
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "total",
        ]
    
    @builtins.property
    def total(self) -> "CostBreakdown":
        """
        Cost breakdown including all SKUs and their individual costs.
        """
        
        return super()._get_field("total", explicit_presence=False,
        wrap=CostBreakdown,
        )
    @total.setter
    def total(self, value: "CostBreakdown|calculator_pb2.CostBreakdown|None") -> None:
        return super()._set_field("total",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "total":"total",
    }
    
class GeneralResourceCost(pb_classes.Message):
    """
    General resource cost for single-unit resources.
    Used for resources like compute instances or disks where the unit count is not variable.
    """
    
    __PB2_CLASS__ = calculator_pb2.GeneralResourceCost
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.billing.v1alpha1.GeneralResourceCost",calculator_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        total: "CostBreakdown|calculator_pb2.CostBreakdown|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(total, unset.UnsetType):
            self.total = total
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "total",
        ]
    
    @builtins.property
    def total(self) -> "CostBreakdown":
        """
        Cost breakdown for the resource including all SKU costs and total cost.
        """
        
        return super()._get_field("total", explicit_presence=False,
        wrap=CostBreakdown,
        )
    @total.setter
    def total(self, value: "CostBreakdown|calculator_pb2.CostBreakdown|None") -> None:
        return super()._set_field("total",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "total":"total",
    }
    
class CostBreakdown(pb_classes.Message):
    """
    Detailed cost breakdown showing individual SKU costs and totals.
    """
    
    __PB2_CLASS__ = calculator_pb2.CostBreakdown
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.billing.v1alpha1.CostBreakdown",calculator_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        cost: "builtins.str|None|unset.UnsetType" = unset.Unset,
        cost_rounded: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(cost, unset.UnsetType):
            self.cost = cost
        if not isinstance(cost_rounded, unset.UnsetType):
            self.cost_rounded = cost_rounded
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "cost",
            "cost_rounded",
        ]
    
    @builtins.property
    def cost(self) -> "builtins.str":
        """
        Total cost as a decimal string.
        Represents the sum of all SKU costs with full precision.
        Example: "42.123456789" for precise billing calculations.
        """
        
        return super()._get_field("cost", explicit_presence=False,
        )
    @cost.setter
    def cost(self, value: "builtins.str|None") -> None:
        return super()._set_field("cost",value,explicit_presence=False,
        )
    
    @builtins.property
    def cost_rounded(self) -> "builtins.str":
        """
        Total cost rounded up to 2 decimal places.
        Example: "42.13"
        """
        
        return super()._get_field("cost_rounded", explicit_presence=False,
        )
    @cost_rounded.setter
    def cost_rounded(self, value: "builtins.str|None") -> None:
        return super()._set_field("cost_rounded",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "cost":"cost",
        "cost_rounded":"cost_rounded",
    }
    
# file: nebius/billing/v1alpha1/offer_type.proto
class OfferType(pb_enum.Enum):
    """
    OfferType is a enum that specifies the type of offer.
    """
    
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.EnumDescriptor](".nebius.billing.v1alpha1.OfferType",offer_type_pb2.DESCRIPTOR,descriptor_1.EnumDescriptor)
    OFFER_TYPE_UNSPECIFIED = 0
    OFFER_TYPE_CONTRACT_PRICE = 1
    """
    Contract price is a special price for SKU.
    """
    

# file: nebius/billing/v1alpha1/calculator_service.proto
class EstimateRequest(pb_classes.Message):
    __PB2_CLASS__ = calculator_service_pb2.EstimateRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.billing.v1alpha1.EstimateRequest",calculator_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        resource_spec: "ResourceSpec|calculator_pb2.ResourceSpec|None|unset.UnsetType" = unset.Unset,
        offer_types: "abc.Iterable[OfferType]|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(resource_spec, unset.UnsetType):
            self.resource_spec = resource_spec
        if not isinstance(offer_types, unset.UnsetType):
            self.offer_types = offer_types
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "resource_spec",
            "offer_types",
        ]
    
    @builtins.property
    def resource_spec(self) -> "ResourceSpec":
        """
        Resource specification for cost estimation.
        Must contain exactly one resource type.
        """
        
        return super()._get_field("resource_spec", explicit_presence=False,
        wrap=ResourceSpec,
        )
    @resource_spec.setter
    def resource_spec(self, value: "ResourceSpec|calculator_pb2.ResourceSpec|None") -> None:
        return super()._set_field("resource_spec",value,explicit_presence=False,
        )
    
    @builtins.property
    def offer_types(self) -> "abc.MutableSequence[OfferType]":
        """
        Type of offers to be applied to the cost estimate.
        """
        
        return super()._get_field("offer_types", explicit_presence=False,
        wrap=pb_classes.Repeated,
        )
    @offer_types.setter
    def offer_types(self, value: "abc.Iterable[OfferType]|None") -> None:
        return super()._set_field("offer_types",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "resource_spec":"resource_spec",
        "offer_types":"offer_types",
    }
    
class EstimateResponse(pb_classes.Message):
    __PB2_CLASS__ = calculator_service_pb2.EstimateResponse
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.billing.v1alpha1.EstimateResponse",calculator_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        hourly_cost: "ResourceGroupCost|calculator_pb2.ResourceGroupCost|None|unset.UnsetType" = unset.Unset,
        monthly_cost: "ResourceGroupCost|calculator_pb2.ResourceGroupCost|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(hourly_cost, unset.UnsetType):
            self.hourly_cost = hourly_cost
        if not isinstance(monthly_cost, unset.UnsetType):
            self.monthly_cost = monthly_cost
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "hourly_cost",
            "monthly_cost",
        ]
    
    @builtins.property
    def hourly_cost(self) -> "ResourceGroupCost":
        """
        Estimated hourly cost for the resource.
        """
        
        return super()._get_field("hourly_cost", explicit_presence=False,
        wrap=ResourceGroupCost,
        )
    @hourly_cost.setter
    def hourly_cost(self, value: "ResourceGroupCost|calculator_pb2.ResourceGroupCost|None") -> None:
        return super()._set_field("hourly_cost",value,explicit_presence=False,
        )
    
    @builtins.property
    def monthly_cost(self) -> "ResourceGroupCost":
        """
        Estimated monthly cost for the resource.
        Calculated as hourly_cost * 24 * 30 (720 hours) for resources running continuously.
        """
        
        return super()._get_field("monthly_cost", explicit_presence=False,
        wrap=ResourceGroupCost,
        )
    @monthly_cost.setter
    def monthly_cost(self, value: "ResourceGroupCost|calculator_pb2.ResourceGroupCost|None") -> None:
        return super()._set_field("monthly_cost",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "hourly_cost":"hourly_cost",
        "monthly_cost":"monthly_cost",
    }
    
class EstimateBatchRequest(pb_classes.Message):
    __PB2_CLASS__ = calculator_service_pb2.EstimateBatchRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.billing.v1alpha1.EstimateBatchRequest",calculator_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        resource_specs: "abc.Iterable[ResourceSpec]|None|unset.UnsetType" = unset.Unset,
        offer_types: "abc.Iterable[OfferType]|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(resource_specs, unset.UnsetType):
            self.resource_specs = resource_specs
        if not isinstance(offer_types, unset.UnsetType):
            self.offer_types = offer_types
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "resource_specs",
            "offer_types",
        ]
    
    @builtins.property
    def resource_specs(self) -> "abc.MutableSequence[ResourceSpec]":
        """
        List of resource specifications for cost estimation.
        Each resource will be priced individually and then aggregated into total costs.
        """
        
        return super()._get_field("resource_specs", explicit_presence=False,
        wrap=pb_classes.Repeated.with_wrap(ResourceSpec,None,None),
        )
    @resource_specs.setter
    def resource_specs(self, value: "abc.Iterable[ResourceSpec]|None") -> None:
        return super()._set_field("resource_specs",value,explicit_presence=False,
        )
    
    @builtins.property
    def offer_types(self) -> "abc.MutableSequence[OfferType]":
        """
        Type of offers to be applied to the cost estimate.
        """
        
        return super()._get_field("offer_types", explicit_presence=False,
        wrap=pb_classes.Repeated,
        )
    @offer_types.setter
    def offer_types(self, value: "abc.Iterable[OfferType]|None") -> None:
        return super()._set_field("offer_types",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "resource_specs":"resource_specs",
        "offer_types":"offer_types",
    }
    
class EstimateBatchResponse(pb_classes.Message):
    __PB2_CLASS__ = calculator_service_pb2.EstimateBatchResponse
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.billing.v1alpha1.EstimateBatchResponse",calculator_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        hourly_cost: "ResourceGroupCost|calculator_pb2.ResourceGroupCost|None|unset.UnsetType" = unset.Unset,
        monthly_cost: "ResourceGroupCost|calculator_pb2.ResourceGroupCost|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(hourly_cost, unset.UnsetType):
            self.hourly_cost = hourly_cost
        if not isinstance(monthly_cost, unset.UnsetType):
            self.monthly_cost = monthly_cost
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "hourly_cost",
            "monthly_cost",
        ]
    
    @builtins.property
    def hourly_cost(self) -> "ResourceGroupCost":
        """
        Estimated hourly cost for all resources in the batch.
        """
        
        return super()._get_field("hourly_cost", explicit_presence=False,
        wrap=ResourceGroupCost,
        )
    @hourly_cost.setter
    def hourly_cost(self, value: "ResourceGroupCost|calculator_pb2.ResourceGroupCost|None") -> None:
        return super()._set_field("hourly_cost",value,explicit_presence=False,
        )
    
    @builtins.property
    def monthly_cost(self) -> "ResourceGroupCost":
        """
        Estimated monthly cost for all resources in the batch.
        Calculated as hourly_cost * 24 * 30 (720 hours) for resources running continuously.
        """
        
        return super()._get_field("monthly_cost", explicit_presence=False,
        wrap=ResourceGroupCost,
        )
    @monthly_cost.setter
    def monthly_cost(self, value: "ResourceGroupCost|calculator_pb2.ResourceGroupCost|None") -> None:
        return super()._set_field("monthly_cost",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "hourly_cost":"hourly_cost",
        "monthly_cost":"monthly_cost",
    }
    

class CalculatorServiceClient(client.Client):
    """
    Calculator service for estimating resource costs.
    """
    
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.ServiceDescriptor](".nebius.billing.v1alpha1.CalculatorService",calculator_service_pb2.DESCRIPTOR,descriptor_1.ServiceDescriptor)
    __service_name__ = ".nebius.billing.v1alpha1.CalculatorService"
    
    def estimate(self,
        request: "EstimateRequest",
        metadata: abc.Iterable[builtins.tuple[builtins.str,builtins.str]]|None = None,
        timeout: builtins.float|None = None,
        credentials: grpc.CallCredentials | None = None,
        compression: grpc.Compression | None = None,
        retries: builtins.int | None = 3,
        per_retry_timeout: builtins.float | None = None,
    ) -> request_1.Request["EstimateRequest","EstimateResponse"]:
        """
        Estimates prices for a single resource.
        Returns both hourly and monthly cost estimates for the specified resource configuration.
        """
        
        return super().request(
            method="Estimate",
            request=request,
            result_pb2_class=calculator_service_pb2.EstimateResponse,
            metadata=metadata,
            timeout=timeout,
            credentials=credentials,
            compression=compression,
            retries=retries,
            per_retry_timeout=per_retry_timeout,
            result_wrapper=pb_classes.simple_wrapper(EstimateResponse),
        )
    
    def estimate_batch(self,
        request: "EstimateBatchRequest",
        metadata: abc.Iterable[builtins.tuple[builtins.str,builtins.str]]|None = None,
        timeout: builtins.float|None = None,
        credentials: grpc.CallCredentials | None = None,
        compression: grpc.Compression | None = None,
        retries: builtins.int | None = 3,
        per_retry_timeout: builtins.float | None = None,
    ) -> request_1.Request["EstimateBatchRequest","EstimateBatchResponse"]:
        """
        Estimates prices for multiple resources.
        Returns aggregated hourly and monthly cost estimates for all specified resources.
        """
        
        return super().request(
            method="EstimateBatch",
            request=request,
            result_pb2_class=calculator_service_pb2.EstimateBatchResponse,
            metadata=metadata,
            timeout=timeout,
            credentials=credentials,
            compression=compression,
            retries=retries,
            per_retry_timeout=per_retry_timeout,
            result_wrapper=pb_classes.simple_wrapper(EstimateBatchResponse),
        )
    

__all__ = [
    #@ local import names here @#
    "ResourceSpec",
    "ResourceGroupCost",
    "GeneralTotalCost",
    "GeneralResourceCost",
    "CostBreakdown",
    "OfferType",
    "EstimateRequest",
    "EstimateResponse",
    "EstimateBatchRequest",
    "EstimateBatchResponse",
    "CalculatorServiceClient",
]
