# CMIP6_CVs [![stable version](https://img.shields.io/badge/Current%20version-6.2.58.79-brightgreen.svg)](https://github.com/WCRP-CMIP/CMIP6_CVs/releases/tag/6.2.58.79) [![DOI](https://zenodo.org/badge/62754800.svg)](https://zenodo.org/doi/10.5281/zenodo.12197150)

Core Controlled Vocabularies (CVs) for use in CMIP6

## Registering Institutions, Models, or requesting changes to CVs:

To register your institution or model or to register a new experiment, please submit an issue/ticket following the instructions on the [CMIP6_CVs issue page](https://github.com/WCRP-CMIP/CMIP6_CVs/issues/new). Follow the same procedure to request a change in any other CV.

Some support for CMIP participating modeling groups is available: pcmdi-cmip@llnl.gov

To view current repository contents in HTML format, point your browser to:

| target | URL |
| :-- | :-- |
| `experiment_id` | [CMIP6_experiment_id.html](https://wcrp-cmip.github.io/CMIP6_CVs/docs/CMIP6_experiment_id.html) |
| `institution_id` | [CMIP6_institution_id.html](https://wcrp-cmip.github.io/CMIP6_CVs/docs/CMIP6_institution_id.html) |
| `source_id` | [CMIP6_source_id.html](https://wcrp-cmip.github.io/CMIP6_CVs/docs/CMIP6_source_id.html) |
| `source_id_licenses` | [CMIP6_source_id_licenses.html](https://wcrp-cmip.github.io/CMIP6_CVs/docs/CMIP6_source_id_licenses.html) |
| `citation information` | [CMIP6_source_id_citation.html](https://wcrp-cmip.github.io/CMIP6_CVs/docs/CMIP6_source_id_citation.html) |
| `citation information by experiment` | [CMIP6_source_id_experiment_citation.html](https://wcrp-cmip.github.io/CMIP6_CVs/docs/CMIP6_source_id_experiment_citation.html) |

The CVs build on logic that is described in the [CMIP6 Global Attributes, DRS, Filenames, Directory Structure, and CV's](http://goo.gl/v1drZl) document.

The controlled vocabularies for CMIP6 will be augmented (e.g., as new institutions, models and experiments are registered), but there should be no changes in the existing vocabulary that would impair searches of and access to already published data or that would in any way invalidate published data.

## Contributors

[![Contributors](https://contrib.rocks/image?repo=WCRP-CMIP/CMIP6_CVs)](https://github.com/WCRP-CMIP/CMIP6_CVs/graphs/contributors)

Thanks to our contributors!

## Acknowledgement

The repository content has been collected from many contributors representing the Coupled Model Intercomparison Project phase 6 (CMIP6), including those from climate modeling groups and model intercomparison projects (MIPs) worldwide. The structure of content and tools required to maintain it was developed by climate and computer scientists from the Program for Climate Model Diagnosis and Intercomparison ([PCMDI](https://pcmdi.llnl.gov/)) at Lawrence Livermore National Laboratory ([LLNL](https://www.llnl.gov/)) with assistance from colleagues at the [UK MetOffice](https://www.metoffice.gov.uk/), UK Centre for Environmental Data Analysis ([CEDA](https://www.ceda.ac.uk/)), the Deutsches Klimarechenzentrum ([DKRZ](https://www.dkrz.de/en/)) in Germany and the members of the Infrastructure for the European Network for Earth System Modelling ([IS-ENES](https://is.enes.org/)) consortium.

This work is sponsored by the Regional and Global Model Analysis ([RGMA](https://climatemodeling.science.energy.gov/program/regional-global-model-analysis)) program of the Earth and Environmental Systems Sciences Division ([EESSD](https://science.osti.gov/ber/Research/eessd)) in the Office of Biological and Environmental Research ([BER](https://science.osti.gov/ber)) within the Department of Energy's ([DOE](https://www.energy.gov/)) Office of Science ([OS](https://science.osti.gov/)). The work at PCMDI is performed under the auspices of the U.S. Department of Energy by Lawrence Livermore National Laboratory under Contract DE-AC52-07NA27344.

<p>
    <img src="https://pcmdi.github.io/assets/PCMDI/100px-PCMDI-Logo-NoText-square-png8.png"
         width="65"
         style="margin-right: 30px"
         title="Program for Climate Model Diagnosis and Intercomparison"
         alt="Program for Climate Model Diagnosis and Intercomparison"
    >&nbsp;
    <img src="https://pcmdi.github.io/assets/DOE/480px-DOE_Seal_Color.png"
         width="65"
         style="margin-right: 30px"
         title="United States Department of Energy"
         alt="United States Department of Energy"
    >&nbsp;
    <img src="https://pcmdi.github.io/assets/LLNL/212px-LLNLiconPMS286-WHITEBACKGROUND.png"
         width="65"
         style="margin-right: 30px"
         title="Lawrence Livermore National Laboratory"
         alt="Lawrence Livermore National Laboratory"
    >&nbsp;
    <img src="https://pcmdi.github.io/assets/MetOffice/100px-Met_Office_LogoBLACK.png"
         width="65"
         style="margin-right: 30px"
         title="UK Met Office"
         alt="UK Met Office"
    >
</p>
