"""Automate downloading and processing PubMed."""

from .api import (
    AbstractText,
    Article,
    Journal,
    ensure_baselines,
    ensure_updates,
    iterate_ensure_articles,
    iterate_ensure_baselines,
    iterate_ensure_updates,
    iterate_process_articles,
    iterate_process_baselines,
    iterate_process_updates,
    process_articles,
    process_baselines,
    process_updates,
)
from .catalog import (
    CatalogRecord,
    ensure_catalog_provider_links,
    ensure_catfile_catalog,
    ensure_journal_overview,
    ensure_serfile_catalog,
    process_catalog,
    process_catalog_provider_links,
    process_journal_overview,
)
from .client import count_search_results, get_abstracts, get_titles, search
from .utils import ISSN, Author, Heading, Qualifier

__all__ = [
    "ISSN",
    "AbstractText",
    "Article",
    "Author",
    "CatalogRecord",
    "Heading",
    "Journal",
    "Qualifier",
    "count_search_results",
    "ensure_baselines",
    "ensure_catalog_provider_links",
    "ensure_catfile_catalog",
    "ensure_journal_overview",
    "ensure_serfile_catalog",
    "ensure_updates",
    "get_abstracts",
    "get_titles",
    "iterate_ensure_articles",
    "iterate_ensure_baselines",
    "iterate_ensure_updates",
    "iterate_process_articles",
    "iterate_process_baselines",
    "iterate_process_updates",
    "process_articles",
    "process_baselines",
    "process_catalog",
    "process_catalog_provider_links",
    "process_journal_overview",
    "process_updates",
    "search",
]
