import PySide2.Qt3DCore
import PySide2.Qt3DRender
import PySide2.QtCore
import PySide2.QtGui
import _typeshed
import collections
import shiboken2
import typing
T = typing.TypeVar('T')
import typing_extensions

class Qt3DExtras(shiboken2.Object):
    class QAbstractCameraController(PySide2.Qt3DCore.Qt3DCore.QEntity):
        class InputState(shiboken2.Object):
            altKeyActive: _typeshed.Incomplete
            leftMouseButtonActive: _typeshed.Incomplete
            middleMouseButtonActive: _typeshed.Incomplete
            rightMouseButtonActive: _typeshed.Incomplete
            rxAxisValue: _typeshed.Incomplete
            ryAxisValue: _typeshed.Incomplete
            shiftKeyActive: _typeshed.Incomplete
            txAxisValue: _typeshed.Incomplete
            tyAxisValue: _typeshed.Incomplete
            tzAxisValue: _typeshed.Incomplete
            @typing.overload
            def __init__(self, InputState: Qt3DExtras.QAbstractCameraController.InputState) -> None: ...
            @typing.overload
            def __init__(self) -> None: ...
            def __copy__(self) -> None: ...
        accelerationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        cameraChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        decelerationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        linearSpeedChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        lookSpeedChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: PySide2.Qt3DCore.Qt3DCore.QEntity.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def acceleration(self) -> float: ...
        def camera(self) -> PySide2.Qt3DRender.Qt3DRender.QCamera: ...
        def deceleration(self) -> float: ...
        def linearSpeed(self) -> float: ...
        def lookSpeed(self) -> float: ...
        def setAcceleration(self, acceleration: float) -> None: ...
        def setCamera(self, camera: PySide2.Qt3DRender.Qt3DRender.QCamera) -> None: ...
        def setDeceleration(self, deceleration: float) -> None: ...
        def setLinearSpeed(self, linearSpeed: float) -> None: ...
        def setLookSpeed(self, lookSpeed: float) -> None: ...

    class QAbstractSpriteSheet(PySide2.Qt3DCore.Qt3DCore.QNode):
        currentIndexChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        textureChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        textureTransformChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @classmethod
        def __init__(cls, *args, currentIndex: int = ..., currentIndexChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QAbstractSpriteSheet.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parent: typing.Any = ..., parentChanged: typing.Callable = ..., texture: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture = ..., textureChanged: typing.Callable = ..., textureTransform: PySide2.QtGui.QMatrix3x3 = ..., textureTransformChanged: typing.Callable = ..., **kwargs) -> None: ...
        def currentIndex(self) -> int: ...
        def setCurrentIndex(self, currentIndex: int) -> None: ...
        def setTexture(self, texture: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture) -> None: ...
        def texture(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture: ...
        def textureTransform(self) -> PySide2.QtGui.QMatrix3x3: ...

    class QConeGeometry(PySide2.Qt3DRender.Qt3DRender.QGeometry):
        bottomRadiusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        hasBottomEndcapChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        hasTopEndcapChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        lengthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        ringsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        slicesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        topRadiusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., bottomRadius: float = ..., bottomRadiusChanged: typing.Callable = ..., boundingVolumePositionAttribute: typing.Any = ..., boundingVolumePositionAttributeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QConeGeometry.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., hasBottomEndcap: bool = ..., hasBottomEndcapChanged: typing.Callable = ..., hasTopEndcap: bool = ..., hasTopEndcapChanged: typing.Callable = ..., indexAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., length: float = ..., lengthChanged: typing.Callable = ..., maxExtent: PySide2.QtGui.QVector3D = ..., maxExtentChanged: typing.Callable = ..., minExtent: PySide2.QtGui.QVector3D = ..., minExtentChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., normalAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., positionAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., rings: int = ..., ringsChanged: typing.Callable = ..., slices: int = ..., slicesChanged: typing.Callable = ..., texCoordAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., topRadius: float = ..., topRadiusChanged: typing.Callable = ...) -> None: ...
        def bottomRadius(self) -> float: ...
        def hasBottomEndcap(self) -> bool: ...
        def hasTopEndcap(self) -> bool: ...
        def indexAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def length(self) -> float: ...
        def normalAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def positionAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def rings(self) -> int: ...
        def setBottomRadius(self, bottomRadius: float) -> None: ...
        def setHasBottomEndcap(self, hasBottomEndcap: bool) -> None: ...
        def setHasTopEndcap(self, hasTopEndcap: bool) -> None: ...
        def setLength(self, length: float) -> None: ...
        def setRings(self, rings: int) -> None: ...
        def setSlices(self, slices: int) -> None: ...
        def setTopRadius(self, topRadius: float) -> None: ...
        def slices(self) -> int: ...
        def texCoordAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def topRadius(self) -> float: ...
        def updateIndices(self) -> None: ...
        def updateVertices(self) -> None: ...

    class QConeMesh(PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer):
        bottomRadiusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        hasBottomEndcapChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        hasTopEndcapChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        lengthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        ringsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        slicesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        topRadiusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., bottomRadius: float = ..., bottomRadiusChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QConeMesh.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., firstInstance: int = ..., firstInstanceChanged: typing.Callable = ..., firstVertex: int = ..., firstVertexChanged: typing.Callable = ..., geometry: typing.Any = ..., geometryChanged: typing.Callable = ..., hasBottomEndcap: bool = ..., hasBottomEndcapChanged: typing.Callable = ..., hasTopEndcap: bool = ..., hasTopEndcapChanged: typing.Callable = ..., indexBufferByteOffset: int = ..., indexBufferByteOffsetChanged: typing.Callable = ..., indexOffset: int = ..., indexOffsetChanged: typing.Callable = ..., instanceCount: int = ..., instanceCountChanged: typing.Callable = ..., isShareable: bool = ..., length: float = ..., lengthChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., primitiveRestartEnabled: bool = ..., primitiveRestartEnabledChanged: typing.Callable = ..., primitiveType: Qt3DExtras.QConeMesh.PrimitiveType = ..., primitiveTypeChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., restartIndexValue: int = ..., restartIndexValueChanged: typing.Callable = ..., rings: int = ..., ringsChanged: typing.Callable = ..., shareableChanged: typing.Callable = ..., slices: int = ..., slicesChanged: typing.Callable = ..., topRadius: float = ..., topRadiusChanged: typing.Callable = ..., vertexCount: int = ..., vertexCountChanged: typing.Callable = ..., verticesPerPatch: int = ..., verticesPerPatchChanged: typing.Callable = ...) -> None: ...
        def bottomRadius(self) -> float: ...
        def hasBottomEndcap(self) -> bool: ...
        def hasTopEndcap(self) -> bool: ...
        def length(self) -> float: ...
        def rings(self) -> int: ...
        def setBottomRadius(self, bottomRadius: float) -> None: ...
        def setFirstInstance(self, firstInstance: int) -> None: ...
        def setGeometry(self, geometry: PySide2.Qt3DRender.Qt3DRender.QGeometry) -> None: ...
        def setHasBottomEndcap(self, hasBottomEndcap: bool) -> None: ...
        def setHasTopEndcap(self, hasTopEndcap: bool) -> None: ...
        def setIndexOffset(self, indexOffset: int) -> None: ...
        def setInstanceCount(self, instanceCount: int) -> None: ...
        def setLength(self, length: float) -> None: ...
        def setPrimitiveRestartEnabled(self, enabled: bool) -> None: ...
        def setPrimitiveType(self, primitiveType: PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer.PrimitiveType) -> None: ...
        def setRestartIndexValue(self, index: int) -> None: ...
        def setRings(self, rings: int) -> None: ...
        def setSlices(self, slices: int) -> None: ...
        def setTopRadius(self, topRadius: float) -> None: ...
        def setVertexCount(self, vertexCount: int) -> None: ...
        def slices(self) -> int: ...
        def topRadius(self) -> float: ...

    class QCuboidGeometry(PySide2.Qt3DRender.Qt3DRender.QGeometry):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        xExtentChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        xyMeshResolutionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        xzMeshResolutionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        yExtentChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        yzMeshResolutionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        zExtentChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., boundingVolumePositionAttribute: typing.Any = ..., boundingVolumePositionAttributeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QCuboidGeometry.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., indexAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., maxExtent: PySide2.QtGui.QVector3D = ..., maxExtentChanged: typing.Callable = ..., minExtent: PySide2.QtGui.QVector3D = ..., minExtentChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., normalAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., positionAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., tangentAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., texCoordAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., xExtent: float = ..., xExtentChanged: typing.Callable = ..., xyMeshResolution: PySide2.QtCore.QSize = ..., xyMeshResolutionChanged: typing.Callable = ..., xzMeshResolution: PySide2.QtCore.QSize = ..., xzMeshResolutionChanged: typing.Callable = ..., yExtent: float = ..., yExtentChanged: typing.Callable = ..., yzMeshResolution: PySide2.QtCore.QSize = ..., yzMeshResolutionChanged: typing.Callable = ..., zExtent: float = ..., zExtentChanged: typing.Callable = ...) -> None: ...
        def indexAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def normalAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def positionAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def setXExtent(self, xExtent: float) -> None: ...
        def setXYMeshResolution(self, resolution: PySide2.QtCore.QSize) -> None: ...
        def setXZMeshResolution(self, resolution: PySide2.QtCore.QSize) -> None: ...
        def setYExtent(self, yExtent: float) -> None: ...
        def setYZMeshResolution(self, resolution: PySide2.QtCore.QSize) -> None: ...
        def setZExtent(self, zExtent: float) -> None: ...
        def tangentAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def texCoordAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def updateIndices(self) -> None: ...
        def updateVertices(self) -> None: ...
        def xExtent(self) -> float: ...
        def xyMeshResolution(self) -> PySide2.QtCore.QSize: ...
        def xzMeshResolution(self) -> PySide2.QtCore.QSize: ...
        def yExtent(self) -> float: ...
        def yzMeshResolution(self) -> PySide2.QtCore.QSize: ...
        def zExtent(self) -> float: ...

    class QCuboidMesh(PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        xExtentChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        xyMeshResolutionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        xzMeshResolutionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        yExtentChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        yzMeshResolutionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        zExtentChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QCuboidMesh.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., firstInstance: int = ..., firstInstanceChanged: typing.Callable = ..., firstVertex: int = ..., firstVertexChanged: typing.Callable = ..., geometry: typing.Any = ..., geometryChanged: typing.Callable = ..., indexBufferByteOffset: int = ..., indexBufferByteOffsetChanged: typing.Callable = ..., indexOffset: int = ..., indexOffsetChanged: typing.Callable = ..., instanceCount: int = ..., instanceCountChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., primitiveRestartEnabled: bool = ..., primitiveRestartEnabledChanged: typing.Callable = ..., primitiveType: Qt3DExtras.QCuboidMesh.PrimitiveType = ..., primitiveTypeChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., restartIndexValue: int = ..., restartIndexValueChanged: typing.Callable = ..., shareableChanged: typing.Callable = ..., vertexCount: int = ..., vertexCountChanged: typing.Callable = ..., verticesPerPatch: int = ..., verticesPerPatchChanged: typing.Callable = ..., xExtent: float = ..., xExtentChanged: typing.Callable = ..., xyMeshResolution: PySide2.QtCore.QSize = ..., xyMeshResolutionChanged: typing.Callable = ..., xzMeshResolution: PySide2.QtCore.QSize = ..., xzMeshResolutionChanged: typing.Callable = ..., yExtent: float = ..., yExtentChanged: typing.Callable = ..., yzMeshResolution: PySide2.QtCore.QSize = ..., yzMeshResolutionChanged: typing.Callable = ..., zExtent: float = ..., zExtentChanged: typing.Callable = ...) -> None: ...
        def setFirstInstance(self, firstInstance: int) -> None: ...
        def setGeometry(self, geometry: PySide2.Qt3DRender.Qt3DRender.QGeometry) -> None: ...
        def setIndexOffset(self, indexOffset: int) -> None: ...
        def setInstanceCount(self, instanceCount: int) -> None: ...
        def setPrimitiveRestartEnabled(self, enabled: bool) -> None: ...
        def setPrimitiveType(self, primitiveType: PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer.PrimitiveType) -> None: ...
        def setRestartIndexValue(self, index: int) -> None: ...
        def setVertexCount(self, vertexCount: int) -> None: ...
        def setXExtent(self, xExtent: float) -> None: ...
        def setXYMeshResolution(self, resolution: PySide2.QtCore.QSize) -> None: ...
        def setXZMeshResolution(self, resolution: PySide2.QtCore.QSize) -> None: ...
        def setYExtent(self, yExtent: float) -> None: ...
        def setYZMeshResolution(self, resolution: PySide2.QtCore.QSize) -> None: ...
        def setZExtent(self, zExtent: float) -> None: ...
        def xExtent(self) -> float: ...
        def xyMeshResolution(self) -> PySide2.QtCore.QSize: ...
        def xzMeshResolution(self) -> PySide2.QtCore.QSize: ...
        def yExtent(self) -> float: ...
        def yzMeshResolution(self) -> PySide2.QtCore.QSize: ...
        def zExtent(self) -> float: ...

    class QCylinderGeometry(PySide2.Qt3DRender.Qt3DRender.QGeometry):
        lengthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        radiusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        ringsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        slicesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., boundingVolumePositionAttribute: typing.Any = ..., boundingVolumePositionAttributeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QCylinderGeometry.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., indexAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., length: float = ..., lengthChanged: typing.Callable = ..., maxExtent: PySide2.QtGui.QVector3D = ..., maxExtentChanged: typing.Callable = ..., minExtent: PySide2.QtGui.QVector3D = ..., minExtentChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., normalAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., positionAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., radius: float = ..., radiusChanged: typing.Callable = ..., rings: int = ..., ringsChanged: typing.Callable = ..., slices: int = ..., slicesChanged: typing.Callable = ..., texCoordAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ...) -> None: ...
        def indexAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def length(self) -> float: ...
        def normalAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def positionAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def radius(self) -> float: ...
        def rings(self) -> int: ...
        def setLength(self, length: float) -> None: ...
        def setRadius(self, radius: float) -> None: ...
        def setRings(self, rings: int) -> None: ...
        def setSlices(self, slices: int) -> None: ...
        def slices(self) -> int: ...
        def texCoordAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def updateIndices(self) -> None: ...
        def updateVertices(self) -> None: ...

    class QCylinderMesh(PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer):
        lengthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        radiusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        ringsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        slicesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QCylinderMesh.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., firstInstance: int = ..., firstInstanceChanged: typing.Callable = ..., firstVertex: int = ..., firstVertexChanged: typing.Callable = ..., geometry: typing.Any = ..., geometryChanged: typing.Callable = ..., indexBufferByteOffset: int = ..., indexBufferByteOffsetChanged: typing.Callable = ..., indexOffset: int = ..., indexOffsetChanged: typing.Callable = ..., instanceCount: int = ..., instanceCountChanged: typing.Callable = ..., isShareable: bool = ..., length: float = ..., lengthChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., primitiveRestartEnabled: bool = ..., primitiveRestartEnabledChanged: typing.Callable = ..., primitiveType: Qt3DExtras.QCylinderMesh.PrimitiveType = ..., primitiveTypeChanged: typing.Callable = ..., radius: float = ..., radiusChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., restartIndexValue: int = ..., restartIndexValueChanged: typing.Callable = ..., rings: int = ..., ringsChanged: typing.Callable = ..., shareableChanged: typing.Callable = ..., slices: int = ..., slicesChanged: typing.Callable = ..., vertexCount: int = ..., vertexCountChanged: typing.Callable = ..., verticesPerPatch: int = ..., verticesPerPatchChanged: typing.Callable = ...) -> None: ...
        def length(self) -> float: ...
        def radius(self) -> float: ...
        def rings(self) -> int: ...
        def setFirstInstance(self, firstInstance: int) -> None: ...
        def setGeometry(self, geometry: PySide2.Qt3DRender.Qt3DRender.QGeometry) -> None: ...
        def setIndexOffset(self, indexOffset: int) -> None: ...
        def setInstanceCount(self, instanceCount: int) -> None: ...
        def setLength(self, length: float) -> None: ...
        def setPrimitiveRestartEnabled(self, enabled: bool) -> None: ...
        def setPrimitiveType(self, primitiveType: PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer.PrimitiveType) -> None: ...
        def setRadius(self, radius: float) -> None: ...
        def setRestartIndexValue(self, index: int) -> None: ...
        def setRings(self, rings: int) -> None: ...
        def setSlices(self, slices: int) -> None: ...
        def setVertexCount(self, vertexCount: int) -> None: ...
        def slices(self) -> int: ...

    class QDiffuseMapMaterial(PySide2.Qt3DRender.Qt3DRender.QMaterial):
        ambientChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        diffuseChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        shininessChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        specularChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        textureScaleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., ambient: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., ambientChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QDiffuseMapMaterial.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., diffuse: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture = ..., diffuseChanged: typing.Callable = ..., effect: typing.Any = ..., effectChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ..., shininess: float = ..., shininessChanged: typing.Callable = ..., specular: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., specularChanged: typing.Callable = ..., textureScale: float = ..., textureScaleChanged: typing.Callable = ...) -> None: ...
        def ambient(self) -> PySide2.QtGui.QColor: ...
        def diffuse(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture: ...
        def setAmbient(self, color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setDiffuse(self, diffuse: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture) -> None: ...
        def setShininess(self, shininess: float) -> None: ...
        def setSpecular(self, specular: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setTextureScale(self, textureScale: float) -> None: ...
        def shininess(self) -> float: ...
        def specular(self) -> PySide2.QtGui.QColor: ...
        def textureScale(self) -> float: ...

    class QDiffuseSpecularMapMaterial(PySide2.Qt3DRender.Qt3DRender.QMaterial):
        ambientChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        diffuseChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        shininessChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        specularChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        textureScaleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., ambient: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., ambientChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QDiffuseSpecularMapMaterial.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., diffuse: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture = ..., diffuseChanged: typing.Callable = ..., effect: typing.Any = ..., effectChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ..., shininess: float = ..., shininessChanged: typing.Callable = ..., specular: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture = ..., specularChanged: typing.Callable = ..., textureScale: float = ..., textureScaleChanged: typing.Callable = ...) -> None: ...
        def ambient(self) -> PySide2.QtGui.QColor: ...
        def diffuse(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture: ...
        def setAmbient(self, ambient: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setDiffuse(self, diffuse: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture) -> None: ...
        def setShininess(self, shininess: float) -> None: ...
        def setSpecular(self, specular: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture) -> None: ...
        def setTextureScale(self, textureScale: float) -> None: ...
        def shininess(self) -> float: ...
        def specular(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture: ...
        def textureScale(self) -> float: ...

    class QDiffuseSpecularMaterial(PySide2.Qt3DRender.Qt3DRender.QMaterial):
        alphaBlendingEnabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        ambientChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        diffuseChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        normalChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        shininessChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        specularChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        textureScaleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., alphaBlending: bool = ..., alphaBlendingEnabledChanged: typing.Callable = ..., ambient: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., ambientChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QDiffuseSpecularMaterial.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., diffuse: object = ..., diffuseChanged: typing.Callable = ..., effect: typing.Any = ..., effectChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., normal: object = ..., normalChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ..., shininess: float = ..., shininessChanged: typing.Callable = ..., specular: object = ..., specularChanged: typing.Callable = ..., textureScale: float = ..., textureScaleChanged: typing.Callable = ...) -> None: ...
        def ambient(self) -> PySide2.QtGui.QColor: ...
        def diffuse(self) -> typing.Any: ...
        def isAlphaBlendingEnabled(self) -> bool: ...
        def normal(self) -> typing.Any: ...
        def setAlphaBlendingEnabled(self, enabled: bool) -> None: ...
        def setAmbient(self, ambient: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setDiffuse(self, diffuse: typing.Any) -> None: ...
        def setNormal(self, normal: typing.Any) -> None: ...
        def setShininess(self, shininess: float) -> None: ...
        def setSpecular(self, specular: typing.Any) -> None: ...
        def setTextureScale(self, textureScale: float) -> None: ...
        def shininess(self) -> float: ...
        def specular(self) -> typing.Any: ...
        def textureScale(self) -> float: ...

    class QExtrudedTextGeometry(PySide2.Qt3DRender.Qt3DRender.QGeometry):
        depthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        fontChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        textChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., boundingVolumePositionAttribute: typing.Any = ..., boundingVolumePositionAttributeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QExtrudedTextGeometry.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., depthChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., extrusionLength: float = ..., font: PySide2.QtGui.QFont = ..., fontChanged: typing.Callable = ..., indexAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., maxExtent: PySide2.QtGui.QVector3D = ..., maxExtentChanged: typing.Callable = ..., minExtent: PySide2.QtGui.QVector3D = ..., minExtentChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., normalAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., positionAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., text: str = ..., textChanged: typing.Callable = ...) -> None: ...
        def extrusionLength(self) -> float: ...
        def font(self) -> PySide2.QtGui.QFont: ...
        def indexAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def normalAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def positionAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def setDepth(self, extrusionLength: float) -> None: ...
        def setFont(self, font: PySide2.QtGui.QFont) -> None: ...
        def setText(self, text: str) -> None: ...
        def text(self) -> str: ...

    class QExtrudedTextMesh(PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer):
        depthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        fontChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        textChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QExtrudedTextMesh.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., depth: float = ..., depthChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., firstInstance: int = ..., firstInstanceChanged: typing.Callable = ..., firstVertex: int = ..., firstVertexChanged: typing.Callable = ..., font: PySide2.QtGui.QFont = ..., fontChanged: typing.Callable = ..., geometry: typing.Any = ..., geometryChanged: typing.Callable = ..., indexBufferByteOffset: int = ..., indexBufferByteOffsetChanged: typing.Callable = ..., indexOffset: int = ..., indexOffsetChanged: typing.Callable = ..., instanceCount: int = ..., instanceCountChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., primitiveRestartEnabled: bool = ..., primitiveRestartEnabledChanged: typing.Callable = ..., primitiveType: Qt3DExtras.QExtrudedTextMesh.PrimitiveType = ..., primitiveTypeChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., restartIndexValue: int = ..., restartIndexValueChanged: typing.Callable = ..., shareableChanged: typing.Callable = ..., text: str = ..., textChanged: typing.Callable = ..., vertexCount: int = ..., vertexCountChanged: typing.Callable = ..., verticesPerPatch: int = ..., verticesPerPatchChanged: typing.Callable = ...) -> None: ...
        def depth(self) -> float: ...
        def font(self) -> PySide2.QtGui.QFont: ...
        def setDepth(self, depth: float) -> None: ...
        def setFont(self, font: PySide2.QtGui.QFont) -> None: ...
        def setText(self, text: str) -> None: ...
        def text(self) -> str: ...

    class QFirstPersonCameraController(Qt3DExtras.QAbstractCameraController):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., acceleration: float = ..., accelerationChanged: typing.Callable = ..., camera: typing.Any = ..., cameraChanged: typing.Callable = ..., deceleration: float = ..., decelerationChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QFirstPersonCameraController.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., linearSpeed: float = ..., linearSpeedChanged: typing.Callable = ..., lookSpeed: float = ..., lookSpeedChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...

    class QForwardRenderer(PySide2.Qt3DRender.Qt3DRender.QTechniqueFilter):
        buffersToClearChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        cameraChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        clearColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        externalRenderTargetSizeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        frustumCullingEnabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        gammaChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        showDebugOverlayChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        surfaceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        viewportRectChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., buffersToClear: typing.Any = ..., buffersToClearChanged: typing.Callable = ..., camera: PySide2.Qt3DCore.Qt3DCore.QEntity = ..., cameraChanged: typing.Callable = ..., clearColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., clearColorChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QForwardRenderer.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., externalRenderTargetSize: PySide2.QtCore.QSize = ..., externalRenderTargetSizeChanged: typing.Callable = ..., frustumCulling: bool = ..., frustumCullingEnabledChanged: typing.Callable = ..., gamma: float = ..., gammaChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., showDebugOverlay: bool = ..., showDebugOverlayChanged: typing.Callable = ..., surface: PySide2.QtCore.QObject = ..., surfaceChanged: typing.Callable = ..., viewportRect: PySide2.QtCore.QRectF = ..., viewportRectChanged: typing.Callable = ..., window: PySide2.QtCore.QObject = ...) -> None: ...
        def buffersToClear(self) -> PySide2.Qt3DRender.Qt3DRender.QClearBuffers.BufferType: ...
        def camera(self) -> PySide2.Qt3DCore.Qt3DCore.QEntity: ...
        def clearColor(self) -> PySide2.QtGui.QColor: ...
        def externalRenderTargetSize(self) -> PySide2.QtCore.QSize: ...
        def gamma(self) -> float: ...
        def isFrustumCullingEnabled(self) -> bool: ...
        def setBuffersToClear(self, arg__1: PySide2.Qt3DRender.Qt3DRender.QClearBuffers.BufferType) -> None: ...
        def setCamera(self, camera: PySide2.Qt3DCore.Qt3DCore.QEntity) -> None: ...
        def setClearColor(self, clearColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setExternalRenderTargetSize(self, size: PySide2.QtCore.QSize) -> None: ...
        def setFrustumCullingEnabled(self, enabled: bool) -> None: ...
        def setGamma(self, gamma: float) -> None: ...
        def setShowDebugOverlay(self, showDebugOverlay: bool) -> None: ...
        def setSurface(self, surface: PySide2.QtCore.QObject) -> None: ...
        def setViewportRect(self, viewportRect: PySide2.QtCore.QRectF) -> None: ...
        def showDebugOverlay(self) -> bool: ...
        def surface(self) -> PySide2.QtCore.QObject: ...
        def viewportRect(self) -> PySide2.QtCore.QRectF: ...

    class QGoochMaterial(PySide2.Qt3DRender.Qt3DRender.QMaterial):
        alphaChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        betaChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        coolChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        diffuseChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        shininessChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        specularChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        warmChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., alpha: float = ..., alphaChanged: typing.Callable = ..., beta: float = ..., betaChanged: typing.Callable = ..., cool: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., coolChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QGoochMaterial.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., diffuse: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., diffuseChanged: typing.Callable = ..., effect: typing.Any = ..., effectChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ..., shininess: float = ..., shininessChanged: typing.Callable = ..., specular: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., specularChanged: typing.Callable = ..., warm: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., warmChanged: typing.Callable = ...) -> None: ...
        def alpha(self) -> float: ...
        def beta(self) -> float: ...
        def cool(self) -> PySide2.QtGui.QColor: ...
        def diffuse(self) -> PySide2.QtGui.QColor: ...
        def setAlpha(self, alpha: float) -> None: ...
        def setBeta(self, beta: float) -> None: ...
        def setCool(self, cool: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setDiffuse(self, diffuse: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setShininess(self, shininess: float) -> None: ...
        def setSpecular(self, specular: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setWarm(self, warm: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def shininess(self) -> float: ...
        def specular(self) -> PySide2.QtGui.QColor: ...
        def warm(self) -> PySide2.QtGui.QColor: ...

    class QMetalRoughMaterial(PySide2.Qt3DRender.Qt3DRender.QMaterial):
        ambientOcclusionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        baseColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        metalnessChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        normalChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        roughnessChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        textureScaleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., ambientOcclusion: object = ..., ambientOcclusionChanged: typing.Callable = ..., baseColor: object = ..., baseColorChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QMetalRoughMaterial.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., effect: typing.Any = ..., effectChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., metalness: object = ..., metalnessChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., normal: object = ..., normalChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., roughness: object = ..., roughnessChanged: typing.Callable = ..., shareableChanged: typing.Callable = ..., textureScale: float = ..., textureScaleChanged: typing.Callable = ...) -> None: ...
        def ambientOcclusion(self) -> typing.Any: ...
        def baseColor(self) -> typing.Any: ...
        def metalness(self) -> typing.Any: ...
        def normal(self) -> typing.Any: ...
        def roughness(self) -> typing.Any: ...
        def setAmbientOcclusion(self, ambientOcclusion: typing.Any) -> None: ...
        def setBaseColor(self, baseColor: typing.Any) -> None: ...
        def setMetalness(self, metalness: typing.Any) -> None: ...
        def setNormal(self, normal: typing.Any) -> None: ...
        def setRoughness(self, roughness: typing.Any) -> None: ...
        def setTextureScale(self, textureScale: float) -> None: ...
        def textureScale(self) -> float: ...

    class QMorphPhongMaterial(PySide2.Qt3DRender.Qt3DRender.QMaterial):
        ambientChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        diffuseChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        interpolatorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        shininessChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        specularChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., ambient: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., ambientChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QMorphPhongMaterial.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., diffuse: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., diffuseChanged: typing.Callable = ..., effect: typing.Any = ..., effectChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., interpolator: float = ..., interpolatorChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ..., shininess: float = ..., shininessChanged: typing.Callable = ..., specular: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., specularChanged: typing.Callable = ...) -> None: ...
        def ambient(self) -> PySide2.QtGui.QColor: ...
        def diffuse(self) -> PySide2.QtGui.QColor: ...
        def interpolator(self) -> float: ...
        def setAmbient(self, ambient: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setDiffuse(self, diffuse: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setInterpolator(self, interpolator: float) -> None: ...
        def setShininess(self, shininess: float) -> None: ...
        def setSpecular(self, specular: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def shininess(self) -> float: ...
        def specular(self) -> PySide2.QtGui.QColor: ...

    class QNormalDiffuseMapAlphaMaterial(Qt3DExtras.QNormalDiffuseMapMaterial):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., ambient: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., ambientChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QNormalDiffuseMapAlphaMaterial.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., diffuse: typing.Any = ..., diffuseChanged: typing.Callable = ..., effect: typing.Any = ..., effectChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., normal: typing.Any = ..., normalChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ..., shininess: float = ..., shininessChanged: typing.Callable = ..., specular: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., specularChanged: typing.Callable = ..., textureScale: float = ..., textureScaleChanged: typing.Callable = ...) -> None: ...

    class QNormalDiffuseMapMaterial(PySide2.Qt3DRender.Qt3DRender.QMaterial):
        ambientChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        diffuseChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        normalChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        shininessChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        specularChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        textureScaleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., ambient: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., ambientChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QNormalDiffuseMapMaterial.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., diffuse: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture = ..., diffuseChanged: typing.Callable = ..., effect: typing.Any = ..., effectChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., normal: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture = ..., normalChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ..., shininess: float = ..., shininessChanged: typing.Callable = ..., specular: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., specularChanged: typing.Callable = ..., textureScale: float = ..., textureScaleChanged: typing.Callable = ...) -> None: ...
        def ambient(self) -> PySide2.QtGui.QColor: ...
        def diffuse(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture: ...
        def normal(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture: ...
        def setAmbient(self, ambient: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setDiffuse(self, diffuse: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture) -> None: ...
        def setNormal(self, normal: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture) -> None: ...
        def setShininess(self, shininess: float) -> None: ...
        def setSpecular(self, specular: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setTextureScale(self, textureScale: float) -> None: ...
        def shininess(self) -> float: ...
        def specular(self) -> PySide2.QtGui.QColor: ...
        def textureScale(self) -> float: ...

    class QNormalDiffuseSpecularMapMaterial(PySide2.Qt3DRender.Qt3DRender.QMaterial):
        ambientChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        diffuseChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        normalChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        shininessChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        specularChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        textureScaleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., ambient: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., ambientChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QNormalDiffuseSpecularMapMaterial.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., diffuse: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture = ..., diffuseChanged: typing.Callable = ..., effect: typing.Any = ..., effectChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., normal: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture = ..., normalChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ..., shininess: float = ..., shininessChanged: typing.Callable = ..., specular: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture = ..., specularChanged: typing.Callable = ..., textureScale: float = ..., textureScaleChanged: typing.Callable = ...) -> None: ...
        def ambient(self) -> PySide2.QtGui.QColor: ...
        def diffuse(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture: ...
        def normal(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture: ...
        def setAmbient(self, ambient: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setDiffuse(self, diffuse: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture) -> None: ...
        def setNormal(self, normal: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture) -> None: ...
        def setShininess(self, shininess: float) -> None: ...
        def setSpecular(self, specular: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture) -> None: ...
        def setTextureScale(self, textureScale: float) -> None: ...
        def shininess(self) -> float: ...
        def specular(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture: ...
        def textureScale(self) -> float: ...

    class QOrbitCameraController(Qt3DExtras.QAbstractCameraController):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        zoomInLimitChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., acceleration: float = ..., accelerationChanged: typing.Callable = ..., camera: typing.Any = ..., cameraChanged: typing.Callable = ..., deceleration: float = ..., decelerationChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QOrbitCameraController.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., linearSpeed: float = ..., linearSpeedChanged: typing.Callable = ..., lookSpeed: float = ..., lookSpeedChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., zoomInLimit: float = ..., zoomInLimitChanged: typing.Callable = ...) -> None: ...
        def setZoomInLimit(self, zoomInLimit: float) -> None: ...
        def zoomInLimit(self) -> float: ...

    class QPerVertexColorMaterial(PySide2.Qt3DRender.Qt3DRender.QMaterial):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QPerVertexColorMaterial.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., effect: typing.Any = ..., effectChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ...) -> None: ...

    class QPhongAlphaMaterial(PySide2.Qt3DRender.Qt3DRender.QMaterial):
        alphaChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        ambientChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        blendFunctionArgChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        destinationAlphaArgChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        destinationRgbArgChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        diffuseChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        shininessChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sourceAlphaArgChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sourceRgbArgChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        specularChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., alpha: float = ..., alphaChanged: typing.Callable = ..., ambient: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., ambientChanged: typing.Callable = ..., blendFunctionArg: typing.Any = ..., blendFunctionArgChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QPhongAlphaMaterial.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destinationAlphaArg: typing.Any = ..., destinationAlphaArgChanged: typing.Callable = ..., destinationRgbArg: typing.Any = ..., destinationRgbArgChanged: typing.Callable = ..., destroyed: typing.Callable = ..., diffuse: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., diffuseChanged: typing.Callable = ..., effect: typing.Any = ..., effectChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ..., shininess: float = ..., shininessChanged: typing.Callable = ..., sourceAlphaArg: typing.Any = ..., sourceAlphaArgChanged: typing.Callable = ..., sourceRgbArg: typing.Any = ..., sourceRgbArgChanged: typing.Callable = ..., specular: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., specularChanged: typing.Callable = ...) -> None: ...
        def alpha(self) -> float: ...
        def ambient(self) -> PySide2.QtGui.QColor: ...
        def blendFunctionArg(self) -> PySide2.Qt3DRender.Qt3DRender.QBlendEquation.BlendFunction: ...
        def destinationAlphaArg(self) -> PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending: ...
        def destinationRgbArg(self) -> PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending: ...
        def diffuse(self) -> PySide2.QtGui.QColor: ...
        def setAlpha(self, alpha: float) -> None: ...
        def setAmbient(self, ambient: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setBlendFunctionArg(self, blendFunctionArg: PySide2.Qt3DRender.Qt3DRender.QBlendEquation.BlendFunction) -> None: ...
        def setDestinationAlphaArg(self, destinationAlphaArg: PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending) -> None: ...
        def setDestinationRgbArg(self, destinationRgbArg: PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending) -> None: ...
        def setDiffuse(self, diffuse: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setShininess(self, shininess: float) -> None: ...
        def setSourceAlphaArg(self, sourceAlphaArg: PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending) -> None: ...
        def setSourceRgbArg(self, sourceRgbArg: PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending) -> None: ...
        def setSpecular(self, specular: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def shininess(self) -> float: ...
        def sourceAlphaArg(self) -> PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending: ...
        def sourceRgbArg(self) -> PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending: ...
        def specular(self) -> PySide2.QtGui.QColor: ...

    class QPhongMaterial(PySide2.Qt3DRender.Qt3DRender.QMaterial):
        ambientChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        diffuseChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        shininessChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        specularChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., ambient: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., ambientChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QPhongMaterial.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., diffuse: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., diffuseChanged: typing.Callable = ..., effect: typing.Any = ..., effectChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ..., shininess: float = ..., shininessChanged: typing.Callable = ..., specular: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., specularChanged: typing.Callable = ...) -> None: ...
        def ambient(self) -> PySide2.QtGui.QColor: ...
        def diffuse(self) -> PySide2.QtGui.QColor: ...
        def setAmbient(self, ambient: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setDiffuse(self, diffuse: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setShininess(self, shininess: float) -> None: ...
        def setSpecular(self, specular: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def shininess(self) -> float: ...
        def specular(self) -> PySide2.QtGui.QColor: ...

    class QPlaneGeometry(PySide2.Qt3DRender.Qt3DRender.QGeometry):
        heightChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        mirroredChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        resolutionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        widthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., boundingVolumePositionAttribute: typing.Any = ..., boundingVolumePositionAttributeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QPlaneGeometry.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., height: float = ..., heightChanged: typing.Callable = ..., indexAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., maxExtent: PySide2.QtGui.QVector3D = ..., maxExtentChanged: typing.Callable = ..., minExtent: PySide2.QtGui.QVector3D = ..., minExtentChanged: typing.Callable = ..., mirrored: bool = ..., mirroredChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., normalAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., positionAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., resolution: PySide2.QtCore.QSize = ..., resolutionChanged: typing.Callable = ..., tangentAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., texCoordAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., width: float = ..., widthChanged: typing.Callable = ...) -> None: ...
        def height(self) -> float: ...
        def indexAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def mirrored(self) -> bool: ...
        def normalAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def positionAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def resolution(self) -> PySide2.QtCore.QSize: ...
        def setHeight(self, height: float) -> None: ...
        def setMirrored(self, mirrored: bool) -> None: ...
        def setResolution(self, resolution: PySide2.QtCore.QSize) -> None: ...
        def setWidth(self, width: float) -> None: ...
        def tangentAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def texCoordAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def updateIndices(self) -> None: ...
        def updateVertices(self) -> None: ...
        def width(self) -> float: ...

    class QPlaneMesh(PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer):
        heightChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        meshResolutionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        mirroredChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        widthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QPlaneMesh.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., firstInstance: int = ..., firstInstanceChanged: typing.Callable = ..., firstVertex: int = ..., firstVertexChanged: typing.Callable = ..., geometry: typing.Any = ..., geometryChanged: typing.Callable = ..., height: float = ..., heightChanged: typing.Callable = ..., indexBufferByteOffset: int = ..., indexBufferByteOffsetChanged: typing.Callable = ..., indexOffset: int = ..., indexOffsetChanged: typing.Callable = ..., instanceCount: int = ..., instanceCountChanged: typing.Callable = ..., isShareable: bool = ..., meshResolution: PySide2.QtCore.QSize = ..., meshResolutionChanged: typing.Callable = ..., mirrored: bool = ..., mirroredChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., primitiveRestartEnabled: bool = ..., primitiveRestartEnabledChanged: typing.Callable = ..., primitiveType: Qt3DExtras.QPlaneMesh.PrimitiveType = ..., primitiveTypeChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., restartIndexValue: int = ..., restartIndexValueChanged: typing.Callable = ..., shareableChanged: typing.Callable = ..., vertexCount: int = ..., vertexCountChanged: typing.Callable = ..., verticesPerPatch: int = ..., verticesPerPatchChanged: typing.Callable = ..., width: float = ..., widthChanged: typing.Callable = ...) -> None: ...
        def height(self) -> float: ...
        def meshResolution(self) -> PySide2.QtCore.QSize: ...
        def mirrored(self) -> bool: ...
        def setFirstInstance(self, firstInstance: int) -> None: ...
        def setGeometry(self, geometry: PySide2.Qt3DRender.Qt3DRender.QGeometry) -> None: ...
        def setHeight(self, height: float) -> None: ...
        def setIndexOffset(self, indexOffset: int) -> None: ...
        def setInstanceCount(self, instanceCount: int) -> None: ...
        def setMeshResolution(self, resolution: PySide2.QtCore.QSize) -> None: ...
        def setMirrored(self, mirrored: bool) -> None: ...
        def setPrimitiveRestartEnabled(self, enabled: bool) -> None: ...
        def setPrimitiveType(self, primitiveType: PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer.PrimitiveType) -> None: ...
        def setRestartIndexValue(self, index: int) -> None: ...
        def setVertexCount(self, vertexCount: int) -> None: ...
        def setWidth(self, width: float) -> None: ...
        def width(self) -> float: ...

    class QSkyboxEntity(PySide2.Qt3DCore.Qt3DCore.QEntity):
        baseNameChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        extensionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        gammaCorrectEnabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., baseName: str = ..., baseNameChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QSkyboxEntity.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., extension: str = ..., extensionChanged: typing.Callable = ..., gammaCorrect: bool = ..., gammaCorrectEnabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def baseName(self) -> str: ...
        def extension(self) -> str: ...
        def isGammaCorrectEnabled(self) -> bool: ...
        def setBaseName(self, path: str) -> None: ...
        def setExtension(self, extension: str) -> None: ...
        def setGammaCorrectEnabled(self, enabled: bool) -> None: ...

    class QSphereGeometry(PySide2.Qt3DRender.Qt3DRender.QGeometry):
        generateTangentsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        radiusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        ringsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        slicesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., boundingVolumePositionAttribute: typing.Any = ..., boundingVolumePositionAttributeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QSphereGeometry.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., generateTangents: bool = ..., generateTangentsChanged: typing.Callable = ..., indexAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., maxExtent: PySide2.QtGui.QVector3D = ..., maxExtentChanged: typing.Callable = ..., minExtent: PySide2.QtGui.QVector3D = ..., minExtentChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., normalAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., positionAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., radius: float = ..., radiusChanged: typing.Callable = ..., rings: int = ..., ringsChanged: typing.Callable = ..., slices: int = ..., slicesChanged: typing.Callable = ..., tangentAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., texCoordAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ...) -> None: ...
        def generateTangents(self) -> bool: ...
        def indexAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def normalAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def positionAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def radius(self) -> float: ...
        def rings(self) -> int: ...
        def setGenerateTangents(self, gen: bool) -> None: ...
        def setRadius(self, radius: float) -> None: ...
        def setRings(self, rings: int) -> None: ...
        def setSlices(self, slices: int) -> None: ...
        def slices(self) -> int: ...
        def tangentAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def texCoordAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def updateIndices(self) -> None: ...
        def updateVertices(self) -> None: ...

    class QSphereMesh(PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer):
        generateTangentsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        radiusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        ringsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        slicesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QSphereMesh.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., firstInstance: int = ..., firstInstanceChanged: typing.Callable = ..., firstVertex: int = ..., firstVertexChanged: typing.Callable = ..., generateTangents: bool = ..., generateTangentsChanged: typing.Callable = ..., geometry: typing.Any = ..., geometryChanged: typing.Callable = ..., indexBufferByteOffset: int = ..., indexBufferByteOffsetChanged: typing.Callable = ..., indexOffset: int = ..., indexOffsetChanged: typing.Callable = ..., instanceCount: int = ..., instanceCountChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., primitiveRestartEnabled: bool = ..., primitiveRestartEnabledChanged: typing.Callable = ..., primitiveType: Qt3DExtras.QSphereMesh.PrimitiveType = ..., primitiveTypeChanged: typing.Callable = ..., radius: float = ..., radiusChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., restartIndexValue: int = ..., restartIndexValueChanged: typing.Callable = ..., rings: int = ..., ringsChanged: typing.Callable = ..., shareableChanged: typing.Callable = ..., slices: int = ..., slicesChanged: typing.Callable = ..., vertexCount: int = ..., vertexCountChanged: typing.Callable = ..., verticesPerPatch: int = ..., verticesPerPatchChanged: typing.Callable = ...) -> None: ...
        def generateTangents(self) -> bool: ...
        def radius(self) -> float: ...
        def rings(self) -> int: ...
        def setFirstInstance(self, firstInstance: int) -> None: ...
        def setGenerateTangents(self, gen: bool) -> None: ...
        def setGeometry(self, geometry: PySide2.Qt3DRender.Qt3DRender.QGeometry) -> None: ...
        def setIndexOffset(self, indexOffset: int) -> None: ...
        def setPrimitiveRestartEnabled(self, enabled: bool) -> None: ...
        def setPrimitiveType(self, primitiveType: PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer.PrimitiveType) -> None: ...
        def setRadius(self, radius: float) -> None: ...
        def setRestartIndexValue(self, index: int) -> None: ...
        def setRings(self, rings: int) -> None: ...
        def setSlices(self, slices: int) -> None: ...
        def setVertexCount(self, vertexCount: int) -> None: ...
        def slices(self) -> int: ...

    class QSpriteGrid(Qt3DExtras.QAbstractSpriteSheet):
        columnsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., columns: int = ..., columnsChanged: typing.Callable = ..., currentIndex: int = ..., currentIndexChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QSpriteGrid.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., rows: int = ..., rowsChanged: typing.Callable = ..., texture: typing.Any = ..., textureChanged: typing.Callable = ..., textureTransform: typing.Any = ..., textureTransformChanged: typing.Callable = ...) -> None: ...
        def columns(self) -> int: ...
        def rows(self) -> int: ...
        def setColumns(self, columns: int) -> None: ...
        def setRows(self, rows: int) -> None: ...

    class QSpriteSheet(Qt3DExtras.QAbstractSpriteSheet):
        spritesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., currentIndex: int = ..., currentIndexChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QSpriteSheet.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., sprites: typing.List[Qt3DExtras.QSpriteSheetItem] = ..., spritesChanged: typing.Callable = ..., texture: typing.Any = ..., textureChanged: typing.Callable = ..., textureTransform: typing.Any = ..., textureTransformChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def addSprite(self, x: int, y: int, width: int, height: int) -> Qt3DExtras.QSpriteSheetItem: ...
        @typing.overload
        def addSprite(self, sprite: Qt3DExtras.QSpriteSheetItem) -> None: ...
        def removeSprite(self, sprite: Qt3DExtras.QSpriteSheetItem) -> None: ...
        def setSprites(self, sprites: typing.List[Qt3DExtras.QSpriteSheetItem]) -> None: ...
        def sprites(self) -> typing.List[Qt3DExtras.QSpriteSheetItem]: ...

    class QSpriteSheetItem(PySide2.Qt3DCore.Qt3DCore.QNode):
        heightChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        widthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        xChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        yChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DExtras.QSpriteSheetItem.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., width: int = ..., widthChanged: typing.Callable = ..., x: int = ..., xChanged: typing.Callable = ..., y: int = ..., yChanged: typing.Callable = ...) -> None: ...
        def height(self) -> int: ...
        def setHeight(self, height: int) -> None: ...
        def setWidth(self, width: int) -> None: ...
        def setX(self, x: int) -> None: ...
        def setY(self, y: int) -> None: ...
        def width(self) -> int: ...
        def x(self) -> int: ...
        def y(self) -> int: ...

    class QText2DEntity(PySide2.Qt3DCore.Qt3DCore.QEntity):
        colorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        fontChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        heightChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        textChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        widthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., colorChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QText2DEntity.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., font: PySide2.QtGui.QFont = ..., fontChanged: typing.Callable = ..., height: float = ..., heightChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., text: str = ..., textChanged: typing.Callable = ..., width: float = ..., widthChanged: typing.Callable = ...) -> None: ...
        def color(self) -> PySide2.QtGui.QColor: ...
        def font(self) -> PySide2.QtGui.QFont: ...
        def height(self) -> float: ...
        def setColor(self, color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setFont(self, font: PySide2.QtGui.QFont) -> None: ...
        def setHeight(self, height: float) -> None: ...
        def setText(self, text: str) -> None: ...
        def setWidth(self, width: float) -> None: ...
        def text(self) -> str: ...
        def width(self) -> float: ...

    class QTextureMaterial(PySide2.Qt3DRender.Qt3DRender.QMaterial):
        alphaBlendingEnabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        textureChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        textureOffsetChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        textureTransformChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., alphaBlending: bool = ..., alphaBlendingEnabledChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QTextureMaterial.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., effect: typing.Any = ..., effectChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ..., texture: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture = ..., textureChanged: typing.Callable = ..., textureOffset: PySide2.QtGui.QVector2D = ..., textureOffsetChanged: typing.Callable = ..., textureTransform: PySide2.QtGui.QMatrix3x3 = ..., textureTransformChanged: typing.Callable = ...) -> None: ...
        def isAlphaBlendingEnabled(self) -> bool: ...
        def setAlphaBlendingEnabled(self, enabled: bool) -> None: ...
        def setTexture(self, texture: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture) -> None: ...
        def setTextureOffset(self, textureOffset: PySide2.QtGui.QVector2D) -> None: ...
        def setTextureTransform(self, matrix: PySide2.QtGui.QMatrix3x3) -> None: ...
        def texture(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture: ...
        def textureOffset(self) -> PySide2.QtGui.QVector2D: ...
        def textureTransform(self) -> PySide2.QtGui.QMatrix3x3: ...

    class QTorusGeometry(PySide2.Qt3DRender.Qt3DRender.QGeometry):
        minorRadiusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        radiusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        ringsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        slicesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., boundingVolumePositionAttribute: typing.Any = ..., boundingVolumePositionAttributeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QTorusGeometry.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., indexAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., maxExtent: PySide2.QtGui.QVector3D = ..., maxExtentChanged: typing.Callable = ..., minExtent: PySide2.QtGui.QVector3D = ..., minExtentChanged: typing.Callable = ..., minorRadius: float = ..., minorRadiusChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., normalAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., positionAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ..., radius: float = ..., radiusChanged: typing.Callable = ..., rings: int = ..., ringsChanged: typing.Callable = ..., slices: int = ..., slicesChanged: typing.Callable = ..., texCoordAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute = ...) -> None: ...
        def indexAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def minorRadius(self) -> float: ...
        def normalAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def positionAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def radius(self) -> float: ...
        def rings(self) -> int: ...
        def setMinorRadius(self, minorRadius: float) -> None: ...
        def setRadius(self, radius: float) -> None: ...
        def setRings(self, rings: int) -> None: ...
        def setSlices(self, slices: int) -> None: ...
        def slices(self) -> int: ...
        def texCoordAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def updateIndices(self) -> None: ...
        def updateVertices(self) -> None: ...

    class QTorusMesh(PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer):
        minorRadiusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        radiusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        ringsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        slicesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DExtras.QTorusMesh.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., firstInstance: int = ..., firstInstanceChanged: typing.Callable = ..., firstVertex: int = ..., firstVertexChanged: typing.Callable = ..., geometry: typing.Any = ..., geometryChanged: typing.Callable = ..., indexBufferByteOffset: int = ..., indexBufferByteOffsetChanged: typing.Callable = ..., indexOffset: int = ..., indexOffsetChanged: typing.Callable = ..., instanceCount: int = ..., instanceCountChanged: typing.Callable = ..., isShareable: bool = ..., minorRadius: float = ..., minorRadiusChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., primitiveRestartEnabled: bool = ..., primitiveRestartEnabledChanged: typing.Callable = ..., primitiveType: Qt3DExtras.QTorusMesh.PrimitiveType = ..., primitiveTypeChanged: typing.Callable = ..., radius: float = ..., radiusChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., restartIndexValue: int = ..., restartIndexValueChanged: typing.Callable = ..., rings: int = ..., ringsChanged: typing.Callable = ..., shareableChanged: typing.Callable = ..., slices: int = ..., slicesChanged: typing.Callable = ..., vertexCount: int = ..., vertexCountChanged: typing.Callable = ..., verticesPerPatch: int = ..., verticesPerPatchChanged: typing.Callable = ...) -> None: ...
        def minorRadius(self) -> float: ...
        def radius(self) -> float: ...
        def rings(self) -> int: ...
        def setFirstInstance(self, firstInstance: int) -> None: ...
        def setGeometry(self, geometry: PySide2.Qt3DRender.Qt3DRender.QGeometry) -> None: ...
        def setIndexOffset(self, indexOffset: int) -> None: ...
        def setInstanceCount(self, instanceCount: int) -> None: ...
        def setMinorRadius(self, minorRadius: float) -> None: ...
        def setPrimitiveRestartEnabled(self, enabled: bool) -> None: ...
        def setPrimitiveType(self, primitiveType: PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer.PrimitiveType) -> None: ...
        def setRadius(self, radius: float) -> None: ...
        def setRestartIndexValue(self, index: int) -> None: ...
        def setRings(self, rings: int) -> None: ...
        def setSlices(self, slices: int) -> None: ...
        def setVertexCount(self, vertexCount: int) -> None: ...
        def slices(self) -> int: ...

    class Qt3DWindow(PySide2.QtGui.QWindow):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, screen: PySide2.QtGui.QScreen | None = ..., arg__2: PySide2.Qt3DRender.Qt3DRender.API = ..., active: bool = ..., activeChanged: typing.Callable = ..., contentOrientation: PySide2.QtCore.Qt.ScreenOrientation = ..., contentOrientationChanged: typing.Callable = ..., destroyed: typing.Callable = ..., flags: PySide2.QtCore.Qt.WindowFlags | PySide2.QtCore.Qt.WindowType = ..., focusObjectChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., maximumHeight: int = ..., maximumHeightChanged: typing.Callable = ..., maximumWidth: int = ..., maximumWidthChanged: typing.Callable = ..., minimumHeight: int = ..., minimumHeightChanged: typing.Callable = ..., minimumWidth: int = ..., minimumWidthChanged: typing.Callable = ..., modality: PySide2.QtCore.Qt.WindowModality = ..., modalityChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., screenChanged: typing.Callable = ..., title: str = ..., transientParent: typing.Any = ..., transientParentChanged: typing.Callable = ..., visibility: Qt3DExtras.Qt3DWindow.Visibility = ..., visibilityChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: int = ..., widthChanged: typing.Callable = ..., windowStateChanged: typing.Callable = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., xChanged: typing.Callable = ..., y: int = ..., yChanged: typing.Callable = ...) -> None: ...
        def activeFrameGraph(self) -> PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode: ...
        def camera(self) -> PySide2.Qt3DRender.Qt3DRender.QCamera: ...
        def defaultFrameGraph(self) -> Qt3DExtras.QForwardRenderer: ...
        def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
        @typing.overload
        def registerAspect(self, name: str) -> None: ...
        @typing.overload
        def registerAspect(self, aspect: PySide2.Qt3DCore.Qt3DCore.QAbstractAspect) -> None: ...
        def renderSettings(self) -> PySide2.Qt3DRender.Qt3DRender.QRenderSettings: ...
        def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent) -> None: ...
        def setActiveFrameGraph(self, activeFrameGraph: PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode) -> None: ...
        def setRootEntity(self, root: PySide2.Qt3DCore.Qt3DCore.QEntity) -> None: ...
        def showEvent(self, e: PySide2.QtGui.QShowEvent) -> None: ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @staticmethod
    def setupWindowSurface(window: PySide2.QtGui.QWindow, arg__2: PySide2.Qt3DRender.Qt3DRender.API) -> None: ...
