import PySide2.Qt3DCore
import PySide2.QtCore
import PySide2.QtGui
import _typeshed
import collections
import shiboken2
import typing
T = typing.TypeVar('T')
import typing_extensions

class Qt3DRender(shiboken2.Object):
    class API:
        DirectX: typing.ClassVar[Qt3DRender.API] = ...
        Metal: typing.ClassVar[Qt3DRender.API] = ...
        Null: typing.ClassVar[Qt3DRender.API] = ...
        OpenGL: typing.ClassVar[Qt3DRender.API] = ...
        Vulkan: typing.ClassVar[Qt3DRender.API] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt3DRender.API: ...
        def __and__(self, other: typing.SupportsInt) -> Qt3DRender.API: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.API: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt3DRender.API: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.API: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.API: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.API: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.API: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.API: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.API: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.API: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.API: ...

    class PropertyReaderInterface(shiboken2.Object):
        def __init__(self) -> None: ...
        def readProperty(self, v: typing.Any) -> typing.Any: ...

    class QAbstractFunctor(shiboken2.Object):
        def __init__(self) -> None: ...
        def id(self) -> int: ...

    class QAbstractLight(PySide2.Qt3DCore.Qt3DCore.QComponent):
        class Type:
            DirectionalLight: typing.ClassVar[Qt3DRender.QAbstractLight.Type] = ...
            PointLight: typing.ClassVar[Qt3DRender.QAbstractLight.Type] = ...
            SpotLight: typing.ClassVar[Qt3DRender.QAbstractLight.Type] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractLight.Type: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractLight.Type: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractLight.Type: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractLight.Type: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractLight.Type: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractLight.Type: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractLight.Type: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractLight.Type: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractLight.Type: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractLight.Type: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractLight.Type: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractLight.Type: ...
        DirectionalLight: typing.ClassVar[Qt3DRender.QAbstractLight.Type] = ...
        PointLight: typing.ClassVar[Qt3DRender.QAbstractLight.Type] = ...
        SpotLight: typing.ClassVar[Qt3DRender.QAbstractLight.Type] = ...
        colorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        intensityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @classmethod
        def __init__(cls, *args, addedToEntity: typing.Callable = ..., color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., colorChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QAbstractLight.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., intensity: float = ..., intensityChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parent: typing.Any = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ..., type: Qt3DRender.QAbstractLight.Type = ..., **kwargs) -> None: ...
        def color(self) -> PySide2.QtGui.QColor: ...
        def intensity(self) -> float: ...
        def setColor(self, color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setIntensity(self, intensity: float) -> None: ...
        def type(self) -> Qt3DRender.QAbstractLight.Type: ...

    class QAbstractRayCaster(PySide2.Qt3DCore.Qt3DCore.QComponent):
        class FilterMode:
            AcceptAllMatchingLayers: typing.ClassVar[Qt3DRender.QAbstractRayCaster.FilterMode] = ...
            AcceptAnyMatchingLayers: typing.ClassVar[Qt3DRender.QAbstractRayCaster.FilterMode] = ...
            DiscardAllMatchingLayers: typing.ClassVar[Qt3DRender.QAbstractRayCaster.FilterMode] = ...
            DiscardAnyMatchingLayers: typing.ClassVar[Qt3DRender.QAbstractRayCaster.FilterMode] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractRayCaster.FilterMode: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractRayCaster.FilterMode: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractRayCaster.FilterMode: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractRayCaster.FilterMode: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractRayCaster.FilterMode: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractRayCaster.FilterMode: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractRayCaster.FilterMode: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractRayCaster.FilterMode: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractRayCaster.FilterMode: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractRayCaster.FilterMode: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractRayCaster.FilterMode: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractRayCaster.FilterMode: ...

        class RunMode:
            Continuous: typing.ClassVar[Qt3DRender.QAbstractRayCaster.RunMode] = ...
            SingleShot: typing.ClassVar[Qt3DRender.QAbstractRayCaster.RunMode] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractRayCaster.RunMode: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractRayCaster.RunMode: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractRayCaster.RunMode: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractRayCaster.RunMode: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractRayCaster.RunMode: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractRayCaster.RunMode: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractRayCaster.RunMode: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractRayCaster.RunMode: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractRayCaster.RunMode: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractRayCaster.RunMode: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractRayCaster.RunMode: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractRayCaster.RunMode: ...
        AcceptAllMatchingLayers: typing.ClassVar[Qt3DRender.QAbstractRayCaster.FilterMode] = ...
        AcceptAnyMatchingLayers: typing.ClassVar[Qt3DRender.QAbstractRayCaster.FilterMode] = ...
        Continuous: typing.ClassVar[Qt3DRender.QAbstractRayCaster.RunMode] = ...
        DiscardAllMatchingLayers: typing.ClassVar[Qt3DRender.QAbstractRayCaster.FilterMode] = ...
        DiscardAnyMatchingLayers: typing.ClassVar[Qt3DRender.QAbstractRayCaster.FilterMode] = ...
        SingleShot: typing.ClassVar[Qt3DRender.QAbstractRayCaster.RunMode] = ...
        filterModeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        hitsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        runModeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QAbstractRayCaster.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., filterMode: Qt3DRender.QAbstractRayCaster.FilterMode = ..., filterModeChanged: typing.Callable = ..., hits: typing.List[Qt3DRender.QRayCasterHit] = ..., hitsChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., runMode: Qt3DRender.QAbstractRayCaster.RunMode = ..., runModeChanged: typing.Callable = ..., shareableChanged: typing.Callable = ...) -> None: ...
        def addLayer(self, layer: Qt3DRender.QLayer) -> None: ...
        def filterMode(self) -> Qt3DRender.QAbstractRayCaster.FilterMode: ...
        def hits(self) -> typing.List[Qt3DRender.QRayCasterHit]: ...
        def layers(self) -> typing.List[Qt3DRender.QLayer]: ...
        def removeLayer(self, layer: Qt3DRender.QLayer) -> None: ...
        def runMode(self) -> Qt3DRender.QAbstractRayCaster.RunMode: ...
        def setFilterMode(self, filterMode: Qt3DRender.QAbstractRayCaster.FilterMode) -> None: ...
        def setRunMode(self, runMode: Qt3DRender.QAbstractRayCaster.RunMode) -> None: ...

    class QAbstractTexture(PySide2.Qt3DCore.Qt3DCore.QNode):
        class ComparisonFunction:
            CommpareNotEqual: typing.ClassVar[Qt3DRender.QAbstractTexture.ComparisonFunction] = ...
            CompareAlways: typing.ClassVar[Qt3DRender.QAbstractTexture.ComparisonFunction] = ...
            CompareEqual: typing.ClassVar[Qt3DRender.QAbstractTexture.ComparisonFunction] = ...
            CompareGreater: typing.ClassVar[Qt3DRender.QAbstractTexture.ComparisonFunction] = ...
            CompareGreaterEqual: typing.ClassVar[Qt3DRender.QAbstractTexture.ComparisonFunction] = ...
            CompareLess: typing.ClassVar[Qt3DRender.QAbstractTexture.ComparisonFunction] = ...
            CompareLessEqual: typing.ClassVar[Qt3DRender.QAbstractTexture.ComparisonFunction] = ...
            CompareNever: typing.ClassVar[Qt3DRender.QAbstractTexture.ComparisonFunction] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.ComparisonFunction: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.ComparisonFunction: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.ComparisonFunction: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.ComparisonFunction: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.ComparisonFunction: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.ComparisonFunction: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.ComparisonFunction: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.ComparisonFunction: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.ComparisonFunction: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.ComparisonFunction: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.ComparisonFunction: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.ComparisonFunction: ...

        class ComparisonMode:
            CompareNone: typing.ClassVar[Qt3DRender.QAbstractTexture.ComparisonMode] = ...
            CompareRefToTexture: typing.ClassVar[Qt3DRender.QAbstractTexture.ComparisonMode] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.ComparisonMode: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.ComparisonMode: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.ComparisonMode: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.ComparisonMode: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.ComparisonMode: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.ComparisonMode: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.ComparisonMode: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.ComparisonMode: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.ComparisonMode: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.ComparisonMode: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.ComparisonMode: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.ComparisonMode: ...

        class CubeMapFace:
            AllFaces: typing.ClassVar[Qt3DRender.QAbstractTexture.CubeMapFace] = ...
            CubeMapNegativeX: typing.ClassVar[Qt3DRender.QAbstractTexture.CubeMapFace] = ...
            CubeMapNegativeY: typing.ClassVar[Qt3DRender.QAbstractTexture.CubeMapFace] = ...
            CubeMapNegativeZ: typing.ClassVar[Qt3DRender.QAbstractTexture.CubeMapFace] = ...
            CubeMapPositiveX: typing.ClassVar[Qt3DRender.QAbstractTexture.CubeMapFace] = ...
            CubeMapPositiveY: typing.ClassVar[Qt3DRender.QAbstractTexture.CubeMapFace] = ...
            CubeMapPositiveZ: typing.ClassVar[Qt3DRender.QAbstractTexture.CubeMapFace] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.CubeMapFace: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.CubeMapFace: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.CubeMapFace: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.CubeMapFace: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.CubeMapFace: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.CubeMapFace: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.CubeMapFace: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.CubeMapFace: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.CubeMapFace: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.CubeMapFace: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.CubeMapFace: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.CubeMapFace: ...

        class Filter:
            Linear: typing.ClassVar[Qt3DRender.QAbstractTexture.Filter] = ...
            LinearMipMapLinear: typing.ClassVar[Qt3DRender.QAbstractTexture.Filter] = ...
            LinearMipMapNearest: typing.ClassVar[Qt3DRender.QAbstractTexture.Filter] = ...
            Nearest: typing.ClassVar[Qt3DRender.QAbstractTexture.Filter] = ...
            NearestMipMapLinear: typing.ClassVar[Qt3DRender.QAbstractTexture.Filter] = ...
            NearestMipMapNearest: typing.ClassVar[Qt3DRender.QAbstractTexture.Filter] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Filter: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Filter: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Filter: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Filter: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Filter: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Filter: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Filter: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Filter: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Filter: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Filter: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Filter: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Filter: ...

        class HandleType:
            NoHandle: typing.ClassVar[Qt3DRender.QAbstractTexture.HandleType] = ...
            OpenGLTextureId: typing.ClassVar[Qt3DRender.QAbstractTexture.HandleType] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.HandleType: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.HandleType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.HandleType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.HandleType: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.HandleType: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.HandleType: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.HandleType: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.HandleType: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.HandleType: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.HandleType: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.HandleType: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.HandleType: ...

        class Status:
            Error: typing.ClassVar[Qt3DRender.QAbstractTexture.Status] = ...
            Loading: typing.ClassVar[Qt3DRender.QAbstractTexture.Status] = ...
            None_: typing.ClassVar[Qt3DRender.QAbstractTexture.Status] = ...
            Ready: typing.ClassVar[Qt3DRender.QAbstractTexture.Status] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Status: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Status: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Status: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Status: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Status: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Status: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Status: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Status: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Status: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Status: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Status: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Status: ...

        class Target:
            Target1D: typing.ClassVar[Qt3DRender.QAbstractTexture.Target] = ...
            Target1DArray: typing.ClassVar[Qt3DRender.QAbstractTexture.Target] = ...
            Target2D: typing.ClassVar[Qt3DRender.QAbstractTexture.Target] = ...
            Target2DArray: typing.ClassVar[Qt3DRender.QAbstractTexture.Target] = ...
            Target2DMultisample: typing.ClassVar[Qt3DRender.QAbstractTexture.Target] = ...
            Target2DMultisampleArray: typing.ClassVar[Qt3DRender.QAbstractTexture.Target] = ...
            Target3D: typing.ClassVar[Qt3DRender.QAbstractTexture.Target] = ...
            TargetAutomatic: typing.ClassVar[Qt3DRender.QAbstractTexture.Target] = ...
            TargetBuffer: typing.ClassVar[Qt3DRender.QAbstractTexture.Target] = ...
            TargetCubeMap: typing.ClassVar[Qt3DRender.QAbstractTexture.Target] = ...
            TargetCubeMapArray: typing.ClassVar[Qt3DRender.QAbstractTexture.Target] = ...
            TargetRectangle: typing.ClassVar[Qt3DRender.QAbstractTexture.Target] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Target: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Target: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Target: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Target: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Target: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Target: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Target: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Target: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Target: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Target: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Target: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.Target: ...

        class TextureFormat:
            AlphaFormat: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            Automatic: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            D16: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            D24: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            D24S8: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            D32: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            D32F: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            D32FS8X24: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            DepthFormat: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            LuminanceAlphaFormat: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            LuminanceFormat: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            NoFormat: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            R11_EAC_SNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            R11_EAC_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            R16F: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            R16I: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            R16U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            R16_SNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            R16_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            R32F: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            R32I: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            R32U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            R5G6B5: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            R8I: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            R8U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            R8_SNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            R8_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RG11B10F: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RG11_EAC_SNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RG11_EAC_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RG16F: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RG16I: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RG16U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RG16_SNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RG16_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RG32F: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RG32I: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RG32U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RG3B2: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RG8I: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RG8U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RG8_SNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RG8_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGB10A2: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGB10A2U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGB16F: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGB16I: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGB16U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGB16_SNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGB16_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGB32F: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGB32I: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGB32U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGB5A1: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGB8I: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGB8U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGB8_ETC1: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGB8_ETC2: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGB8_PunchThrough_Alpha1_ETC2: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGB8_SNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGB8_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGB9E5: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGBA16F: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGBA16I: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGBA16U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGBA16_SNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGBA16_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGBA32F: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGBA32I: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGBA32U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGBA4: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGBA8I: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGBA8U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGBA8_ETC2_EAC: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGBA8_SNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGBA8_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGBAFormat: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGBA_DXT1: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGBA_DXT3: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGBA_DXT5: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGBFormat: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGB_BP_SIGNED_FLOAT: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGB_BP_UNSIGNED_FLOAT: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGB_BP_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RGB_DXT1: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RG_ATI2N_SNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            RG_ATI2N_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            R_ATI1N_SNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            R_ATI1N_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            SRGB8: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            SRGB8_Alpha8: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            SRGB8_Alpha8_ETC2_EAC: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            SRGB8_ETC2: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            SRGB8_PunchThrough_Alpha1_ETC2: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            SRGB_Alpha_DXT1: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            SRGB_Alpha_DXT3: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            SRGB_Alpha_DXT5: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            SRGB_BP_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            SRGB_DXT1: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.TextureFormat: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.TextureFormat: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.TextureFormat: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.TextureFormat: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.TextureFormat: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.TextureFormat: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.TextureFormat: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.TextureFormat: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.TextureFormat: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.TextureFormat: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.TextureFormat: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QAbstractTexture.TextureFormat: ...
        AllFaces: typing.ClassVar[Qt3DRender.QAbstractTexture.CubeMapFace] = ...
        AlphaFormat: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        Automatic: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        CommpareNotEqual: typing.ClassVar[Qt3DRender.QAbstractTexture.ComparisonFunction] = ...
        CompareAlways: typing.ClassVar[Qt3DRender.QAbstractTexture.ComparisonFunction] = ...
        CompareEqual: typing.ClassVar[Qt3DRender.QAbstractTexture.ComparisonFunction] = ...
        CompareGreater: typing.ClassVar[Qt3DRender.QAbstractTexture.ComparisonFunction] = ...
        CompareGreaterEqual: typing.ClassVar[Qt3DRender.QAbstractTexture.ComparisonFunction] = ...
        CompareLess: typing.ClassVar[Qt3DRender.QAbstractTexture.ComparisonFunction] = ...
        CompareLessEqual: typing.ClassVar[Qt3DRender.QAbstractTexture.ComparisonFunction] = ...
        CompareNever: typing.ClassVar[Qt3DRender.QAbstractTexture.ComparisonFunction] = ...
        CompareNone: typing.ClassVar[Qt3DRender.QAbstractTexture.ComparisonMode] = ...
        CompareRefToTexture: typing.ClassVar[Qt3DRender.QAbstractTexture.ComparisonMode] = ...
        CubeMapNegativeX: typing.ClassVar[Qt3DRender.QAbstractTexture.CubeMapFace] = ...
        CubeMapNegativeY: typing.ClassVar[Qt3DRender.QAbstractTexture.CubeMapFace] = ...
        CubeMapNegativeZ: typing.ClassVar[Qt3DRender.QAbstractTexture.CubeMapFace] = ...
        CubeMapPositiveX: typing.ClassVar[Qt3DRender.QAbstractTexture.CubeMapFace] = ...
        CubeMapPositiveY: typing.ClassVar[Qt3DRender.QAbstractTexture.CubeMapFace] = ...
        CubeMapPositiveZ: typing.ClassVar[Qt3DRender.QAbstractTexture.CubeMapFace] = ...
        D16: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        D24: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        D24S8: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        D32: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        D32F: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        D32FS8X24: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        DepthFormat: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        Error: typing.ClassVar[Qt3DRender.QAbstractTexture.Status] = ...
        Linear: typing.ClassVar[Qt3DRender.QAbstractTexture.Filter] = ...
        LinearMipMapLinear: typing.ClassVar[Qt3DRender.QAbstractTexture.Filter] = ...
        LinearMipMapNearest: typing.ClassVar[Qt3DRender.QAbstractTexture.Filter] = ...
        Loading: typing.ClassVar[Qt3DRender.QAbstractTexture.Status] = ...
        LuminanceAlphaFormat: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        LuminanceFormat: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        Nearest: typing.ClassVar[Qt3DRender.QAbstractTexture.Filter] = ...
        NearestMipMapLinear: typing.ClassVar[Qt3DRender.QAbstractTexture.Filter] = ...
        NearestMipMapNearest: typing.ClassVar[Qt3DRender.QAbstractTexture.Filter] = ...
        NoFormat: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        NoHandle: typing.ClassVar[Qt3DRender.QAbstractTexture.HandleType] = ...
        None_: typing.ClassVar[Qt3DRender.QAbstractTexture.Status] = ...
        OpenGLTextureId: typing.ClassVar[Qt3DRender.QAbstractTexture.HandleType] = ...
        R11_EAC_SNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        R11_EAC_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        R16F: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        R16I: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        R16U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        R16_SNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        R16_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        R32F: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        R32I: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        R32U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        R5G6B5: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        R8I: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        R8U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        R8_SNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        R8_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RG11B10F: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RG11_EAC_SNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RG11_EAC_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RG16F: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RG16I: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RG16U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RG16_SNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RG16_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RG32F: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RG32I: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RG32U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RG3B2: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RG8I: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RG8U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RG8_SNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RG8_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGB10A2: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGB10A2U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGB16F: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGB16I: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGB16U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGB16_SNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGB16_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGB32F: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGB32I: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGB32U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGB5A1: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGB8I: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGB8U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGB8_ETC1: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGB8_ETC2: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGB8_PunchThrough_Alpha1_ETC2: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGB8_SNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGB8_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGB9E5: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGBA16F: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGBA16I: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGBA16U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGBA16_SNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGBA16_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGBA32F: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGBA32I: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGBA32U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGBA4: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGBA8I: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGBA8U: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGBA8_ETC2_EAC: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGBA8_SNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGBA8_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGBAFormat: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGBA_DXT1: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGBA_DXT3: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGBA_DXT5: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGBFormat: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGB_BP_SIGNED_FLOAT: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGB_BP_UNSIGNED_FLOAT: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGB_BP_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RGB_DXT1: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RG_ATI2N_SNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        RG_ATI2N_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        R_ATI1N_SNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        R_ATI1N_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        Ready: typing.ClassVar[Qt3DRender.QAbstractTexture.Status] = ...
        SRGB8: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        SRGB8_Alpha8: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        SRGB8_Alpha8_ETC2_EAC: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        SRGB8_ETC2: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        SRGB8_PunchThrough_Alpha1_ETC2: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        SRGB_Alpha_DXT1: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        SRGB_Alpha_DXT3: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        SRGB_Alpha_DXT5: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        SRGB_BP_UNorm: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        SRGB_DXT1: typing.ClassVar[Qt3DRender.QAbstractTexture.TextureFormat] = ...
        Target1D: typing.ClassVar[Qt3DRender.QAbstractTexture.Target] = ...
        Target1DArray: typing.ClassVar[Qt3DRender.QAbstractTexture.Target] = ...
        Target2D: typing.ClassVar[Qt3DRender.QAbstractTexture.Target] = ...
        Target2DArray: typing.ClassVar[Qt3DRender.QAbstractTexture.Target] = ...
        Target2DMultisample: typing.ClassVar[Qt3DRender.QAbstractTexture.Target] = ...
        Target2DMultisampleArray: typing.ClassVar[Qt3DRender.QAbstractTexture.Target] = ...
        Target3D: typing.ClassVar[Qt3DRender.QAbstractTexture.Target] = ...
        TargetAutomatic: typing.ClassVar[Qt3DRender.QAbstractTexture.Target] = ...
        TargetBuffer: typing.ClassVar[Qt3DRender.QAbstractTexture.Target] = ...
        TargetCubeMap: typing.ClassVar[Qt3DRender.QAbstractTexture.Target] = ...
        TargetCubeMapArray: typing.ClassVar[Qt3DRender.QAbstractTexture.Target] = ...
        TargetRectangle: typing.ClassVar[Qt3DRender.QAbstractTexture.Target] = ...
        comparisonFunctionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        comparisonModeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        depthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        formatChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        generateMipMapsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        handleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        handleTypeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        heightChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        layersChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        magnificationFilterChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        maximumAnisotropyChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        minificationFilterChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        samplesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        statusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        widthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @typing.overload
        def __init__(self, target: Qt3DRender.QAbstractTexture.Target, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., comparisonFunction: Qt3DRender.QAbstractTexture.ComparisonFunction = ..., comparisonFunctionChanged: typing.Callable = ..., comparisonMode: Qt3DRender.QAbstractTexture.ComparisonMode = ..., comparisonModeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QAbstractTexture.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., depth: int = ..., depthChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., format: Qt3DRender.QAbstractTexture.TextureFormat = ..., formatChanged: typing.Callable = ..., generateMipMaps: bool = ..., generateMipMapsChanged: typing.Callable = ..., handle: object = ..., handleChanged: typing.Callable = ..., handleType: Qt3DRender.QAbstractTexture.HandleType = ..., handleTypeChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., layers: int = ..., layersChanged: typing.Callable = ..., magnificationFilter: Qt3DRender.QAbstractTexture.Filter = ..., magnificationFilterChanged: typing.Callable = ..., maximumAnisotropy: float = ..., maximumAnisotropyChanged: typing.Callable = ..., minificationFilter: Qt3DRender.QAbstractTexture.Filter = ..., minificationFilterChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., samples: int = ..., samplesChanged: typing.Callable = ..., status: Qt3DRender.QAbstractTexture.Status = ..., statusChanged: typing.Callable = ..., width: int = ..., widthChanged: typing.Callable = ..., wrapMode: Qt3DRender.QTextureWrapMode = ...) -> None: ...
        @typing.overload
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., comparisonFunction: Qt3DRender.QAbstractTexture.ComparisonFunction = ..., comparisonFunctionChanged: typing.Callable = ..., comparisonMode: Qt3DRender.QAbstractTexture.ComparisonMode = ..., comparisonModeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QAbstractTexture.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., depth: int = ..., depthChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., format: Qt3DRender.QAbstractTexture.TextureFormat = ..., formatChanged: typing.Callable = ..., generateMipMaps: bool = ..., generateMipMapsChanged: typing.Callable = ..., handle: object = ..., handleChanged: typing.Callable = ..., handleType: Qt3DRender.QAbstractTexture.HandleType = ..., handleTypeChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., layers: int = ..., layersChanged: typing.Callable = ..., magnificationFilter: Qt3DRender.QAbstractTexture.Filter = ..., magnificationFilterChanged: typing.Callable = ..., maximumAnisotropy: float = ..., maximumAnisotropyChanged: typing.Callable = ..., minificationFilter: Qt3DRender.QAbstractTexture.Filter = ..., minificationFilterChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., samples: int = ..., samplesChanged: typing.Callable = ..., status: Qt3DRender.QAbstractTexture.Status = ..., statusChanged: typing.Callable = ..., target: Qt3DRender.QAbstractTexture.Target = ..., width: int = ..., widthChanged: typing.Callable = ..., wrapMode: Qt3DRender.QTextureWrapMode = ...) -> None: ...
        def addTextureImage(self, textureImage: Qt3DRender.QAbstractTextureImage) -> None: ...
        def comparisonFunction(self) -> Qt3DRender.QAbstractTexture.ComparisonFunction: ...
        def comparisonMode(self) -> Qt3DRender.QAbstractTexture.ComparisonMode: ...
        def depth(self) -> int: ...
        def format(self) -> Qt3DRender.QAbstractTexture.TextureFormat: ...
        def generateMipMaps(self) -> bool: ...
        def handle(self) -> typing.Any: ...
        def handleType(self) -> Qt3DRender.QAbstractTexture.HandleType: ...
        def height(self) -> int: ...
        def layers(self) -> int: ...
        def magnificationFilter(self) -> Qt3DRender.QAbstractTexture.Filter: ...
        def maximumAnisotropy(self) -> float: ...
        def minificationFilter(self) -> Qt3DRender.QAbstractTexture.Filter: ...
        def removeTextureImage(self, textureImage: Qt3DRender.QAbstractTextureImage) -> None: ...
        def samples(self) -> int: ...
        def setComparisonFunction(self, function: Qt3DRender.QAbstractTexture.ComparisonFunction) -> None: ...
        def setComparisonMode(self, mode: Qt3DRender.QAbstractTexture.ComparisonMode) -> None: ...
        def setDepth(self, depth: int) -> None: ...
        def setFormat(self, format: Qt3DRender.QAbstractTexture.TextureFormat) -> None: ...
        def setGenerateMipMaps(self, gen: bool) -> None: ...
        def setHandle(self, handle: typing.Any) -> None: ...
        def setHandleType(self, type: Qt3DRender.QAbstractTexture.HandleType) -> None: ...
        def setHeight(self, height: int) -> None: ...
        def setLayers(self, layers: int) -> None: ...
        def setMagnificationFilter(self, f: Qt3DRender.QAbstractTexture.Filter) -> None: ...
        def setMaximumAnisotropy(self, anisotropy: float) -> None: ...
        def setMinificationFilter(self, f: Qt3DRender.QAbstractTexture.Filter) -> None: ...
        def setSamples(self, samples: int) -> None: ...
        def setSize(self, width: int, height: int = ..., depth: int = ...) -> None: ...
        def setStatus(self, status: Qt3DRender.QAbstractTexture.Status) -> None: ...
        def setWidth(self, width: int) -> None: ...
        def setWrapMode(self, wrapMode: Qt3DRender.QTextureWrapMode) -> None: ...
        def status(self) -> Qt3DRender.QAbstractTexture.Status: ...
        def target(self) -> Qt3DRender.QAbstractTexture.Target: ...
        def textureImages(self) -> typing.List[Qt3DRender.QAbstractTextureImage]: ...
        def width(self) -> int: ...
        def wrapMode(self) -> Qt3DRender.QTextureWrapMode: ...

    class QAbstractTextureImage(PySide2.Qt3DCore.Qt3DCore.QNode):
        faceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        layerChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        mipLevelChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @classmethod
        def __init__(cls, *args, defaultPropertyTrackingMode: Qt3DRender.QAbstractTextureImage.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., face: typing.Any = ..., faceChanged: typing.Callable = ..., layer: int = ..., layerChanged: typing.Callable = ..., mipLevel: int = ..., mipLevelChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parent: typing.Any = ..., parentChanged: typing.Callable = ..., **kwargs) -> None: ...
        def face(self) -> Qt3DRender.QAbstractTexture.CubeMapFace: ...
        def layer(self) -> int: ...
        def mipLevel(self) -> int: ...
        def notifyDataGeneratorChanged(self) -> None: ...
        def setFace(self, face: Qt3DRender.QAbstractTexture.CubeMapFace) -> None: ...
        def setLayer(self, layer: int) -> None: ...
        def setMipLevel(self, level: int) -> None: ...

    class QAlphaCoverage(Qt3DRender.QRenderState):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QAlphaCoverage.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...

    class QAlphaTest(Qt3DRender.QRenderState):
        class AlphaFunction:
            Always: typing.ClassVar[Qt3DRender.QAlphaTest.AlphaFunction] = ...
            Equal: typing.ClassVar[Qt3DRender.QAlphaTest.AlphaFunction] = ...
            Greater: typing.ClassVar[Qt3DRender.QAlphaTest.AlphaFunction] = ...
            GreaterOrEqual: typing.ClassVar[Qt3DRender.QAlphaTest.AlphaFunction] = ...
            Less: typing.ClassVar[Qt3DRender.QAlphaTest.AlphaFunction] = ...
            LessOrEqual: typing.ClassVar[Qt3DRender.QAlphaTest.AlphaFunction] = ...
            Never: typing.ClassVar[Qt3DRender.QAlphaTest.AlphaFunction] = ...
            NotEqual: typing.ClassVar[Qt3DRender.QAlphaTest.AlphaFunction] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QAlphaTest.AlphaFunction: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QAlphaTest.AlphaFunction: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QAlphaTest.AlphaFunction: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QAlphaTest.AlphaFunction: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QAlphaTest.AlphaFunction: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QAlphaTest.AlphaFunction: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QAlphaTest.AlphaFunction: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QAlphaTest.AlphaFunction: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QAlphaTest.AlphaFunction: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QAlphaTest.AlphaFunction: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QAlphaTest.AlphaFunction: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QAlphaTest.AlphaFunction: ...
        Always: typing.ClassVar[Qt3DRender.QAlphaTest.AlphaFunction] = ...
        Equal: typing.ClassVar[Qt3DRender.QAlphaTest.AlphaFunction] = ...
        Greater: typing.ClassVar[Qt3DRender.QAlphaTest.AlphaFunction] = ...
        GreaterOrEqual: typing.ClassVar[Qt3DRender.QAlphaTest.AlphaFunction] = ...
        Less: typing.ClassVar[Qt3DRender.QAlphaTest.AlphaFunction] = ...
        LessOrEqual: typing.ClassVar[Qt3DRender.QAlphaTest.AlphaFunction] = ...
        Never: typing.ClassVar[Qt3DRender.QAlphaTest.AlphaFunction] = ...
        NotEqual: typing.ClassVar[Qt3DRender.QAlphaTest.AlphaFunction] = ...
        alphaFunctionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        referenceValueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., alphaFunction: Qt3DRender.QAlphaTest.AlphaFunction = ..., alphaFunctionChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QAlphaTest.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., referenceValue: float = ..., referenceValueChanged: typing.Callable = ...) -> None: ...
        def alphaFunction(self) -> Qt3DRender.QAlphaTest.AlphaFunction: ...
        def referenceValue(self) -> float: ...
        def setAlphaFunction(self, alphaFunction: Qt3DRender.QAlphaTest.AlphaFunction) -> None: ...
        def setReferenceValue(self, referenceValue: float) -> None: ...

    class QAttribute(PySide2.Qt3DCore.Qt3DCore.QNode):
        class AttributeType:
            DrawIndirectAttribute: typing.ClassVar[Qt3DRender.QAttribute.AttributeType] = ...
            IndexAttribute: typing.ClassVar[Qt3DRender.QAttribute.AttributeType] = ...
            VertexAttribute: typing.ClassVar[Qt3DRender.QAttribute.AttributeType] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QAttribute.AttributeType: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QAttribute.AttributeType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QAttribute.AttributeType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QAttribute.AttributeType: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QAttribute.AttributeType: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QAttribute.AttributeType: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QAttribute.AttributeType: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QAttribute.AttributeType: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QAttribute.AttributeType: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QAttribute.AttributeType: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QAttribute.AttributeType: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QAttribute.AttributeType: ...

        class VertexBaseType:
            Byte: typing.ClassVar[Qt3DRender.QAttribute.VertexBaseType] = ...
            Double: typing.ClassVar[Qt3DRender.QAttribute.VertexBaseType] = ...
            Float: typing.ClassVar[Qt3DRender.QAttribute.VertexBaseType] = ...
            HalfFloat: typing.ClassVar[Qt3DRender.QAttribute.VertexBaseType] = ...
            Int: typing.ClassVar[Qt3DRender.QAttribute.VertexBaseType] = ...
            Short: typing.ClassVar[Qt3DRender.QAttribute.VertexBaseType] = ...
            UnsignedByte: typing.ClassVar[Qt3DRender.QAttribute.VertexBaseType] = ...
            UnsignedInt: typing.ClassVar[Qt3DRender.QAttribute.VertexBaseType] = ...
            UnsignedShort: typing.ClassVar[Qt3DRender.QAttribute.VertexBaseType] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QAttribute.VertexBaseType: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QAttribute.VertexBaseType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QAttribute.VertexBaseType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QAttribute.VertexBaseType: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QAttribute.VertexBaseType: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QAttribute.VertexBaseType: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QAttribute.VertexBaseType: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QAttribute.VertexBaseType: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QAttribute.VertexBaseType: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QAttribute.VertexBaseType: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QAttribute.VertexBaseType: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QAttribute.VertexBaseType: ...
        Byte: typing.ClassVar[Qt3DRender.QAttribute.VertexBaseType] = ...
        Double: typing.ClassVar[Qt3DRender.QAttribute.VertexBaseType] = ...
        DrawIndirectAttribute: typing.ClassVar[Qt3DRender.QAttribute.AttributeType] = ...
        Float: typing.ClassVar[Qt3DRender.QAttribute.VertexBaseType] = ...
        HalfFloat: typing.ClassVar[Qt3DRender.QAttribute.VertexBaseType] = ...
        IndexAttribute: typing.ClassVar[Qt3DRender.QAttribute.AttributeType] = ...
        Int: typing.ClassVar[Qt3DRender.QAttribute.VertexBaseType] = ...
        Short: typing.ClassVar[Qt3DRender.QAttribute.VertexBaseType] = ...
        UnsignedByte: typing.ClassVar[Qt3DRender.QAttribute.VertexBaseType] = ...
        UnsignedInt: typing.ClassVar[Qt3DRender.QAttribute.VertexBaseType] = ...
        UnsignedShort: typing.ClassVar[Qt3DRender.QAttribute.VertexBaseType] = ...
        VertexAttribute: typing.ClassVar[Qt3DRender.QAttribute.AttributeType] = ...
        attributeTypeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        bufferChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        byteOffsetChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        byteStrideChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        countChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        dataSizeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        dataTypeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        divisorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        nameChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        vertexBaseTypeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        vertexSizeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @typing.overload
        def __init__(self, buf: Qt3DRender.QBuffer, name: str, vertexBaseType: Qt3DRender.QAttribute.VertexBaseType, vertexSize: int, count: int, offset: int = ..., stride: int = ..., parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., attributeType: Qt3DRender.QAttribute.AttributeType = ..., attributeTypeChanged: typing.Callable = ..., buffer: Qt3DRender.QBuffer = ..., bufferChanged: typing.Callable = ..., byteOffset: int = ..., byteOffsetChanged: typing.Callable = ..., byteStride: int = ..., byteStrideChanged: typing.Callable = ..., countChanged: typing.Callable = ..., dataSizeChanged: typing.Callable = ..., dataTypeChanged: typing.Callable = ..., defaultColorAttributeName: str = ..., defaultJointIndicesAttributeName: str = ..., defaultJointWeightsAttributeName: str = ..., defaultNormalAttributeName: str = ..., defaultPositionAttributeName: str = ..., defaultPropertyTrackingMode: Qt3DRender.QAttribute.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., defaultTangentAttributeName: str = ..., defaultTextureCoordinate1AttributeName: str = ..., defaultTextureCoordinate2AttributeName: str = ..., defaultTextureCoordinateAttributeName: str = ..., destroyed: typing.Callable = ..., divisor: int = ..., divisorChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nameChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., vertexBaseTypeChanged: typing.Callable = ..., vertexSizeChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, buf: Qt3DRender.QBuffer, vertexBaseType: Qt3DRender.QAttribute.VertexBaseType, vertexSize: int, count: int, offset: int = ..., stride: int = ..., parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., attributeType: Qt3DRender.QAttribute.AttributeType = ..., attributeTypeChanged: typing.Callable = ..., buffer: Qt3DRender.QBuffer = ..., bufferChanged: typing.Callable = ..., byteOffset: int = ..., byteOffsetChanged: typing.Callable = ..., byteStride: int = ..., byteStrideChanged: typing.Callable = ..., countChanged: typing.Callable = ..., dataSizeChanged: typing.Callable = ..., dataTypeChanged: typing.Callable = ..., defaultColorAttributeName: str = ..., defaultJointIndicesAttributeName: str = ..., defaultJointWeightsAttributeName: str = ..., defaultNormalAttributeName: str = ..., defaultPositionAttributeName: str = ..., defaultPropertyTrackingMode: Qt3DRender.QAttribute.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., defaultTangentAttributeName: str = ..., defaultTextureCoordinate1AttributeName: str = ..., defaultTextureCoordinate2AttributeName: str = ..., defaultTextureCoordinateAttributeName: str = ..., destroyed: typing.Callable = ..., divisor: int = ..., divisorChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., vertexBaseTypeChanged: typing.Callable = ..., vertexSizeChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., attributeType: Qt3DRender.QAttribute.AttributeType = ..., attributeTypeChanged: typing.Callable = ..., buffer: Qt3DRender.QBuffer = ..., bufferChanged: typing.Callable = ..., byteOffset: int = ..., byteOffsetChanged: typing.Callable = ..., byteStride: int = ..., byteStrideChanged: typing.Callable = ..., count: int = ..., countChanged: typing.Callable = ..., dataSizeChanged: typing.Callable = ..., dataTypeChanged: typing.Callable = ..., defaultColorAttributeName: str = ..., defaultJointIndicesAttributeName: str = ..., defaultJointWeightsAttributeName: str = ..., defaultNormalAttributeName: str = ..., defaultPositionAttributeName: str = ..., defaultPropertyTrackingMode: Qt3DRender.QAttribute.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., defaultTangentAttributeName: str = ..., defaultTextureCoordinate1AttributeName: str = ..., defaultTextureCoordinate2AttributeName: str = ..., defaultTextureCoordinateAttributeName: str = ..., destroyed: typing.Callable = ..., divisor: int = ..., divisorChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., vertexBaseType: Qt3DRender.QAttribute.VertexBaseType = ..., vertexBaseTypeChanged: typing.Callable = ..., vertexSize: int = ..., vertexSizeChanged: typing.Callable = ...) -> None: ...
        def attributeType(self) -> Qt3DRender.QAttribute.AttributeType: ...
        def buffer(self) -> Qt3DRender.QBuffer: ...
        def byteOffset(self) -> int: ...
        def byteStride(self) -> int: ...
        def count(self) -> int: ...
        @staticmethod
        def defaultColorAttributeName() -> str: ...
        @staticmethod
        def defaultJointIndicesAttributeName() -> str: ...
        @staticmethod
        def defaultJointWeightsAttributeName() -> str: ...
        @staticmethod
        def defaultNormalAttributeName() -> str: ...
        @staticmethod
        def defaultPositionAttributeName() -> str: ...
        @staticmethod
        def defaultTangentAttributeName() -> str: ...
        @staticmethod
        def defaultTextureCoordinate1AttributeName() -> str: ...
        @staticmethod
        def defaultTextureCoordinate2AttributeName() -> str: ...
        @staticmethod
        def defaultTextureCoordinateAttributeName() -> str: ...
        def divisor(self) -> int: ...
        def name(self) -> str: ...
        def setAttributeType(self, attributeType: Qt3DRender.QAttribute.AttributeType) -> None: ...
        def setBuffer(self, buffer: Qt3DRender.QBuffer) -> None: ...
        def setByteOffset(self, byteOffset: int) -> None: ...
        def setByteStride(self, byteStride: int) -> None: ...
        def setCount(self, count: int) -> None: ...
        def setDataSize(self, size: int) -> None: ...
        def setDataType(self, type: Qt3DRender.QAttribute.VertexBaseType) -> None: ...
        def setDivisor(self, divisor: int) -> None: ...
        def setName(self, name: str) -> None: ...
        def setVertexBaseType(self, type: Qt3DRender.QAttribute.VertexBaseType) -> None: ...
        def setVertexSize(self, size: int) -> None: ...
        def vertexBaseType(self) -> Qt3DRender.QAttribute.VertexBaseType: ...
        def vertexSize(self) -> int: ...

    class QBlendEquation(Qt3DRender.QRenderState):
        class BlendFunction:
            Add: typing.ClassVar[Qt3DRender.QBlendEquation.BlendFunction] = ...
            Max: typing.ClassVar[Qt3DRender.QBlendEquation.BlendFunction] = ...
            Min: typing.ClassVar[Qt3DRender.QBlendEquation.BlendFunction] = ...
            ReverseSubtract: typing.ClassVar[Qt3DRender.QBlendEquation.BlendFunction] = ...
            Subtract: typing.ClassVar[Qt3DRender.QBlendEquation.BlendFunction] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QBlendEquation.BlendFunction: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QBlendEquation.BlendFunction: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QBlendEquation.BlendFunction: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QBlendEquation.BlendFunction: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QBlendEquation.BlendFunction: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QBlendEquation.BlendFunction: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QBlendEquation.BlendFunction: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QBlendEquation.BlendFunction: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QBlendEquation.BlendFunction: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QBlendEquation.BlendFunction: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QBlendEquation.BlendFunction: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QBlendEquation.BlendFunction: ...
        Add: typing.ClassVar[Qt3DRender.QBlendEquation.BlendFunction] = ...
        Max: typing.ClassVar[Qt3DRender.QBlendEquation.BlendFunction] = ...
        Min: typing.ClassVar[Qt3DRender.QBlendEquation.BlendFunction] = ...
        ReverseSubtract: typing.ClassVar[Qt3DRender.QBlendEquation.BlendFunction] = ...
        Subtract: typing.ClassVar[Qt3DRender.QBlendEquation.BlendFunction] = ...
        blendFunctionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., blendFunction: Qt3DRender.QBlendEquation.BlendFunction = ..., blendFunctionChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QBlendEquation.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def blendFunction(self) -> Qt3DRender.QBlendEquation.BlendFunction: ...
        def setBlendFunction(self, blendFunction: Qt3DRender.QBlendEquation.BlendFunction) -> None: ...

    class QBlendEquationArguments(Qt3DRender.QRenderState):
        class Blending:
            ConstantAlpha: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
            ConstantColor: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
            DestinationAlpha: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
            DestinationColor: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
            One: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
            OneMinusConstantAlpha: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
            OneMinusConstantColor: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
            OneMinusDestinationAlpha: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
            OneMinusDestinationColor: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
            OneMinusSource1Alpha: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
            OneMinusSource1Color: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
            OneMinusSource1Color0: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
            OneMinusSourceAlpha: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
            OneMinusSourceColor: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
            Source1Alpha: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
            Source1Color: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
            SourceAlpha: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
            SourceAlphaSaturate: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
            SourceColor: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
            Zero: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QBlendEquationArguments.Blending: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QBlendEquationArguments.Blending: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QBlendEquationArguments.Blending: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QBlendEquationArguments.Blending: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QBlendEquationArguments.Blending: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QBlendEquationArguments.Blending: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QBlendEquationArguments.Blending: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QBlendEquationArguments.Blending: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QBlendEquationArguments.Blending: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QBlendEquationArguments.Blending: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QBlendEquationArguments.Blending: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QBlendEquationArguments.Blending: ...
        ConstantAlpha: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
        ConstantColor: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
        DestinationAlpha: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
        DestinationColor: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
        One: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
        OneMinusConstantAlpha: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
        OneMinusConstantColor: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
        OneMinusDestinationAlpha: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
        OneMinusDestinationColor: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
        OneMinusSource1Alpha: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
        OneMinusSource1Color: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
        OneMinusSource1Color0: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
        OneMinusSourceAlpha: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
        OneMinusSourceColor: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
        Source1Alpha: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
        Source1Color: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
        SourceAlpha: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
        SourceAlphaSaturate: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
        SourceColor: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
        Zero: typing.ClassVar[Qt3DRender.QBlendEquationArguments.Blending] = ...
        bufferIndexChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        destinationAlphaChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        destinationRgbChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        destinationRgbaChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sourceAlphaChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sourceRgbChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sourceRgbaChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., bufferIndex: int = ..., bufferIndexChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QBlendEquationArguments.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destinationAlpha: Qt3DRender.QBlendEquationArguments.Blending = ..., destinationAlphaChanged: typing.Callable = ..., destinationRgb: Qt3DRender.QBlendEquationArguments.Blending = ..., destinationRgbChanged: typing.Callable = ..., destinationRgbaChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., sourceAlpha: Qt3DRender.QBlendEquationArguments.Blending = ..., sourceAlphaChanged: typing.Callable = ..., sourceRgb: Qt3DRender.QBlendEquationArguments.Blending = ..., sourceRgbChanged: typing.Callable = ..., sourceRgbaChanged: typing.Callable = ...) -> None: ...
        def bufferIndex(self) -> int: ...
        def destinationAlpha(self) -> Qt3DRender.QBlendEquationArguments.Blending: ...
        def destinationRgb(self) -> Qt3DRender.QBlendEquationArguments.Blending: ...
        def setBufferIndex(self, index: int) -> None: ...
        def setDestinationAlpha(self, destinationAlpha: Qt3DRender.QBlendEquationArguments.Blending) -> None: ...
        def setDestinationRgb(self, destinationRgb: Qt3DRender.QBlendEquationArguments.Blending) -> None: ...
        def setDestinationRgba(self, destinationRgba: Qt3DRender.QBlendEquationArguments.Blending) -> None: ...
        def setSourceAlpha(self, sourceAlpha: Qt3DRender.QBlendEquationArguments.Blending) -> None: ...
        def setSourceRgb(self, sourceRgb: Qt3DRender.QBlendEquationArguments.Blending) -> None: ...
        def setSourceRgba(self, sourceRgba: Qt3DRender.QBlendEquationArguments.Blending) -> None: ...
        def sourceAlpha(self) -> Qt3DRender.QBlendEquationArguments.Blending: ...
        def sourceRgb(self) -> Qt3DRender.QBlendEquationArguments.Blending: ...

    class QBlitFramebuffer(Qt3DRender.QFrameGraphNode):
        class InterpolationMethod:
            Linear: typing.ClassVar[Qt3DRender.QBlitFramebuffer.InterpolationMethod] = ...
            Nearest: typing.ClassVar[Qt3DRender.QBlitFramebuffer.InterpolationMethod] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QBlitFramebuffer.InterpolationMethod: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QBlitFramebuffer.InterpolationMethod: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QBlitFramebuffer.InterpolationMethod: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QBlitFramebuffer.InterpolationMethod: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QBlitFramebuffer.InterpolationMethod: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QBlitFramebuffer.InterpolationMethod: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QBlitFramebuffer.InterpolationMethod: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QBlitFramebuffer.InterpolationMethod: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QBlitFramebuffer.InterpolationMethod: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QBlitFramebuffer.InterpolationMethod: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QBlitFramebuffer.InterpolationMethod: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QBlitFramebuffer.InterpolationMethod: ...
        Linear: typing.ClassVar[Qt3DRender.QBlitFramebuffer.InterpolationMethod] = ...
        Nearest: typing.ClassVar[Qt3DRender.QBlitFramebuffer.InterpolationMethod] = ...
        destinationAttachmentPointChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        destinationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        destinationRectChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        interpolationMethodChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sourceAttachmentPointChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sourceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sourceRectChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QBlitFramebuffer.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destination: Qt3DRender.QRenderTarget = ..., destinationAttachmentPoint: typing.Any = ..., destinationAttachmentPointChanged: typing.Callable = ..., destinationChanged: typing.Callable = ..., destinationRect: PySide2.QtCore.QRectF = ..., destinationRectChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., interpolationMethod: Qt3DRender.QBlitFramebuffer.InterpolationMethod = ..., interpolationMethodChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., source: Qt3DRender.QRenderTarget = ..., sourceAttachmentPoint: typing.Any = ..., sourceAttachmentPointChanged: typing.Callable = ..., sourceChanged: typing.Callable = ..., sourceRect: PySide2.QtCore.QRectF = ..., sourceRectChanged: typing.Callable = ...) -> None: ...
        def destination(self) -> Qt3DRender.QRenderTarget: ...
        def destinationAttachmentPoint(self) -> Qt3DRender.QRenderTargetOutput.AttachmentPoint: ...
        def destinationRect(self) -> PySide2.QtCore.QRectF: ...
        def interpolationMethod(self) -> Qt3DRender.QBlitFramebuffer.InterpolationMethod: ...
        def setDestination(self, destination: Qt3DRender.QRenderTarget) -> None: ...
        def setDestinationAttachmentPoint(self, destinationAttachmentPoint: Qt3DRender.QRenderTargetOutput.AttachmentPoint) -> None: ...
        def setDestinationRect(self, destinationRect: PySide2.QtCore.QRectF) -> None: ...
        def setInterpolationMethod(self, interpolationMethod: Qt3DRender.QBlitFramebuffer.InterpolationMethod) -> None: ...
        def setSource(self, source: Qt3DRender.QRenderTarget) -> None: ...
        def setSourceAttachmentPoint(self, sourceAttachmentPoint: Qt3DRender.QRenderTargetOutput.AttachmentPoint) -> None: ...
        def setSourceRect(self, sourceRect: PySide2.QtCore.QRectF) -> None: ...
        def source(self) -> Qt3DRender.QRenderTarget: ...
        def sourceAttachmentPoint(self) -> Qt3DRender.QRenderTargetOutput.AttachmentPoint: ...
        def sourceRect(self) -> PySide2.QtCore.QRectF: ...

    class QBuffer(PySide2.Qt3DCore.Qt3DCore.QNode):
        class AccessType:
            Read: typing.ClassVar[Qt3DRender.QBuffer.AccessType] = ...
            ReadWrite: typing.ClassVar[Qt3DRender.QBuffer.AccessType] = ...
            Write: typing.ClassVar[Qt3DRender.QBuffer.AccessType] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.AccessType: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.AccessType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.AccessType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.AccessType: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.AccessType: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.AccessType: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.AccessType: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.AccessType: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.AccessType: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.AccessType: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.AccessType: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.AccessType: ...

        class BufferType:
            DrawIndirectBuffer: typing.ClassVar[Qt3DRender.QBuffer.BufferType] = ...
            IndexBuffer: typing.ClassVar[Qt3DRender.QBuffer.BufferType] = ...
            PixelPackBuffer: typing.ClassVar[Qt3DRender.QBuffer.BufferType] = ...
            PixelUnpackBuffer: typing.ClassVar[Qt3DRender.QBuffer.BufferType] = ...
            ShaderStorageBuffer: typing.ClassVar[Qt3DRender.QBuffer.BufferType] = ...
            UniformBuffer: typing.ClassVar[Qt3DRender.QBuffer.BufferType] = ...
            VertexBuffer: typing.ClassVar[Qt3DRender.QBuffer.BufferType] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.BufferType: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.BufferType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.BufferType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.BufferType: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.BufferType: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.BufferType: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.BufferType: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.BufferType: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.BufferType: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.BufferType: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.BufferType: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.BufferType: ...

        class UsageType:
            DynamicCopy: typing.ClassVar[Qt3DRender.QBuffer.UsageType] = ...
            DynamicDraw: typing.ClassVar[Qt3DRender.QBuffer.UsageType] = ...
            DynamicRead: typing.ClassVar[Qt3DRender.QBuffer.UsageType] = ...
            StaticCopy: typing.ClassVar[Qt3DRender.QBuffer.UsageType] = ...
            StaticDraw: typing.ClassVar[Qt3DRender.QBuffer.UsageType] = ...
            StaticRead: typing.ClassVar[Qt3DRender.QBuffer.UsageType] = ...
            StreamCopy: typing.ClassVar[Qt3DRender.QBuffer.UsageType] = ...
            StreamDraw: typing.ClassVar[Qt3DRender.QBuffer.UsageType] = ...
            StreamRead: typing.ClassVar[Qt3DRender.QBuffer.UsageType] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.UsageType: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.UsageType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.UsageType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.UsageType: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.UsageType: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.UsageType: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.UsageType: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.UsageType: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.UsageType: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.UsageType: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.UsageType: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QBuffer.UsageType: ...
        DrawIndirectBuffer: typing.ClassVar[Qt3DRender.QBuffer.BufferType] = ...
        DynamicCopy: typing.ClassVar[Qt3DRender.QBuffer.UsageType] = ...
        DynamicDraw: typing.ClassVar[Qt3DRender.QBuffer.UsageType] = ...
        DynamicRead: typing.ClassVar[Qt3DRender.QBuffer.UsageType] = ...
        IndexBuffer: typing.ClassVar[Qt3DRender.QBuffer.BufferType] = ...
        PixelPackBuffer: typing.ClassVar[Qt3DRender.QBuffer.BufferType] = ...
        PixelUnpackBuffer: typing.ClassVar[Qt3DRender.QBuffer.BufferType] = ...
        Read: typing.ClassVar[Qt3DRender.QBuffer.AccessType] = ...
        ReadWrite: typing.ClassVar[Qt3DRender.QBuffer.AccessType] = ...
        ShaderStorageBuffer: typing.ClassVar[Qt3DRender.QBuffer.BufferType] = ...
        StaticCopy: typing.ClassVar[Qt3DRender.QBuffer.UsageType] = ...
        StaticDraw: typing.ClassVar[Qt3DRender.QBuffer.UsageType] = ...
        StaticRead: typing.ClassVar[Qt3DRender.QBuffer.UsageType] = ...
        StreamCopy: typing.ClassVar[Qt3DRender.QBuffer.UsageType] = ...
        StreamDraw: typing.ClassVar[Qt3DRender.QBuffer.UsageType] = ...
        StreamRead: typing.ClassVar[Qt3DRender.QBuffer.UsageType] = ...
        UniformBuffer: typing.ClassVar[Qt3DRender.QBuffer.BufferType] = ...
        VertexBuffer: typing.ClassVar[Qt3DRender.QBuffer.BufferType] = ...
        Write: typing.ClassVar[Qt3DRender.QBuffer.AccessType] = ...
        accessTypeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        dataAvailable: typing.ClassVar[PySide2.QtCore.Signal] = ...
        dataChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        syncDataChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        typeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        usageChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @typing.overload
        def __init__(self, ty: Qt3DRender.QBuffer.BufferType, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., accessType: Qt3DRender.QBuffer.AccessType = ..., accessTypeChanged: typing.Callable = ..., dataAvailable: typing.Callable = ..., dataChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QBuffer.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., syncData: bool = ..., syncDataChanged: typing.Callable = ..., type: Qt3DRender.QBuffer.BufferType = ..., typeChanged: typing.Callable = ..., usage: Qt3DRender.QBuffer.UsageType = ..., usageChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., accessType: Qt3DRender.QBuffer.AccessType = ..., accessTypeChanged: typing.Callable = ..., dataAvailable: typing.Callable = ..., dataChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QBuffer.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., syncData: bool = ..., syncDataChanged: typing.Callable = ..., type: Qt3DRender.QBuffer.BufferType = ..., typeChanged: typing.Callable = ..., usage: Qt3DRender.QBuffer.UsageType = ..., usageChanged: typing.Callable = ...) -> None: ...
        def accessType(self) -> Qt3DRender.QBuffer.AccessType: ...
        def data(self) -> PySide2.QtCore.QByteArray: ...
        def isSyncData(self) -> bool: ...
        def setAccessType(self, access: Qt3DRender.QBuffer.AccessType) -> None: ...
        def setData(self, bytes: PySide2.QtCore.QByteArray | bytes) -> None: ...
        def setSyncData(self, syncData: bool) -> None: ...
        def setType(self, type: Qt3DRender.QBuffer.BufferType) -> None: ...
        def setUsage(self, usage: Qt3DRender.QBuffer.UsageType) -> None: ...
        def type(self) -> Qt3DRender.QBuffer.BufferType: ...
        def updateData(self, offset: int, bytes: PySide2.QtCore.QByteArray | bytes) -> None: ...
        def usage(self) -> Qt3DRender.QBuffer.UsageType: ...

    class QBufferCapture(Qt3DRender.QFrameGraphNode):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QBufferCapture.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...

    class QBufferDataGenerator(Qt3DRender.QAbstractFunctor):
        def __init__(self) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...

    class QCamera(PySide2.Qt3DCore.Qt3DCore.QEntity):
        class CameraTranslationOption:
            DontTranslateViewCenter: typing.ClassVar[Qt3DRender.QCamera.CameraTranslationOption] = ...
            TranslateViewCenter: typing.ClassVar[Qt3DRender.QCamera.CameraTranslationOption] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QCamera.CameraTranslationOption: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QCamera.CameraTranslationOption: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QCamera.CameraTranslationOption: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QCamera.CameraTranslationOption: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QCamera.CameraTranslationOption: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QCamera.CameraTranslationOption: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QCamera.CameraTranslationOption: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QCamera.CameraTranslationOption: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QCamera.CameraTranslationOption: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QCamera.CameraTranslationOption: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QCamera.CameraTranslationOption: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QCamera.CameraTranslationOption: ...
        DontTranslateViewCenter: typing.ClassVar[Qt3DRender.QCamera.CameraTranslationOption] = ...
        TranslateViewCenter: typing.ClassVar[Qt3DRender.QCamera.CameraTranslationOption] = ...
        aspectRatioChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        bottomChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        exposureChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        farPlaneChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        fieldOfViewChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        leftChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        nearPlaneChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        positionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        projectionMatrixChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        projectionTypeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rightChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        topChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        upVectorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        viewCenterChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        viewMatrixChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        viewVectorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., aspectRatio: float = ..., aspectRatioChanged: typing.Callable = ..., bottom: float = ..., bottomChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QCamera.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., exposure: float = ..., exposureChanged: typing.Callable = ..., farPlane: float = ..., farPlaneChanged: typing.Callable = ..., fieldOfView: float = ..., fieldOfViewChanged: typing.Callable = ..., left: float = ..., leftChanged: typing.Callable = ..., lens: Qt3DRender.QCameraLens = ..., nearPlane: float = ..., nearPlaneChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., position: PySide2.QtGui.QVector3D = ..., positionChanged: typing.Callable = ..., projectionMatrix: PySide2.QtGui.QMatrix4x4 = ..., projectionMatrixChanged: typing.Callable = ..., projectionType: typing.Any = ..., projectionTypeChanged: typing.Callable = ..., right: float = ..., rightChanged: typing.Callable = ..., top: float = ..., topChanged: typing.Callable = ..., transform: PySide2.Qt3DCore.Qt3DCore.QTransform = ..., upVector: PySide2.QtGui.QVector3D = ..., upVectorChanged: typing.Callable = ..., viewCenter: PySide2.QtGui.QVector3D = ..., viewCenterChanged: typing.Callable = ..., viewMatrix: PySide2.QtGui.QMatrix4x4 = ..., viewMatrixChanged: typing.Callable = ..., viewVector: PySide2.QtGui.QVector3D = ..., viewVectorChanged: typing.Callable = ...) -> None: ...
        def aspectRatio(self) -> float: ...
        def bottom(self) -> float: ...
        def exposure(self) -> float: ...
        def farPlane(self) -> float: ...
        def fieldOfView(self) -> float: ...
        def left(self) -> float: ...
        def lens(self) -> Qt3DRender.QCameraLens: ...
        def nearPlane(self) -> float: ...
        @typing.overload
        def pan(self, angle: float, axis: PySide2.QtGui.QVector3D) -> None: ...
        @typing.overload
        def pan(self, angle: float) -> None: ...
        @typing.overload
        def panAboutViewCenter(self, angle: float, axis: PySide2.QtGui.QVector3D) -> None: ...
        @typing.overload
        def panAboutViewCenter(self, angle: float) -> None: ...
        def panRotation(self, angle: float) -> PySide2.QtGui.QQuaternion: ...
        def position(self) -> PySide2.QtGui.QVector3D: ...
        def projectionMatrix(self) -> PySide2.QtGui.QMatrix4x4: ...
        def projectionType(self) -> Qt3DRender.QCameraLens.ProjectionType: ...
        def right(self) -> float: ...
        def roll(self, angle: float) -> None: ...
        def rollAboutViewCenter(self, angle: float) -> None: ...
        def rollRotation(self, angle: float) -> PySide2.QtGui.QQuaternion: ...
        def rotate(self, q: PySide2.QtGui.QQuaternion) -> None: ...
        def rotateAboutViewCenter(self, q: PySide2.QtGui.QQuaternion) -> None: ...
        def rotation(self, angle: float, axis: PySide2.QtGui.QVector3D) -> PySide2.QtGui.QQuaternion: ...
        def setAspectRatio(self, aspectRatio: float) -> None: ...
        def setBottom(self, bottom: float) -> None: ...
        def setExposure(self, exposure: float) -> None: ...
        def setFarPlane(self, farPlane: float) -> None: ...
        def setFieldOfView(self, fieldOfView: float) -> None: ...
        def setLeft(self, left: float) -> None: ...
        def setNearPlane(self, nearPlane: float) -> None: ...
        def setPosition(self, position: PySide2.QtGui.QVector3D) -> None: ...
        def setProjectionMatrix(self, projectionMatrix: PySide2.QtGui.QMatrix4x4) -> None: ...
        def setProjectionType(self, type: Qt3DRender.QCameraLens.ProjectionType) -> None: ...
        def setRight(self, right: float) -> None: ...
        def setTop(self, top: float) -> None: ...
        def setUpVector(self, upVector: PySide2.QtGui.QVector3D) -> None: ...
        def setViewCenter(self, viewCenter: PySide2.QtGui.QVector3D) -> None: ...
        def tilt(self, angle: float) -> None: ...
        def tiltAboutViewCenter(self, angle: float) -> None: ...
        def tiltRotation(self, angle: float) -> PySide2.QtGui.QQuaternion: ...
        def top(self) -> float: ...
        def transform(self) -> PySide2.Qt3DCore.Qt3DCore.QTransform: ...
        def translate(self, vLocal: PySide2.QtGui.QVector3D, option: Qt3DRender.QCamera.CameraTranslationOption = ...) -> None: ...
        def translateWorld(self, vWorld: PySide2.QtGui.QVector3D, option: Qt3DRender.QCamera.CameraTranslationOption = ...) -> None: ...
        def upVector(self) -> PySide2.QtGui.QVector3D: ...
        def viewAll(self) -> None: ...
        def viewCenter(self) -> PySide2.QtGui.QVector3D: ...
        def viewEntity(self, entity: PySide2.Qt3DCore.Qt3DCore.QEntity) -> None: ...
        def viewMatrix(self) -> PySide2.QtGui.QMatrix4x4: ...
        def viewSphere(self, center: PySide2.QtGui.QVector3D, radius: float) -> None: ...
        def viewVector(self) -> PySide2.QtGui.QVector3D: ...

    class QCameraLens(PySide2.Qt3DCore.Qt3DCore.QComponent):
        class ProjectionType:
            CustomProjection: typing.ClassVar[Qt3DRender.QCameraLens.ProjectionType] = ...
            FrustumProjection: typing.ClassVar[Qt3DRender.QCameraLens.ProjectionType] = ...
            OrthographicProjection: typing.ClassVar[Qt3DRender.QCameraLens.ProjectionType] = ...
            PerspectiveProjection: typing.ClassVar[Qt3DRender.QCameraLens.ProjectionType] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QCameraLens.ProjectionType: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QCameraLens.ProjectionType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QCameraLens.ProjectionType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QCameraLens.ProjectionType: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QCameraLens.ProjectionType: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QCameraLens.ProjectionType: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QCameraLens.ProjectionType: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QCameraLens.ProjectionType: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QCameraLens.ProjectionType: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QCameraLens.ProjectionType: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QCameraLens.ProjectionType: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QCameraLens.ProjectionType: ...
        CustomProjection: typing.ClassVar[Qt3DRender.QCameraLens.ProjectionType] = ...
        FrustumProjection: typing.ClassVar[Qt3DRender.QCameraLens.ProjectionType] = ...
        OrthographicProjection: typing.ClassVar[Qt3DRender.QCameraLens.ProjectionType] = ...
        PerspectiveProjection: typing.ClassVar[Qt3DRender.QCameraLens.ProjectionType] = ...
        aspectRatioChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        bottomChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        exposureChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        farPlaneChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        fieldOfViewChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        leftChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        nearPlaneChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        projectionMatrixChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        projectionTypeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rightChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        topChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        viewSphere: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., aspectRatio: float = ..., aspectRatioChanged: typing.Callable = ..., bottom: float = ..., bottomChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QCameraLens.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., exposure: float = ..., exposureChanged: typing.Callable = ..., farPlane: float = ..., farPlaneChanged: typing.Callable = ..., fieldOfView: float = ..., fieldOfViewChanged: typing.Callable = ..., isShareable: bool = ..., left: float = ..., leftChanged: typing.Callable = ..., nearPlane: float = ..., nearPlaneChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., projectionMatrix: PySide2.QtGui.QMatrix4x4 = ..., projectionMatrixChanged: typing.Callable = ..., projectionType: Qt3DRender.QCameraLens.ProjectionType = ..., projectionTypeChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., right: float = ..., rightChanged: typing.Callable = ..., shareableChanged: typing.Callable = ..., top: float = ..., topChanged: typing.Callable = ..., viewSphere: typing.Callable = ...) -> None: ...
        def aspectRatio(self) -> float: ...
        def bottom(self) -> float: ...
        def exposure(self) -> float: ...
        def farPlane(self) -> float: ...
        def fieldOfView(self) -> float: ...
        def left(self) -> float: ...
        def nearPlane(self) -> float: ...
        def projectionMatrix(self) -> PySide2.QtGui.QMatrix4x4: ...
        def projectionType(self) -> Qt3DRender.QCameraLens.ProjectionType: ...
        def right(self) -> float: ...
        def setAspectRatio(self, aspectRatio: float) -> None: ...
        def setBottom(self, bottom: float) -> None: ...
        def setExposure(self, exposure: float) -> None: ...
        def setFarPlane(self, farPlane: float) -> None: ...
        def setFieldOfView(self, fieldOfView: float) -> None: ...
        def setFrustumProjection(self, left: float, right: float, bottom: float, top: float, nearPlane: float, farPlane: float) -> None: ...
        def setLeft(self, left: float) -> None: ...
        def setNearPlane(self, nearPlane: float) -> None: ...
        def setOrthographicProjection(self, left: float, right: float, bottom: float, top: float, nearPlane: float, farPlane: float) -> None: ...
        def setPerspectiveProjection(self, fieldOfView: float, aspect: float, nearPlane: float, farPlane: float) -> None: ...
        def setProjectionMatrix(self, projectionMatrix: PySide2.QtGui.QMatrix4x4) -> None: ...
        def setProjectionType(self, projectionType: Qt3DRender.QCameraLens.ProjectionType) -> None: ...
        def setRight(self, right: float) -> None: ...
        def setTop(self, top: float) -> None: ...
        def top(self) -> float: ...
        def viewAll(self, cameraId: PySide2.Qt3DCore.Qt3DCore.QNodeId) -> None: ...
        def viewEntity(self, entityId: PySide2.Qt3DCore.Qt3DCore.QNodeId, cameraId: PySide2.Qt3DCore.Qt3DCore.QNodeId) -> None: ...

    class QCameraSelector(Qt3DRender.QFrameGraphNode):
        cameraChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., camera: PySide2.Qt3DCore.Qt3DCore.QEntity = ..., cameraChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QCameraSelector.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def camera(self) -> PySide2.Qt3DCore.Qt3DCore.QEntity: ...
        def setCamera(self, camera: PySide2.Qt3DCore.Qt3DCore.QEntity) -> None: ...

    class QClearBuffers(Qt3DRender.QFrameGraphNode):
        class BufferType:
            AllBuffers: typing.ClassVar[Qt3DRender.QClearBuffers.BufferType] = ...
            ColorBuffer: typing.ClassVar[Qt3DRender.QClearBuffers.BufferType] = ...
            ColorDepthBuffer: typing.ClassVar[Qt3DRender.QClearBuffers.BufferType] = ...
            ColorDepthStencilBuffer: typing.ClassVar[Qt3DRender.QClearBuffers.BufferType] = ...
            DepthBuffer: typing.ClassVar[Qt3DRender.QClearBuffers.BufferType] = ...
            DepthStencilBuffer: typing.ClassVar[Qt3DRender.QClearBuffers.BufferType] = ...
            None_: typing.ClassVar[Qt3DRender.QClearBuffers.BufferType] = ...
            StencilBuffer: typing.ClassVar[Qt3DRender.QClearBuffers.BufferType] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QClearBuffers.BufferTypeFlags: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __invert__(self) -> Qt3DRender.QClearBuffers.BufferTypeFlags: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QClearBuffers.BufferTypeFlags: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QClearBuffers.BufferTypeFlags: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QClearBuffers.BufferTypeFlags: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QClearBuffers.BufferTypeFlags: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QClearBuffers.BufferTypeFlags: ...

        class BufferTypeFlags:
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QClearBuffers.BufferTypeFlags: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __invert__(self) -> Qt3DRender.QClearBuffers.BufferTypeFlags: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QClearBuffers.BufferTypeFlags: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QClearBuffers.BufferTypeFlags: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QClearBuffers.BufferTypeFlags: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QClearBuffers.BufferTypeFlags: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QClearBuffers.BufferTypeFlags: ...
        AllBuffers: typing.ClassVar[Qt3DRender.QClearBuffers.BufferType] = ...
        ColorBuffer: typing.ClassVar[Qt3DRender.QClearBuffers.BufferType] = ...
        ColorDepthBuffer: typing.ClassVar[Qt3DRender.QClearBuffers.BufferType] = ...
        ColorDepthStencilBuffer: typing.ClassVar[Qt3DRender.QClearBuffers.BufferType] = ...
        DepthBuffer: typing.ClassVar[Qt3DRender.QClearBuffers.BufferType] = ...
        DepthStencilBuffer: typing.ClassVar[Qt3DRender.QClearBuffers.BufferType] = ...
        None_: typing.ClassVar[Qt3DRender.QClearBuffers.BufferType] = ...
        StencilBuffer: typing.ClassVar[Qt3DRender.QClearBuffers.BufferType] = ...
        buffersChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        clearColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        clearDepthValueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        clearStencilValueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        colorBufferChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., buffers: Qt3DRender.QClearBuffers.BufferType = ..., buffersChanged: typing.Callable = ..., clearColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., clearColorChanged: typing.Callable = ..., clearDepthValue: float = ..., clearDepthValueChanged: typing.Callable = ..., clearStencilValue: int = ..., clearStencilValueChanged: typing.Callable = ..., colorBuffer: Qt3DRender.QRenderTargetOutput = ..., colorBufferChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QClearBuffers.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def buffers(self) -> Qt3DRender.QClearBuffers.BufferType: ...
        def clearColor(self) -> PySide2.QtGui.QColor: ...
        def clearDepthValue(self) -> float: ...
        def clearStencilValue(self) -> int: ...
        def colorBuffer(self) -> Qt3DRender.QRenderTargetOutput: ...
        def setBuffers(self, buffers: Qt3DRender.QClearBuffers.BufferType) -> None: ...
        def setClearColor(self, color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setClearDepthValue(self, clearDepthValue: float) -> None: ...
        def setClearStencilValue(self, clearStencilValue: int) -> None: ...
        def setColorBuffer(self, buffer: Qt3DRender.QRenderTargetOutput) -> None: ...

    class QClipPlane(Qt3DRender.QRenderState):
        distanceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        normalChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        planeIndexChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QClipPlane.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., distance: float = ..., distanceChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., normal: PySide2.QtGui.QVector3D = ..., normalChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., planeIndex: int = ..., planeIndexChanged: typing.Callable = ...) -> None: ...
        def distance(self) -> float: ...
        def normal(self) -> PySide2.QtGui.QVector3D: ...
        def planeIndex(self) -> int: ...
        def setDistance(self, arg__1: float) -> None: ...
        def setNormal(self, arg__1: PySide2.QtGui.QVector3D) -> None: ...
        def setPlaneIndex(self, arg__1: int) -> None: ...

    class QColorMask(Qt3DRender.QRenderState):
        alphaMaskedChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        blueMaskedChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        greenMaskedChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        redMaskedChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., alphaMasked: bool = ..., alphaMaskedChanged: typing.Callable = ..., blueMasked: bool = ..., blueMaskedChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QColorMask.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., greenMasked: bool = ..., greenMaskedChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., redMasked: bool = ..., redMaskedChanged: typing.Callable = ...) -> None: ...
        def isAlphaMasked(self) -> bool: ...
        def isBlueMasked(self) -> bool: ...
        def isGreenMasked(self) -> bool: ...
        def isRedMasked(self) -> bool: ...
        def setAlphaMasked(self, alphaMasked: bool) -> None: ...
        def setBlueMasked(self, blueMasked: bool) -> None: ...
        def setGreenMasked(self, greenMasked: bool) -> None: ...
        def setRedMasked(self, redMasked: bool) -> None: ...

    class QComputeCommand(PySide2.Qt3DCore.Qt3DCore.QComponent):
        class RunType:
            Continuous: typing.ClassVar[Qt3DRender.QComputeCommand.RunType] = ...
            Manual: typing.ClassVar[Qt3DRender.QComputeCommand.RunType] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QComputeCommand.RunType: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QComputeCommand.RunType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QComputeCommand.RunType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QComputeCommand.RunType: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QComputeCommand.RunType: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QComputeCommand.RunType: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QComputeCommand.RunType: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QComputeCommand.RunType: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QComputeCommand.RunType: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QComputeCommand.RunType: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QComputeCommand.RunType: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QComputeCommand.RunType: ...
        Continuous: typing.ClassVar[Qt3DRender.QComputeCommand.RunType] = ...
        Manual: typing.ClassVar[Qt3DRender.QComputeCommand.RunType] = ...
        runTypeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        workGroupXChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        workGroupYChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        workGroupZChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QComputeCommand.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., runType: Qt3DRender.QComputeCommand.RunType = ..., runTypeChanged: typing.Callable = ..., shareableChanged: typing.Callable = ..., workGroupX: int = ..., workGroupXChanged: typing.Callable = ..., workGroupY: int = ..., workGroupYChanged: typing.Callable = ..., workGroupZ: int = ..., workGroupZChanged: typing.Callable = ...) -> None: ...
        def runType(self) -> Qt3DRender.QComputeCommand.RunType: ...
        def setRunType(self, runType: Qt3DRender.QComputeCommand.RunType) -> None: ...
        def setWorkGroupX(self, workGroupX: int) -> None: ...
        def setWorkGroupY(self, workGroupY: int) -> None: ...
        def setWorkGroupZ(self, workGroupZ: int) -> None: ...
        @typing.overload
        def trigger(self, workGroupX: int, workGroupY: int, workGroupZ: int, frameCount: int = ...) -> None: ...
        @typing.overload
        def trigger(self, frameCount: int = ...) -> None: ...
        def workGroupX(self) -> int: ...
        def workGroupY(self) -> int: ...
        def workGroupZ(self) -> int: ...

    class QCullFace(Qt3DRender.QRenderState):
        class CullingMode:
            Back: typing.ClassVar[Qt3DRender.QCullFace.CullingMode] = ...
            Front: typing.ClassVar[Qt3DRender.QCullFace.CullingMode] = ...
            FrontAndBack: typing.ClassVar[Qt3DRender.QCullFace.CullingMode] = ...
            NoCulling: typing.ClassVar[Qt3DRender.QCullFace.CullingMode] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QCullFace.CullingMode: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QCullFace.CullingMode: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QCullFace.CullingMode: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QCullFace.CullingMode: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QCullFace.CullingMode: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QCullFace.CullingMode: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QCullFace.CullingMode: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QCullFace.CullingMode: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QCullFace.CullingMode: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QCullFace.CullingMode: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QCullFace.CullingMode: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QCullFace.CullingMode: ...
        Back: typing.ClassVar[Qt3DRender.QCullFace.CullingMode] = ...
        Front: typing.ClassVar[Qt3DRender.QCullFace.CullingMode] = ...
        FrontAndBack: typing.ClassVar[Qt3DRender.QCullFace.CullingMode] = ...
        NoCulling: typing.ClassVar[Qt3DRender.QCullFace.CullingMode] = ...
        modeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QCullFace.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., mode: Qt3DRender.QCullFace.CullingMode = ..., modeChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def mode(self) -> Qt3DRender.QCullFace.CullingMode: ...
        def setMode(self, mode: Qt3DRender.QCullFace.CullingMode) -> None: ...

    class QDepthTest(Qt3DRender.QRenderState):
        class DepthFunction:
            Always: typing.ClassVar[Qt3DRender.QDepthTest.DepthFunction] = ...
            Equal: typing.ClassVar[Qt3DRender.QDepthTest.DepthFunction] = ...
            Greater: typing.ClassVar[Qt3DRender.QDepthTest.DepthFunction] = ...
            GreaterOrEqual: typing.ClassVar[Qt3DRender.QDepthTest.DepthFunction] = ...
            Less: typing.ClassVar[Qt3DRender.QDepthTest.DepthFunction] = ...
            LessOrEqual: typing.ClassVar[Qt3DRender.QDepthTest.DepthFunction] = ...
            Never: typing.ClassVar[Qt3DRender.QDepthTest.DepthFunction] = ...
            NotEqual: typing.ClassVar[Qt3DRender.QDepthTest.DepthFunction] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QDepthTest.DepthFunction: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QDepthTest.DepthFunction: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QDepthTest.DepthFunction: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QDepthTest.DepthFunction: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QDepthTest.DepthFunction: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QDepthTest.DepthFunction: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QDepthTest.DepthFunction: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QDepthTest.DepthFunction: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QDepthTest.DepthFunction: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QDepthTest.DepthFunction: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QDepthTest.DepthFunction: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QDepthTest.DepthFunction: ...
        Always: typing.ClassVar[Qt3DRender.QDepthTest.DepthFunction] = ...
        Equal: typing.ClassVar[Qt3DRender.QDepthTest.DepthFunction] = ...
        Greater: typing.ClassVar[Qt3DRender.QDepthTest.DepthFunction] = ...
        GreaterOrEqual: typing.ClassVar[Qt3DRender.QDepthTest.DepthFunction] = ...
        Less: typing.ClassVar[Qt3DRender.QDepthTest.DepthFunction] = ...
        LessOrEqual: typing.ClassVar[Qt3DRender.QDepthTest.DepthFunction] = ...
        Never: typing.ClassVar[Qt3DRender.QDepthTest.DepthFunction] = ...
        NotEqual: typing.ClassVar[Qt3DRender.QDepthTest.DepthFunction] = ...
        depthFunctionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QDepthTest.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., depthFunction: Qt3DRender.QDepthTest.DepthFunction = ..., depthFunctionChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def depthFunction(self) -> Qt3DRender.QDepthTest.DepthFunction: ...
        def setDepthFunction(self, depthFunction: Qt3DRender.QDepthTest.DepthFunction) -> None: ...

    class QDirectionalLight(Qt3DRender.QAbstractLight):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        worldDirectionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., colorChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QDirectionalLight.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., intensity: float = ..., intensityChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ..., type: Qt3DRender.QDirectionalLight.Type = ..., worldDirection: PySide2.QtGui.QVector3D = ..., worldDirectionChanged: typing.Callable = ...) -> None: ...
        def setWorldDirection(self, worldDirection: PySide2.QtGui.QVector3D) -> None: ...
        def worldDirection(self) -> PySide2.QtGui.QVector3D: ...

    class QDispatchCompute(Qt3DRender.QFrameGraphNode):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        workGroupXChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        workGroupYChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        workGroupZChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QDispatchCompute.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., workGroupX: int = ..., workGroupXChanged: typing.Callable = ..., workGroupY: int = ..., workGroupYChanged: typing.Callable = ..., workGroupZ: int = ..., workGroupZChanged: typing.Callable = ...) -> None: ...
        def setWorkGroupX(self, workGroupX: int) -> None: ...
        def setWorkGroupY(self, workGroupY: int) -> None: ...
        def setWorkGroupZ(self, workGroupZ: int) -> None: ...
        def workGroupX(self) -> int: ...
        def workGroupY(self) -> int: ...
        def workGroupZ(self) -> int: ...

    class QDithering(Qt3DRender.QRenderState):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QDithering.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...

    class QEffect(PySide2.Qt3DCore.Qt3DCore.QNode):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QEffect.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def addParameter(self, parameter: Qt3DRender.QParameter) -> None: ...
        def addTechnique(self, t: Qt3DRender.QTechnique) -> None: ...
        def parameters(self) -> typing.List[Qt3DRender.QParameter]: ...
        def removeParameter(self, parameter: Qt3DRender.QParameter) -> None: ...
        def removeTechnique(self, t: Qt3DRender.QTechnique) -> None: ...
        def techniques(self) -> typing.List[Qt3DRender.QTechnique]: ...

    class QEnvironmentLight(PySide2.Qt3DCore.Qt3DCore.QComponent):
        irradianceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        specularChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QEnvironmentLight.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., irradiance: Qt3DRender.QAbstractTexture = ..., irradianceChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ..., specular: Qt3DRender.QAbstractTexture = ..., specularChanged: typing.Callable = ...) -> None: ...
        def irradiance(self) -> Qt3DRender.QAbstractTexture: ...
        def setIrradiance(self, irradiance: Qt3DRender.QAbstractTexture) -> None: ...
        def setSpecular(self, specular: Qt3DRender.QAbstractTexture) -> None: ...
        def specular(self) -> Qt3DRender.QAbstractTexture: ...

    class QFilterKey(PySide2.Qt3DCore.Qt3DCore.QNode):
        nameChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        valueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QFilterKey.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., value: object = ..., valueChanged: typing.Callable = ...) -> None: ...
        def name(self) -> str: ...
        def setName(self, customType: str) -> None: ...
        def setValue(self, value: typing.Any) -> None: ...
        def value(self) -> typing.Any: ...

    class QFrameGraphNode(PySide2.Qt3DCore.Qt3DCore.QNode):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QFrameGraphNode.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def parentFrameGraphNode(self) -> Qt3DRender.QFrameGraphNode: ...

    class QFrameGraphNodeCreatedChangeBase(PySide2.Qt3DCore.Qt3DCore.QNodeCreatedChangeBase):
        def __init__(self, node: Qt3DRender.QFrameGraphNode) -> None: ...
        def parentFrameGraphNodeId(self) -> PySide2.Qt3DCore.Qt3DCore.QNodeId: ...

    class QFrontFace(Qt3DRender.QRenderState):
        class WindingDirection:
            ClockWise: typing.ClassVar[Qt3DRender.QFrontFace.WindingDirection] = ...
            CounterClockWise: typing.ClassVar[Qt3DRender.QFrontFace.WindingDirection] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QFrontFace.WindingDirection: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QFrontFace.WindingDirection: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QFrontFace.WindingDirection: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QFrontFace.WindingDirection: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QFrontFace.WindingDirection: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QFrontFace.WindingDirection: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QFrontFace.WindingDirection: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QFrontFace.WindingDirection: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QFrontFace.WindingDirection: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QFrontFace.WindingDirection: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QFrontFace.WindingDirection: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QFrontFace.WindingDirection: ...
        ClockWise: typing.ClassVar[Qt3DRender.QFrontFace.WindingDirection] = ...
        CounterClockWise: typing.ClassVar[Qt3DRender.QFrontFace.WindingDirection] = ...
        directionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QFrontFace.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., direction: Qt3DRender.QFrontFace.WindingDirection = ..., directionChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def direction(self) -> Qt3DRender.QFrontFace.WindingDirection: ...
        def setDirection(self, direction: Qt3DRender.QFrontFace.WindingDirection) -> None: ...

    class QFrustumCulling(Qt3DRender.QFrameGraphNode):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QFrustumCulling.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...

    class QGeometry(PySide2.Qt3DCore.Qt3DCore.QNode):
        boundingVolumePositionAttributeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        maxExtentChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        minExtentChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., boundingVolumePositionAttribute: Qt3DRender.QAttribute = ..., boundingVolumePositionAttributeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QGeometry.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., maxExtent: PySide2.QtGui.QVector3D = ..., maxExtentChanged: typing.Callable = ..., minExtent: PySide2.QtGui.QVector3D = ..., minExtentChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def addAttribute(self, attribute: Qt3DRender.QAttribute) -> None: ...
        def attributes(self) -> typing.List[Qt3DRender.QAttribute]: ...
        def boundingVolumePositionAttribute(self) -> Qt3DRender.QAttribute: ...
        def maxExtent(self) -> PySide2.QtGui.QVector3D: ...
        def minExtent(self) -> PySide2.QtGui.QVector3D: ...
        def removeAttribute(self, attribute: Qt3DRender.QAttribute) -> None: ...
        def setBoundingVolumePositionAttribute(self, boundingVolumePositionAttribute: Qt3DRender.QAttribute) -> None: ...

    class QGeometryFactory(Qt3DRender.QAbstractFunctor):
        def __init__(self) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...

    class QGeometryRenderer(PySide2.Qt3DCore.Qt3DCore.QComponent):
        class PrimitiveType:
            LineLoop: typing.ClassVar[Qt3DRender.QGeometryRenderer.PrimitiveType] = ...
            LineStrip: typing.ClassVar[Qt3DRender.QGeometryRenderer.PrimitiveType] = ...
            LineStripAdjacency: typing.ClassVar[Qt3DRender.QGeometryRenderer.PrimitiveType] = ...
            Lines: typing.ClassVar[Qt3DRender.QGeometryRenderer.PrimitiveType] = ...
            LinesAdjacency: typing.ClassVar[Qt3DRender.QGeometryRenderer.PrimitiveType] = ...
            Patches: typing.ClassVar[Qt3DRender.QGeometryRenderer.PrimitiveType] = ...
            Points: typing.ClassVar[Qt3DRender.QGeometryRenderer.PrimitiveType] = ...
            TriangleFan: typing.ClassVar[Qt3DRender.QGeometryRenderer.PrimitiveType] = ...
            TriangleStrip: typing.ClassVar[Qt3DRender.QGeometryRenderer.PrimitiveType] = ...
            TriangleStripAdjacency: typing.ClassVar[Qt3DRender.QGeometryRenderer.PrimitiveType] = ...
            Triangles: typing.ClassVar[Qt3DRender.QGeometryRenderer.PrimitiveType] = ...
            TrianglesAdjacency: typing.ClassVar[Qt3DRender.QGeometryRenderer.PrimitiveType] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QGeometryRenderer.PrimitiveType: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QGeometryRenderer.PrimitiveType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QGeometryRenderer.PrimitiveType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QGeometryRenderer.PrimitiveType: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QGeometryRenderer.PrimitiveType: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QGeometryRenderer.PrimitiveType: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QGeometryRenderer.PrimitiveType: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QGeometryRenderer.PrimitiveType: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QGeometryRenderer.PrimitiveType: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QGeometryRenderer.PrimitiveType: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QGeometryRenderer.PrimitiveType: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QGeometryRenderer.PrimitiveType: ...
        LineLoop: typing.ClassVar[Qt3DRender.QGeometryRenderer.PrimitiveType] = ...
        LineStrip: typing.ClassVar[Qt3DRender.QGeometryRenderer.PrimitiveType] = ...
        LineStripAdjacency: typing.ClassVar[Qt3DRender.QGeometryRenderer.PrimitiveType] = ...
        Lines: typing.ClassVar[Qt3DRender.QGeometryRenderer.PrimitiveType] = ...
        LinesAdjacency: typing.ClassVar[Qt3DRender.QGeometryRenderer.PrimitiveType] = ...
        Patches: typing.ClassVar[Qt3DRender.QGeometryRenderer.PrimitiveType] = ...
        Points: typing.ClassVar[Qt3DRender.QGeometryRenderer.PrimitiveType] = ...
        TriangleFan: typing.ClassVar[Qt3DRender.QGeometryRenderer.PrimitiveType] = ...
        TriangleStrip: typing.ClassVar[Qt3DRender.QGeometryRenderer.PrimitiveType] = ...
        TriangleStripAdjacency: typing.ClassVar[Qt3DRender.QGeometryRenderer.PrimitiveType] = ...
        Triangles: typing.ClassVar[Qt3DRender.QGeometryRenderer.PrimitiveType] = ...
        TrianglesAdjacency: typing.ClassVar[Qt3DRender.QGeometryRenderer.PrimitiveType] = ...
        firstInstanceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        firstVertexChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        geometryChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        indexBufferByteOffsetChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        indexOffsetChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        instanceCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        primitiveRestartEnabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        primitiveTypeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        restartIndexValueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        vertexCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        verticesPerPatchChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QGeometryRenderer.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., firstInstance: int = ..., firstInstanceChanged: typing.Callable = ..., firstVertex: int = ..., firstVertexChanged: typing.Callable = ..., geometry: Qt3DRender.QGeometry = ..., geometryChanged: typing.Callable = ..., indexBufferByteOffset: int = ..., indexBufferByteOffsetChanged: typing.Callable = ..., indexOffset: int = ..., indexOffsetChanged: typing.Callable = ..., instanceCount: int = ..., instanceCountChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., primitiveRestartEnabled: bool = ..., primitiveRestartEnabledChanged: typing.Callable = ..., primitiveType: Qt3DRender.QGeometryRenderer.PrimitiveType = ..., primitiveTypeChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., restartIndexValue: int = ..., restartIndexValueChanged: typing.Callable = ..., shareableChanged: typing.Callable = ..., vertexCount: int = ..., vertexCountChanged: typing.Callable = ..., verticesPerPatch: int = ..., verticesPerPatchChanged: typing.Callable = ...) -> None: ...
        def firstInstance(self) -> int: ...
        def firstVertex(self) -> int: ...
        def geometry(self) -> Qt3DRender.QGeometry: ...
        def indexBufferByteOffset(self) -> int: ...
        def indexOffset(self) -> int: ...
        def instanceCount(self) -> int: ...
        def primitiveRestartEnabled(self) -> bool: ...
        def primitiveType(self) -> Qt3DRender.QGeometryRenderer.PrimitiveType: ...
        def restartIndexValue(self) -> int: ...
        def setFirstInstance(self, firstInstance: int) -> None: ...
        def setFirstVertex(self, firstVertex: int) -> None: ...
        def setGeometry(self, geometry: Qt3DRender.QGeometry) -> None: ...
        def setIndexBufferByteOffset(self, offset: int) -> None: ...
        def setIndexOffset(self, indexOffset: int) -> None: ...
        def setInstanceCount(self, instanceCount: int) -> None: ...
        def setPrimitiveRestartEnabled(self, enabled: bool) -> None: ...
        def setPrimitiveType(self, primitiveType: Qt3DRender.QGeometryRenderer.PrimitiveType) -> None: ...
        def setRestartIndexValue(self, index: int) -> None: ...
        def setVertexCount(self, vertexCount: int) -> None: ...
        def setVerticesPerPatch(self, verticesPerPatch: int) -> None: ...
        def vertexCount(self) -> int: ...
        def verticesPerPatch(self) -> int: ...

    class QGraphicsApiFilter(PySide2.QtCore.QObject):
        class Api:
            DirectX: typing.ClassVar[Qt3DRender.QGraphicsApiFilter.Api] = ...
            OpenGL: typing.ClassVar[Qt3DRender.QGraphicsApiFilter.Api] = ...
            OpenGLES: typing.ClassVar[Qt3DRender.QGraphicsApiFilter.Api] = ...
            RHI: typing.ClassVar[Qt3DRender.QGraphicsApiFilter.Api] = ...
            Vulkan: typing.ClassVar[Qt3DRender.QGraphicsApiFilter.Api] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QGraphicsApiFilter.Api: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QGraphicsApiFilter.Api: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QGraphicsApiFilter.Api: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QGraphicsApiFilter.Api: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QGraphicsApiFilter.Api: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QGraphicsApiFilter.Api: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QGraphicsApiFilter.Api: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QGraphicsApiFilter.Api: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QGraphicsApiFilter.Api: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QGraphicsApiFilter.Api: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QGraphicsApiFilter.Api: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QGraphicsApiFilter.Api: ...

        class OpenGLProfile:
            CompatibilityProfile: typing.ClassVar[Qt3DRender.QGraphicsApiFilter.OpenGLProfile] = ...
            CoreProfile: typing.ClassVar[Qt3DRender.QGraphicsApiFilter.OpenGLProfile] = ...
            NoProfile: typing.ClassVar[Qt3DRender.QGraphicsApiFilter.OpenGLProfile] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QGraphicsApiFilter.OpenGLProfile: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QGraphicsApiFilter.OpenGLProfile: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QGraphicsApiFilter.OpenGLProfile: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QGraphicsApiFilter.OpenGLProfile: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QGraphicsApiFilter.OpenGLProfile: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QGraphicsApiFilter.OpenGLProfile: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QGraphicsApiFilter.OpenGLProfile: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QGraphicsApiFilter.OpenGLProfile: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QGraphicsApiFilter.OpenGLProfile: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QGraphicsApiFilter.OpenGLProfile: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QGraphicsApiFilter.OpenGLProfile: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QGraphicsApiFilter.OpenGLProfile: ...
        CompatibilityProfile: typing.ClassVar[Qt3DRender.QGraphicsApiFilter.OpenGLProfile] = ...
        CoreProfile: typing.ClassVar[Qt3DRender.QGraphicsApiFilter.OpenGLProfile] = ...
        DirectX: typing.ClassVar[Qt3DRender.QGraphicsApiFilter.Api] = ...
        NoProfile: typing.ClassVar[Qt3DRender.QGraphicsApiFilter.OpenGLProfile] = ...
        OpenGL: typing.ClassVar[Qt3DRender.QGraphicsApiFilter.Api] = ...
        OpenGLES: typing.ClassVar[Qt3DRender.QGraphicsApiFilter.Api] = ...
        RHI: typing.ClassVar[Qt3DRender.QGraphicsApiFilter.Api] = ...
        Vulkan: typing.ClassVar[Qt3DRender.QGraphicsApiFilter.Api] = ...
        apiChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        extensionsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        graphicsApiFilterChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        majorVersionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        minorVersionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        profileChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        vendorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., api: typing.Any = ..., apiChanged: typing.Callable = ..., destroyed: typing.Callable = ..., extensions: None = ..., extensionsChanged: typing.Callable = ..., graphicsApiFilterChanged: typing.Callable = ..., majorVersion: int = ..., majorVersionChanged: typing.Callable = ..., minorVersion: int = ..., minorVersionChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., profile: typing.Any = ..., profileChanged: typing.Callable = ..., vendor: str = ..., vendorChanged: typing.Callable = ...) -> None: ...
        def api(self) -> Qt3DRender.QGraphicsApiFilter.Api: ...
        def extensions(self) -> typing.List[str]: ...
        def majorVersion(self) -> int: ...
        def minorVersion(self) -> int: ...
        def profile(self) -> Qt3DRender.QGraphicsApiFilter.OpenGLProfile: ...
        def setApi(self, api: Qt3DRender.QGraphicsApiFilter.Api) -> None: ...
        def setExtensions(self, extensions: typing.Iterable[str]) -> None: ...
        def setMajorVersion(self, majorVersion: int) -> None: ...
        def setMinorVersion(self, minorVersion: int) -> None: ...
        def setProfile(self, profile: Qt3DRender.QGraphicsApiFilter.OpenGLProfile) -> None: ...
        def setVendor(self, vendor: str) -> None: ...
        def vendor(self) -> str: ...

    class QLayer(PySide2.Qt3DCore.Qt3DCore.QComponent):
        recursiveChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QLayer.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., recursive: bool = ..., recursiveChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ...) -> None: ...
        def recursive(self) -> bool: ...
        def setRecursive(self, recursive: bool) -> None: ...

    class QLayerFilter(Qt3DRender.QFrameGraphNode):
        class FilterMode:
            AcceptAllMatchingLayers: typing.ClassVar[Qt3DRender.QLayerFilter.FilterMode] = ...
            AcceptAnyMatchingLayers: typing.ClassVar[Qt3DRender.QLayerFilter.FilterMode] = ...
            DiscardAllMatchingLayers: typing.ClassVar[Qt3DRender.QLayerFilter.FilterMode] = ...
            DiscardAnyMatchingLayers: typing.ClassVar[Qt3DRender.QLayerFilter.FilterMode] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QLayerFilter.FilterMode: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QLayerFilter.FilterMode: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QLayerFilter.FilterMode: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QLayerFilter.FilterMode: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QLayerFilter.FilterMode: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QLayerFilter.FilterMode: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QLayerFilter.FilterMode: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QLayerFilter.FilterMode: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QLayerFilter.FilterMode: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QLayerFilter.FilterMode: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QLayerFilter.FilterMode: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QLayerFilter.FilterMode: ...
        AcceptAllMatchingLayers: typing.ClassVar[Qt3DRender.QLayerFilter.FilterMode] = ...
        AcceptAnyMatchingLayers: typing.ClassVar[Qt3DRender.QLayerFilter.FilterMode] = ...
        DiscardAllMatchingLayers: typing.ClassVar[Qt3DRender.QLayerFilter.FilterMode] = ...
        DiscardAnyMatchingLayers: typing.ClassVar[Qt3DRender.QLayerFilter.FilterMode] = ...
        filterModeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QLayerFilter.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., filterMode: Qt3DRender.QLayerFilter.FilterMode = ..., filterModeChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def addLayer(self, layer: Qt3DRender.QLayer) -> None: ...
        def filterMode(self) -> Qt3DRender.QLayerFilter.FilterMode: ...
        def layers(self) -> typing.List[Qt3DRender.QLayer]: ...
        def removeLayer(self, layer: Qt3DRender.QLayer) -> None: ...
        def setFilterMode(self, filterMode: Qt3DRender.QLayerFilter.FilterMode) -> None: ...

    class QLevelOfDetail(PySide2.Qt3DCore.Qt3DCore.QComponent):
        class ThresholdType:
            DistanceToCameraThreshold: typing.ClassVar[Qt3DRender.QLevelOfDetail.ThresholdType] = ...
            ProjectedScreenPixelSizeThreshold: typing.ClassVar[Qt3DRender.QLevelOfDetail.ThresholdType] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QLevelOfDetail.ThresholdType: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QLevelOfDetail.ThresholdType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QLevelOfDetail.ThresholdType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QLevelOfDetail.ThresholdType: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QLevelOfDetail.ThresholdType: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QLevelOfDetail.ThresholdType: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QLevelOfDetail.ThresholdType: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QLevelOfDetail.ThresholdType: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QLevelOfDetail.ThresholdType: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QLevelOfDetail.ThresholdType: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QLevelOfDetail.ThresholdType: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QLevelOfDetail.ThresholdType: ...
        DistanceToCameraThreshold: typing.ClassVar[Qt3DRender.QLevelOfDetail.ThresholdType] = ...
        ProjectedScreenPixelSizeThreshold: typing.ClassVar[Qt3DRender.QLevelOfDetail.ThresholdType] = ...
        cameraChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        currentIndexChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        thresholdTypeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        thresholdsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        volumeOverrideChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., camera: Qt3DRender.QCamera = ..., cameraChanged: typing.Callable = ..., currentIndex: int = ..., currentIndexChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QLevelOfDetail.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ..., thresholdType: Qt3DRender.QLevelOfDetail.ThresholdType = ..., thresholdTypeChanged: typing.Callable = ..., thresholds: typing.List[float] = ..., thresholdsChanged: typing.Callable = ..., volumeOverride: Qt3DRender.QLevelOfDetailBoundingSphere = ..., volumeOverrideChanged: typing.Callable = ...) -> None: ...
        def camera(self) -> Qt3DRender.QCamera: ...
        def createBoundingSphere(self, center: PySide2.QtGui.QVector3D, radius: float) -> Qt3DRender.QLevelOfDetailBoundingSphere: ...
        def currentIndex(self) -> int: ...
        def setCamera(self, camera: Qt3DRender.QCamera) -> None: ...
        def setCurrentIndex(self, currentIndex: int) -> None: ...
        def setThresholdType(self, thresholdType: Qt3DRender.QLevelOfDetail.ThresholdType) -> None: ...
        def setThresholds(self, thresholds: typing.List[float]) -> None: ...
        def setVolumeOverride(self, volumeOverride: Qt3DRender.QLevelOfDetailBoundingSphere) -> None: ...
        def thresholdType(self) -> Qt3DRender.QLevelOfDetail.ThresholdType: ...
        def thresholds(self) -> typing.List[float]: ...
        def volumeOverride(self) -> Qt3DRender.QLevelOfDetailBoundingSphere: ...

    class QLevelOfDetailBoundingSphere(shiboken2.Object):
        @typing.overload
        def __init__(self, center: PySide2.QtGui.QVector3D = ..., radius: float = ...) -> None: ...
        @typing.overload
        def __init__(self, other: Qt3DRender.QLevelOfDetailBoundingSphere) -> None: ...
        def center(self) -> PySide2.QtGui.QVector3D: ...
        def isEmpty(self) -> bool: ...
        def radius(self) -> float: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...

    class QLevelOfDetailSwitch(Qt3DRender.QLevelOfDetail):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., camera: typing.Any = ..., cameraChanged: typing.Callable = ..., currentIndex: int = ..., currentIndexChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QLevelOfDetailSwitch.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ..., thresholdType: Qt3DRender.QLevelOfDetailSwitch.ThresholdType = ..., thresholdTypeChanged: typing.Callable = ..., thresholds: typing.Any = ..., thresholdsChanged: typing.Callable = ..., volumeOverride: typing.Any = ..., volumeOverrideChanged: typing.Callable = ...) -> None: ...

    class QLineWidth(Qt3DRender.QRenderState):
        smoothChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        valueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QLineWidth.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., smooth: bool = ..., smoothChanged: typing.Callable = ..., value: float = ..., valueChanged: typing.Callable = ...) -> None: ...
        def setSmooth(self, enabled: bool) -> None: ...
        def setValue(self, value: float) -> None: ...
        def smooth(self) -> bool: ...
        def value(self) -> float: ...

    class QMaterial(PySide2.Qt3DCore.Qt3DCore.QComponent):
        effectChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QMaterial.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., effect: Qt3DRender.QEffect = ..., effectChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ...) -> None: ...
        def addParameter(self, parameter: Qt3DRender.QParameter) -> None: ...
        def effect(self) -> Qt3DRender.QEffect: ...
        def parameters(self) -> typing.List[Qt3DRender.QParameter]: ...
        def removeParameter(self, parameter: Qt3DRender.QParameter) -> None: ...
        def setEffect(self, effect: Qt3DRender.QEffect) -> None: ...

    class QMemoryBarrier(Qt3DRender.QFrameGraphNode):
        class Operation:
            All: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
            AtomicCounter: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
            BufferUpdate: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
            Command: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
            ElementArray: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
            FrameBuffer: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
            None_: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
            PixelBuffer: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
            QueryBuffer: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
            ShaderImageAccess: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
            ShaderStorage: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
            TextureFetch: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
            TextureUpdate: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
            TransformFeedback: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
            Uniform: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
            VertexAttributeArray: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QMemoryBarrier.Operations: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __invert__(self) -> Qt3DRender.QMemoryBarrier.Operations: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QMemoryBarrier.Operations: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QMemoryBarrier.Operations: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QMemoryBarrier.Operations: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QMemoryBarrier.Operations: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QMemoryBarrier.Operations: ...

        class Operations:
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QMemoryBarrier.Operations: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __invert__(self) -> Qt3DRender.QMemoryBarrier.Operations: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QMemoryBarrier.Operations: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QMemoryBarrier.Operations: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QMemoryBarrier.Operations: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QMemoryBarrier.Operations: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QMemoryBarrier.Operations: ...
        All: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
        AtomicCounter: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
        BufferUpdate: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
        Command: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
        ElementArray: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
        FrameBuffer: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
        None_: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
        PixelBuffer: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
        QueryBuffer: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
        ShaderImageAccess: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
        ShaderStorage: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
        TextureFetch: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
        TextureUpdate: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
        TransformFeedback: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
        Uniform: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
        VertexAttributeArray: typing.ClassVar[Qt3DRender.QMemoryBarrier.Operation] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        waitOperationsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QMemoryBarrier.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., waitOperationsChanged: typing.Callable = ...) -> None: ...
        def setWaitOperations(self, operations: Qt3DRender.QMemoryBarrier.Operations | Qt3DRender.QMemoryBarrier.Operation) -> None: ...
        def waitOperations(self) -> Qt3DRender.QMemoryBarrier.Operations | Qt3DRender.QMemoryBarrier.Operation: ...

    class QMesh(Qt3DRender.QGeometryRenderer):
        class Status:
            Error: typing.ClassVar[Qt3DRender.QMesh.Status] = ...
            Loading: typing.ClassVar[Qt3DRender.QMesh.Status] = ...
            None_: typing.ClassVar[Qt3DRender.QMesh.Status] = ...
            Ready: typing.ClassVar[Qt3DRender.QMesh.Status] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QMesh.Status: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QMesh.Status: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QMesh.Status: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QMesh.Status: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QMesh.Status: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QMesh.Status: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QMesh.Status: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QMesh.Status: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QMesh.Status: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QMesh.Status: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QMesh.Status: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QMesh.Status: ...
        Error: typing.ClassVar[Qt3DRender.QMesh.Status] = ...
        Loading: typing.ClassVar[Qt3DRender.QMesh.Status] = ...
        None_: typing.ClassVar[Qt3DRender.QMesh.Status] = ...
        Ready: typing.ClassVar[Qt3DRender.QMesh.Status] = ...
        meshNameChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sourceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        statusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QMesh.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., firstInstance: int = ..., firstInstanceChanged: typing.Callable = ..., firstVertex: int = ..., firstVertexChanged: typing.Callable = ..., geometry: typing.Any = ..., geometryChanged: typing.Callable = ..., indexBufferByteOffset: int = ..., indexBufferByteOffsetChanged: typing.Callable = ..., indexOffset: int = ..., indexOffsetChanged: typing.Callable = ..., instanceCount: int = ..., instanceCountChanged: typing.Callable = ..., isShareable: bool = ..., meshName: str = ..., meshNameChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., primitiveRestartEnabled: bool = ..., primitiveRestartEnabledChanged: typing.Callable = ..., primitiveType: Qt3DRender.QMesh.PrimitiveType = ..., primitiveTypeChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., restartIndexValue: int = ..., restartIndexValueChanged: typing.Callable = ..., shareableChanged: typing.Callable = ..., source: PySide2.QtCore.QUrl = ..., sourceChanged: typing.Callable = ..., status: Qt3DRender.QMesh.Status = ..., statusChanged: typing.Callable = ..., vertexCount: int = ..., vertexCountChanged: typing.Callable = ..., verticesPerPatch: int = ..., verticesPerPatchChanged: typing.Callable = ...) -> None: ...
        def meshName(self) -> str: ...
        def setMeshName(self, meshName: str) -> None: ...
        def setSource(self, source: PySide2.QtCore.QUrl) -> None: ...
        def source(self) -> PySide2.QtCore.QUrl: ...
        def status(self) -> Qt3DRender.QMesh.Status: ...

    class QMultiSampleAntiAliasing(Qt3DRender.QRenderState):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QMultiSampleAntiAliasing.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...

    class QNoDepthMask(Qt3DRender.QRenderState):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QNoDepthMask.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...

    class QNoDraw(Qt3DRender.QFrameGraphNode):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QNoDraw.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...

    class QNoPicking(Qt3DRender.QFrameGraphNode):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QNoPicking.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...

    class QObjectPicker(PySide2.Qt3DCore.Qt3DCore.QComponent):
        clicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
        containsMouseChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        dragEnabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        entered: typing.ClassVar[PySide2.QtCore.Signal] = ...
        exited: typing.ClassVar[PySide2.QtCore.Signal] = ...
        hoverEnabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        moved: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pressedChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        priorityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        released: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., clicked: typing.Callable = ..., containsMouse: bool = ..., containsMouseChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QObjectPicker.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., dragEnabled: bool = ..., dragEnabledChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., entered: typing.Callable = ..., exited: typing.Callable = ..., hoverEnabled: bool = ..., hoverEnabledChanged: typing.Callable = ..., isShareable: bool = ..., moved: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., pressed: typing.Callable = ..., pressedChanged: typing.Callable = ..., priority: int = ..., priorityChanged: typing.Callable = ..., released: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ...) -> None: ...
        def containsMouse(self) -> bool: ...
        def isDragEnabled(self) -> bool: ...
        def isHoverEnabled(self) -> bool: ...
        def isPressed(self) -> bool: ...
        def priority(self) -> int: ...
        def setDragEnabled(self, dragEnabled: bool) -> None: ...
        def setHoverEnabled(self, hoverEnabled: bool) -> None: ...
        def setPriority(self, priority: int) -> None: ...

    class QPaintedTextureImage(Qt3DRender.QAbstractTextureImage):
        heightChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sizeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        widthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QAbstractTextureImage.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., face: typing.Any = ..., faceChanged: typing.Callable = ..., layer: int = ..., layerChanged: typing.Callable = ..., mipLevel: int = ..., mipLevelChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def height(self) -> int: ...
        def paint(self, painter: PySide2.QtGui.QPainter) -> None: ...
        def setHeight(self, h: int) -> None: ...
        def setSize(self, size: PySide2.QtCore.QSize) -> None: ...
        def setWidth(self, w: int) -> None: ...
        def size(self) -> PySide2.QtCore.QSize: ...
        def update(self, rect: PySide2.QtCore.QRect = ...) -> None: ...
        def width(self) -> int: ...

    class QParameter(PySide2.Qt3DCore.Qt3DCore.QNode):
        nameChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        valueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @typing.overload
        def __init__(self, name: str, value: typing.Any, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QParameter.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nameChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., valueChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, name: str, texture: Qt3DRender.QAbstractTexture, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QParameter.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nameChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., value: object = ..., valueChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QParameter.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., value: object = ..., valueChanged: typing.Callable = ...) -> None: ...
        def name(self) -> str: ...
        def setName(self, name: str) -> None: ...
        def setValue(self, dv: typing.Any) -> None: ...
        def value(self) -> typing.Any: ...

    class QPickEvent(PySide2.QtCore.QObject):
        class Buttons:
            BackButton: typing.ClassVar[Qt3DRender.QPickEvent.Buttons] = ...
            LeftButton: typing.ClassVar[Qt3DRender.QPickEvent.Buttons] = ...
            MiddleButton: typing.ClassVar[Qt3DRender.QPickEvent.Buttons] = ...
            NoButton: typing.ClassVar[Qt3DRender.QPickEvent.Buttons] = ...
            RightButton: typing.ClassVar[Qt3DRender.QPickEvent.Buttons] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QPickEvent.Buttons: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QPickEvent.Buttons: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QPickEvent.Buttons: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QPickEvent.Buttons: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QPickEvent.Buttons: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QPickEvent.Buttons: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QPickEvent.Buttons: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QPickEvent.Buttons: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QPickEvent.Buttons: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QPickEvent.Buttons: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QPickEvent.Buttons: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QPickEvent.Buttons: ...

        class Modifiers:
            AltModifier: typing.ClassVar[Qt3DRender.QPickEvent.Modifiers] = ...
            ControlModifier: typing.ClassVar[Qt3DRender.QPickEvent.Modifiers] = ...
            KeypadModifier: typing.ClassVar[Qt3DRender.QPickEvent.Modifiers] = ...
            MetaModifier: typing.ClassVar[Qt3DRender.QPickEvent.Modifiers] = ...
            NoModifier: typing.ClassVar[Qt3DRender.QPickEvent.Modifiers] = ...
            ShiftModifier: typing.ClassVar[Qt3DRender.QPickEvent.Modifiers] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QPickEvent.Modifiers: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QPickEvent.Modifiers: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QPickEvent.Modifiers: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QPickEvent.Modifiers: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QPickEvent.Modifiers: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QPickEvent.Modifiers: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QPickEvent.Modifiers: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QPickEvent.Modifiers: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QPickEvent.Modifiers: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QPickEvent.Modifiers: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QPickEvent.Modifiers: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QPickEvent.Modifiers: ...
        AltModifier: typing.ClassVar[Qt3DRender.QPickEvent.Modifiers] = ...
        BackButton: typing.ClassVar[Qt3DRender.QPickEvent.Buttons] = ...
        ControlModifier: typing.ClassVar[Qt3DRender.QPickEvent.Modifiers] = ...
        KeypadModifier: typing.ClassVar[Qt3DRender.QPickEvent.Modifiers] = ...
        LeftButton: typing.ClassVar[Qt3DRender.QPickEvent.Buttons] = ...
        MetaModifier: typing.ClassVar[Qt3DRender.QPickEvent.Modifiers] = ...
        MiddleButton: typing.ClassVar[Qt3DRender.QPickEvent.Buttons] = ...
        NoButton: typing.ClassVar[Qt3DRender.QPickEvent.Buttons] = ...
        NoModifier: typing.ClassVar[Qt3DRender.QPickEvent.Modifiers] = ...
        RightButton: typing.ClassVar[Qt3DRender.QPickEvent.Buttons] = ...
        ShiftModifier: typing.ClassVar[Qt3DRender.QPickEvent.Modifiers] = ...
        acceptedChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @typing.overload
        def __init__(self, position: PySide2.QtCore.QPointF, worldIntersection: PySide2.QtGui.QVector3D, localIntersection: PySide2.QtGui.QVector3D, distance: float, button: Qt3DRender.QPickEvent.Buttons, buttons: int, modifiers: int, accepted: bool = ..., acceptedChanged: typing.Callable = ..., destroyed: typing.Callable = ..., entity: PySide2.Qt3DCore.Qt3DCore.QEntity = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., viewport: Qt3DRender.QViewport = ...) -> None: ...
        @typing.overload
        def __init__(self, position: PySide2.QtCore.QPointF, worldIntersection: PySide2.QtGui.QVector3D, localIntersection: PySide2.QtGui.QVector3D, distance: float, accepted: bool = ..., acceptedChanged: typing.Callable = ..., button: typing.Any = ..., buttons: int = ..., destroyed: typing.Callable = ..., entity: PySide2.Qt3DCore.Qt3DCore.QEntity = ..., modifiers: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., viewport: Qt3DRender.QViewport = ...) -> None: ...
        @typing.overload
        def __init__(self, accepted: bool = ..., acceptedChanged: typing.Callable = ..., button: typing.Any = ..., buttons: int = ..., destroyed: typing.Callable = ..., distance: float = ..., entity: PySide2.Qt3DCore.Qt3DCore.QEntity = ..., localIntersection: PySide2.QtGui.QVector3D = ..., modifiers: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., position: PySide2.QtCore.QPointF = ..., viewport: Qt3DRender.QViewport = ..., worldIntersection: PySide2.QtGui.QVector3D = ...) -> None: ...
        def button(self) -> Qt3DRender.QPickEvent.Buttons: ...
        def buttons(self) -> int: ...
        def distance(self) -> float: ...
        def entity(self) -> PySide2.Qt3DCore.Qt3DCore.QEntity: ...
        def isAccepted(self) -> bool: ...
        def localIntersection(self) -> PySide2.QtGui.QVector3D: ...
        def modifiers(self) -> int: ...
        def position(self) -> PySide2.QtCore.QPointF: ...
        def setAccepted(self, accepted: bool) -> None: ...
        def viewport(self) -> Qt3DRender.QViewport: ...
        def worldIntersection(self) -> PySide2.QtGui.QVector3D: ...

    class QPickLineEvent(Qt3DRender.QPickEvent):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @typing.overload
        def __init__(self, position: PySide2.QtCore.QPointF, worldIntersection: PySide2.QtGui.QVector3D, localIntersection: PySide2.QtGui.QVector3D, distance: float, edgeIndex: int, vertex1Index: int, vertex2Index: int, button: Qt3DRender.QPickEvent.Buttons, buttons: int, modifiers: int, accepted: bool = ..., acceptedChanged: typing.Callable = ..., destroyed: typing.Callable = ..., entity: typing.Any = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., viewport: typing.Any = ...) -> None: ...
        @typing.overload
        def __init__(self, accepted: bool = ..., acceptedChanged: typing.Callable = ..., button: typing.Any = ..., buttons: int = ..., destroyed: typing.Callable = ..., distance: float = ..., edgeIndex: int = ..., entity: typing.Any = ..., localIntersection: PySide2.QtGui.QVector3D = ..., modifiers: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., position: PySide2.QtCore.QPointF = ..., vertex1Index: int = ..., vertex2Index: int = ..., viewport: typing.Any = ..., worldIntersection: PySide2.QtGui.QVector3D = ...) -> None: ...
        def edgeIndex(self) -> int: ...
        def vertex1Index(self) -> int: ...
        def vertex2Index(self) -> int: ...

    class QPickPointEvent(Qt3DRender.QPickEvent):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @typing.overload
        def __init__(self, position: PySide2.QtCore.QPointF, worldIntersection: PySide2.QtGui.QVector3D, localIntersection: PySide2.QtGui.QVector3D, distance: float, pointIndex: int, button: Qt3DRender.QPickEvent.Buttons, buttons: int, modifiers: int, accepted: bool = ..., acceptedChanged: typing.Callable = ..., destroyed: typing.Callable = ..., entity: typing.Any = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., viewport: typing.Any = ...) -> None: ...
        @typing.overload
        def __init__(self, accepted: bool = ..., acceptedChanged: typing.Callable = ..., button: typing.Any = ..., buttons: int = ..., destroyed: typing.Callable = ..., distance: float = ..., entity: typing.Any = ..., localIntersection: PySide2.QtGui.QVector3D = ..., modifiers: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., pointIndex: int = ..., position: PySide2.QtCore.QPointF = ..., viewport: typing.Any = ..., worldIntersection: PySide2.QtGui.QVector3D = ...) -> None: ...
        def pointIndex(self) -> int: ...

    class QPickTriangleEvent(Qt3DRender.QPickEvent):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @typing.overload
        def __init__(self, position: PySide2.QtCore.QPointF, worldIntersection: PySide2.QtGui.QVector3D, localIntersection: PySide2.QtGui.QVector3D, distance: float, triangleIndex: int, vertex1Index: int, vertex2Index: int, vertex3Index: int, button: Qt3DRender.QPickEvent.Buttons, buttons: int, modifiers: int, uvw: PySide2.QtGui.QVector3D, accepted: bool = ..., acceptedChanged: typing.Callable = ..., destroyed: typing.Callable = ..., entity: typing.Any = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., viewport: typing.Any = ...) -> None: ...
        @typing.overload
        def __init__(self, position: PySide2.QtCore.QPointF, worldIntersection: PySide2.QtGui.QVector3D, localIntersection: PySide2.QtGui.QVector3D, distance: float, triangleIndex: int, vertex1Index: int, vertex2Index: int, vertex3Index: int, accepted: bool = ..., acceptedChanged: typing.Callable = ..., button: typing.Any = ..., buttons: int = ..., destroyed: typing.Callable = ..., entity: typing.Any = ..., modifiers: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., uvw: PySide2.QtGui.QVector3D = ..., viewport: typing.Any = ...) -> None: ...
        @typing.overload
        def __init__(self, accepted: bool = ..., acceptedChanged: typing.Callable = ..., button: typing.Any = ..., buttons: int = ..., destroyed: typing.Callable = ..., distance: float = ..., entity: typing.Any = ..., localIntersection: PySide2.QtGui.QVector3D = ..., modifiers: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., position: PySide2.QtCore.QPointF = ..., triangleIndex: int = ..., uvw: PySide2.QtGui.QVector3D = ..., vertex1Index: int = ..., vertex2Index: int = ..., vertex3Index: int = ..., viewport: typing.Any = ..., worldIntersection: PySide2.QtGui.QVector3D = ...) -> None: ...
        def triangleIndex(self) -> int: ...
        def uvw(self) -> PySide2.QtGui.QVector3D: ...
        def vertex1Index(self) -> int: ...
        def vertex2Index(self) -> int: ...
        def vertex3Index(self) -> int: ...

    class QPickingSettings(PySide2.Qt3DCore.Qt3DCore.QNode):
        class FaceOrientationPickingMode:
            BackFace: typing.ClassVar[Qt3DRender.QPickingSettings.FaceOrientationPickingMode] = ...
            FrontAndBackFace: typing.ClassVar[Qt3DRender.QPickingSettings.FaceOrientationPickingMode] = ...
            FrontFace: typing.ClassVar[Qt3DRender.QPickingSettings.FaceOrientationPickingMode] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.FaceOrientationPickingMode: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.FaceOrientationPickingMode: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.FaceOrientationPickingMode: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.FaceOrientationPickingMode: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.FaceOrientationPickingMode: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.FaceOrientationPickingMode: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.FaceOrientationPickingMode: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.FaceOrientationPickingMode: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.FaceOrientationPickingMode: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.FaceOrientationPickingMode: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.FaceOrientationPickingMode: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.FaceOrientationPickingMode: ...

        class PickMethod:
            BoundingVolumePicking: typing.ClassVar[Qt3DRender.QPickingSettings.PickMethod] = ...
            LinePicking: typing.ClassVar[Qt3DRender.QPickingSettings.PickMethod] = ...
            PointPicking: typing.ClassVar[Qt3DRender.QPickingSettings.PickMethod] = ...
            PrimitivePicking: typing.ClassVar[Qt3DRender.QPickingSettings.PickMethod] = ...
            TrianglePicking: typing.ClassVar[Qt3DRender.QPickingSettings.PickMethod] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.PickMethod: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.PickMethod: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.PickMethod: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.PickMethod: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.PickMethod: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.PickMethod: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.PickMethod: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.PickMethod: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.PickMethod: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.PickMethod: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.PickMethod: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.PickMethod: ...

        class PickResultMode:
            AllPicks: typing.ClassVar[Qt3DRender.QPickingSettings.PickResultMode] = ...
            NearestPick: typing.ClassVar[Qt3DRender.QPickingSettings.PickResultMode] = ...
            NearestPriorityPick: typing.ClassVar[Qt3DRender.QPickingSettings.PickResultMode] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.PickResultMode: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.PickResultMode: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.PickResultMode: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.PickResultMode: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.PickResultMode: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.PickResultMode: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.PickResultMode: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.PickResultMode: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.PickResultMode: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.PickResultMode: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.PickResultMode: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QPickingSettings.PickResultMode: ...
        AllPicks: typing.ClassVar[Qt3DRender.QPickingSettings.PickResultMode] = ...
        BackFace: typing.ClassVar[Qt3DRender.QPickingSettings.FaceOrientationPickingMode] = ...
        BoundingVolumePicking: typing.ClassVar[Qt3DRender.QPickingSettings.PickMethod] = ...
        FrontAndBackFace: typing.ClassVar[Qt3DRender.QPickingSettings.FaceOrientationPickingMode] = ...
        FrontFace: typing.ClassVar[Qt3DRender.QPickingSettings.FaceOrientationPickingMode] = ...
        LinePicking: typing.ClassVar[Qt3DRender.QPickingSettings.PickMethod] = ...
        NearestPick: typing.ClassVar[Qt3DRender.QPickingSettings.PickResultMode] = ...
        NearestPriorityPick: typing.ClassVar[Qt3DRender.QPickingSettings.PickResultMode] = ...
        PointPicking: typing.ClassVar[Qt3DRender.QPickingSettings.PickMethod] = ...
        PrimitivePicking: typing.ClassVar[Qt3DRender.QPickingSettings.PickMethod] = ...
        TrianglePicking: typing.ClassVar[Qt3DRender.QPickingSettings.PickMethod] = ...
        faceOrientationPickingModeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pickMethodChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pickResultModeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        worldSpaceToleranceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QPickingSettings.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., faceOrientationPickingMode: Qt3DRender.QPickingSettings.FaceOrientationPickingMode = ..., faceOrientationPickingModeChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., pickMethod: Qt3DRender.QPickingSettings.PickMethod = ..., pickMethodChanged: typing.Callable = ..., pickResultMode: Qt3DRender.QPickingSettings.PickResultMode = ..., pickResultModeChanged: typing.Callable = ..., worldSpaceTolerance: float = ..., worldSpaceToleranceChanged: typing.Callable = ...) -> None: ...
        def faceOrientationPickingMode(self) -> Qt3DRender.QPickingSettings.FaceOrientationPickingMode: ...
        def pickMethod(self) -> Qt3DRender.QPickingSettings.PickMethod: ...
        def pickResultMode(self) -> Qt3DRender.QPickingSettings.PickResultMode: ...
        def setFaceOrientationPickingMode(self, faceOrientationPickingMode: Qt3DRender.QPickingSettings.FaceOrientationPickingMode) -> None: ...
        def setPickMethod(self, pickMethod: Qt3DRender.QPickingSettings.PickMethod) -> None: ...
        def setPickResultMode(self, pickResultMode: Qt3DRender.QPickingSettings.PickResultMode) -> None: ...
        def setWorldSpaceTolerance(self, worldSpaceTolerance: float) -> None: ...
        def worldSpaceTolerance(self) -> float: ...

    class QPointLight(Qt3DRender.QAbstractLight):
        constantAttenuationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        linearAttenuationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        quadraticAttenuationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., colorChanged: typing.Callable = ..., constantAttenuation: float = ..., constantAttenuationChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QPointLight.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., intensity: float = ..., intensityChanged: typing.Callable = ..., isShareable: bool = ..., linearAttenuation: float = ..., linearAttenuationChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., quadraticAttenuation: float = ..., quadraticAttenuationChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ..., type: Qt3DRender.QPointLight.Type = ...) -> None: ...
        def constantAttenuation(self) -> float: ...
        def linearAttenuation(self) -> float: ...
        def quadraticAttenuation(self) -> float: ...
        def setConstantAttenuation(self, value: float) -> None: ...
        def setLinearAttenuation(self, value: float) -> None: ...
        def setQuadraticAttenuation(self, value: float) -> None: ...

    class QPointSize(Qt3DRender.QRenderState):
        class SizeMode:
            Fixed: typing.ClassVar[Qt3DRender.QPointSize.SizeMode] = ...
            Programmable: typing.ClassVar[Qt3DRender.QPointSize.SizeMode] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QPointSize.SizeMode: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QPointSize.SizeMode: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QPointSize.SizeMode: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QPointSize.SizeMode: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QPointSize.SizeMode: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QPointSize.SizeMode: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QPointSize.SizeMode: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QPointSize.SizeMode: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QPointSize.SizeMode: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QPointSize.SizeMode: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QPointSize.SizeMode: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QPointSize.SizeMode: ...
        Fixed: typing.ClassVar[Qt3DRender.QPointSize.SizeMode] = ...
        Programmable: typing.ClassVar[Qt3DRender.QPointSize.SizeMode] = ...
        sizeModeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        valueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QPointSize.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., sizeMode: Qt3DRender.QPointSize.SizeMode = ..., sizeModeChanged: typing.Callable = ..., value: float = ..., valueChanged: typing.Callable = ...) -> None: ...
        def setSizeMode(self, sizeMode: Qt3DRender.QPointSize.SizeMode) -> None: ...
        def setValue(self, value: float) -> None: ...
        def sizeMode(self) -> Qt3DRender.QPointSize.SizeMode: ...
        def value(self) -> float: ...

    class QPolygonOffset(Qt3DRender.QRenderState):
        depthStepsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        scaleFactorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QPolygonOffset.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., depthSteps: float = ..., depthStepsChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., scaleFactor: float = ..., scaleFactorChanged: typing.Callable = ...) -> None: ...
        def depthSteps(self) -> float: ...
        def scaleFactor(self) -> float: ...
        def setDepthSteps(self, depthSteps: float) -> None: ...
        def setScaleFactor(self, scaleFactor: float) -> None: ...

    class QProximityFilter(Qt3DRender.QFrameGraphNode):
        distanceThresholdChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        entityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QProximityFilter.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., distanceThreshold: float = ..., distanceThresholdChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., entity: PySide2.Qt3DCore.Qt3DCore.QEntity = ..., entityChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def distanceThreshold(self) -> float: ...
        def entity(self) -> PySide2.Qt3DCore.Qt3DCore.QEntity: ...
        def setDistanceThreshold(self, distanceThreshold: float) -> None: ...
        def setEntity(self, entity: PySide2.Qt3DCore.Qt3DCore.QEntity) -> None: ...

    class QRayCaster(Qt3DRender.QAbstractRayCaster):
        directionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        lengthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        originChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QRayCaster.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., direction: PySide2.QtGui.QVector3D = ..., directionChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., filterMode: Qt3DRender.QRayCaster.FilterMode = ..., filterModeChanged: typing.Callable = ..., hits: typing.Any = ..., hitsChanged: typing.Callable = ..., isShareable: bool = ..., length: float = ..., lengthChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., origin: PySide2.QtGui.QVector3D = ..., originChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., runMode: Qt3DRender.QRayCaster.RunMode = ..., runModeChanged: typing.Callable = ..., shareableChanged: typing.Callable = ...) -> None: ...
        def direction(self) -> PySide2.QtGui.QVector3D: ...
        def length(self) -> float: ...
        def origin(self) -> PySide2.QtGui.QVector3D: ...
        def setDirection(self, direction: PySide2.QtGui.QVector3D) -> None: ...
        def setLength(self, length: float) -> None: ...
        def setOrigin(self, origin: PySide2.QtGui.QVector3D) -> None: ...
        @typing.overload
        def trigger(self, origin: PySide2.QtGui.QVector3D, direction: PySide2.QtGui.QVector3D, length: float) -> None: ...
        @typing.overload
        def trigger(self) -> None: ...

    class QRayCasterHit(shiboken2.Object):
        class HitType:
            EntityHit: typing.ClassVar[Qt3DRender.QRayCasterHit.HitType] = ...
            LineHit: typing.ClassVar[Qt3DRender.QRayCasterHit.HitType] = ...
            PointHit: typing.ClassVar[Qt3DRender.QRayCasterHit.HitType] = ...
            TriangleHit: typing.ClassVar[Qt3DRender.QRayCasterHit.HitType] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QRayCasterHit.HitType: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QRayCasterHit.HitType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QRayCasterHit.HitType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QRayCasterHit.HitType: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QRayCasterHit.HitType: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QRayCasterHit.HitType: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QRayCasterHit.HitType: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QRayCasterHit.HitType: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QRayCasterHit.HitType: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QRayCasterHit.HitType: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QRayCasterHit.HitType: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QRayCasterHit.HitType: ...
        EntityHit: typing.ClassVar[Qt3DRender.QRayCasterHit.HitType] = ...
        LineHit: typing.ClassVar[Qt3DRender.QRayCasterHit.HitType] = ...
        PointHit: typing.ClassVar[Qt3DRender.QRayCasterHit.HitType] = ...
        TriangleHit: typing.ClassVar[Qt3DRender.QRayCasterHit.HitType] = ...
        @typing.overload
        def __init__(self, type: Qt3DRender.QRayCasterHit.HitType, id: PySide2.Qt3DCore.Qt3DCore.QNodeId, distance: float, localIntersect: PySide2.QtGui.QVector3D, worldIntersect: PySide2.QtGui.QVector3D, primitiveIndex: int, v1: int, v2: int, v3: int) -> None: ...
        @typing.overload
        def __init__(self, other: Qt3DRender.QRayCasterHit) -> None: ...
        @typing.overload
        def __init__(self) -> None: ...
        def distance(self) -> float: ...
        def entity(self) -> PySide2.Qt3DCore.Qt3DCore.QEntity: ...
        def entityId(self) -> PySide2.Qt3DCore.Qt3DCore.QNodeId: ...
        def localIntersection(self) -> PySide2.QtGui.QVector3D: ...
        def primitiveIndex(self) -> int: ...
        def type(self) -> Qt3DRender.QRayCasterHit.HitType: ...
        def vertex1Index(self) -> int: ...
        def vertex2Index(self) -> int: ...
        def vertex3Index(self) -> int: ...
        def worldIntersection(self) -> PySide2.QtGui.QVector3D: ...
        def __copy__(self) -> None: ...

    class QRenderAspect(PySide2.Qt3DCore.Qt3DCore.QAbstractAspect):
        class RenderType:
            Synchronous: typing.ClassVar[Qt3DRender.QRenderAspect.RenderType] = ...
            Threaded: typing.ClassVar[Qt3DRender.QRenderAspect.RenderType] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderAspect.RenderType: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderAspect.RenderType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderAspect.RenderType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderAspect.RenderType: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderAspect.RenderType: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderAspect.RenderType: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderAspect.RenderType: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderAspect.RenderType: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderAspect.RenderType: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderAspect.RenderType: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderAspect.RenderType: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderAspect.RenderType: ...
        Synchronous: typing.ClassVar[Qt3DRender.QRenderAspect.RenderType] = ...
        Threaded: typing.ClassVar[Qt3DRender.QRenderAspect.RenderType] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @typing.overload
        def __init__(self, type: Qt3DRender.QRenderAspect.RenderType, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...

    class QRenderCapabilities(PySide2.QtCore.QObject):
        class API:
            DirectX: typing.ClassVar[Qt3DRender.QRenderCapabilities.API] = ...
            OpenGL: typing.ClassVar[Qt3DRender.QRenderCapabilities.API] = ...
            OpenGLES: typing.ClassVar[Qt3DRender.QRenderCapabilities.API] = ...
            RHI: typing.ClassVar[Qt3DRender.QRenderCapabilities.API] = ...
            Vulkan: typing.ClassVar[Qt3DRender.QRenderCapabilities.API] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderCapabilities.API: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderCapabilities.API: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderCapabilities.API: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderCapabilities.API: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderCapabilities.API: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderCapabilities.API: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderCapabilities.API: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderCapabilities.API: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderCapabilities.API: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderCapabilities.API: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderCapabilities.API: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderCapabilities.API: ...

        class Profile:
            CompatibilityProfile: typing.ClassVar[Qt3DRender.QRenderCapabilities.Profile] = ...
            CoreProfile: typing.ClassVar[Qt3DRender.QRenderCapabilities.Profile] = ...
            NoProfile: typing.ClassVar[Qt3DRender.QRenderCapabilities.Profile] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderCapabilities.Profile: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderCapabilities.Profile: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderCapabilities.Profile: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderCapabilities.Profile: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderCapabilities.Profile: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderCapabilities.Profile: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderCapabilities.Profile: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderCapabilities.Profile: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderCapabilities.Profile: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderCapabilities.Profile: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderCapabilities.Profile: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderCapabilities.Profile: ...
        CompatibilityProfile: typing.ClassVar[Qt3DRender.QRenderCapabilities.Profile] = ...
        CoreProfile: typing.ClassVar[Qt3DRender.QRenderCapabilities.Profile] = ...
        DirectX: typing.ClassVar[Qt3DRender.QRenderCapabilities.API] = ...
        NoProfile: typing.ClassVar[Qt3DRender.QRenderCapabilities.Profile] = ...
        OpenGL: typing.ClassVar[Qt3DRender.QRenderCapabilities.API] = ...
        OpenGLES: typing.ClassVar[Qt3DRender.QRenderCapabilities.API] = ...
        RHI: typing.ClassVar[Qt3DRender.QRenderCapabilities.API] = ...
        Vulkan: typing.ClassVar[Qt3DRender.QRenderCapabilities.API] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., api: Qt3DRender.QRenderCapabilities.API = ..., destroyed: typing.Callable = ..., driverVersion: str = ..., extensions: None = ..., glslVersion: str = ..., majorVersion: int = ..., maxComputeInvocations: int = ..., maxComputeSharedMemorySize: int = ..., maxImageUnits: int = ..., maxSSBOBindings: int = ..., maxSSBOSize: int = ..., maxSamples: int = ..., maxTextureLayers: int = ..., maxTextureSize: int = ..., maxTextureUnits: int = ..., maxUBOBindings: int = ..., maxUBOSize: int = ..., maxWorkGroupCountX: int = ..., maxWorkGroupCountY: int = ..., maxWorkGroupCountZ: int = ..., maxWorkGroupSizeX: int = ..., maxWorkGroupSizeY: int = ..., maxWorkGroupSizeZ: int = ..., minorVersion: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., profile: Qt3DRender.QRenderCapabilities.Profile = ..., renderer: str = ..., supportsCompute: bool = ..., supportsImageStore: bool = ..., supportsSSBO: bool = ..., supportsUBO: bool = ..., valid: bool = ..., vendor: str = ...) -> None: ...
        def api(self) -> Qt3DRender.QRenderCapabilities.API: ...
        def driverVersion(self) -> str: ...
        def extensions(self) -> typing.List[str]: ...
        def glslVersion(self) -> str: ...
        def isValid(self) -> bool: ...
        def majorVersion(self) -> int: ...
        def maxComputeInvocations(self) -> int: ...
        def maxComputeSharedMemorySize(self) -> int: ...
        def maxImageUnits(self) -> int: ...
        def maxSSBOBindings(self) -> int: ...
        def maxSSBOSize(self) -> int: ...
        def maxSamples(self) -> int: ...
        def maxTextureLayers(self) -> int: ...
        def maxTextureSize(self) -> int: ...
        def maxTextureUnits(self) -> int: ...
        def maxUBOBindings(self) -> int: ...
        def maxUBOSize(self) -> int: ...
        def maxWorkGroupCountX(self) -> int: ...
        def maxWorkGroupCountY(self) -> int: ...
        def maxWorkGroupCountZ(self) -> int: ...
        def maxWorkGroupSizeX(self) -> int: ...
        def maxWorkGroupSizeY(self) -> int: ...
        def maxWorkGroupSizeZ(self) -> int: ...
        def minorVersion(self) -> int: ...
        def profile(self) -> Qt3DRender.QRenderCapabilities.Profile: ...
        def renderer(self) -> str: ...
        def supportsCompute(self) -> bool: ...
        def supportsImageStore(self) -> bool: ...
        def supportsSSBO(self) -> bool: ...
        def supportsUBO(self) -> bool: ...
        def vendor(self) -> str: ...

    class QRenderCapture(Qt3DRender.QFrameGraphNode):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QRenderCapture.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def requestCapture(self, rect: PySide2.QtCore.QRect) -> Qt3DRender.QRenderCaptureReply: ...
        @typing.overload
        def requestCapture(self, captureId: int) -> Qt3DRender.QRenderCaptureReply: ...
        @typing.overload
        def requestCapture(self) -> Qt3DRender.QRenderCaptureReply: ...

    class QRenderCaptureReply(PySide2.QtCore.QObject):
        completeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        completed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @classmethod
        def __init__(cls, *args, captureId: int = ..., complete: bool = ..., completeChanged: typing.Callable = ..., completed: typing.Callable = ..., destroyed: typing.Callable = ..., image: PySide2.QtGui.QImage = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., **kwargs) -> None: ...
        def captureId(self) -> int: ...
        def image(self) -> PySide2.QtGui.QImage: ...
        def isComplete(self) -> bool: ...
        def saveImage(self, fileName: str) -> bool: ...
        def saveToFile(self, fileName: str) -> None: ...

    class QRenderPass(PySide2.Qt3DCore.Qt3DCore.QNode):
        shaderProgramChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QRenderPass.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., shaderProgram: Qt3DRender.QShaderProgram = ..., shaderProgramChanged: typing.Callable = ...) -> None: ...
        def addFilterKey(self, filterKey: Qt3DRender.QFilterKey) -> None: ...
        def addParameter(self, p: Qt3DRender.QParameter) -> None: ...
        def addRenderState(self, state: Qt3DRender.QRenderState) -> None: ...
        def filterKeys(self) -> typing.List[Qt3DRender.QFilterKey]: ...
        def parameters(self) -> typing.List[Qt3DRender.QParameter]: ...
        def removeFilterKey(self, filterKey: Qt3DRender.QFilterKey) -> None: ...
        def removeParameter(self, p: Qt3DRender.QParameter) -> None: ...
        def removeRenderState(self, state: Qt3DRender.QRenderState) -> None: ...
        def renderStates(self) -> typing.List[Qt3DRender.QRenderState]: ...
        def setShaderProgram(self, shaderProgram: Qt3DRender.QShaderProgram) -> None: ...
        def shaderProgram(self) -> Qt3DRender.QShaderProgram: ...

    class QRenderPassFilter(Qt3DRender.QFrameGraphNode):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QRenderPassFilter.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def addMatch(self, filterKey: Qt3DRender.QFilterKey) -> None: ...
        def addParameter(self, parameter: Qt3DRender.QParameter) -> None: ...
        def matchAny(self) -> typing.List[Qt3DRender.QFilterKey]: ...
        def parameters(self) -> typing.List[Qt3DRender.QParameter]: ...
        def removeMatch(self, filterKey: Qt3DRender.QFilterKey) -> None: ...
        def removeParameter(self, parameter: Qt3DRender.QParameter) -> None: ...

    class QRenderSettings(PySide2.Qt3DCore.Qt3DCore.QComponent):
        class RenderPolicy:
            Always: typing.ClassVar[Qt3DRender.QRenderSettings.RenderPolicy] = ...
            OnDemand: typing.ClassVar[Qt3DRender.QRenderSettings.RenderPolicy] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderSettings.RenderPolicy: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderSettings.RenderPolicy: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderSettings.RenderPolicy: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderSettings.RenderPolicy: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderSettings.RenderPolicy: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderSettings.RenderPolicy: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderSettings.RenderPolicy: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderSettings.RenderPolicy: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderSettings.RenderPolicy: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderSettings.RenderPolicy: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderSettings.RenderPolicy: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderSettings.RenderPolicy: ...
        Always: typing.ClassVar[Qt3DRender.QRenderSettings.RenderPolicy] = ...
        OnDemand: typing.ClassVar[Qt3DRender.QRenderSettings.RenderPolicy] = ...
        activeFrameGraphChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        renderPolicyChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., activeFrameGraph: Qt3DRender.QFrameGraphNode = ..., activeFrameGraphChanged: typing.Callable = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QRenderSettings.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., pickingSettings: Qt3DRender.QPickingSettings = ..., removedFromEntity: typing.Callable = ..., renderCapabilities: Qt3DRender.QRenderCapabilities = ..., renderPolicy: Qt3DRender.QRenderSettings.RenderPolicy = ..., renderPolicyChanged: typing.Callable = ..., shareableChanged: typing.Callable = ...) -> None: ...
        def activeFrameGraph(self) -> Qt3DRender.QFrameGraphNode: ...
        def pickingSettings(self) -> Qt3DRender.QPickingSettings: ...
        def renderCapabilities(self) -> Qt3DRender.QRenderCapabilities: ...
        def renderPolicy(self) -> Qt3DRender.QRenderSettings.RenderPolicy: ...
        def setActiveFrameGraph(self, activeFrameGraph: Qt3DRender.QFrameGraphNode) -> None: ...
        def setRenderPolicy(self, renderPolicy: Qt3DRender.QRenderSettings.RenderPolicy) -> None: ...

    class QRenderState(PySide2.Qt3DCore.Qt3DCore.QNode):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @classmethod
        def __init__(cls, *args, defaultPropertyTrackingMode: Qt3DRender.QRenderState.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parent: typing.Any = ..., parentChanged: typing.Callable = ..., **kwargs) -> None: ...

    class QRenderStateSet(Qt3DRender.QFrameGraphNode):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QRenderStateSet.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def addRenderState(self, state: Qt3DRender.QRenderState) -> None: ...
        def removeRenderState(self, state: Qt3DRender.QRenderState) -> None: ...
        def renderStates(self) -> typing.List[Qt3DRender.QRenderState]: ...

    class QRenderSurfaceSelector(Qt3DRender.QFrameGraphNode):
        externalRenderTargetSizeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        surfaceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        surfacePixelRatioChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QRenderSurfaceSelector.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., externalRenderTargetSize: PySide2.QtCore.QSize = ..., externalRenderTargetSizeChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., surface: PySide2.QtCore.QObject = ..., surfaceChanged: typing.Callable = ..., surfacePixelRatio: float = ..., surfacePixelRatioChanged: typing.Callable = ...) -> None: ...
        def externalRenderTargetSize(self) -> PySide2.QtCore.QSize: ...
        def setExternalRenderTargetSize(self, size: PySide2.QtCore.QSize) -> None: ...
        def setSurface(self, surfaceObject: PySide2.QtCore.QObject) -> None: ...
        def setSurfacePixelRatio(self, ratio: float) -> None: ...
        def surface(self) -> PySide2.QtCore.QObject: ...
        def surfacePixelRatio(self) -> float: ...

    class QRenderTarget(PySide2.Qt3DCore.Qt3DCore.QComponent):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QRenderTarget.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ...) -> None: ...
        def addOutput(self, output: Qt3DRender.QRenderTargetOutput) -> None: ...
        def outputs(self) -> typing.List[Qt3DRender.QRenderTargetOutput]: ...
        def removeOutput(self, output: Qt3DRender.QRenderTargetOutput) -> None: ...

    class QRenderTargetOutput(PySide2.Qt3DCore.Qt3DCore.QNode):
        class AttachmentPoint:
            Color0: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
            Color1: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
            Color10: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
            Color11: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
            Color12: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
            Color13: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
            Color14: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
            Color15: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
            Color2: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
            Color3: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
            Color4: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
            Color5: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
            Color6: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
            Color7: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
            Color8: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
            Color9: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
            Depth: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
            DepthStencil: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
            Stencil: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderTargetOutput.AttachmentPoint: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderTargetOutput.AttachmentPoint: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderTargetOutput.AttachmentPoint: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderTargetOutput.AttachmentPoint: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderTargetOutput.AttachmentPoint: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderTargetOutput.AttachmentPoint: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderTargetOutput.AttachmentPoint: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderTargetOutput.AttachmentPoint: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderTargetOutput.AttachmentPoint: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderTargetOutput.AttachmentPoint: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderTargetOutput.AttachmentPoint: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QRenderTargetOutput.AttachmentPoint: ...
        Color0: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
        Color1: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
        Color10: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
        Color11: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
        Color12: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
        Color13: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
        Color14: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
        Color15: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
        Color2: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
        Color3: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
        Color4: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
        Color5: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
        Color6: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
        Color7: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
        Color8: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
        Color9: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
        Depth: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
        DepthStencil: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
        Stencil: typing.ClassVar[Qt3DRender.QRenderTargetOutput.AttachmentPoint] = ...
        attachmentPointChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        faceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        layerChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        mipLevelChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        textureChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., attachmentPoint: Qt3DRender.QRenderTargetOutput.AttachmentPoint = ..., attachmentPointChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QRenderTargetOutput.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., face: typing.Any = ..., faceChanged: typing.Callable = ..., layer: int = ..., layerChanged: typing.Callable = ..., mipLevel: int = ..., mipLevelChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., texture: Qt3DRender.QAbstractTexture = ..., textureChanged: typing.Callable = ...) -> None: ...
        def attachmentPoint(self) -> Qt3DRender.QRenderTargetOutput.AttachmentPoint: ...
        def face(self) -> Qt3DRender.QAbstractTexture.CubeMapFace: ...
        def layer(self) -> int: ...
        def mipLevel(self) -> int: ...
        def setAttachmentPoint(self, attachmentPoint: Qt3DRender.QRenderTargetOutput.AttachmentPoint) -> None: ...
        def setFace(self, face: Qt3DRender.QAbstractTexture.CubeMapFace) -> None: ...
        def setLayer(self, layer: int) -> None: ...
        def setMipLevel(self, level: int) -> None: ...
        def setTexture(self, texture: Qt3DRender.QAbstractTexture) -> None: ...
        def texture(self) -> Qt3DRender.QAbstractTexture: ...

    class QRenderTargetSelector(Qt3DRender.QFrameGraphNode):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        targetChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QRenderTargetSelector.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., target: Qt3DRender.QRenderTarget = ..., targetChanged: typing.Callable = ...) -> None: ...
        def outputs(self) -> typing.List[Qt3DRender.QRenderTargetOutput.AttachmentPoint]: ...
        def setOutputs(self, buffers: typing.List[Qt3DRender.QRenderTargetOutput.AttachmentPoint]) -> None: ...
        def setTarget(self, target: Qt3DRender.QRenderTarget) -> None: ...
        def target(self) -> Qt3DRender.QRenderTarget: ...

    class QSceneLoader(PySide2.Qt3DCore.Qt3DCore.QComponent):
        class ComponentType:
            CameraLensComponent: typing.ClassVar[Qt3DRender.QSceneLoader.ComponentType] = ...
            GeometryRendererComponent: typing.ClassVar[Qt3DRender.QSceneLoader.ComponentType] = ...
            LightComponent: typing.ClassVar[Qt3DRender.QSceneLoader.ComponentType] = ...
            MaterialComponent: typing.ClassVar[Qt3DRender.QSceneLoader.ComponentType] = ...
            TransformComponent: typing.ClassVar[Qt3DRender.QSceneLoader.ComponentType] = ...
            UnknownComponent: typing.ClassVar[Qt3DRender.QSceneLoader.ComponentType] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QSceneLoader.ComponentType: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QSceneLoader.ComponentType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QSceneLoader.ComponentType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QSceneLoader.ComponentType: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QSceneLoader.ComponentType: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QSceneLoader.ComponentType: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QSceneLoader.ComponentType: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QSceneLoader.ComponentType: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QSceneLoader.ComponentType: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QSceneLoader.ComponentType: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QSceneLoader.ComponentType: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QSceneLoader.ComponentType: ...

        class Status:
            Error: typing.ClassVar[Qt3DRender.QSceneLoader.Status] = ...
            Loading: typing.ClassVar[Qt3DRender.QSceneLoader.Status] = ...
            None_: typing.ClassVar[Qt3DRender.QSceneLoader.Status] = ...
            Ready: typing.ClassVar[Qt3DRender.QSceneLoader.Status] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QSceneLoader.Status: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QSceneLoader.Status: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QSceneLoader.Status: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QSceneLoader.Status: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QSceneLoader.Status: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QSceneLoader.Status: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QSceneLoader.Status: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QSceneLoader.Status: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QSceneLoader.Status: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QSceneLoader.Status: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QSceneLoader.Status: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QSceneLoader.Status: ...
        CameraLensComponent: typing.ClassVar[Qt3DRender.QSceneLoader.ComponentType] = ...
        Error: typing.ClassVar[Qt3DRender.QSceneLoader.Status] = ...
        GeometryRendererComponent: typing.ClassVar[Qt3DRender.QSceneLoader.ComponentType] = ...
        LightComponent: typing.ClassVar[Qt3DRender.QSceneLoader.ComponentType] = ...
        Loading: typing.ClassVar[Qt3DRender.QSceneLoader.Status] = ...
        MaterialComponent: typing.ClassVar[Qt3DRender.QSceneLoader.ComponentType] = ...
        None_: typing.ClassVar[Qt3DRender.QSceneLoader.Status] = ...
        Ready: typing.ClassVar[Qt3DRender.QSceneLoader.Status] = ...
        TransformComponent: typing.ClassVar[Qt3DRender.QSceneLoader.ComponentType] = ...
        UnknownComponent: typing.ClassVar[Qt3DRender.QSceneLoader.ComponentType] = ...
        sourceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        statusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QSceneLoader.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ..., source: PySide2.QtCore.QUrl = ..., sourceChanged: typing.Callable = ..., status: Qt3DRender.QSceneLoader.Status = ..., statusChanged: typing.Callable = ...) -> None: ...
        def component(self, entityName: str, componentType: Qt3DRender.QSceneLoader.ComponentType) -> PySide2.Qt3DCore.Qt3DCore.QComponent: ...
        def entity(self, entityName: str) -> PySide2.Qt3DCore.Qt3DCore.QEntity: ...
        def entityNames(self) -> typing.List[str]: ...
        def setSource(self, arg: PySide2.QtCore.QUrl) -> None: ...
        def setStatus(self, status: Qt3DRender.QSceneLoader.Status) -> None: ...
        def source(self) -> PySide2.QtCore.QUrl: ...
        def status(self) -> Qt3DRender.QSceneLoader.Status: ...

    class QScissorTest(Qt3DRender.QRenderState):
        bottomChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        heightChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        leftChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        widthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., bottom: int = ..., bottomChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QScissorTest.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., left: int = ..., leftChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., width: int = ..., widthChanged: typing.Callable = ...) -> None: ...
        def bottom(self) -> int: ...
        def height(self) -> int: ...
        def left(self) -> int: ...
        def setBottom(self, bottom: int) -> None: ...
        def setHeight(self, height: int) -> None: ...
        def setLeft(self, left: int) -> None: ...
        def setWidth(self, width: int) -> None: ...
        def width(self) -> int: ...

    class QScreenRayCaster(Qt3DRender.QAbstractRayCaster):
        positionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QScreenRayCaster.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., filterMode: Qt3DRender.QScreenRayCaster.FilterMode = ..., filterModeChanged: typing.Callable = ..., hits: typing.Any = ..., hitsChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., position: PySide2.QtCore.QPoint = ..., positionChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., runMode: Qt3DRender.QScreenRayCaster.RunMode = ..., runModeChanged: typing.Callable = ..., shareableChanged: typing.Callable = ...) -> None: ...
        def position(self) -> PySide2.QtCore.QPoint: ...
        def setPosition(self, position: PySide2.QtCore.QPoint) -> None: ...
        @typing.overload
        def trigger(self, position: PySide2.QtCore.QPoint) -> None: ...
        @typing.overload
        def trigger(self) -> None: ...

    class QSeamlessCubemap(Qt3DRender.QRenderState):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QSeamlessCubemap.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...

    class QSetFence(Qt3DRender.QFrameGraphNode):
        class HandleType:
            NoHandle: typing.ClassVar[Qt3DRender.QSetFence.HandleType] = ...
            OpenGLFenceId: typing.ClassVar[Qt3DRender.QSetFence.HandleType] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QSetFence.HandleType: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QSetFence.HandleType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QSetFence.HandleType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QSetFence.HandleType: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QSetFence.HandleType: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QSetFence.HandleType: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QSetFence.HandleType: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QSetFence.HandleType: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QSetFence.HandleType: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QSetFence.HandleType: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QSetFence.HandleType: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QSetFence.HandleType: ...
        NoHandle: typing.ClassVar[Qt3DRender.QSetFence.HandleType] = ...
        OpenGLFenceId: typing.ClassVar[Qt3DRender.QSetFence.HandleType] = ...
        handleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        handleTypeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QSetFence.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., handle: object = ..., handleChanged: typing.Callable = ..., handleType: Qt3DRender.QSetFence.HandleType = ..., handleTypeChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def handle(self) -> typing.Any: ...
        def handleType(self) -> Qt3DRender.QSetFence.HandleType: ...

    class QShaderData(PySide2.Qt3DCore.Qt3DCore.QComponent):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QShaderData.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ...) -> None: ...
        def event(self, event: PySide2.QtCore.QEvent) -> bool: ...

    class QShaderImage(PySide2.Qt3DCore.Qt3DCore.QNode):
        class Access:
            ReadOnly: typing.ClassVar[Qt3DRender.QShaderImage.Access] = ...
            ReadWrite: typing.ClassVar[Qt3DRender.QShaderImage.Access] = ...
            WriteOnly: typing.ClassVar[Qt3DRender.QShaderImage.Access] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderImage.Access: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderImage.Access: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderImage.Access: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderImage.Access: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderImage.Access: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderImage.Access: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderImage.Access: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderImage.Access: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderImage.Access: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderImage.Access: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderImage.Access: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderImage.Access: ...

        class ImageFormat:
            Automatic: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            NoFormat: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            R16F: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            R16I: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            R16U: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            R16_SNorm: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            R16_UNorm: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            R32F: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            R32I: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            R32U: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            R8I: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            R8U: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            R8_SNorm: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            R8_UNorm: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RG11B10F: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RG16F: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RG16I: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RG16U: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RG16_SNorm: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RG16_UNorm: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RG32F: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RG32I: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RG32U: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RG8I: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RG8U: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RG8_SNorm: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RG8_UNorm: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RGB10A2: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RGB10A2U: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RGBA16F: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RGBA16I: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RGBA16U: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RGBA16_SNorm: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RGBA16_UNorm: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RGBA32F: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RGBA32I: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RGBA32U: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RGBA8I: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RGBA8U: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RGBA8_SNorm: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            RGBA8_UNorm: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderImage.ImageFormat: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderImage.ImageFormat: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderImage.ImageFormat: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderImage.ImageFormat: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderImage.ImageFormat: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderImage.ImageFormat: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderImage.ImageFormat: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderImage.ImageFormat: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderImage.ImageFormat: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderImage.ImageFormat: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderImage.ImageFormat: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderImage.ImageFormat: ...
        Automatic: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        NoFormat: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        R16F: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        R16I: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        R16U: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        R16_SNorm: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        R16_UNorm: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        R32F: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        R32I: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        R32U: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        R8I: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        R8U: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        R8_SNorm: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        R8_UNorm: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RG11B10F: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RG16F: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RG16I: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RG16U: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RG16_SNorm: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RG16_UNorm: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RG32F: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RG32I: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RG32U: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RG8I: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RG8U: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RG8_SNorm: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RG8_UNorm: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RGB10A2: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RGB10A2U: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RGBA16F: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RGBA16I: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RGBA16U: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RGBA16_SNorm: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RGBA16_UNorm: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RGBA32F: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RGBA32I: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RGBA32U: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RGBA8I: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RGBA8U: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RGBA8_SNorm: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        RGBA8_UNorm: typing.ClassVar[Qt3DRender.QShaderImage.ImageFormat] = ...
        ReadOnly: typing.ClassVar[Qt3DRender.QShaderImage.Access] = ...
        ReadWrite: typing.ClassVar[Qt3DRender.QShaderImage.Access] = ...
        WriteOnly: typing.ClassVar[Qt3DRender.QShaderImage.Access] = ...
        accessChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        formatChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        layerChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        layeredChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        mipLevelChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        textureChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., access: Qt3DRender.QShaderImage.Access = ..., accessChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QShaderImage.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., format: Qt3DRender.QShaderImage.ImageFormat = ..., formatChanged: typing.Callable = ..., layer: int = ..., layerChanged: typing.Callable = ..., layered: bool = ..., layeredChanged: typing.Callable = ..., mipLevel: int = ..., mipLevelChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., texture: Qt3DRender.QAbstractTexture = ..., textureChanged: typing.Callable = ...) -> None: ...
        def access(self) -> Qt3DRender.QShaderImage.Access: ...
        def format(self) -> Qt3DRender.QShaderImage.ImageFormat: ...
        def layer(self) -> int: ...
        def layered(self) -> bool: ...
        def mipLevel(self) -> int: ...
        def setAccess(self, access: Qt3DRender.QShaderImage.Access) -> None: ...
        def setFormat(self, format: Qt3DRender.QShaderImage.ImageFormat) -> None: ...
        def setLayer(self, layer: int) -> None: ...
        def setLayered(self, layered: bool) -> None: ...
        def setMipLevel(self, mipLevel: int) -> None: ...
        def setTexture(self, texture: Qt3DRender.QAbstractTexture) -> None: ...
        def texture(self) -> Qt3DRender.QAbstractTexture: ...

    class QShaderProgram(PySide2.Qt3DCore.Qt3DCore.QNode):
        class Format:
            GLSL: typing.ClassVar[Qt3DRender.QShaderProgram.Format] = ...
            SPIRV: typing.ClassVar[Qt3DRender.QShaderProgram.Format] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.Format: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.Format: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.Format: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.Format: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.Format: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.Format: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.Format: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.Format: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.Format: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.Format: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.Format: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.Format: ...

        class ShaderType:
            Compute: typing.ClassVar[Qt3DRender.QShaderProgram.ShaderType] = ...
            Fragment: typing.ClassVar[Qt3DRender.QShaderProgram.ShaderType] = ...
            Geometry: typing.ClassVar[Qt3DRender.QShaderProgram.ShaderType] = ...
            TessellationControl: typing.ClassVar[Qt3DRender.QShaderProgram.ShaderType] = ...
            TessellationEvaluation: typing.ClassVar[Qt3DRender.QShaderProgram.ShaderType] = ...
            Vertex: typing.ClassVar[Qt3DRender.QShaderProgram.ShaderType] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.ShaderType: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.ShaderType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.ShaderType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.ShaderType: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.ShaderType: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.ShaderType: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.ShaderType: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.ShaderType: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.ShaderType: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.ShaderType: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.ShaderType: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.ShaderType: ...

        class Status:
            Error: typing.ClassVar[Qt3DRender.QShaderProgram.Status] = ...
            NotReady: typing.ClassVar[Qt3DRender.QShaderProgram.Status] = ...
            Ready: typing.ClassVar[Qt3DRender.QShaderProgram.Status] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.Status: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.Status: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.Status: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.Status: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.Status: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.Status: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.Status: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.Status: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.Status: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.Status: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.Status: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QShaderProgram.Status: ...
        Compute: typing.ClassVar[Qt3DRender.QShaderProgram.ShaderType] = ...
        Error: typing.ClassVar[Qt3DRender.QShaderProgram.Status] = ...
        Fragment: typing.ClassVar[Qt3DRender.QShaderProgram.ShaderType] = ...
        GLSL: typing.ClassVar[Qt3DRender.QShaderProgram.Format] = ...
        Geometry: typing.ClassVar[Qt3DRender.QShaderProgram.ShaderType] = ...
        NotReady: typing.ClassVar[Qt3DRender.QShaderProgram.Status] = ...
        Ready: typing.ClassVar[Qt3DRender.QShaderProgram.Status] = ...
        SPIRV: typing.ClassVar[Qt3DRender.QShaderProgram.Format] = ...
        TessellationControl: typing.ClassVar[Qt3DRender.QShaderProgram.ShaderType] = ...
        TessellationEvaluation: typing.ClassVar[Qt3DRender.QShaderProgram.ShaderType] = ...
        Vertex: typing.ClassVar[Qt3DRender.QShaderProgram.ShaderType] = ...
        computeShaderCodeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        formatChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        fragmentShaderCodeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        geometryShaderCodeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        logChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        statusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        tessellationControlShaderCodeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        tessellationEvaluationShaderCodeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        vertexShaderCodeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., computeShaderCode: PySide2.QtCore.QByteArray | bytes = ..., computeShaderCodeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QShaderProgram.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., format: Qt3DRender.QShaderProgram.Format = ..., formatChanged: typing.Callable = ..., fragmentShaderCode: PySide2.QtCore.QByteArray | bytes = ..., fragmentShaderCodeChanged: typing.Callable = ..., geometryShaderCode: PySide2.QtCore.QByteArray | bytes = ..., geometryShaderCodeChanged: typing.Callable = ..., log: str = ..., logChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., status: Qt3DRender.QShaderProgram.Status = ..., statusChanged: typing.Callable = ..., tessellationControlShaderCode: PySide2.QtCore.QByteArray | bytes = ..., tessellationControlShaderCodeChanged: typing.Callable = ..., tessellationEvaluationShaderCode: PySide2.QtCore.QByteArray | bytes = ..., tessellationEvaluationShaderCodeChanged: typing.Callable = ..., vertexShaderCode: PySide2.QtCore.QByteArray | bytes = ..., vertexShaderCodeChanged: typing.Callable = ...) -> None: ...
        def computeShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        def format(self) -> Qt3DRender.QShaderProgram.Format: ...
        def fragmentShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        def geometryShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        @staticmethod
        def loadSource(sourceUrl: PySide2.QtCore.QUrl) -> PySide2.QtCore.QByteArray: ...
        def log(self) -> str: ...
        def setComputeShaderCode(self, computeShaderCode: PySide2.QtCore.QByteArray | bytes) -> None: ...
        def setFormat(self, format: Qt3DRender.QShaderProgram.Format) -> None: ...
        def setFragmentShaderCode(self, fragmentShaderCode: PySide2.QtCore.QByteArray | bytes) -> None: ...
        def setGeometryShaderCode(self, geometryShaderCode: PySide2.QtCore.QByteArray | bytes) -> None: ...
        def setShaderCode(self, type: Qt3DRender.QShaderProgram.ShaderType, shaderCode: PySide2.QtCore.QByteArray | bytes) -> None: ...
        def setTessellationControlShaderCode(self, tessellationControlShaderCode: PySide2.QtCore.QByteArray | bytes) -> None: ...
        def setTessellationEvaluationShaderCode(self, tessellationEvaluationShaderCode: PySide2.QtCore.QByteArray | bytes) -> None: ...
        def setVertexShaderCode(self, vertexShaderCode: PySide2.QtCore.QByteArray | bytes) -> None: ...
        def shaderCode(self, type: Qt3DRender.QShaderProgram.ShaderType) -> PySide2.QtCore.QByteArray: ...
        def status(self) -> Qt3DRender.QShaderProgram.Status: ...
        def tessellationControlShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        def tessellationEvaluationShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        def vertexShaderCode(self) -> PySide2.QtCore.QByteArray: ...

    class QShaderProgramBuilder(PySide2.Qt3DCore.Qt3DCore.QNode):
        computeShaderCodeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        computeShaderGraphChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        enabledLayersChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        fragmentShaderCodeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        fragmentShaderGraphChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        geometryShaderCodeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        geometryShaderGraphChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        shaderProgramChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        tessellationControlShaderCodeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        tessellationControlShaderGraphChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        tessellationEvaluationShaderCodeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        tessellationEvaluationShaderGraphChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        vertexShaderCodeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        vertexShaderGraphChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., computeShaderCode: PySide2.QtCore.QByteArray | bytes = ..., computeShaderCodeChanged: typing.Callable = ..., computeShaderGraph: PySide2.QtCore.QUrl = ..., computeShaderGraphChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QShaderProgramBuilder.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., enabledLayers: None = ..., enabledLayersChanged: typing.Callable = ..., fragmentShaderCode: PySide2.QtCore.QByteArray | bytes = ..., fragmentShaderCodeChanged: typing.Callable = ..., fragmentShaderGraph: PySide2.QtCore.QUrl = ..., fragmentShaderGraphChanged: typing.Callable = ..., geometryShaderCode: PySide2.QtCore.QByteArray | bytes = ..., geometryShaderCodeChanged: typing.Callable = ..., geometryShaderGraph: PySide2.QtCore.QUrl = ..., geometryShaderGraphChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., shaderProgram: Qt3DRender.QShaderProgram = ..., shaderProgramChanged: typing.Callable = ..., tessellationControlShaderCode: PySide2.QtCore.QByteArray | bytes = ..., tessellationControlShaderCodeChanged: typing.Callable = ..., tessellationControlShaderGraph: PySide2.QtCore.QUrl = ..., tessellationControlShaderGraphChanged: typing.Callable = ..., tessellationEvaluationShaderCode: PySide2.QtCore.QByteArray | bytes = ..., tessellationEvaluationShaderCodeChanged: typing.Callable = ..., tessellationEvaluationShaderGraph: PySide2.QtCore.QUrl = ..., tessellationEvaluationShaderGraphChanged: typing.Callable = ..., vertexShaderCode: PySide2.QtCore.QByteArray | bytes = ..., vertexShaderCodeChanged: typing.Callable = ..., vertexShaderGraph: PySide2.QtCore.QUrl = ..., vertexShaderGraphChanged: typing.Callable = ...) -> None: ...
        def computeShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        def computeShaderGraph(self) -> PySide2.QtCore.QUrl: ...
        def enabledLayers(self) -> typing.List[str]: ...
        def fragmentShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        def fragmentShaderGraph(self) -> PySide2.QtCore.QUrl: ...
        def geometryShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        def geometryShaderGraph(self) -> PySide2.QtCore.QUrl: ...
        def setComputeShaderGraph(self, computeShaderGraph: PySide2.QtCore.QUrl) -> None: ...
        def setEnabledLayers(self, layers: typing.Iterable[str]) -> None: ...
        def setFragmentShaderGraph(self, fragmentShaderGraph: PySide2.QtCore.QUrl) -> None: ...
        def setGeometryShaderGraph(self, geometryShaderGraph: PySide2.QtCore.QUrl) -> None: ...
        def setShaderProgram(self, program: Qt3DRender.QShaderProgram) -> None: ...
        def setTessellationControlShaderGraph(self, tessellationControlShaderGraph: PySide2.QtCore.QUrl) -> None: ...
        def setTessellationEvaluationShaderGraph(self, tessellationEvaluationShaderGraph: PySide2.QtCore.QUrl) -> None: ...
        def setVertexShaderGraph(self, vertexShaderGraph: PySide2.QtCore.QUrl) -> None: ...
        def shaderProgram(self) -> Qt3DRender.QShaderProgram: ...
        def tessellationControlShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        def tessellationControlShaderGraph(self) -> PySide2.QtCore.QUrl: ...
        def tessellationEvaluationShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        def tessellationEvaluationShaderGraph(self) -> PySide2.QtCore.QUrl: ...
        def vertexShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        def vertexShaderGraph(self) -> PySide2.QtCore.QUrl: ...

    class QSharedGLTexture(Qt3DRender.QAbstractTexture):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        textureIdChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., comparisonFunction: Qt3DRender.QSharedGLTexture.ComparisonFunction = ..., comparisonFunctionChanged: typing.Callable = ..., comparisonMode: Qt3DRender.QSharedGLTexture.ComparisonMode = ..., comparisonModeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QSharedGLTexture.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., depth: int = ..., depthChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., format: Qt3DRender.QSharedGLTexture.TextureFormat = ..., formatChanged: typing.Callable = ..., generateMipMaps: bool = ..., generateMipMapsChanged: typing.Callable = ..., handle: object = ..., handleChanged: typing.Callable = ..., handleType: Qt3DRender.QSharedGLTexture.HandleType = ..., handleTypeChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., layers: int = ..., layersChanged: typing.Callable = ..., magnificationFilter: Qt3DRender.QSharedGLTexture.Filter = ..., magnificationFilterChanged: typing.Callable = ..., maximumAnisotropy: float = ..., maximumAnisotropyChanged: typing.Callable = ..., minificationFilter: Qt3DRender.QSharedGLTexture.Filter = ..., minificationFilterChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., samples: int = ..., samplesChanged: typing.Callable = ..., status: Qt3DRender.QSharedGLTexture.Status = ..., statusChanged: typing.Callable = ..., target: Qt3DRender.QSharedGLTexture.Target = ..., textureId: int = ..., textureIdChanged: typing.Callable = ..., width: int = ..., widthChanged: typing.Callable = ..., wrapMode: typing.Any = ...) -> None: ...
        def setTextureId(self, id: int) -> None: ...
        def textureId(self) -> int: ...

    class QSortPolicy(Qt3DRender.QFrameGraphNode):
        class SortType:
            BackToFront: typing.ClassVar[Qt3DRender.QSortPolicy.SortType] = ...
            FrontToBack: typing.ClassVar[Qt3DRender.QSortPolicy.SortType] = ...
            Material: typing.ClassVar[Qt3DRender.QSortPolicy.SortType] = ...
            StateChangeCost: typing.ClassVar[Qt3DRender.QSortPolicy.SortType] = ...
            Texture: typing.ClassVar[Qt3DRender.QSortPolicy.SortType] = ...
            Uniform: typing.ClassVar[Qt3DRender.QSortPolicy.SortType] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QSortPolicy.SortType: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QSortPolicy.SortType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QSortPolicy.SortType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QSortPolicy.SortType: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QSortPolicy.SortType: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QSortPolicy.SortType: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QSortPolicy.SortType: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QSortPolicy.SortType: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QSortPolicy.SortType: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QSortPolicy.SortType: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QSortPolicy.SortType: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QSortPolicy.SortType: ...
        BackToFront: typing.ClassVar[Qt3DRender.QSortPolicy.SortType] = ...
        FrontToBack: typing.ClassVar[Qt3DRender.QSortPolicy.SortType] = ...
        Material: typing.ClassVar[Qt3DRender.QSortPolicy.SortType] = ...
        StateChangeCost: typing.ClassVar[Qt3DRender.QSortPolicy.SortType] = ...
        Texture: typing.ClassVar[Qt3DRender.QSortPolicy.SortType] = ...
        Uniform: typing.ClassVar[Qt3DRender.QSortPolicy.SortType] = ...
        sortTypesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QSortPolicy.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., sortTypes: typing.List[Qt3DRender.QSortPolicy.SortType] = ..., sortTypesChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def setSortTypes(self, sortTypesInt: typing.List[int]) -> None: ...
        @typing.overload
        def setSortTypes(self, sortTypes: typing.List[Qt3DRender.QSortPolicy.SortType]) -> None: ...
        def sortTypes(self) -> typing.List[Qt3DRender.QSortPolicy.SortType]: ...
        def sortTypesInt(self) -> typing.List[int]: ...

    class QSpotLight(Qt3DRender.QAbstractLight):
        constantAttenuationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        cutOffAngleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        linearAttenuationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        localDirectionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        quadraticAttenuationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., addedToEntity: typing.Callable = ..., color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., colorChanged: typing.Callable = ..., constantAttenuation: float = ..., constantAttenuationChanged: typing.Callable = ..., cutOffAngle: float = ..., cutOffAngleChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QSpotLight.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., intensity: float = ..., intensityChanged: typing.Callable = ..., isShareable: bool = ..., linearAttenuation: float = ..., linearAttenuationChanged: typing.Callable = ..., localDirection: PySide2.QtGui.QVector3D = ..., localDirectionChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., quadraticAttenuation: float = ..., quadraticAttenuationChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ..., type: Qt3DRender.QSpotLight.Type = ...) -> None: ...
        def constantAttenuation(self) -> float: ...
        def cutOffAngle(self) -> float: ...
        def linearAttenuation(self) -> float: ...
        def localDirection(self) -> PySide2.QtGui.QVector3D: ...
        def quadraticAttenuation(self) -> float: ...
        def setConstantAttenuation(self, value: float) -> None: ...
        def setCutOffAngle(self, cutOffAngle: float) -> None: ...
        def setLinearAttenuation(self, value: float) -> None: ...
        def setLocalDirection(self, localDirection: PySide2.QtGui.QVector3D) -> None: ...
        def setQuadraticAttenuation(self, value: float) -> None: ...

    class QStencilMask(Qt3DRender.QRenderState):
        backOutputMaskChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        frontOutputMaskChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., backOutputMask: int = ..., backOutputMaskChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QStencilMask.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., frontOutputMask: int = ..., frontOutputMaskChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def backOutputMask(self) -> int: ...
        def frontOutputMask(self) -> int: ...
        def setBackOutputMask(self, backOutputMask: int) -> None: ...
        def setFrontOutputMask(self, frontOutputMask: int) -> None: ...

    class QStencilOperation(Qt3DRender.QRenderState):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., back: Qt3DRender.QStencilOperationArguments = ..., defaultPropertyTrackingMode: Qt3DRender.QStencilOperation.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., front: Qt3DRender.QStencilOperationArguments = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def back(self) -> Qt3DRender.QStencilOperationArguments: ...
        def front(self) -> Qt3DRender.QStencilOperationArguments: ...

    class QStencilOperationArguments(PySide2.QtCore.QObject):
        class FaceMode:
            Back: typing.ClassVar[Qt3DRender.QStencilOperationArguments.FaceMode] = ...
            Front: typing.ClassVar[Qt3DRender.QStencilOperationArguments.FaceMode] = ...
            FrontAndBack: typing.ClassVar[Qt3DRender.QStencilOperationArguments.FaceMode] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilOperationArguments.FaceMode: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilOperationArguments.FaceMode: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilOperationArguments.FaceMode: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilOperationArguments.FaceMode: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilOperationArguments.FaceMode: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilOperationArguments.FaceMode: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilOperationArguments.FaceMode: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilOperationArguments.FaceMode: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilOperationArguments.FaceMode: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilOperationArguments.FaceMode: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilOperationArguments.FaceMode: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilOperationArguments.FaceMode: ...

        class Operation:
            Decrement: typing.ClassVar[Qt3DRender.QStencilOperationArguments.Operation] = ...
            DecrementWrap: typing.ClassVar[Qt3DRender.QStencilOperationArguments.Operation] = ...
            Increment: typing.ClassVar[Qt3DRender.QStencilOperationArguments.Operation] = ...
            IncrementWrap: typing.ClassVar[Qt3DRender.QStencilOperationArguments.Operation] = ...
            Invert: typing.ClassVar[Qt3DRender.QStencilOperationArguments.Operation] = ...
            Keep: typing.ClassVar[Qt3DRender.QStencilOperationArguments.Operation] = ...
            Replace: typing.ClassVar[Qt3DRender.QStencilOperationArguments.Operation] = ...
            Zero: typing.ClassVar[Qt3DRender.QStencilOperationArguments.Operation] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilOperationArguments.Operation: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilOperationArguments.Operation: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilOperationArguments.Operation: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilOperationArguments.Operation: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilOperationArguments.Operation: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilOperationArguments.Operation: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilOperationArguments.Operation: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilOperationArguments.Operation: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilOperationArguments.Operation: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilOperationArguments.Operation: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilOperationArguments.Operation: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilOperationArguments.Operation: ...
        Back: typing.ClassVar[Qt3DRender.QStencilOperationArguments.FaceMode] = ...
        Decrement: typing.ClassVar[Qt3DRender.QStencilOperationArguments.Operation] = ...
        DecrementWrap: typing.ClassVar[Qt3DRender.QStencilOperationArguments.Operation] = ...
        Front: typing.ClassVar[Qt3DRender.QStencilOperationArguments.FaceMode] = ...
        FrontAndBack: typing.ClassVar[Qt3DRender.QStencilOperationArguments.FaceMode] = ...
        Increment: typing.ClassVar[Qt3DRender.QStencilOperationArguments.Operation] = ...
        IncrementWrap: typing.ClassVar[Qt3DRender.QStencilOperationArguments.Operation] = ...
        Invert: typing.ClassVar[Qt3DRender.QStencilOperationArguments.Operation] = ...
        Keep: typing.ClassVar[Qt3DRender.QStencilOperationArguments.Operation] = ...
        Replace: typing.ClassVar[Qt3DRender.QStencilOperationArguments.Operation] = ...
        Zero: typing.ClassVar[Qt3DRender.QStencilOperationArguments.Operation] = ...
        allTestsPassOperationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        depthTestFailureOperationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        faceModeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        stencilTestFailureOperationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @classmethod
        def __init__(cls, *args, allTestsPassOperation: Qt3DRender.QStencilOperationArguments.Operation = ..., allTestsPassOperationChanged: typing.Callable = ..., depthTestFailureOperation: Qt3DRender.QStencilOperationArguments.Operation = ..., depthTestFailureOperationChanged: typing.Callable = ..., destroyed: typing.Callable = ..., faceMode: Qt3DRender.QStencilOperationArguments.FaceMode = ..., faceModeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., stencilTestFailureOperation: Qt3DRender.QStencilOperationArguments.Operation = ..., stencilTestFailureOperationChanged: typing.Callable = ..., **kwargs) -> None: ...
        def allTestsPassOperation(self) -> Qt3DRender.QStencilOperationArguments.Operation: ...
        def depthTestFailureOperation(self) -> Qt3DRender.QStencilOperationArguments.Operation: ...
        def faceMode(self) -> Qt3DRender.QStencilOperationArguments.FaceMode: ...
        def setAllTestsPassOperation(self, operation: Qt3DRender.QStencilOperationArguments.Operation) -> None: ...
        def setDepthTestFailureOperation(self, operation: Qt3DRender.QStencilOperationArguments.Operation) -> None: ...
        def setStencilTestFailureOperation(self, operation: Qt3DRender.QStencilOperationArguments.Operation) -> None: ...
        def stencilTestFailureOperation(self) -> Qt3DRender.QStencilOperationArguments.Operation: ...

    class QStencilTest(Qt3DRender.QRenderState):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., back: Qt3DRender.QStencilTestArguments = ..., defaultPropertyTrackingMode: Qt3DRender.QStencilTest.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., front: Qt3DRender.QStencilTestArguments = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def back(self) -> Qt3DRender.QStencilTestArguments: ...
        def front(self) -> Qt3DRender.QStencilTestArguments: ...

    class QStencilTestArguments(PySide2.QtCore.QObject):
        class StencilFaceMode:
            Back: typing.ClassVar[Qt3DRender.QStencilTestArguments.StencilFaceMode] = ...
            Front: typing.ClassVar[Qt3DRender.QStencilTestArguments.StencilFaceMode] = ...
            FrontAndBack: typing.ClassVar[Qt3DRender.QStencilTestArguments.StencilFaceMode] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilTestArguments.StencilFaceMode: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilTestArguments.StencilFaceMode: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilTestArguments.StencilFaceMode: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilTestArguments.StencilFaceMode: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilTestArguments.StencilFaceMode: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilTestArguments.StencilFaceMode: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilTestArguments.StencilFaceMode: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilTestArguments.StencilFaceMode: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilTestArguments.StencilFaceMode: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilTestArguments.StencilFaceMode: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilTestArguments.StencilFaceMode: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilTestArguments.StencilFaceMode: ...

        class StencilFunction:
            Always: typing.ClassVar[Qt3DRender.QStencilTestArguments.StencilFunction] = ...
            Equal: typing.ClassVar[Qt3DRender.QStencilTestArguments.StencilFunction] = ...
            Greater: typing.ClassVar[Qt3DRender.QStencilTestArguments.StencilFunction] = ...
            GreaterOrEqual: typing.ClassVar[Qt3DRender.QStencilTestArguments.StencilFunction] = ...
            Less: typing.ClassVar[Qt3DRender.QStencilTestArguments.StencilFunction] = ...
            LessOrEqual: typing.ClassVar[Qt3DRender.QStencilTestArguments.StencilFunction] = ...
            Never: typing.ClassVar[Qt3DRender.QStencilTestArguments.StencilFunction] = ...
            NotEqual: typing.ClassVar[Qt3DRender.QStencilTestArguments.StencilFunction] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilTestArguments.StencilFunction: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilTestArguments.StencilFunction: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilTestArguments.StencilFunction: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilTestArguments.StencilFunction: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilTestArguments.StencilFunction: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilTestArguments.StencilFunction: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilTestArguments.StencilFunction: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilTestArguments.StencilFunction: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilTestArguments.StencilFunction: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilTestArguments.StencilFunction: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilTestArguments.StencilFunction: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QStencilTestArguments.StencilFunction: ...
        Always: typing.ClassVar[Qt3DRender.QStencilTestArguments.StencilFunction] = ...
        Back: typing.ClassVar[Qt3DRender.QStencilTestArguments.StencilFaceMode] = ...
        Equal: typing.ClassVar[Qt3DRender.QStencilTestArguments.StencilFunction] = ...
        Front: typing.ClassVar[Qt3DRender.QStencilTestArguments.StencilFaceMode] = ...
        FrontAndBack: typing.ClassVar[Qt3DRender.QStencilTestArguments.StencilFaceMode] = ...
        Greater: typing.ClassVar[Qt3DRender.QStencilTestArguments.StencilFunction] = ...
        GreaterOrEqual: typing.ClassVar[Qt3DRender.QStencilTestArguments.StencilFunction] = ...
        Less: typing.ClassVar[Qt3DRender.QStencilTestArguments.StencilFunction] = ...
        LessOrEqual: typing.ClassVar[Qt3DRender.QStencilTestArguments.StencilFunction] = ...
        Never: typing.ClassVar[Qt3DRender.QStencilTestArguments.StencilFunction] = ...
        NotEqual: typing.ClassVar[Qt3DRender.QStencilTestArguments.StencilFunction] = ...
        comparisonMaskChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        faceModeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        referenceValueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        stencilFunctionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @classmethod
        def __init__(cls, *args, comparisonMask: int = ..., comparisonMaskChanged: typing.Callable = ..., destroyed: typing.Callable = ..., faceMode: Qt3DRender.QStencilTestArguments.StencilFaceMode = ..., faceModeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., referenceValue: int = ..., referenceValueChanged: typing.Callable = ..., stencilFunction: Qt3DRender.QStencilTestArguments.StencilFunction = ..., stencilFunctionChanged: typing.Callable = ..., **kwargs) -> None: ...
        def comparisonMask(self) -> int: ...
        def faceMode(self) -> Qt3DRender.QStencilTestArguments.StencilFaceMode: ...
        def referenceValue(self) -> int: ...
        def setComparisonMask(self, comparisonMask: int) -> None: ...
        def setReferenceValue(self, referenceValue: int) -> None: ...
        def setStencilFunction(self, stencilFunction: Qt3DRender.QStencilTestArguments.StencilFunction) -> None: ...
        def stencilFunction(self) -> Qt3DRender.QStencilTestArguments.StencilFunction: ...

    class QTechnique(PySide2.Qt3DCore.Qt3DCore.QNode):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QTechnique.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., graphicsApiFilter: Qt3DRender.QGraphicsApiFilter = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def addFilterKey(self, filterKey: Qt3DRender.QFilterKey) -> None: ...
        def addParameter(self, p: Qt3DRender.QParameter) -> None: ...
        def addRenderPass(self, pass_: Qt3DRender.QRenderPass) -> None: ...
        def filterKeys(self) -> typing.List[Qt3DRender.QFilterKey]: ...
        def graphicsApiFilter(self) -> Qt3DRender.QGraphicsApiFilter: ...
        def parameters(self) -> typing.List[Qt3DRender.QParameter]: ...
        def removeFilterKey(self, filterKey: Qt3DRender.QFilterKey) -> None: ...
        def removeParameter(self, p: Qt3DRender.QParameter) -> None: ...
        def removeRenderPass(self, pass_: Qt3DRender.QRenderPass) -> None: ...
        def renderPasses(self) -> typing.List[Qt3DRender.QRenderPass]: ...

    class QTechniqueFilter(Qt3DRender.QFrameGraphNode):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QTechniqueFilter.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def addMatch(self, filterKey: Qt3DRender.QFilterKey) -> None: ...
        def addParameter(self, p: Qt3DRender.QParameter) -> None: ...
        def matchAll(self) -> typing.List[Qt3DRender.QFilterKey]: ...
        def parameters(self) -> typing.List[Qt3DRender.QParameter]: ...
        def removeMatch(self, filterKey: Qt3DRender.QFilterKey) -> None: ...
        def removeParameter(self, p: Qt3DRender.QParameter) -> None: ...

    class QTexture1D(Qt3DRender.QAbstractTexture):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., comparisonFunction: Qt3DRender.QTexture1D.ComparisonFunction = ..., comparisonFunctionChanged: typing.Callable = ..., comparisonMode: Qt3DRender.QTexture1D.ComparisonMode = ..., comparisonModeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QTexture1D.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., depth: int = ..., depthChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., format: Qt3DRender.QTexture1D.TextureFormat = ..., formatChanged: typing.Callable = ..., generateMipMaps: bool = ..., generateMipMapsChanged: typing.Callable = ..., handle: object = ..., handleChanged: typing.Callable = ..., handleType: Qt3DRender.QTexture1D.HandleType = ..., handleTypeChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., layers: int = ..., layersChanged: typing.Callable = ..., magnificationFilter: Qt3DRender.QTexture1D.Filter = ..., magnificationFilterChanged: typing.Callable = ..., maximumAnisotropy: float = ..., maximumAnisotropyChanged: typing.Callable = ..., minificationFilter: Qt3DRender.QTexture1D.Filter = ..., minificationFilterChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., samples: int = ..., samplesChanged: typing.Callable = ..., status: Qt3DRender.QTexture1D.Status = ..., statusChanged: typing.Callable = ..., target: Qt3DRender.QTexture1D.Target = ..., width: int = ..., widthChanged: typing.Callable = ..., wrapMode: typing.Any = ...) -> None: ...

    class QTexture1DArray(Qt3DRender.QAbstractTexture):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., comparisonFunction: Qt3DRender.QTexture1DArray.ComparisonFunction = ..., comparisonFunctionChanged: typing.Callable = ..., comparisonMode: Qt3DRender.QTexture1DArray.ComparisonMode = ..., comparisonModeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QTexture1DArray.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., depth: int = ..., depthChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., format: Qt3DRender.QTexture1DArray.TextureFormat = ..., formatChanged: typing.Callable = ..., generateMipMaps: bool = ..., generateMipMapsChanged: typing.Callable = ..., handle: object = ..., handleChanged: typing.Callable = ..., handleType: Qt3DRender.QTexture1DArray.HandleType = ..., handleTypeChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., layers: int = ..., layersChanged: typing.Callable = ..., magnificationFilter: Qt3DRender.QTexture1DArray.Filter = ..., magnificationFilterChanged: typing.Callable = ..., maximumAnisotropy: float = ..., maximumAnisotropyChanged: typing.Callable = ..., minificationFilter: Qt3DRender.QTexture1DArray.Filter = ..., minificationFilterChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., samples: int = ..., samplesChanged: typing.Callable = ..., status: Qt3DRender.QTexture1DArray.Status = ..., statusChanged: typing.Callable = ..., target: Qt3DRender.QTexture1DArray.Target = ..., width: int = ..., widthChanged: typing.Callable = ..., wrapMode: typing.Any = ...) -> None: ...

    class QTexture2D(Qt3DRender.QAbstractTexture):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., comparisonFunction: Qt3DRender.QTexture2D.ComparisonFunction = ..., comparisonFunctionChanged: typing.Callable = ..., comparisonMode: Qt3DRender.QTexture2D.ComparisonMode = ..., comparisonModeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QTexture2D.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., depth: int = ..., depthChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., format: Qt3DRender.QTexture2D.TextureFormat = ..., formatChanged: typing.Callable = ..., generateMipMaps: bool = ..., generateMipMapsChanged: typing.Callable = ..., handle: object = ..., handleChanged: typing.Callable = ..., handleType: Qt3DRender.QTexture2D.HandleType = ..., handleTypeChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., layers: int = ..., layersChanged: typing.Callable = ..., magnificationFilter: Qt3DRender.QTexture2D.Filter = ..., magnificationFilterChanged: typing.Callable = ..., maximumAnisotropy: float = ..., maximumAnisotropyChanged: typing.Callable = ..., minificationFilter: Qt3DRender.QTexture2D.Filter = ..., minificationFilterChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., samples: int = ..., samplesChanged: typing.Callable = ..., status: Qt3DRender.QTexture2D.Status = ..., statusChanged: typing.Callable = ..., target: Qt3DRender.QTexture2D.Target = ..., width: int = ..., widthChanged: typing.Callable = ..., wrapMode: typing.Any = ...) -> None: ...

    class QTexture2DArray(Qt3DRender.QAbstractTexture):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., comparisonFunction: Qt3DRender.QTexture2DArray.ComparisonFunction = ..., comparisonFunctionChanged: typing.Callable = ..., comparisonMode: Qt3DRender.QTexture2DArray.ComparisonMode = ..., comparisonModeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QTexture2DArray.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., depth: int = ..., depthChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., format: Qt3DRender.QTexture2DArray.TextureFormat = ..., formatChanged: typing.Callable = ..., generateMipMaps: bool = ..., generateMipMapsChanged: typing.Callable = ..., handle: object = ..., handleChanged: typing.Callable = ..., handleType: Qt3DRender.QTexture2DArray.HandleType = ..., handleTypeChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., layers: int = ..., layersChanged: typing.Callable = ..., magnificationFilter: Qt3DRender.QTexture2DArray.Filter = ..., magnificationFilterChanged: typing.Callable = ..., maximumAnisotropy: float = ..., maximumAnisotropyChanged: typing.Callable = ..., minificationFilter: Qt3DRender.QTexture2DArray.Filter = ..., minificationFilterChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., samples: int = ..., samplesChanged: typing.Callable = ..., status: Qt3DRender.QTexture2DArray.Status = ..., statusChanged: typing.Callable = ..., target: Qt3DRender.QTexture2DArray.Target = ..., width: int = ..., widthChanged: typing.Callable = ..., wrapMode: typing.Any = ...) -> None: ...

    class QTexture2DMultisample(Qt3DRender.QAbstractTexture):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., comparisonFunction: Qt3DRender.QTexture2DMultisample.ComparisonFunction = ..., comparisonFunctionChanged: typing.Callable = ..., comparisonMode: Qt3DRender.QTexture2DMultisample.ComparisonMode = ..., comparisonModeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QTexture2DMultisample.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., depth: int = ..., depthChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., format: Qt3DRender.QTexture2DMultisample.TextureFormat = ..., formatChanged: typing.Callable = ..., generateMipMaps: bool = ..., generateMipMapsChanged: typing.Callable = ..., handle: object = ..., handleChanged: typing.Callable = ..., handleType: Qt3DRender.QTexture2DMultisample.HandleType = ..., handleTypeChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., layers: int = ..., layersChanged: typing.Callable = ..., magnificationFilter: Qt3DRender.QTexture2DMultisample.Filter = ..., magnificationFilterChanged: typing.Callable = ..., maximumAnisotropy: float = ..., maximumAnisotropyChanged: typing.Callable = ..., minificationFilter: Qt3DRender.QTexture2DMultisample.Filter = ..., minificationFilterChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., samples: int = ..., samplesChanged: typing.Callable = ..., status: Qt3DRender.QTexture2DMultisample.Status = ..., statusChanged: typing.Callable = ..., target: Qt3DRender.QTexture2DMultisample.Target = ..., width: int = ..., widthChanged: typing.Callable = ..., wrapMode: typing.Any = ...) -> None: ...

    class QTexture2DMultisampleArray(Qt3DRender.QAbstractTexture):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., comparisonFunction: Qt3DRender.QTexture2DMultisampleArray.ComparisonFunction = ..., comparisonFunctionChanged: typing.Callable = ..., comparisonMode: Qt3DRender.QTexture2DMultisampleArray.ComparisonMode = ..., comparisonModeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QTexture2DMultisampleArray.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., depth: int = ..., depthChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., format: Qt3DRender.QTexture2DMultisampleArray.TextureFormat = ..., formatChanged: typing.Callable = ..., generateMipMaps: bool = ..., generateMipMapsChanged: typing.Callable = ..., handle: object = ..., handleChanged: typing.Callable = ..., handleType: Qt3DRender.QTexture2DMultisampleArray.HandleType = ..., handleTypeChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., layers: int = ..., layersChanged: typing.Callable = ..., magnificationFilter: Qt3DRender.QTexture2DMultisampleArray.Filter = ..., magnificationFilterChanged: typing.Callable = ..., maximumAnisotropy: float = ..., maximumAnisotropyChanged: typing.Callable = ..., minificationFilter: Qt3DRender.QTexture2DMultisampleArray.Filter = ..., minificationFilterChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., samples: int = ..., samplesChanged: typing.Callable = ..., status: Qt3DRender.QTexture2DMultisampleArray.Status = ..., statusChanged: typing.Callable = ..., target: Qt3DRender.QTexture2DMultisampleArray.Target = ..., width: int = ..., widthChanged: typing.Callable = ..., wrapMode: typing.Any = ...) -> None: ...

    class QTexture3D(Qt3DRender.QAbstractTexture):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., comparisonFunction: Qt3DRender.QTexture3D.ComparisonFunction = ..., comparisonFunctionChanged: typing.Callable = ..., comparisonMode: Qt3DRender.QTexture3D.ComparisonMode = ..., comparisonModeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QTexture3D.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., depth: int = ..., depthChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., format: Qt3DRender.QTexture3D.TextureFormat = ..., formatChanged: typing.Callable = ..., generateMipMaps: bool = ..., generateMipMapsChanged: typing.Callable = ..., handle: object = ..., handleChanged: typing.Callable = ..., handleType: Qt3DRender.QTexture3D.HandleType = ..., handleTypeChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., layers: int = ..., layersChanged: typing.Callable = ..., magnificationFilter: Qt3DRender.QTexture3D.Filter = ..., magnificationFilterChanged: typing.Callable = ..., maximumAnisotropy: float = ..., maximumAnisotropyChanged: typing.Callable = ..., minificationFilter: Qt3DRender.QTexture3D.Filter = ..., minificationFilterChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., samples: int = ..., samplesChanged: typing.Callable = ..., status: Qt3DRender.QTexture3D.Status = ..., statusChanged: typing.Callable = ..., target: Qt3DRender.QTexture3D.Target = ..., width: int = ..., widthChanged: typing.Callable = ..., wrapMode: typing.Any = ...) -> None: ...

    class QTextureBuffer(Qt3DRender.QAbstractTexture):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., comparisonFunction: Qt3DRender.QTextureBuffer.ComparisonFunction = ..., comparisonFunctionChanged: typing.Callable = ..., comparisonMode: Qt3DRender.QTextureBuffer.ComparisonMode = ..., comparisonModeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QTextureBuffer.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., depth: int = ..., depthChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., format: Qt3DRender.QTextureBuffer.TextureFormat = ..., formatChanged: typing.Callable = ..., generateMipMaps: bool = ..., generateMipMapsChanged: typing.Callable = ..., handle: object = ..., handleChanged: typing.Callable = ..., handleType: Qt3DRender.QTextureBuffer.HandleType = ..., handleTypeChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., layers: int = ..., layersChanged: typing.Callable = ..., magnificationFilter: Qt3DRender.QTextureBuffer.Filter = ..., magnificationFilterChanged: typing.Callable = ..., maximumAnisotropy: float = ..., maximumAnisotropyChanged: typing.Callable = ..., minificationFilter: Qt3DRender.QTextureBuffer.Filter = ..., minificationFilterChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., samples: int = ..., samplesChanged: typing.Callable = ..., status: Qt3DRender.QTextureBuffer.Status = ..., statusChanged: typing.Callable = ..., target: Qt3DRender.QTextureBuffer.Target = ..., width: int = ..., widthChanged: typing.Callable = ..., wrapMode: typing.Any = ...) -> None: ...

    class QTextureCubeMap(Qt3DRender.QAbstractTexture):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., comparisonFunction: Qt3DRender.QTextureCubeMap.ComparisonFunction = ..., comparisonFunctionChanged: typing.Callable = ..., comparisonMode: Qt3DRender.QTextureCubeMap.ComparisonMode = ..., comparisonModeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QTextureCubeMap.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., depth: int = ..., depthChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., format: Qt3DRender.QTextureCubeMap.TextureFormat = ..., formatChanged: typing.Callable = ..., generateMipMaps: bool = ..., generateMipMapsChanged: typing.Callable = ..., handle: object = ..., handleChanged: typing.Callable = ..., handleType: Qt3DRender.QTextureCubeMap.HandleType = ..., handleTypeChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., layers: int = ..., layersChanged: typing.Callable = ..., magnificationFilter: Qt3DRender.QTextureCubeMap.Filter = ..., magnificationFilterChanged: typing.Callable = ..., maximumAnisotropy: float = ..., maximumAnisotropyChanged: typing.Callable = ..., minificationFilter: Qt3DRender.QTextureCubeMap.Filter = ..., minificationFilterChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., samples: int = ..., samplesChanged: typing.Callable = ..., status: Qt3DRender.QTextureCubeMap.Status = ..., statusChanged: typing.Callable = ..., target: Qt3DRender.QTextureCubeMap.Target = ..., width: int = ..., widthChanged: typing.Callable = ..., wrapMode: typing.Any = ...) -> None: ...

    class QTextureCubeMapArray(Qt3DRender.QAbstractTexture):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., comparisonFunction: Qt3DRender.QTextureCubeMapArray.ComparisonFunction = ..., comparisonFunctionChanged: typing.Callable = ..., comparisonMode: Qt3DRender.QTextureCubeMapArray.ComparisonMode = ..., comparisonModeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QTextureCubeMapArray.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., depth: int = ..., depthChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., format: Qt3DRender.QTextureCubeMapArray.TextureFormat = ..., formatChanged: typing.Callable = ..., generateMipMaps: bool = ..., generateMipMapsChanged: typing.Callable = ..., handle: object = ..., handleChanged: typing.Callable = ..., handleType: Qt3DRender.QTextureCubeMapArray.HandleType = ..., handleTypeChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., layers: int = ..., layersChanged: typing.Callable = ..., magnificationFilter: Qt3DRender.QTextureCubeMapArray.Filter = ..., magnificationFilterChanged: typing.Callable = ..., maximumAnisotropy: float = ..., maximumAnisotropyChanged: typing.Callable = ..., minificationFilter: Qt3DRender.QTextureCubeMapArray.Filter = ..., minificationFilterChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., samples: int = ..., samplesChanged: typing.Callable = ..., status: Qt3DRender.QTextureCubeMapArray.Status = ..., statusChanged: typing.Callable = ..., target: Qt3DRender.QTextureCubeMapArray.Target = ..., width: int = ..., widthChanged: typing.Callable = ..., wrapMode: typing.Any = ...) -> None: ...

    class QTextureData(shiboken2.Object):
        def __init__(self) -> None: ...
        def comparisonFunction(self) -> Qt3DRender.QAbstractTexture.ComparisonFunction: ...
        def comparisonMode(self) -> Qt3DRender.QAbstractTexture.ComparisonMode: ...
        def depth(self) -> int: ...
        def format(self) -> Qt3DRender.QAbstractTexture.TextureFormat: ...
        def height(self) -> int: ...
        def isAutoMipMapGenerationEnabled(self) -> bool: ...
        def layers(self) -> int: ...
        def magnificationFilter(self) -> Qt3DRender.QAbstractTexture.Filter: ...
        def maximumAnisotropy(self) -> float: ...
        def minificationFilter(self) -> Qt3DRender.QAbstractTexture.Filter: ...
        def setAutoMipMapGenerationEnabled(self, isAutoMipMapGenerationEnabled: bool) -> None: ...
        def setComparisonFunction(self, comparisonFunction: Qt3DRender.QAbstractTexture.ComparisonFunction) -> None: ...
        def setComparisonMode(self, comparisonMode: Qt3DRender.QAbstractTexture.ComparisonMode) -> None: ...
        def setDepth(self, depth: int) -> None: ...
        def setFormat(self, arg__1: Qt3DRender.QAbstractTexture.TextureFormat) -> None: ...
        def setHeight(self, height: int) -> None: ...
        def setLayers(self, layers: int) -> None: ...
        def setMagnificationFilter(self, filter: Qt3DRender.QAbstractTexture.Filter) -> None: ...
        def setMaximumAnisotropy(self, maximumAnisotropy: float) -> None: ...
        def setMinificationFilter(self, filter: Qt3DRender.QAbstractTexture.Filter) -> None: ...
        def setTarget(self, target: Qt3DRender.QAbstractTexture.Target) -> None: ...
        def setWidth(self, width: int) -> None: ...
        def setWrapModeX(self, wrapModeX: Qt3DRender.QTextureWrapMode.WrapMode) -> None: ...
        def setWrapModeY(self, wrapModeY: Qt3DRender.QTextureWrapMode.WrapMode) -> None: ...
        def setWrapModeZ(self, wrapModeZ: Qt3DRender.QTextureWrapMode.WrapMode) -> None: ...
        def target(self) -> Qt3DRender.QAbstractTexture.Target: ...
        def width(self) -> int: ...
        def wrapModeX(self) -> Qt3DRender.QTextureWrapMode.WrapMode: ...
        def wrapModeY(self) -> Qt3DRender.QTextureWrapMode.WrapMode: ...
        def wrapModeZ(self) -> Qt3DRender.QTextureWrapMode.WrapMode: ...

    class QTextureGenerator(Qt3DRender.QAbstractFunctor):
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...

    class QTextureImage(Qt3DRender.QAbstractTextureImage):
        class Status:
            Error: typing.ClassVar[Qt3DRender.QTextureImage.Status] = ...
            Loading: typing.ClassVar[Qt3DRender.QTextureImage.Status] = ...
            None_: typing.ClassVar[Qt3DRender.QTextureImage.Status] = ...
            Ready: typing.ClassVar[Qt3DRender.QTextureImage.Status] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QTextureImage.Status: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QTextureImage.Status: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QTextureImage.Status: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QTextureImage.Status: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QTextureImage.Status: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QTextureImage.Status: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QTextureImage.Status: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QTextureImage.Status: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QTextureImage.Status: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QTextureImage.Status: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QTextureImage.Status: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QTextureImage.Status: ...
        Error: typing.ClassVar[Qt3DRender.QTextureImage.Status] = ...
        Loading: typing.ClassVar[Qt3DRender.QTextureImage.Status] = ...
        None_: typing.ClassVar[Qt3DRender.QTextureImage.Status] = ...
        Ready: typing.ClassVar[Qt3DRender.QTextureImage.Status] = ...
        mirroredChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sourceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        statusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QTextureImage.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., face: typing.Any = ..., faceChanged: typing.Callable = ..., layer: int = ..., layerChanged: typing.Callable = ..., mipLevel: int = ..., mipLevelChanged: typing.Callable = ..., mirrored: bool = ..., mirroredChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., source: PySide2.QtCore.QUrl = ..., sourceChanged: typing.Callable = ..., status: Qt3DRender.QTextureImage.Status = ..., statusChanged: typing.Callable = ...) -> None: ...
        def isMirrored(self) -> bool: ...
        def setMirrored(self, mirrored: bool) -> None: ...
        def setSource(self, source: PySide2.QtCore.QUrl) -> None: ...
        def setStatus(self, status: Qt3DRender.QTextureImage.Status) -> None: ...
        def source(self) -> PySide2.QtCore.QUrl: ...
        def status(self) -> Qt3DRender.QTextureImage.Status: ...

    class QTextureImageData(shiboken2.Object):
        def __init__(self) -> None: ...
        def cleanup(self) -> None: ...
        def data(self, layer: int = ..., face: int = ..., mipmapLevel: int = ...) -> PySide2.QtCore.QByteArray: ...
        def depth(self) -> int: ...
        def faces(self) -> int: ...
        def format(self) -> PySide2.QtGui.QOpenGLTexture.TextureFormat: ...
        def height(self) -> int: ...
        def isCompressed(self) -> bool: ...
        def layers(self) -> int: ...
        def mipLevels(self) -> int: ...
        def pixelFormat(self) -> PySide2.QtGui.QOpenGLTexture.PixelFormat: ...
        def pixelType(self) -> PySide2.QtGui.QOpenGLTexture.PixelType: ...
        def setData(self, data: PySide2.QtCore.QByteArray | bytes, blockSize: int, isCompressed: bool = ...) -> None: ...
        def setDepth(self, depth: int) -> None: ...
        def setFaces(self, faces: int) -> None: ...
        def setFormat(self, format: PySide2.QtGui.QOpenGLTexture.TextureFormat) -> None: ...
        def setHeight(self, height: int) -> None: ...
        def setImage(self, arg__1: PySide2.QtGui.QImage) -> None: ...
        def setLayers(self, layers: int) -> None: ...
        def setMipLevels(self, mipLevels: int) -> None: ...
        def setPixelFormat(self, pixelFormat: PySide2.QtGui.QOpenGLTexture.PixelFormat) -> None: ...
        def setPixelType(self, pixelType: PySide2.QtGui.QOpenGLTexture.PixelType) -> None: ...
        def setTarget(self, target: PySide2.QtGui.QOpenGLTexture.Target) -> None: ...
        def setWidth(self, width: int) -> None: ...
        def target(self) -> PySide2.QtGui.QOpenGLTexture.Target: ...
        def width(self) -> int: ...

    class QTextureImageDataGenerator(Qt3DRender.QAbstractFunctor):
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...

    class QTextureLoader(Qt3DRender.QAbstractTexture):
        mirroredChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sourceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., comparisonFunction: Qt3DRender.QTextureLoader.ComparisonFunction = ..., comparisonFunctionChanged: typing.Callable = ..., comparisonMode: Qt3DRender.QTextureLoader.ComparisonMode = ..., comparisonModeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QTextureLoader.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., depth: int = ..., depthChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., format: Qt3DRender.QTextureLoader.TextureFormat = ..., formatChanged: typing.Callable = ..., generateMipMaps: bool = ..., generateMipMapsChanged: typing.Callable = ..., handle: object = ..., handleChanged: typing.Callable = ..., handleType: Qt3DRender.QTextureLoader.HandleType = ..., handleTypeChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., layers: int = ..., layersChanged: typing.Callable = ..., magnificationFilter: Qt3DRender.QTextureLoader.Filter = ..., magnificationFilterChanged: typing.Callable = ..., maximumAnisotropy: float = ..., maximumAnisotropyChanged: typing.Callable = ..., minificationFilter: Qt3DRender.QTextureLoader.Filter = ..., minificationFilterChanged: typing.Callable = ..., mirrored: bool = ..., mirroredChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., samples: int = ..., samplesChanged: typing.Callable = ..., source: PySide2.QtCore.QUrl = ..., sourceChanged: typing.Callable = ..., status: Qt3DRender.QTextureLoader.Status = ..., statusChanged: typing.Callable = ..., target: Qt3DRender.QTextureLoader.Target = ..., width: int = ..., widthChanged: typing.Callable = ..., wrapMode: typing.Any = ...) -> None: ...
        def isMirrored(self) -> bool: ...
        def setMirrored(self, mirrored: bool) -> None: ...
        def setSource(self, source: PySide2.QtCore.QUrl) -> None: ...
        def source(self) -> PySide2.QtCore.QUrl: ...

    class QTextureRectangle(Qt3DRender.QAbstractTexture):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., comparisonFunction: Qt3DRender.QTextureRectangle.ComparisonFunction = ..., comparisonFunctionChanged: typing.Callable = ..., comparisonMode: Qt3DRender.QTextureRectangle.ComparisonMode = ..., comparisonModeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DRender.QTextureRectangle.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., depth: int = ..., depthChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., format: Qt3DRender.QTextureRectangle.TextureFormat = ..., formatChanged: typing.Callable = ..., generateMipMaps: bool = ..., generateMipMapsChanged: typing.Callable = ..., handle: object = ..., handleChanged: typing.Callable = ..., handleType: Qt3DRender.QTextureRectangle.HandleType = ..., handleTypeChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., layers: int = ..., layersChanged: typing.Callable = ..., magnificationFilter: Qt3DRender.QTextureRectangle.Filter = ..., magnificationFilterChanged: typing.Callable = ..., maximumAnisotropy: float = ..., maximumAnisotropyChanged: typing.Callable = ..., minificationFilter: Qt3DRender.QTextureRectangle.Filter = ..., minificationFilterChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., samples: int = ..., samplesChanged: typing.Callable = ..., status: Qt3DRender.QTextureRectangle.Status = ..., statusChanged: typing.Callable = ..., target: Qt3DRender.QTextureRectangle.Target = ..., width: int = ..., widthChanged: typing.Callable = ..., wrapMode: typing.Any = ...) -> None: ...

    class QTextureWrapMode(PySide2.QtCore.QObject):
        class WrapMode:
            ClampToBorder: typing.ClassVar[Qt3DRender.QTextureWrapMode.WrapMode] = ...
            ClampToEdge: typing.ClassVar[Qt3DRender.QTextureWrapMode.WrapMode] = ...
            MirroredRepeat: typing.ClassVar[Qt3DRender.QTextureWrapMode.WrapMode] = ...
            Repeat: typing.ClassVar[Qt3DRender.QTextureWrapMode.WrapMode] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QTextureWrapMode.WrapMode: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QTextureWrapMode.WrapMode: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QTextureWrapMode.WrapMode: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QTextureWrapMode.WrapMode: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QTextureWrapMode.WrapMode: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QTextureWrapMode.WrapMode: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QTextureWrapMode.WrapMode: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QTextureWrapMode.WrapMode: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QTextureWrapMode.WrapMode: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QTextureWrapMode.WrapMode: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QTextureWrapMode.WrapMode: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QTextureWrapMode.WrapMode: ...
        ClampToBorder: typing.ClassVar[Qt3DRender.QTextureWrapMode.WrapMode] = ...
        ClampToEdge: typing.ClassVar[Qt3DRender.QTextureWrapMode.WrapMode] = ...
        MirroredRepeat: typing.ClassVar[Qt3DRender.QTextureWrapMode.WrapMode] = ...
        Repeat: typing.ClassVar[Qt3DRender.QTextureWrapMode.WrapMode] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        xChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        yChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        zChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @typing.overload
        def __init__(self, x: Qt3DRender.QTextureWrapMode.WrapMode, y: Qt3DRender.QTextureWrapMode.WrapMode, z: Qt3DRender.QTextureWrapMode.WrapMode, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., xChanged: typing.Callable = ..., yChanged: typing.Callable = ..., zChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, wrapMode: Qt3DRender.QTextureWrapMode.WrapMode = ..., parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., x: Qt3DRender.QTextureWrapMode.WrapMode = ..., xChanged: typing.Callable = ..., y: Qt3DRender.QTextureWrapMode.WrapMode = ..., yChanged: typing.Callable = ..., z: Qt3DRender.QTextureWrapMode.WrapMode = ..., zChanged: typing.Callable = ...) -> None: ...
        def setX(self, x: Qt3DRender.QTextureWrapMode.WrapMode) -> None: ...
        def setY(self, y: Qt3DRender.QTextureWrapMode.WrapMode) -> None: ...
        def setZ(self, z: Qt3DRender.QTextureWrapMode.WrapMode) -> None: ...
        def x(self) -> Qt3DRender.QTextureWrapMode.WrapMode: ...
        def y(self) -> Qt3DRender.QTextureWrapMode.WrapMode: ...
        def z(self) -> Qt3DRender.QTextureWrapMode.WrapMode: ...

    class QViewport(Qt3DRender.QFrameGraphNode):
        gammaChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        normalizedRectChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QViewport.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., gamma: float = ..., gammaChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., normalizedRect: PySide2.QtCore.QRectF = ..., normalizedRectChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def gamma(self) -> float: ...
        def normalizedRect(self) -> PySide2.QtCore.QRectF: ...
        def setGamma(self, gamma: float) -> None: ...
        def setNormalizedRect(self, normalizedRect: PySide2.QtCore.QRectF) -> None: ...

    class QWaitFence(Qt3DRender.QFrameGraphNode):
        class HandleType:
            NoHandle: typing.ClassVar[Qt3DRender.QWaitFence.HandleType] = ...
            OpenGLFenceId: typing.ClassVar[Qt3DRender.QWaitFence.HandleType] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DRender.QWaitFence.HandleType: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DRender.QWaitFence.HandleType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DRender.QWaitFence.HandleType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DRender.QWaitFence.HandleType: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DRender.QWaitFence.HandleType: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DRender.QWaitFence.HandleType: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DRender.QWaitFence.HandleType: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DRender.QWaitFence.HandleType: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DRender.QWaitFence.HandleType: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DRender.QWaitFence.HandleType: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DRender.QWaitFence.HandleType: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DRender.QWaitFence.HandleType: ...
        NoHandle: typing.ClassVar[Qt3DRender.QWaitFence.HandleType] = ...
        OpenGLFenceId: typing.ClassVar[Qt3DRender.QWaitFence.HandleType] = ...
        handleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        handleTypeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        timeoutChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        waitOnCPUChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode | None = ..., defaultPropertyTrackingMode: Qt3DRender.QWaitFence.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., handle: object = ..., handleChanged: typing.Callable = ..., handleType: Qt3DRender.QWaitFence.HandleType = ..., handleTypeChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., timeout: int = ..., timeoutChanged: typing.Callable = ..., waitOnCPU: bool = ..., waitOnCPUChanged: typing.Callable = ...) -> None: ...
        def handle(self) -> typing.Any: ...
        def handleType(self) -> Qt3DRender.QWaitFence.HandleType: ...
        def setHandle(self, handle: typing.Any) -> None: ...
        def setHandleType(self, type: Qt3DRender.QWaitFence.HandleType) -> None: ...
        def setTimeout(self, timeout: int) -> None: ...
        def setWaitOnCPU(self, waitOnCPU: bool) -> None: ...
        def timeout(self) -> int: ...
        def waitOnCPU(self) -> bool: ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
