import PySide2.QtCore
import PySide2.QtGui
import _typeshed
import collections
import shiboken2
import typing
T = typing.TypeVar('T')
import typing_extensions

class QtDataVisualization(shiboken2.Object):
    class Q3DBars(QtDataVisualization.QAbstract3DGraph):
        barSpacingChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        barSpacingRelativeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        barThicknessChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        columnAxisChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        floorLevelChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        multiSeriesUniformChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        primarySeriesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowAxisChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        selectedSeriesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        valueAxisChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, format: PySide2.QtGui.QSurfaceFormat | None = ..., parent: PySide2.QtGui.QWindow | None = ..., active: bool = ..., activeChanged: typing.Callable = ..., activeInputHandler: typing.Any = ..., activeInputHandlerChanged: typing.Callable = ..., activeTheme: typing.Any = ..., activeThemeChanged: typing.Callable = ..., aspectRatio: float = ..., aspectRatioChanged: typing.Callable = ..., barSpacing: PySide2.QtCore.QSizeF = ..., barSpacingChanged: typing.Callable = ..., barSpacingRelative: bool = ..., barSpacingRelativeChanged: typing.Callable = ..., barThickness: float = ..., barThicknessChanged: typing.Callable = ..., columnAxis: QtDataVisualization.QCategory3DAxis = ..., columnAxisChanged: typing.Callable = ..., contentOrientation: PySide2.QtCore.Qt.ScreenOrientation = ..., contentOrientationChanged: typing.Callable = ..., currentFps: float = ..., currentFpsChanged: typing.Callable = ..., destroyed: typing.Callable = ..., flags: PySide2.QtCore.Qt.WindowFlags | PySide2.QtCore.Qt.WindowType = ..., floorLevel: float = ..., floorLevelChanged: typing.Callable = ..., focusObjectChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., horizontalAspectRatio: float = ..., horizontalAspectRatioChanged: typing.Callable = ..., locale: PySide2.QtCore.QLocale = ..., localeChanged: typing.Callable = ..., margin: float = ..., marginChanged: typing.Callable = ..., maximumHeight: int = ..., maximumHeightChanged: typing.Callable = ..., maximumWidth: int = ..., maximumWidthChanged: typing.Callable = ..., measureFps: bool = ..., measureFpsChanged: typing.Callable = ..., minimumHeight: int = ..., minimumHeightChanged: typing.Callable = ..., minimumWidth: int = ..., minimumWidthChanged: typing.Callable = ..., modality: PySide2.QtCore.Qt.WindowModality = ..., modalityChanged: typing.Callable = ..., multiSeriesUniform: bool = ..., multiSeriesUniformChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., optimizationHints: QtDataVisualization.Q3DBars.OptimizationHints = ..., optimizationHintsChanged: typing.Callable = ..., orthoProjection: bool = ..., orthoProjectionChanged: typing.Callable = ..., polar: bool = ..., polarChanged: typing.Callable = ..., primarySeries: QtDataVisualization.QBar3DSeries = ..., primarySeriesChanged: typing.Callable = ..., queriedGraphPosition: PySide2.QtGui.QVector3D = ..., queriedGraphPositionChanged: typing.Callable = ..., radialLabelOffset: float = ..., radialLabelOffsetChanged: typing.Callable = ..., reflection: bool = ..., reflectionChanged: typing.Callable = ..., reflectivity: float = ..., reflectivityChanged: typing.Callable = ..., rowAxis: QtDataVisualization.QCategory3DAxis = ..., rowAxisChanged: typing.Callable = ..., scene: typing.Any = ..., screenChanged: typing.Callable = ..., selectedElement: QtDataVisualization.Q3DBars.ElementType = ..., selectedElementChanged: typing.Callable = ..., selectedSeries: QtDataVisualization.QBar3DSeries = ..., selectedSeriesChanged: typing.Callable = ..., selectionMode: QtDataVisualization.Q3DBars.SelectionFlags = ..., selectionModeChanged: typing.Callable = ..., shadowQuality: QtDataVisualization.Q3DBars.ShadowQuality = ..., shadowQualityChanged: typing.Callable = ..., title: str = ..., transientParent: typing.Any = ..., transientParentChanged: typing.Callable = ..., valueAxis: QtDataVisualization.QValue3DAxis = ..., valueAxisChanged: typing.Callable = ..., visibility: QtDataVisualization.Q3DBars.Visibility = ..., visibilityChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: int = ..., widthChanged: typing.Callable = ..., windowStateChanged: typing.Callable = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., xChanged: typing.Callable = ..., y: int = ..., yChanged: typing.Callable = ...) -> None: ...
        def addAxis(self, axis: QtDataVisualization.QAbstract3DAxis) -> None: ...
        def addSeries(self, series: QtDataVisualization.QBar3DSeries) -> None: ...
        def axes(self) -> typing.List[QtDataVisualization.QAbstract3DAxis]: ...
        def barSpacing(self) -> PySide2.QtCore.QSizeF: ...
        def barThickness(self) -> float: ...
        def columnAxis(self) -> QtDataVisualization.QCategory3DAxis: ...
        def floorLevel(self) -> float: ...
        def insertSeries(self, index: int, series: QtDataVisualization.QBar3DSeries) -> None: ...
        def isBarSpacingRelative(self) -> bool: ...
        def isMultiSeriesUniform(self) -> bool: ...
        def primarySeries(self) -> QtDataVisualization.QBar3DSeries: ...
        def releaseAxis(self, axis: QtDataVisualization.QAbstract3DAxis) -> None: ...
        def removeSeries(self, series: QtDataVisualization.QBar3DSeries) -> None: ...
        def rowAxis(self) -> QtDataVisualization.QCategory3DAxis: ...
        def selectedSeries(self) -> QtDataVisualization.QBar3DSeries: ...
        def seriesList(self) -> typing.List[QtDataVisualization.QBar3DSeries]: ...
        def setBarSpacing(self, spacing: PySide2.QtCore.QSizeF) -> None: ...
        def setBarSpacingRelative(self, relative: bool) -> None: ...
        def setBarThickness(self, thicknessRatio: float) -> None: ...
        def setColumnAxis(self, axis: QtDataVisualization.QCategory3DAxis) -> None: ...
        def setFloorLevel(self, level: float) -> None: ...
        def setMultiSeriesUniform(self, uniform: bool) -> None: ...
        def setPrimarySeries(self, series: QtDataVisualization.QBar3DSeries) -> None: ...
        def setRowAxis(self, axis: QtDataVisualization.QCategory3DAxis) -> None: ...
        def setValueAxis(self, axis: QtDataVisualization.QValue3DAxis) -> None: ...
        def valueAxis(self) -> QtDataVisualization.QValue3DAxis: ...

    class Q3DCamera(QtDataVisualization.Q3DObject):
        class CameraPreset:
            CameraPresetBehind: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            CameraPresetBehindBelow: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            CameraPresetBehindHigh: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            CameraPresetBehindLow: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            CameraPresetDirectlyAbove: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            CameraPresetDirectlyAboveCCW45: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            CameraPresetDirectlyAboveCW45: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            CameraPresetDirectlyBelow: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            CameraPresetFront: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            CameraPresetFrontBelow: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            CameraPresetFrontHigh: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            CameraPresetFrontLow: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            CameraPresetIsometricLeft: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            CameraPresetIsometricLeftHigh: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            CameraPresetIsometricRight: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            CameraPresetIsometricRightHigh: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            CameraPresetLeft: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            CameraPresetLeftBelow: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            CameraPresetLeftHigh: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            CameraPresetLeftLow: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            CameraPresetNone: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            CameraPresetRight: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            CameraPresetRightBelow: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            CameraPresetRightHigh: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            CameraPresetRightLow: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DCamera.CameraPreset: ...
            def __and__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DCamera.CameraPreset: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DCamera.CameraPreset: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DCamera.CameraPreset: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DCamera.CameraPreset: ...
            def __rand__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DCamera.CameraPreset: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DCamera.CameraPreset: ...
            def __ror__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DCamera.CameraPreset: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DCamera.CameraPreset: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DCamera.CameraPreset: ...
            def __sub__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DCamera.CameraPreset: ...
            def __xor__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DCamera.CameraPreset: ...
        CameraPresetBehind: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        CameraPresetBehindBelow: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        CameraPresetBehindHigh: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        CameraPresetBehindLow: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        CameraPresetDirectlyAbove: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        CameraPresetDirectlyAboveCCW45: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        CameraPresetDirectlyAboveCW45: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        CameraPresetDirectlyBelow: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        CameraPresetFront: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        CameraPresetFrontBelow: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        CameraPresetFrontHigh: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        CameraPresetFrontLow: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        CameraPresetIsometricLeft: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        CameraPresetIsometricLeftHigh: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        CameraPresetIsometricRight: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        CameraPresetIsometricRightHigh: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        CameraPresetLeft: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        CameraPresetLeftBelow: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        CameraPresetLeftHigh: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        CameraPresetLeftLow: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        CameraPresetNone: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        CameraPresetRight: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        CameraPresetRightBelow: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        CameraPresetRightHigh: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        CameraPresetRightLow: typing.ClassVar[QtDataVisualization.Q3DCamera.CameraPreset] = ...
        cameraPresetChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        maxZoomLevelChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        minZoomLevelChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        targetChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        wrapXRotationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        wrapYRotationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        xRotationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        yRotationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        zoomLevelChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., cameraPreset: QtDataVisualization.Q3DCamera.CameraPreset = ..., cameraPresetChanged: typing.Callable = ..., destroyed: typing.Callable = ..., maxZoomLevel: float = ..., maxZoomLevelChanged: typing.Callable = ..., minZoomLevel: float = ..., minZoomLevelChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentScene: typing.Any = ..., position: PySide2.QtGui.QVector3D = ..., positionChanged: typing.Callable = ..., target: PySide2.QtGui.QVector3D = ..., targetChanged: typing.Callable = ..., wrapXRotation: bool = ..., wrapXRotationChanged: typing.Callable = ..., wrapYRotation: bool = ..., wrapYRotationChanged: typing.Callable = ..., xRotation: float = ..., xRotationChanged: typing.Callable = ..., yRotation: float = ..., yRotationChanged: typing.Callable = ..., zoomLevel: float = ..., zoomLevelChanged: typing.Callable = ...) -> None: ...
        def cameraPreset(self) -> QtDataVisualization.Q3DCamera.CameraPreset: ...
        def copyValuesFrom(self, source: QtDataVisualization.Q3DObject) -> None: ...
        def maxZoomLevel(self) -> float: ...
        def minZoomLevel(self) -> float: ...
        def setCameraPosition(self, horizontal: float, vertical: float, zoom: float = ...) -> None: ...
        def setCameraPreset(self, preset: QtDataVisualization.Q3DCamera.CameraPreset) -> None: ...
        def setMaxZoomLevel(self, zoomLevel: float) -> None: ...
        def setMinZoomLevel(self, zoomLevel: float) -> None: ...
        def setTarget(self, target: PySide2.QtGui.QVector3D) -> None: ...
        def setWrapXRotation(self, isEnabled: bool) -> None: ...
        def setWrapYRotation(self, isEnabled: bool) -> None: ...
        def setXRotation(self, rotation: float) -> None: ...
        def setYRotation(self, rotation: float) -> None: ...
        def setZoomLevel(self, zoomLevel: float) -> None: ...
        def target(self) -> PySide2.QtGui.QVector3D: ...
        def wrapXRotation(self) -> bool: ...
        def wrapYRotation(self) -> bool: ...
        def xRotation(self) -> float: ...
        def yRotation(self) -> float: ...
        def zoomLevel(self) -> float: ...

    class Q3DInputHandler(QtDataVisualization.QAbstract3DInputHandler):
        rotationEnabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        selectionEnabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        zoomAtTargetEnabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        zoomEnabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., inputPosition: PySide2.QtCore.QPoint = ..., inputView: QtDataVisualization.Q3DInputHandler.InputView = ..., inputViewChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., positionChanged: typing.Callable = ..., rotationEnabled: bool = ..., rotationEnabledChanged: typing.Callable = ..., scene: typing.Any = ..., sceneChanged: typing.Callable = ..., selectionEnabled: bool = ..., selectionEnabledChanged: typing.Callable = ..., zoomAtTargetEnabled: bool = ..., zoomAtTargetEnabledChanged: typing.Callable = ..., zoomEnabled: bool = ..., zoomEnabledChanged: typing.Callable = ...) -> None: ...
        def isRotationEnabled(self) -> bool: ...
        def isSelectionEnabled(self) -> bool: ...
        def isZoomAtTargetEnabled(self) -> bool: ...
        def isZoomEnabled(self) -> bool: ...
        def mouseMoveEvent(self, event: PySide2.QtGui.QMouseEvent, mousePos: PySide2.QtCore.QPoint) -> None: ...
        def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent, mousePos: PySide2.QtCore.QPoint) -> None: ...
        def mouseReleaseEvent(self, event: PySide2.QtGui.QMouseEvent, mousePos: PySide2.QtCore.QPoint) -> None: ...
        def setRotationEnabled(self, enable: bool) -> None: ...
        def setSelectionEnabled(self, enable: bool) -> None: ...
        def setZoomAtTargetEnabled(self, enable: bool) -> None: ...
        def setZoomEnabled(self, enable: bool) -> None: ...
        def wheelEvent(self, event: PySide2.QtGui.QWheelEvent) -> None: ...

    class Q3DLight(QtDataVisualization.Q3DObject):
        autoPositionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., autoPosition: bool = ..., autoPositionChanged: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentScene: typing.Any = ..., position: PySide2.QtGui.QVector3D = ..., positionChanged: typing.Callable = ...) -> None: ...
        def isAutoPosition(self) -> bool: ...
        def setAutoPosition(self, enabled: bool) -> None: ...

    class Q3DObject(PySide2.QtCore.QObject):
        positionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentScene: QtDataVisualization.Q3DScene = ..., position: PySide2.QtGui.QVector3D = ..., positionChanged: typing.Callable = ...) -> None: ...
        def copyValuesFrom(self, source: QtDataVisualization.Q3DObject) -> None: ...
        def isDirty(self) -> bool: ...
        def parentScene(self) -> QtDataVisualization.Q3DScene: ...
        def position(self) -> PySide2.QtGui.QVector3D: ...
        def setDirty(self, dirty: bool) -> None: ...
        def setPosition(self, position: PySide2.QtGui.QVector3D) -> None: ...

    class Q3DScatter(QtDataVisualization.QAbstract3DGraph):
        axisXChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        axisYChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        axisZChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        selectedSeriesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, format: PySide2.QtGui.QSurfaceFormat | None = ..., parent: PySide2.QtGui.QWindow | None = ..., active: bool = ..., activeChanged: typing.Callable = ..., activeInputHandler: typing.Any = ..., activeInputHandlerChanged: typing.Callable = ..., activeTheme: typing.Any = ..., activeThemeChanged: typing.Callable = ..., aspectRatio: float = ..., aspectRatioChanged: typing.Callable = ..., axisX: QtDataVisualization.QValue3DAxis = ..., axisXChanged: typing.Callable = ..., axisY: QtDataVisualization.QValue3DAxis = ..., axisYChanged: typing.Callable = ..., axisZ: QtDataVisualization.QValue3DAxis = ..., axisZChanged: typing.Callable = ..., contentOrientation: PySide2.QtCore.Qt.ScreenOrientation = ..., contentOrientationChanged: typing.Callable = ..., currentFps: float = ..., currentFpsChanged: typing.Callable = ..., destroyed: typing.Callable = ..., flags: PySide2.QtCore.Qt.WindowFlags | PySide2.QtCore.Qt.WindowType = ..., focusObjectChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., horizontalAspectRatio: float = ..., horizontalAspectRatioChanged: typing.Callable = ..., locale: PySide2.QtCore.QLocale = ..., localeChanged: typing.Callable = ..., margin: float = ..., marginChanged: typing.Callable = ..., maximumHeight: int = ..., maximumHeightChanged: typing.Callable = ..., maximumWidth: int = ..., maximumWidthChanged: typing.Callable = ..., measureFps: bool = ..., measureFpsChanged: typing.Callable = ..., minimumHeight: int = ..., minimumHeightChanged: typing.Callable = ..., minimumWidth: int = ..., minimumWidthChanged: typing.Callable = ..., modality: PySide2.QtCore.Qt.WindowModality = ..., modalityChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., optimizationHints: QtDataVisualization.Q3DScatter.OptimizationHints = ..., optimizationHintsChanged: typing.Callable = ..., orthoProjection: bool = ..., orthoProjectionChanged: typing.Callable = ..., polar: bool = ..., polarChanged: typing.Callable = ..., queriedGraphPosition: PySide2.QtGui.QVector3D = ..., queriedGraphPositionChanged: typing.Callable = ..., radialLabelOffset: float = ..., radialLabelOffsetChanged: typing.Callable = ..., reflection: bool = ..., reflectionChanged: typing.Callable = ..., reflectivity: float = ..., reflectivityChanged: typing.Callable = ..., scene: typing.Any = ..., screenChanged: typing.Callable = ..., selectedElement: QtDataVisualization.Q3DScatter.ElementType = ..., selectedElementChanged: typing.Callable = ..., selectedSeries: QtDataVisualization.QScatter3DSeries = ..., selectedSeriesChanged: typing.Callable = ..., selectionMode: QtDataVisualization.Q3DScatter.SelectionFlags = ..., selectionModeChanged: typing.Callable = ..., shadowQuality: QtDataVisualization.Q3DScatter.ShadowQuality = ..., shadowQualityChanged: typing.Callable = ..., title: str = ..., transientParent: typing.Any = ..., transientParentChanged: typing.Callable = ..., visibility: QtDataVisualization.Q3DScatter.Visibility = ..., visibilityChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: int = ..., widthChanged: typing.Callable = ..., windowStateChanged: typing.Callable = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., xChanged: typing.Callable = ..., y: int = ..., yChanged: typing.Callable = ...) -> None: ...
        def addAxis(self, axis: QtDataVisualization.QValue3DAxis) -> None: ...
        def addSeries(self, series: QtDataVisualization.QScatter3DSeries) -> None: ...
        def axes(self) -> typing.List[QtDataVisualization.QValue3DAxis]: ...
        def axisX(self) -> QtDataVisualization.QValue3DAxis: ...
        def axisY(self) -> QtDataVisualization.QValue3DAxis: ...
        def axisZ(self) -> QtDataVisualization.QValue3DAxis: ...
        def releaseAxis(self, axis: QtDataVisualization.QValue3DAxis) -> None: ...
        def removeSeries(self, series: QtDataVisualization.QScatter3DSeries) -> None: ...
        def selectedSeries(self) -> QtDataVisualization.QScatter3DSeries: ...
        def seriesList(self) -> typing.List[QtDataVisualization.QScatter3DSeries]: ...
        def setAxisX(self, axis: QtDataVisualization.QValue3DAxis) -> None: ...
        def setAxisY(self, axis: QtDataVisualization.QValue3DAxis) -> None: ...
        def setAxisZ(self, axis: QtDataVisualization.QValue3DAxis) -> None: ...

    class Q3DScene(PySide2.QtCore.QObject):
        activeCameraChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        activeLightChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        devicePixelRatioChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        graphPositionQueryChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        primarySubViewportChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        secondarySubViewportChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        secondarySubviewOnTopChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        selectionQueryPositionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        slicingActiveChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        viewportChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., activeCamera: QtDataVisualization.Q3DCamera = ..., activeCameraChanged: typing.Callable = ..., activeLight: QtDataVisualization.Q3DLight = ..., activeLightChanged: typing.Callable = ..., destroyed: typing.Callable = ..., devicePixelRatio: float = ..., devicePixelRatioChanged: typing.Callable = ..., graphPositionQuery: PySide2.QtCore.QPoint = ..., graphPositionQueryChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., primarySubViewport: PySide2.QtCore.QRect = ..., primarySubViewportChanged: typing.Callable = ..., secondarySubViewport: PySide2.QtCore.QRect = ..., secondarySubViewportChanged: typing.Callable = ..., secondarySubviewOnTop: bool = ..., secondarySubviewOnTopChanged: typing.Callable = ..., selectionQueryPosition: PySide2.QtCore.QPoint = ..., selectionQueryPositionChanged: typing.Callable = ..., slicingActive: bool = ..., slicingActiveChanged: typing.Callable = ..., viewport: PySide2.QtCore.QRect = ..., viewportChanged: typing.Callable = ...) -> None: ...
        def activeCamera(self) -> QtDataVisualization.Q3DCamera: ...
        def activeLight(self) -> QtDataVisualization.Q3DLight: ...
        def devicePixelRatio(self) -> float: ...
        def graphPositionQuery(self) -> PySide2.QtCore.QPoint: ...
        @staticmethod
        def invalidSelectionPoint() -> PySide2.QtCore.QPoint: ...
        def isPointInPrimarySubView(self, point: PySide2.QtCore.QPoint) -> bool: ...
        def isPointInSecondarySubView(self, point: PySide2.QtCore.QPoint) -> bool: ...
        def isSecondarySubviewOnTop(self) -> bool: ...
        def isSlicingActive(self) -> bool: ...
        def primarySubViewport(self) -> PySide2.QtCore.QRect: ...
        def secondarySubViewport(self) -> PySide2.QtCore.QRect: ...
        def selectionQueryPosition(self) -> PySide2.QtCore.QPoint: ...
        def setActiveCamera(self, camera: QtDataVisualization.Q3DCamera) -> None: ...
        def setActiveLight(self, light: QtDataVisualization.Q3DLight) -> None: ...
        def setDevicePixelRatio(self, pixelRatio: float) -> None: ...
        def setGraphPositionQuery(self, point: PySide2.QtCore.QPoint) -> None: ...
        def setPrimarySubViewport(self, primarySubViewport: PySide2.QtCore.QRect) -> None: ...
        def setSecondarySubViewport(self, secondarySubViewport: PySide2.QtCore.QRect) -> None: ...
        def setSecondarySubviewOnTop(self, isSecondaryOnTop: bool) -> None: ...
        def setSelectionQueryPosition(self, point: PySide2.QtCore.QPoint) -> None: ...
        def setSlicingActive(self, isSlicing: bool) -> None: ...
        def viewport(self) -> PySide2.QtCore.QRect: ...

    class Q3DSurface(QtDataVisualization.QAbstract3DGraph):
        axisXChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        axisYChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        axisZChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        flipHorizontalGridChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        selectedSeriesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, format: PySide2.QtGui.QSurfaceFormat | None = ..., parent: PySide2.QtGui.QWindow | None = ..., active: bool = ..., activeChanged: typing.Callable = ..., activeInputHandler: typing.Any = ..., activeInputHandlerChanged: typing.Callable = ..., activeTheme: typing.Any = ..., activeThemeChanged: typing.Callable = ..., aspectRatio: float = ..., aspectRatioChanged: typing.Callable = ..., axisX: QtDataVisualization.QValue3DAxis = ..., axisXChanged: typing.Callable = ..., axisY: QtDataVisualization.QValue3DAxis = ..., axisYChanged: typing.Callable = ..., axisZ: QtDataVisualization.QValue3DAxis = ..., axisZChanged: typing.Callable = ..., contentOrientation: PySide2.QtCore.Qt.ScreenOrientation = ..., contentOrientationChanged: typing.Callable = ..., currentFps: float = ..., currentFpsChanged: typing.Callable = ..., destroyed: typing.Callable = ..., flags: PySide2.QtCore.Qt.WindowFlags | PySide2.QtCore.Qt.WindowType = ..., flipHorizontalGrid: bool = ..., flipHorizontalGridChanged: typing.Callable = ..., focusObjectChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., horizontalAspectRatio: float = ..., horizontalAspectRatioChanged: typing.Callable = ..., locale: PySide2.QtCore.QLocale = ..., localeChanged: typing.Callable = ..., margin: float = ..., marginChanged: typing.Callable = ..., maximumHeight: int = ..., maximumHeightChanged: typing.Callable = ..., maximumWidth: int = ..., maximumWidthChanged: typing.Callable = ..., measureFps: bool = ..., measureFpsChanged: typing.Callable = ..., minimumHeight: int = ..., minimumHeightChanged: typing.Callable = ..., minimumWidth: int = ..., minimumWidthChanged: typing.Callable = ..., modality: PySide2.QtCore.Qt.WindowModality = ..., modalityChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., optimizationHints: QtDataVisualization.Q3DSurface.OptimizationHints = ..., optimizationHintsChanged: typing.Callable = ..., orthoProjection: bool = ..., orthoProjectionChanged: typing.Callable = ..., polar: bool = ..., polarChanged: typing.Callable = ..., queriedGraphPosition: PySide2.QtGui.QVector3D = ..., queriedGraphPositionChanged: typing.Callable = ..., radialLabelOffset: float = ..., radialLabelOffsetChanged: typing.Callable = ..., reflection: bool = ..., reflectionChanged: typing.Callable = ..., reflectivity: float = ..., reflectivityChanged: typing.Callable = ..., scene: typing.Any = ..., screenChanged: typing.Callable = ..., selectedElement: QtDataVisualization.Q3DSurface.ElementType = ..., selectedElementChanged: typing.Callable = ..., selectedSeries: QtDataVisualization.QSurface3DSeries = ..., selectedSeriesChanged: typing.Callable = ..., selectionMode: QtDataVisualization.Q3DSurface.SelectionFlags = ..., selectionModeChanged: typing.Callable = ..., shadowQuality: QtDataVisualization.Q3DSurface.ShadowQuality = ..., shadowQualityChanged: typing.Callable = ..., title: str = ..., transientParent: typing.Any = ..., transientParentChanged: typing.Callable = ..., visibility: QtDataVisualization.Q3DSurface.Visibility = ..., visibilityChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: int = ..., widthChanged: typing.Callable = ..., windowStateChanged: typing.Callable = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., xChanged: typing.Callable = ..., y: int = ..., yChanged: typing.Callable = ...) -> None: ...
        def addAxis(self, axis: QtDataVisualization.QValue3DAxis) -> None: ...
        def addSeries(self, series: QtDataVisualization.QSurface3DSeries) -> None: ...
        def axes(self) -> typing.List[QtDataVisualization.QValue3DAxis]: ...
        def axisX(self) -> QtDataVisualization.QValue3DAxis: ...
        def axisY(self) -> QtDataVisualization.QValue3DAxis: ...
        def axisZ(self) -> QtDataVisualization.QValue3DAxis: ...
        def flipHorizontalGrid(self) -> bool: ...
        def releaseAxis(self, axis: QtDataVisualization.QValue3DAxis) -> None: ...
        def removeSeries(self, series: QtDataVisualization.QSurface3DSeries) -> None: ...
        def selectedSeries(self) -> QtDataVisualization.QSurface3DSeries: ...
        def seriesList(self) -> typing.List[QtDataVisualization.QSurface3DSeries]: ...
        def setAxisX(self, axis: QtDataVisualization.QValue3DAxis) -> None: ...
        def setAxisY(self, axis: QtDataVisualization.QValue3DAxis) -> None: ...
        def setAxisZ(self, axis: QtDataVisualization.QValue3DAxis) -> None: ...
        def setFlipHorizontalGrid(self, flip: bool) -> None: ...

    class Q3DTheme(PySide2.QtCore.QObject):
        class ColorStyle:
            ColorStyleObjectGradient: typing.ClassVar[QtDataVisualization.Q3DTheme.ColorStyle] = ...
            ColorStyleRangeGradient: typing.ClassVar[QtDataVisualization.Q3DTheme.ColorStyle] = ...
            ColorStyleUniform: typing.ClassVar[QtDataVisualization.Q3DTheme.ColorStyle] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DTheme.ColorStyle: ...
            def __and__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DTheme.ColorStyle: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DTheme.ColorStyle: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DTheme.ColorStyle: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DTheme.ColorStyle: ...
            def __rand__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DTheme.ColorStyle: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DTheme.ColorStyle: ...
            def __ror__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DTheme.ColorStyle: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DTheme.ColorStyle: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DTheme.ColorStyle: ...
            def __sub__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DTheme.ColorStyle: ...
            def __xor__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DTheme.ColorStyle: ...

        class Theme:
            ThemeArmyBlue: typing.ClassVar[QtDataVisualization.Q3DTheme.Theme] = ...
            ThemeDigia: typing.ClassVar[QtDataVisualization.Q3DTheme.Theme] = ...
            ThemeEbony: typing.ClassVar[QtDataVisualization.Q3DTheme.Theme] = ...
            ThemeIsabelle: typing.ClassVar[QtDataVisualization.Q3DTheme.Theme] = ...
            ThemePrimaryColors: typing.ClassVar[QtDataVisualization.Q3DTheme.Theme] = ...
            ThemeQt: typing.ClassVar[QtDataVisualization.Q3DTheme.Theme] = ...
            ThemeRetro: typing.ClassVar[QtDataVisualization.Q3DTheme.Theme] = ...
            ThemeStoneMoss: typing.ClassVar[QtDataVisualization.Q3DTheme.Theme] = ...
            ThemeUserDefined: typing.ClassVar[QtDataVisualization.Q3DTheme.Theme] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DTheme.Theme: ...
            def __and__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DTheme.Theme: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DTheme.Theme: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DTheme.Theme: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DTheme.Theme: ...
            def __rand__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DTheme.Theme: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DTheme.Theme: ...
            def __ror__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DTheme.Theme: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DTheme.Theme: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DTheme.Theme: ...
            def __sub__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DTheme.Theme: ...
            def __xor__(self, other: typing.SupportsInt) -> QtDataVisualization.Q3DTheme.Theme: ...
        ColorStyleObjectGradient: typing.ClassVar[QtDataVisualization.Q3DTheme.ColorStyle] = ...
        ColorStyleRangeGradient: typing.ClassVar[QtDataVisualization.Q3DTheme.ColorStyle] = ...
        ColorStyleUniform: typing.ClassVar[QtDataVisualization.Q3DTheme.ColorStyle] = ...
        ThemeArmyBlue: typing.ClassVar[QtDataVisualization.Q3DTheme.Theme] = ...
        ThemeDigia: typing.ClassVar[QtDataVisualization.Q3DTheme.Theme] = ...
        ThemeEbony: typing.ClassVar[QtDataVisualization.Q3DTheme.Theme] = ...
        ThemeIsabelle: typing.ClassVar[QtDataVisualization.Q3DTheme.Theme] = ...
        ThemePrimaryColors: typing.ClassVar[QtDataVisualization.Q3DTheme.Theme] = ...
        ThemeQt: typing.ClassVar[QtDataVisualization.Q3DTheme.Theme] = ...
        ThemeRetro: typing.ClassVar[QtDataVisualization.Q3DTheme.Theme] = ...
        ThemeStoneMoss: typing.ClassVar[QtDataVisualization.Q3DTheme.Theme] = ...
        ThemeUserDefined: typing.ClassVar[QtDataVisualization.Q3DTheme.Theme] = ...
        ambientLightStrengthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        backgroundColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        backgroundEnabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        baseColorsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        baseGradientsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        colorStyleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        fontChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        gridEnabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        gridLineColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        highlightLightStrengthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelBackgroundColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelBackgroundEnabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelBorderEnabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelTextColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        lightColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        lightStrengthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        multiHighlightColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        multiHighlightGradientChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        singleHighlightColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        singleHighlightGradientChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        typeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        windowColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @typing.overload
        def __init__(self, themeType: QtDataVisualization.Q3DTheme.Theme, parent: PySide2.QtCore.QObject | None = ..., ambientLightStrength: float = ..., ambientLightStrengthChanged: typing.Callable = ..., backgroundColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., backgroundColorChanged: typing.Callable = ..., backgroundEnabled: bool = ..., backgroundEnabledChanged: typing.Callable = ..., baseColors: typing.List[PySide2.QtGui.QColor] = ..., baseColorsChanged: typing.Callable = ..., baseGradients: typing.List[PySide2.QtGui.QLinearGradient] = ..., baseGradientsChanged: typing.Callable = ..., colorStyle: QtDataVisualization.Q3DTheme.ColorStyle = ..., colorStyleChanged: typing.Callable = ..., destroyed: typing.Callable = ..., font: PySide2.QtGui.QFont = ..., fontChanged: typing.Callable = ..., gridEnabled: bool = ..., gridEnabledChanged: typing.Callable = ..., gridLineColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., gridLineColorChanged: typing.Callable = ..., highlightLightStrength: float = ..., highlightLightStrengthChanged: typing.Callable = ..., labelBackgroundColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., labelBackgroundColorChanged: typing.Callable = ..., labelBackgroundEnabled: bool = ..., labelBackgroundEnabledChanged: typing.Callable = ..., labelBorderEnabled: bool = ..., labelBorderEnabledChanged: typing.Callable = ..., labelTextColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., labelTextColorChanged: typing.Callable = ..., lightColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., lightColorChanged: typing.Callable = ..., lightStrength: float = ..., lightStrengthChanged: typing.Callable = ..., multiHighlightColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., multiHighlightColorChanged: typing.Callable = ..., multiHighlightGradient: PySide2.QtGui.QLinearGradient = ..., multiHighlightGradientChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., singleHighlightColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., singleHighlightColorChanged: typing.Callable = ..., singleHighlightGradient: PySide2.QtGui.QLinearGradient = ..., singleHighlightGradientChanged: typing.Callable = ..., type: QtDataVisualization.Q3DTheme.Theme = ..., typeChanged: typing.Callable = ..., windowColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., windowColorChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., ambientLightStrength: float = ..., ambientLightStrengthChanged: typing.Callable = ..., backgroundColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., backgroundColorChanged: typing.Callable = ..., backgroundEnabled: bool = ..., backgroundEnabledChanged: typing.Callable = ..., baseColors: typing.List[PySide2.QtGui.QColor] = ..., baseColorsChanged: typing.Callable = ..., baseGradients: typing.List[PySide2.QtGui.QLinearGradient] = ..., baseGradientsChanged: typing.Callable = ..., colorStyle: QtDataVisualization.Q3DTheme.ColorStyle = ..., colorStyleChanged: typing.Callable = ..., destroyed: typing.Callable = ..., font: PySide2.QtGui.QFont = ..., fontChanged: typing.Callable = ..., gridEnabled: bool = ..., gridEnabledChanged: typing.Callable = ..., gridLineColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., gridLineColorChanged: typing.Callable = ..., highlightLightStrength: float = ..., highlightLightStrengthChanged: typing.Callable = ..., labelBackgroundColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., labelBackgroundColorChanged: typing.Callable = ..., labelBackgroundEnabled: bool = ..., labelBackgroundEnabledChanged: typing.Callable = ..., labelBorderEnabled: bool = ..., labelBorderEnabledChanged: typing.Callable = ..., labelTextColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., labelTextColorChanged: typing.Callable = ..., lightColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., lightColorChanged: typing.Callable = ..., lightStrength: float = ..., lightStrengthChanged: typing.Callable = ..., multiHighlightColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., multiHighlightColorChanged: typing.Callable = ..., multiHighlightGradient: PySide2.QtGui.QLinearGradient = ..., multiHighlightGradientChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., singleHighlightColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., singleHighlightColorChanged: typing.Callable = ..., singleHighlightGradient: PySide2.QtGui.QLinearGradient = ..., singleHighlightGradientChanged: typing.Callable = ..., type: QtDataVisualization.Q3DTheme.Theme = ..., typeChanged: typing.Callable = ..., windowColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., windowColorChanged: typing.Callable = ...) -> None: ...
        def ambientLightStrength(self) -> float: ...
        def backgroundColor(self) -> PySide2.QtGui.QColor: ...
        def baseColors(self) -> typing.List[PySide2.QtGui.QColor]: ...
        def baseGradients(self) -> typing.List[PySide2.QtGui.QLinearGradient]: ...
        def colorStyle(self) -> QtDataVisualization.Q3DTheme.ColorStyle: ...
        def font(self) -> PySide2.QtGui.QFont: ...
        def gridLineColor(self) -> PySide2.QtGui.QColor: ...
        def highlightLightStrength(self) -> float: ...
        def isBackgroundEnabled(self) -> bool: ...
        def isGridEnabled(self) -> bool: ...
        def isLabelBackgroundEnabled(self) -> bool: ...
        def isLabelBorderEnabled(self) -> bool: ...
        def labelBackgroundColor(self) -> PySide2.QtGui.QColor: ...
        def labelTextColor(self) -> PySide2.QtGui.QColor: ...
        def lightColor(self) -> PySide2.QtGui.QColor: ...
        def lightStrength(self) -> float: ...
        def multiHighlightColor(self) -> PySide2.QtGui.QColor: ...
        def multiHighlightGradient(self) -> PySide2.QtGui.QLinearGradient: ...
        def setAmbientLightStrength(self, strength: float) -> None: ...
        def setBackgroundColor(self, color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setBackgroundEnabled(self, enabled: bool) -> None: ...
        def setBaseColors(self, colors: typing.Iterable[PySide2.QtGui.QColor]) -> None: ...
        def setBaseGradients(self, gradients: typing.Iterable[PySide2.QtGui.QLinearGradient]) -> None: ...
        def setColorStyle(self, style: QtDataVisualization.Q3DTheme.ColorStyle) -> None: ...
        def setFont(self, font: PySide2.QtGui.QFont) -> None: ...
        def setGridEnabled(self, enabled: bool) -> None: ...
        def setGridLineColor(self, color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setHighlightLightStrength(self, strength: float) -> None: ...
        def setLabelBackgroundColor(self, color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setLabelBackgroundEnabled(self, enabled: bool) -> None: ...
        def setLabelBorderEnabled(self, enabled: bool) -> None: ...
        def setLabelTextColor(self, color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setLightColor(self, color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setLightStrength(self, strength: float) -> None: ...
        def setMultiHighlightColor(self, color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setMultiHighlightGradient(self, gradient: PySide2.QtGui.QLinearGradient) -> None: ...
        def setSingleHighlightColor(self, color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setSingleHighlightGradient(self, gradient: PySide2.QtGui.QLinearGradient) -> None: ...
        def setType(self, themeType: QtDataVisualization.Q3DTheme.Theme) -> None: ...
        def setWindowColor(self, color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def singleHighlightColor(self) -> PySide2.QtGui.QColor: ...
        def singleHighlightGradient(self) -> PySide2.QtGui.QLinearGradient: ...
        def type(self) -> QtDataVisualization.Q3DTheme.Theme: ...
        def windowColor(self) -> PySide2.QtGui.QColor: ...

    class QAbstract3DAxis(PySide2.QtCore.QObject):
        class AxisOrientation:
            AxisOrientationNone: typing.ClassVar[QtDataVisualization.QAbstract3DAxis.AxisOrientation] = ...
            AxisOrientationX: typing.ClassVar[QtDataVisualization.QAbstract3DAxis.AxisOrientation] = ...
            AxisOrientationY: typing.ClassVar[QtDataVisualization.QAbstract3DAxis.AxisOrientation] = ...
            AxisOrientationZ: typing.ClassVar[QtDataVisualization.QAbstract3DAxis.AxisOrientation] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DAxis.AxisOrientation: ...
            def __and__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DAxis.AxisOrientation: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DAxis.AxisOrientation: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DAxis.AxisOrientation: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DAxis.AxisOrientation: ...
            def __rand__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DAxis.AxisOrientation: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DAxis.AxisOrientation: ...
            def __ror__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DAxis.AxisOrientation: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DAxis.AxisOrientation: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DAxis.AxisOrientation: ...
            def __sub__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DAxis.AxisOrientation: ...
            def __xor__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DAxis.AxisOrientation: ...

        class AxisType:
            AxisTypeCategory: typing.ClassVar[QtDataVisualization.QAbstract3DAxis.AxisType] = ...
            AxisTypeNone: typing.ClassVar[QtDataVisualization.QAbstract3DAxis.AxisType] = ...
            AxisTypeValue: typing.ClassVar[QtDataVisualization.QAbstract3DAxis.AxisType] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DAxis.AxisType: ...
            def __and__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DAxis.AxisType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DAxis.AxisType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DAxis.AxisType: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DAxis.AxisType: ...
            def __rand__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DAxis.AxisType: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DAxis.AxisType: ...
            def __ror__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DAxis.AxisType: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DAxis.AxisType: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DAxis.AxisType: ...
            def __sub__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DAxis.AxisType: ...
            def __xor__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DAxis.AxisType: ...
        AxisOrientationNone: typing.ClassVar[QtDataVisualization.QAbstract3DAxis.AxisOrientation] = ...
        AxisOrientationX: typing.ClassVar[QtDataVisualization.QAbstract3DAxis.AxisOrientation] = ...
        AxisOrientationY: typing.ClassVar[QtDataVisualization.QAbstract3DAxis.AxisOrientation] = ...
        AxisOrientationZ: typing.ClassVar[QtDataVisualization.QAbstract3DAxis.AxisOrientation] = ...
        AxisTypeCategory: typing.ClassVar[QtDataVisualization.QAbstract3DAxis.AxisType] = ...
        AxisTypeNone: typing.ClassVar[QtDataVisualization.QAbstract3DAxis.AxisType] = ...
        AxisTypeValue: typing.ClassVar[QtDataVisualization.QAbstract3DAxis.AxisType] = ...
        autoAdjustRangeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelAutoRotationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        maxChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        minChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        orientationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rangeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        titleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        titleFixedChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        titleVisibilityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @classmethod
        def __init__(cls, *args, autoAdjustRange: bool = ..., autoAdjustRangeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., labelAutoRotation: float = ..., labelAutoRotationChanged: typing.Callable = ..., labels: None = ..., labelsChanged: typing.Callable = ..., max: float = ..., maxChanged: typing.Callable = ..., min: float = ..., minChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., orientation: QtDataVisualization.QAbstract3DAxis.AxisOrientation = ..., orientationChanged: typing.Callable = ..., rangeChanged: typing.Callable = ..., title: str = ..., titleChanged: typing.Callable = ..., titleFixed: bool = ..., titleFixedChanged: typing.Callable = ..., titleVisibilityChanged: typing.Callable = ..., titleVisible: bool = ..., type: QtDataVisualization.QAbstract3DAxis.AxisType = ..., **kwargs) -> None: ...
        def isAutoAdjustRange(self) -> bool: ...
        def isTitleFixed(self) -> bool: ...
        def isTitleVisible(self) -> bool: ...
        def labelAutoRotation(self) -> float: ...
        def labels(self) -> typing.List[str]: ...
        def max(self) -> float: ...
        def min(self) -> float: ...
        def orientation(self) -> QtDataVisualization.QAbstract3DAxis.AxisOrientation: ...
        def setAutoAdjustRange(self, autoAdjust: bool) -> None: ...
        def setLabelAutoRotation(self, angle: float) -> None: ...
        def setLabels(self, labels: typing.Iterable[str]) -> None: ...
        def setMax(self, max: float) -> None: ...
        def setMin(self, min: float) -> None: ...
        def setRange(self, min: float, max: float) -> None: ...
        def setTitle(self, title: str) -> None: ...
        def setTitleFixed(self, fixed: bool) -> None: ...
        def setTitleVisible(self, visible: bool) -> None: ...
        def title(self) -> str: ...
        def type(self) -> QtDataVisualization.QAbstract3DAxis.AxisType: ...

    class QAbstract3DGraph(PySide2.QtGui.QWindow):
        class ElementType:
            ElementAxisXLabel: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ElementType] = ...
            ElementAxisYLabel: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ElementType] = ...
            ElementAxisZLabel: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ElementType] = ...
            ElementCustomItem: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ElementType] = ...
            ElementNone: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ElementType] = ...
            ElementSeries: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ElementType] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.ElementType: ...
            def __and__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.ElementType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.ElementType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.ElementType: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.ElementType: ...
            def __rand__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.ElementType: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.ElementType: ...
            def __ror__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.ElementType: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.ElementType: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.ElementType: ...
            def __sub__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.ElementType: ...
            def __xor__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.ElementType: ...

        class OptimizationHint:
            OptimizationDefault: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.OptimizationHint] = ...
            OptimizationStatic: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.OptimizationHint] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __and__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.OptimizationHints: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __invert__(self) -> QtDataVisualization.QAbstract3DGraph.OptimizationHints: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.OptimizationHints: ...
            def __rand__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.OptimizationHints: ...
            def __ror__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.OptimizationHints: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.OptimizationHints: ...
            def __xor__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.OptimizationHints: ...

        class OptimizationHints:
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __and__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.OptimizationHints: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __invert__(self) -> QtDataVisualization.QAbstract3DGraph.OptimizationHints: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.OptimizationHints: ...
            def __rand__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.OptimizationHints: ...
            def __ror__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.OptimizationHints: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.OptimizationHints: ...
            def __xor__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.OptimizationHints: ...

        class SelectionFlag:
            SelectionColumn: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.SelectionFlag] = ...
            SelectionItem: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.SelectionFlag] = ...
            SelectionItemAndColumn: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.SelectionFlag] = ...
            SelectionItemAndRow: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.SelectionFlag] = ...
            SelectionItemRowAndColumn: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.SelectionFlag] = ...
            SelectionMultiSeries: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.SelectionFlag] = ...
            SelectionNone: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.SelectionFlag] = ...
            SelectionRow: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.SelectionFlag] = ...
            SelectionRowAndColumn: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.SelectionFlag] = ...
            SelectionSlice: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.SelectionFlag] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __and__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.SelectionFlags: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __invert__(self) -> QtDataVisualization.QAbstract3DGraph.SelectionFlags: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.SelectionFlags: ...
            def __rand__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.SelectionFlags: ...
            def __ror__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.SelectionFlags: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.SelectionFlags: ...
            def __xor__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.SelectionFlags: ...

        class SelectionFlags:
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __and__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.SelectionFlags: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __invert__(self) -> QtDataVisualization.QAbstract3DGraph.SelectionFlags: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.SelectionFlags: ...
            def __rand__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.SelectionFlags: ...
            def __ror__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.SelectionFlags: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.SelectionFlags: ...
            def __xor__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.SelectionFlags: ...

        class ShadowQuality:
            ShadowQualityHigh: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ShadowQuality] = ...
            ShadowQualityLow: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ShadowQuality] = ...
            ShadowQualityMedium: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ShadowQuality] = ...
            ShadowQualityNone: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ShadowQuality] = ...
            ShadowQualitySoftHigh: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ShadowQuality] = ...
            ShadowQualitySoftLow: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ShadowQuality] = ...
            ShadowQualitySoftMedium: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ShadowQuality] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.ShadowQuality: ...
            def __and__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.ShadowQuality: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.ShadowQuality: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.ShadowQuality: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.ShadowQuality: ...
            def __rand__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.ShadowQuality: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.ShadowQuality: ...
            def __ror__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.ShadowQuality: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.ShadowQuality: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.ShadowQuality: ...
            def __sub__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.ShadowQuality: ...
            def __xor__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DGraph.ShadowQuality: ...
        ElementAxisXLabel: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ElementType] = ...
        ElementAxisYLabel: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ElementType] = ...
        ElementAxisZLabel: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ElementType] = ...
        ElementCustomItem: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ElementType] = ...
        ElementNone: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ElementType] = ...
        ElementSeries: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ElementType] = ...
        OptimizationDefault: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.OptimizationHint] = ...
        OptimizationStatic: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.OptimizationHint] = ...
        SelectionColumn: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.SelectionFlag] = ...
        SelectionItem: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.SelectionFlag] = ...
        SelectionItemAndColumn: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.SelectionFlag] = ...
        SelectionItemAndRow: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.SelectionFlag] = ...
        SelectionItemRowAndColumn: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.SelectionFlag] = ...
        SelectionMultiSeries: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.SelectionFlag] = ...
        SelectionNone: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.SelectionFlag] = ...
        SelectionRow: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.SelectionFlag] = ...
        SelectionRowAndColumn: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.SelectionFlag] = ...
        SelectionSlice: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.SelectionFlag] = ...
        ShadowQualityHigh: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ShadowQuality] = ...
        ShadowQualityLow: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ShadowQuality] = ...
        ShadowQualityMedium: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ShadowQuality] = ...
        ShadowQualityNone: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ShadowQuality] = ...
        ShadowQualitySoftHigh: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ShadowQuality] = ...
        ShadowQualitySoftLow: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ShadowQuality] = ...
        ShadowQualitySoftMedium: typing.ClassVar[QtDataVisualization.QAbstract3DGraph.ShadowQuality] = ...
        activeInputHandlerChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        activeThemeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        aspectRatioChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        currentFpsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        horizontalAspectRatioChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        localeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        marginChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        measureFpsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        optimizationHintsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        orthoProjectionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        polarChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        queriedGraphPositionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        radialLabelOffsetChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        reflectionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        reflectivityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        selectedElementChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        selectionModeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        shadowQualityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @classmethod
        def __init__(cls, *args, active: bool = ..., activeChanged: typing.Callable = ..., activeInputHandler: QtDataVisualization.QAbstract3DInputHandler = ..., activeInputHandlerChanged: typing.Callable = ..., activeTheme: QtDataVisualization.Q3DTheme = ..., activeThemeChanged: typing.Callable = ..., aspectRatio: float = ..., aspectRatioChanged: typing.Callable = ..., contentOrientation: PySide2.QtCore.Qt.ScreenOrientation = ..., contentOrientationChanged: typing.Callable = ..., currentFps: float = ..., currentFpsChanged: typing.Callable = ..., destroyed: typing.Callable = ..., flags: PySide2.QtCore.Qt.WindowFlags | PySide2.QtCore.Qt.WindowType = ..., focusObjectChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., horizontalAspectRatio: float = ..., horizontalAspectRatioChanged: typing.Callable = ..., locale: PySide2.QtCore.QLocale = ..., localeChanged: typing.Callable = ..., margin: float = ..., marginChanged: typing.Callable = ..., maximumHeight: int = ..., maximumHeightChanged: typing.Callable = ..., maximumWidth: int = ..., maximumWidthChanged: typing.Callable = ..., measureFps: bool = ..., measureFpsChanged: typing.Callable = ..., minimumHeight: int = ..., minimumHeightChanged: typing.Callable = ..., minimumWidth: int = ..., minimumWidthChanged: typing.Callable = ..., modality: PySide2.QtCore.Qt.WindowModality = ..., modalityChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., optimizationHints: QtDataVisualization.QAbstract3DGraph.OptimizationHints | QtDataVisualization.QAbstract3DGraph.OptimizationHint = ..., optimizationHintsChanged: typing.Callable = ..., orthoProjection: bool = ..., orthoProjectionChanged: typing.Callable = ..., polar: bool = ..., polarChanged: typing.Callable = ..., queriedGraphPosition: PySide2.QtGui.QVector3D = ..., queriedGraphPositionChanged: typing.Callable = ..., radialLabelOffset: float = ..., radialLabelOffsetChanged: typing.Callable = ..., reflection: bool = ..., reflectionChanged: typing.Callable = ..., reflectivity: float = ..., reflectivityChanged: typing.Callable = ..., scene: QtDataVisualization.Q3DScene = ..., screenChanged: typing.Callable = ..., selectedElement: QtDataVisualization.QAbstract3DGraph.ElementType = ..., selectedElementChanged: typing.Callable = ..., selectionMode: QtDataVisualization.QAbstract3DGraph.SelectionFlags | QtDataVisualization.QAbstract3DGraph.SelectionFlag = ..., selectionModeChanged: typing.Callable = ..., shadowQuality: QtDataVisualization.QAbstract3DGraph.ShadowQuality = ..., shadowQualityChanged: typing.Callable = ..., title: str = ..., transientParent: typing.Any = ..., transientParentChanged: typing.Callable = ..., visibility: QtDataVisualization.QAbstract3DGraph.Visibility = ..., visibilityChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: int = ..., widthChanged: typing.Callable = ..., windowStateChanged: typing.Callable = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., xChanged: typing.Callable = ..., y: int = ..., yChanged: typing.Callable = ..., **kwargs) -> None: ...
        def activeInputHandler(self) -> QtDataVisualization.QAbstract3DInputHandler: ...
        def activeTheme(self) -> QtDataVisualization.Q3DTheme: ...
        def addCustomItem(self, item: QtDataVisualization.QCustom3DItem) -> int: ...
        def addInputHandler(self, inputHandler: QtDataVisualization.QAbstract3DInputHandler) -> None: ...
        def addTheme(self, theme: QtDataVisualization.Q3DTheme) -> None: ...
        def aspectRatio(self) -> float: ...
        def clearSelection(self) -> None: ...
        def currentFps(self) -> float: ...
        def customItems(self) -> typing.List[QtDataVisualization.QCustom3DItem]: ...
        def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
        def exposeEvent(self, event: PySide2.QtGui.QExposeEvent) -> None: ...
        def hasContext(self) -> bool: ...
        def horizontalAspectRatio(self) -> float: ...
        def inputHandlers(self) -> typing.List[QtDataVisualization.QAbstract3DInputHandler]: ...
        def isOrthoProjection(self) -> bool: ...
        def isPolar(self) -> bool: ...
        def isReflection(self) -> bool: ...
        def locale(self) -> PySide2.QtCore.QLocale: ...
        def margin(self) -> float: ...
        def measureFps(self) -> bool: ...
        def mouseDoubleClickEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
        def mouseMoveEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
        def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
        def mouseReleaseEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
        def optimizationHints(self) -> QtDataVisualization.QAbstract3DGraph.OptimizationHints | QtDataVisualization.QAbstract3DGraph.OptimizationHint: ...
        def queriedGraphPosition(self) -> PySide2.QtGui.QVector3D: ...
        def radialLabelOffset(self) -> float: ...
        def reflectivity(self) -> float: ...
        def releaseCustomItem(self, item: QtDataVisualization.QCustom3DItem) -> None: ...
        def releaseInputHandler(self, inputHandler: QtDataVisualization.QAbstract3DInputHandler) -> None: ...
        def releaseTheme(self, theme: QtDataVisualization.Q3DTheme) -> None: ...
        def removeCustomItem(self, item: QtDataVisualization.QCustom3DItem) -> None: ...
        def removeCustomItemAt(self, position: PySide2.QtGui.QVector3D) -> None: ...
        def removeCustomItems(self) -> None: ...
        def renderToImage(self, msaaSamples: int = ..., imageSize: PySide2.QtCore.QSize = ...) -> PySide2.QtGui.QImage: ...
        def resizeEvent(self, event: PySide2.QtGui.QResizeEvent) -> None: ...
        def scene(self) -> QtDataVisualization.Q3DScene: ...
        def selectedAxis(self) -> QtDataVisualization.QAbstract3DAxis: ...
        def selectedCustomItem(self) -> QtDataVisualization.QCustom3DItem: ...
        def selectedCustomItemIndex(self) -> int: ...
        def selectedElement(self) -> QtDataVisualization.QAbstract3DGraph.ElementType: ...
        def selectedLabelIndex(self) -> int: ...
        def selectionMode(self) -> QtDataVisualization.QAbstract3DGraph.SelectionFlags | QtDataVisualization.QAbstract3DGraph.SelectionFlag: ...
        def setActiveInputHandler(self, inputHandler: QtDataVisualization.QAbstract3DInputHandler) -> None: ...
        def setActiveTheme(self, theme: QtDataVisualization.Q3DTheme) -> None: ...
        def setAspectRatio(self, ratio: float) -> None: ...
        def setHorizontalAspectRatio(self, ratio: float) -> None: ...
        def setLocale(self, locale: PySide2.QtCore.QLocale) -> None: ...
        def setMargin(self, margin: float) -> None: ...
        def setMeasureFps(self, enable: bool) -> None: ...
        def setOptimizationHints(self, hints: QtDataVisualization.QAbstract3DGraph.OptimizationHints | QtDataVisualization.QAbstract3DGraph.OptimizationHint) -> None: ...
        def setOrthoProjection(self, enable: bool) -> None: ...
        def setPolar(self, enable: bool) -> None: ...
        def setRadialLabelOffset(self, offset: float) -> None: ...
        def setReflection(self, enable: bool) -> None: ...
        def setReflectivity(self, reflectivity: float) -> None: ...
        def setSelectionMode(self, mode: QtDataVisualization.QAbstract3DGraph.SelectionFlags | QtDataVisualization.QAbstract3DGraph.SelectionFlag) -> None: ...
        def setShadowQuality(self, quality: QtDataVisualization.QAbstract3DGraph.ShadowQuality) -> None: ...
        def shadowQuality(self) -> QtDataVisualization.QAbstract3DGraph.ShadowQuality: ...
        def shadowsSupported(self) -> bool: ...
        def themes(self) -> typing.List[QtDataVisualization.Q3DTheme]: ...
        def touchEvent(self, event: PySide2.QtGui.QTouchEvent) -> None: ...
        def wheelEvent(self, event: PySide2.QtGui.QWheelEvent) -> None: ...

    class QAbstract3DInputHandler(PySide2.QtCore.QObject):
        class InputView:
            InputViewNone: typing.ClassVar[QtDataVisualization.QAbstract3DInputHandler.InputView] = ...
            InputViewOnPrimary: typing.ClassVar[QtDataVisualization.QAbstract3DInputHandler.InputView] = ...
            InputViewOnSecondary: typing.ClassVar[QtDataVisualization.QAbstract3DInputHandler.InputView] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DInputHandler.InputView: ...
            def __and__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DInputHandler.InputView: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DInputHandler.InputView: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DInputHandler.InputView: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DInputHandler.InputView: ...
            def __rand__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DInputHandler.InputView: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DInputHandler.InputView: ...
            def __ror__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DInputHandler.InputView: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DInputHandler.InputView: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DInputHandler.InputView: ...
            def __sub__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DInputHandler.InputView: ...
            def __xor__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DInputHandler.InputView: ...
        InputViewNone: typing.ClassVar[QtDataVisualization.QAbstract3DInputHandler.InputView] = ...
        InputViewOnPrimary: typing.ClassVar[QtDataVisualization.QAbstract3DInputHandler.InputView] = ...
        InputViewOnSecondary: typing.ClassVar[QtDataVisualization.QAbstract3DInputHandler.InputView] = ...
        inputViewChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        positionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sceneChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., inputPosition: PySide2.QtCore.QPoint = ..., inputView: QtDataVisualization.QAbstract3DInputHandler.InputView = ..., inputViewChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., positionChanged: typing.Callable = ..., scene: QtDataVisualization.Q3DScene = ..., sceneChanged: typing.Callable = ...) -> None: ...
        def inputPosition(self) -> PySide2.QtCore.QPoint: ...
        def inputView(self) -> QtDataVisualization.QAbstract3DInputHandler.InputView: ...
        def mouseDoubleClickEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
        def mouseMoveEvent(self, event: PySide2.QtGui.QMouseEvent, mousePos: PySide2.QtCore.QPoint) -> None: ...
        def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent, mousePos: PySide2.QtCore.QPoint) -> None: ...
        def mouseReleaseEvent(self, event: PySide2.QtGui.QMouseEvent, mousePos: PySide2.QtCore.QPoint) -> None: ...
        def prevDistance(self) -> int: ...
        def previousInputPos(self) -> PySide2.QtCore.QPoint: ...
        def scene(self) -> QtDataVisualization.Q3DScene: ...
        def setInputPosition(self, position: PySide2.QtCore.QPoint) -> None: ...
        def setInputView(self, inputView: QtDataVisualization.QAbstract3DInputHandler.InputView) -> None: ...
        def setPrevDistance(self, distance: int) -> None: ...
        def setPreviousInputPos(self, position: PySide2.QtCore.QPoint) -> None: ...
        def setScene(self, scene: QtDataVisualization.Q3DScene) -> None: ...
        def touchEvent(self, event: PySide2.QtGui.QTouchEvent) -> None: ...
        def wheelEvent(self, event: PySide2.QtGui.QWheelEvent) -> None: ...

    class QAbstract3DSeries(PySide2.QtCore.QObject):
        class Mesh:
            MeshArrow: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.Mesh] = ...
            MeshBar: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.Mesh] = ...
            MeshBevelBar: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.Mesh] = ...
            MeshBevelCube: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.Mesh] = ...
            MeshCone: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.Mesh] = ...
            MeshCube: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.Mesh] = ...
            MeshCylinder: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.Mesh] = ...
            MeshMinimal: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.Mesh] = ...
            MeshPoint: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.Mesh] = ...
            MeshPyramid: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.Mesh] = ...
            MeshSphere: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.Mesh] = ...
            MeshUserDefined: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.Mesh] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DSeries.Mesh: ...
            def __and__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DSeries.Mesh: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DSeries.Mesh: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DSeries.Mesh: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DSeries.Mesh: ...
            def __rand__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DSeries.Mesh: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DSeries.Mesh: ...
            def __ror__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DSeries.Mesh: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DSeries.Mesh: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DSeries.Mesh: ...
            def __sub__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DSeries.Mesh: ...
            def __xor__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DSeries.Mesh: ...

        class SeriesType:
            SeriesTypeBar: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.SeriesType] = ...
            SeriesTypeNone: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.SeriesType] = ...
            SeriesTypeScatter: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.SeriesType] = ...
            SeriesTypeSurface: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.SeriesType] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DSeries.SeriesType: ...
            def __and__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DSeries.SeriesType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DSeries.SeriesType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DSeries.SeriesType: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DSeries.SeriesType: ...
            def __rand__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DSeries.SeriesType: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DSeries.SeriesType: ...
            def __ror__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DSeries.SeriesType: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DSeries.SeriesType: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DSeries.SeriesType: ...
            def __sub__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DSeries.SeriesType: ...
            def __xor__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstract3DSeries.SeriesType: ...
        MeshArrow: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.Mesh] = ...
        MeshBar: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.Mesh] = ...
        MeshBevelBar: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.Mesh] = ...
        MeshBevelCube: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.Mesh] = ...
        MeshCone: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.Mesh] = ...
        MeshCube: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.Mesh] = ...
        MeshCylinder: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.Mesh] = ...
        MeshMinimal: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.Mesh] = ...
        MeshPoint: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.Mesh] = ...
        MeshPyramid: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.Mesh] = ...
        MeshSphere: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.Mesh] = ...
        MeshUserDefined: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.Mesh] = ...
        SeriesTypeBar: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.SeriesType] = ...
        SeriesTypeNone: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.SeriesType] = ...
        SeriesTypeScatter: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.SeriesType] = ...
        SeriesTypeSurface: typing.ClassVar[QtDataVisualization.QAbstract3DSeries.SeriesType] = ...
        baseColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        baseGradientChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        colorStyleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        itemLabelChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        itemLabelFormatChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        itemLabelVisibilityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        meshChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        meshRotationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        meshSmoothChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        multiHighlightColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        multiHighlightGradientChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        nameChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        singleHighlightColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        singleHighlightGradientChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        userDefinedMeshChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        visibilityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @classmethod
        def __init__(cls, *args, baseColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., baseColorChanged: typing.Callable = ..., baseGradient: PySide2.QtGui.QLinearGradient = ..., baseGradientChanged: typing.Callable = ..., colorStyle: typing.Any = ..., colorStyleChanged: typing.Callable = ..., destroyed: typing.Callable = ..., itemLabel: str = ..., itemLabelChanged: typing.Callable = ..., itemLabelFormat: str = ..., itemLabelFormatChanged: typing.Callable = ..., itemLabelVisibilityChanged: typing.Callable = ..., itemLabelVisible: bool = ..., mesh: QtDataVisualization.QAbstract3DSeries.Mesh = ..., meshChanged: typing.Callable = ..., meshRotation: PySide2.QtGui.QQuaternion = ..., meshRotationChanged: typing.Callable = ..., meshSmooth: bool = ..., meshSmoothChanged: typing.Callable = ..., multiHighlightColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., multiHighlightColorChanged: typing.Callable = ..., multiHighlightGradient: PySide2.QtGui.QLinearGradient = ..., multiHighlightGradientChanged: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., singleHighlightColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., singleHighlightColorChanged: typing.Callable = ..., singleHighlightGradient: PySide2.QtGui.QLinearGradient = ..., singleHighlightGradientChanged: typing.Callable = ..., type: QtDataVisualization.QAbstract3DSeries.SeriesType = ..., userDefinedMesh: str = ..., userDefinedMeshChanged: typing.Callable = ..., visibilityChanged: typing.Callable = ..., visible: bool = ..., **kwargs) -> None: ...
        def baseColor(self) -> PySide2.QtGui.QColor: ...
        def baseGradient(self) -> PySide2.QtGui.QLinearGradient: ...
        def colorStyle(self) -> QtDataVisualization.Q3DTheme.ColorStyle: ...
        def isItemLabelVisible(self) -> bool: ...
        def isMeshSmooth(self) -> bool: ...
        def isVisible(self) -> bool: ...
        def itemLabel(self) -> str: ...
        def itemLabelFormat(self) -> str: ...
        def mesh(self) -> QtDataVisualization.QAbstract3DSeries.Mesh: ...
        def meshRotation(self) -> PySide2.QtGui.QQuaternion: ...
        def multiHighlightColor(self) -> PySide2.QtGui.QColor: ...
        def multiHighlightGradient(self) -> PySide2.QtGui.QLinearGradient: ...
        def name(self) -> str: ...
        def setBaseColor(self, color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setBaseGradient(self, gradient: PySide2.QtGui.QLinearGradient) -> None: ...
        def setColorStyle(self, style: QtDataVisualization.Q3DTheme.ColorStyle) -> None: ...
        def setItemLabelFormat(self, format: str) -> None: ...
        def setItemLabelVisible(self, visible: bool) -> None: ...
        def setMesh(self, mesh: QtDataVisualization.QAbstract3DSeries.Mesh) -> None: ...
        def setMeshAxisAndAngle(self, axis: PySide2.QtGui.QVector3D, angle: float) -> None: ...
        def setMeshRotation(self, rotation: PySide2.QtGui.QQuaternion) -> None: ...
        def setMeshSmooth(self, enable: bool) -> None: ...
        def setMultiHighlightColor(self, color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setMultiHighlightGradient(self, gradient: PySide2.QtGui.QLinearGradient) -> None: ...
        def setName(self, name: str) -> None: ...
        def setSingleHighlightColor(self, color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setSingleHighlightGradient(self, gradient: PySide2.QtGui.QLinearGradient) -> None: ...
        def setUserDefinedMesh(self, fileName: str) -> None: ...
        def setVisible(self, visible: bool) -> None: ...
        def singleHighlightColor(self) -> PySide2.QtGui.QColor: ...
        def singleHighlightGradient(self) -> PySide2.QtGui.QLinearGradient: ...
        def type(self) -> QtDataVisualization.QAbstract3DSeries.SeriesType: ...
        def userDefinedMesh(self) -> str: ...

    class QAbstractDataProxy(PySide2.QtCore.QObject):
        class DataType:
            DataTypeBar: typing.ClassVar[QtDataVisualization.QAbstractDataProxy.DataType] = ...
            DataTypeNone: typing.ClassVar[QtDataVisualization.QAbstractDataProxy.DataType] = ...
            DataTypeScatter: typing.ClassVar[QtDataVisualization.QAbstractDataProxy.DataType] = ...
            DataTypeSurface: typing.ClassVar[QtDataVisualization.QAbstractDataProxy.DataType] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstractDataProxy.DataType: ...
            def __and__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstractDataProxy.DataType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstractDataProxy.DataType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstractDataProxy.DataType: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstractDataProxy.DataType: ...
            def __rand__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstractDataProxy.DataType: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstractDataProxy.DataType: ...
            def __ror__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstractDataProxy.DataType: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstractDataProxy.DataType: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstractDataProxy.DataType: ...
            def __sub__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstractDataProxy.DataType: ...
            def __xor__(self, other: typing.SupportsInt) -> QtDataVisualization.QAbstractDataProxy.DataType: ...
        DataTypeBar: typing.ClassVar[QtDataVisualization.QAbstractDataProxy.DataType] = ...
        DataTypeNone: typing.ClassVar[QtDataVisualization.QAbstractDataProxy.DataType] = ...
        DataTypeScatter: typing.ClassVar[QtDataVisualization.QAbstractDataProxy.DataType] = ...
        DataTypeSurface: typing.ClassVar[QtDataVisualization.QAbstractDataProxy.DataType] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @classmethod
        def __init__(cls, *args, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., type: QtDataVisualization.QAbstractDataProxy.DataType = ..., **kwargs) -> None: ...
        def type(self) -> QtDataVisualization.QAbstractDataProxy.DataType: ...

    class QBar3DSeries(QtDataVisualization.QAbstract3DSeries):
        dataProxyChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        meshAngleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        selectedBarChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @typing.overload
        def __init__(self, dataProxy: QtDataVisualization.QBarDataProxy, parent: PySide2.QtCore.QObject | None = ..., baseColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., baseColorChanged: typing.Callable = ..., baseGradient: typing.Any = ..., baseGradientChanged: typing.Callable = ..., colorStyle: typing.Any = ..., colorStyleChanged: typing.Callable = ..., dataProxyChanged: typing.Callable = ..., destroyed: typing.Callable = ..., itemLabel: str = ..., itemLabelChanged: typing.Callable = ..., itemLabelFormat: str = ..., itemLabelFormatChanged: typing.Callable = ..., itemLabelVisibilityChanged: typing.Callable = ..., itemLabelVisible: bool = ..., mesh: QtDataVisualization.QBar3DSeries.Mesh = ..., meshAngle: float = ..., meshAngleChanged: typing.Callable = ..., meshChanged: typing.Callable = ..., meshRotation: PySide2.QtGui.QQuaternion = ..., meshRotationChanged: typing.Callable = ..., meshSmooth: bool = ..., meshSmoothChanged: typing.Callable = ..., multiHighlightColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., multiHighlightColorChanged: typing.Callable = ..., multiHighlightGradient: typing.Any = ..., multiHighlightGradientChanged: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., selectedBar: PySide2.QtCore.QPoint = ..., selectedBarChanged: typing.Callable = ..., singleHighlightColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., singleHighlightColorChanged: typing.Callable = ..., singleHighlightGradient: typing.Any = ..., singleHighlightGradientChanged: typing.Callable = ..., type: QtDataVisualization.QBar3DSeries.SeriesType = ..., userDefinedMesh: str = ..., userDefinedMeshChanged: typing.Callable = ..., visibilityChanged: typing.Callable = ..., visible: bool = ...) -> None: ...
        @typing.overload
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., baseColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., baseColorChanged: typing.Callable = ..., baseGradient: typing.Any = ..., baseGradientChanged: typing.Callable = ..., colorStyle: typing.Any = ..., colorStyleChanged: typing.Callable = ..., dataProxy: QtDataVisualization.QBarDataProxy = ..., dataProxyChanged: typing.Callable = ..., destroyed: typing.Callable = ..., itemLabel: str = ..., itemLabelChanged: typing.Callable = ..., itemLabelFormat: str = ..., itemLabelFormatChanged: typing.Callable = ..., itemLabelVisibilityChanged: typing.Callable = ..., itemLabelVisible: bool = ..., mesh: QtDataVisualization.QBar3DSeries.Mesh = ..., meshAngle: float = ..., meshAngleChanged: typing.Callable = ..., meshChanged: typing.Callable = ..., meshRotation: PySide2.QtGui.QQuaternion = ..., meshRotationChanged: typing.Callable = ..., meshSmooth: bool = ..., meshSmoothChanged: typing.Callable = ..., multiHighlightColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., multiHighlightColorChanged: typing.Callable = ..., multiHighlightGradient: typing.Any = ..., multiHighlightGradientChanged: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., selectedBar: PySide2.QtCore.QPoint = ..., selectedBarChanged: typing.Callable = ..., singleHighlightColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., singleHighlightColorChanged: typing.Callable = ..., singleHighlightGradient: typing.Any = ..., singleHighlightGradientChanged: typing.Callable = ..., type: QtDataVisualization.QBar3DSeries.SeriesType = ..., userDefinedMesh: str = ..., userDefinedMeshChanged: typing.Callable = ..., visibilityChanged: typing.Callable = ..., visible: bool = ...) -> None: ...
        def dataProxy(self) -> QtDataVisualization.QBarDataProxy: ...
        @staticmethod
        def invalidSelectionPosition() -> PySide2.QtCore.QPoint: ...
        def meshAngle(self) -> float: ...
        def selectedBar(self) -> PySide2.QtCore.QPoint: ...
        def setDataProxy(self, proxy: QtDataVisualization.QBarDataProxy) -> None: ...
        def setMeshAngle(self, angle: float) -> None: ...
        def setSelectedBar(self, position: PySide2.QtCore.QPoint) -> None: ...

    class QBarDataItem(shiboken2.Object):
        @typing.overload
        def __init__(self, value: float, angle: float) -> None: ...
        @typing.overload
        def __init__(self, value: float) -> None: ...
        @typing.overload
        def __init__(self, other: QtDataVisualization.QBarDataItem) -> None: ...
        @typing.overload
        def __init__(self) -> None: ...
        def createExtraData(self) -> None: ...
        def rotation(self) -> float: ...
        def setRotation(self, angle: float) -> None: ...
        def setValue(self, val: float) -> None: ...
        def value(self) -> float: ...
        def __copy__(self) -> None: ...

    class QBarDataProxy(QtDataVisualization.QAbstractDataProxy):
        arrayReset: typing.ClassVar[PySide2.QtCore.Signal] = ...
        columnLabelsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        itemChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowLabelsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowsAdded: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowsInserted: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowsRemoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
        seriesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., arrayReset: typing.Callable = ..., columnLabels: None = ..., columnLabelsChanged: typing.Callable = ..., destroyed: typing.Callable = ..., itemChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowCount: int = ..., rowCountChanged: typing.Callable = ..., rowLabels: None = ..., rowLabelsChanged: typing.Callable = ..., rowsAdded: typing.Callable = ..., rowsChanged: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsRemoved: typing.Callable = ..., series: QtDataVisualization.QBar3DSeries = ..., seriesChanged: typing.Callable = ..., type: QtDataVisualization.QBarDataProxy.DataType = ...) -> None: ...
        @typing.overload
        def addRow(self, row: typing.List[QtDataVisualization.QBarDataItem], label: str) -> int: ...
        @typing.overload
        def addRow(self, row: typing.List[QtDataVisualization.QBarDataItem]) -> int: ...
        @typing.overload
        def addRows(self, rows: typing.List[typing.List[QtDataVisualization.QBarDataItem]], labels: typing.Iterable[str]) -> int: ...
        @typing.overload
        def addRows(self, rows: typing.List[typing.List[QtDataVisualization.QBarDataItem]]) -> int: ...
        def array(self) -> typing.List[typing.List[QtDataVisualization.QBarDataItem]]: ...
        def columnLabels(self) -> typing.List[str]: ...
        @typing.overload
        def insertRow(self, rowIndex: int, row: typing.List[QtDataVisualization.QBarDataItem], label: str) -> None: ...
        @typing.overload
        def insertRow(self, rowIndex: int, row: typing.List[QtDataVisualization.QBarDataItem]) -> None: ...
        @typing.overload
        def insertRows(self, rowIndex: int, rows: typing.List[typing.List[QtDataVisualization.QBarDataItem]], labels: typing.Iterable[str]) -> None: ...
        @typing.overload
        def insertRows(self, rowIndex: int, rows: typing.List[typing.List[QtDataVisualization.QBarDataItem]]) -> None: ...
        @typing.overload
        def itemAt(self, rowIndex: int, columnIndex: int) -> QtDataVisualization.QBarDataItem: ...
        @typing.overload
        def itemAt(self, position: PySide2.QtCore.QPoint) -> QtDataVisualization.QBarDataItem: ...
        def removeRows(self, rowIndex: int, removeCount: int, removeLabels: bool = ...) -> None: ...
        @typing.overload
        def resetArray(self, newArray: typing.List[typing.List[QtDataVisualization.QBarDataItem]], rowLabels: typing.Iterable[str], columnLabels: typing.Iterable[str]) -> None: ...
        @typing.overload
        def resetArray(self, newArray: typing.List[typing.List[QtDataVisualization.QBarDataItem]]) -> None: ...
        @typing.overload
        def resetArray(self) -> None: ...
        def rowAt(self, rowIndex: int) -> typing.List[QtDataVisualization.QBarDataItem]: ...
        def rowCount(self) -> int: ...
        def rowLabels(self) -> typing.List[str]: ...
        def series(self) -> QtDataVisualization.QBar3DSeries: ...
        def setColumnLabels(self, labels: typing.Iterable[str]) -> None: ...
        @typing.overload
        def setItem(self, rowIndex: int, columnIndex: int, item: QtDataVisualization.QBarDataItem) -> None: ...
        @typing.overload
        def setItem(self, position: PySide2.QtCore.QPoint, item: QtDataVisualization.QBarDataItem) -> None: ...
        @typing.overload
        def setRow(self, rowIndex: int, row: typing.List[QtDataVisualization.QBarDataItem], label: str) -> None: ...
        @typing.overload
        def setRow(self, rowIndex: int, row: typing.List[QtDataVisualization.QBarDataItem]) -> None: ...
        def setRowLabels(self, labels: typing.Iterable[str]) -> None: ...
        @typing.overload
        def setRows(self, rowIndex: int, rows: typing.List[typing.List[QtDataVisualization.QBarDataItem]], labels: typing.Iterable[str]) -> None: ...
        @typing.overload
        def setRows(self, rowIndex: int, rows: typing.List[typing.List[QtDataVisualization.QBarDataItem]]) -> None: ...

    class QCategory3DAxis(QtDataVisualization.QAbstract3DAxis):
        labelsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., autoAdjustRange: bool = ..., autoAdjustRangeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., labelAutoRotation: float = ..., labelAutoRotationChanged: typing.Callable = ..., labels: None = ..., labelsChanged: typing.Callable = ..., max: float = ..., maxChanged: typing.Callable = ..., min: float = ..., minChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., orientation: QtDataVisualization.QCategory3DAxis.AxisOrientation = ..., orientationChanged: typing.Callable = ..., rangeChanged: typing.Callable = ..., title: str = ..., titleChanged: typing.Callable = ..., titleFixed: bool = ..., titleFixedChanged: typing.Callable = ..., titleVisibilityChanged: typing.Callable = ..., titleVisible: bool = ..., type: QtDataVisualization.QCategory3DAxis.AxisType = ...) -> None: ...
        def labels(self) -> typing.List[str]: ...
        def setLabels(self, labels: typing.Iterable[str]) -> None: ...

    class QCustom3DItem(PySide2.QtCore.QObject):
        meshFileChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        positionAbsoluteChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        positionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rotationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        scalingAbsoluteChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        scalingChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        shadowCastingChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        textureFileChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        visibleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @typing.overload
        def __init__(self, meshFile: str, position: PySide2.QtGui.QVector3D, scaling: PySide2.QtGui.QVector3D, rotation: PySide2.QtGui.QQuaternion, texture: PySide2.QtGui.QImage, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., meshFileChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., positionAbsolute: bool = ..., positionAbsoluteChanged: typing.Callable = ..., positionChanged: typing.Callable = ..., rotationChanged: typing.Callable = ..., scalingAbsolute: bool = ..., scalingAbsoluteChanged: typing.Callable = ..., scalingChanged: typing.Callable = ..., shadowCasting: bool = ..., shadowCastingChanged: typing.Callable = ..., textureFile: str = ..., textureFileChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., meshFile: str = ..., meshFileChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., position: PySide2.QtGui.QVector3D = ..., positionAbsolute: bool = ..., positionAbsoluteChanged: typing.Callable = ..., positionChanged: typing.Callable = ..., rotation: PySide2.QtGui.QQuaternion = ..., rotationChanged: typing.Callable = ..., scaling: PySide2.QtGui.QVector3D = ..., scalingAbsolute: bool = ..., scalingAbsoluteChanged: typing.Callable = ..., scalingChanged: typing.Callable = ..., shadowCasting: bool = ..., shadowCastingChanged: typing.Callable = ..., textureFile: str = ..., textureFileChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        def isPositionAbsolute(self) -> bool: ...
        def isScalingAbsolute(self) -> bool: ...
        def isShadowCasting(self) -> bool: ...
        def isVisible(self) -> bool: ...
        def meshFile(self) -> str: ...
        def position(self) -> PySide2.QtGui.QVector3D: ...
        def rotation(self) -> PySide2.QtGui.QQuaternion: ...
        def scaling(self) -> PySide2.QtGui.QVector3D: ...
        def setMeshFile(self, meshFile: str) -> None: ...
        def setPosition(self, position: PySide2.QtGui.QVector3D) -> None: ...
        def setPositionAbsolute(self, positionAbsolute: bool) -> None: ...
        def setRotation(self, rotation: PySide2.QtGui.QQuaternion) -> None: ...
        def setRotationAxisAndAngle(self, axis: PySide2.QtGui.QVector3D, angle: float) -> None: ...
        def setScaling(self, scaling: PySide2.QtGui.QVector3D) -> None: ...
        def setScalingAbsolute(self, scalingAbsolute: bool) -> None: ...
        def setShadowCasting(self, enabled: bool) -> None: ...
        def setTextureFile(self, textureFile: str) -> None: ...
        def setTextureImage(self, textureImage: PySide2.QtGui.QImage) -> None: ...
        def setVisible(self, visible: bool) -> None: ...
        def textureFile(self) -> str: ...

    class QCustom3DLabel(QtDataVisualization.QCustom3DItem):
        backgroundColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        backgroundEnabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        borderEnabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        facingCameraChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        fontChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        textChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        textColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @typing.overload
        def __init__(self, text: str, font: PySide2.QtGui.QFont, position: PySide2.QtGui.QVector3D, scaling: PySide2.QtGui.QVector3D, rotation: PySide2.QtGui.QQuaternion, parent: PySide2.QtCore.QObject | None = ..., backgroundColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., backgroundColorChanged: typing.Callable = ..., backgroundEnabled: bool = ..., backgroundEnabledChanged: typing.Callable = ..., borderEnabled: bool = ..., borderEnabledChanged: typing.Callable = ..., destroyed: typing.Callable = ..., facingCamera: bool = ..., facingCameraChanged: typing.Callable = ..., fontChanged: typing.Callable = ..., meshFile: str = ..., meshFileChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., positionAbsolute: bool = ..., positionAbsoluteChanged: typing.Callable = ..., positionChanged: typing.Callable = ..., rotationChanged: typing.Callable = ..., scalingAbsolute: bool = ..., scalingAbsoluteChanged: typing.Callable = ..., scalingChanged: typing.Callable = ..., shadowCasting: bool = ..., shadowCastingChanged: typing.Callable = ..., textChanged: typing.Callable = ..., textColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., textColorChanged: typing.Callable = ..., textureFile: str = ..., textureFileChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., backgroundColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., backgroundColorChanged: typing.Callable = ..., backgroundEnabled: bool = ..., backgroundEnabledChanged: typing.Callable = ..., borderEnabled: bool = ..., borderEnabledChanged: typing.Callable = ..., destroyed: typing.Callable = ..., facingCamera: bool = ..., facingCameraChanged: typing.Callable = ..., font: PySide2.QtGui.QFont = ..., fontChanged: typing.Callable = ..., meshFile: str = ..., meshFileChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., position: PySide2.QtGui.QVector3D = ..., positionAbsolute: bool = ..., positionAbsoluteChanged: typing.Callable = ..., positionChanged: typing.Callable = ..., rotation: PySide2.QtGui.QQuaternion = ..., rotationChanged: typing.Callable = ..., scaling: PySide2.QtGui.QVector3D = ..., scalingAbsolute: bool = ..., scalingAbsoluteChanged: typing.Callable = ..., scalingChanged: typing.Callable = ..., shadowCasting: bool = ..., shadowCastingChanged: typing.Callable = ..., text: str = ..., textChanged: typing.Callable = ..., textColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., textColorChanged: typing.Callable = ..., textureFile: str = ..., textureFileChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        def backgroundColor(self) -> PySide2.QtGui.QColor: ...
        def font(self) -> PySide2.QtGui.QFont: ...
        def isBackgroundEnabled(self) -> bool: ...
        def isBorderEnabled(self) -> bool: ...
        def isFacingCamera(self) -> bool: ...
        def setBackgroundColor(self, color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setBackgroundEnabled(self, enabled: bool) -> None: ...
        def setBorderEnabled(self, enabled: bool) -> None: ...
        def setFacingCamera(self, enabled: bool) -> None: ...
        def setFont(self, font: PySide2.QtGui.QFont) -> None: ...
        def setText(self, text: str) -> None: ...
        def setTextColor(self, color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def text(self) -> str: ...
        def textColor(self) -> PySide2.QtGui.QColor: ...

    class QCustom3DVolume(QtDataVisualization.QCustom3DItem):
        alphaMultiplierChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        colorTableChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        drawSliceFramesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        drawSlicesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        preserveOpacityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sliceFrameColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sliceFrameGapsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sliceFrameThicknessesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sliceFrameWidthsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sliceIndexXChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sliceIndexYChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sliceIndexZChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        textureDataChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        textureDepthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        textureFormatChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        textureHeightChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        textureWidthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        useHighDefShaderChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @typing.overload
        def __init__(self, position: PySide2.QtGui.QVector3D, scaling: PySide2.QtGui.QVector3D, rotation: PySide2.QtGui.QQuaternion, textureWidth: int, textureHeight: int, textureDepth: int, textureData: typing.List[int], textureFormat: PySide2.QtGui.QImage.Format, colorTable: typing.List[int], parent: PySide2.QtCore.QObject | None = ..., alphaMultiplier: float = ..., alphaMultiplierChanged: typing.Callable = ..., colorTableChanged: typing.Callable = ..., destroyed: typing.Callable = ..., drawSliceFrames: bool = ..., drawSliceFramesChanged: typing.Callable = ..., drawSlices: bool = ..., drawSlicesChanged: typing.Callable = ..., meshFile: str = ..., meshFileChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., positionAbsolute: bool = ..., positionAbsoluteChanged: typing.Callable = ..., positionChanged: typing.Callable = ..., preserveOpacity: bool = ..., preserveOpacityChanged: typing.Callable = ..., rotationChanged: typing.Callable = ..., scalingAbsolute: bool = ..., scalingAbsoluteChanged: typing.Callable = ..., scalingChanged: typing.Callable = ..., shadowCasting: bool = ..., shadowCastingChanged: typing.Callable = ..., sliceFrameColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., sliceFrameColorChanged: typing.Callable = ..., sliceFrameGaps: PySide2.QtGui.QVector3D = ..., sliceFrameGapsChanged: typing.Callable = ..., sliceFrameThicknesses: PySide2.QtGui.QVector3D = ..., sliceFrameThicknessesChanged: typing.Callable = ..., sliceFrameWidths: PySide2.QtGui.QVector3D = ..., sliceFrameWidthsChanged: typing.Callable = ..., sliceIndexX: int = ..., sliceIndexXChanged: typing.Callable = ..., sliceIndexY: int = ..., sliceIndexYChanged: typing.Callable = ..., sliceIndexZ: int = ..., sliceIndexZChanged: typing.Callable = ..., textureDataChanged: typing.Callable = ..., textureDepthChanged: typing.Callable = ..., textureFile: str = ..., textureFileChanged: typing.Callable = ..., textureFormatChanged: typing.Callable = ..., textureHeightChanged: typing.Callable = ..., textureWidthChanged: typing.Callable = ..., useHighDefShader: bool = ..., useHighDefShaderChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., alphaMultiplier: float = ..., alphaMultiplierChanged: typing.Callable = ..., colorTable: typing.List[int] = ..., colorTableChanged: typing.Callable = ..., destroyed: typing.Callable = ..., drawSliceFrames: bool = ..., drawSliceFramesChanged: typing.Callable = ..., drawSlices: bool = ..., drawSlicesChanged: typing.Callable = ..., meshFile: str = ..., meshFileChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., position: PySide2.QtGui.QVector3D = ..., positionAbsolute: bool = ..., positionAbsoluteChanged: typing.Callable = ..., positionChanged: typing.Callable = ..., preserveOpacity: bool = ..., preserveOpacityChanged: typing.Callable = ..., rotation: PySide2.QtGui.QQuaternion = ..., rotationChanged: typing.Callable = ..., scaling: PySide2.QtGui.QVector3D = ..., scalingAbsolute: bool = ..., scalingAbsoluteChanged: typing.Callable = ..., scalingChanged: typing.Callable = ..., shadowCasting: bool = ..., shadowCastingChanged: typing.Callable = ..., sliceFrameColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., sliceFrameColorChanged: typing.Callable = ..., sliceFrameGaps: PySide2.QtGui.QVector3D = ..., sliceFrameGapsChanged: typing.Callable = ..., sliceFrameThicknesses: PySide2.QtGui.QVector3D = ..., sliceFrameThicknessesChanged: typing.Callable = ..., sliceFrameWidths: PySide2.QtGui.QVector3D = ..., sliceFrameWidthsChanged: typing.Callable = ..., sliceIndexX: int = ..., sliceIndexXChanged: typing.Callable = ..., sliceIndexY: int = ..., sliceIndexYChanged: typing.Callable = ..., sliceIndexZ: int = ..., sliceIndexZChanged: typing.Callable = ..., textureData: typing.List[int] = ..., textureDataChanged: typing.Callable = ..., textureDepth: int = ..., textureDepthChanged: typing.Callable = ..., textureFile: str = ..., textureFileChanged: typing.Callable = ..., textureFormatChanged: typing.Callable = ..., textureHeight: int = ..., textureHeightChanged: typing.Callable = ..., textureWidth: int = ..., textureWidthChanged: typing.Callable = ..., useHighDefShader: bool = ..., useHighDefShaderChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ...) -> None: ...
        def alphaMultiplier(self) -> float: ...
        def colorTable(self) -> typing.List[int]: ...
        def createTextureData(self, images: typing.List[PySide2.QtGui.QImage]) -> typing.List[int]: ...
        def drawSliceFrames(self) -> bool: ...
        def drawSlices(self) -> bool: ...
        def preserveOpacity(self) -> bool: ...
        def renderSlice(self, axis: PySide2.QtCore.Qt.Axis, index: int) -> PySide2.QtGui.QImage: ...
        def setAlphaMultiplier(self, mult: float) -> None: ...
        def setColorTable(self, colors: typing.List[int]) -> None: ...
        def setDrawSliceFrames(self, enable: bool) -> None: ...
        def setDrawSlices(self, enable: bool) -> None: ...
        def setPreserveOpacity(self, enable: bool) -> None: ...
        def setSliceFrameColor(self, color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
        def setSliceFrameGaps(self, values: PySide2.QtGui.QVector3D) -> None: ...
        def setSliceFrameThicknesses(self, values: PySide2.QtGui.QVector3D) -> None: ...
        def setSliceFrameWidths(self, values: PySide2.QtGui.QVector3D) -> None: ...
        def setSliceIndexX(self, value: int) -> None: ...
        def setSliceIndexY(self, value: int) -> None: ...
        def setSliceIndexZ(self, value: int) -> None: ...
        def setSliceIndices(self, x: int, y: int, z: int) -> None: ...
        @typing.overload
        def setSubTextureData(self, axis: PySide2.QtCore.Qt.Axis, index: int, image: PySide2.QtGui.QImage) -> None: ...
        @typing.overload
        def setSubTextureData(self, axis: PySide2.QtCore.Qt.Axis, index: int, data: bytes) -> None: ...
        def setTextureData(self, data: typing.List[int]) -> None: ...
        def setTextureDepth(self, value: int) -> None: ...
        def setTextureDimensions(self, width: int, height: int, depth: int) -> None: ...
        def setTextureFormat(self, format: PySide2.QtGui.QImage.Format) -> None: ...
        def setTextureHeight(self, value: int) -> None: ...
        def setTextureWidth(self, value: int) -> None: ...
        def setUseHighDefShader(self, enable: bool) -> None: ...
        def sliceFrameColor(self) -> PySide2.QtGui.QColor: ...
        def sliceFrameGaps(self) -> PySide2.QtGui.QVector3D: ...
        def sliceFrameThicknesses(self) -> PySide2.QtGui.QVector3D: ...
        def sliceFrameWidths(self) -> PySide2.QtGui.QVector3D: ...
        def sliceIndexX(self) -> int: ...
        def sliceIndexY(self) -> int: ...
        def sliceIndexZ(self) -> int: ...
        def textureData(self) -> typing.List[int]: ...
        def textureDataWidth(self) -> int: ...
        def textureDepth(self) -> int: ...
        def textureFormat(self) -> PySide2.QtGui.QImage.Format: ...
        def textureHeight(self) -> int: ...
        def textureWidth(self) -> int: ...
        def useHighDefShader(self) -> bool: ...

    class QHeightMapSurfaceDataProxy(QtDataVisualization.QSurfaceDataProxy):
        heightMapChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        heightMapFileChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        maxXValueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        maxZValueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        minXValueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        minZValueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @typing.overload
        def __init__(self, image: PySide2.QtGui.QImage, parent: PySide2.QtCore.QObject | None = ..., arrayReset: typing.Callable = ..., columnCount: int = ..., columnCountChanged: typing.Callable = ..., destroyed: typing.Callable = ..., heightMap: PySide2.QtGui.QImage = ..., heightMapChanged: typing.Callable = ..., heightMapFile: str = ..., heightMapFileChanged: typing.Callable = ..., itemChanged: typing.Callable = ..., maxXValue: float = ..., maxXValueChanged: typing.Callable = ..., maxZValue: float = ..., maxZValueChanged: typing.Callable = ..., minXValue: float = ..., minXValueChanged: typing.Callable = ..., minZValue: float = ..., minZValueChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowCount: int = ..., rowCountChanged: typing.Callable = ..., rowsAdded: typing.Callable = ..., rowsChanged: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsRemoved: typing.Callable = ..., series: typing.Any = ..., seriesChanged: typing.Callable = ..., type: QtDataVisualization.QHeightMapSurfaceDataProxy.DataType = ...) -> None: ...
        @typing.overload
        def __init__(self, filename: str, parent: PySide2.QtCore.QObject | None = ..., arrayReset: typing.Callable = ..., columnCount: int = ..., columnCountChanged: typing.Callable = ..., destroyed: typing.Callable = ..., heightMap: PySide2.QtGui.QImage = ..., heightMapChanged: typing.Callable = ..., heightMapFile: str = ..., heightMapFileChanged: typing.Callable = ..., itemChanged: typing.Callable = ..., maxXValue: float = ..., maxXValueChanged: typing.Callable = ..., maxZValue: float = ..., maxZValueChanged: typing.Callable = ..., minXValue: float = ..., minXValueChanged: typing.Callable = ..., minZValue: float = ..., minZValueChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowCount: int = ..., rowCountChanged: typing.Callable = ..., rowsAdded: typing.Callable = ..., rowsChanged: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsRemoved: typing.Callable = ..., series: typing.Any = ..., seriesChanged: typing.Callable = ..., type: QtDataVisualization.QHeightMapSurfaceDataProxy.DataType = ...) -> None: ...
        @typing.overload
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., arrayReset: typing.Callable = ..., columnCount: int = ..., columnCountChanged: typing.Callable = ..., destroyed: typing.Callable = ..., heightMap: PySide2.QtGui.QImage = ..., heightMapChanged: typing.Callable = ..., heightMapFile: str = ..., heightMapFileChanged: typing.Callable = ..., itemChanged: typing.Callable = ..., maxXValue: float = ..., maxXValueChanged: typing.Callable = ..., maxZValue: float = ..., maxZValueChanged: typing.Callable = ..., minXValue: float = ..., minXValueChanged: typing.Callable = ..., minZValue: float = ..., minZValueChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowCount: int = ..., rowCountChanged: typing.Callable = ..., rowsAdded: typing.Callable = ..., rowsChanged: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsRemoved: typing.Callable = ..., series: typing.Any = ..., seriesChanged: typing.Callable = ..., type: QtDataVisualization.QHeightMapSurfaceDataProxy.DataType = ...) -> None: ...
        def heightMap(self) -> PySide2.QtGui.QImage: ...
        def heightMapFile(self) -> str: ...
        def maxXValue(self) -> float: ...
        def maxZValue(self) -> float: ...
        def minXValue(self) -> float: ...
        def minZValue(self) -> float: ...
        def setHeightMap(self, image: PySide2.QtGui.QImage) -> None: ...
        def setHeightMapFile(self, filename: str) -> None: ...
        def setMaxXValue(self, max: float) -> None: ...
        def setMaxZValue(self, max: float) -> None: ...
        def setMinXValue(self, min: float) -> None: ...
        def setMinZValue(self, min: float) -> None: ...
        def setValueRanges(self, minX: float, maxX: float, minZ: float, maxZ: float) -> None: ...

    class QItemModelBarDataProxy(QtDataVisualization.QBarDataProxy):
        class MultiMatchBehavior:
            MMBAverage: typing.ClassVar[QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior] = ...
            MMBCumulative: typing.ClassVar[QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior] = ...
            MMBFirst: typing.ClassVar[QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior] = ...
            MMBLast: typing.ClassVar[QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior: ...
            def __and__(self, other: typing.SupportsInt) -> QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior: ...
            def __rand__(self, other: typing.SupportsInt) -> QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior: ...
            def __ror__(self, other: typing.SupportsInt) -> QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior: ...
            def __sub__(self, other: typing.SupportsInt) -> QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior: ...
            def __xor__(self, other: typing.SupportsInt) -> QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior: ...
        MMBAverage: typing.ClassVar[QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior] = ...
        MMBCumulative: typing.ClassVar[QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior] = ...
        MMBFirst: typing.ClassVar[QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior] = ...
        MMBLast: typing.ClassVar[QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior] = ...
        autoColumnCategoriesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        autoRowCategoriesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        columnCategoriesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        columnRoleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        columnRolePatternChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        columnRoleReplaceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        itemModelChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        multiMatchBehaviorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rotationRoleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rotationRolePatternChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rotationRoleReplaceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowCategoriesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowRoleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowRolePatternChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowRoleReplaceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        useModelCategoriesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        valueRoleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        valueRolePatternChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        valueRoleReplaceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, rowRole: str, columnRole: str, valueRole: str, rotationRole: str, rowCategories: typing.Iterable[str], columnCategories: typing.Iterable[str], parent: PySide2.QtCore.QObject | None = ..., arrayReset: typing.Callable = ..., autoColumnCategories: bool = ..., autoColumnCategoriesChanged: typing.Callable = ..., autoRowCategories: bool = ..., autoRowCategoriesChanged: typing.Callable = ..., columnCategoriesChanged: typing.Callable = ..., columnLabels: None = ..., columnLabelsChanged: typing.Callable = ..., columnRoleChanged: typing.Callable = ..., columnRolePattern: PySide2.QtCore.QRegExp = ..., columnRolePatternChanged: typing.Callable = ..., columnRoleReplace: str = ..., columnRoleReplaceChanged: typing.Callable = ..., destroyed: typing.Callable = ..., itemChanged: typing.Callable = ..., itemModelChanged: typing.Callable = ..., multiMatchBehavior: QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior = ..., multiMatchBehaviorChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rotationRoleChanged: typing.Callable = ..., rotationRolePattern: PySide2.QtCore.QRegExp = ..., rotationRolePatternChanged: typing.Callable = ..., rotationRoleReplace: str = ..., rotationRoleReplaceChanged: typing.Callable = ..., rowCategoriesChanged: typing.Callable = ..., rowCount: int = ..., rowCountChanged: typing.Callable = ..., rowLabels: None = ..., rowLabelsChanged: typing.Callable = ..., rowRoleChanged: typing.Callable = ..., rowRolePattern: PySide2.QtCore.QRegExp = ..., rowRolePatternChanged: typing.Callable = ..., rowRoleReplace: str = ..., rowRoleReplaceChanged: typing.Callable = ..., rowsAdded: typing.Callable = ..., rowsChanged: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsRemoved: typing.Callable = ..., series: typing.Any = ..., seriesChanged: typing.Callable = ..., type: QtDataVisualization.QItemModelBarDataProxy.DataType = ..., useModelCategories: bool = ..., useModelCategoriesChanged: typing.Callable = ..., valueRoleChanged: typing.Callable = ..., valueRolePattern: PySide2.QtCore.QRegExp = ..., valueRolePatternChanged: typing.Callable = ..., valueRoleReplace: str = ..., valueRoleReplaceChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, rowRole: str, columnRole: str, valueRole: str, rowCategories: typing.Iterable[str], columnCategories: typing.Iterable[str], parent: PySide2.QtCore.QObject | None = ..., arrayReset: typing.Callable = ..., autoColumnCategories: bool = ..., autoColumnCategoriesChanged: typing.Callable = ..., autoRowCategories: bool = ..., autoRowCategoriesChanged: typing.Callable = ..., columnCategoriesChanged: typing.Callable = ..., columnLabels: None = ..., columnLabelsChanged: typing.Callable = ..., columnRoleChanged: typing.Callable = ..., columnRolePattern: PySide2.QtCore.QRegExp = ..., columnRolePatternChanged: typing.Callable = ..., columnRoleReplace: str = ..., columnRoleReplaceChanged: typing.Callable = ..., destroyed: typing.Callable = ..., itemChanged: typing.Callable = ..., itemModelChanged: typing.Callable = ..., multiMatchBehavior: QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior = ..., multiMatchBehaviorChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rotationRole: str = ..., rotationRoleChanged: typing.Callable = ..., rotationRolePattern: PySide2.QtCore.QRegExp = ..., rotationRolePatternChanged: typing.Callable = ..., rotationRoleReplace: str = ..., rotationRoleReplaceChanged: typing.Callable = ..., rowCategoriesChanged: typing.Callable = ..., rowCount: int = ..., rowCountChanged: typing.Callable = ..., rowLabels: None = ..., rowLabelsChanged: typing.Callable = ..., rowRoleChanged: typing.Callable = ..., rowRolePattern: PySide2.QtCore.QRegExp = ..., rowRolePatternChanged: typing.Callable = ..., rowRoleReplace: str = ..., rowRoleReplaceChanged: typing.Callable = ..., rowsAdded: typing.Callable = ..., rowsChanged: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsRemoved: typing.Callable = ..., series: typing.Any = ..., seriesChanged: typing.Callable = ..., type: QtDataVisualization.QItemModelBarDataProxy.DataType = ..., useModelCategories: bool = ..., useModelCategoriesChanged: typing.Callable = ..., valueRoleChanged: typing.Callable = ..., valueRolePattern: PySide2.QtCore.QRegExp = ..., valueRolePatternChanged: typing.Callable = ..., valueRoleReplace: str = ..., valueRoleReplaceChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, rowRole: str, columnRole: str, valueRole: str, rotationRole: str, parent: PySide2.QtCore.QObject | None = ..., arrayReset: typing.Callable = ..., autoColumnCategories: bool = ..., autoColumnCategoriesChanged: typing.Callable = ..., autoRowCategories: bool = ..., autoRowCategoriesChanged: typing.Callable = ..., columnCategories: None = ..., columnCategoriesChanged: typing.Callable = ..., columnLabels: None = ..., columnLabelsChanged: typing.Callable = ..., columnRoleChanged: typing.Callable = ..., columnRolePattern: PySide2.QtCore.QRegExp = ..., columnRolePatternChanged: typing.Callable = ..., columnRoleReplace: str = ..., columnRoleReplaceChanged: typing.Callable = ..., destroyed: typing.Callable = ..., itemChanged: typing.Callable = ..., itemModelChanged: typing.Callable = ..., multiMatchBehavior: QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior = ..., multiMatchBehaviorChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rotationRoleChanged: typing.Callable = ..., rotationRolePattern: PySide2.QtCore.QRegExp = ..., rotationRolePatternChanged: typing.Callable = ..., rotationRoleReplace: str = ..., rotationRoleReplaceChanged: typing.Callable = ..., rowCategories: None = ..., rowCategoriesChanged: typing.Callable = ..., rowCount: int = ..., rowCountChanged: typing.Callable = ..., rowLabels: None = ..., rowLabelsChanged: typing.Callable = ..., rowRoleChanged: typing.Callable = ..., rowRolePattern: PySide2.QtCore.QRegExp = ..., rowRolePatternChanged: typing.Callable = ..., rowRoleReplace: str = ..., rowRoleReplaceChanged: typing.Callable = ..., rowsAdded: typing.Callable = ..., rowsChanged: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsRemoved: typing.Callable = ..., series: typing.Any = ..., seriesChanged: typing.Callable = ..., type: QtDataVisualization.QItemModelBarDataProxy.DataType = ..., useModelCategories: bool = ..., useModelCategoriesChanged: typing.Callable = ..., valueRoleChanged: typing.Callable = ..., valueRolePattern: PySide2.QtCore.QRegExp = ..., valueRolePatternChanged: typing.Callable = ..., valueRoleReplace: str = ..., valueRoleReplaceChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, rowRole: str, columnRole: str, valueRole: str, parent: PySide2.QtCore.QObject | None = ..., arrayReset: typing.Callable = ..., autoColumnCategories: bool = ..., autoColumnCategoriesChanged: typing.Callable = ..., autoRowCategories: bool = ..., autoRowCategoriesChanged: typing.Callable = ..., columnCategories: None = ..., columnCategoriesChanged: typing.Callable = ..., columnLabels: None = ..., columnLabelsChanged: typing.Callable = ..., columnRoleChanged: typing.Callable = ..., columnRolePattern: PySide2.QtCore.QRegExp = ..., columnRolePatternChanged: typing.Callable = ..., columnRoleReplace: str = ..., columnRoleReplaceChanged: typing.Callable = ..., destroyed: typing.Callable = ..., itemChanged: typing.Callable = ..., itemModelChanged: typing.Callable = ..., multiMatchBehavior: QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior = ..., multiMatchBehaviorChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rotationRole: str = ..., rotationRoleChanged: typing.Callable = ..., rotationRolePattern: PySide2.QtCore.QRegExp = ..., rotationRolePatternChanged: typing.Callable = ..., rotationRoleReplace: str = ..., rotationRoleReplaceChanged: typing.Callable = ..., rowCategories: None = ..., rowCategoriesChanged: typing.Callable = ..., rowCount: int = ..., rowCountChanged: typing.Callable = ..., rowLabels: None = ..., rowLabelsChanged: typing.Callable = ..., rowRoleChanged: typing.Callable = ..., rowRolePattern: PySide2.QtCore.QRegExp = ..., rowRolePatternChanged: typing.Callable = ..., rowRoleReplace: str = ..., rowRoleReplaceChanged: typing.Callable = ..., rowsAdded: typing.Callable = ..., rowsChanged: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsRemoved: typing.Callable = ..., series: typing.Any = ..., seriesChanged: typing.Callable = ..., type: QtDataVisualization.QItemModelBarDataProxy.DataType = ..., useModelCategories: bool = ..., useModelCategoriesChanged: typing.Callable = ..., valueRoleChanged: typing.Callable = ..., valueRolePattern: PySide2.QtCore.QRegExp = ..., valueRolePatternChanged: typing.Callable = ..., valueRoleReplace: str = ..., valueRoleReplaceChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, valueRole: str, parent: PySide2.QtCore.QObject | None = ..., arrayReset: typing.Callable = ..., autoColumnCategories: bool = ..., autoColumnCategoriesChanged: typing.Callable = ..., autoRowCategories: bool = ..., autoRowCategoriesChanged: typing.Callable = ..., columnCategories: None = ..., columnCategoriesChanged: typing.Callable = ..., columnLabels: None = ..., columnLabelsChanged: typing.Callable = ..., columnRole: str = ..., columnRoleChanged: typing.Callable = ..., columnRolePattern: PySide2.QtCore.QRegExp = ..., columnRolePatternChanged: typing.Callable = ..., columnRoleReplace: str = ..., columnRoleReplaceChanged: typing.Callable = ..., destroyed: typing.Callable = ..., itemChanged: typing.Callable = ..., itemModelChanged: typing.Callable = ..., multiMatchBehavior: QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior = ..., multiMatchBehaviorChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rotationRole: str = ..., rotationRoleChanged: typing.Callable = ..., rotationRolePattern: PySide2.QtCore.QRegExp = ..., rotationRolePatternChanged: typing.Callable = ..., rotationRoleReplace: str = ..., rotationRoleReplaceChanged: typing.Callable = ..., rowCategories: None = ..., rowCategoriesChanged: typing.Callable = ..., rowCount: int = ..., rowCountChanged: typing.Callable = ..., rowLabels: None = ..., rowLabelsChanged: typing.Callable = ..., rowRole: str = ..., rowRoleChanged: typing.Callable = ..., rowRolePattern: PySide2.QtCore.QRegExp = ..., rowRolePatternChanged: typing.Callable = ..., rowRoleReplace: str = ..., rowRoleReplaceChanged: typing.Callable = ..., rowsAdded: typing.Callable = ..., rowsChanged: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsRemoved: typing.Callable = ..., series: typing.Any = ..., seriesChanged: typing.Callable = ..., type: QtDataVisualization.QItemModelBarDataProxy.DataType = ..., useModelCategories: bool = ..., useModelCategoriesChanged: typing.Callable = ..., valueRoleChanged: typing.Callable = ..., valueRolePattern: PySide2.QtCore.QRegExp = ..., valueRolePatternChanged: typing.Callable = ..., valueRoleReplace: str = ..., valueRoleReplaceChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, parent: PySide2.QtCore.QObject | None = ..., arrayReset: typing.Callable = ..., autoColumnCategories: bool = ..., autoColumnCategoriesChanged: typing.Callable = ..., autoRowCategories: bool = ..., autoRowCategoriesChanged: typing.Callable = ..., columnCategories: None = ..., columnCategoriesChanged: typing.Callable = ..., columnLabels: None = ..., columnLabelsChanged: typing.Callable = ..., columnRole: str = ..., columnRoleChanged: typing.Callable = ..., columnRolePattern: PySide2.QtCore.QRegExp = ..., columnRolePatternChanged: typing.Callable = ..., columnRoleReplace: str = ..., columnRoleReplaceChanged: typing.Callable = ..., destroyed: typing.Callable = ..., itemChanged: typing.Callable = ..., itemModelChanged: typing.Callable = ..., multiMatchBehavior: QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior = ..., multiMatchBehaviorChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rotationRole: str = ..., rotationRoleChanged: typing.Callable = ..., rotationRolePattern: PySide2.QtCore.QRegExp = ..., rotationRolePatternChanged: typing.Callable = ..., rotationRoleReplace: str = ..., rotationRoleReplaceChanged: typing.Callable = ..., rowCategories: None = ..., rowCategoriesChanged: typing.Callable = ..., rowCount: int = ..., rowCountChanged: typing.Callable = ..., rowLabels: None = ..., rowLabelsChanged: typing.Callable = ..., rowRole: str = ..., rowRoleChanged: typing.Callable = ..., rowRolePattern: PySide2.QtCore.QRegExp = ..., rowRolePatternChanged: typing.Callable = ..., rowRoleReplace: str = ..., rowRoleReplaceChanged: typing.Callable = ..., rowsAdded: typing.Callable = ..., rowsChanged: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsRemoved: typing.Callable = ..., series: typing.Any = ..., seriesChanged: typing.Callable = ..., type: QtDataVisualization.QItemModelBarDataProxy.DataType = ..., useModelCategories: bool = ..., useModelCategoriesChanged: typing.Callable = ..., valueRole: str = ..., valueRoleChanged: typing.Callable = ..., valueRolePattern: PySide2.QtCore.QRegExp = ..., valueRolePatternChanged: typing.Callable = ..., valueRoleReplace: str = ..., valueRoleReplaceChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., arrayReset: typing.Callable = ..., autoColumnCategories: bool = ..., autoColumnCategoriesChanged: typing.Callable = ..., autoRowCategories: bool = ..., autoRowCategoriesChanged: typing.Callable = ..., columnCategories: None = ..., columnCategoriesChanged: typing.Callable = ..., columnLabels: None = ..., columnLabelsChanged: typing.Callable = ..., columnRole: str = ..., columnRoleChanged: typing.Callable = ..., columnRolePattern: PySide2.QtCore.QRegExp = ..., columnRolePatternChanged: typing.Callable = ..., columnRoleReplace: str = ..., columnRoleReplaceChanged: typing.Callable = ..., destroyed: typing.Callable = ..., itemChanged: typing.Callable = ..., itemModel: PySide2.QtCore.QAbstractItemModel = ..., itemModelChanged: typing.Callable = ..., multiMatchBehavior: QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior = ..., multiMatchBehaviorChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rotationRole: str = ..., rotationRoleChanged: typing.Callable = ..., rotationRolePattern: PySide2.QtCore.QRegExp = ..., rotationRolePatternChanged: typing.Callable = ..., rotationRoleReplace: str = ..., rotationRoleReplaceChanged: typing.Callable = ..., rowCategories: None = ..., rowCategoriesChanged: typing.Callable = ..., rowCount: int = ..., rowCountChanged: typing.Callable = ..., rowLabels: None = ..., rowLabelsChanged: typing.Callable = ..., rowRole: str = ..., rowRoleChanged: typing.Callable = ..., rowRolePattern: PySide2.QtCore.QRegExp = ..., rowRolePatternChanged: typing.Callable = ..., rowRoleReplace: str = ..., rowRoleReplaceChanged: typing.Callable = ..., rowsAdded: typing.Callable = ..., rowsChanged: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsRemoved: typing.Callable = ..., series: typing.Any = ..., seriesChanged: typing.Callable = ..., type: QtDataVisualization.QItemModelBarDataProxy.DataType = ..., useModelCategories: bool = ..., useModelCategoriesChanged: typing.Callable = ..., valueRole: str = ..., valueRoleChanged: typing.Callable = ..., valueRolePattern: PySide2.QtCore.QRegExp = ..., valueRolePatternChanged: typing.Callable = ..., valueRoleReplace: str = ..., valueRoleReplaceChanged: typing.Callable = ...) -> None: ...
        def autoColumnCategories(self) -> bool: ...
        def autoRowCategories(self) -> bool: ...
        def columnCategories(self) -> typing.List[str]: ...
        def columnCategoryIndex(self, category: str) -> int: ...
        def columnRole(self) -> str: ...
        def columnRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def columnRoleReplace(self) -> str: ...
        def itemModel(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def multiMatchBehavior(self) -> QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior: ...
        def remap(self, rowRole: str, columnRole: str, valueRole: str, rotationRole: str, rowCategories: typing.Iterable[str], columnCategories: typing.Iterable[str]) -> None: ...
        def rotationRole(self) -> str: ...
        def rotationRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def rotationRoleReplace(self) -> str: ...
        def rowCategories(self) -> typing.List[str]: ...
        def rowCategoryIndex(self, category: str) -> int: ...
        def rowRole(self) -> str: ...
        def rowRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def rowRoleReplace(self) -> str: ...
        def setAutoColumnCategories(self, enable: bool) -> None: ...
        def setAutoRowCategories(self, enable: bool) -> None: ...
        def setColumnCategories(self, categories: typing.Iterable[str]) -> None: ...
        def setColumnRole(self, role: str) -> None: ...
        def setColumnRolePattern(self, pattern: PySide2.QtCore.QRegExp) -> None: ...
        def setColumnRoleReplace(self, replace: str) -> None: ...
        def setItemModel(self, itemModel: PySide2.QtCore.QAbstractItemModel) -> None: ...
        def setMultiMatchBehavior(self, behavior: QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior) -> None: ...
        def setRotationRole(self, role: str) -> None: ...
        def setRotationRolePattern(self, pattern: PySide2.QtCore.QRegExp) -> None: ...
        def setRotationRoleReplace(self, replace: str) -> None: ...
        def setRowCategories(self, categories: typing.Iterable[str]) -> None: ...
        def setRowRole(self, role: str) -> None: ...
        def setRowRolePattern(self, pattern: PySide2.QtCore.QRegExp) -> None: ...
        def setRowRoleReplace(self, replace: str) -> None: ...
        def setUseModelCategories(self, enable: bool) -> None: ...
        def setValueRole(self, role: str) -> None: ...
        def setValueRolePattern(self, pattern: PySide2.QtCore.QRegExp) -> None: ...
        def setValueRoleReplace(self, replace: str) -> None: ...
        def useModelCategories(self) -> bool: ...
        def valueRole(self) -> str: ...
        def valueRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def valueRoleReplace(self) -> str: ...

    class QItemModelScatterDataProxy(QtDataVisualization.QScatterDataProxy):
        itemModelChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rotationRoleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rotationRolePatternChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rotationRoleReplaceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        xPosRoleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        xPosRolePatternChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        xPosRoleReplaceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        yPosRoleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        yPosRolePatternChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        yPosRoleReplaceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        zPosRoleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        zPosRolePatternChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        zPosRoleReplaceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, xPosRole: str, yPosRole: str, zPosRole: str, rotationRole: str, parent: PySide2.QtCore.QObject | None = ..., arrayReset: typing.Callable = ..., destroyed: typing.Callable = ..., itemCount: int = ..., itemCountChanged: typing.Callable = ..., itemModelChanged: typing.Callable = ..., itemsAdded: typing.Callable = ..., itemsChanged: typing.Callable = ..., itemsInserted: typing.Callable = ..., itemsRemoved: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rotationRoleChanged: typing.Callable = ..., rotationRolePattern: PySide2.QtCore.QRegExp = ..., rotationRolePatternChanged: typing.Callable = ..., rotationRoleReplace: str = ..., rotationRoleReplaceChanged: typing.Callable = ..., series: typing.Any = ..., seriesChanged: typing.Callable = ..., type: QtDataVisualization.QItemModelScatterDataProxy.DataType = ..., xPosRoleChanged: typing.Callable = ..., xPosRolePattern: PySide2.QtCore.QRegExp = ..., xPosRolePatternChanged: typing.Callable = ..., xPosRoleReplace: str = ..., xPosRoleReplaceChanged: typing.Callable = ..., yPosRoleChanged: typing.Callable = ..., yPosRolePattern: PySide2.QtCore.QRegExp = ..., yPosRolePatternChanged: typing.Callable = ..., yPosRoleReplace: str = ..., yPosRoleReplaceChanged: typing.Callable = ..., zPosRoleChanged: typing.Callable = ..., zPosRolePattern: PySide2.QtCore.QRegExp = ..., zPosRolePatternChanged: typing.Callable = ..., zPosRoleReplace: str = ..., zPosRoleReplaceChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, xPosRole: str, yPosRole: str, zPosRole: str, parent: PySide2.QtCore.QObject | None = ..., arrayReset: typing.Callable = ..., destroyed: typing.Callable = ..., itemCount: int = ..., itemCountChanged: typing.Callable = ..., itemModelChanged: typing.Callable = ..., itemsAdded: typing.Callable = ..., itemsChanged: typing.Callable = ..., itemsInserted: typing.Callable = ..., itemsRemoved: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rotationRole: str = ..., rotationRoleChanged: typing.Callable = ..., rotationRolePattern: PySide2.QtCore.QRegExp = ..., rotationRolePatternChanged: typing.Callable = ..., rotationRoleReplace: str = ..., rotationRoleReplaceChanged: typing.Callable = ..., series: typing.Any = ..., seriesChanged: typing.Callable = ..., type: QtDataVisualization.QItemModelScatterDataProxy.DataType = ..., xPosRoleChanged: typing.Callable = ..., xPosRolePattern: PySide2.QtCore.QRegExp = ..., xPosRolePatternChanged: typing.Callable = ..., xPosRoleReplace: str = ..., xPosRoleReplaceChanged: typing.Callable = ..., yPosRoleChanged: typing.Callable = ..., yPosRolePattern: PySide2.QtCore.QRegExp = ..., yPosRolePatternChanged: typing.Callable = ..., yPosRoleReplace: str = ..., yPosRoleReplaceChanged: typing.Callable = ..., zPosRoleChanged: typing.Callable = ..., zPosRolePattern: PySide2.QtCore.QRegExp = ..., zPosRolePatternChanged: typing.Callable = ..., zPosRoleReplace: str = ..., zPosRoleReplaceChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, parent: PySide2.QtCore.QObject | None = ..., arrayReset: typing.Callable = ..., destroyed: typing.Callable = ..., itemCount: int = ..., itemCountChanged: typing.Callable = ..., itemModelChanged: typing.Callable = ..., itemsAdded: typing.Callable = ..., itemsChanged: typing.Callable = ..., itemsInserted: typing.Callable = ..., itemsRemoved: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rotationRole: str = ..., rotationRoleChanged: typing.Callable = ..., rotationRolePattern: PySide2.QtCore.QRegExp = ..., rotationRolePatternChanged: typing.Callable = ..., rotationRoleReplace: str = ..., rotationRoleReplaceChanged: typing.Callable = ..., series: typing.Any = ..., seriesChanged: typing.Callable = ..., type: QtDataVisualization.QItemModelScatterDataProxy.DataType = ..., xPosRole: str = ..., xPosRoleChanged: typing.Callable = ..., xPosRolePattern: PySide2.QtCore.QRegExp = ..., xPosRolePatternChanged: typing.Callable = ..., xPosRoleReplace: str = ..., xPosRoleReplaceChanged: typing.Callable = ..., yPosRole: str = ..., yPosRoleChanged: typing.Callable = ..., yPosRolePattern: PySide2.QtCore.QRegExp = ..., yPosRolePatternChanged: typing.Callable = ..., yPosRoleReplace: str = ..., yPosRoleReplaceChanged: typing.Callable = ..., zPosRole: str = ..., zPosRoleChanged: typing.Callable = ..., zPosRolePattern: PySide2.QtCore.QRegExp = ..., zPosRolePatternChanged: typing.Callable = ..., zPosRoleReplace: str = ..., zPosRoleReplaceChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., arrayReset: typing.Callable = ..., destroyed: typing.Callable = ..., itemCount: int = ..., itemCountChanged: typing.Callable = ..., itemModel: PySide2.QtCore.QAbstractItemModel = ..., itemModelChanged: typing.Callable = ..., itemsAdded: typing.Callable = ..., itemsChanged: typing.Callable = ..., itemsInserted: typing.Callable = ..., itemsRemoved: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rotationRole: str = ..., rotationRoleChanged: typing.Callable = ..., rotationRolePattern: PySide2.QtCore.QRegExp = ..., rotationRolePatternChanged: typing.Callable = ..., rotationRoleReplace: str = ..., rotationRoleReplaceChanged: typing.Callable = ..., series: typing.Any = ..., seriesChanged: typing.Callable = ..., type: QtDataVisualization.QItemModelScatterDataProxy.DataType = ..., xPosRole: str = ..., xPosRoleChanged: typing.Callable = ..., xPosRolePattern: PySide2.QtCore.QRegExp = ..., xPosRolePatternChanged: typing.Callable = ..., xPosRoleReplace: str = ..., xPosRoleReplaceChanged: typing.Callable = ..., yPosRole: str = ..., yPosRoleChanged: typing.Callable = ..., yPosRolePattern: PySide2.QtCore.QRegExp = ..., yPosRolePatternChanged: typing.Callable = ..., yPosRoleReplace: str = ..., yPosRoleReplaceChanged: typing.Callable = ..., zPosRole: str = ..., zPosRoleChanged: typing.Callable = ..., zPosRolePattern: PySide2.QtCore.QRegExp = ..., zPosRolePatternChanged: typing.Callable = ..., zPosRoleReplace: str = ..., zPosRoleReplaceChanged: typing.Callable = ...) -> None: ...
        def itemModel(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def remap(self, xPosRole: str, yPosRole: str, zPosRole: str, rotationRole: str) -> None: ...
        def rotationRole(self) -> str: ...
        def rotationRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def rotationRoleReplace(self) -> str: ...
        def setItemModel(self, itemModel: PySide2.QtCore.QAbstractItemModel) -> None: ...
        def setRotationRole(self, role: str) -> None: ...
        def setRotationRolePattern(self, pattern: PySide2.QtCore.QRegExp) -> None: ...
        def setRotationRoleReplace(self, replace: str) -> None: ...
        def setXPosRole(self, role: str) -> None: ...
        def setXPosRolePattern(self, pattern: PySide2.QtCore.QRegExp) -> None: ...
        def setXPosRoleReplace(self, replace: str) -> None: ...
        def setYPosRole(self, role: str) -> None: ...
        def setYPosRolePattern(self, pattern: PySide2.QtCore.QRegExp) -> None: ...
        def setYPosRoleReplace(self, replace: str) -> None: ...
        def setZPosRole(self, role: str) -> None: ...
        def setZPosRolePattern(self, pattern: PySide2.QtCore.QRegExp) -> None: ...
        def setZPosRoleReplace(self, replace: str) -> None: ...
        def xPosRole(self) -> str: ...
        def xPosRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def xPosRoleReplace(self) -> str: ...
        def yPosRole(self) -> str: ...
        def yPosRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def yPosRoleReplace(self) -> str: ...
        def zPosRole(self) -> str: ...
        def zPosRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def zPosRoleReplace(self) -> str: ...

    class QItemModelSurfaceDataProxy(QtDataVisualization.QSurfaceDataProxy):
        class MultiMatchBehavior:
            MMBAverage: typing.ClassVar[QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior] = ...
            MMBCumulativeY: typing.ClassVar[QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior] = ...
            MMBFirst: typing.ClassVar[QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior] = ...
            MMBLast: typing.ClassVar[QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior: ...
            def __and__(self, other: typing.SupportsInt) -> QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior: ...
            def __pos__(self): ...
            def __radd__(self, other: typing.SupportsInt) -> QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior: ...
            def __rand__(self, other: typing.SupportsInt) -> QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior: ...
            def __rmul__(self, other: typing.SupportsInt) -> QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior: ...
            def __ror__(self, other: typing.SupportsInt) -> QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior: ...
            def __rsub__(self, other: typing.SupportsInt) -> QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior: ...
            def __sub__(self, other: typing.SupportsInt) -> QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior: ...
            def __xor__(self, other: typing.SupportsInt) -> QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior: ...
        MMBAverage: typing.ClassVar[QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior] = ...
        MMBCumulativeY: typing.ClassVar[QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior] = ...
        MMBFirst: typing.ClassVar[QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior] = ...
        MMBLast: typing.ClassVar[QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior] = ...
        autoColumnCategoriesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        autoRowCategoriesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        columnCategoriesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        columnRoleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        columnRolePatternChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        columnRoleReplaceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        itemModelChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        multiMatchBehaviorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowCategoriesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowRoleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowRolePatternChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowRoleReplaceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        useModelCategoriesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        xPosRoleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        xPosRolePatternChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        xPosRoleReplaceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        yPosRoleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        yPosRolePatternChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        yPosRoleReplaceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        zPosRoleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        zPosRolePatternChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        zPosRoleReplaceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, rowRole: str, columnRole: str, xPosRole: str, yPosRole: str, zPosRole: str, rowCategories: typing.Iterable[str], columnCategories: typing.Iterable[str], parent: PySide2.QtCore.QObject | None = ..., arrayReset: typing.Callable = ..., autoColumnCategories: bool = ..., autoColumnCategoriesChanged: typing.Callable = ..., autoRowCategories: bool = ..., autoRowCategoriesChanged: typing.Callable = ..., columnCategoriesChanged: typing.Callable = ..., columnCount: int = ..., columnCountChanged: typing.Callable = ..., columnRoleChanged: typing.Callable = ..., columnRolePattern: PySide2.QtCore.QRegExp = ..., columnRolePatternChanged: typing.Callable = ..., columnRoleReplace: str = ..., columnRoleReplaceChanged: typing.Callable = ..., destroyed: typing.Callable = ..., itemChanged: typing.Callable = ..., itemModelChanged: typing.Callable = ..., multiMatchBehavior: QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior = ..., multiMatchBehaviorChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowCategoriesChanged: typing.Callable = ..., rowCount: int = ..., rowCountChanged: typing.Callable = ..., rowRoleChanged: typing.Callable = ..., rowRolePattern: PySide2.QtCore.QRegExp = ..., rowRolePatternChanged: typing.Callable = ..., rowRoleReplace: str = ..., rowRoleReplaceChanged: typing.Callable = ..., rowsAdded: typing.Callable = ..., rowsChanged: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsRemoved: typing.Callable = ..., series: typing.Any = ..., seriesChanged: typing.Callable = ..., type: QtDataVisualization.QItemModelSurfaceDataProxy.DataType = ..., useModelCategories: bool = ..., useModelCategoriesChanged: typing.Callable = ..., xPosRoleChanged: typing.Callable = ..., xPosRolePattern: PySide2.QtCore.QRegExp = ..., xPosRolePatternChanged: typing.Callable = ..., xPosRoleReplace: str = ..., xPosRoleReplaceChanged: typing.Callable = ..., yPosRoleChanged: typing.Callable = ..., yPosRolePattern: PySide2.QtCore.QRegExp = ..., yPosRolePatternChanged: typing.Callable = ..., yPosRoleReplace: str = ..., yPosRoleReplaceChanged: typing.Callable = ..., zPosRoleChanged: typing.Callable = ..., zPosRolePattern: PySide2.QtCore.QRegExp = ..., zPosRolePatternChanged: typing.Callable = ..., zPosRoleReplace: str = ..., zPosRoleReplaceChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, rowRole: str, columnRole: str, yPosRole: str, rowCategories: typing.Iterable[str], columnCategories: typing.Iterable[str], parent: PySide2.QtCore.QObject | None = ..., arrayReset: typing.Callable = ..., autoColumnCategories: bool = ..., autoColumnCategoriesChanged: typing.Callable = ..., autoRowCategories: bool = ..., autoRowCategoriesChanged: typing.Callable = ..., columnCategoriesChanged: typing.Callable = ..., columnCount: int = ..., columnCountChanged: typing.Callable = ..., columnRoleChanged: typing.Callable = ..., columnRolePattern: PySide2.QtCore.QRegExp = ..., columnRolePatternChanged: typing.Callable = ..., columnRoleReplace: str = ..., columnRoleReplaceChanged: typing.Callable = ..., destroyed: typing.Callable = ..., itemChanged: typing.Callable = ..., itemModelChanged: typing.Callable = ..., multiMatchBehavior: QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior = ..., multiMatchBehaviorChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowCategoriesChanged: typing.Callable = ..., rowCount: int = ..., rowCountChanged: typing.Callable = ..., rowRoleChanged: typing.Callable = ..., rowRolePattern: PySide2.QtCore.QRegExp = ..., rowRolePatternChanged: typing.Callable = ..., rowRoleReplace: str = ..., rowRoleReplaceChanged: typing.Callable = ..., rowsAdded: typing.Callable = ..., rowsChanged: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsRemoved: typing.Callable = ..., series: typing.Any = ..., seriesChanged: typing.Callable = ..., type: QtDataVisualization.QItemModelSurfaceDataProxy.DataType = ..., useModelCategories: bool = ..., useModelCategoriesChanged: typing.Callable = ..., xPosRole: str = ..., xPosRoleChanged: typing.Callable = ..., xPosRolePattern: PySide2.QtCore.QRegExp = ..., xPosRolePatternChanged: typing.Callable = ..., xPosRoleReplace: str = ..., xPosRoleReplaceChanged: typing.Callable = ..., yPosRoleChanged: typing.Callable = ..., yPosRolePattern: PySide2.QtCore.QRegExp = ..., yPosRolePatternChanged: typing.Callable = ..., yPosRoleReplace: str = ..., yPosRoleReplaceChanged: typing.Callable = ..., zPosRole: str = ..., zPosRoleChanged: typing.Callable = ..., zPosRolePattern: PySide2.QtCore.QRegExp = ..., zPosRolePatternChanged: typing.Callable = ..., zPosRoleReplace: str = ..., zPosRoleReplaceChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, rowRole: str, columnRole: str, xPosRole: str, yPosRole: str, zPosRole: str, parent: PySide2.QtCore.QObject | None = ..., arrayReset: typing.Callable = ..., autoColumnCategories: bool = ..., autoColumnCategoriesChanged: typing.Callable = ..., autoRowCategories: bool = ..., autoRowCategoriesChanged: typing.Callable = ..., columnCategories: None = ..., columnCategoriesChanged: typing.Callable = ..., columnCount: int = ..., columnCountChanged: typing.Callable = ..., columnRoleChanged: typing.Callable = ..., columnRolePattern: PySide2.QtCore.QRegExp = ..., columnRolePatternChanged: typing.Callable = ..., columnRoleReplace: str = ..., columnRoleReplaceChanged: typing.Callable = ..., destroyed: typing.Callable = ..., itemChanged: typing.Callable = ..., itemModelChanged: typing.Callable = ..., multiMatchBehavior: QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior = ..., multiMatchBehaviorChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowCategories: None = ..., rowCategoriesChanged: typing.Callable = ..., rowCount: int = ..., rowCountChanged: typing.Callable = ..., rowRoleChanged: typing.Callable = ..., rowRolePattern: PySide2.QtCore.QRegExp = ..., rowRolePatternChanged: typing.Callable = ..., rowRoleReplace: str = ..., rowRoleReplaceChanged: typing.Callable = ..., rowsAdded: typing.Callable = ..., rowsChanged: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsRemoved: typing.Callable = ..., series: typing.Any = ..., seriesChanged: typing.Callable = ..., type: QtDataVisualization.QItemModelSurfaceDataProxy.DataType = ..., useModelCategories: bool = ..., useModelCategoriesChanged: typing.Callable = ..., xPosRoleChanged: typing.Callable = ..., xPosRolePattern: PySide2.QtCore.QRegExp = ..., xPosRolePatternChanged: typing.Callable = ..., xPosRoleReplace: str = ..., xPosRoleReplaceChanged: typing.Callable = ..., yPosRoleChanged: typing.Callable = ..., yPosRolePattern: PySide2.QtCore.QRegExp = ..., yPosRolePatternChanged: typing.Callable = ..., yPosRoleReplace: str = ..., yPosRoleReplaceChanged: typing.Callable = ..., zPosRoleChanged: typing.Callable = ..., zPosRolePattern: PySide2.QtCore.QRegExp = ..., zPosRolePatternChanged: typing.Callable = ..., zPosRoleReplace: str = ..., zPosRoleReplaceChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, rowRole: str, columnRole: str, yPosRole: str, parent: PySide2.QtCore.QObject | None = ..., arrayReset: typing.Callable = ..., autoColumnCategories: bool = ..., autoColumnCategoriesChanged: typing.Callable = ..., autoRowCategories: bool = ..., autoRowCategoriesChanged: typing.Callable = ..., columnCategories: None = ..., columnCategoriesChanged: typing.Callable = ..., columnCount: int = ..., columnCountChanged: typing.Callable = ..., columnRoleChanged: typing.Callable = ..., columnRolePattern: PySide2.QtCore.QRegExp = ..., columnRolePatternChanged: typing.Callable = ..., columnRoleReplace: str = ..., columnRoleReplaceChanged: typing.Callable = ..., destroyed: typing.Callable = ..., itemChanged: typing.Callable = ..., itemModelChanged: typing.Callable = ..., multiMatchBehavior: QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior = ..., multiMatchBehaviorChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowCategories: None = ..., rowCategoriesChanged: typing.Callable = ..., rowCount: int = ..., rowCountChanged: typing.Callable = ..., rowRoleChanged: typing.Callable = ..., rowRolePattern: PySide2.QtCore.QRegExp = ..., rowRolePatternChanged: typing.Callable = ..., rowRoleReplace: str = ..., rowRoleReplaceChanged: typing.Callable = ..., rowsAdded: typing.Callable = ..., rowsChanged: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsRemoved: typing.Callable = ..., series: typing.Any = ..., seriesChanged: typing.Callable = ..., type: QtDataVisualization.QItemModelSurfaceDataProxy.DataType = ..., useModelCategories: bool = ..., useModelCategoriesChanged: typing.Callable = ..., xPosRole: str = ..., xPosRoleChanged: typing.Callable = ..., xPosRolePattern: PySide2.QtCore.QRegExp = ..., xPosRolePatternChanged: typing.Callable = ..., xPosRoleReplace: str = ..., xPosRoleReplaceChanged: typing.Callable = ..., yPosRoleChanged: typing.Callable = ..., yPosRolePattern: PySide2.QtCore.QRegExp = ..., yPosRolePatternChanged: typing.Callable = ..., yPosRoleReplace: str = ..., yPosRoleReplaceChanged: typing.Callable = ..., zPosRole: str = ..., zPosRoleChanged: typing.Callable = ..., zPosRolePattern: PySide2.QtCore.QRegExp = ..., zPosRolePatternChanged: typing.Callable = ..., zPosRoleReplace: str = ..., zPosRoleReplaceChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, yPosRole: str, parent: PySide2.QtCore.QObject | None = ..., arrayReset: typing.Callable = ..., autoColumnCategories: bool = ..., autoColumnCategoriesChanged: typing.Callable = ..., autoRowCategories: bool = ..., autoRowCategoriesChanged: typing.Callable = ..., columnCategories: None = ..., columnCategoriesChanged: typing.Callable = ..., columnCount: int = ..., columnCountChanged: typing.Callable = ..., columnRole: str = ..., columnRoleChanged: typing.Callable = ..., columnRolePattern: PySide2.QtCore.QRegExp = ..., columnRolePatternChanged: typing.Callable = ..., columnRoleReplace: str = ..., columnRoleReplaceChanged: typing.Callable = ..., destroyed: typing.Callable = ..., itemChanged: typing.Callable = ..., itemModelChanged: typing.Callable = ..., multiMatchBehavior: QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior = ..., multiMatchBehaviorChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowCategories: None = ..., rowCategoriesChanged: typing.Callable = ..., rowCount: int = ..., rowCountChanged: typing.Callable = ..., rowRole: str = ..., rowRoleChanged: typing.Callable = ..., rowRolePattern: PySide2.QtCore.QRegExp = ..., rowRolePatternChanged: typing.Callable = ..., rowRoleReplace: str = ..., rowRoleReplaceChanged: typing.Callable = ..., rowsAdded: typing.Callable = ..., rowsChanged: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsRemoved: typing.Callable = ..., series: typing.Any = ..., seriesChanged: typing.Callable = ..., type: QtDataVisualization.QItemModelSurfaceDataProxy.DataType = ..., useModelCategories: bool = ..., useModelCategoriesChanged: typing.Callable = ..., xPosRole: str = ..., xPosRoleChanged: typing.Callable = ..., xPosRolePattern: PySide2.QtCore.QRegExp = ..., xPosRolePatternChanged: typing.Callable = ..., xPosRoleReplace: str = ..., xPosRoleReplaceChanged: typing.Callable = ..., yPosRoleChanged: typing.Callable = ..., yPosRolePattern: PySide2.QtCore.QRegExp = ..., yPosRolePatternChanged: typing.Callable = ..., yPosRoleReplace: str = ..., yPosRoleReplaceChanged: typing.Callable = ..., zPosRole: str = ..., zPosRoleChanged: typing.Callable = ..., zPosRolePattern: PySide2.QtCore.QRegExp = ..., zPosRolePatternChanged: typing.Callable = ..., zPosRoleReplace: str = ..., zPosRoleReplaceChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, parent: PySide2.QtCore.QObject | None = ..., arrayReset: typing.Callable = ..., autoColumnCategories: bool = ..., autoColumnCategoriesChanged: typing.Callable = ..., autoRowCategories: bool = ..., autoRowCategoriesChanged: typing.Callable = ..., columnCategories: None = ..., columnCategoriesChanged: typing.Callable = ..., columnCount: int = ..., columnCountChanged: typing.Callable = ..., columnRole: str = ..., columnRoleChanged: typing.Callable = ..., columnRolePattern: PySide2.QtCore.QRegExp = ..., columnRolePatternChanged: typing.Callable = ..., columnRoleReplace: str = ..., columnRoleReplaceChanged: typing.Callable = ..., destroyed: typing.Callable = ..., itemChanged: typing.Callable = ..., itemModelChanged: typing.Callable = ..., multiMatchBehavior: QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior = ..., multiMatchBehaviorChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowCategories: None = ..., rowCategoriesChanged: typing.Callable = ..., rowCount: int = ..., rowCountChanged: typing.Callable = ..., rowRole: str = ..., rowRoleChanged: typing.Callable = ..., rowRolePattern: PySide2.QtCore.QRegExp = ..., rowRolePatternChanged: typing.Callable = ..., rowRoleReplace: str = ..., rowRoleReplaceChanged: typing.Callable = ..., rowsAdded: typing.Callable = ..., rowsChanged: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsRemoved: typing.Callable = ..., series: typing.Any = ..., seriesChanged: typing.Callable = ..., type: QtDataVisualization.QItemModelSurfaceDataProxy.DataType = ..., useModelCategories: bool = ..., useModelCategoriesChanged: typing.Callable = ..., xPosRole: str = ..., xPosRoleChanged: typing.Callable = ..., xPosRolePattern: PySide2.QtCore.QRegExp = ..., xPosRolePatternChanged: typing.Callable = ..., xPosRoleReplace: str = ..., xPosRoleReplaceChanged: typing.Callable = ..., yPosRole: str = ..., yPosRoleChanged: typing.Callable = ..., yPosRolePattern: PySide2.QtCore.QRegExp = ..., yPosRolePatternChanged: typing.Callable = ..., yPosRoleReplace: str = ..., yPosRoleReplaceChanged: typing.Callable = ..., zPosRole: str = ..., zPosRoleChanged: typing.Callable = ..., zPosRolePattern: PySide2.QtCore.QRegExp = ..., zPosRolePatternChanged: typing.Callable = ..., zPosRoleReplace: str = ..., zPosRoleReplaceChanged: typing.Callable = ...) -> None: ...
        @typing.overload
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., arrayReset: typing.Callable = ..., autoColumnCategories: bool = ..., autoColumnCategoriesChanged: typing.Callable = ..., autoRowCategories: bool = ..., autoRowCategoriesChanged: typing.Callable = ..., columnCategories: None = ..., columnCategoriesChanged: typing.Callable = ..., columnCount: int = ..., columnCountChanged: typing.Callable = ..., columnRole: str = ..., columnRoleChanged: typing.Callable = ..., columnRolePattern: PySide2.QtCore.QRegExp = ..., columnRolePatternChanged: typing.Callable = ..., columnRoleReplace: str = ..., columnRoleReplaceChanged: typing.Callable = ..., destroyed: typing.Callable = ..., itemChanged: typing.Callable = ..., itemModel: PySide2.QtCore.QAbstractItemModel = ..., itemModelChanged: typing.Callable = ..., multiMatchBehavior: QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior = ..., multiMatchBehaviorChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowCategories: None = ..., rowCategoriesChanged: typing.Callable = ..., rowCount: int = ..., rowCountChanged: typing.Callable = ..., rowRole: str = ..., rowRoleChanged: typing.Callable = ..., rowRolePattern: PySide2.QtCore.QRegExp = ..., rowRolePatternChanged: typing.Callable = ..., rowRoleReplace: str = ..., rowRoleReplaceChanged: typing.Callable = ..., rowsAdded: typing.Callable = ..., rowsChanged: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsRemoved: typing.Callable = ..., series: typing.Any = ..., seriesChanged: typing.Callable = ..., type: QtDataVisualization.QItemModelSurfaceDataProxy.DataType = ..., useModelCategories: bool = ..., useModelCategoriesChanged: typing.Callable = ..., xPosRole: str = ..., xPosRoleChanged: typing.Callable = ..., xPosRolePattern: PySide2.QtCore.QRegExp = ..., xPosRolePatternChanged: typing.Callable = ..., xPosRoleReplace: str = ..., xPosRoleReplaceChanged: typing.Callable = ..., yPosRole: str = ..., yPosRoleChanged: typing.Callable = ..., yPosRolePattern: PySide2.QtCore.QRegExp = ..., yPosRolePatternChanged: typing.Callable = ..., yPosRoleReplace: str = ..., yPosRoleReplaceChanged: typing.Callable = ..., zPosRole: str = ..., zPosRoleChanged: typing.Callable = ..., zPosRolePattern: PySide2.QtCore.QRegExp = ..., zPosRolePatternChanged: typing.Callable = ..., zPosRoleReplace: str = ..., zPosRoleReplaceChanged: typing.Callable = ...) -> None: ...
        def autoColumnCategories(self) -> bool: ...
        def autoRowCategories(self) -> bool: ...
        def columnCategories(self) -> typing.List[str]: ...
        def columnCategoryIndex(self, category: str) -> int: ...
        def columnRole(self) -> str: ...
        def columnRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def columnRoleReplace(self) -> str: ...
        def itemModel(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def multiMatchBehavior(self) -> QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior: ...
        def remap(self, rowRole: str, columnRole: str, xPosRole: str, yPosRole: str, zPosRole: str, rowCategories: typing.Iterable[str], columnCategories: typing.Iterable[str]) -> None: ...
        def rowCategories(self) -> typing.List[str]: ...
        def rowCategoryIndex(self, category: str) -> int: ...
        def rowRole(self) -> str: ...
        def rowRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def rowRoleReplace(self) -> str: ...
        def setAutoColumnCategories(self, enable: bool) -> None: ...
        def setAutoRowCategories(self, enable: bool) -> None: ...
        def setColumnCategories(self, categories: typing.Iterable[str]) -> None: ...
        def setColumnRole(self, role: str) -> None: ...
        def setColumnRolePattern(self, pattern: PySide2.QtCore.QRegExp) -> None: ...
        def setColumnRoleReplace(self, replace: str) -> None: ...
        def setItemModel(self, itemModel: PySide2.QtCore.QAbstractItemModel) -> None: ...
        def setMultiMatchBehavior(self, behavior: QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior) -> None: ...
        def setRowCategories(self, categories: typing.Iterable[str]) -> None: ...
        def setRowRole(self, role: str) -> None: ...
        def setRowRolePattern(self, pattern: PySide2.QtCore.QRegExp) -> None: ...
        def setRowRoleReplace(self, replace: str) -> None: ...
        def setUseModelCategories(self, enable: bool) -> None: ...
        def setXPosRole(self, role: str) -> None: ...
        def setXPosRolePattern(self, pattern: PySide2.QtCore.QRegExp) -> None: ...
        def setXPosRoleReplace(self, replace: str) -> None: ...
        def setYPosRole(self, role: str) -> None: ...
        def setYPosRolePattern(self, pattern: PySide2.QtCore.QRegExp) -> None: ...
        def setYPosRoleReplace(self, replace: str) -> None: ...
        def setZPosRole(self, role: str) -> None: ...
        def setZPosRolePattern(self, pattern: PySide2.QtCore.QRegExp) -> None: ...
        def setZPosRoleReplace(self, replace: str) -> None: ...
        def useModelCategories(self) -> bool: ...
        def xPosRole(self) -> str: ...
        def xPosRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def xPosRoleReplace(self) -> str: ...
        def yPosRole(self) -> str: ...
        def yPosRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def yPosRoleReplace(self) -> str: ...
        def zPosRole(self) -> str: ...
        def zPosRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def zPosRoleReplace(self) -> str: ...

    class QLogValue3DAxisFormatter(QtDataVisualization.QValue3DAxisFormatter):
        autoSubGridChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        baseChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        showEdgeLabelsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., autoSubGrid: bool = ..., autoSubGridChanged: typing.Callable = ..., base: float = ..., baseChanged: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., showEdgeLabels: bool = ..., showEdgeLabelsChanged: typing.Callable = ...) -> None: ...
        def autoSubGrid(self) -> bool: ...
        def base(self) -> float: ...
        def createNewInstance(self) -> QtDataVisualization.QValue3DAxisFormatter: ...
        def populateCopy(self, copy: QtDataVisualization.QValue3DAxisFormatter) -> None: ...
        def positionAt(self, value: float) -> float: ...
        def recalculate(self) -> None: ...
        def setAutoSubGrid(self, enabled: bool) -> None: ...
        def setBase(self, base: float) -> None: ...
        def setShowEdgeLabels(self, enabled: bool) -> None: ...
        def showEdgeLabels(self) -> bool: ...
        def valueAt(self, position: float) -> float: ...

    class QScatter3DSeries(QtDataVisualization.QAbstract3DSeries):
        dataProxyChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        itemSizeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        selectedItemChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @typing.overload
        def __init__(self, dataProxy: QtDataVisualization.QScatterDataProxy, parent: PySide2.QtCore.QObject | None = ..., baseColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., baseColorChanged: typing.Callable = ..., baseGradient: typing.Any = ..., baseGradientChanged: typing.Callable = ..., colorStyle: typing.Any = ..., colorStyleChanged: typing.Callable = ..., dataProxyChanged: typing.Callable = ..., destroyed: typing.Callable = ..., itemLabel: str = ..., itemLabelChanged: typing.Callable = ..., itemLabelFormat: str = ..., itemLabelFormatChanged: typing.Callable = ..., itemLabelVisibilityChanged: typing.Callable = ..., itemLabelVisible: bool = ..., itemSize: float = ..., itemSizeChanged: typing.Callable = ..., mesh: QtDataVisualization.QScatter3DSeries.Mesh = ..., meshChanged: typing.Callable = ..., meshRotation: PySide2.QtGui.QQuaternion = ..., meshRotationChanged: typing.Callable = ..., meshSmooth: bool = ..., meshSmoothChanged: typing.Callable = ..., multiHighlightColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., multiHighlightColorChanged: typing.Callable = ..., multiHighlightGradient: typing.Any = ..., multiHighlightGradientChanged: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., selectedItem: int = ..., selectedItemChanged: typing.Callable = ..., singleHighlightColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., singleHighlightColorChanged: typing.Callable = ..., singleHighlightGradient: typing.Any = ..., singleHighlightGradientChanged: typing.Callable = ..., type: QtDataVisualization.QScatter3DSeries.SeriesType = ..., userDefinedMesh: str = ..., userDefinedMeshChanged: typing.Callable = ..., visibilityChanged: typing.Callable = ..., visible: bool = ...) -> None: ...
        @typing.overload
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., baseColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., baseColorChanged: typing.Callable = ..., baseGradient: typing.Any = ..., baseGradientChanged: typing.Callable = ..., colorStyle: typing.Any = ..., colorStyleChanged: typing.Callable = ..., dataProxy: QtDataVisualization.QScatterDataProxy = ..., dataProxyChanged: typing.Callable = ..., destroyed: typing.Callable = ..., itemLabel: str = ..., itemLabelChanged: typing.Callable = ..., itemLabelFormat: str = ..., itemLabelFormatChanged: typing.Callable = ..., itemLabelVisibilityChanged: typing.Callable = ..., itemLabelVisible: bool = ..., itemSize: float = ..., itemSizeChanged: typing.Callable = ..., mesh: QtDataVisualization.QScatter3DSeries.Mesh = ..., meshChanged: typing.Callable = ..., meshRotation: PySide2.QtGui.QQuaternion = ..., meshRotationChanged: typing.Callable = ..., meshSmooth: bool = ..., meshSmoothChanged: typing.Callable = ..., multiHighlightColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., multiHighlightColorChanged: typing.Callable = ..., multiHighlightGradient: typing.Any = ..., multiHighlightGradientChanged: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., selectedItem: int = ..., selectedItemChanged: typing.Callable = ..., singleHighlightColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., singleHighlightColorChanged: typing.Callable = ..., singleHighlightGradient: typing.Any = ..., singleHighlightGradientChanged: typing.Callable = ..., type: QtDataVisualization.QScatter3DSeries.SeriesType = ..., userDefinedMesh: str = ..., userDefinedMeshChanged: typing.Callable = ..., visibilityChanged: typing.Callable = ..., visible: bool = ...) -> None: ...
        def dataProxy(self) -> QtDataVisualization.QScatterDataProxy: ...
        @staticmethod
        def invalidSelectionIndex() -> int: ...
        def itemSize(self) -> float: ...
        def selectedItem(self) -> int: ...
        def setDataProxy(self, proxy: QtDataVisualization.QScatterDataProxy) -> None: ...
        def setItemSize(self, size: float) -> None: ...
        def setSelectedItem(self, index: int) -> None: ...

    class QScatterDataItem(shiboken2.Object):
        @typing.overload
        def __init__(self, position: PySide2.QtGui.QVector3D, rotation: PySide2.QtGui.QQuaternion) -> None: ...
        @typing.overload
        def __init__(self, position: PySide2.QtGui.QVector3D) -> None: ...
        @typing.overload
        def __init__(self, other: QtDataVisualization.QScatterDataItem) -> None: ...
        @typing.overload
        def __init__(self) -> None: ...
        def createExtraData(self) -> None: ...
        def position(self) -> PySide2.QtGui.QVector3D: ...
        def rotation(self) -> PySide2.QtGui.QQuaternion: ...
        def setPosition(self, pos: PySide2.QtGui.QVector3D) -> None: ...
        def setRotation(self, rot: PySide2.QtGui.QQuaternion) -> None: ...
        def setX(self, value: float) -> None: ...
        def setY(self, value: float) -> None: ...
        def setZ(self, value: float) -> None: ...
        def x(self) -> float: ...
        def y(self) -> float: ...
        def z(self) -> float: ...
        def __copy__(self) -> None: ...

    class QScatterDataProxy(QtDataVisualization.QAbstractDataProxy):
        arrayReset: typing.ClassVar[PySide2.QtCore.Signal] = ...
        itemCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        itemsAdded: typing.ClassVar[PySide2.QtCore.Signal] = ...
        itemsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        itemsInserted: typing.ClassVar[PySide2.QtCore.Signal] = ...
        itemsRemoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
        seriesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., arrayReset: typing.Callable = ..., destroyed: typing.Callable = ..., itemCount: int = ..., itemCountChanged: typing.Callable = ..., itemsAdded: typing.Callable = ..., itemsChanged: typing.Callable = ..., itemsInserted: typing.Callable = ..., itemsRemoved: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., series: QtDataVisualization.QScatter3DSeries = ..., seriesChanged: typing.Callable = ..., type: QtDataVisualization.QScatterDataProxy.DataType = ...) -> None: ...
        def addItem(self, item: QtDataVisualization.QScatterDataItem) -> int: ...
        def addItems(self, items: typing.List[QtDataVisualization.QScatterDataItem]) -> int: ...
        def array(self) -> typing.List[QtDataVisualization.QScatterDataItem]: ...
        def insertItem(self, index: int, item: QtDataVisualization.QScatterDataItem) -> None: ...
        def insertItems(self, index: int, items: typing.List[QtDataVisualization.QScatterDataItem]) -> None: ...
        def itemAt(self, index: int) -> QtDataVisualization.QScatterDataItem: ...
        def itemCount(self) -> int: ...
        def removeItems(self, index: int, removeCount: int) -> None: ...
        def resetArray(self, newArray: typing.List[QtDataVisualization.QScatterDataItem]) -> None: ...
        def series(self) -> QtDataVisualization.QScatter3DSeries: ...
        def setItem(self, index: int, item: QtDataVisualization.QScatterDataItem) -> None: ...
        def setItems(self, index: int, items: typing.List[QtDataVisualization.QScatterDataItem]) -> None: ...

    class QSurface3DSeries(QtDataVisualization.QAbstract3DSeries):
        class DrawFlag:
            DrawSurface: typing.ClassVar[QtDataVisualization.QSurface3DSeries.DrawFlag] = ...
            DrawSurfaceAndWireframe: typing.ClassVar[QtDataVisualization.QSurface3DSeries.DrawFlag] = ...
            DrawWireframe: typing.ClassVar[QtDataVisualization.QSurface3DSeries.DrawFlag] = ...
            values: typing.ClassVar[dict] = ...
            name: _typeshed.Incomplete
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __and__(self, other: typing.SupportsInt) -> QtDataVisualization.QSurface3DSeries.DrawFlags: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __invert__(self) -> QtDataVisualization.QSurface3DSeries.DrawFlags: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtDataVisualization.QSurface3DSeries.DrawFlags: ...
            def __rand__(self, other: typing.SupportsInt) -> QtDataVisualization.QSurface3DSeries.DrawFlags: ...
            def __ror__(self, other: typing.SupportsInt) -> QtDataVisualization.QSurface3DSeries.DrawFlags: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtDataVisualization.QSurface3DSeries.DrawFlags: ...
            def __xor__(self, other: typing.SupportsInt) -> QtDataVisualization.QSurface3DSeries.DrawFlags: ...

        class DrawFlags:
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __and__(self, other: typing.SupportsInt) -> QtDataVisualization.QSurface3DSeries.DrawFlags: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __invert__(self) -> QtDataVisualization.QSurface3DSeries.DrawFlags: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QtDataVisualization.QSurface3DSeries.DrawFlags: ...
            def __rand__(self, other: typing.SupportsInt) -> QtDataVisualization.QSurface3DSeries.DrawFlags: ...
            def __ror__(self, other: typing.SupportsInt) -> QtDataVisualization.QSurface3DSeries.DrawFlags: ...
            def __rxor__(self, other: typing.SupportsInt) -> QtDataVisualization.QSurface3DSeries.DrawFlags: ...
            def __xor__(self, other: typing.SupportsInt) -> QtDataVisualization.QSurface3DSeries.DrawFlags: ...
        DrawSurface: typing.ClassVar[QtDataVisualization.QSurface3DSeries.DrawFlag] = ...
        DrawSurfaceAndWireframe: typing.ClassVar[QtDataVisualization.QSurface3DSeries.DrawFlag] = ...
        DrawWireframe: typing.ClassVar[QtDataVisualization.QSurface3DSeries.DrawFlag] = ...
        dataProxyChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        drawModeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        flatShadingEnabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        flatShadingSupportedChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        selectedPointChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        textureChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        textureFileChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @typing.overload
        def __init__(self, dataProxy: QtDataVisualization.QSurfaceDataProxy, parent: PySide2.QtCore.QObject | None = ..., baseColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., baseColorChanged: typing.Callable = ..., baseGradient: typing.Any = ..., baseGradientChanged: typing.Callable = ..., colorStyle: typing.Any = ..., colorStyleChanged: typing.Callable = ..., dataProxyChanged: typing.Callable = ..., destroyed: typing.Callable = ..., drawMode: QtDataVisualization.QSurface3DSeries.DrawFlags | QtDataVisualization.QSurface3DSeries.DrawFlag = ..., drawModeChanged: typing.Callable = ..., flatShadingEnabled: bool = ..., flatShadingEnabledChanged: typing.Callable = ..., flatShadingSupported: bool = ..., flatShadingSupportedChanged: typing.Callable = ..., itemLabel: str = ..., itemLabelChanged: typing.Callable = ..., itemLabelFormat: str = ..., itemLabelFormatChanged: typing.Callable = ..., itemLabelVisibilityChanged: typing.Callable = ..., itemLabelVisible: bool = ..., mesh: QtDataVisualization.QSurface3DSeries.Mesh = ..., meshChanged: typing.Callable = ..., meshRotation: PySide2.QtGui.QQuaternion = ..., meshRotationChanged: typing.Callable = ..., meshSmooth: bool = ..., meshSmoothChanged: typing.Callable = ..., multiHighlightColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., multiHighlightColorChanged: typing.Callable = ..., multiHighlightGradient: typing.Any = ..., multiHighlightGradientChanged: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., selectedPoint: PySide2.QtCore.QPoint = ..., selectedPointChanged: typing.Callable = ..., singleHighlightColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., singleHighlightColorChanged: typing.Callable = ..., singleHighlightGradient: typing.Any = ..., singleHighlightGradientChanged: typing.Callable = ..., texture: PySide2.QtGui.QImage = ..., textureChanged: typing.Callable = ..., textureFile: str = ..., textureFileChanged: typing.Callable = ..., type: QtDataVisualization.QSurface3DSeries.SeriesType = ..., userDefinedMesh: str = ..., userDefinedMeshChanged: typing.Callable = ..., visibilityChanged: typing.Callable = ..., visible: bool = ...) -> None: ...
        @typing.overload
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., baseColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., baseColorChanged: typing.Callable = ..., baseGradient: typing.Any = ..., baseGradientChanged: typing.Callable = ..., colorStyle: typing.Any = ..., colorStyleChanged: typing.Callable = ..., dataProxy: QtDataVisualization.QSurfaceDataProxy = ..., dataProxyChanged: typing.Callable = ..., destroyed: typing.Callable = ..., drawMode: QtDataVisualization.QSurface3DSeries.DrawFlags | QtDataVisualization.QSurface3DSeries.DrawFlag = ..., drawModeChanged: typing.Callable = ..., flatShadingEnabled: bool = ..., flatShadingEnabledChanged: typing.Callable = ..., flatShadingSupported: bool = ..., flatShadingSupportedChanged: typing.Callable = ..., itemLabel: str = ..., itemLabelChanged: typing.Callable = ..., itemLabelFormat: str = ..., itemLabelFormatChanged: typing.Callable = ..., itemLabelVisibilityChanged: typing.Callable = ..., itemLabelVisible: bool = ..., mesh: QtDataVisualization.QSurface3DSeries.Mesh = ..., meshChanged: typing.Callable = ..., meshRotation: PySide2.QtGui.QQuaternion = ..., meshRotationChanged: typing.Callable = ..., meshSmooth: bool = ..., meshSmoothChanged: typing.Callable = ..., multiHighlightColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., multiHighlightColorChanged: typing.Callable = ..., multiHighlightGradient: typing.Any = ..., multiHighlightGradientChanged: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., selectedPoint: PySide2.QtCore.QPoint = ..., selectedPointChanged: typing.Callable = ..., singleHighlightColor: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., singleHighlightColorChanged: typing.Callable = ..., singleHighlightGradient: typing.Any = ..., singleHighlightGradientChanged: typing.Callable = ..., texture: PySide2.QtGui.QImage = ..., textureChanged: typing.Callable = ..., textureFile: str = ..., textureFileChanged: typing.Callable = ..., type: QtDataVisualization.QSurface3DSeries.SeriesType = ..., userDefinedMesh: str = ..., userDefinedMeshChanged: typing.Callable = ..., visibilityChanged: typing.Callable = ..., visible: bool = ...) -> None: ...
        def dataProxy(self) -> QtDataVisualization.QSurfaceDataProxy: ...
        def drawMode(self) -> QtDataVisualization.QSurface3DSeries.DrawFlags | QtDataVisualization.QSurface3DSeries.DrawFlag: ...
        @staticmethod
        def invalidSelectionPosition() -> PySide2.QtCore.QPoint: ...
        def isFlatShadingEnabled(self) -> bool: ...
        def isFlatShadingSupported(self) -> bool: ...
        def selectedPoint(self) -> PySide2.QtCore.QPoint: ...
        def setDataProxy(self, proxy: QtDataVisualization.QSurfaceDataProxy) -> None: ...
        def setDrawMode(self, mode: QtDataVisualization.QSurface3DSeries.DrawFlags | QtDataVisualization.QSurface3DSeries.DrawFlag) -> None: ...
        def setFlatShadingEnabled(self, enabled: bool) -> None: ...
        def setSelectedPoint(self, position: PySide2.QtCore.QPoint) -> None: ...
        def setTexture(self, texture: PySide2.QtGui.QImage) -> None: ...
        def setTextureFile(self, filename: str) -> None: ...
        def texture(self) -> PySide2.QtGui.QImage: ...
        def textureFile(self) -> str: ...

    class QSurfaceDataItem(shiboken2.Object):
        @typing.overload
        def __init__(self, position: PySide2.QtGui.QVector3D) -> None: ...
        @typing.overload
        def __init__(self, other: QtDataVisualization.QSurfaceDataItem) -> None: ...
        @typing.overload
        def __init__(self) -> None: ...
        def createExtraData(self) -> None: ...
        def position(self) -> PySide2.QtGui.QVector3D: ...
        def setPosition(self, pos: PySide2.QtGui.QVector3D) -> None: ...
        def setX(self, value: float) -> None: ...
        def setY(self, value: float) -> None: ...
        def setZ(self, value: float) -> None: ...
        def x(self) -> float: ...
        def y(self) -> float: ...
        def z(self) -> float: ...
        def __copy__(self) -> None: ...

    class QSurfaceDataProxy(QtDataVisualization.QAbstractDataProxy):
        arrayReset: typing.ClassVar[PySide2.QtCore.Signal] = ...
        columnCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        itemChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowsAdded: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowsInserted: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rowsRemoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
        seriesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., arrayReset: typing.Callable = ..., columnCount: int = ..., columnCountChanged: typing.Callable = ..., destroyed: typing.Callable = ..., itemChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowCount: int = ..., rowCountChanged: typing.Callable = ..., rowsAdded: typing.Callable = ..., rowsChanged: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsRemoved: typing.Callable = ..., series: QtDataVisualization.QSurface3DSeries = ..., seriesChanged: typing.Callable = ..., type: QtDataVisualization.QSurfaceDataProxy.DataType = ...) -> None: ...
        def addRow(self, row: typing.List[QtDataVisualization.QSurfaceDataItem]) -> int: ...
        def addRows(self, rows: typing.List[typing.List[QtDataVisualization.QSurfaceDataItem]]) -> int: ...
        def array(self) -> typing.List[typing.List[QtDataVisualization.QSurfaceDataItem]]: ...
        def columnCount(self) -> int: ...
        def insertRow(self, rowIndex: int, row: typing.List[QtDataVisualization.QSurfaceDataItem]) -> None: ...
        def insertRows(self, rowIndex: int, rows: typing.List[typing.List[QtDataVisualization.QSurfaceDataItem]]) -> None: ...
        @typing.overload
        def itemAt(self, rowIndex: int, columnIndex: int) -> QtDataVisualization.QSurfaceDataItem: ...
        @typing.overload
        def itemAt(self, position: PySide2.QtCore.QPoint) -> QtDataVisualization.QSurfaceDataItem: ...
        def removeRows(self, rowIndex: int, removeCount: int) -> None: ...
        def resetArray(self, newArray: typing.List[typing.List[QtDataVisualization.QSurfaceDataItem]]) -> None: ...
        def rowCount(self) -> int: ...
        def series(self) -> QtDataVisualization.QSurface3DSeries: ...
        @typing.overload
        def setItem(self, rowIndex: int, columnIndex: int, item: QtDataVisualization.QSurfaceDataItem) -> None: ...
        @typing.overload
        def setItem(self, position: PySide2.QtCore.QPoint, item: QtDataVisualization.QSurfaceDataItem) -> None: ...
        def setRow(self, rowIndex: int, row: typing.List[QtDataVisualization.QSurfaceDataItem]) -> None: ...
        def setRows(self, rowIndex: int, rows: typing.List[typing.List[QtDataVisualization.QSurfaceDataItem]]) -> None: ...

    class QTouch3DInputHandler(QtDataVisualization.Q3DInputHandler):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., inputPosition: PySide2.QtCore.QPoint = ..., inputView: QtDataVisualization.QTouch3DInputHandler.InputView = ..., inputViewChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., positionChanged: typing.Callable = ..., rotationEnabled: bool = ..., rotationEnabledChanged: typing.Callable = ..., scene: typing.Any = ..., sceneChanged: typing.Callable = ..., selectionEnabled: bool = ..., selectionEnabledChanged: typing.Callable = ..., zoomAtTargetEnabled: bool = ..., zoomAtTargetEnabledChanged: typing.Callable = ..., zoomEnabled: bool = ..., zoomEnabledChanged: typing.Callable = ...) -> None: ...
        def touchEvent(self, event: PySide2.QtGui.QTouchEvent) -> None: ...

    class QValue3DAxis(QtDataVisualization.QAbstract3DAxis):
        formatterChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        labelFormatChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        reversedChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        segmentCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        subSegmentCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., autoAdjustRange: bool = ..., autoAdjustRangeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., formatter: QtDataVisualization.QValue3DAxisFormatter = ..., formatterChanged: typing.Callable = ..., labelAutoRotation: float = ..., labelAutoRotationChanged: typing.Callable = ..., labelFormat: str = ..., labelFormatChanged: typing.Callable = ..., labels: None = ..., labelsChanged: typing.Callable = ..., max: float = ..., maxChanged: typing.Callable = ..., min: float = ..., minChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., orientation: QtDataVisualization.QValue3DAxis.AxisOrientation = ..., orientationChanged: typing.Callable = ..., rangeChanged: typing.Callable = ..., reversed: bool = ..., reversedChanged: typing.Callable = ..., segmentCount: int = ..., segmentCountChanged: typing.Callable = ..., subSegmentCount: int = ..., subSegmentCountChanged: typing.Callable = ..., title: str = ..., titleChanged: typing.Callable = ..., titleFixed: bool = ..., titleFixedChanged: typing.Callable = ..., titleVisibilityChanged: typing.Callable = ..., titleVisible: bool = ..., type: QtDataVisualization.QValue3DAxis.AxisType = ...) -> None: ...
        def formatter(self) -> QtDataVisualization.QValue3DAxisFormatter: ...
        def labelFormat(self) -> str: ...
        def reversed(self) -> bool: ...
        def segmentCount(self) -> int: ...
        def setFormatter(self, formatter: QtDataVisualization.QValue3DAxisFormatter) -> None: ...
        def setLabelFormat(self, format: str) -> None: ...
        def setReversed(self, enable: bool) -> None: ...
        def setSegmentCount(self, count: int) -> None: ...
        def setSubSegmentCount(self, count: int) -> None: ...
        def subSegmentCount(self) -> int: ...

    class QValue3DAxisFormatter(PySide2.QtCore.QObject):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
        def allowNegatives(self) -> bool: ...
        def allowZero(self) -> bool: ...
        def axis(self) -> QtDataVisualization.QValue3DAxis: ...
        def createNewInstance(self) -> QtDataVisualization.QValue3DAxisFormatter: ...
        def gridPositions(self) -> typing.List[float]: ...
        def labelPositions(self) -> typing.List[float]: ...
        def labelStrings(self) -> typing.List[str]: ...
        def locale(self) -> PySide2.QtCore.QLocale: ...
        def markDirty(self, labelsChange: bool = ...) -> None: ...
        def populateCopy(self, copy: QtDataVisualization.QValue3DAxisFormatter) -> None: ...
        def positionAt(self, value: float) -> float: ...
        def recalculate(self) -> None: ...
        def setAllowNegatives(self, allow: bool) -> None: ...
        def setAllowZero(self, allow: bool) -> None: ...
        def setLocale(self, locale: PySide2.QtCore.QLocale) -> None: ...
        def stringForValue(self, value: float, format: str) -> str: ...
        def subGridPositions(self) -> typing.List[float]: ...
        def valueAt(self, position: float) -> float: ...
    QBarDataArray: typing.ClassVar[typing._GenericAlias] = ...
    QBarDataRow: typing.ClassVar[typing._GenericAlias] = ...
    QSurfaceDataArray: typing.ClassVar[typing._GenericAlias] = ...
    QSurfaceDataRow: typing.ClassVar[typing._GenericAlias] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @typing.overload
    @staticmethod
    def qDefaultSurfaceFormat(antialias: bool) -> PySide2.QtGui.QSurfaceFormat: ...
    @typing.overload
    @staticmethod
    def qDefaultSurfaceFormat(antialias: bool = ...) -> PySide2.QtGui.QSurfaceFormat: ...
