import PySide2.QtCore
import PySide2.QtGui
import PySide2.QtWidgets
import _typeshed
import collections
import shiboken2
import typing
T = typing.TypeVar('T')
import typing_extensions

class QCompressedHelpInfo(shiboken2.Object):
    @typing.overload
    def __init__(self, other: QCompressedHelpInfo) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def component(self) -> str: ...
    @staticmethod
    def fromCompressedHelpFile(documentationFileName: str) -> QCompressedHelpInfo: ...
    def isNull(self) -> bool: ...
    def namespaceName(self) -> str: ...
    def swap(self, other: QCompressedHelpInfo) -> None: ...
    def version(self) -> PySide2.QtCore.QVersionNumber: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...

class QHelpContentItem(shiboken2.Object):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def child(self, row: int) -> QHelpContentItem: ...
    def childCount(self) -> int: ...
    def childPosition(self, child: QHelpContentItem) -> int: ...
    def parent(self) -> QHelpContentItem: ...
    def row(self) -> int: ...
    def title(self) -> str: ...
    def url(self) -> PySide2.QtCore.QUrl: ...
    def __copy__(self) -> None: ...

class QHelpContentModel(PySide2.QtCore.QAbstractItemModel):
    contentsCreated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    contentsCreationStarted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, columnsAboutToBeInserted: typing.Callable = ..., columnsAboutToBeMoved: typing.Callable = ..., columnsAboutToBeRemoved: typing.Callable = ..., columnsInserted: typing.Callable = ..., columnsMoved: typing.Callable = ..., columnsRemoved: typing.Callable = ..., contentsCreated: typing.Callable = ..., contentsCreationStarted: typing.Callable = ..., dataChanged: typing.Callable = ..., destroyed: typing.Callable = ..., headerDataChanged: typing.Callable = ..., layoutAboutToBeChanged: typing.Callable = ..., layoutChanged: typing.Callable = ..., modelAboutToBeReset: typing.Callable = ..., modelReset: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowsAboutToBeInserted: typing.Callable = ..., rowsAboutToBeMoved: typing.Callable = ..., rowsAboutToBeRemoved: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsMoved: typing.Callable = ..., rowsRemoved: typing.Callable = ..., **kwargs) -> None: ...
    def columnCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def contentItemAt(self, index: PySide2.QtCore.QModelIndex) -> QHelpContentItem: ...
    def createContents(self, customFilterName: str) -> None: ...
    def data(self, index: PySide2.QtCore.QModelIndex, role: PySide2.QtCore.Qt.ItemDataRole) -> typing.Any: ...
    def index(self, row: int, column: int, parent: PySide2.QtCore.QModelIndex = ...) -> PySide2.QtCore.QModelIndex: ...
    def isCreatingContents(self) -> bool: ...
    @typing.overload
    def parent(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    @typing.overload
    def parent(self) -> PySide2.QtCore.QObject: ...
    def rowCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...

class QHelpContentWidget(PySide2.QtWidgets.QTreeView):
    linkActivated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., activated: typing.Callable = ..., allColumnsShowFocus: bool = ..., alternatingRowColors: bool = ..., animated: bool = ..., autoExpandDelay: int = ..., autoFillBackground: bool = ..., autoScroll: bool = ..., autoScrollMargin: int = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., clicked: typing.Callable = ..., collapsed: typing.Callable = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: PySide2.QtGui.QCursor | PySide2.QtCore.Qt.CursorShape = ..., customContextMenuRequested: typing.Callable = ..., defaultDropAction: PySide2.QtCore.Qt.DropAction = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., dragDropMode: QHelpContentWidget.DragDropMode = ..., dragDropOverwriteMode: bool = ..., dragEnabled: bool = ..., editTriggers: QHelpContentWidget.EditTriggers = ..., enabled: bool = ..., entered: typing.Callable = ..., expanded: typing.Callable = ..., expandsOnDoubleClick: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameRect: PySide2.QtCore.QRect = ..., frameShadow: QHelpContentWidget.Shadow = ..., frameShape: QHelpContentWidget.Shape = ..., frameSize: PySide2.QtCore.QSize = ..., frameWidth: int = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., headerHidden: bool = ..., height: int = ..., horizontalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., horizontalScrollMode: QHelpContentWidget.ScrollMode = ..., iconSize: PySide2.QtCore.QSize = ..., iconSizeChanged: typing.Callable = ..., indentation: int = ..., inputMethodHints: PySide2.QtCore.Qt.InputMethodHints | PySide2.QtCore.Qt.InputMethodHint = ..., isActiveWindow: bool = ..., itemsExpandable: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., lineWidth: int = ..., linkActivated: typing.Callable = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., midLineWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., pressed: typing.Callable = ..., rect: PySide2.QtCore.QRect = ..., rootIsDecorated: bool = ..., selectionBehavior: QHelpContentWidget.SelectionBehavior = ..., selectionMode: QHelpContentWidget.SelectionMode = ..., showDropIndicator: bool = ..., size: PySide2.QtCore.QSize = ..., sizeAdjustPolicy: QHelpContentWidget.SizeAdjustPolicy = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., sortingEnabled: bool = ..., statusTip: str = ..., styleSheet: str = ..., tabKeyNavigation: bool = ..., tabletTracking: bool = ..., textElideMode: PySide2.QtCore.Qt.TextElideMode = ..., toolTip: str = ..., toolTipDuration: int = ..., uniformRowHeights: bool = ..., updatesEnabled: bool = ..., verticalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., verticalScrollMode: QHelpContentWidget.ScrollMode = ..., viewportEntered: typing.Callable = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., wordWrap: bool = ..., x: int = ..., y: int = ..., **kwargs) -> None: ...
    def indexOf(self, link: PySide2.QtCore.QUrl) -> PySide2.QtCore.QModelIndex: ...

class QHelpEngine(QHelpEngineCore):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, collectionFile: str, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def contentModel(self) -> QHelpContentModel: ...
    def contentWidget(self) -> QHelpContentWidget: ...
    def indexModel(self) -> QHelpIndexModel: ...
    def indexWidget(self) -> QHelpIndexWidget: ...
    def searchEngine(self) -> QHelpSearchEngine: ...

class QHelpEngineCore(PySide2.QtCore.QObject):
    currentFilterChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    readersAboutToBeInvalidated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    setupFinished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    setupStarted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    warning: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, collectionFile: str, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def addCustomFilter(self, filterName: str, attributes: typing.Iterable[str]) -> bool: ...
    def autoSaveFilter(self) -> bool: ...
    def collectionFile(self) -> str: ...
    def copyCollectionFile(self, fileName: str) -> bool: ...
    def currentFilter(self) -> str: ...
    def customFilters(self) -> typing.List[str]: ...
    def customValue(self, key: str, defaultValue: typing.Any = ...) -> typing.Any: ...
    def documentationFileName(self, namespaceName: str) -> str: ...
    @typing.overload
    def documentsForIdentifier(self, id: str, filterName: str) -> typing.List[QHelpLink]: ...
    @typing.overload
    def documentsForIdentifier(self, id: str) -> typing.List[QHelpLink]: ...
    @typing.overload
    def documentsForKeyword(self, keyword: str, filterName: str) -> typing.List[QHelpLink]: ...
    @typing.overload
    def documentsForKeyword(self, keyword: str) -> typing.List[QHelpLink]: ...
    def error(self) -> str: ...
    def fileData(self, url: PySide2.QtCore.QUrl) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def files(self, namespaceName: str, filterName: str, extensionFilter: str = ...) -> typing.List[PySide2.QtCore.QUrl]: ...
    @typing.overload
    def files(self, namespaceName: str, filterAttributes: typing.Iterable[str], extensionFilter: str = ...) -> typing.List[PySide2.QtCore.QUrl]: ...
    def filterAttributeSets(self, namespaceName: str) -> typing.List[typing.List[str]]: ...
    @typing.overload
    def filterAttributes(self, filterName: str) -> typing.List[str]: ...
    @typing.overload
    def filterAttributes(self) -> typing.List[str]: ...
    def filterEngine(self) -> QHelpFilterEngine: ...
    def findFile(self, url: PySide2.QtCore.QUrl) -> PySide2.QtCore.QUrl: ...
    def linksForIdentifier(self, id: str) -> typing.Dict[str, PySide2.QtCore.QUrl]: ...
    def linksForKeyword(self, keyword: str) -> typing.Dict[str, PySide2.QtCore.QUrl]: ...
    @staticmethod
    def metaData(documentationFileName: str, name: str) -> typing.Any: ...
    @staticmethod
    def namespaceName(documentationFileName: str) -> str: ...
    def registerDocumentation(self, documentationFileName: str) -> bool: ...
    def registeredDocumentations(self) -> typing.List[str]: ...
    def removeCustomFilter(self, filterName: str) -> bool: ...
    def removeCustomValue(self, key: str) -> bool: ...
    def setAutoSaveFilter(self, save: bool) -> None: ...
    def setCollectionFile(self, fileName: str) -> None: ...
    def setCurrentFilter(self, filterName: str) -> None: ...
    def setCustomValue(self, key: str, value: typing.Any) -> bool: ...
    def setUsesFilterEngine(self, uses: bool) -> None: ...
    def setupData(self) -> bool: ...
    def unregisterDocumentation(self, namespaceName: str) -> bool: ...
    def usesFilterEngine(self) -> bool: ...

class QHelpFilterData(shiboken2.Object):
    @typing.overload
    def __init__(self, other: QHelpFilterData) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def components(self) -> typing.List[str]: ...
    def setComponents(self, components: typing.Iterable[str]) -> None: ...
    def setVersions(self, versions: typing.Iterable[PySide2.QtCore.QVersionNumber]) -> None: ...
    def swap(self, other: QHelpFilterData) -> None: ...
    def versions(self) -> typing.List[PySide2.QtCore.QVersionNumber]: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QHelpFilterEngine(PySide2.QtCore.QObject):
    filterActivated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, helpEngine: QHelpEngineCore, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def activeFilter(self) -> str: ...
    def availableComponents(self) -> typing.List[str]: ...
    def availableVersions(self) -> typing.List[PySide2.QtCore.QVersionNumber]: ...
    def filterData(self, filterName: str) -> QHelpFilterData: ...
    def filters(self) -> typing.List[str]: ...
    @typing.overload
    def indices(self, filterName: str) -> typing.List[str]: ...
    @typing.overload
    def indices(self) -> typing.List[str]: ...
    def namespaceToComponent(self) -> typing.Dict[str, str]: ...
    def namespaceToVersion(self) -> typing.Dict[str, PySide2.QtCore.QVersionNumber]: ...
    def namespacesForFilter(self, filterName: str) -> typing.List[str]: ...
    def removeFilter(self, filterName: str) -> bool: ...
    def setActiveFilter(self, filterName: str) -> bool: ...
    def setFilterData(self, filterName: str, filterData: QHelpFilterData) -> bool: ...

class QHelpFilterSettingsWidget(PySide2.QtWidgets.QWidget):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtWidgets.QWidget | None = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: PySide2.QtGui.QCursor | PySide2.QtCore.Qt.CursorShape = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: PySide2.QtCore.Qt.InputMethodHints | PySide2.QtCore.Qt.InputMethodHint = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def applySettings(self, filterEngine: QHelpFilterEngine) -> bool: ...
    def readSettings(self, filterEngine: QHelpFilterEngine) -> None: ...
    def setAvailableComponents(self, components: typing.Iterable[str]) -> None: ...
    def setAvailableVersions(self, versions: typing.Iterable[PySide2.QtCore.QVersionNumber]) -> None: ...

class QHelpIndexModel(PySide2.QtCore.QStringListModel):
    indexCreated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    indexCreationStarted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, columnsAboutToBeInserted: typing.Callable = ..., columnsAboutToBeMoved: typing.Callable = ..., columnsAboutToBeRemoved: typing.Callable = ..., columnsInserted: typing.Callable = ..., columnsMoved: typing.Callable = ..., columnsRemoved: typing.Callable = ..., dataChanged: typing.Callable = ..., destroyed: typing.Callable = ..., headerDataChanged: typing.Callable = ..., indexCreated: typing.Callable = ..., indexCreationStarted: typing.Callable = ..., layoutAboutToBeChanged: typing.Callable = ..., layoutChanged: typing.Callable = ..., modelAboutToBeReset: typing.Callable = ..., modelReset: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowsAboutToBeInserted: typing.Callable = ..., rowsAboutToBeMoved: typing.Callable = ..., rowsAboutToBeRemoved: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsMoved: typing.Callable = ..., rowsRemoved: typing.Callable = ..., **kwargs) -> None: ...
    @typing.overload
    def createIndex(self, row: int, column: int, ptr: object) -> PySide2.QtCore.QModelIndex: ...
    @typing.overload
    def createIndex(self, row: int, column: int, id: int = ...) -> PySide2.QtCore.QModelIndex: ...
    @typing.overload
    def createIndex(self, customFilterName: str) -> None: ...
    def filter(self, filter: str, wildcard: str = ...) -> PySide2.QtCore.QModelIndex: ...
    def helpEngine(self) -> QHelpEngineCore: ...
    def isCreatingIndex(self) -> bool: ...
    def linksForKeyword(self, keyword: str) -> typing.Dict[str, PySide2.QtCore.QUrl]: ...

class QHelpIndexWidget(PySide2.QtWidgets.QListView):
    documentActivated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    documentsActivated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    linkActivated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    linksActivated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., activated: typing.Callable = ..., alternatingRowColors: bool = ..., autoFillBackground: bool = ..., autoScroll: bool = ..., autoScrollMargin: int = ..., baseSize: PySide2.QtCore.QSize = ..., batchSize: int = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., clicked: typing.Callable = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: PySide2.QtGui.QCursor | PySide2.QtCore.Qt.CursorShape = ..., customContextMenuRequested: typing.Callable = ..., defaultDropAction: PySide2.QtCore.Qt.DropAction = ..., destroyed: typing.Callable = ..., documentActivated: typing.Callable = ..., documentsActivated: typing.Callable = ..., doubleClicked: typing.Callable = ..., dragDropMode: QHelpIndexWidget.DragDropMode = ..., dragDropOverwriteMode: bool = ..., dragEnabled: bool = ..., editTriggers: QHelpIndexWidget.EditTriggers = ..., enabled: bool = ..., entered: typing.Callable = ..., flow: QHelpIndexWidget.Flow = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameRect: PySide2.QtCore.QRect = ..., frameShadow: QHelpIndexWidget.Shadow = ..., frameShape: QHelpIndexWidget.Shape = ..., frameSize: PySide2.QtCore.QSize = ..., frameWidth: int = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., gridSize: PySide2.QtCore.QSize = ..., height: int = ..., horizontalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., horizontalScrollMode: QHelpIndexWidget.ScrollMode = ..., iconSize: PySide2.QtCore.QSize = ..., iconSizeChanged: typing.Callable = ..., indexesMoved: typing.Callable = ..., inputMethodHints: PySide2.QtCore.Qt.InputMethodHints | PySide2.QtCore.Qt.InputMethodHint = ..., isActiveWindow: bool = ..., isWrapping: bool = ..., itemAlignment: PySide2.QtCore.Qt.Alignment | PySide2.QtCore.Qt.AlignmentFlag = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., layoutMode: QHelpIndexWidget.LayoutMode = ..., lineWidth: int = ..., linkActivated: typing.Callable = ..., linksActivated: typing.Callable = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., midLineWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., modelColumn: int = ..., mouseTracking: bool = ..., movement: QHelpIndexWidget.Movement = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., pressed: typing.Callable = ..., rect: PySide2.QtCore.QRect = ..., resizeMode: QHelpIndexWidget.ResizeMode = ..., selectionBehavior: QHelpIndexWidget.SelectionBehavior = ..., selectionMode: QHelpIndexWidget.SelectionMode = ..., selectionRectVisible: bool = ..., showDropIndicator: bool = ..., size: PySide2.QtCore.QSize = ..., sizeAdjustPolicy: QHelpIndexWidget.SizeAdjustPolicy = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., spacing: int = ..., statusTip: str = ..., styleSheet: str = ..., tabKeyNavigation: bool = ..., tabletTracking: bool = ..., textElideMode: PySide2.QtCore.Qt.TextElideMode = ..., toolTip: str = ..., toolTipDuration: int = ..., uniformItemSizes: bool = ..., updatesEnabled: bool = ..., verticalScrollBarPolicy: PySide2.QtCore.Qt.ScrollBarPolicy = ..., verticalScrollMode: QHelpIndexWidget.ScrollMode = ..., viewMode: QHelpIndexWidget.ViewMode = ..., viewportEntered: typing.Callable = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., wordWrap: bool = ..., x: int = ..., y: int = ..., **kwargs) -> None: ...
    def activateCurrentItem(self) -> None: ...
    def filterIndices(self, filter: str, wildcard: str = ...) -> None: ...

class QHelpLink(shiboken2.Object):
    title: _typeshed.Incomplete
    url: _typeshed.Incomplete
    @typing.overload
    def __init__(self, QHelpLink: QHelpLink) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def __copy__(self) -> None: ...

class QHelpSearchEngine(PySide2.QtCore.QObject):
    indexingFinished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    indexingStarted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    searchingFinished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    searchingStarted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, helpEngine: QHelpEngineCore, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def cancelIndexing(self) -> None: ...
    def cancelSearching(self) -> None: ...
    def hitCount(self) -> int: ...
    def hits(self, start: int, end: int) -> typing.List[typing.Tuple[str, str]]: ...
    def hitsCount(self) -> int: ...
    def query(self) -> typing.List[QHelpSearchQuery]: ...
    def queryWidget(self) -> QHelpSearchQueryWidget: ...
    def reindexDocumentation(self) -> None: ...
    def resultWidget(self) -> QHelpSearchResultWidget: ...
    def scheduleIndexDocumentation(self) -> None: ...
    @typing.overload
    def search(self, searchInput: str) -> None: ...
    @typing.overload
    def search(self, queryList: typing.Iterable[QHelpSearchQuery]) -> None: ...
    def searchInput(self) -> str: ...
    def searchResultCount(self) -> int: ...
    def searchResults(self, start: int, end: int) -> typing.List[QHelpSearchResult]: ...

class QHelpSearchQuery(shiboken2.Object):
    class FieldName:
        ALL: typing.ClassVar[QHelpSearchQuery.FieldName] = ...
        ATLEAST: typing.ClassVar[QHelpSearchQuery.FieldName] = ...
        DEFAULT: typing.ClassVar[QHelpSearchQuery.FieldName] = ...
        FUZZY: typing.ClassVar[QHelpSearchQuery.FieldName] = ...
        PHRASE: typing.ClassVar[QHelpSearchQuery.FieldName] = ...
        WITHOUT: typing.ClassVar[QHelpSearchQuery.FieldName] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QHelpSearchQuery.FieldName: ...
        def __and__(self, other: typing.SupportsInt) -> QHelpSearchQuery.FieldName: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QHelpSearchQuery.FieldName: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QHelpSearchQuery.FieldName: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QHelpSearchQuery.FieldName: ...
        def __rand__(self, other: typing.SupportsInt) -> QHelpSearchQuery.FieldName: ...
        def __rmul__(self, other: typing.SupportsInt) -> QHelpSearchQuery.FieldName: ...
        def __ror__(self, other: typing.SupportsInt) -> QHelpSearchQuery.FieldName: ...
        def __rsub__(self, other: typing.SupportsInt) -> QHelpSearchQuery.FieldName: ...
        def __rxor__(self, other: typing.SupportsInt) -> QHelpSearchQuery.FieldName: ...
        def __sub__(self, other: typing.SupportsInt) -> QHelpSearchQuery.FieldName: ...
        def __xor__(self, other: typing.SupportsInt) -> QHelpSearchQuery.FieldName: ...
    ALL: typing.ClassVar[QHelpSearchQuery.FieldName] = ...
    ATLEAST: typing.ClassVar[QHelpSearchQuery.FieldName] = ...
    DEFAULT: typing.ClassVar[QHelpSearchQuery.FieldName] = ...
    FUZZY: typing.ClassVar[QHelpSearchQuery.FieldName] = ...
    PHRASE: typing.ClassVar[QHelpSearchQuery.FieldName] = ...
    WITHOUT: typing.ClassVar[QHelpSearchQuery.FieldName] = ...
    fieldName: _typeshed.Incomplete
    wordList: _typeshed.Incomplete
    @typing.overload
    def __init__(self, field: QHelpSearchQuery.FieldName, wordList_: typing.Iterable[str]) -> None: ...
    @typing.overload
    def __init__(self, QHelpSearchQuery: QHelpSearchQuery) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def __copy__(self) -> None: ...

class QHelpSearchQueryWidget(PySide2.QtWidgets.QWidget):
    search: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtWidgets.QWidget | None = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: PySide2.QtGui.QCursor | PySide2.QtCore.Qt.CursorShape = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: PySide2.QtCore.Qt.InputMethodHints | PySide2.QtCore.Qt.InputMethodHint = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., search: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def collapseExtendedSearch(self) -> None: ...
    def expandExtendedSearch(self) -> None: ...
    def focusInEvent(self, focusEvent: PySide2.QtGui.QFocusEvent) -> None: ...
    def isCompactMode(self) -> bool: ...
    def query(self) -> typing.List[QHelpSearchQuery]: ...
    def searchInput(self) -> str: ...
    def setCompactMode(self, on: bool) -> None: ...
    def setQuery(self, queryList: typing.Iterable[QHelpSearchQuery]) -> None: ...
    def setSearchInput(self, searchInput: str) -> None: ...

class QHelpSearchResult(shiboken2.Object):
    @typing.overload
    def __init__(self, url: PySide2.QtCore.QUrl, title: str, snippet: str) -> None: ...
    @typing.overload
    def __init__(self, other: QHelpSearchResult) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def snippet(self) -> str: ...
    def title(self) -> str: ...
    def url(self) -> PySide2.QtCore.QUrl: ...

class QHelpSearchResultWidget(PySide2.QtWidgets.QWidget):
    requestShowLink: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: PySide2.QtGui.QCursor | PySide2.QtCore.Qt.CursorShape = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: PySide2.QtCore.Qt.InputMethodHints | PySide2.QtCore.Qt.InputMethodHint = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., requestShowLink: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ..., **kwargs) -> None: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def linkAt(self, point: PySide2.QtCore.QPoint) -> PySide2.QtCore.QUrl: ...
