import PySide2.QtCore
import PySide2.QtGui
import PySide2.QtMultimediaWidgets
import PySide2.QtNetwork
import _typeshed
import collections
import shiboken2
import typing
T = typing.TypeVar('T')
import typing_extensions

class QAbstractAudioDeviceInfo(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def deviceName(self) -> str: ...
    def isFormatSupported(self, format: QAudioFormat) -> bool: ...
    def preferredFormat(self) -> QAudioFormat: ...
    def supportedByteOrders(self) -> typing.List[QAudioFormat.Endian]: ...
    def supportedChannelCounts(self) -> typing.List[int]: ...
    def supportedCodecs(self) -> typing.List[str]: ...
    def supportedSampleRates(self) -> typing.List[int]: ...
    def supportedSampleSizes(self) -> typing.List[int]: ...
    def supportedSampleTypes(self) -> typing.List[QAudioFormat.SampleType]: ...

class QAbstractAudioInput(PySide2.QtCore.QObject):
    errorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    notify: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def bufferSize(self) -> int: ...
    def bytesReady(self) -> int: ...
    def elapsedUSecs(self) -> int: ...
    def error(self) -> QAudio.Error: ...
    def format(self) -> QAudioFormat: ...
    def notifyInterval(self) -> int: ...
    def periodSize(self) -> int: ...
    def processedUSecs(self) -> int: ...
    def reset(self) -> None: ...
    def resume(self) -> None: ...
    def setBufferSize(self, value: int) -> None: ...
    def setFormat(self, fmt: QAudioFormat) -> None: ...
    def setNotifyInterval(self, milliSeconds: int) -> None: ...
    def setVolume(self, arg__1: float) -> None: ...
    @typing.overload
    def start(self, device: PySide2.QtCore.QIODevice) -> None: ...
    @typing.overload
    def start(self) -> PySide2.QtCore.QIODevice: ...
    def state(self) -> QAudio.State: ...
    def stop(self) -> None: ...
    def suspend(self) -> None: ...
    def volume(self) -> float: ...

class QAbstractAudioOutput(PySide2.QtCore.QObject):
    errorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    notify: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def bufferSize(self) -> int: ...
    def bytesFree(self) -> int: ...
    def category(self) -> str: ...
    def elapsedUSecs(self) -> int: ...
    def error(self) -> QAudio.Error: ...
    def format(self) -> QAudioFormat: ...
    def notifyInterval(self) -> int: ...
    def periodSize(self) -> int: ...
    def processedUSecs(self) -> int: ...
    def reset(self) -> None: ...
    def resume(self) -> None: ...
    def setBufferSize(self, value: int) -> None: ...
    def setCategory(self, arg__1: str) -> None: ...
    def setFormat(self, fmt: QAudioFormat) -> None: ...
    def setNotifyInterval(self, milliSeconds: int) -> None: ...
    def setVolume(self, arg__1: float) -> None: ...
    @typing.overload
    def start(self, device: PySide2.QtCore.QIODevice) -> None: ...
    @typing.overload
    def start(self) -> PySide2.QtCore.QIODevice: ...
    def state(self) -> QAudio.State: ...
    def stop(self) -> None: ...
    def suspend(self) -> None: ...
    def volume(self) -> float: ...

class QAbstractVideoBuffer(shiboken2.Object):
    class HandleType:
        CoreImageHandle: typing.ClassVar[QAbstractVideoBuffer.HandleType] = ...
        EGLImageHandle: typing.ClassVar[QAbstractVideoBuffer.HandleType] = ...
        GLTextureHandle: typing.ClassVar[QAbstractVideoBuffer.HandleType] = ...
        NoHandle: typing.ClassVar[QAbstractVideoBuffer.HandleType] = ...
        QPixmapHandle: typing.ClassVar[QAbstractVideoBuffer.HandleType] = ...
        UserHandle: typing.ClassVar[QAbstractVideoBuffer.HandleType] = ...
        XvShmImageHandle: typing.ClassVar[QAbstractVideoBuffer.HandleType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractVideoBuffer.HandleType: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractVideoBuffer.HandleType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractVideoBuffer.HandleType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractVideoBuffer.HandleType: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractVideoBuffer.HandleType: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractVideoBuffer.HandleType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractVideoBuffer.HandleType: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractVideoBuffer.HandleType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractVideoBuffer.HandleType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractVideoBuffer.HandleType: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractVideoBuffer.HandleType: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractVideoBuffer.HandleType: ...

    class MapMode:
        NotMapped: typing.ClassVar[QAbstractVideoBuffer.MapMode] = ...
        ReadOnly: typing.ClassVar[QAbstractVideoBuffer.MapMode] = ...
        ReadWrite: typing.ClassVar[QAbstractVideoBuffer.MapMode] = ...
        WriteOnly: typing.ClassVar[QAbstractVideoBuffer.MapMode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractVideoBuffer.MapMode: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractVideoBuffer.MapMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractVideoBuffer.MapMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractVideoBuffer.MapMode: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractVideoBuffer.MapMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractVideoBuffer.MapMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractVideoBuffer.MapMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractVideoBuffer.MapMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractVideoBuffer.MapMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractVideoBuffer.MapMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractVideoBuffer.MapMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractVideoBuffer.MapMode: ...
    CoreImageHandle: typing.ClassVar[QAbstractVideoBuffer.HandleType] = ...
    EGLImageHandle: typing.ClassVar[QAbstractVideoBuffer.HandleType] = ...
    GLTextureHandle: typing.ClassVar[QAbstractVideoBuffer.HandleType] = ...
    NoHandle: typing.ClassVar[QAbstractVideoBuffer.HandleType] = ...
    NotMapped: typing.ClassVar[QAbstractVideoBuffer.MapMode] = ...
    QPixmapHandle: typing.ClassVar[QAbstractVideoBuffer.HandleType] = ...
    ReadOnly: typing.ClassVar[QAbstractVideoBuffer.MapMode] = ...
    ReadWrite: typing.ClassVar[QAbstractVideoBuffer.MapMode] = ...
    UserHandle: typing.ClassVar[QAbstractVideoBuffer.HandleType] = ...
    WriteOnly: typing.ClassVar[QAbstractVideoBuffer.MapMode] = ...
    XvShmImageHandle: typing.ClassVar[QAbstractVideoBuffer.HandleType] = ...
    m_type: _typeshed.Incomplete
    def __init__(self, type: QAbstractVideoBuffer.HandleType) -> None: ...
    def handle(self) -> typing.Any: ...
    def handleType(self) -> QAbstractVideoBuffer.HandleType: ...
    def mapMode(self) -> QAbstractVideoBuffer.MapMode: ...
    def release(self) -> None: ...
    def unmap(self) -> None: ...

class QAbstractVideoFilter(PySide2.QtCore.QObject):
    activeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def createFilterRunnable(self) -> QVideoFilterRunnable: ...
    def isActive(self) -> bool: ...
    def setActive(self, v: bool) -> None: ...

class QAbstractVideoSurface(PySide2.QtCore.QObject):
    class Error:
        IncorrectFormatError: typing.ClassVar[QAbstractVideoSurface.Error] = ...
        NoError: typing.ClassVar[QAbstractVideoSurface.Error] = ...
        ResourceError: typing.ClassVar[QAbstractVideoSurface.Error] = ...
        StoppedError: typing.ClassVar[QAbstractVideoSurface.Error] = ...
        UnsupportedFormatError: typing.ClassVar[QAbstractVideoSurface.Error] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractVideoSurface.Error: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractVideoSurface.Error: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractVideoSurface.Error: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractVideoSurface.Error: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractVideoSurface.Error: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractVideoSurface.Error: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractVideoSurface.Error: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractVideoSurface.Error: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractVideoSurface.Error: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractVideoSurface.Error: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractVideoSurface.Error: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractVideoSurface.Error: ...
    IncorrectFormatError: typing.ClassVar[QAbstractVideoSurface.Error] = ...
    NoError: typing.ClassVar[QAbstractVideoSurface.Error] = ...
    ResourceError: typing.ClassVar[QAbstractVideoSurface.Error] = ...
    StoppedError: typing.ClassVar[QAbstractVideoSurface.Error] = ...
    UnsupportedFormatError: typing.ClassVar[QAbstractVideoSurface.Error] = ...
    activeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    nativeResolutionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    supportedFormatsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    surfaceFormatChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def error(self) -> QAbstractVideoSurface.Error: ...
    def isActive(self) -> bool: ...
    def isFormatSupported(self, format: QVideoSurfaceFormat) -> bool: ...
    def nativeResolution(self) -> PySide2.QtCore.QSize: ...
    def nearestFormat(self, format: QVideoSurfaceFormat) -> QVideoSurfaceFormat: ...
    def present(self, frame: QVideoFrame) -> bool: ...
    def setError(self, error: QAbstractVideoSurface.Error) -> None: ...
    def setNativeResolution(self, resolution: PySide2.QtCore.QSize) -> None: ...
    def start(self, format: QVideoSurfaceFormat) -> bool: ...
    def stop(self) -> None: ...
    def supportedPixelFormats(self, type: QAbstractVideoBuffer.HandleType = ...) -> typing.List[QVideoFrame.PixelFormat]: ...
    def surfaceFormat(self) -> QVideoSurfaceFormat: ...

class QAudio(shiboken2.Object):
    class Error:
        FatalError: typing.ClassVar[QAudio.Error] = ...
        IOError: typing.ClassVar[QAudio.Error] = ...
        NoError: typing.ClassVar[QAudio.Error] = ...
        OpenError: typing.ClassVar[QAudio.Error] = ...
        UnderrunError: typing.ClassVar[QAudio.Error] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAudio.Error: ...
        def __and__(self, other: typing.SupportsInt) -> QAudio.Error: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAudio.Error: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAudio.Error: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QAudio.Error: ...
        def __rand__(self, other: typing.SupportsInt) -> QAudio.Error: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAudio.Error: ...
        def __ror__(self, other: typing.SupportsInt) -> QAudio.Error: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAudio.Error: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAudio.Error: ...
        def __sub__(self, other: typing.SupportsInt) -> QAudio.Error: ...
        def __xor__(self, other: typing.SupportsInt) -> QAudio.Error: ...

    class Mode:
        AudioInput: typing.ClassVar[QAudio.Mode] = ...
        AudioOutput: typing.ClassVar[QAudio.Mode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAudio.Mode: ...
        def __and__(self, other: typing.SupportsInt) -> QAudio.Mode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAudio.Mode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAudio.Mode: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QAudio.Mode: ...
        def __rand__(self, other: typing.SupportsInt) -> QAudio.Mode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAudio.Mode: ...
        def __ror__(self, other: typing.SupportsInt) -> QAudio.Mode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAudio.Mode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAudio.Mode: ...
        def __sub__(self, other: typing.SupportsInt) -> QAudio.Mode: ...
        def __xor__(self, other: typing.SupportsInt) -> QAudio.Mode: ...

    class Role:
        AccessibilityRole: typing.ClassVar[QAudio.Role] = ...
        AlarmRole: typing.ClassVar[QAudio.Role] = ...
        CustomRole: typing.ClassVar[QAudio.Role] = ...
        GameRole: typing.ClassVar[QAudio.Role] = ...
        MusicRole: typing.ClassVar[QAudio.Role] = ...
        NotificationRole: typing.ClassVar[QAudio.Role] = ...
        RingtoneRole: typing.ClassVar[QAudio.Role] = ...
        SonificationRole: typing.ClassVar[QAudio.Role] = ...
        UnknownRole: typing.ClassVar[QAudio.Role] = ...
        VideoRole: typing.ClassVar[QAudio.Role] = ...
        VoiceCommunicationRole: typing.ClassVar[QAudio.Role] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAudio.Role: ...
        def __and__(self, other: typing.SupportsInt) -> QAudio.Role: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAudio.Role: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAudio.Role: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QAudio.Role: ...
        def __rand__(self, other: typing.SupportsInt) -> QAudio.Role: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAudio.Role: ...
        def __ror__(self, other: typing.SupportsInt) -> QAudio.Role: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAudio.Role: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAudio.Role: ...
        def __sub__(self, other: typing.SupportsInt) -> QAudio.Role: ...
        def __xor__(self, other: typing.SupportsInt) -> QAudio.Role: ...

    class State:
        ActiveState: typing.ClassVar[QAudio.State] = ...
        IdleState: typing.ClassVar[QAudio.State] = ...
        InterruptedState: typing.ClassVar[QAudio.State] = ...
        StoppedState: typing.ClassVar[QAudio.State] = ...
        SuspendedState: typing.ClassVar[QAudio.State] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAudio.State: ...
        def __and__(self, other: typing.SupportsInt) -> QAudio.State: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAudio.State: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAudio.State: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QAudio.State: ...
        def __rand__(self, other: typing.SupportsInt) -> QAudio.State: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAudio.State: ...
        def __ror__(self, other: typing.SupportsInt) -> QAudio.State: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAudio.State: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAudio.State: ...
        def __sub__(self, other: typing.SupportsInt) -> QAudio.State: ...
        def __xor__(self, other: typing.SupportsInt) -> QAudio.State: ...

    class VolumeScale:
        CubicVolumeScale: typing.ClassVar[QAudio.VolumeScale] = ...
        DecibelVolumeScale: typing.ClassVar[QAudio.VolumeScale] = ...
        LinearVolumeScale: typing.ClassVar[QAudio.VolumeScale] = ...
        LogarithmicVolumeScale: typing.ClassVar[QAudio.VolumeScale] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAudio.VolumeScale: ...
        def __and__(self, other: typing.SupportsInt) -> QAudio.VolumeScale: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAudio.VolumeScale: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAudio.VolumeScale: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QAudio.VolumeScale: ...
        def __rand__(self, other: typing.SupportsInt) -> QAudio.VolumeScale: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAudio.VolumeScale: ...
        def __ror__(self, other: typing.SupportsInt) -> QAudio.VolumeScale: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAudio.VolumeScale: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAudio.VolumeScale: ...
        def __sub__(self, other: typing.SupportsInt) -> QAudio.VolumeScale: ...
        def __xor__(self, other: typing.SupportsInt) -> QAudio.VolumeScale: ...
    AccessibilityRole: typing.ClassVar[QAudio.Role] = ...
    ActiveState: typing.ClassVar[QAudio.State] = ...
    AlarmRole: typing.ClassVar[QAudio.Role] = ...
    AudioInput: typing.ClassVar[QAudio.Mode] = ...
    AudioOutput: typing.ClassVar[QAudio.Mode] = ...
    CubicVolumeScale: typing.ClassVar[QAudio.VolumeScale] = ...
    CustomRole: typing.ClassVar[QAudio.Role] = ...
    DecibelVolumeScale: typing.ClassVar[QAudio.VolumeScale] = ...
    FatalError: typing.ClassVar[QAudio.Error] = ...
    GameRole: typing.ClassVar[QAudio.Role] = ...
    IOError: typing.ClassVar[QAudio.Error] = ...
    IdleState: typing.ClassVar[QAudio.State] = ...
    InterruptedState: typing.ClassVar[QAudio.State] = ...
    LinearVolumeScale: typing.ClassVar[QAudio.VolumeScale] = ...
    LogarithmicVolumeScale: typing.ClassVar[QAudio.VolumeScale] = ...
    MusicRole: typing.ClassVar[QAudio.Role] = ...
    NoError: typing.ClassVar[QAudio.Error] = ...
    NotificationRole: typing.ClassVar[QAudio.Role] = ...
    OpenError: typing.ClassVar[QAudio.Error] = ...
    RingtoneRole: typing.ClassVar[QAudio.Role] = ...
    SonificationRole: typing.ClassVar[QAudio.Role] = ...
    StoppedState: typing.ClassVar[QAudio.State] = ...
    SuspendedState: typing.ClassVar[QAudio.State] = ...
    UnderrunError: typing.ClassVar[QAudio.Error] = ...
    UnknownRole: typing.ClassVar[QAudio.Role] = ...
    VideoRole: typing.ClassVar[QAudio.Role] = ...
    VoiceCommunicationRole: typing.ClassVar[QAudio.Role] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @staticmethod
    def convertVolume(volume: float, from_: QAudio.VolumeScale, to: QAudio.VolumeScale) -> float: ...

class QAudioBuffer(shiboken2.Object):
    @typing.overload
    def __init__(self, numFrames: int, format: QAudioFormat, startTime: int = ...) -> None: ...
    @typing.overload
    def __init__(self, data: PySide2.QtCore.QByteArray | bytes, format: QAudioFormat, startTime: int = ...) -> None: ...
    @typing.overload
    def __init__(self, other: QAudioBuffer) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def byteCount(self) -> int: ...
    def constData(self) -> int: ...
    def data(self) -> int: ...
    def duration(self) -> int: ...
    def format(self) -> QAudioFormat: ...
    def frameCount(self) -> int: ...
    def isValid(self) -> bool: ...
    def sampleCount(self) -> int: ...
    def startTime(self) -> int: ...
    def __copy__(self) -> None: ...

class QAudioDecoder(QMediaObject):
    class Error:
        AccessDeniedError: typing.ClassVar[QAudioDecoder.Error] = ...
        FormatError: typing.ClassVar[QAudioDecoder.Error] = ...
        NoError: typing.ClassVar[QAudioDecoder.Error] = ...
        ResourceError: typing.ClassVar[QAudioDecoder.Error] = ...
        ServiceMissingError: typing.ClassVar[QAudioDecoder.Error] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAudioDecoder.Error: ...
        def __and__(self, other: typing.SupportsInt) -> QAudioDecoder.Error: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAudioDecoder.Error: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAudioDecoder.Error: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QAudioDecoder.Error: ...
        def __rand__(self, other: typing.SupportsInt) -> QAudioDecoder.Error: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAudioDecoder.Error: ...
        def __ror__(self, other: typing.SupportsInt) -> QAudioDecoder.Error: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAudioDecoder.Error: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAudioDecoder.Error: ...
        def __sub__(self, other: typing.SupportsInt) -> QAudioDecoder.Error: ...
        def __xor__(self, other: typing.SupportsInt) -> QAudioDecoder.Error: ...

    class State:
        DecodingState: typing.ClassVar[QAudioDecoder.State] = ...
        StoppedState: typing.ClassVar[QAudioDecoder.State] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAudioDecoder.State: ...
        def __and__(self, other: typing.SupportsInt) -> QAudioDecoder.State: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAudioDecoder.State: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAudioDecoder.State: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QAudioDecoder.State: ...
        def __rand__(self, other: typing.SupportsInt) -> QAudioDecoder.State: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAudioDecoder.State: ...
        def __ror__(self, other: typing.SupportsInt) -> QAudioDecoder.State: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAudioDecoder.State: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAudioDecoder.State: ...
        def __sub__(self, other: typing.SupportsInt) -> QAudioDecoder.State: ...
        def __xor__(self, other: typing.SupportsInt) -> QAudioDecoder.State: ...
    AccessDeniedError: typing.ClassVar[QAudioDecoder.Error] = ...
    DecodingState: typing.ClassVar[QAudioDecoder.State] = ...
    FormatError: typing.ClassVar[QAudioDecoder.Error] = ...
    NoError: typing.ClassVar[QAudioDecoder.Error] = ...
    ResourceError: typing.ClassVar[QAudioDecoder.Error] = ...
    ServiceMissingError: typing.ClassVar[QAudioDecoder.Error] = ...
    StoppedState: typing.ClassVar[QAudioDecoder.State] = ...
    bufferAvailableChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    bufferReady: typing.ClassVar[PySide2.QtCore.Signal] = ...
    durationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    finished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    formatChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    positionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sourceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., availabilityChanged: typing.Callable = ..., bufferAvailable: bool = ..., bufferAvailableChanged: typing.Callable = ..., bufferReady: typing.Callable = ..., destroyed: typing.Callable = ..., durationChanged: typing.Callable = ..., error: typing.Callable = ..., finished: typing.Callable = ..., formatChanged: typing.Callable = ..., metaDataAvailableChanged: typing.Callable = ..., metaDataChanged: typing.Callable = ..., notifyInterval: int = ..., notifyIntervalChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., positionChanged: typing.Callable = ..., sourceChanged: typing.Callable = ..., sourceFilename: str = ..., state: QAudioDecoder.State = ..., stateChanged: typing.Callable = ...) -> None: ...
    def audioFormat(self) -> QAudioFormat: ...
    def bind(self, arg__1: PySide2.QtCore.QObject) -> bool: ...
    def bufferAvailable(self) -> bool: ...
    def duration(self) -> int: ...
    def errorString(self) -> str: ...
    @staticmethod
    def hasSupport(mimeType: str, codecs: typing.Iterable[str] = ...) -> QMultimedia.SupportEstimate: ...
    def position(self) -> int: ...
    def read(self) -> QAudioBuffer: ...
    def setAudioFormat(self, format: QAudioFormat) -> None: ...
    def setSourceDevice(self, device: PySide2.QtCore.QIODevice) -> None: ...
    def setSourceFilename(self, fileName: str) -> None: ...
    def sourceDevice(self) -> PySide2.QtCore.QIODevice: ...
    def sourceFilename(self) -> str: ...
    def start(self) -> None: ...
    def state(self) -> QAudioDecoder.State: ...
    def stop(self) -> None: ...
    def unbind(self, arg__1: PySide2.QtCore.QObject) -> None: ...

class QAudioDecoderControl(QMediaControl):
    bufferAvailableChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    bufferReady: typing.ClassVar[PySide2.QtCore.Signal] = ...
    durationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    finished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    formatChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    positionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sourceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def audioFormat(self) -> QAudioFormat: ...
    def bufferAvailable(self) -> bool: ...
    def duration(self) -> int: ...
    def position(self) -> int: ...
    def read(self) -> QAudioBuffer: ...
    def setAudioFormat(self, format: QAudioFormat) -> None: ...
    def setSourceDevice(self, device: PySide2.QtCore.QIODevice) -> None: ...
    def setSourceFilename(self, fileName: str) -> None: ...
    def sourceDevice(self) -> PySide2.QtCore.QIODevice: ...
    def sourceFilename(self) -> str: ...
    def start(self) -> None: ...
    def state(self) -> QAudioDecoder.State: ...
    def stop(self) -> None: ...

class QAudioDeviceInfo(shiboken2.Object):
    @typing.overload
    def __init__(self, other: QAudioDeviceInfo) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @staticmethod
    def availableDevices(mode: QAudio.Mode) -> typing.List[QAudioDeviceInfo]: ...
    @staticmethod
    def defaultInputDevice() -> QAudioDeviceInfo: ...
    @staticmethod
    def defaultOutputDevice() -> QAudioDeviceInfo: ...
    def deviceName(self) -> str: ...
    def isFormatSupported(self, format: QAudioFormat) -> bool: ...
    def isNull(self) -> bool: ...
    def nearestFormat(self, format: QAudioFormat) -> QAudioFormat: ...
    def preferredFormat(self) -> QAudioFormat: ...
    def realm(self) -> str: ...
    def supportedByteOrders(self) -> typing.List[QAudioFormat.Endian]: ...
    def supportedChannelCounts(self) -> typing.List[int]: ...
    def supportedCodecs(self) -> typing.List[str]: ...
    def supportedSampleRates(self) -> typing.List[int]: ...
    def supportedSampleSizes(self) -> typing.List[int]: ...
    def supportedSampleTypes(self) -> typing.List[QAudioFormat.SampleType]: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QAudioEncoderSettings(shiboken2.Object):
    @typing.overload
    def __init__(self, other: QAudioEncoderSettings) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def bitRate(self) -> int: ...
    def channelCount(self) -> int: ...
    def codec(self) -> str: ...
    def encodingMode(self) -> QMultimedia.EncodingMode: ...
    def encodingOption(self, option: str) -> typing.Any: ...
    def encodingOptions(self) -> typing.Dict[str, typing.Any]: ...
    def isNull(self) -> bool: ...
    def quality(self) -> QMultimedia.EncodingQuality: ...
    def sampleRate(self) -> int: ...
    def setBitRate(self, bitrate: int) -> None: ...
    def setChannelCount(self, channels: int) -> None: ...
    def setCodec(self, codec: str) -> None: ...
    def setEncodingMode(self, arg__1: QMultimedia.EncodingMode) -> None: ...
    def setEncodingOption(self, option: str, value: typing.Any) -> None: ...
    def setEncodingOptions(self, options: typing.Dict[str, typing.Any]) -> None: ...
    def setQuality(self, quality: QMultimedia.EncodingQuality) -> None: ...
    def setSampleRate(self, rate: int) -> None: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QAudioEncoderSettingsControl(QMediaControl):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def audioSettings(self) -> QAudioEncoderSettings: ...
    def codecDescription(self, codecName: str) -> str: ...
    def setAudioSettings(self, settings: QAudioEncoderSettings) -> None: ...
    def supportedAudioCodecs(self) -> typing.List[str]: ...

class QAudioFormat(shiboken2.Object):
    class Endian:
        BigEndian: typing.ClassVar[QAudioFormat.Endian] = ...
        LittleEndian: typing.ClassVar[QAudioFormat.Endian] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAudioFormat.Endian: ...
        def __and__(self, other: typing.SupportsInt) -> QAudioFormat.Endian: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAudioFormat.Endian: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAudioFormat.Endian: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QAudioFormat.Endian: ...
        def __rand__(self, other: typing.SupportsInt) -> QAudioFormat.Endian: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAudioFormat.Endian: ...
        def __ror__(self, other: typing.SupportsInt) -> QAudioFormat.Endian: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAudioFormat.Endian: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAudioFormat.Endian: ...
        def __sub__(self, other: typing.SupportsInt) -> QAudioFormat.Endian: ...
        def __xor__(self, other: typing.SupportsInt) -> QAudioFormat.Endian: ...

    class SampleType:
        Float: typing.ClassVar[QAudioFormat.SampleType] = ...
        SignedInt: typing.ClassVar[QAudioFormat.SampleType] = ...
        UnSignedInt: typing.ClassVar[QAudioFormat.SampleType] = ...
        Unknown: typing.ClassVar[QAudioFormat.SampleType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAudioFormat.SampleType: ...
        def __and__(self, other: typing.SupportsInt) -> QAudioFormat.SampleType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAudioFormat.SampleType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAudioFormat.SampleType: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QAudioFormat.SampleType: ...
        def __rand__(self, other: typing.SupportsInt) -> QAudioFormat.SampleType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAudioFormat.SampleType: ...
        def __ror__(self, other: typing.SupportsInt) -> QAudioFormat.SampleType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAudioFormat.SampleType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAudioFormat.SampleType: ...
        def __sub__(self, other: typing.SupportsInt) -> QAudioFormat.SampleType: ...
        def __xor__(self, other: typing.SupportsInt) -> QAudioFormat.SampleType: ...
    BigEndian: typing.ClassVar[QAudioFormat.Endian] = ...
    Float: typing.ClassVar[QAudioFormat.SampleType] = ...
    LittleEndian: typing.ClassVar[QAudioFormat.Endian] = ...
    SignedInt: typing.ClassVar[QAudioFormat.SampleType] = ...
    UnSignedInt: typing.ClassVar[QAudioFormat.SampleType] = ...
    Unknown: typing.ClassVar[QAudioFormat.SampleType] = ...
    @typing.overload
    def __init__(self, other: QAudioFormat) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def byteOrder(self) -> QAudioFormat.Endian: ...
    def bytesForDuration(self, duration: int) -> int: ...
    def bytesForFrames(self, frameCount: int) -> int: ...
    def bytesPerFrame(self) -> int: ...
    def channelCount(self) -> int: ...
    def codec(self) -> str: ...
    def durationForBytes(self, byteCount: int) -> int: ...
    def durationForFrames(self, frameCount: int) -> int: ...
    def framesForBytes(self, byteCount: int) -> int: ...
    def framesForDuration(self, duration: int) -> int: ...
    def isValid(self) -> bool: ...
    def sampleRate(self) -> int: ...
    def sampleSize(self) -> int: ...
    def sampleType(self) -> QAudioFormat.SampleType: ...
    def setByteOrder(self, byteOrder: QAudioFormat.Endian) -> None: ...
    def setChannelCount(self, channelCount: int) -> None: ...
    def setCodec(self, codec: str) -> None: ...
    def setSampleRate(self, sampleRate: int) -> None: ...
    def setSampleSize(self, sampleSize: int) -> None: ...
    def setSampleType(self, sampleType: QAudioFormat.SampleType) -> None: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QAudioInput(PySide2.QtCore.QObject):
    notify: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @typing.overload
    def __init__(self, audioDeviceInfo: QAudioDeviceInfo, format: QAudioFormat = ..., parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., notify: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., stateChanged: typing.Callable = ...) -> None: ...
    @typing.overload
    def __init__(self, format: QAudioFormat = ..., parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., notify: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., stateChanged: typing.Callable = ...) -> None: ...
    def bufferSize(self) -> int: ...
    def bytesReady(self) -> int: ...
    def elapsedUSecs(self) -> int: ...
    def error(self) -> QAudio.Error: ...
    def format(self) -> QAudioFormat: ...
    def notifyInterval(self) -> int: ...
    def periodSize(self) -> int: ...
    def processedUSecs(self) -> int: ...
    def reset(self) -> None: ...
    def resume(self) -> None: ...
    def setBufferSize(self, bytes: int) -> None: ...
    def setNotifyInterval(self, milliSeconds: int) -> None: ...
    def setVolume(self, volume: float) -> None: ...
    @typing.overload
    def start(self, device: PySide2.QtCore.QIODevice) -> None: ...
    @typing.overload
    def start(self) -> PySide2.QtCore.QIODevice: ...
    def state(self) -> QAudio.State: ...
    def stop(self) -> None: ...
    def suspend(self) -> None: ...
    def volume(self) -> float: ...

class QAudioInputSelectorControl(QMediaControl):
    activeInputChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    availableInputsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def activeInput(self) -> str: ...
    def availableInputs(self) -> typing.List[str]: ...
    def defaultInput(self) -> str: ...
    def inputDescription(self, name: str) -> str: ...
    def setActiveInput(self, name: str) -> None: ...

class QAudioOutput(PySide2.QtCore.QObject):
    notify: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @typing.overload
    def __init__(self, audioDeviceInfo: QAudioDeviceInfo, format: QAudioFormat = ..., parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., notify: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., stateChanged: typing.Callable = ...) -> None: ...
    @typing.overload
    def __init__(self, format: QAudioFormat = ..., parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., notify: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., stateChanged: typing.Callable = ...) -> None: ...
    def bufferSize(self) -> int: ...
    def bytesFree(self) -> int: ...
    def category(self) -> str: ...
    def elapsedUSecs(self) -> int: ...
    def error(self) -> QAudio.Error: ...
    def format(self) -> QAudioFormat: ...
    def notifyInterval(self) -> int: ...
    def periodSize(self) -> int: ...
    def processedUSecs(self) -> int: ...
    def reset(self) -> None: ...
    def resume(self) -> None: ...
    def setBufferSize(self, bytes: int) -> None: ...
    def setCategory(self, category: str) -> None: ...
    def setNotifyInterval(self, milliSeconds: int) -> None: ...
    def setVolume(self, arg__1: float) -> None: ...
    @typing.overload
    def start(self, device: PySide2.QtCore.QIODevice) -> None: ...
    @typing.overload
    def start(self) -> PySide2.QtCore.QIODevice: ...
    def state(self) -> QAudio.State: ...
    def stop(self) -> None: ...
    def suspend(self) -> None: ...
    def volume(self) -> float: ...

class QAudioOutputSelectorControl(QMediaControl):
    activeOutputChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    availableOutputsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def activeOutput(self) -> str: ...
    def availableOutputs(self) -> typing.List[str]: ...
    def defaultOutput(self) -> str: ...
    def outputDescription(self, name: str) -> str: ...
    def setActiveOutput(self, name: str) -> None: ...

class QAudioProbe(PySide2.QtCore.QObject):
    audioBufferProbed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    flush: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., audioBufferProbed: typing.Callable = ..., destroyed: typing.Callable = ..., flush: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def isActive(self) -> bool: ...
    @typing.overload
    def setSource(self, source: QMediaObject) -> bool: ...
    @typing.overload
    def setSource(self, source: QMediaRecorder) -> bool: ...

class QAudioRecorder(QMediaRecorder):
    audioInputChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    availableAudioInputsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., actualLocation: PySide2.QtCore.QUrl = ..., actualLocationChanged: typing.Callable = ..., audioInput: str = ..., audioInputChanged: typing.Callable = ..., availabilityChanged: typing.Callable = ..., availableAudioInputsChanged: typing.Callable = ..., destroyed: typing.Callable = ..., duration: int = ..., durationChanged: typing.Callable = ..., error: typing.Callable = ..., metaDataAvailable: bool = ..., metaDataAvailableChanged: typing.Callable = ..., metaDataChanged: typing.Callable = ..., metaDataWritable: bool = ..., metaDataWritableChanged: typing.Callable = ..., muted: bool = ..., mutedChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., outputLocation: PySide2.QtCore.QUrl = ..., state: typing.Any = ..., stateChanged: typing.Callable = ..., status: typing.Any = ..., statusChanged: typing.Callable = ..., volume: float = ..., volumeChanged: typing.Callable = ...) -> None: ...
    def audioInput(self) -> str: ...
    def audioInputDescription(self, name: str) -> str: ...
    def audioInputs(self) -> typing.List[str]: ...
    def defaultAudioInput(self) -> str: ...
    def setAudioInput(self, name: str) -> None: ...

class QAudioRoleControl(QMediaControl):
    audioRoleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def audioRole(self) -> QAudio.Role: ...
    def setAudioRole(self, role: QAudio.Role) -> None: ...
    def supportedAudioRoles(self) -> typing.List[QAudio.Role]: ...

class QCamera(QMediaObject):
    class CaptureMode:
        CaptureStillImage: typing.ClassVar[QCamera.CaptureMode] = ...
        CaptureVideo: typing.ClassVar[QCamera.CaptureMode] = ...
        CaptureViewfinder: typing.ClassVar[QCamera.CaptureMode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QCamera.CaptureModes: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QCamera.CaptureModes: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCamera.CaptureModes: ...
        def __rand__(self, other: typing.SupportsInt) -> QCamera.CaptureModes: ...
        def __ror__(self, other: typing.SupportsInt) -> QCamera.CaptureModes: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCamera.CaptureModes: ...
        def __xor__(self, other: typing.SupportsInt) -> QCamera.CaptureModes: ...

    class CaptureModes:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QCamera.CaptureModes: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QCamera.CaptureModes: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCamera.CaptureModes: ...
        def __rand__(self, other: typing.SupportsInt) -> QCamera.CaptureModes: ...
        def __ror__(self, other: typing.SupportsInt) -> QCamera.CaptureModes: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCamera.CaptureModes: ...
        def __xor__(self, other: typing.SupportsInt) -> QCamera.CaptureModes: ...

    class Error:
        CameraError: typing.ClassVar[QCamera.Error] = ...
        InvalidRequestError: typing.ClassVar[QCamera.Error] = ...
        NoError: typing.ClassVar[QCamera.Error] = ...
        NotSupportedFeatureError: typing.ClassVar[QCamera.Error] = ...
        ServiceMissingError: typing.ClassVar[QCamera.Error] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCamera.Error: ...
        def __and__(self, other: typing.SupportsInt) -> QCamera.Error: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCamera.Error: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCamera.Error: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QCamera.Error: ...
        def __rand__(self, other: typing.SupportsInt) -> QCamera.Error: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCamera.Error: ...
        def __ror__(self, other: typing.SupportsInt) -> QCamera.Error: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCamera.Error: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCamera.Error: ...
        def __sub__(self, other: typing.SupportsInt) -> QCamera.Error: ...
        def __xor__(self, other: typing.SupportsInt) -> QCamera.Error: ...

    class FrameRateRange(shiboken2.Object):
        maximumFrameRate: _typeshed.Incomplete
        minimumFrameRate: _typeshed.Incomplete
        @typing.overload
        def __init__(self, minimum: float, maximum: float) -> None: ...
        @typing.overload
        def __init__(self, FrameRateRange: QCamera.FrameRateRange) -> None: ...
        @typing.overload
        def __init__(self) -> None: ...
        def __copy__(self) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...

    class LockChangeReason:
        LockAcquired: typing.ClassVar[QCamera.LockChangeReason] = ...
        LockFailed: typing.ClassVar[QCamera.LockChangeReason] = ...
        LockLost: typing.ClassVar[QCamera.LockChangeReason] = ...
        LockTemporaryLost: typing.ClassVar[QCamera.LockChangeReason] = ...
        UserRequest: typing.ClassVar[QCamera.LockChangeReason] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCamera.LockChangeReason: ...
        def __and__(self, other: typing.SupportsInt) -> QCamera.LockChangeReason: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCamera.LockChangeReason: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCamera.LockChangeReason: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QCamera.LockChangeReason: ...
        def __rand__(self, other: typing.SupportsInt) -> QCamera.LockChangeReason: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCamera.LockChangeReason: ...
        def __ror__(self, other: typing.SupportsInt) -> QCamera.LockChangeReason: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCamera.LockChangeReason: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCamera.LockChangeReason: ...
        def __sub__(self, other: typing.SupportsInt) -> QCamera.LockChangeReason: ...
        def __xor__(self, other: typing.SupportsInt) -> QCamera.LockChangeReason: ...

    class LockStatus:
        Locked: typing.ClassVar[QCamera.LockStatus] = ...
        Searching: typing.ClassVar[QCamera.LockStatus] = ...
        Unlocked: typing.ClassVar[QCamera.LockStatus] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCamera.LockStatus: ...
        def __and__(self, other: typing.SupportsInt) -> QCamera.LockStatus: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCamera.LockStatus: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCamera.LockStatus: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QCamera.LockStatus: ...
        def __rand__(self, other: typing.SupportsInt) -> QCamera.LockStatus: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCamera.LockStatus: ...
        def __ror__(self, other: typing.SupportsInt) -> QCamera.LockStatus: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCamera.LockStatus: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCamera.LockStatus: ...
        def __sub__(self, other: typing.SupportsInt) -> QCamera.LockStatus: ...
        def __xor__(self, other: typing.SupportsInt) -> QCamera.LockStatus: ...

    class LockType:
        LockExposure: typing.ClassVar[QCamera.LockType] = ...
        LockFocus: typing.ClassVar[QCamera.LockType] = ...
        LockWhiteBalance: typing.ClassVar[QCamera.LockType] = ...
        NoLock: typing.ClassVar[QCamera.LockType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QCamera.LockTypes: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QCamera.LockTypes: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCamera.LockTypes: ...
        def __rand__(self, other: typing.SupportsInt) -> QCamera.LockTypes: ...
        def __ror__(self, other: typing.SupportsInt) -> QCamera.LockTypes: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCamera.LockTypes: ...
        def __xor__(self, other: typing.SupportsInt) -> QCamera.LockTypes: ...

    class LockTypes:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QCamera.LockTypes: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QCamera.LockTypes: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCamera.LockTypes: ...
        def __rand__(self, other: typing.SupportsInt) -> QCamera.LockTypes: ...
        def __ror__(self, other: typing.SupportsInt) -> QCamera.LockTypes: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCamera.LockTypes: ...
        def __xor__(self, other: typing.SupportsInt) -> QCamera.LockTypes: ...

    class Position:
        BackFace: typing.ClassVar[QCamera.Position] = ...
        FrontFace: typing.ClassVar[QCamera.Position] = ...
        UnspecifiedPosition: typing.ClassVar[QCamera.Position] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCamera.Position: ...
        def __and__(self, other: typing.SupportsInt) -> QCamera.Position: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCamera.Position: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCamera.Position: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QCamera.Position: ...
        def __rand__(self, other: typing.SupportsInt) -> QCamera.Position: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCamera.Position: ...
        def __ror__(self, other: typing.SupportsInt) -> QCamera.Position: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCamera.Position: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCamera.Position: ...
        def __sub__(self, other: typing.SupportsInt) -> QCamera.Position: ...
        def __xor__(self, other: typing.SupportsInt) -> QCamera.Position: ...

    class State:
        ActiveState: typing.ClassVar[QCamera.State] = ...
        LoadedState: typing.ClassVar[QCamera.State] = ...
        UnloadedState: typing.ClassVar[QCamera.State] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCamera.State: ...
        def __and__(self, other: typing.SupportsInt) -> QCamera.State: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCamera.State: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCamera.State: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QCamera.State: ...
        def __rand__(self, other: typing.SupportsInt) -> QCamera.State: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCamera.State: ...
        def __ror__(self, other: typing.SupportsInt) -> QCamera.State: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCamera.State: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCamera.State: ...
        def __sub__(self, other: typing.SupportsInt) -> QCamera.State: ...
        def __xor__(self, other: typing.SupportsInt) -> QCamera.State: ...

    class Status:
        ActiveStatus: typing.ClassVar[QCamera.Status] = ...
        LoadedStatus: typing.ClassVar[QCamera.Status] = ...
        LoadingStatus: typing.ClassVar[QCamera.Status] = ...
        StandbyStatus: typing.ClassVar[QCamera.Status] = ...
        StartingStatus: typing.ClassVar[QCamera.Status] = ...
        StoppingStatus: typing.ClassVar[QCamera.Status] = ...
        UnavailableStatus: typing.ClassVar[QCamera.Status] = ...
        UnloadedStatus: typing.ClassVar[QCamera.Status] = ...
        UnloadingStatus: typing.ClassVar[QCamera.Status] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCamera.Status: ...
        def __and__(self, other: typing.SupportsInt) -> QCamera.Status: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCamera.Status: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCamera.Status: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QCamera.Status: ...
        def __rand__(self, other: typing.SupportsInt) -> QCamera.Status: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCamera.Status: ...
        def __ror__(self, other: typing.SupportsInt) -> QCamera.Status: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCamera.Status: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCamera.Status: ...
        def __sub__(self, other: typing.SupportsInt) -> QCamera.Status: ...
        def __xor__(self, other: typing.SupportsInt) -> QCamera.Status: ...
    ActiveState: typing.ClassVar[QCamera.State] = ...
    ActiveStatus: typing.ClassVar[QCamera.Status] = ...
    BackFace: typing.ClassVar[QCamera.Position] = ...
    CameraError: typing.ClassVar[QCamera.Error] = ...
    CaptureStillImage: typing.ClassVar[QCamera.CaptureMode] = ...
    CaptureVideo: typing.ClassVar[QCamera.CaptureMode] = ...
    CaptureViewfinder: typing.ClassVar[QCamera.CaptureMode] = ...
    FrontFace: typing.ClassVar[QCamera.Position] = ...
    InvalidRequestError: typing.ClassVar[QCamera.Error] = ...
    LoadedState: typing.ClassVar[QCamera.State] = ...
    LoadedStatus: typing.ClassVar[QCamera.Status] = ...
    LoadingStatus: typing.ClassVar[QCamera.Status] = ...
    LockAcquired: typing.ClassVar[QCamera.LockChangeReason] = ...
    LockExposure: typing.ClassVar[QCamera.LockType] = ...
    LockFailed: typing.ClassVar[QCamera.LockChangeReason] = ...
    LockFocus: typing.ClassVar[QCamera.LockType] = ...
    LockLost: typing.ClassVar[QCamera.LockChangeReason] = ...
    LockTemporaryLost: typing.ClassVar[QCamera.LockChangeReason] = ...
    LockWhiteBalance: typing.ClassVar[QCamera.LockType] = ...
    Locked: typing.ClassVar[QCamera.LockStatus] = ...
    NoError: typing.ClassVar[QCamera.Error] = ...
    NoLock: typing.ClassVar[QCamera.LockType] = ...
    NotSupportedFeatureError: typing.ClassVar[QCamera.Error] = ...
    Searching: typing.ClassVar[QCamera.LockStatus] = ...
    ServiceMissingError: typing.ClassVar[QCamera.Error] = ...
    StandbyStatus: typing.ClassVar[QCamera.Status] = ...
    StartingStatus: typing.ClassVar[QCamera.Status] = ...
    StoppingStatus: typing.ClassVar[QCamera.Status] = ...
    UnavailableStatus: typing.ClassVar[QCamera.Status] = ...
    UnloadedState: typing.ClassVar[QCamera.State] = ...
    UnloadedStatus: typing.ClassVar[QCamera.Status] = ...
    UnloadingStatus: typing.ClassVar[QCamera.Status] = ...
    Unlocked: typing.ClassVar[QCamera.LockStatus] = ...
    UnspecifiedPosition: typing.ClassVar[QCamera.Position] = ...
    UserRequest: typing.ClassVar[QCamera.LockChangeReason] = ...
    captureModeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    errorOccurred: typing.ClassVar[PySide2.QtCore.Signal] = ...
    lockFailed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    lockStatusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    locked: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    statusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @typing.overload
    def __init__(self, position: QCamera.Position, parent: PySide2.QtCore.QObject | None = ..., availabilityChanged: typing.Callable = ..., captureMode: QCamera.CaptureModes | QCamera.CaptureMode = ..., captureModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., errorOccurred: typing.Callable = ..., lockFailed: typing.Callable = ..., lockStatus: typing.Any = ..., lockStatusChanged: typing.Callable = ..., locked: typing.Callable = ..., metaDataAvailableChanged: typing.Callable = ..., metaDataChanged: typing.Callable = ..., notifyInterval: int = ..., notifyIntervalChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., state: typing.Any = ..., stateChanged: typing.Callable = ..., status: typing.Any = ..., statusChanged: typing.Callable = ...) -> None: ...
    @typing.overload
    def __init__(self, deviceName: PySide2.QtCore.QByteArray | bytes, parent: PySide2.QtCore.QObject | None = ..., availabilityChanged: typing.Callable = ..., captureMode: QCamera.CaptureModes | QCamera.CaptureMode = ..., captureModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., errorOccurred: typing.Callable = ..., lockFailed: typing.Callable = ..., lockStatus: typing.Any = ..., lockStatusChanged: typing.Callable = ..., locked: typing.Callable = ..., metaDataAvailableChanged: typing.Callable = ..., metaDataChanged: typing.Callable = ..., notifyInterval: int = ..., notifyIntervalChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., state: typing.Any = ..., stateChanged: typing.Callable = ..., status: typing.Any = ..., statusChanged: typing.Callable = ...) -> None: ...
    @typing.overload
    def __init__(self, cameraInfo: QCameraInfo, parent: PySide2.QtCore.QObject | None = ..., availabilityChanged: typing.Callable = ..., captureMode: QCamera.CaptureModes | QCamera.CaptureMode = ..., captureModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., errorOccurred: typing.Callable = ..., lockFailed: typing.Callable = ..., lockStatus: typing.Any = ..., lockStatusChanged: typing.Callable = ..., locked: typing.Callable = ..., metaDataAvailableChanged: typing.Callable = ..., metaDataChanged: typing.Callable = ..., notifyInterval: int = ..., notifyIntervalChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., state: typing.Any = ..., stateChanged: typing.Callable = ..., status: typing.Any = ..., statusChanged: typing.Callable = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., availabilityChanged: typing.Callable = ..., captureMode: QCamera.CaptureModes | QCamera.CaptureMode = ..., captureModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., errorOccurred: typing.Callable = ..., lockFailed: typing.Callable = ..., lockStatus: typing.Any = ..., lockStatusChanged: typing.Callable = ..., locked: typing.Callable = ..., metaDataAvailableChanged: typing.Callable = ..., metaDataChanged: typing.Callable = ..., notifyInterval: int = ..., notifyIntervalChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., state: typing.Any = ..., stateChanged: typing.Callable = ..., status: typing.Any = ..., statusChanged: typing.Callable = ...) -> None: ...
    def availability(self) -> QMultimedia.AvailabilityStatus: ...
    @staticmethod
    def availableDevices() -> typing.List[PySide2.QtCore.QByteArray]: ...
    def captureMode(self) -> QCamera.CaptureModes | QCamera.CaptureMode: ...
    @staticmethod
    def deviceDescription(device: PySide2.QtCore.QByteArray | bytes) -> str: ...
    def errorString(self) -> str: ...
    def exposure(self) -> QCameraExposure: ...
    def focus(self) -> QCameraFocus: ...
    def imageProcessing(self) -> QCameraImageProcessing: ...
    def isCaptureModeSupported(self, mode: QCamera.CaptureModes | QCamera.CaptureMode) -> bool: ...
    def load(self) -> None: ...
    @typing.overload
    def lockStatus(self, lock: QCamera.LockType) -> QCamera.LockStatus: ...
    @typing.overload
    def lockStatus(self) -> QCamera.LockStatus: ...
    def requestedLocks(self) -> QCamera.LockTypes | QCamera.LockType: ...
    @typing.overload
    def searchAndLock(self, locks: QCamera.LockTypes | QCamera.LockType) -> None: ...
    @typing.overload
    def searchAndLock(self) -> None: ...
    def setCaptureMode(self, mode: QCamera.CaptureModes | QCamera.CaptureMode) -> None: ...
    @typing.overload
    def setViewfinder(self, viewfinder: PySide2.QtMultimediaWidgets.QGraphicsVideoItem) -> None: ...
    @typing.overload
    def setViewfinder(self, viewfinder: PySide2.QtMultimediaWidgets.QVideoWidget) -> None: ...
    @typing.overload
    def setViewfinder(self, surface: QAbstractVideoSurface) -> None: ...
    def setViewfinderSettings(self, settings: QCameraViewfinderSettings) -> None: ...
    def start(self) -> None: ...
    def state(self) -> QCamera.State: ...
    def status(self) -> QCamera.Status: ...
    def stop(self) -> None: ...
    def supportedLocks(self) -> QCamera.LockTypes | QCamera.LockType: ...
    def supportedViewfinderFrameRateRanges(self, settings: QCameraViewfinderSettings = ...) -> typing.List[QCamera.FrameRateRange]: ...
    def supportedViewfinderPixelFormats(self, settings: QCameraViewfinderSettings = ...) -> typing.List[QVideoFrame.PixelFormat]: ...
    def supportedViewfinderResolutions(self, settings: QCameraViewfinderSettings = ...) -> typing.List[PySide2.QtCore.QSize]: ...
    def supportedViewfinderSettings(self, settings: QCameraViewfinderSettings = ...) -> typing.List[QCameraViewfinderSettings]: ...
    def unload(self) -> None: ...
    @typing.overload
    def unlock(self, locks: QCamera.LockTypes | QCamera.LockType) -> None: ...
    @typing.overload
    def unlock(self) -> None: ...
    def viewfinderSettings(self) -> QCameraViewfinderSettings: ...

class QCameraCaptureBufferFormatControl(QMediaControl):
    bufferFormatChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def bufferFormat(self) -> QVideoFrame.PixelFormat: ...
    def setBufferFormat(self, format: QVideoFrame.PixelFormat) -> None: ...
    def supportedBufferFormats(self) -> typing.List[QVideoFrame.PixelFormat]: ...

class QCameraCaptureDestinationControl(QMediaControl):
    captureDestinationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def captureDestination(self) -> QCameraImageCapture.CaptureDestinations | QCameraImageCapture.CaptureDestination: ...
    def isCaptureDestinationSupported(self, destination: QCameraImageCapture.CaptureDestinations | QCameraImageCapture.CaptureDestination) -> bool: ...
    def setCaptureDestination(self, destination: QCameraImageCapture.CaptureDestinations | QCameraImageCapture.CaptureDestination) -> None: ...

class QCameraControl(QMediaControl):
    class PropertyChangeType:
        CaptureMode: typing.ClassVar[QCameraControl.PropertyChangeType] = ...
        ImageEncodingSettings: typing.ClassVar[QCameraControl.PropertyChangeType] = ...
        VideoEncodingSettings: typing.ClassVar[QCameraControl.PropertyChangeType] = ...
        Viewfinder: typing.ClassVar[QCameraControl.PropertyChangeType] = ...
        ViewfinderSettings: typing.ClassVar[QCameraControl.PropertyChangeType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCameraControl.PropertyChangeType: ...
        def __and__(self, other: typing.SupportsInt) -> QCameraControl.PropertyChangeType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCameraControl.PropertyChangeType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCameraControl.PropertyChangeType: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QCameraControl.PropertyChangeType: ...
        def __rand__(self, other: typing.SupportsInt) -> QCameraControl.PropertyChangeType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCameraControl.PropertyChangeType: ...
        def __ror__(self, other: typing.SupportsInt) -> QCameraControl.PropertyChangeType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCameraControl.PropertyChangeType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCameraControl.PropertyChangeType: ...
        def __sub__(self, other: typing.SupportsInt) -> QCameraControl.PropertyChangeType: ...
        def __xor__(self, other: typing.SupportsInt) -> QCameraControl.PropertyChangeType: ...
    CaptureMode: typing.ClassVar[QCameraControl.PropertyChangeType] = ...
    ImageEncodingSettings: typing.ClassVar[QCameraControl.PropertyChangeType] = ...
    VideoEncodingSettings: typing.ClassVar[QCameraControl.PropertyChangeType] = ...
    Viewfinder: typing.ClassVar[QCameraControl.PropertyChangeType] = ...
    ViewfinderSettings: typing.ClassVar[QCameraControl.PropertyChangeType] = ...
    captureModeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    statusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def canChangeProperty(self, changeType: QCameraControl.PropertyChangeType, status: QCamera.Status) -> bool: ...
    def captureMode(self) -> QCamera.CaptureModes | QCamera.CaptureMode: ...
    def isCaptureModeSupported(self, mode: QCamera.CaptureModes | QCamera.CaptureMode) -> bool: ...
    def setCaptureMode(self, arg__1: QCamera.CaptureModes | QCamera.CaptureMode) -> None: ...
    def setState(self, state: QCamera.State) -> None: ...
    def state(self) -> QCamera.State: ...
    def status(self) -> QCamera.Status: ...

class QCameraExposure(PySide2.QtCore.QObject):
    class ExposureMode:
        ExposureAction: typing.ClassVar[QCameraExposure.ExposureMode] = ...
        ExposureAuto: typing.ClassVar[QCameraExposure.ExposureMode] = ...
        ExposureBacklight: typing.ClassVar[QCameraExposure.ExposureMode] = ...
        ExposureBarcode: typing.ClassVar[QCameraExposure.ExposureMode] = ...
        ExposureBeach: typing.ClassVar[QCameraExposure.ExposureMode] = ...
        ExposureCandlelight: typing.ClassVar[QCameraExposure.ExposureMode] = ...
        ExposureFireworks: typing.ClassVar[QCameraExposure.ExposureMode] = ...
        ExposureLandscape: typing.ClassVar[QCameraExposure.ExposureMode] = ...
        ExposureLargeAperture: typing.ClassVar[QCameraExposure.ExposureMode] = ...
        ExposureManual: typing.ClassVar[QCameraExposure.ExposureMode] = ...
        ExposureModeVendor: typing.ClassVar[QCameraExposure.ExposureMode] = ...
        ExposureNight: typing.ClassVar[QCameraExposure.ExposureMode] = ...
        ExposureNightPortrait: typing.ClassVar[QCameraExposure.ExposureMode] = ...
        ExposureParty: typing.ClassVar[QCameraExposure.ExposureMode] = ...
        ExposurePortrait: typing.ClassVar[QCameraExposure.ExposureMode] = ...
        ExposureSmallAperture: typing.ClassVar[QCameraExposure.ExposureMode] = ...
        ExposureSnow: typing.ClassVar[QCameraExposure.ExposureMode] = ...
        ExposureSports: typing.ClassVar[QCameraExposure.ExposureMode] = ...
        ExposureSpotlight: typing.ClassVar[QCameraExposure.ExposureMode] = ...
        ExposureSteadyPhoto: typing.ClassVar[QCameraExposure.ExposureMode] = ...
        ExposureSunset: typing.ClassVar[QCameraExposure.ExposureMode] = ...
        ExposureTheatre: typing.ClassVar[QCameraExposure.ExposureMode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCameraExposure.ExposureMode: ...
        def __and__(self, other: typing.SupportsInt) -> QCameraExposure.ExposureMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCameraExposure.ExposureMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCameraExposure.ExposureMode: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QCameraExposure.ExposureMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QCameraExposure.ExposureMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCameraExposure.ExposureMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QCameraExposure.ExposureMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCameraExposure.ExposureMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCameraExposure.ExposureMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QCameraExposure.ExposureMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QCameraExposure.ExposureMode: ...

    class FlashMode:
        FlashAuto: typing.ClassVar[QCameraExposure.FlashMode] = ...
        FlashFill: typing.ClassVar[QCameraExposure.FlashMode] = ...
        FlashManual: typing.ClassVar[QCameraExposure.FlashMode] = ...
        FlashOff: typing.ClassVar[QCameraExposure.FlashMode] = ...
        FlashOn: typing.ClassVar[QCameraExposure.FlashMode] = ...
        FlashRedEyeReduction: typing.ClassVar[QCameraExposure.FlashMode] = ...
        FlashSlowSyncFrontCurtain: typing.ClassVar[QCameraExposure.FlashMode] = ...
        FlashSlowSyncRearCurtain: typing.ClassVar[QCameraExposure.FlashMode] = ...
        FlashTorch: typing.ClassVar[QCameraExposure.FlashMode] = ...
        FlashVideoLight: typing.ClassVar[QCameraExposure.FlashMode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QCameraExposure.FlashModes: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QCameraExposure.FlashModes: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCameraExposure.FlashModes: ...
        def __rand__(self, other: typing.SupportsInt) -> QCameraExposure.FlashModes: ...
        def __ror__(self, other: typing.SupportsInt) -> QCameraExposure.FlashModes: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCameraExposure.FlashModes: ...
        def __xor__(self, other: typing.SupportsInt) -> QCameraExposure.FlashModes: ...

    class FlashModes:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QCameraExposure.FlashModes: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QCameraExposure.FlashModes: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCameraExposure.FlashModes: ...
        def __rand__(self, other: typing.SupportsInt) -> QCameraExposure.FlashModes: ...
        def __ror__(self, other: typing.SupportsInt) -> QCameraExposure.FlashModes: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCameraExposure.FlashModes: ...
        def __xor__(self, other: typing.SupportsInt) -> QCameraExposure.FlashModes: ...

    class MeteringMode:
        MeteringAverage: typing.ClassVar[QCameraExposure.MeteringMode] = ...
        MeteringMatrix: typing.ClassVar[QCameraExposure.MeteringMode] = ...
        MeteringSpot: typing.ClassVar[QCameraExposure.MeteringMode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCameraExposure.MeteringMode: ...
        def __and__(self, other: typing.SupportsInt) -> QCameraExposure.MeteringMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCameraExposure.MeteringMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCameraExposure.MeteringMode: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QCameraExposure.MeteringMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QCameraExposure.MeteringMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCameraExposure.MeteringMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QCameraExposure.MeteringMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCameraExposure.MeteringMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCameraExposure.MeteringMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QCameraExposure.MeteringMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QCameraExposure.MeteringMode: ...
    ExposureAction: typing.ClassVar[QCameraExposure.ExposureMode] = ...
    ExposureAuto: typing.ClassVar[QCameraExposure.ExposureMode] = ...
    ExposureBacklight: typing.ClassVar[QCameraExposure.ExposureMode] = ...
    ExposureBarcode: typing.ClassVar[QCameraExposure.ExposureMode] = ...
    ExposureBeach: typing.ClassVar[QCameraExposure.ExposureMode] = ...
    ExposureCandlelight: typing.ClassVar[QCameraExposure.ExposureMode] = ...
    ExposureFireworks: typing.ClassVar[QCameraExposure.ExposureMode] = ...
    ExposureLandscape: typing.ClassVar[QCameraExposure.ExposureMode] = ...
    ExposureLargeAperture: typing.ClassVar[QCameraExposure.ExposureMode] = ...
    ExposureManual: typing.ClassVar[QCameraExposure.ExposureMode] = ...
    ExposureModeVendor: typing.ClassVar[QCameraExposure.ExposureMode] = ...
    ExposureNight: typing.ClassVar[QCameraExposure.ExposureMode] = ...
    ExposureNightPortrait: typing.ClassVar[QCameraExposure.ExposureMode] = ...
    ExposureParty: typing.ClassVar[QCameraExposure.ExposureMode] = ...
    ExposurePortrait: typing.ClassVar[QCameraExposure.ExposureMode] = ...
    ExposureSmallAperture: typing.ClassVar[QCameraExposure.ExposureMode] = ...
    ExposureSnow: typing.ClassVar[QCameraExposure.ExposureMode] = ...
    ExposureSports: typing.ClassVar[QCameraExposure.ExposureMode] = ...
    ExposureSpotlight: typing.ClassVar[QCameraExposure.ExposureMode] = ...
    ExposureSteadyPhoto: typing.ClassVar[QCameraExposure.ExposureMode] = ...
    ExposureSunset: typing.ClassVar[QCameraExposure.ExposureMode] = ...
    ExposureTheatre: typing.ClassVar[QCameraExposure.ExposureMode] = ...
    FlashAuto: typing.ClassVar[QCameraExposure.FlashMode] = ...
    FlashFill: typing.ClassVar[QCameraExposure.FlashMode] = ...
    FlashManual: typing.ClassVar[QCameraExposure.FlashMode] = ...
    FlashOff: typing.ClassVar[QCameraExposure.FlashMode] = ...
    FlashOn: typing.ClassVar[QCameraExposure.FlashMode] = ...
    FlashRedEyeReduction: typing.ClassVar[QCameraExposure.FlashMode] = ...
    FlashSlowSyncFrontCurtain: typing.ClassVar[QCameraExposure.FlashMode] = ...
    FlashSlowSyncRearCurtain: typing.ClassVar[QCameraExposure.FlashMode] = ...
    FlashTorch: typing.ClassVar[QCameraExposure.FlashMode] = ...
    FlashVideoLight: typing.ClassVar[QCameraExposure.FlashMode] = ...
    MeteringAverage: typing.ClassVar[QCameraExposure.MeteringMode] = ...
    MeteringMatrix: typing.ClassVar[QCameraExposure.MeteringMode] = ...
    MeteringSpot: typing.ClassVar[QCameraExposure.MeteringMode] = ...
    apertureChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    apertureRangeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    exposureCompensationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    flashReady: typing.ClassVar[PySide2.QtCore.Signal] = ...
    isoSensitivityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    shutterSpeedChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    shutterSpeedRangeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, aperture: float = ..., apertureChanged: typing.Callable = ..., apertureRangeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., exposureCompensation: float = ..., exposureCompensationChanged: typing.Callable = ..., exposureMode: typing.Any = ..., flashMode: QCameraExposure.FlashModes | QCameraExposure.FlashMode = ..., flashReady: typing.Callable = ..., isoSensitivity: int = ..., isoSensitivityChanged: typing.Callable = ..., meteringMode: typing.Any = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., shutterSpeed: float = ..., shutterSpeedChanged: typing.Callable = ..., shutterSpeedRangeChanged: typing.Callable = ..., **kwargs) -> None: ...
    def aperture(self) -> float: ...
    def exposureCompensation(self) -> float: ...
    def exposureMode(self) -> QCameraExposure.ExposureMode: ...
    def flashMode(self) -> QCameraExposure.FlashModes | QCameraExposure.FlashMode: ...
    def isAvailable(self) -> bool: ...
    def isExposureModeSupported(self, mode: QCameraExposure.ExposureMode) -> bool: ...
    def isFlashModeSupported(self, mode: QCameraExposure.FlashModes | QCameraExposure.FlashMode) -> bool: ...
    def isFlashReady(self) -> bool: ...
    def isMeteringModeSupported(self, mode: QCameraExposure.MeteringMode) -> bool: ...
    def isoSensitivity(self) -> int: ...
    def meteringMode(self) -> QCameraExposure.MeteringMode: ...
    def requestedAperture(self) -> float: ...
    def requestedIsoSensitivity(self) -> int: ...
    def requestedShutterSpeed(self) -> float: ...
    def setAutoAperture(self) -> None: ...
    def setAutoIsoSensitivity(self) -> None: ...
    def setAutoShutterSpeed(self) -> None: ...
    def setExposureCompensation(self, ev: float) -> None: ...
    def setExposureMode(self, mode: QCameraExposure.ExposureMode) -> None: ...
    def setFlashMode(self, mode: QCameraExposure.FlashModes | QCameraExposure.FlashMode) -> None: ...
    def setManualAperture(self, aperture: float) -> None: ...
    def setManualIsoSensitivity(self, iso: int) -> None: ...
    def setManualShutterSpeed(self, seconds: float) -> None: ...
    def setMeteringMode(self, mode: QCameraExposure.MeteringMode) -> None: ...
    def setSpotMeteringPoint(self, point: PySide2.QtCore.QPointF) -> None: ...
    def shutterSpeed(self) -> float: ...
    def spotMeteringPoint(self) -> PySide2.QtCore.QPointF: ...

class QCameraExposureControl(QMediaControl):
    class ExposureParameter:
        Aperture: typing.ClassVar[QCameraExposureControl.ExposureParameter] = ...
        ExposureCompensation: typing.ClassVar[QCameraExposureControl.ExposureParameter] = ...
        ExposureMode: typing.ClassVar[QCameraExposureControl.ExposureParameter] = ...
        ExtendedExposureParameter: typing.ClassVar[QCameraExposureControl.ExposureParameter] = ...
        FlashCompensation: typing.ClassVar[QCameraExposureControl.ExposureParameter] = ...
        FlashPower: typing.ClassVar[QCameraExposureControl.ExposureParameter] = ...
        ISO: typing.ClassVar[QCameraExposureControl.ExposureParameter] = ...
        MeteringMode: typing.ClassVar[QCameraExposureControl.ExposureParameter] = ...
        ShutterSpeed: typing.ClassVar[QCameraExposureControl.ExposureParameter] = ...
        SpotMeteringPoint: typing.ClassVar[QCameraExposureControl.ExposureParameter] = ...
        TorchPower: typing.ClassVar[QCameraExposureControl.ExposureParameter] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCameraExposureControl.ExposureParameter: ...
        def __and__(self, other: typing.SupportsInt) -> QCameraExposureControl.ExposureParameter: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCameraExposureControl.ExposureParameter: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCameraExposureControl.ExposureParameter: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QCameraExposureControl.ExposureParameter: ...
        def __rand__(self, other: typing.SupportsInt) -> QCameraExposureControl.ExposureParameter: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCameraExposureControl.ExposureParameter: ...
        def __ror__(self, other: typing.SupportsInt) -> QCameraExposureControl.ExposureParameter: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCameraExposureControl.ExposureParameter: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCameraExposureControl.ExposureParameter: ...
        def __sub__(self, other: typing.SupportsInt) -> QCameraExposureControl.ExposureParameter: ...
        def __xor__(self, other: typing.SupportsInt) -> QCameraExposureControl.ExposureParameter: ...
    Aperture: typing.ClassVar[QCameraExposureControl.ExposureParameter] = ...
    ExposureCompensation: typing.ClassVar[QCameraExposureControl.ExposureParameter] = ...
    ExposureMode: typing.ClassVar[QCameraExposureControl.ExposureParameter] = ...
    ExtendedExposureParameter: typing.ClassVar[QCameraExposureControl.ExposureParameter] = ...
    FlashCompensation: typing.ClassVar[QCameraExposureControl.ExposureParameter] = ...
    FlashPower: typing.ClassVar[QCameraExposureControl.ExposureParameter] = ...
    ISO: typing.ClassVar[QCameraExposureControl.ExposureParameter] = ...
    MeteringMode: typing.ClassVar[QCameraExposureControl.ExposureParameter] = ...
    ShutterSpeed: typing.ClassVar[QCameraExposureControl.ExposureParameter] = ...
    SpotMeteringPoint: typing.ClassVar[QCameraExposureControl.ExposureParameter] = ...
    TorchPower: typing.ClassVar[QCameraExposureControl.ExposureParameter] = ...
    actualValueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    parameterRangeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    requestedValueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def actualValue(self, parameter: QCameraExposureControl.ExposureParameter) -> typing.Any: ...
    def isParameterSupported(self, parameter: QCameraExposureControl.ExposureParameter) -> bool: ...
    def requestedValue(self, parameter: QCameraExposureControl.ExposureParameter) -> typing.Any: ...
    def setValue(self, parameter: QCameraExposureControl.ExposureParameter, value: typing.Any) -> bool: ...

class QCameraFeedbackControl(QMediaControl):
    class EventType:
        AutoFocusFailed: typing.ClassVar[QCameraFeedbackControl.EventType] = ...
        AutoFocusInProgress: typing.ClassVar[QCameraFeedbackControl.EventType] = ...
        AutoFocusLocked: typing.ClassVar[QCameraFeedbackControl.EventType] = ...
        ImageCaptured: typing.ClassVar[QCameraFeedbackControl.EventType] = ...
        ImageError: typing.ClassVar[QCameraFeedbackControl.EventType] = ...
        ImageSaved: typing.ClassVar[QCameraFeedbackControl.EventType] = ...
        RecordingInProgress: typing.ClassVar[QCameraFeedbackControl.EventType] = ...
        RecordingStarted: typing.ClassVar[QCameraFeedbackControl.EventType] = ...
        RecordingStopped: typing.ClassVar[QCameraFeedbackControl.EventType] = ...
        ViewfinderStarted: typing.ClassVar[QCameraFeedbackControl.EventType] = ...
        ViewfinderStopped: typing.ClassVar[QCameraFeedbackControl.EventType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCameraFeedbackControl.EventType: ...
        def __and__(self, other: typing.SupportsInt) -> QCameraFeedbackControl.EventType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCameraFeedbackControl.EventType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCameraFeedbackControl.EventType: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QCameraFeedbackControl.EventType: ...
        def __rand__(self, other: typing.SupportsInt) -> QCameraFeedbackControl.EventType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCameraFeedbackControl.EventType: ...
        def __ror__(self, other: typing.SupportsInt) -> QCameraFeedbackControl.EventType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCameraFeedbackControl.EventType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCameraFeedbackControl.EventType: ...
        def __sub__(self, other: typing.SupportsInt) -> QCameraFeedbackControl.EventType: ...
        def __xor__(self, other: typing.SupportsInt) -> QCameraFeedbackControl.EventType: ...
    AutoFocusFailed: typing.ClassVar[QCameraFeedbackControl.EventType] = ...
    AutoFocusInProgress: typing.ClassVar[QCameraFeedbackControl.EventType] = ...
    AutoFocusLocked: typing.ClassVar[QCameraFeedbackControl.EventType] = ...
    ImageCaptured: typing.ClassVar[QCameraFeedbackControl.EventType] = ...
    ImageError: typing.ClassVar[QCameraFeedbackControl.EventType] = ...
    ImageSaved: typing.ClassVar[QCameraFeedbackControl.EventType] = ...
    RecordingInProgress: typing.ClassVar[QCameraFeedbackControl.EventType] = ...
    RecordingStarted: typing.ClassVar[QCameraFeedbackControl.EventType] = ...
    RecordingStopped: typing.ClassVar[QCameraFeedbackControl.EventType] = ...
    ViewfinderStarted: typing.ClassVar[QCameraFeedbackControl.EventType] = ...
    ViewfinderStopped: typing.ClassVar[QCameraFeedbackControl.EventType] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def isEventFeedbackEnabled(self, arg__1: QCameraFeedbackControl.EventType) -> bool: ...
    def isEventFeedbackLocked(self, arg__1: QCameraFeedbackControl.EventType) -> bool: ...
    def resetEventFeedback(self, arg__1: QCameraFeedbackControl.EventType) -> None: ...
    def setEventFeedbackEnabled(self, arg__1: QCameraFeedbackControl.EventType, arg__2: bool) -> bool: ...
    def setEventFeedbackSound(self, arg__1: QCameraFeedbackControl.EventType, filePath: str) -> bool: ...

class QCameraFlashControl(QMediaControl):
    flashReady: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def flashMode(self) -> QCameraExposure.FlashModes | QCameraExposure.FlashMode: ...
    def isFlashModeSupported(self, mode: QCameraExposure.FlashModes | QCameraExposure.FlashMode) -> bool: ...
    def isFlashReady(self) -> bool: ...
    def setFlashMode(self, mode: QCameraExposure.FlashModes | QCameraExposure.FlashMode) -> None: ...

class QCameraFocus(PySide2.QtCore.QObject):
    class FocusMode:
        AutoFocus: typing.ClassVar[QCameraFocus.FocusMode] = ...
        ContinuousFocus: typing.ClassVar[QCameraFocus.FocusMode] = ...
        HyperfocalFocus: typing.ClassVar[QCameraFocus.FocusMode] = ...
        InfinityFocus: typing.ClassVar[QCameraFocus.FocusMode] = ...
        MacroFocus: typing.ClassVar[QCameraFocus.FocusMode] = ...
        ManualFocus: typing.ClassVar[QCameraFocus.FocusMode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QCameraFocus.FocusModes: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QCameraFocus.FocusModes: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCameraFocus.FocusModes: ...
        def __rand__(self, other: typing.SupportsInt) -> QCameraFocus.FocusModes: ...
        def __ror__(self, other: typing.SupportsInt) -> QCameraFocus.FocusModes: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCameraFocus.FocusModes: ...
        def __xor__(self, other: typing.SupportsInt) -> QCameraFocus.FocusModes: ...

    class FocusModes:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QCameraFocus.FocusModes: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QCameraFocus.FocusModes: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCameraFocus.FocusModes: ...
        def __rand__(self, other: typing.SupportsInt) -> QCameraFocus.FocusModes: ...
        def __ror__(self, other: typing.SupportsInt) -> QCameraFocus.FocusModes: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCameraFocus.FocusModes: ...
        def __xor__(self, other: typing.SupportsInt) -> QCameraFocus.FocusModes: ...

    class FocusPointMode:
        FocusPointAuto: typing.ClassVar[QCameraFocus.FocusPointMode] = ...
        FocusPointCenter: typing.ClassVar[QCameraFocus.FocusPointMode] = ...
        FocusPointCustom: typing.ClassVar[QCameraFocus.FocusPointMode] = ...
        FocusPointFaceDetection: typing.ClassVar[QCameraFocus.FocusPointMode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCameraFocus.FocusPointMode: ...
        def __and__(self, other: typing.SupportsInt) -> QCameraFocus.FocusPointMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCameraFocus.FocusPointMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCameraFocus.FocusPointMode: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QCameraFocus.FocusPointMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QCameraFocus.FocusPointMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCameraFocus.FocusPointMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QCameraFocus.FocusPointMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCameraFocus.FocusPointMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCameraFocus.FocusPointMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QCameraFocus.FocusPointMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QCameraFocus.FocusPointMode: ...
    AutoFocus: typing.ClassVar[QCameraFocus.FocusMode] = ...
    ContinuousFocus: typing.ClassVar[QCameraFocus.FocusMode] = ...
    FocusPointAuto: typing.ClassVar[QCameraFocus.FocusPointMode] = ...
    FocusPointCenter: typing.ClassVar[QCameraFocus.FocusPointMode] = ...
    FocusPointCustom: typing.ClassVar[QCameraFocus.FocusPointMode] = ...
    FocusPointFaceDetection: typing.ClassVar[QCameraFocus.FocusPointMode] = ...
    HyperfocalFocus: typing.ClassVar[QCameraFocus.FocusMode] = ...
    InfinityFocus: typing.ClassVar[QCameraFocus.FocusMode] = ...
    MacroFocus: typing.ClassVar[QCameraFocus.FocusMode] = ...
    ManualFocus: typing.ClassVar[QCameraFocus.FocusMode] = ...
    digitalZoomChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    focusZonesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    maximumDigitalZoomChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    maximumOpticalZoomChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    opticalZoomChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, customFocusPoint: PySide2.QtCore.QPointF = ..., destroyed: typing.Callable = ..., digitalZoom: float = ..., digitalZoomChanged: typing.Callable = ..., focusMode: QCameraFocus.FocusModes | QCameraFocus.FocusMode = ..., focusPointMode: QCameraFocus.FocusPointMode = ..., focusZones: typing.List[QCameraFocusZone] = ..., focusZonesChanged: typing.Callable = ..., maximumDigitalZoomChanged: typing.Callable = ..., maximumOpticalZoomChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opticalZoom: float = ..., opticalZoomChanged: typing.Callable = ..., **kwargs) -> None: ...
    def customFocusPoint(self) -> PySide2.QtCore.QPointF: ...
    def digitalZoom(self) -> float: ...
    def focusMode(self) -> QCameraFocus.FocusModes | QCameraFocus.FocusMode: ...
    def focusPointMode(self) -> QCameraFocus.FocusPointMode: ...
    def focusZones(self) -> typing.List[QCameraFocusZone]: ...
    def isAvailable(self) -> bool: ...
    def isFocusModeSupported(self, mode: QCameraFocus.FocusModes | QCameraFocus.FocusMode) -> bool: ...
    def isFocusPointModeSupported(self, arg__1: QCameraFocus.FocusPointMode) -> bool: ...
    def maximumDigitalZoom(self) -> float: ...
    def maximumOpticalZoom(self) -> float: ...
    def opticalZoom(self) -> float: ...
    def setCustomFocusPoint(self, point: PySide2.QtCore.QPointF) -> None: ...
    def setFocusMode(self, mode: QCameraFocus.FocusModes | QCameraFocus.FocusMode) -> None: ...
    def setFocusPointMode(self, mode: QCameraFocus.FocusPointMode) -> None: ...
    def zoomTo(self, opticalZoom: float, digitalZoom: float) -> None: ...

class QCameraFocusControl(QMediaControl):
    customFocusPointChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    focusModeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    focusPointModeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    focusZonesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def customFocusPoint(self) -> PySide2.QtCore.QPointF: ...
    def focusMode(self) -> QCameraFocus.FocusModes | QCameraFocus.FocusMode: ...
    def focusPointMode(self) -> QCameraFocus.FocusPointMode: ...
    def focusZones(self) -> typing.List[QCameraFocusZone]: ...
    def isFocusModeSupported(self, mode: QCameraFocus.FocusModes | QCameraFocus.FocusMode) -> bool: ...
    def isFocusPointModeSupported(self, mode: QCameraFocus.FocusPointMode) -> bool: ...
    def setCustomFocusPoint(self, point: PySide2.QtCore.QPointF) -> None: ...
    def setFocusMode(self, mode: QCameraFocus.FocusModes | QCameraFocus.FocusMode) -> None: ...
    def setFocusPointMode(self, mode: QCameraFocus.FocusPointMode) -> None: ...

class QCameraFocusZone(shiboken2.Object):
    class FocusZoneStatus:
        Focused: typing.ClassVar[QCameraFocusZone.FocusZoneStatus] = ...
        Invalid: typing.ClassVar[QCameraFocusZone.FocusZoneStatus] = ...
        Selected: typing.ClassVar[QCameraFocusZone.FocusZoneStatus] = ...
        Unused: typing.ClassVar[QCameraFocusZone.FocusZoneStatus] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCameraFocusZone.FocusZoneStatus: ...
        def __and__(self, other: typing.SupportsInt) -> QCameraFocusZone.FocusZoneStatus: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCameraFocusZone.FocusZoneStatus: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCameraFocusZone.FocusZoneStatus: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QCameraFocusZone.FocusZoneStatus: ...
        def __rand__(self, other: typing.SupportsInt) -> QCameraFocusZone.FocusZoneStatus: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCameraFocusZone.FocusZoneStatus: ...
        def __ror__(self, other: typing.SupportsInt) -> QCameraFocusZone.FocusZoneStatus: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCameraFocusZone.FocusZoneStatus: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCameraFocusZone.FocusZoneStatus: ...
        def __sub__(self, other: typing.SupportsInt) -> QCameraFocusZone.FocusZoneStatus: ...
        def __xor__(self, other: typing.SupportsInt) -> QCameraFocusZone.FocusZoneStatus: ...
    Focused: typing.ClassVar[QCameraFocusZone.FocusZoneStatus] = ...
    Invalid: typing.ClassVar[QCameraFocusZone.FocusZoneStatus] = ...
    Selected: typing.ClassVar[QCameraFocusZone.FocusZoneStatus] = ...
    Unused: typing.ClassVar[QCameraFocusZone.FocusZoneStatus] = ...
    @typing.overload
    def __init__(self, area: PySide2.QtCore.QRectF, status: QCameraFocusZone.FocusZoneStatus = ...) -> None: ...
    @typing.overload
    def __init__(self, other: QCameraFocusZone) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def area(self) -> PySide2.QtCore.QRectF: ...
    def isValid(self) -> bool: ...
    def setStatus(self, status: QCameraFocusZone.FocusZoneStatus) -> None: ...
    def status(self) -> QCameraFocusZone.FocusZoneStatus: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QCameraImageCapture(PySide2.QtCore.QObject, QMediaBindableInterface):
    class CaptureDestination:
        CaptureToBuffer: typing.ClassVar[QCameraImageCapture.CaptureDestination] = ...
        CaptureToFile: typing.ClassVar[QCameraImageCapture.CaptureDestination] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QCameraImageCapture.CaptureDestinations: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QCameraImageCapture.CaptureDestinations: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCameraImageCapture.CaptureDestinations: ...
        def __rand__(self, other: typing.SupportsInt) -> QCameraImageCapture.CaptureDestinations: ...
        def __ror__(self, other: typing.SupportsInt) -> QCameraImageCapture.CaptureDestinations: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCameraImageCapture.CaptureDestinations: ...
        def __xor__(self, other: typing.SupportsInt) -> QCameraImageCapture.CaptureDestinations: ...

    class CaptureDestinations:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QCameraImageCapture.CaptureDestinations: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QCameraImageCapture.CaptureDestinations: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCameraImageCapture.CaptureDestinations: ...
        def __rand__(self, other: typing.SupportsInt) -> QCameraImageCapture.CaptureDestinations: ...
        def __ror__(self, other: typing.SupportsInt) -> QCameraImageCapture.CaptureDestinations: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCameraImageCapture.CaptureDestinations: ...
        def __xor__(self, other: typing.SupportsInt) -> QCameraImageCapture.CaptureDestinations: ...

    class DriveMode:
        SingleImageCapture: typing.ClassVar[QCameraImageCapture.DriveMode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCameraImageCapture.DriveMode: ...
        def __and__(self, other: typing.SupportsInt) -> QCameraImageCapture.DriveMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCameraImageCapture.DriveMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCameraImageCapture.DriveMode: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QCameraImageCapture.DriveMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QCameraImageCapture.DriveMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCameraImageCapture.DriveMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QCameraImageCapture.DriveMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCameraImageCapture.DriveMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCameraImageCapture.DriveMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QCameraImageCapture.DriveMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QCameraImageCapture.DriveMode: ...

    class Error:
        FormatError: typing.ClassVar[QCameraImageCapture.Error] = ...
        NoError: typing.ClassVar[QCameraImageCapture.Error] = ...
        NotReadyError: typing.ClassVar[QCameraImageCapture.Error] = ...
        NotSupportedFeatureError: typing.ClassVar[QCameraImageCapture.Error] = ...
        OutOfSpaceError: typing.ClassVar[QCameraImageCapture.Error] = ...
        ResourceError: typing.ClassVar[QCameraImageCapture.Error] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCameraImageCapture.Error: ...
        def __and__(self, other: typing.SupportsInt) -> QCameraImageCapture.Error: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCameraImageCapture.Error: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCameraImageCapture.Error: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QCameraImageCapture.Error: ...
        def __rand__(self, other: typing.SupportsInt) -> QCameraImageCapture.Error: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCameraImageCapture.Error: ...
        def __ror__(self, other: typing.SupportsInt) -> QCameraImageCapture.Error: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCameraImageCapture.Error: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCameraImageCapture.Error: ...
        def __sub__(self, other: typing.SupportsInt) -> QCameraImageCapture.Error: ...
        def __xor__(self, other: typing.SupportsInt) -> QCameraImageCapture.Error: ...
    CaptureToBuffer: typing.ClassVar[QCameraImageCapture.CaptureDestination] = ...
    CaptureToFile: typing.ClassVar[QCameraImageCapture.CaptureDestination] = ...
    FormatError: typing.ClassVar[QCameraImageCapture.Error] = ...
    NoError: typing.ClassVar[QCameraImageCapture.Error] = ...
    NotReadyError: typing.ClassVar[QCameraImageCapture.Error] = ...
    NotSupportedFeatureError: typing.ClassVar[QCameraImageCapture.Error] = ...
    OutOfSpaceError: typing.ClassVar[QCameraImageCapture.Error] = ...
    ResourceError: typing.ClassVar[QCameraImageCapture.Error] = ...
    SingleImageCapture: typing.ClassVar[QCameraImageCapture.DriveMode] = ...
    bufferFormatChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    captureDestinationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    imageAvailable: typing.ClassVar[PySide2.QtCore.Signal] = ...
    imageCaptured: typing.ClassVar[PySide2.QtCore.Signal] = ...
    imageExposed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    imageMetadataAvailable: typing.ClassVar[PySide2.QtCore.Signal] = ...
    imageSaved: typing.ClassVar[PySide2.QtCore.Signal] = ...
    readyForCaptureChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, mediaObject: QMediaObject, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def availability(self) -> QMultimedia.AvailabilityStatus: ...
    def bufferFormat(self) -> QVideoFrame.PixelFormat: ...
    def cancelCapture(self) -> None: ...
    def capture(self, location: str = ...) -> int: ...
    def captureDestination(self) -> QCameraImageCapture.CaptureDestinations | QCameraImageCapture.CaptureDestination: ...
    def encodingSettings(self) -> QImageEncoderSettings: ...
    def errorString(self) -> str: ...
    def imageCodecDescription(self, codecName: str) -> str: ...
    def isAvailable(self) -> bool: ...
    def isCaptureDestinationSupported(self, destination: QCameraImageCapture.CaptureDestinations | QCameraImageCapture.CaptureDestination) -> bool: ...
    def isReadyForCapture(self) -> bool: ...
    def mediaObject(self) -> QMediaObject: ...
    def setBufferFormat(self, format: QVideoFrame.PixelFormat) -> None: ...
    def setCaptureDestination(self, destination: QCameraImageCapture.CaptureDestinations | QCameraImageCapture.CaptureDestination) -> None: ...
    def setEncodingSettings(self, settings: QImageEncoderSettings) -> None: ...
    def setMediaObject(self, arg__1: QMediaObject) -> bool: ...
    def supportedBufferFormats(self) -> typing.List[QVideoFrame.PixelFormat]: ...
    def supportedImageCodecs(self) -> typing.List[str]: ...

class QCameraImageCaptureControl(QMediaControl):
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    imageAvailable: typing.ClassVar[PySide2.QtCore.Signal] = ...
    imageCaptured: typing.ClassVar[PySide2.QtCore.Signal] = ...
    imageExposed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    imageMetadataAvailable: typing.ClassVar[PySide2.QtCore.Signal] = ...
    imageSaved: typing.ClassVar[PySide2.QtCore.Signal] = ...
    readyForCaptureChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def cancelCapture(self) -> None: ...
    def capture(self, fileName: str) -> int: ...
    def driveMode(self) -> QCameraImageCapture.DriveMode: ...
    def isReadyForCapture(self) -> bool: ...
    def setDriveMode(self, mode: QCameraImageCapture.DriveMode) -> None: ...

class QCameraImageProcessing(PySide2.QtCore.QObject):
    class ColorFilter:
        ColorFilterAqua: typing.ClassVar[QCameraImageProcessing.ColorFilter] = ...
        ColorFilterBlackboard: typing.ClassVar[QCameraImageProcessing.ColorFilter] = ...
        ColorFilterGrayscale: typing.ClassVar[QCameraImageProcessing.ColorFilter] = ...
        ColorFilterNegative: typing.ClassVar[QCameraImageProcessing.ColorFilter] = ...
        ColorFilterNone: typing.ClassVar[QCameraImageProcessing.ColorFilter] = ...
        ColorFilterPosterize: typing.ClassVar[QCameraImageProcessing.ColorFilter] = ...
        ColorFilterSepia: typing.ClassVar[QCameraImageProcessing.ColorFilter] = ...
        ColorFilterSolarize: typing.ClassVar[QCameraImageProcessing.ColorFilter] = ...
        ColorFilterVendor: typing.ClassVar[QCameraImageProcessing.ColorFilter] = ...
        ColorFilterWhiteboard: typing.ClassVar[QCameraImageProcessing.ColorFilter] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCameraImageProcessing.ColorFilter: ...
        def __and__(self, other: typing.SupportsInt) -> QCameraImageProcessing.ColorFilter: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCameraImageProcessing.ColorFilter: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCameraImageProcessing.ColorFilter: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QCameraImageProcessing.ColorFilter: ...
        def __rand__(self, other: typing.SupportsInt) -> QCameraImageProcessing.ColorFilter: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCameraImageProcessing.ColorFilter: ...
        def __ror__(self, other: typing.SupportsInt) -> QCameraImageProcessing.ColorFilter: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCameraImageProcessing.ColorFilter: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCameraImageProcessing.ColorFilter: ...
        def __sub__(self, other: typing.SupportsInt) -> QCameraImageProcessing.ColorFilter: ...
        def __xor__(self, other: typing.SupportsInt) -> QCameraImageProcessing.ColorFilter: ...

    class WhiteBalanceMode:
        WhiteBalanceAuto: typing.ClassVar[QCameraImageProcessing.WhiteBalanceMode] = ...
        WhiteBalanceCloudy: typing.ClassVar[QCameraImageProcessing.WhiteBalanceMode] = ...
        WhiteBalanceFlash: typing.ClassVar[QCameraImageProcessing.WhiteBalanceMode] = ...
        WhiteBalanceFluorescent: typing.ClassVar[QCameraImageProcessing.WhiteBalanceMode] = ...
        WhiteBalanceManual: typing.ClassVar[QCameraImageProcessing.WhiteBalanceMode] = ...
        WhiteBalanceShade: typing.ClassVar[QCameraImageProcessing.WhiteBalanceMode] = ...
        WhiteBalanceSunlight: typing.ClassVar[QCameraImageProcessing.WhiteBalanceMode] = ...
        WhiteBalanceSunset: typing.ClassVar[QCameraImageProcessing.WhiteBalanceMode] = ...
        WhiteBalanceTungsten: typing.ClassVar[QCameraImageProcessing.WhiteBalanceMode] = ...
        WhiteBalanceVendor: typing.ClassVar[QCameraImageProcessing.WhiteBalanceMode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCameraImageProcessing.WhiteBalanceMode: ...
        def __and__(self, other: typing.SupportsInt) -> QCameraImageProcessing.WhiteBalanceMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCameraImageProcessing.WhiteBalanceMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCameraImageProcessing.WhiteBalanceMode: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QCameraImageProcessing.WhiteBalanceMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QCameraImageProcessing.WhiteBalanceMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCameraImageProcessing.WhiteBalanceMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QCameraImageProcessing.WhiteBalanceMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCameraImageProcessing.WhiteBalanceMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCameraImageProcessing.WhiteBalanceMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QCameraImageProcessing.WhiteBalanceMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QCameraImageProcessing.WhiteBalanceMode: ...
    ColorFilterAqua: typing.ClassVar[QCameraImageProcessing.ColorFilter] = ...
    ColorFilterBlackboard: typing.ClassVar[QCameraImageProcessing.ColorFilter] = ...
    ColorFilterGrayscale: typing.ClassVar[QCameraImageProcessing.ColorFilter] = ...
    ColorFilterNegative: typing.ClassVar[QCameraImageProcessing.ColorFilter] = ...
    ColorFilterNone: typing.ClassVar[QCameraImageProcessing.ColorFilter] = ...
    ColorFilterPosterize: typing.ClassVar[QCameraImageProcessing.ColorFilter] = ...
    ColorFilterSepia: typing.ClassVar[QCameraImageProcessing.ColorFilter] = ...
    ColorFilterSolarize: typing.ClassVar[QCameraImageProcessing.ColorFilter] = ...
    ColorFilterVendor: typing.ClassVar[QCameraImageProcessing.ColorFilter] = ...
    ColorFilterWhiteboard: typing.ClassVar[QCameraImageProcessing.ColorFilter] = ...
    WhiteBalanceAuto: typing.ClassVar[QCameraImageProcessing.WhiteBalanceMode] = ...
    WhiteBalanceCloudy: typing.ClassVar[QCameraImageProcessing.WhiteBalanceMode] = ...
    WhiteBalanceFlash: typing.ClassVar[QCameraImageProcessing.WhiteBalanceMode] = ...
    WhiteBalanceFluorescent: typing.ClassVar[QCameraImageProcessing.WhiteBalanceMode] = ...
    WhiteBalanceManual: typing.ClassVar[QCameraImageProcessing.WhiteBalanceMode] = ...
    WhiteBalanceShade: typing.ClassVar[QCameraImageProcessing.WhiteBalanceMode] = ...
    WhiteBalanceSunlight: typing.ClassVar[QCameraImageProcessing.WhiteBalanceMode] = ...
    WhiteBalanceSunset: typing.ClassVar[QCameraImageProcessing.WhiteBalanceMode] = ...
    WhiteBalanceTungsten: typing.ClassVar[QCameraImageProcessing.WhiteBalanceMode] = ...
    WhiteBalanceVendor: typing.ClassVar[QCameraImageProcessing.WhiteBalanceMode] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., **kwargs) -> None: ...
    def brightness(self) -> float: ...
    def colorFilter(self) -> QCameraImageProcessing.ColorFilter: ...
    def contrast(self) -> float: ...
    def denoisingLevel(self) -> float: ...
    def isAvailable(self) -> bool: ...
    def isColorFilterSupported(self, filter: QCameraImageProcessing.ColorFilter) -> bool: ...
    def isWhiteBalanceModeSupported(self, mode: QCameraImageProcessing.WhiteBalanceMode) -> bool: ...
    def manualWhiteBalance(self) -> float: ...
    def saturation(self) -> float: ...
    def setBrightness(self, value: float) -> None: ...
    def setColorFilter(self, filter: QCameraImageProcessing.ColorFilter) -> None: ...
    def setContrast(self, value: float) -> None: ...
    def setDenoisingLevel(self, value: float) -> None: ...
    def setManualWhiteBalance(self, colorTemperature: float) -> None: ...
    def setSaturation(self, value: float) -> None: ...
    def setSharpeningLevel(self, value: float) -> None: ...
    def setWhiteBalanceMode(self, mode: QCameraImageProcessing.WhiteBalanceMode) -> None: ...
    def sharpeningLevel(self) -> float: ...
    def whiteBalanceMode(self) -> QCameraImageProcessing.WhiteBalanceMode: ...

class QCameraImageProcessingControl(QMediaControl):
    class ProcessingParameter:
        Brightness: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
        BrightnessAdjustment: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
        ColorFilter: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
        ColorTemperature: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
        Contrast: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
        ContrastAdjustment: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
        Denoising: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
        DenoisingAdjustment: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
        ExtendedParameter: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
        Saturation: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
        SaturationAdjustment: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
        Sharpening: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
        SharpeningAdjustment: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
        WhiteBalancePreset: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCameraImageProcessingControl.ProcessingParameter: ...
        def __and__(self, other: typing.SupportsInt) -> QCameraImageProcessingControl.ProcessingParameter: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCameraImageProcessingControl.ProcessingParameter: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCameraImageProcessingControl.ProcessingParameter: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QCameraImageProcessingControl.ProcessingParameter: ...
        def __rand__(self, other: typing.SupportsInt) -> QCameraImageProcessingControl.ProcessingParameter: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCameraImageProcessingControl.ProcessingParameter: ...
        def __ror__(self, other: typing.SupportsInt) -> QCameraImageProcessingControl.ProcessingParameter: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCameraImageProcessingControl.ProcessingParameter: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCameraImageProcessingControl.ProcessingParameter: ...
        def __sub__(self, other: typing.SupportsInt) -> QCameraImageProcessingControl.ProcessingParameter: ...
        def __xor__(self, other: typing.SupportsInt) -> QCameraImageProcessingControl.ProcessingParameter: ...
    Brightness: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
    BrightnessAdjustment: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
    ColorFilter: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
    ColorTemperature: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
    Contrast: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
    ContrastAdjustment: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
    Denoising: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
    DenoisingAdjustment: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
    ExtendedParameter: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
    Saturation: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
    SaturationAdjustment: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
    Sharpening: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
    SharpeningAdjustment: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
    WhiteBalancePreset: typing.ClassVar[QCameraImageProcessingControl.ProcessingParameter] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def isParameterSupported(self, arg__1: QCameraImageProcessingControl.ProcessingParameter) -> bool: ...
    def isParameterValueSupported(self, parameter: QCameraImageProcessingControl.ProcessingParameter, value: typing.Any) -> bool: ...
    def parameter(self, parameter: QCameraImageProcessingControl.ProcessingParameter) -> typing.Any: ...
    def setParameter(self, parameter: QCameraImageProcessingControl.ProcessingParameter, value: typing.Any) -> None: ...

class QCameraInfo(shiboken2.Object):
    @typing.overload
    def __init__(self, other: QCameraInfo) -> None: ...
    @typing.overload
    def __init__(self, name: PySide2.QtCore.QByteArray | bytes = ...) -> None: ...
    @typing.overload
    def __init__(self, camera: QCamera) -> None: ...
    @staticmethod
    def availableCameras(position: QCamera.Position = ...) -> typing.List[QCameraInfo]: ...
    @staticmethod
    def defaultCamera() -> QCameraInfo: ...
    def description(self) -> str: ...
    def deviceName(self) -> str: ...
    def isNull(self) -> bool: ...
    def orientation(self) -> int: ...
    def position(self) -> QCamera.Position: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QCameraInfoControl(QMediaControl):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def cameraOrientation(self, deviceName: str) -> int: ...
    def cameraPosition(self, deviceName: str) -> QCamera.Position: ...

class QCameraLocksControl(QMediaControl):
    lockStatusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def lockStatus(self, lock: QCamera.LockType) -> QCamera.LockStatus: ...
    def searchAndLock(self, locks: QCamera.LockTypes | QCamera.LockType) -> None: ...
    def supportedLocks(self) -> QCamera.LockTypes | QCamera.LockType: ...
    def unlock(self, locks: QCamera.LockTypes | QCamera.LockType) -> None: ...

class QCameraViewfinderSettings(shiboken2.Object):
    @typing.overload
    def __init__(self, other: QCameraViewfinderSettings) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def isNull(self) -> bool: ...
    def maximumFrameRate(self) -> float: ...
    def minimumFrameRate(self) -> float: ...
    def pixelAspectRatio(self) -> PySide2.QtCore.QSize: ...
    def pixelFormat(self) -> QVideoFrame.PixelFormat: ...
    def resolution(self) -> PySide2.QtCore.QSize: ...
    def setMaximumFrameRate(self, rate: float) -> None: ...
    def setMinimumFrameRate(self, rate: float) -> None: ...
    @typing.overload
    def setPixelAspectRatio(self, horizontal: int, vertical: int) -> None: ...
    @typing.overload
    def setPixelAspectRatio(self, ratio: PySide2.QtCore.QSize) -> None: ...
    def setPixelFormat(self, format: QVideoFrame.PixelFormat) -> None: ...
    @typing.overload
    def setResolution(self, width: int, height: int) -> None: ...
    @typing.overload
    def setResolution(self, arg__1: PySide2.QtCore.QSize) -> None: ...
    def swap(self, other: QCameraViewfinderSettings) -> None: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QCameraViewfinderSettingsControl(QMediaControl):
    class ViewfinderParameter:
        MaximumFrameRate: typing.ClassVar[QCameraViewfinderSettingsControl.ViewfinderParameter] = ...
        MinimumFrameRate: typing.ClassVar[QCameraViewfinderSettingsControl.ViewfinderParameter] = ...
        PixelAspectRatio: typing.ClassVar[QCameraViewfinderSettingsControl.ViewfinderParameter] = ...
        PixelFormat: typing.ClassVar[QCameraViewfinderSettingsControl.ViewfinderParameter] = ...
        Resolution: typing.ClassVar[QCameraViewfinderSettingsControl.ViewfinderParameter] = ...
        UserParameter: typing.ClassVar[QCameraViewfinderSettingsControl.ViewfinderParameter] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCameraViewfinderSettingsControl.ViewfinderParameter: ...
        def __and__(self, other: typing.SupportsInt) -> QCameraViewfinderSettingsControl.ViewfinderParameter: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCameraViewfinderSettingsControl.ViewfinderParameter: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCameraViewfinderSettingsControl.ViewfinderParameter: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QCameraViewfinderSettingsControl.ViewfinderParameter: ...
        def __rand__(self, other: typing.SupportsInt) -> QCameraViewfinderSettingsControl.ViewfinderParameter: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCameraViewfinderSettingsControl.ViewfinderParameter: ...
        def __ror__(self, other: typing.SupportsInt) -> QCameraViewfinderSettingsControl.ViewfinderParameter: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCameraViewfinderSettingsControl.ViewfinderParameter: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCameraViewfinderSettingsControl.ViewfinderParameter: ...
        def __sub__(self, other: typing.SupportsInt) -> QCameraViewfinderSettingsControl.ViewfinderParameter: ...
        def __xor__(self, other: typing.SupportsInt) -> QCameraViewfinderSettingsControl.ViewfinderParameter: ...
    MaximumFrameRate: typing.ClassVar[QCameraViewfinderSettingsControl.ViewfinderParameter] = ...
    MinimumFrameRate: typing.ClassVar[QCameraViewfinderSettingsControl.ViewfinderParameter] = ...
    PixelAspectRatio: typing.ClassVar[QCameraViewfinderSettingsControl.ViewfinderParameter] = ...
    PixelFormat: typing.ClassVar[QCameraViewfinderSettingsControl.ViewfinderParameter] = ...
    Resolution: typing.ClassVar[QCameraViewfinderSettingsControl.ViewfinderParameter] = ...
    UserParameter: typing.ClassVar[QCameraViewfinderSettingsControl.ViewfinderParameter] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def isViewfinderParameterSupported(self, parameter: QCameraViewfinderSettingsControl.ViewfinderParameter) -> bool: ...
    def setViewfinderParameter(self, parameter: QCameraViewfinderSettingsControl.ViewfinderParameter, value: typing.Any) -> None: ...
    def viewfinderParameter(self, parameter: QCameraViewfinderSettingsControl.ViewfinderParameter) -> typing.Any: ...

class QCameraViewfinderSettingsControl2(QMediaControl):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def setViewfinderSettings(self, settings: QCameraViewfinderSettings) -> None: ...
    def supportedViewfinderSettings(self) -> typing.List[QCameraViewfinderSettings]: ...
    def viewfinderSettings(self) -> QCameraViewfinderSettings: ...

class QCameraZoomControl(QMediaControl):
    currentDigitalZoomChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    currentOpticalZoomChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    maximumDigitalZoomChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    maximumOpticalZoomChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    requestedDigitalZoomChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    requestedOpticalZoomChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def currentDigitalZoom(self) -> float: ...
    def currentOpticalZoom(self) -> float: ...
    def maximumDigitalZoom(self) -> float: ...
    def maximumOpticalZoom(self) -> float: ...
    def requestedDigitalZoom(self) -> float: ...
    def requestedOpticalZoom(self) -> float: ...
    def zoomTo(self, optical: float, digital: float) -> None: ...

class QCustomAudioRoleControl(QMediaControl):
    customAudioRoleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def customAudioRole(self) -> str: ...
    def setCustomAudioRole(self, role: str) -> None: ...
    def supportedCustomAudioRoles(self) -> typing.List[str]: ...

class QImageEncoderControl(QMediaControl):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def imageCodecDescription(self, codec: str) -> str: ...
    def imageSettings(self) -> QImageEncoderSettings: ...
    def setImageSettings(self, settings: QImageEncoderSettings) -> None: ...
    def supportedImageCodecs(self) -> typing.List[str]: ...

class QImageEncoderSettings(shiboken2.Object):
    @typing.overload
    def __init__(self, other: QImageEncoderSettings) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def codec(self) -> str: ...
    def encodingOption(self, option: str) -> typing.Any: ...
    def encodingOptions(self) -> typing.Dict[str, typing.Any]: ...
    def isNull(self) -> bool: ...
    def quality(self) -> QMultimedia.EncodingQuality: ...
    def resolution(self) -> PySide2.QtCore.QSize: ...
    def setCodec(self, arg__1: str) -> None: ...
    def setEncodingOption(self, option: str, value: typing.Any) -> None: ...
    def setEncodingOptions(self, options: typing.Dict[str, typing.Any]) -> None: ...
    def setQuality(self, quality: QMultimedia.EncodingQuality) -> None: ...
    @typing.overload
    def setResolution(self, width: int, height: int) -> None: ...
    @typing.overload
    def setResolution(self, arg__1: PySide2.QtCore.QSize) -> None: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QMediaAudioProbeControl(QMediaControl):
    audioBufferProbed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    flush: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., audioBufferProbed: typing.Callable = ..., destroyed: typing.Callable = ..., flush: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...

class QMediaAvailabilityControl(QMediaControl):
    availabilityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def availability(self) -> QMultimedia.AvailabilityStatus: ...

class QMediaBindableInterface(shiboken2.Object):
    def __init__(self) -> None: ...
    def mediaObject(self) -> QMediaObject: ...
    def setMediaObject(self, object: QMediaObject) -> bool: ...

class QMediaContainerControl(QMediaControl):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def containerDescription(self, formatMimeType: str) -> str: ...
    def containerFormat(self) -> str: ...
    def setContainerFormat(self, format: str) -> None: ...
    def supportedContainers(self) -> typing.List[str]: ...

class QMediaContent(shiboken2.Object):
    @typing.overload
    def __init__(self, playlist: QMediaPlaylist, contentUrl: PySide2.QtCore.QUrl = ..., takeOwnership: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, resources: typing.Iterable[QMediaResource]) -> None: ...
    @typing.overload
    def __init__(self, other: QMediaContent) -> None: ...
    @typing.overload
    def __init__(self, contentUrl: PySide2.QtCore.QUrl) -> None: ...
    @typing.overload
    def __init__(self, contentResource: QMediaResource) -> None: ...
    @typing.overload
    def __init__(self, contentRequest: PySide2.QtNetwork.QNetworkRequest) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def canonicalRequest(self) -> PySide2.QtNetwork.QNetworkRequest: ...
    def canonicalResource(self) -> QMediaResource: ...
    def canonicalUrl(self) -> PySide2.QtCore.QUrl: ...
    def isNull(self) -> bool: ...
    def playlist(self) -> QMediaPlaylist: ...
    def request(self) -> PySide2.QtNetwork.QNetworkRequest: ...
    def resources(self) -> typing.List[QMediaResource]: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QMediaControl(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...

class QMediaGaplessPlaybackControl(QMediaControl):
    advancedToNextMedia: typing.ClassVar[PySide2.QtCore.Signal] = ...
    crossfadeTimeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    nextMediaChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def crossfadeTime(self) -> float: ...
    def isCrossfadeSupported(self) -> bool: ...
    def nextMedia(self) -> QMediaContent: ...
    def setCrossfadeTime(self, crossfadeTime: float) -> None: ...
    def setNextMedia(self, media: QMediaContent) -> None: ...

class QMediaNetworkAccessControl(QMediaControl):
    configurationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def currentConfiguration(self) -> PySide2.QtNetwork.QNetworkConfiguration: ...
    def setConfigurations(self, configuration: typing.Iterable[PySide2.QtNetwork.QNetworkConfiguration]) -> None: ...

class QMediaObject(PySide2.QtCore.QObject):
    availabilityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    metaDataAvailableChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    metaDataChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    notifyIntervalChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None, service: QMediaService, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def addPropertyWatch(self, name: PySide2.QtCore.QByteArray | bytes) -> None: ...
    def availability(self) -> QMultimedia.AvailabilityStatus: ...
    def availableMetaData(self) -> typing.List[str]: ...
    def bind(self, arg__1: PySide2.QtCore.QObject) -> bool: ...
    def isAvailable(self) -> bool: ...
    def isMetaDataAvailable(self) -> bool: ...
    def metaData(self, key: str) -> typing.Any: ...
    def notifyInterval(self) -> int: ...
    def removePropertyWatch(self, name: PySide2.QtCore.QByteArray | bytes) -> None: ...
    def service(self) -> QMediaService: ...
    def setNotifyInterval(self, milliSeconds: int) -> None: ...
    def unbind(self, arg__1: PySide2.QtCore.QObject) -> None: ...

class QMediaPlayer(QMediaObject):
    class Error:
        AccessDeniedError: typing.ClassVar[QMediaPlayer.Error] = ...
        FormatError: typing.ClassVar[QMediaPlayer.Error] = ...
        MediaIsPlaylist: typing.ClassVar[QMediaPlayer.Error] = ...
        NetworkError: typing.ClassVar[QMediaPlayer.Error] = ...
        NoError: typing.ClassVar[QMediaPlayer.Error] = ...
        ResourceError: typing.ClassVar[QMediaPlayer.Error] = ...
        ServiceMissingError: typing.ClassVar[QMediaPlayer.Error] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMediaPlayer.Error: ...
        def __and__(self, other: typing.SupportsInt) -> QMediaPlayer.Error: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMediaPlayer.Error: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMediaPlayer.Error: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QMediaPlayer.Error: ...
        def __rand__(self, other: typing.SupportsInt) -> QMediaPlayer.Error: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMediaPlayer.Error: ...
        def __ror__(self, other: typing.SupportsInt) -> QMediaPlayer.Error: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMediaPlayer.Error: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMediaPlayer.Error: ...
        def __sub__(self, other: typing.SupportsInt) -> QMediaPlayer.Error: ...
        def __xor__(self, other: typing.SupportsInt) -> QMediaPlayer.Error: ...

    class Flag:
        LowLatency: typing.ClassVar[QMediaPlayer.Flag] = ...
        StreamPlayback: typing.ClassVar[QMediaPlayer.Flag] = ...
        VideoSurface: typing.ClassVar[QMediaPlayer.Flag] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QMediaPlayer.Flags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QMediaPlayer.Flags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMediaPlayer.Flags: ...
        def __rand__(self, other: typing.SupportsInt) -> QMediaPlayer.Flags: ...
        def __ror__(self, other: typing.SupportsInt) -> QMediaPlayer.Flags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMediaPlayer.Flags: ...
        def __xor__(self, other: typing.SupportsInt) -> QMediaPlayer.Flags: ...

    class Flags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QMediaPlayer.Flags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QMediaPlayer.Flags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMediaPlayer.Flags: ...
        def __rand__(self, other: typing.SupportsInt) -> QMediaPlayer.Flags: ...
        def __ror__(self, other: typing.SupportsInt) -> QMediaPlayer.Flags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMediaPlayer.Flags: ...
        def __xor__(self, other: typing.SupportsInt) -> QMediaPlayer.Flags: ...

    class MediaStatus:
        BufferedMedia: typing.ClassVar[QMediaPlayer.MediaStatus] = ...
        BufferingMedia: typing.ClassVar[QMediaPlayer.MediaStatus] = ...
        EndOfMedia: typing.ClassVar[QMediaPlayer.MediaStatus] = ...
        InvalidMedia: typing.ClassVar[QMediaPlayer.MediaStatus] = ...
        LoadedMedia: typing.ClassVar[QMediaPlayer.MediaStatus] = ...
        LoadingMedia: typing.ClassVar[QMediaPlayer.MediaStatus] = ...
        NoMedia: typing.ClassVar[QMediaPlayer.MediaStatus] = ...
        StalledMedia: typing.ClassVar[QMediaPlayer.MediaStatus] = ...
        UnknownMediaStatus: typing.ClassVar[QMediaPlayer.MediaStatus] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMediaPlayer.MediaStatus: ...
        def __and__(self, other: typing.SupportsInt) -> QMediaPlayer.MediaStatus: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMediaPlayer.MediaStatus: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMediaPlayer.MediaStatus: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QMediaPlayer.MediaStatus: ...
        def __rand__(self, other: typing.SupportsInt) -> QMediaPlayer.MediaStatus: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMediaPlayer.MediaStatus: ...
        def __ror__(self, other: typing.SupportsInt) -> QMediaPlayer.MediaStatus: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMediaPlayer.MediaStatus: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMediaPlayer.MediaStatus: ...
        def __sub__(self, other: typing.SupportsInt) -> QMediaPlayer.MediaStatus: ...
        def __xor__(self, other: typing.SupportsInt) -> QMediaPlayer.MediaStatus: ...

    class State:
        PausedState: typing.ClassVar[QMediaPlayer.State] = ...
        PlayingState: typing.ClassVar[QMediaPlayer.State] = ...
        StoppedState: typing.ClassVar[QMediaPlayer.State] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMediaPlayer.State: ...
        def __and__(self, other: typing.SupportsInt) -> QMediaPlayer.State: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMediaPlayer.State: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMediaPlayer.State: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QMediaPlayer.State: ...
        def __rand__(self, other: typing.SupportsInt) -> QMediaPlayer.State: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMediaPlayer.State: ...
        def __ror__(self, other: typing.SupportsInt) -> QMediaPlayer.State: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMediaPlayer.State: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMediaPlayer.State: ...
        def __sub__(self, other: typing.SupportsInt) -> QMediaPlayer.State: ...
        def __xor__(self, other: typing.SupportsInt) -> QMediaPlayer.State: ...
    AccessDeniedError: typing.ClassVar[QMediaPlayer.Error] = ...
    BufferedMedia: typing.ClassVar[QMediaPlayer.MediaStatus] = ...
    BufferingMedia: typing.ClassVar[QMediaPlayer.MediaStatus] = ...
    EndOfMedia: typing.ClassVar[QMediaPlayer.MediaStatus] = ...
    FormatError: typing.ClassVar[QMediaPlayer.Error] = ...
    InvalidMedia: typing.ClassVar[QMediaPlayer.MediaStatus] = ...
    LoadedMedia: typing.ClassVar[QMediaPlayer.MediaStatus] = ...
    LoadingMedia: typing.ClassVar[QMediaPlayer.MediaStatus] = ...
    LowLatency: typing.ClassVar[QMediaPlayer.Flag] = ...
    MediaIsPlaylist: typing.ClassVar[QMediaPlayer.Error] = ...
    NetworkError: typing.ClassVar[QMediaPlayer.Error] = ...
    NoError: typing.ClassVar[QMediaPlayer.Error] = ...
    NoMedia: typing.ClassVar[QMediaPlayer.MediaStatus] = ...
    PausedState: typing.ClassVar[QMediaPlayer.State] = ...
    PlayingState: typing.ClassVar[QMediaPlayer.State] = ...
    ResourceError: typing.ClassVar[QMediaPlayer.Error] = ...
    ServiceMissingError: typing.ClassVar[QMediaPlayer.Error] = ...
    StalledMedia: typing.ClassVar[QMediaPlayer.MediaStatus] = ...
    StoppedState: typing.ClassVar[QMediaPlayer.State] = ...
    StreamPlayback: typing.ClassVar[QMediaPlayer.Flag] = ...
    UnknownMediaStatus: typing.ClassVar[QMediaPlayer.MediaStatus] = ...
    VideoSurface: typing.ClassVar[QMediaPlayer.Flag] = ...
    audioAvailableChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    audioRoleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    bufferStatusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    currentMediaChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    customAudioRoleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    durationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    mediaChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    mediaStatusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    mutedChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    networkConfigurationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    playbackRateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    positionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    seekableChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    videoAvailableChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    volumeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., flags: QMediaPlayer.Flags | QMediaPlayer.Flag = ..., audioAvailable: bool = ..., audioAvailableChanged: typing.Callable = ..., audioRole: typing.Any = ..., audioRoleChanged: typing.Callable = ..., availabilityChanged: typing.Callable = ..., bufferStatus: int = ..., bufferStatusChanged: typing.Callable = ..., currentMedia: QMediaContent = ..., currentMediaChanged: typing.Callable = ..., customAudioRole: str = ..., customAudioRoleChanged: typing.Callable = ..., destroyed: typing.Callable = ..., duration: int = ..., durationChanged: typing.Callable = ..., error: typing.Callable = ..., media: QMediaContent = ..., mediaChanged: typing.Callable = ..., mediaStatus: QMediaPlayer.MediaStatus = ..., mediaStatusChanged: typing.Callable = ..., metaDataAvailableChanged: typing.Callable = ..., metaDataChanged: typing.Callable = ..., muted: bool = ..., mutedChanged: typing.Callable = ..., networkConfigurationChanged: typing.Callable = ..., notifyInterval: int = ..., notifyIntervalChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., playbackRate: float = ..., playbackRateChanged: typing.Callable = ..., playlist: QMediaPlaylist = ..., position: int = ..., positionChanged: typing.Callable = ..., seekable: bool = ..., seekableChanged: typing.Callable = ..., state: QMediaPlayer.State = ..., stateChanged: typing.Callable = ..., videoAvailable: bool = ..., videoAvailableChanged: typing.Callable = ..., volume: int = ..., volumeChanged: typing.Callable = ...) -> None: ...
    def audioRole(self) -> QAudio.Role: ...
    def availability(self) -> QMultimedia.AvailabilityStatus: ...
    def bind(self, arg__1: PySide2.QtCore.QObject) -> bool: ...
    def bufferStatus(self) -> int: ...
    def currentMedia(self) -> QMediaContent: ...
    def currentNetworkConfiguration(self) -> PySide2.QtNetwork.QNetworkConfiguration: ...
    def customAudioRole(self) -> str: ...
    def duration(self) -> int: ...
    def errorString(self) -> str: ...
    @staticmethod
    def hasSupport(mimeType: str, codecs: typing.Iterable[str] = ..., flags: QMediaPlayer.Flags | QMediaPlayer.Flag = ...) -> QMultimedia.SupportEstimate: ...
    def isAudioAvailable(self) -> bool: ...
    def isMuted(self) -> bool: ...
    def isSeekable(self) -> bool: ...
    def isVideoAvailable(self) -> bool: ...
    def media(self) -> QMediaContent: ...
    def mediaStatus(self) -> QMediaPlayer.MediaStatus: ...
    def mediaStream(self) -> PySide2.QtCore.QIODevice: ...
    def pause(self) -> None: ...
    def play(self) -> None: ...
    def playbackRate(self) -> float: ...
    def playlist(self) -> QMediaPlaylist: ...
    def position(self) -> int: ...
    def setAudioRole(self, audioRole: QAudio.Role) -> None: ...
    def setCustomAudioRole(self, audioRole: str) -> None: ...
    def setMedia(self, media: QMediaContent, stream: PySide2.QtCore.QIODevice | None = ...) -> None: ...
    def setMuted(self, muted: bool) -> None: ...
    def setNetworkConfigurations(self, configurations: typing.Iterable[PySide2.QtNetwork.QNetworkConfiguration]) -> None: ...
    def setPlaybackRate(self, rate: float) -> None: ...
    def setPlaylist(self, playlist: QMediaPlaylist) -> None: ...
    def setPosition(self, position: int) -> None: ...
    @typing.overload
    def setVideoOutput(self, surfaces: typing.List[QAbstractVideoSurface]) -> None: ...
    @typing.overload
    def setVideoOutput(self, surface: QAbstractVideoSurface) -> None: ...
    @typing.overload
    def setVideoOutput(self, arg__1: PySide2.QtMultimediaWidgets.QGraphicsVideoItem) -> None: ...
    @typing.overload
    def setVideoOutput(self, arg__1: PySide2.QtMultimediaWidgets.QVideoWidget) -> None: ...
    def setVolume(self, volume: int) -> None: ...
    def state(self) -> QMediaPlayer.State: ...
    def stop(self) -> None: ...
    def supportedAudioRoles(self) -> typing.List[QAudio.Role]: ...
    def supportedCustomAudioRoles(self) -> typing.List[str]: ...
    @staticmethod
    def supportedMimeTypes(flags: QMediaPlayer.Flags | QMediaPlayer.Flag = ...) -> typing.List[str]: ...
    def unbind(self, arg__1: PySide2.QtCore.QObject) -> None: ...
    def volume(self) -> int: ...

class QMediaPlayerControl(QMediaControl):
    audioAvailableChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    availablePlaybackRangesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    bufferStatusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    durationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    mediaChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    mediaStatusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    mutedChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    playbackRateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    positionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    seekableChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    videoAvailableChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    volumeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def availablePlaybackRanges(self) -> QMediaTimeRange: ...
    def bufferStatus(self) -> int: ...
    def duration(self) -> int: ...
    def isAudioAvailable(self) -> bool: ...
    def isMuted(self) -> bool: ...
    def isSeekable(self) -> bool: ...
    def isVideoAvailable(self) -> bool: ...
    def media(self) -> QMediaContent: ...
    def mediaStatus(self) -> QMediaPlayer.MediaStatus: ...
    def mediaStream(self) -> PySide2.QtCore.QIODevice: ...
    def pause(self) -> None: ...
    def play(self) -> None: ...
    def playbackRate(self) -> float: ...
    def position(self) -> int: ...
    def setMedia(self, media: QMediaContent, stream: PySide2.QtCore.QIODevice) -> None: ...
    def setMuted(self, mute: bool) -> None: ...
    def setPlaybackRate(self, rate: float) -> None: ...
    def setPosition(self, position: int) -> None: ...
    def setVolume(self, volume: int) -> None: ...
    def state(self) -> QMediaPlayer.State: ...
    def stop(self) -> None: ...
    def volume(self) -> int: ...

class QMediaPlaylist(PySide2.QtCore.QObject, QMediaBindableInterface):
    class Error:
        AccessDeniedError: typing.ClassVar[QMediaPlaylist.Error] = ...
        FormatError: typing.ClassVar[QMediaPlaylist.Error] = ...
        FormatNotSupportedError: typing.ClassVar[QMediaPlaylist.Error] = ...
        NetworkError: typing.ClassVar[QMediaPlaylist.Error] = ...
        NoError: typing.ClassVar[QMediaPlaylist.Error] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMediaPlaylist.Error: ...
        def __and__(self, other: typing.SupportsInt) -> QMediaPlaylist.Error: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMediaPlaylist.Error: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMediaPlaylist.Error: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QMediaPlaylist.Error: ...
        def __rand__(self, other: typing.SupportsInt) -> QMediaPlaylist.Error: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMediaPlaylist.Error: ...
        def __ror__(self, other: typing.SupportsInt) -> QMediaPlaylist.Error: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMediaPlaylist.Error: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMediaPlaylist.Error: ...
        def __sub__(self, other: typing.SupportsInt) -> QMediaPlaylist.Error: ...
        def __xor__(self, other: typing.SupportsInt) -> QMediaPlaylist.Error: ...

    class PlaybackMode:
        CurrentItemInLoop: typing.ClassVar[QMediaPlaylist.PlaybackMode] = ...
        CurrentItemOnce: typing.ClassVar[QMediaPlaylist.PlaybackMode] = ...
        Loop: typing.ClassVar[QMediaPlaylist.PlaybackMode] = ...
        Random: typing.ClassVar[QMediaPlaylist.PlaybackMode] = ...
        Sequential: typing.ClassVar[QMediaPlaylist.PlaybackMode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMediaPlaylist.PlaybackMode: ...
        def __and__(self, other: typing.SupportsInt) -> QMediaPlaylist.PlaybackMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMediaPlaylist.PlaybackMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMediaPlaylist.PlaybackMode: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QMediaPlaylist.PlaybackMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QMediaPlaylist.PlaybackMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMediaPlaylist.PlaybackMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QMediaPlaylist.PlaybackMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMediaPlaylist.PlaybackMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMediaPlaylist.PlaybackMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QMediaPlaylist.PlaybackMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QMediaPlaylist.PlaybackMode: ...
    AccessDeniedError: typing.ClassVar[QMediaPlaylist.Error] = ...
    CurrentItemInLoop: typing.ClassVar[QMediaPlaylist.PlaybackMode] = ...
    CurrentItemOnce: typing.ClassVar[QMediaPlaylist.PlaybackMode] = ...
    FormatError: typing.ClassVar[QMediaPlaylist.Error] = ...
    FormatNotSupportedError: typing.ClassVar[QMediaPlaylist.Error] = ...
    Loop: typing.ClassVar[QMediaPlaylist.PlaybackMode] = ...
    NetworkError: typing.ClassVar[QMediaPlaylist.Error] = ...
    NoError: typing.ClassVar[QMediaPlaylist.Error] = ...
    Random: typing.ClassVar[QMediaPlaylist.PlaybackMode] = ...
    Sequential: typing.ClassVar[QMediaPlaylist.PlaybackMode] = ...
    currentIndexChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    currentMediaChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    loadFailed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    loaded: typing.ClassVar[PySide2.QtCore.Signal] = ...
    mediaAboutToBeInserted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    mediaAboutToBeRemoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
    mediaChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    mediaInserted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    mediaRemoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
    playbackModeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., currentIndex: int = ..., currentIndexChanged: typing.Callable = ..., currentMedia: QMediaContent = ..., currentMediaChanged: typing.Callable = ..., destroyed: typing.Callable = ..., loadFailed: typing.Callable = ..., loaded: typing.Callable = ..., mediaAboutToBeInserted: typing.Callable = ..., mediaAboutToBeRemoved: typing.Callable = ..., mediaChanged: typing.Callable = ..., mediaInserted: typing.Callable = ..., mediaRemoved: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., playbackMode: typing.Any = ..., playbackModeChanged: typing.Callable = ...) -> None: ...
    @typing.overload
    def addMedia(self, items: typing.Iterable[QMediaContent]) -> bool: ...
    @typing.overload
    def addMedia(self, content: QMediaContent) -> bool: ...
    def clear(self) -> bool: ...
    def currentIndex(self) -> int: ...
    def currentMedia(self) -> QMediaContent: ...
    def error(self) -> QMediaPlaylist.Error: ...
    def errorString(self) -> str: ...
    @typing.overload
    def insertMedia(self, index: int, items: typing.Iterable[QMediaContent]) -> bool: ...
    @typing.overload
    def insertMedia(self, index: int, content: QMediaContent) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    @typing.overload
    def load(self, request: PySide2.QtNetwork.QNetworkRequest, format: bytes | None = ...) -> None: ...
    @typing.overload
    def load(self, location: PySide2.QtCore.QUrl, format: bytes | None = ...) -> None: ...
    @typing.overload
    def load(self, device: PySide2.QtCore.QIODevice, format: bytes | None = ...) -> None: ...
    def media(self, index: int) -> QMediaContent: ...
    def mediaCount(self) -> int: ...
    def mediaObject(self) -> QMediaObject: ...
    def moveMedia(self, from_: int, to: int) -> bool: ...
    def next(self) -> None: ...
    def nextIndex(self, steps: int = ...) -> int: ...
    def playbackMode(self) -> QMediaPlaylist.PlaybackMode: ...
    def previous(self) -> None: ...
    def previousIndex(self, steps: int = ...) -> int: ...
    @typing.overload
    def removeMedia(self, start: int, end: int) -> bool: ...
    @typing.overload
    def removeMedia(self, pos: int) -> bool: ...
    @typing.overload
    def save(self, location: PySide2.QtCore.QUrl, format: bytes | None = ...) -> bool: ...
    @typing.overload
    def save(self, device: PySide2.QtCore.QIODevice, format: bytes) -> bool: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def setMediaObject(self, object: QMediaObject) -> bool: ...
    def setPlaybackMode(self, mode: QMediaPlaylist.PlaybackMode) -> None: ...
    def shuffle(self) -> None: ...

class QMediaRecorder(PySide2.QtCore.QObject, QMediaBindableInterface):
    class Error:
        FormatError: typing.ClassVar[QMediaRecorder.Error] = ...
        NoError: typing.ClassVar[QMediaRecorder.Error] = ...
        OutOfSpaceError: typing.ClassVar[QMediaRecorder.Error] = ...
        ResourceError: typing.ClassVar[QMediaRecorder.Error] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMediaRecorder.Error: ...
        def __and__(self, other: typing.SupportsInt) -> QMediaRecorder.Error: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMediaRecorder.Error: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMediaRecorder.Error: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QMediaRecorder.Error: ...
        def __rand__(self, other: typing.SupportsInt) -> QMediaRecorder.Error: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMediaRecorder.Error: ...
        def __ror__(self, other: typing.SupportsInt) -> QMediaRecorder.Error: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMediaRecorder.Error: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMediaRecorder.Error: ...
        def __sub__(self, other: typing.SupportsInt) -> QMediaRecorder.Error: ...
        def __xor__(self, other: typing.SupportsInt) -> QMediaRecorder.Error: ...

    class State:
        PausedState: typing.ClassVar[QMediaRecorder.State] = ...
        RecordingState: typing.ClassVar[QMediaRecorder.State] = ...
        StoppedState: typing.ClassVar[QMediaRecorder.State] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMediaRecorder.State: ...
        def __and__(self, other: typing.SupportsInt) -> QMediaRecorder.State: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMediaRecorder.State: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMediaRecorder.State: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QMediaRecorder.State: ...
        def __rand__(self, other: typing.SupportsInt) -> QMediaRecorder.State: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMediaRecorder.State: ...
        def __ror__(self, other: typing.SupportsInt) -> QMediaRecorder.State: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMediaRecorder.State: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMediaRecorder.State: ...
        def __sub__(self, other: typing.SupportsInt) -> QMediaRecorder.State: ...
        def __xor__(self, other: typing.SupportsInt) -> QMediaRecorder.State: ...

    class Status:
        FinalizingStatus: typing.ClassVar[QMediaRecorder.Status] = ...
        LoadedStatus: typing.ClassVar[QMediaRecorder.Status] = ...
        LoadingStatus: typing.ClassVar[QMediaRecorder.Status] = ...
        PausedStatus: typing.ClassVar[QMediaRecorder.Status] = ...
        RecordingStatus: typing.ClassVar[QMediaRecorder.Status] = ...
        StartingStatus: typing.ClassVar[QMediaRecorder.Status] = ...
        UnavailableStatus: typing.ClassVar[QMediaRecorder.Status] = ...
        UnloadedStatus: typing.ClassVar[QMediaRecorder.Status] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMediaRecorder.Status: ...
        def __and__(self, other: typing.SupportsInt) -> QMediaRecorder.Status: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMediaRecorder.Status: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMediaRecorder.Status: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QMediaRecorder.Status: ...
        def __rand__(self, other: typing.SupportsInt) -> QMediaRecorder.Status: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMediaRecorder.Status: ...
        def __ror__(self, other: typing.SupportsInt) -> QMediaRecorder.Status: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMediaRecorder.Status: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMediaRecorder.Status: ...
        def __sub__(self, other: typing.SupportsInt) -> QMediaRecorder.Status: ...
        def __xor__(self, other: typing.SupportsInt) -> QMediaRecorder.Status: ...
    FinalizingStatus: typing.ClassVar[QMediaRecorder.Status] = ...
    FormatError: typing.ClassVar[QMediaRecorder.Error] = ...
    LoadedStatus: typing.ClassVar[QMediaRecorder.Status] = ...
    LoadingStatus: typing.ClassVar[QMediaRecorder.Status] = ...
    NoError: typing.ClassVar[QMediaRecorder.Error] = ...
    OutOfSpaceError: typing.ClassVar[QMediaRecorder.Error] = ...
    PausedState: typing.ClassVar[QMediaRecorder.State] = ...
    PausedStatus: typing.ClassVar[QMediaRecorder.Status] = ...
    RecordingState: typing.ClassVar[QMediaRecorder.State] = ...
    RecordingStatus: typing.ClassVar[QMediaRecorder.Status] = ...
    ResourceError: typing.ClassVar[QMediaRecorder.Error] = ...
    StartingStatus: typing.ClassVar[QMediaRecorder.Status] = ...
    StoppedState: typing.ClassVar[QMediaRecorder.State] = ...
    UnavailableStatus: typing.ClassVar[QMediaRecorder.Status] = ...
    UnloadedStatus: typing.ClassVar[QMediaRecorder.Status] = ...
    actualLocationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    availabilityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    durationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    metaDataAvailableChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    metaDataChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    metaDataWritableChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    mutedChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    statusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    volumeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, mediaObject: QMediaObject, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def actualLocation(self) -> PySide2.QtCore.QUrl: ...
    def audioCodecDescription(self, codecName: str) -> str: ...
    def audioSettings(self) -> QAudioEncoderSettings: ...
    def availability(self) -> QMultimedia.AvailabilityStatus: ...
    def availableMetaData(self) -> typing.List[str]: ...
    def containerDescription(self, format: str) -> str: ...
    def containerFormat(self) -> str: ...
    def duration(self) -> int: ...
    def errorString(self) -> str: ...
    def isAvailable(self) -> bool: ...
    def isMetaDataAvailable(self) -> bool: ...
    def isMetaDataWritable(self) -> bool: ...
    def isMuted(self) -> bool: ...
    def mediaObject(self) -> QMediaObject: ...
    def metaData(self, key: str) -> typing.Any: ...
    def outputLocation(self) -> PySide2.QtCore.QUrl: ...
    def pause(self) -> None: ...
    def record(self) -> None: ...
    def setAudioSettings(self, audioSettings: QAudioEncoderSettings) -> None: ...
    def setContainerFormat(self, container: str) -> None: ...
    def setEncodingSettings(self, audioSettings: QAudioEncoderSettings, videoSettings: QVideoEncoderSettings = ..., containerMimeType: str = ...) -> None: ...
    def setMediaObject(self, object: QMediaObject) -> bool: ...
    def setMetaData(self, key: str, value: typing.Any) -> None: ...
    def setMuted(self, muted: bool) -> None: ...
    def setOutputLocation(self, location: PySide2.QtCore.QUrl) -> bool: ...
    def setVideoSettings(self, videoSettings: QVideoEncoderSettings) -> None: ...
    def setVolume(self, volume: float) -> None: ...
    def state(self) -> QMediaRecorder.State: ...
    def status(self) -> QMediaRecorder.Status: ...
    def stop(self) -> None: ...
    def supportedAudioCodecs(self) -> typing.List[str]: ...
    def supportedContainers(self) -> typing.List[str]: ...
    def supportedVideoCodecs(self) -> typing.List[str]: ...
    def videoCodecDescription(self, codecName: str) -> str: ...
    def videoSettings(self) -> QVideoEncoderSettings: ...
    def volume(self) -> float: ...

class QMediaRecorderControl(QMediaControl):
    actualLocationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    durationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    mutedChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    statusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    volumeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def applySettings(self) -> None: ...
    def duration(self) -> int: ...
    def isMuted(self) -> bool: ...
    def outputLocation(self) -> PySide2.QtCore.QUrl: ...
    def setMuted(self, muted: bool) -> None: ...
    def setOutputLocation(self, location: PySide2.QtCore.QUrl) -> bool: ...
    def setState(self, state: QMediaRecorder.State) -> None: ...
    def setVolume(self, volume: float) -> None: ...
    def state(self) -> QMediaRecorder.State: ...
    def status(self) -> QMediaRecorder.Status: ...
    def volume(self) -> float: ...

class QMediaResource(shiboken2.Object):
    @typing.overload
    def __init__(self, url: PySide2.QtCore.QUrl, mimeType: str = ...) -> None: ...
    @typing.overload
    def __init__(self, request: PySide2.QtNetwork.QNetworkRequest, mimeType: str = ...) -> None: ...
    @typing.overload
    def __init__(self, other: QMediaResource) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def audioBitRate(self) -> int: ...
    def audioCodec(self) -> str: ...
    def channelCount(self) -> int: ...
    def dataSize(self) -> int: ...
    def isNull(self) -> bool: ...
    def language(self) -> str: ...
    def mimeType(self) -> str: ...
    def request(self) -> PySide2.QtNetwork.QNetworkRequest: ...
    def resolution(self) -> PySide2.QtCore.QSize: ...
    def sampleRate(self) -> int: ...
    def setAudioBitRate(self, rate: int) -> None: ...
    def setAudioCodec(self, codec: str) -> None: ...
    def setChannelCount(self, channels: int) -> None: ...
    def setDataSize(self, size: int) -> None: ...
    def setLanguage(self, language: str) -> None: ...
    @typing.overload
    def setResolution(self, width: int, height: int) -> None: ...
    @typing.overload
    def setResolution(self, resolution: PySide2.QtCore.QSize) -> None: ...
    def setSampleRate(self, frequency: int) -> None: ...
    def setVideoBitRate(self, rate: int) -> None: ...
    def setVideoCodec(self, codec: str) -> None: ...
    def url(self) -> PySide2.QtCore.QUrl: ...
    def videoBitRate(self) -> int: ...
    def videoCodec(self) -> str: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QMediaService(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def releaseControl(self, control: QMediaControl) -> None: ...
    def requestControl(self, name: bytes) -> QMediaControl: ...

class QMediaServiceCameraInfoInterface(shiboken2.Object):
    def __init__(self) -> None: ...
    def cameraOrientation(self, device: PySide2.QtCore.QByteArray | bytes) -> int: ...
    def cameraPosition(self, device: PySide2.QtCore.QByteArray | bytes) -> QCamera.Position: ...

class QMediaServiceDefaultDeviceInterface(shiboken2.Object):
    def __init__(self) -> None: ...
    def defaultDevice(self, service: PySide2.QtCore.QByteArray | bytes) -> PySide2.QtCore.QByteArray: ...

class QMediaServiceFeaturesInterface(shiboken2.Object):
    def __init__(self) -> None: ...
    def supportedFeatures(self, service: PySide2.QtCore.QByteArray | bytes) -> QMediaServiceProviderHint.Features | QMediaServiceProviderHint.Feature: ...

class QMediaServiceProviderHint(shiboken2.Object):
    class Feature:
        LowLatencyPlayback: typing.ClassVar[QMediaServiceProviderHint.Feature] = ...
        RecordingSupport: typing.ClassVar[QMediaServiceProviderHint.Feature] = ...
        StreamPlayback: typing.ClassVar[QMediaServiceProviderHint.Feature] = ...
        VideoSurface: typing.ClassVar[QMediaServiceProviderHint.Feature] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QMediaServiceProviderHint.Features: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QMediaServiceProviderHint.Features: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMediaServiceProviderHint.Features: ...
        def __rand__(self, other: typing.SupportsInt) -> QMediaServiceProviderHint.Features: ...
        def __ror__(self, other: typing.SupportsInt) -> QMediaServiceProviderHint.Features: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMediaServiceProviderHint.Features: ...
        def __xor__(self, other: typing.SupportsInt) -> QMediaServiceProviderHint.Features: ...

    class Features:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QMediaServiceProviderHint.Features: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QMediaServiceProviderHint.Features: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMediaServiceProviderHint.Features: ...
        def __rand__(self, other: typing.SupportsInt) -> QMediaServiceProviderHint.Features: ...
        def __ror__(self, other: typing.SupportsInt) -> QMediaServiceProviderHint.Features: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMediaServiceProviderHint.Features: ...
        def __xor__(self, other: typing.SupportsInt) -> QMediaServiceProviderHint.Features: ...

    class Type:
        CameraPosition: typing.ClassVar[QMediaServiceProviderHint.Type] = ...
        ContentType: typing.ClassVar[QMediaServiceProviderHint.Type] = ...
        Device: typing.ClassVar[QMediaServiceProviderHint.Type] = ...
        Null: typing.ClassVar[QMediaServiceProviderHint.Type] = ...
        SupportedFeatures: typing.ClassVar[QMediaServiceProviderHint.Type] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMediaServiceProviderHint.Type: ...
        def __and__(self, other: typing.SupportsInt) -> QMediaServiceProviderHint.Type: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMediaServiceProviderHint.Type: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMediaServiceProviderHint.Type: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QMediaServiceProviderHint.Type: ...
        def __rand__(self, other: typing.SupportsInt) -> QMediaServiceProviderHint.Type: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMediaServiceProviderHint.Type: ...
        def __ror__(self, other: typing.SupportsInt) -> QMediaServiceProviderHint.Type: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMediaServiceProviderHint.Type: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMediaServiceProviderHint.Type: ...
        def __sub__(self, other: typing.SupportsInt) -> QMediaServiceProviderHint.Type: ...
        def __xor__(self, other: typing.SupportsInt) -> QMediaServiceProviderHint.Type: ...
    CameraPosition: typing.ClassVar[QMediaServiceProviderHint.Type] = ...
    ContentType: typing.ClassVar[QMediaServiceProviderHint.Type] = ...
    Device: typing.ClassVar[QMediaServiceProviderHint.Type] = ...
    LowLatencyPlayback: typing.ClassVar[QMediaServiceProviderHint.Feature] = ...
    Null: typing.ClassVar[QMediaServiceProviderHint.Type] = ...
    RecordingSupport: typing.ClassVar[QMediaServiceProviderHint.Feature] = ...
    StreamPlayback: typing.ClassVar[QMediaServiceProviderHint.Feature] = ...
    SupportedFeatures: typing.ClassVar[QMediaServiceProviderHint.Type] = ...
    VideoSurface: typing.ClassVar[QMediaServiceProviderHint.Feature] = ...
    @typing.overload
    def __init__(self, mimeType: str, codecs: typing.Iterable[str]) -> None: ...
    @typing.overload
    def __init__(self, position: QCamera.Position) -> None: ...
    @typing.overload
    def __init__(self, other: QMediaServiceProviderHint) -> None: ...
    @typing.overload
    def __init__(self, features: QMediaServiceProviderHint.Features | QMediaServiceProviderHint.Feature) -> None: ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QByteArray | bytes) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def cameraPosition(self) -> QCamera.Position: ...
    def codecs(self) -> typing.List[str]: ...
    def device(self) -> PySide2.QtCore.QByteArray: ...
    def features(self) -> QMediaServiceProviderHint.Features | QMediaServiceProviderHint.Feature: ...
    def isNull(self) -> bool: ...
    def mimeType(self) -> str: ...
    def type(self) -> QMediaServiceProviderHint.Type: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QMediaServiceSupportedDevicesInterface(shiboken2.Object):
    def __init__(self) -> None: ...
    def deviceDescription(self, service: PySide2.QtCore.QByteArray | bytes, device: PySide2.QtCore.QByteArray | bytes) -> str: ...
    def devices(self, service: PySide2.QtCore.QByteArray | bytes) -> typing.List[PySide2.QtCore.QByteArray]: ...

class QMediaServiceSupportedFormatsInterface(shiboken2.Object):
    def __init__(self) -> None: ...
    def hasSupport(self, mimeType: str, codecs: typing.Iterable[str]) -> QMultimedia.SupportEstimate: ...
    def supportedMimeTypes(self) -> typing.List[str]: ...

class QMediaStreamsControl(QMediaControl):
    class StreamType:
        AudioStream: typing.ClassVar[QMediaStreamsControl.StreamType] = ...
        DataStream: typing.ClassVar[QMediaStreamsControl.StreamType] = ...
        SubPictureStream: typing.ClassVar[QMediaStreamsControl.StreamType] = ...
        UnknownStream: typing.ClassVar[QMediaStreamsControl.StreamType] = ...
        VideoStream: typing.ClassVar[QMediaStreamsControl.StreamType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMediaStreamsControl.StreamType: ...
        def __and__(self, other: typing.SupportsInt) -> QMediaStreamsControl.StreamType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMediaStreamsControl.StreamType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMediaStreamsControl.StreamType: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QMediaStreamsControl.StreamType: ...
        def __rand__(self, other: typing.SupportsInt) -> QMediaStreamsControl.StreamType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMediaStreamsControl.StreamType: ...
        def __ror__(self, other: typing.SupportsInt) -> QMediaStreamsControl.StreamType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMediaStreamsControl.StreamType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMediaStreamsControl.StreamType: ...
        def __sub__(self, other: typing.SupportsInt) -> QMediaStreamsControl.StreamType: ...
        def __xor__(self, other: typing.SupportsInt) -> QMediaStreamsControl.StreamType: ...
    AudioStream: typing.ClassVar[QMediaStreamsControl.StreamType] = ...
    DataStream: typing.ClassVar[QMediaStreamsControl.StreamType] = ...
    SubPictureStream: typing.ClassVar[QMediaStreamsControl.StreamType] = ...
    UnknownStream: typing.ClassVar[QMediaStreamsControl.StreamType] = ...
    VideoStream: typing.ClassVar[QMediaStreamsControl.StreamType] = ...
    activeStreamsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    streamsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def isActive(self, streamNumber: int) -> bool: ...
    def metaData(self, streamNumber: int, key: str) -> typing.Any: ...
    def setActive(self, streamNumber: int, state: bool) -> None: ...
    def streamCount(self) -> int: ...
    def streamType(self, streamNumber: int) -> QMediaStreamsControl.StreamType: ...

class QMediaTimeInterval(shiboken2.Object):
    @typing.overload
    def __init__(self, start: int, end: int) -> None: ...
    @typing.overload
    def __init__(self, arg__1: QMediaTimeInterval) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def contains(self, time: int) -> bool: ...
    def end(self) -> int: ...
    def isNormal(self) -> bool: ...
    def normalized(self) -> QMediaTimeInterval: ...
    def start(self) -> int: ...
    def translated(self, offset: int) -> QMediaTimeInterval: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QMediaTimeRange(shiboken2.Object):
    @typing.overload
    def __init__(self, start: int, end: int) -> None: ...
    @typing.overload
    def __init__(self, range: QMediaTimeRange) -> None: ...
    @typing.overload
    def __init__(self, arg__1: QMediaTimeInterval) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def addInterval(self, start: int, end: int) -> None: ...
    @typing.overload
    def addInterval(self, interval: QMediaTimeInterval) -> None: ...
    def addTimeRange(self, arg__1: QMediaTimeRange) -> None: ...
    def clear(self) -> None: ...
    def contains(self, time: int) -> bool: ...
    def earliestTime(self) -> int: ...
    def intervals(self) -> typing.List[QMediaTimeInterval]: ...
    def isContinuous(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def latestTime(self) -> int: ...
    @typing.overload
    def removeInterval(self, start: int, end: int) -> None: ...
    @typing.overload
    def removeInterval(self, interval: QMediaTimeInterval) -> None: ...
    def removeTimeRange(self, arg__1: QMediaTimeRange) -> None: ...
    def __add__(self, arg__2: QMediaTimeRange) -> QMediaTimeRange: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    @typing.overload
    def __iadd__(self, arg__1: QMediaTimeInterval) -> QMediaTimeRange: ...
    @typing.overload
    def __iadd__(self, arg__1: QMediaTimeRange) -> QMediaTimeRange: ...
    @typing.overload
    def __isub__(self, arg__1: QMediaTimeInterval) -> QMediaTimeRange: ...
    @typing.overload
    def __isub__(self, arg__1: QMediaTimeRange) -> QMediaTimeRange: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __radd__(self, other): ...
    def __rsub__(self, other): ...
    def __sub__(self, arg__2: QMediaTimeRange) -> QMediaTimeRange: ...

class QMediaVideoProbeControl(QMediaControl):
    flush: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    videoFrameProbed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., flush: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., videoFrameProbed: typing.Callable = ...) -> None: ...

class QMetaDataReaderControl(QMediaControl):
    metaDataAvailableChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    metaDataChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def availableMetaData(self) -> typing.List[str]: ...
    def isMetaDataAvailable(self) -> bool: ...
    def metaData(self, key: str) -> typing.Any: ...

class QMetaDataWriterControl(QMediaControl):
    metaDataAvailableChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    metaDataChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    writableChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def availableMetaData(self) -> typing.List[str]: ...
    def isMetaDataAvailable(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def metaData(self, key: str) -> typing.Any: ...
    def setMetaData(self, key: str, value: typing.Any) -> None: ...

class QMultimedia(shiboken2.Object):
    class AvailabilityStatus:
        Available: typing.ClassVar[QMultimedia.AvailabilityStatus] = ...
        Busy: typing.ClassVar[QMultimedia.AvailabilityStatus] = ...
        ResourceError: typing.ClassVar[QMultimedia.AvailabilityStatus] = ...
        ServiceMissing: typing.ClassVar[QMultimedia.AvailabilityStatus] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMultimedia.AvailabilityStatus: ...
        def __and__(self, other: typing.SupportsInt) -> QMultimedia.AvailabilityStatus: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMultimedia.AvailabilityStatus: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMultimedia.AvailabilityStatus: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QMultimedia.AvailabilityStatus: ...
        def __rand__(self, other: typing.SupportsInt) -> QMultimedia.AvailabilityStatus: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMultimedia.AvailabilityStatus: ...
        def __ror__(self, other: typing.SupportsInt) -> QMultimedia.AvailabilityStatus: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMultimedia.AvailabilityStatus: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMultimedia.AvailabilityStatus: ...
        def __sub__(self, other: typing.SupportsInt) -> QMultimedia.AvailabilityStatus: ...
        def __xor__(self, other: typing.SupportsInt) -> QMultimedia.AvailabilityStatus: ...

    class EncodingMode:
        AverageBitRateEncoding: typing.ClassVar[QMultimedia.EncodingMode] = ...
        ConstantBitRateEncoding: typing.ClassVar[QMultimedia.EncodingMode] = ...
        ConstantQualityEncoding: typing.ClassVar[QMultimedia.EncodingMode] = ...
        TwoPassEncoding: typing.ClassVar[QMultimedia.EncodingMode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMultimedia.EncodingMode: ...
        def __and__(self, other: typing.SupportsInt) -> QMultimedia.EncodingMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMultimedia.EncodingMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMultimedia.EncodingMode: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QMultimedia.EncodingMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QMultimedia.EncodingMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMultimedia.EncodingMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QMultimedia.EncodingMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMultimedia.EncodingMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMultimedia.EncodingMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QMultimedia.EncodingMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QMultimedia.EncodingMode: ...

    class EncodingQuality:
        HighQuality: typing.ClassVar[QMultimedia.EncodingQuality] = ...
        LowQuality: typing.ClassVar[QMultimedia.EncodingQuality] = ...
        NormalQuality: typing.ClassVar[QMultimedia.EncodingQuality] = ...
        VeryHighQuality: typing.ClassVar[QMultimedia.EncodingQuality] = ...
        VeryLowQuality: typing.ClassVar[QMultimedia.EncodingQuality] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMultimedia.EncodingQuality: ...
        def __and__(self, other: typing.SupportsInt) -> QMultimedia.EncodingQuality: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMultimedia.EncodingQuality: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMultimedia.EncodingQuality: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QMultimedia.EncodingQuality: ...
        def __rand__(self, other: typing.SupportsInt) -> QMultimedia.EncodingQuality: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMultimedia.EncodingQuality: ...
        def __ror__(self, other: typing.SupportsInt) -> QMultimedia.EncodingQuality: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMultimedia.EncodingQuality: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMultimedia.EncodingQuality: ...
        def __sub__(self, other: typing.SupportsInt) -> QMultimedia.EncodingQuality: ...
        def __xor__(self, other: typing.SupportsInt) -> QMultimedia.EncodingQuality: ...

    class SupportEstimate:
        MaybeSupported: typing.ClassVar[QMultimedia.SupportEstimate] = ...
        NotSupported: typing.ClassVar[QMultimedia.SupportEstimate] = ...
        PreferredService: typing.ClassVar[QMultimedia.SupportEstimate] = ...
        ProbablySupported: typing.ClassVar[QMultimedia.SupportEstimate] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMultimedia.SupportEstimate: ...
        def __and__(self, other: typing.SupportsInt) -> QMultimedia.SupportEstimate: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMultimedia.SupportEstimate: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMultimedia.SupportEstimate: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QMultimedia.SupportEstimate: ...
        def __rand__(self, other: typing.SupportsInt) -> QMultimedia.SupportEstimate: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMultimedia.SupportEstimate: ...
        def __ror__(self, other: typing.SupportsInt) -> QMultimedia.SupportEstimate: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMultimedia.SupportEstimate: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMultimedia.SupportEstimate: ...
        def __sub__(self, other: typing.SupportsInt) -> QMultimedia.SupportEstimate: ...
        def __xor__(self, other: typing.SupportsInt) -> QMultimedia.SupportEstimate: ...
    Available: typing.ClassVar[QMultimedia.AvailabilityStatus] = ...
    AverageBitRateEncoding: typing.ClassVar[QMultimedia.EncodingMode] = ...
    Busy: typing.ClassVar[QMultimedia.AvailabilityStatus] = ...
    ConstantBitRateEncoding: typing.ClassVar[QMultimedia.EncodingMode] = ...
    ConstantQualityEncoding: typing.ClassVar[QMultimedia.EncodingMode] = ...
    HighQuality: typing.ClassVar[QMultimedia.EncodingQuality] = ...
    LowQuality: typing.ClassVar[QMultimedia.EncodingQuality] = ...
    MaybeSupported: typing.ClassVar[QMultimedia.SupportEstimate] = ...
    NormalQuality: typing.ClassVar[QMultimedia.EncodingQuality] = ...
    NotSupported: typing.ClassVar[QMultimedia.SupportEstimate] = ...
    PreferredService: typing.ClassVar[QMultimedia.SupportEstimate] = ...
    ProbablySupported: typing.ClassVar[QMultimedia.SupportEstimate] = ...
    ResourceError: typing.ClassVar[QMultimedia.AvailabilityStatus] = ...
    ServiceMissing: typing.ClassVar[QMultimedia.AvailabilityStatus] = ...
    TwoPassEncoding: typing.ClassVar[QMultimedia.EncodingMode] = ...
    VeryHighQuality: typing.ClassVar[QMultimedia.EncodingQuality] = ...
    VeryLowQuality: typing.ClassVar[QMultimedia.EncodingQuality] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...

class QRadioData(PySide2.QtCore.QObject, QMediaBindableInterface):
    class Error:
        NoError: typing.ClassVar[QRadioData.Error] = ...
        OpenError: typing.ClassVar[QRadioData.Error] = ...
        OutOfRangeError: typing.ClassVar[QRadioData.Error] = ...
        ResourceError: typing.ClassVar[QRadioData.Error] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QRadioData.Error: ...
        def __and__(self, other: typing.SupportsInt) -> QRadioData.Error: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QRadioData.Error: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QRadioData.Error: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QRadioData.Error: ...
        def __rand__(self, other: typing.SupportsInt) -> QRadioData.Error: ...
        def __rmul__(self, other: typing.SupportsInt) -> QRadioData.Error: ...
        def __ror__(self, other: typing.SupportsInt) -> QRadioData.Error: ...
        def __rsub__(self, other: typing.SupportsInt) -> QRadioData.Error: ...
        def __rxor__(self, other: typing.SupportsInt) -> QRadioData.Error: ...
        def __sub__(self, other: typing.SupportsInt) -> QRadioData.Error: ...
        def __xor__(self, other: typing.SupportsInt) -> QRadioData.Error: ...

    class ProgramType:
        AdultHits: typing.ClassVar[QRadioData.ProgramType] = ...
        Alarm: typing.ClassVar[QRadioData.ProgramType] = ...
        AlarmTest: typing.ClassVar[QRadioData.ProgramType] = ...
        ChildrensProgrammes: typing.ClassVar[QRadioData.ProgramType] = ...
        ClassicRock: typing.ClassVar[QRadioData.ProgramType] = ...
        Classical: typing.ClassVar[QRadioData.ProgramType] = ...
        College: typing.ClassVar[QRadioData.ProgramType] = ...
        CountryMusic: typing.ClassVar[QRadioData.ProgramType] = ...
        Culture: typing.ClassVar[QRadioData.ProgramType] = ...
        CurrentAffairs: typing.ClassVar[QRadioData.ProgramType] = ...
        Documentary: typing.ClassVar[QRadioData.ProgramType] = ...
        Drama: typing.ClassVar[QRadioData.ProgramType] = ...
        EasyListening: typing.ClassVar[QRadioData.ProgramType] = ...
        Education: typing.ClassVar[QRadioData.ProgramType] = ...
        Finance: typing.ClassVar[QRadioData.ProgramType] = ...
        FolkMusic: typing.ClassVar[QRadioData.ProgramType] = ...
        Information: typing.ClassVar[QRadioData.ProgramType] = ...
        JazzMusic: typing.ClassVar[QRadioData.ProgramType] = ...
        Language: typing.ClassVar[QRadioData.ProgramType] = ...
        Leisure: typing.ClassVar[QRadioData.ProgramType] = ...
        LightClassical: typing.ClassVar[QRadioData.ProgramType] = ...
        NationalMusic: typing.ClassVar[QRadioData.ProgramType] = ...
        News: typing.ClassVar[QRadioData.ProgramType] = ...
        Nostalgia: typing.ClassVar[QRadioData.ProgramType] = ...
        OldiesMusic: typing.ClassVar[QRadioData.ProgramType] = ...
        OtherMusic: typing.ClassVar[QRadioData.ProgramType] = ...
        Personality: typing.ClassVar[QRadioData.ProgramType] = ...
        PhoneIn: typing.ClassVar[QRadioData.ProgramType] = ...
        PopMusic: typing.ClassVar[QRadioData.ProgramType] = ...
        Public: typing.ClassVar[QRadioData.ProgramType] = ...
        Religion: typing.ClassVar[QRadioData.ProgramType] = ...
        ReligiousMusic: typing.ClassVar[QRadioData.ProgramType] = ...
        ReligiousTalk: typing.ClassVar[QRadioData.ProgramType] = ...
        RhythmAndBlues: typing.ClassVar[QRadioData.ProgramType] = ...
        RockMusic: typing.ClassVar[QRadioData.ProgramType] = ...
        Science: typing.ClassVar[QRadioData.ProgramType] = ...
        SeriousClassical: typing.ClassVar[QRadioData.ProgramType] = ...
        SocialAffairs: typing.ClassVar[QRadioData.ProgramType] = ...
        Soft: typing.ClassVar[QRadioData.ProgramType] = ...
        SoftRhythmAndBlues: typing.ClassVar[QRadioData.ProgramType] = ...
        SoftRock: typing.ClassVar[QRadioData.ProgramType] = ...
        Sport: typing.ClassVar[QRadioData.ProgramType] = ...
        Talk: typing.ClassVar[QRadioData.ProgramType] = ...
        Top40: typing.ClassVar[QRadioData.ProgramType] = ...
        Travel: typing.ClassVar[QRadioData.ProgramType] = ...
        Undefined: typing.ClassVar[QRadioData.ProgramType] = ...
        Varied: typing.ClassVar[QRadioData.ProgramType] = ...
        Weather: typing.ClassVar[QRadioData.ProgramType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QRadioData.ProgramType: ...
        def __and__(self, other: typing.SupportsInt) -> QRadioData.ProgramType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QRadioData.ProgramType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QRadioData.ProgramType: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QRadioData.ProgramType: ...
        def __rand__(self, other: typing.SupportsInt) -> QRadioData.ProgramType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QRadioData.ProgramType: ...
        def __ror__(self, other: typing.SupportsInt) -> QRadioData.ProgramType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QRadioData.ProgramType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QRadioData.ProgramType: ...
        def __sub__(self, other: typing.SupportsInt) -> QRadioData.ProgramType: ...
        def __xor__(self, other: typing.SupportsInt) -> QRadioData.ProgramType: ...
    AdultHits: typing.ClassVar[QRadioData.ProgramType] = ...
    Alarm: typing.ClassVar[QRadioData.ProgramType] = ...
    AlarmTest: typing.ClassVar[QRadioData.ProgramType] = ...
    ChildrensProgrammes: typing.ClassVar[QRadioData.ProgramType] = ...
    ClassicRock: typing.ClassVar[QRadioData.ProgramType] = ...
    Classical: typing.ClassVar[QRadioData.ProgramType] = ...
    College: typing.ClassVar[QRadioData.ProgramType] = ...
    CountryMusic: typing.ClassVar[QRadioData.ProgramType] = ...
    Culture: typing.ClassVar[QRadioData.ProgramType] = ...
    CurrentAffairs: typing.ClassVar[QRadioData.ProgramType] = ...
    Documentary: typing.ClassVar[QRadioData.ProgramType] = ...
    Drama: typing.ClassVar[QRadioData.ProgramType] = ...
    EasyListening: typing.ClassVar[QRadioData.ProgramType] = ...
    Education: typing.ClassVar[QRadioData.ProgramType] = ...
    Finance: typing.ClassVar[QRadioData.ProgramType] = ...
    FolkMusic: typing.ClassVar[QRadioData.ProgramType] = ...
    Information: typing.ClassVar[QRadioData.ProgramType] = ...
    JazzMusic: typing.ClassVar[QRadioData.ProgramType] = ...
    Language: typing.ClassVar[QRadioData.ProgramType] = ...
    Leisure: typing.ClassVar[QRadioData.ProgramType] = ...
    LightClassical: typing.ClassVar[QRadioData.ProgramType] = ...
    NationalMusic: typing.ClassVar[QRadioData.ProgramType] = ...
    News: typing.ClassVar[QRadioData.ProgramType] = ...
    NoError: typing.ClassVar[QRadioData.Error] = ...
    Nostalgia: typing.ClassVar[QRadioData.ProgramType] = ...
    OldiesMusic: typing.ClassVar[QRadioData.ProgramType] = ...
    OpenError: typing.ClassVar[QRadioData.Error] = ...
    OtherMusic: typing.ClassVar[QRadioData.ProgramType] = ...
    OutOfRangeError: typing.ClassVar[QRadioData.Error] = ...
    Personality: typing.ClassVar[QRadioData.ProgramType] = ...
    PhoneIn: typing.ClassVar[QRadioData.ProgramType] = ...
    PopMusic: typing.ClassVar[QRadioData.ProgramType] = ...
    Public: typing.ClassVar[QRadioData.ProgramType] = ...
    Religion: typing.ClassVar[QRadioData.ProgramType] = ...
    ReligiousMusic: typing.ClassVar[QRadioData.ProgramType] = ...
    ReligiousTalk: typing.ClassVar[QRadioData.ProgramType] = ...
    ResourceError: typing.ClassVar[QRadioData.Error] = ...
    RhythmAndBlues: typing.ClassVar[QRadioData.ProgramType] = ...
    RockMusic: typing.ClassVar[QRadioData.ProgramType] = ...
    Science: typing.ClassVar[QRadioData.ProgramType] = ...
    SeriousClassical: typing.ClassVar[QRadioData.ProgramType] = ...
    SocialAffairs: typing.ClassVar[QRadioData.ProgramType] = ...
    Soft: typing.ClassVar[QRadioData.ProgramType] = ...
    SoftRhythmAndBlues: typing.ClassVar[QRadioData.ProgramType] = ...
    SoftRock: typing.ClassVar[QRadioData.ProgramType] = ...
    Sport: typing.ClassVar[QRadioData.ProgramType] = ...
    Talk: typing.ClassVar[QRadioData.ProgramType] = ...
    Top40: typing.ClassVar[QRadioData.ProgramType] = ...
    Travel: typing.ClassVar[QRadioData.ProgramType] = ...
    Undefined: typing.ClassVar[QRadioData.ProgramType] = ...
    Varied: typing.ClassVar[QRadioData.ProgramType] = ...
    Weather: typing.ClassVar[QRadioData.ProgramType] = ...
    alternativeFrequenciesEnabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    programTypeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    programTypeNameChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    radioTextChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    stationIdChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stationNameChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, mediaObject: QMediaObject, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def availability(self) -> QMultimedia.AvailabilityStatus: ...
    def errorString(self) -> str: ...
    def isAlternativeFrequenciesEnabled(self) -> bool: ...
    def mediaObject(self) -> QMediaObject: ...
    def programType(self) -> QRadioData.ProgramType: ...
    def programTypeName(self) -> str: ...
    def radioText(self) -> str: ...
    def setAlternativeFrequenciesEnabled(self, enabled: bool) -> None: ...
    def setMediaObject(self, arg__1: QMediaObject) -> bool: ...
    def stationId(self) -> str: ...
    def stationName(self) -> str: ...

class QRadioDataControl(QMediaControl):
    alternativeFrequenciesEnabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    programTypeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    programTypeNameChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    radioTextChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    stationIdChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stationNameChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def errorString(self) -> str: ...
    def isAlternativeFrequenciesEnabled(self) -> bool: ...
    def programType(self) -> QRadioData.ProgramType: ...
    def programTypeName(self) -> str: ...
    def radioText(self) -> str: ...
    def setAlternativeFrequenciesEnabled(self, enabled: bool) -> None: ...
    def stationId(self) -> str: ...
    def stationName(self) -> str: ...

class QRadioTuner(QMediaObject):
    class Band:
        AM: typing.ClassVar[QRadioTuner.Band] = ...
        FM: typing.ClassVar[QRadioTuner.Band] = ...
        FM2: typing.ClassVar[QRadioTuner.Band] = ...
        LW: typing.ClassVar[QRadioTuner.Band] = ...
        SW: typing.ClassVar[QRadioTuner.Band] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QRadioTuner.Band: ...
        def __and__(self, other: typing.SupportsInt) -> QRadioTuner.Band: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QRadioTuner.Band: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QRadioTuner.Band: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QRadioTuner.Band: ...
        def __rand__(self, other: typing.SupportsInt) -> QRadioTuner.Band: ...
        def __rmul__(self, other: typing.SupportsInt) -> QRadioTuner.Band: ...
        def __ror__(self, other: typing.SupportsInt) -> QRadioTuner.Band: ...
        def __rsub__(self, other: typing.SupportsInt) -> QRadioTuner.Band: ...
        def __rxor__(self, other: typing.SupportsInt) -> QRadioTuner.Band: ...
        def __sub__(self, other: typing.SupportsInt) -> QRadioTuner.Band: ...
        def __xor__(self, other: typing.SupportsInt) -> QRadioTuner.Band: ...

    class Error:
        NoError: typing.ClassVar[QRadioTuner.Error] = ...
        OpenError: typing.ClassVar[QRadioTuner.Error] = ...
        OutOfRangeError: typing.ClassVar[QRadioTuner.Error] = ...
        ResourceError: typing.ClassVar[QRadioTuner.Error] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QRadioTuner.Error: ...
        def __and__(self, other: typing.SupportsInt) -> QRadioTuner.Error: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QRadioTuner.Error: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QRadioTuner.Error: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QRadioTuner.Error: ...
        def __rand__(self, other: typing.SupportsInt) -> QRadioTuner.Error: ...
        def __rmul__(self, other: typing.SupportsInt) -> QRadioTuner.Error: ...
        def __ror__(self, other: typing.SupportsInt) -> QRadioTuner.Error: ...
        def __rsub__(self, other: typing.SupportsInt) -> QRadioTuner.Error: ...
        def __rxor__(self, other: typing.SupportsInt) -> QRadioTuner.Error: ...
        def __sub__(self, other: typing.SupportsInt) -> QRadioTuner.Error: ...
        def __xor__(self, other: typing.SupportsInt) -> QRadioTuner.Error: ...

    class SearchMode:
        SearchFast: typing.ClassVar[QRadioTuner.SearchMode] = ...
        SearchGetStationId: typing.ClassVar[QRadioTuner.SearchMode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QRadioTuner.SearchMode: ...
        def __and__(self, other: typing.SupportsInt) -> QRadioTuner.SearchMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QRadioTuner.SearchMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QRadioTuner.SearchMode: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QRadioTuner.SearchMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QRadioTuner.SearchMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QRadioTuner.SearchMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QRadioTuner.SearchMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QRadioTuner.SearchMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QRadioTuner.SearchMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QRadioTuner.SearchMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QRadioTuner.SearchMode: ...

    class State:
        ActiveState: typing.ClassVar[QRadioTuner.State] = ...
        StoppedState: typing.ClassVar[QRadioTuner.State] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QRadioTuner.State: ...
        def __and__(self, other: typing.SupportsInt) -> QRadioTuner.State: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QRadioTuner.State: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QRadioTuner.State: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QRadioTuner.State: ...
        def __rand__(self, other: typing.SupportsInt) -> QRadioTuner.State: ...
        def __rmul__(self, other: typing.SupportsInt) -> QRadioTuner.State: ...
        def __ror__(self, other: typing.SupportsInt) -> QRadioTuner.State: ...
        def __rsub__(self, other: typing.SupportsInt) -> QRadioTuner.State: ...
        def __rxor__(self, other: typing.SupportsInt) -> QRadioTuner.State: ...
        def __sub__(self, other: typing.SupportsInt) -> QRadioTuner.State: ...
        def __xor__(self, other: typing.SupportsInt) -> QRadioTuner.State: ...

    class StereoMode:
        Auto: typing.ClassVar[QRadioTuner.StereoMode] = ...
        ForceMono: typing.ClassVar[QRadioTuner.StereoMode] = ...
        ForceStereo: typing.ClassVar[QRadioTuner.StereoMode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QRadioTuner.StereoMode: ...
        def __and__(self, other: typing.SupportsInt) -> QRadioTuner.StereoMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QRadioTuner.StereoMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QRadioTuner.StereoMode: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QRadioTuner.StereoMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QRadioTuner.StereoMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QRadioTuner.StereoMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QRadioTuner.StereoMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QRadioTuner.StereoMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QRadioTuner.StereoMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QRadioTuner.StereoMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QRadioTuner.StereoMode: ...
    AM: typing.ClassVar[QRadioTuner.Band] = ...
    ActiveState: typing.ClassVar[QRadioTuner.State] = ...
    Auto: typing.ClassVar[QRadioTuner.StereoMode] = ...
    FM: typing.ClassVar[QRadioTuner.Band] = ...
    FM2: typing.ClassVar[QRadioTuner.Band] = ...
    ForceMono: typing.ClassVar[QRadioTuner.StereoMode] = ...
    ForceStereo: typing.ClassVar[QRadioTuner.StereoMode] = ...
    LW: typing.ClassVar[QRadioTuner.Band] = ...
    NoError: typing.ClassVar[QRadioTuner.Error] = ...
    OpenError: typing.ClassVar[QRadioTuner.Error] = ...
    OutOfRangeError: typing.ClassVar[QRadioTuner.Error] = ...
    ResourceError: typing.ClassVar[QRadioTuner.Error] = ...
    SW: typing.ClassVar[QRadioTuner.Band] = ...
    SearchFast: typing.ClassVar[QRadioTuner.SearchMode] = ...
    SearchGetStationId: typing.ClassVar[QRadioTuner.SearchMode] = ...
    StoppedState: typing.ClassVar[QRadioTuner.State] = ...
    antennaConnectedChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    bandChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    frequencyChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    mutedChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    searchingChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    signalStrengthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    stationFound: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stereoStatusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    volumeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., antennaConnected: bool = ..., antennaConnectedChanged: typing.Callable = ..., availabilityChanged: typing.Callable = ..., band: QRadioTuner.Band = ..., bandChanged: typing.Callable = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., frequency: int = ..., frequencyChanged: typing.Callable = ..., metaDataAvailableChanged: typing.Callable = ..., metaDataChanged: typing.Callable = ..., muted: bool = ..., mutedChanged: typing.Callable = ..., notifyInterval: int = ..., notifyIntervalChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., radioData: QRadioData = ..., searching: bool = ..., searchingChanged: typing.Callable = ..., signalStrength: int = ..., signalStrengthChanged: typing.Callable = ..., state: QRadioTuner.State = ..., stateChanged: typing.Callable = ..., stationFound: typing.Callable = ..., stereo: bool = ..., stereoMode: QRadioTuner.StereoMode = ..., stereoStatusChanged: typing.Callable = ..., volume: int = ..., volumeChanged: typing.Callable = ...) -> None: ...
    def availability(self) -> QMultimedia.AvailabilityStatus: ...
    def band(self) -> QRadioTuner.Band: ...
    def cancelSearch(self) -> None: ...
    def errorString(self) -> str: ...
    def frequency(self) -> int: ...
    def frequencyRange(self, band: QRadioTuner.Band) -> typing.Tuple[int, int]: ...
    def frequencyStep(self, band: QRadioTuner.Band) -> int: ...
    def isAntennaConnected(self) -> bool: ...
    def isBandSupported(self, b: QRadioTuner.Band) -> bool: ...
    def isMuted(self) -> bool: ...
    def isSearching(self) -> bool: ...
    def isStereo(self) -> bool: ...
    def radioData(self) -> QRadioData: ...
    def searchAllStations(self, searchMode: QRadioTuner.SearchMode = ...) -> None: ...
    def searchBackward(self) -> None: ...
    def searchForward(self) -> None: ...
    def setBand(self, band: QRadioTuner.Band) -> None: ...
    def setFrequency(self, frequency: int) -> None: ...
    def setMuted(self, muted: bool) -> None: ...
    def setStereoMode(self, mode: QRadioTuner.StereoMode) -> None: ...
    def setVolume(self, volume: int) -> None: ...
    def signalStrength(self) -> int: ...
    def start(self) -> None: ...
    def state(self) -> QRadioTuner.State: ...
    def stereoMode(self) -> QRadioTuner.StereoMode: ...
    def stop(self) -> None: ...
    def volume(self) -> int: ...

class QRadioTunerControl(QMediaControl):
    antennaConnectedChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    bandChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    frequencyChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    mutedChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    searchingChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    signalStrengthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    stationFound: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stereoStatusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    volumeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def band(self) -> QRadioTuner.Band: ...
    def cancelSearch(self) -> None: ...
    def errorString(self) -> str: ...
    def frequency(self) -> int: ...
    def frequencyRange(self, b: QRadioTuner.Band) -> typing.Tuple[int, int]: ...
    def frequencyStep(self, b: QRadioTuner.Band) -> int: ...
    def isAntennaConnected(self) -> bool: ...
    def isBandSupported(self, b: QRadioTuner.Band) -> bool: ...
    def isMuted(self) -> bool: ...
    def isSearching(self) -> bool: ...
    def isStereo(self) -> bool: ...
    def searchAllStations(self, searchMode: QRadioTuner.SearchMode = ...) -> None: ...
    def searchBackward(self) -> None: ...
    def searchForward(self) -> None: ...
    def setBand(self, b: QRadioTuner.Band) -> None: ...
    def setFrequency(self, frequency: int) -> None: ...
    def setMuted(self, muted: bool) -> None: ...
    def setStereoMode(self, mode: QRadioTuner.StereoMode) -> None: ...
    def setVolume(self, volume: int) -> None: ...
    def signalStrength(self) -> int: ...
    def start(self) -> None: ...
    def state(self) -> QRadioTuner.State: ...
    def stereoMode(self) -> QRadioTuner.StereoMode: ...
    def stop(self) -> None: ...
    def volume(self) -> int: ...

class QSound(PySide2.QtCore.QObject):
    class Loop:
        Infinite: typing.ClassVar[QSound.Loop] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSound.Loop: ...
        def __and__(self, other: typing.SupportsInt) -> QSound.Loop: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSound.Loop: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSound.Loop: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSound.Loop: ...
        def __rand__(self, other: typing.SupportsInt) -> QSound.Loop: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSound.Loop: ...
        def __ror__(self, other: typing.SupportsInt) -> QSound.Loop: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSound.Loop: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSound.Loop: ...
        def __sub__(self, other: typing.SupportsInt) -> QSound.Loop: ...
        def __xor__(self, other: typing.SupportsInt) -> QSound.Loop: ...
    Infinite: typing.ClassVar[QSound.Loop] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, filename: str, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def fileName(self) -> str: ...
    def isFinished(self) -> bool: ...
    def loops(self) -> int: ...
    def loopsRemaining(self) -> int: ...
    @staticmethod
    def play(self) -> None: ...
    def setLoops(self, arg__1: int) -> None: ...
    def stop(self) -> None: ...

class QSoundEffect(PySide2.QtCore.QObject):
    class Loop:
        Infinite: typing.ClassVar[QSoundEffect.Loop] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSoundEffect.Loop: ...
        def __and__(self, other: typing.SupportsInt) -> QSoundEffect.Loop: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSoundEffect.Loop: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSoundEffect.Loop: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSoundEffect.Loop: ...
        def __rand__(self, other: typing.SupportsInt) -> QSoundEffect.Loop: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSoundEffect.Loop: ...
        def __ror__(self, other: typing.SupportsInt) -> QSoundEffect.Loop: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSoundEffect.Loop: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSoundEffect.Loop: ...
        def __sub__(self, other: typing.SupportsInt) -> QSoundEffect.Loop: ...
        def __xor__(self, other: typing.SupportsInt) -> QSoundEffect.Loop: ...

    class Status:
        Error: typing.ClassVar[QSoundEffect.Status] = ...
        Loading: typing.ClassVar[QSoundEffect.Status] = ...
        Null: typing.ClassVar[QSoundEffect.Status] = ...
        Ready: typing.ClassVar[QSoundEffect.Status] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSoundEffect.Status: ...
        def __and__(self, other: typing.SupportsInt) -> QSoundEffect.Status: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSoundEffect.Status: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSoundEffect.Status: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSoundEffect.Status: ...
        def __rand__(self, other: typing.SupportsInt) -> QSoundEffect.Status: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSoundEffect.Status: ...
        def __ror__(self, other: typing.SupportsInt) -> QSoundEffect.Status: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSoundEffect.Status: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSoundEffect.Status: ...
        def __sub__(self, other: typing.SupportsInt) -> QSoundEffect.Status: ...
        def __xor__(self, other: typing.SupportsInt) -> QSoundEffect.Status: ...
    Error: typing.ClassVar[QSoundEffect.Status] = ...
    Infinite: typing.ClassVar[QSoundEffect.Loop] = ...
    Loading: typing.ClassVar[QSoundEffect.Status] = ...
    Null: typing.ClassVar[QSoundEffect.Status] = ...
    Ready: typing.ClassVar[QSoundEffect.Status] = ...
    categoryChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    loadedChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    loopCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    loopsRemainingChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    mutedChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    playingChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sourceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    statusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    volumeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @typing.overload
    def __init__(self, audioDevice: QAudioDeviceInfo, parent: PySide2.QtCore.QObject | None = ..., category: str = ..., categoryChanged: typing.Callable = ..., destroyed: typing.Callable = ..., loadedChanged: typing.Callable = ..., loopCountChanged: typing.Callable = ..., loops: int = ..., loopsRemaining: int = ..., loopsRemainingChanged: typing.Callable = ..., muted: bool = ..., mutedChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., playing: bool = ..., playingChanged: typing.Callable = ..., source: PySide2.QtCore.QUrl = ..., sourceChanged: typing.Callable = ..., status: QSoundEffect.Status = ..., statusChanged: typing.Callable = ..., volume: float = ..., volumeChanged: typing.Callable = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., category: str = ..., categoryChanged: typing.Callable = ..., destroyed: typing.Callable = ..., loadedChanged: typing.Callable = ..., loopCountChanged: typing.Callable = ..., loops: int = ..., loopsRemaining: int = ..., loopsRemainingChanged: typing.Callable = ..., muted: bool = ..., mutedChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., playing: bool = ..., playingChanged: typing.Callable = ..., source: PySide2.QtCore.QUrl = ..., sourceChanged: typing.Callable = ..., status: QSoundEffect.Status = ..., statusChanged: typing.Callable = ..., volume: float = ..., volumeChanged: typing.Callable = ...) -> None: ...
    def category(self) -> str: ...
    def isLoaded(self) -> bool: ...
    def isMuted(self) -> bool: ...
    def isPlaying(self) -> bool: ...
    def loopCount(self) -> int: ...
    def loopsRemaining(self) -> int: ...
    def play(self) -> None: ...
    def setCategory(self, category: str) -> None: ...
    def setLoopCount(self, loopCount: int) -> None: ...
    def setMuted(self, muted: bool) -> None: ...
    def setSource(self, url: PySide2.QtCore.QUrl) -> None: ...
    def setVolume(self, volume: float) -> None: ...
    def source(self) -> PySide2.QtCore.QUrl: ...
    def status(self) -> QSoundEffect.Status: ...
    def stop(self) -> None: ...
    @staticmethod
    def supportedMimeTypes() -> typing.List[str]: ...
    def volume(self) -> float: ...

class QVideoDeviceSelectorControl(QMediaControl):
    devicesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    selectedDeviceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def defaultDevice(self) -> int: ...
    def deviceCount(self) -> int: ...
    def deviceDescription(self, index: int) -> str: ...
    def deviceName(self, index: int) -> str: ...
    def selectedDevice(self) -> int: ...
    def setSelectedDevice(self, index: int) -> None: ...

class QVideoEncoderSettings(shiboken2.Object):
    @typing.overload
    def __init__(self, other: QVideoEncoderSettings) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def bitRate(self) -> int: ...
    def codec(self) -> str: ...
    def encodingMode(self) -> QMultimedia.EncodingMode: ...
    def encodingOption(self, option: str) -> typing.Any: ...
    def encodingOptions(self) -> typing.Dict[str, typing.Any]: ...
    def frameRate(self) -> float: ...
    def isNull(self) -> bool: ...
    def quality(self) -> QMultimedia.EncodingQuality: ...
    def resolution(self) -> PySide2.QtCore.QSize: ...
    def setBitRate(self, bitrate: int) -> None: ...
    def setCodec(self, arg__1: str) -> None: ...
    def setEncodingMode(self, arg__1: QMultimedia.EncodingMode) -> None: ...
    def setEncodingOption(self, option: str, value: typing.Any) -> None: ...
    def setEncodingOptions(self, options: typing.Dict[str, typing.Any]) -> None: ...
    def setFrameRate(self, rate: float) -> None: ...
    def setQuality(self, quality: QMultimedia.EncodingQuality) -> None: ...
    @typing.overload
    def setResolution(self, width: int, height: int) -> None: ...
    @typing.overload
    def setResolution(self, arg__1: PySide2.QtCore.QSize) -> None: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QVideoEncoderSettingsControl(QMediaControl):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def setVideoSettings(self, settings: QVideoEncoderSettings) -> None: ...
    def supportedVideoCodecs(self) -> typing.List[str]: ...
    def videoCodecDescription(self, codec: str) -> str: ...
    def videoSettings(self) -> QVideoEncoderSettings: ...

class QVideoFilterRunnable(shiboken2.Object):
    class RunFlag:
        LastInChain: typing.ClassVar[QVideoFilterRunnable.RunFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QVideoFilterRunnable.RunFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QVideoFilterRunnable.RunFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QVideoFilterRunnable.RunFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QVideoFilterRunnable.RunFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QVideoFilterRunnable.RunFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QVideoFilterRunnable.RunFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QVideoFilterRunnable.RunFlags: ...

    class RunFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QVideoFilterRunnable.RunFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QVideoFilterRunnable.RunFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QVideoFilterRunnable.RunFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QVideoFilterRunnable.RunFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QVideoFilterRunnable.RunFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QVideoFilterRunnable.RunFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QVideoFilterRunnable.RunFlags: ...
    LastInChain: typing.ClassVar[QVideoFilterRunnable.RunFlag] = ...
    def __init__(self) -> None: ...
    def run(self, input: QVideoFrame, surfaceFormat: QVideoSurfaceFormat, flags: QVideoFilterRunnable.RunFlags | QVideoFilterRunnable.RunFlag) -> QVideoFrame: ...

class QVideoFrame(shiboken2.Object):
    class FieldType:
        BottomField: typing.ClassVar[QVideoFrame.FieldType] = ...
        InterlacedFrame: typing.ClassVar[QVideoFrame.FieldType] = ...
        ProgressiveFrame: typing.ClassVar[QVideoFrame.FieldType] = ...
        TopField: typing.ClassVar[QVideoFrame.FieldType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QVideoFrame.FieldType: ...
        def __and__(self, other: typing.SupportsInt) -> QVideoFrame.FieldType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QVideoFrame.FieldType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QVideoFrame.FieldType: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QVideoFrame.FieldType: ...
        def __rand__(self, other: typing.SupportsInt) -> QVideoFrame.FieldType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QVideoFrame.FieldType: ...
        def __ror__(self, other: typing.SupportsInt) -> QVideoFrame.FieldType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QVideoFrame.FieldType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QVideoFrame.FieldType: ...
        def __sub__(self, other: typing.SupportsInt) -> QVideoFrame.FieldType: ...
        def __xor__(self, other: typing.SupportsInt) -> QVideoFrame.FieldType: ...

    class PixelFormat:
        Format_ABGR32: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_ARGB32: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_ARGB32_Premultiplied: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_ARGB8565_Premultiplied: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_AYUV444: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_AYUV444_Premultiplied: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_AdobeDng: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_BGR24: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_BGR32: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_BGR555: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_BGR565: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_BGRA32: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_BGRA32_Premultiplied: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_BGRA5658_Premultiplied: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_CameraRaw: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_IMC1: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_IMC2: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_IMC3: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_IMC4: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_Invalid: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_Jpeg: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_NV12: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_NV21: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_RGB24: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_RGB32: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_RGB555: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_RGB565: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_UYVY: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_User: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_Y16: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_Y8: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_YUV420P: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_YUV422P: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_YUV444: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_YUYV: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        Format_YV12: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        NPixelFormats: typing.ClassVar[QVideoFrame.PixelFormat] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QVideoFrame.PixelFormat: ...
        def __and__(self, other: typing.SupportsInt) -> QVideoFrame.PixelFormat: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QVideoFrame.PixelFormat: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QVideoFrame.PixelFormat: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QVideoFrame.PixelFormat: ...
        def __rand__(self, other: typing.SupportsInt) -> QVideoFrame.PixelFormat: ...
        def __rmul__(self, other: typing.SupportsInt) -> QVideoFrame.PixelFormat: ...
        def __ror__(self, other: typing.SupportsInt) -> QVideoFrame.PixelFormat: ...
        def __rsub__(self, other: typing.SupportsInt) -> QVideoFrame.PixelFormat: ...
        def __rxor__(self, other: typing.SupportsInt) -> QVideoFrame.PixelFormat: ...
        def __sub__(self, other: typing.SupportsInt) -> QVideoFrame.PixelFormat: ...
        def __xor__(self, other: typing.SupportsInt) -> QVideoFrame.PixelFormat: ...
    BottomField: typing.ClassVar[QVideoFrame.FieldType] = ...
    Format_ABGR32: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_ARGB32: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_ARGB32_Premultiplied: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_ARGB8565_Premultiplied: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_AYUV444: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_AYUV444_Premultiplied: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_AdobeDng: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_BGR24: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_BGR32: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_BGR555: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_BGR565: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_BGRA32: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_BGRA32_Premultiplied: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_BGRA5658_Premultiplied: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_CameraRaw: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_IMC1: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_IMC2: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_IMC3: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_IMC4: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_Invalid: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_Jpeg: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_NV12: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_NV21: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_RGB24: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_RGB32: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_RGB555: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_RGB565: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_UYVY: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_User: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_Y16: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_Y8: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_YUV420P: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_YUV422P: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_YUV444: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_YUYV: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    Format_YV12: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    InterlacedFrame: typing.ClassVar[QVideoFrame.FieldType] = ...
    NPixelFormats: typing.ClassVar[QVideoFrame.PixelFormat] = ...
    ProgressiveFrame: typing.ClassVar[QVideoFrame.FieldType] = ...
    TopField: typing.ClassVar[QVideoFrame.FieldType] = ...
    @typing.overload
    def __init__(self, bytes: int, size: PySide2.QtCore.QSize, bytesPerLine: int, format: QVideoFrame.PixelFormat) -> None: ...
    @typing.overload
    def __init__(self, buffer: QAbstractVideoBuffer, size: PySide2.QtCore.QSize, format: QVideoFrame.PixelFormat) -> None: ...
    @typing.overload
    def __init__(self, other: QVideoFrame) -> None: ...
    @typing.overload
    def __init__(self, image: PySide2.QtGui.QImage) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def availableMetaData(self) -> typing.Dict[str, typing.Any]: ...
    def bits(self) -> bytes: ...
    def buffer(self) -> QAbstractVideoBuffer: ...
    @typing.overload
    def bytesPerLine(self, plane: int) -> int: ...
    @typing.overload
    def bytesPerLine(self) -> int: ...
    def endTime(self) -> int: ...
    def fieldType(self) -> QVideoFrame.FieldType: ...
    def handle(self) -> typing.Any: ...
    def handleType(self) -> QAbstractVideoBuffer.HandleType: ...
    def height(self) -> int: ...
    def image(self) -> PySide2.QtGui.QImage: ...
    @staticmethod
    def imageFormatFromPixelFormat(format: QVideoFrame.PixelFormat) -> PySide2.QtGui.QImage.Format: ...
    def isMapped(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isValid(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def map(self, mode: QAbstractVideoBuffer.MapMode) -> bool: ...
    def mapMode(self) -> QAbstractVideoBuffer.MapMode: ...
    def mappedBytes(self) -> int: ...
    def metaData(self, key: str) -> typing.Any: ...
    def pixelFormat(self) -> QVideoFrame.PixelFormat: ...
    @staticmethod
    def pixelFormatFromImageFormat(format: PySide2.QtGui.QImage.Format) -> QVideoFrame.PixelFormat: ...
    def planeCount(self) -> int: ...
    def setEndTime(self, time: int) -> None: ...
    def setFieldType(self, arg__1: QVideoFrame.FieldType) -> None: ...
    def setMetaData(self, key: str, value: typing.Any) -> None: ...
    def setStartTime(self, time: int) -> None: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def startTime(self) -> int: ...
    def unmap(self) -> None: ...
    def width(self) -> int: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QVideoProbe(PySide2.QtCore.QObject):
    flush: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    videoFrameProbed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., flush: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., videoFrameProbed: typing.Callable = ...) -> None: ...
    def isActive(self) -> bool: ...
    @typing.overload
    def setSource(self, source: QMediaObject) -> bool: ...
    @typing.overload
    def setSource(self, source: QMediaRecorder) -> bool: ...

class QVideoRendererControl(QMediaControl):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def setSurface(self, surface: QAbstractVideoSurface) -> None: ...
    def surface(self) -> QAbstractVideoSurface: ...

class QVideoSurfaceFormat(shiboken2.Object):
    class Direction:
        BottomToTop: typing.ClassVar[QVideoSurfaceFormat.Direction] = ...
        TopToBottom: typing.ClassVar[QVideoSurfaceFormat.Direction] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QVideoSurfaceFormat.Direction: ...
        def __and__(self, other: typing.SupportsInt) -> QVideoSurfaceFormat.Direction: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QVideoSurfaceFormat.Direction: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QVideoSurfaceFormat.Direction: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QVideoSurfaceFormat.Direction: ...
        def __rand__(self, other: typing.SupportsInt) -> QVideoSurfaceFormat.Direction: ...
        def __rmul__(self, other: typing.SupportsInt) -> QVideoSurfaceFormat.Direction: ...
        def __ror__(self, other: typing.SupportsInt) -> QVideoSurfaceFormat.Direction: ...
        def __rsub__(self, other: typing.SupportsInt) -> QVideoSurfaceFormat.Direction: ...
        def __rxor__(self, other: typing.SupportsInt) -> QVideoSurfaceFormat.Direction: ...
        def __sub__(self, other: typing.SupportsInt) -> QVideoSurfaceFormat.Direction: ...
        def __xor__(self, other: typing.SupportsInt) -> QVideoSurfaceFormat.Direction: ...

    class YCbCrColorSpace:
        YCbCr_BT601: typing.ClassVar[QVideoSurfaceFormat.YCbCrColorSpace] = ...
        YCbCr_BT709: typing.ClassVar[QVideoSurfaceFormat.YCbCrColorSpace] = ...
        YCbCr_CustomMatrix: typing.ClassVar[QVideoSurfaceFormat.YCbCrColorSpace] = ...
        YCbCr_JPEG: typing.ClassVar[QVideoSurfaceFormat.YCbCrColorSpace] = ...
        YCbCr_Undefined: typing.ClassVar[QVideoSurfaceFormat.YCbCrColorSpace] = ...
        YCbCr_xvYCC601: typing.ClassVar[QVideoSurfaceFormat.YCbCrColorSpace] = ...
        YCbCr_xvYCC709: typing.ClassVar[QVideoSurfaceFormat.YCbCrColorSpace] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QVideoSurfaceFormat.YCbCrColorSpace: ...
        def __and__(self, other: typing.SupportsInt) -> QVideoSurfaceFormat.YCbCrColorSpace: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QVideoSurfaceFormat.YCbCrColorSpace: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QVideoSurfaceFormat.YCbCrColorSpace: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QVideoSurfaceFormat.YCbCrColorSpace: ...
        def __rand__(self, other: typing.SupportsInt) -> QVideoSurfaceFormat.YCbCrColorSpace: ...
        def __rmul__(self, other: typing.SupportsInt) -> QVideoSurfaceFormat.YCbCrColorSpace: ...
        def __ror__(self, other: typing.SupportsInt) -> QVideoSurfaceFormat.YCbCrColorSpace: ...
        def __rsub__(self, other: typing.SupportsInt) -> QVideoSurfaceFormat.YCbCrColorSpace: ...
        def __rxor__(self, other: typing.SupportsInt) -> QVideoSurfaceFormat.YCbCrColorSpace: ...
        def __sub__(self, other: typing.SupportsInt) -> QVideoSurfaceFormat.YCbCrColorSpace: ...
        def __xor__(self, other: typing.SupportsInt) -> QVideoSurfaceFormat.YCbCrColorSpace: ...
    BottomToTop: typing.ClassVar[QVideoSurfaceFormat.Direction] = ...
    TopToBottom: typing.ClassVar[QVideoSurfaceFormat.Direction] = ...
    YCbCr_BT601: typing.ClassVar[QVideoSurfaceFormat.YCbCrColorSpace] = ...
    YCbCr_BT709: typing.ClassVar[QVideoSurfaceFormat.YCbCrColorSpace] = ...
    YCbCr_CustomMatrix: typing.ClassVar[QVideoSurfaceFormat.YCbCrColorSpace] = ...
    YCbCr_JPEG: typing.ClassVar[QVideoSurfaceFormat.YCbCrColorSpace] = ...
    YCbCr_Undefined: typing.ClassVar[QVideoSurfaceFormat.YCbCrColorSpace] = ...
    YCbCr_xvYCC601: typing.ClassVar[QVideoSurfaceFormat.YCbCrColorSpace] = ...
    YCbCr_xvYCC709: typing.ClassVar[QVideoSurfaceFormat.YCbCrColorSpace] = ...
    @typing.overload
    def __init__(self, size: PySide2.QtCore.QSize, pixelFormat: QVideoFrame.PixelFormat, handleType: QAbstractVideoBuffer.HandleType = ...) -> None: ...
    @typing.overload
    def __init__(self, format: QVideoSurfaceFormat) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def frameHeight(self) -> int: ...
    def frameRate(self) -> float: ...
    def frameSize(self) -> PySide2.QtCore.QSize: ...
    def frameWidth(self) -> int: ...
    def handleType(self) -> QAbstractVideoBuffer.HandleType: ...
    def isMirrored(self) -> bool: ...
    def isValid(self) -> bool: ...
    def pixelAspectRatio(self) -> PySide2.QtCore.QSize: ...
    def pixelFormat(self) -> QVideoFrame.PixelFormat: ...
    def property(self, name: bytes) -> typing.Any: ...
    def propertyNames(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def scanLineDirection(self) -> QVideoSurfaceFormat.Direction: ...
    def setFrameRate(self, rate: float) -> None: ...
    @typing.overload
    def setFrameSize(self, width: int, height: int) -> None: ...
    @typing.overload
    def setFrameSize(self, size: PySide2.QtCore.QSize) -> None: ...
    def setMirrored(self, mirrored: bool) -> None: ...
    @typing.overload
    def setPixelAspectRatio(self, width: int, height: int) -> None: ...
    @typing.overload
    def setPixelAspectRatio(self, ratio: PySide2.QtCore.QSize) -> None: ...
    def setProperty(self, name: bytes, value: typing.Any) -> None: ...
    def setScanLineDirection(self, direction: QVideoSurfaceFormat.Direction) -> None: ...
    def setViewport(self, viewport: PySide2.QtCore.QRect) -> None: ...
    def setYCbCrColorSpace(self, colorSpace: QVideoSurfaceFormat.YCbCrColorSpace) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def viewport(self) -> PySide2.QtCore.QRect: ...
    def yCbCrColorSpace(self) -> QVideoSurfaceFormat.YCbCrColorSpace: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QVideoWindowControl(QMediaControl):
    brightnessChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    contrastChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    fullScreenChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    hueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    nativeSizeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    saturationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def aspectRatioMode(self) -> PySide2.QtCore.Qt.AspectRatioMode: ...
    def brightness(self) -> int: ...
    def contrast(self) -> int: ...
    def displayRect(self) -> PySide2.QtCore.QRect: ...
    def hue(self) -> int: ...
    def isFullScreen(self) -> bool: ...
    def nativeSize(self) -> PySide2.QtCore.QSize: ...
    def repaint(self) -> None: ...
    def saturation(self) -> int: ...
    def setAspectRatioMode(self, mode: PySide2.QtCore.Qt.AspectRatioMode) -> None: ...
    def setBrightness(self, brightness: int) -> None: ...
    def setContrast(self, contrast: int) -> None: ...
    def setDisplayRect(self, rect: PySide2.QtCore.QRect) -> None: ...
    def setFullScreen(self, fullScreen: bool) -> None: ...
    def setHue(self, hue: int) -> None: ...
    def setSaturation(self, saturation: int) -> None: ...
    def setWinId(self, id: int) -> None: ...
    def winId(self) -> int: ...
