import PySide2.QtCore
import _typeshed
import collections
import datetime
import shiboken2
import typing
T = typing.TypeVar('T')
import typing_extensions

class QAbstractNetworkCache(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def cacheSize(self) -> int: ...
    def clear(self) -> None: ...
    def data(self, url: PySide2.QtCore.QUrl) -> PySide2.QtCore.QIODevice: ...
    def insert(self, device: PySide2.QtCore.QIODevice) -> None: ...
    def metaData(self, url: PySide2.QtCore.QUrl) -> QNetworkCacheMetaData: ...
    def prepare(self, metaData: QNetworkCacheMetaData) -> PySide2.QtCore.QIODevice: ...
    def remove(self, url: PySide2.QtCore.QUrl) -> bool: ...
    def updateMetaData(self, metaData: QNetworkCacheMetaData) -> None: ...

class QAbstractSocket(PySide2.QtCore.QIODevice):
    class BindFlag:
        DefaultForPlatform: typing.ClassVar[QAbstractSocket.BindFlag] = ...
        DontShareAddress: typing.ClassVar[QAbstractSocket.BindFlag] = ...
        ReuseAddressHint: typing.ClassVar[QAbstractSocket.BindFlag] = ...
        ShareAddress: typing.ClassVar[QAbstractSocket.BindFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractSocket.BindMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QAbstractSocket.BindMode: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractSocket.BindMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractSocket.BindMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractSocket.BindMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractSocket.BindMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractSocket.BindMode: ...

    class BindMode:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractSocket.BindMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QAbstractSocket.BindMode: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractSocket.BindMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractSocket.BindMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractSocket.BindMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractSocket.BindMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractSocket.BindMode: ...

    class NetworkLayerProtocol:
        AnyIPProtocol: typing.ClassVar[QAbstractSocket.NetworkLayerProtocol] = ...
        IPv4Protocol: typing.ClassVar[QAbstractSocket.NetworkLayerProtocol] = ...
        IPv6Protocol: typing.ClassVar[QAbstractSocket.NetworkLayerProtocol] = ...
        UnknownNetworkLayerProtocol: typing.ClassVar[QAbstractSocket.NetworkLayerProtocol] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractSocket.NetworkLayerProtocol: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractSocket.NetworkLayerProtocol: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractSocket.NetworkLayerProtocol: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractSocket.NetworkLayerProtocol: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractSocket.NetworkLayerProtocol: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractSocket.NetworkLayerProtocol: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractSocket.NetworkLayerProtocol: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractSocket.NetworkLayerProtocol: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractSocket.NetworkLayerProtocol: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractSocket.NetworkLayerProtocol: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractSocket.NetworkLayerProtocol: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractSocket.NetworkLayerProtocol: ...

    class PauseMode:
        PauseNever: typing.ClassVar[QAbstractSocket.PauseMode] = ...
        PauseOnSslErrors: typing.ClassVar[QAbstractSocket.PauseMode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractSocket.PauseModes: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QAbstractSocket.PauseModes: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractSocket.PauseModes: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractSocket.PauseModes: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractSocket.PauseModes: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractSocket.PauseModes: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractSocket.PauseModes: ...

    class PauseModes:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractSocket.PauseModes: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QAbstractSocket.PauseModes: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractSocket.PauseModes: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractSocket.PauseModes: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractSocket.PauseModes: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractSocket.PauseModes: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractSocket.PauseModes: ...

    class SocketError:
        AddressInUseError: typing.ClassVar[QAbstractSocket.SocketError] = ...
        ConnectionRefusedError: typing.ClassVar[QAbstractSocket.SocketError] = ...
        DatagramTooLargeError: typing.ClassVar[QAbstractSocket.SocketError] = ...
        HostNotFoundError: typing.ClassVar[QAbstractSocket.SocketError] = ...
        NetworkError: typing.ClassVar[QAbstractSocket.SocketError] = ...
        OperationError: typing.ClassVar[QAbstractSocket.SocketError] = ...
        ProxyAuthenticationRequiredError: typing.ClassVar[QAbstractSocket.SocketError] = ...
        ProxyConnectionClosedError: typing.ClassVar[QAbstractSocket.SocketError] = ...
        ProxyConnectionRefusedError: typing.ClassVar[QAbstractSocket.SocketError] = ...
        ProxyConnectionTimeoutError: typing.ClassVar[QAbstractSocket.SocketError] = ...
        ProxyNotFoundError: typing.ClassVar[QAbstractSocket.SocketError] = ...
        ProxyProtocolError: typing.ClassVar[QAbstractSocket.SocketError] = ...
        RemoteHostClosedError: typing.ClassVar[QAbstractSocket.SocketError] = ...
        SocketAccessError: typing.ClassVar[QAbstractSocket.SocketError] = ...
        SocketAddressNotAvailableError: typing.ClassVar[QAbstractSocket.SocketError] = ...
        SocketResourceError: typing.ClassVar[QAbstractSocket.SocketError] = ...
        SocketTimeoutError: typing.ClassVar[QAbstractSocket.SocketError] = ...
        SslHandshakeFailedError: typing.ClassVar[QAbstractSocket.SocketError] = ...
        SslInternalError: typing.ClassVar[QAbstractSocket.SocketError] = ...
        SslInvalidUserDataError: typing.ClassVar[QAbstractSocket.SocketError] = ...
        TemporaryError: typing.ClassVar[QAbstractSocket.SocketError] = ...
        UnfinishedSocketOperationError: typing.ClassVar[QAbstractSocket.SocketError] = ...
        UnknownSocketError: typing.ClassVar[QAbstractSocket.SocketError] = ...
        UnsupportedSocketOperationError: typing.ClassVar[QAbstractSocket.SocketError] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketError: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketError: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketError: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketError: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketError: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketError: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketError: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketError: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketError: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketError: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketError: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketError: ...

    class SocketOption:
        KeepAliveOption: typing.ClassVar[QAbstractSocket.SocketOption] = ...
        LowDelayOption: typing.ClassVar[QAbstractSocket.SocketOption] = ...
        MulticastLoopbackOption: typing.ClassVar[QAbstractSocket.SocketOption] = ...
        MulticastTtlOption: typing.ClassVar[QAbstractSocket.SocketOption] = ...
        PathMtuSocketOption: typing.ClassVar[QAbstractSocket.SocketOption] = ...
        ReceiveBufferSizeSocketOption: typing.ClassVar[QAbstractSocket.SocketOption] = ...
        SendBufferSizeSocketOption: typing.ClassVar[QAbstractSocket.SocketOption] = ...
        TypeOfServiceOption: typing.ClassVar[QAbstractSocket.SocketOption] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketOption: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketOption: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketOption: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketOption: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketOption: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketOption: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketOption: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketOption: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketOption: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketOption: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketOption: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketOption: ...

    class SocketState:
        BoundState: typing.ClassVar[QAbstractSocket.SocketState] = ...
        ClosingState: typing.ClassVar[QAbstractSocket.SocketState] = ...
        ConnectedState: typing.ClassVar[QAbstractSocket.SocketState] = ...
        ConnectingState: typing.ClassVar[QAbstractSocket.SocketState] = ...
        HostLookupState: typing.ClassVar[QAbstractSocket.SocketState] = ...
        ListeningState: typing.ClassVar[QAbstractSocket.SocketState] = ...
        UnconnectedState: typing.ClassVar[QAbstractSocket.SocketState] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketState: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketState: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketState: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketState: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketState: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketState: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketState: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketState: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketState: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketState: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketState: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketState: ...

    class SocketType:
        SctpSocket: typing.ClassVar[QAbstractSocket.SocketType] = ...
        TcpSocket: typing.ClassVar[QAbstractSocket.SocketType] = ...
        UdpSocket: typing.ClassVar[QAbstractSocket.SocketType] = ...
        UnknownSocketType: typing.ClassVar[QAbstractSocket.SocketType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketType: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketType: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketType: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketType: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketType: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketType: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractSocket.SocketType: ...
    AddressInUseError: typing.ClassVar[QAbstractSocket.SocketError] = ...
    AnyIPProtocol: typing.ClassVar[QAbstractSocket.NetworkLayerProtocol] = ...
    BoundState: typing.ClassVar[QAbstractSocket.SocketState] = ...
    ClosingState: typing.ClassVar[QAbstractSocket.SocketState] = ...
    ConnectedState: typing.ClassVar[QAbstractSocket.SocketState] = ...
    ConnectingState: typing.ClassVar[QAbstractSocket.SocketState] = ...
    ConnectionRefusedError: typing.ClassVar[QAbstractSocket.SocketError] = ...
    DatagramTooLargeError: typing.ClassVar[QAbstractSocket.SocketError] = ...
    DefaultForPlatform: typing.ClassVar[QAbstractSocket.BindFlag] = ...
    DontShareAddress: typing.ClassVar[QAbstractSocket.BindFlag] = ...
    HostLookupState: typing.ClassVar[QAbstractSocket.SocketState] = ...
    HostNotFoundError: typing.ClassVar[QAbstractSocket.SocketError] = ...
    IPv4Protocol: typing.ClassVar[QAbstractSocket.NetworkLayerProtocol] = ...
    IPv6Protocol: typing.ClassVar[QAbstractSocket.NetworkLayerProtocol] = ...
    KeepAliveOption: typing.ClassVar[QAbstractSocket.SocketOption] = ...
    ListeningState: typing.ClassVar[QAbstractSocket.SocketState] = ...
    LowDelayOption: typing.ClassVar[QAbstractSocket.SocketOption] = ...
    MulticastLoopbackOption: typing.ClassVar[QAbstractSocket.SocketOption] = ...
    MulticastTtlOption: typing.ClassVar[QAbstractSocket.SocketOption] = ...
    NetworkError: typing.ClassVar[QAbstractSocket.SocketError] = ...
    OperationError: typing.ClassVar[QAbstractSocket.SocketError] = ...
    PathMtuSocketOption: typing.ClassVar[QAbstractSocket.SocketOption] = ...
    PauseNever: typing.ClassVar[QAbstractSocket.PauseMode] = ...
    PauseOnSslErrors: typing.ClassVar[QAbstractSocket.PauseMode] = ...
    ProxyAuthenticationRequiredError: typing.ClassVar[QAbstractSocket.SocketError] = ...
    ProxyConnectionClosedError: typing.ClassVar[QAbstractSocket.SocketError] = ...
    ProxyConnectionRefusedError: typing.ClassVar[QAbstractSocket.SocketError] = ...
    ProxyConnectionTimeoutError: typing.ClassVar[QAbstractSocket.SocketError] = ...
    ProxyNotFoundError: typing.ClassVar[QAbstractSocket.SocketError] = ...
    ProxyProtocolError: typing.ClassVar[QAbstractSocket.SocketError] = ...
    ReceiveBufferSizeSocketOption: typing.ClassVar[QAbstractSocket.SocketOption] = ...
    RemoteHostClosedError: typing.ClassVar[QAbstractSocket.SocketError] = ...
    ReuseAddressHint: typing.ClassVar[QAbstractSocket.BindFlag] = ...
    SctpSocket: typing.ClassVar[QAbstractSocket.SocketType] = ...
    SendBufferSizeSocketOption: typing.ClassVar[QAbstractSocket.SocketOption] = ...
    ShareAddress: typing.ClassVar[QAbstractSocket.BindFlag] = ...
    SocketAccessError: typing.ClassVar[QAbstractSocket.SocketError] = ...
    SocketAddressNotAvailableError: typing.ClassVar[QAbstractSocket.SocketError] = ...
    SocketResourceError: typing.ClassVar[QAbstractSocket.SocketError] = ...
    SocketTimeoutError: typing.ClassVar[QAbstractSocket.SocketError] = ...
    SslHandshakeFailedError: typing.ClassVar[QAbstractSocket.SocketError] = ...
    SslInternalError: typing.ClassVar[QAbstractSocket.SocketError] = ...
    SslInvalidUserDataError: typing.ClassVar[QAbstractSocket.SocketError] = ...
    TcpSocket: typing.ClassVar[QAbstractSocket.SocketType] = ...
    TemporaryError: typing.ClassVar[QAbstractSocket.SocketError] = ...
    TypeOfServiceOption: typing.ClassVar[QAbstractSocket.SocketOption] = ...
    UdpSocket: typing.ClassVar[QAbstractSocket.SocketType] = ...
    UnconnectedState: typing.ClassVar[QAbstractSocket.SocketState] = ...
    UnfinishedSocketOperationError: typing.ClassVar[QAbstractSocket.SocketError] = ...
    UnknownNetworkLayerProtocol: typing.ClassVar[QAbstractSocket.NetworkLayerProtocol] = ...
    UnknownSocketError: typing.ClassVar[QAbstractSocket.SocketError] = ...
    UnknownSocketType: typing.ClassVar[QAbstractSocket.SocketType] = ...
    UnsupportedSocketOperationError: typing.ClassVar[QAbstractSocket.SocketError] = ...
    connected: typing.ClassVar[PySide2.QtCore.Signal] = ...
    disconnected: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    errorOccurred: typing.ClassVar[PySide2.QtCore.Signal] = ...
    hostFound: typing.ClassVar[PySide2.QtCore.Signal] = ...
    proxyAuthenticationRequired: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, socketType: QAbstractSocket.SocketType, parent: PySide2.QtCore.QObject | None, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def abort(self) -> None: ...
    def atEnd(self) -> bool: ...
    @typing.overload
    def bind(self, address: QHostAddress, port: int = ..., mode: QAbstractSocket.BindMode | QAbstractSocket.BindFlag = ...) -> bool: ...
    @typing.overload
    def bind(self, port: int = ..., mode: QAbstractSocket.BindMode | QAbstractSocket.BindFlag = ...) -> bool: ...
    def bytesAvailable(self) -> int: ...
    def bytesToWrite(self) -> int: ...
    def canReadLine(self) -> bool: ...
    def close(self) -> None: ...
    @typing.overload
    def connectToHost(self, hostName: str, port: int, mode: PySide2.QtCore.QIODevice.OpenMode | PySide2.QtCore.QIODevice.OpenModeFlag = ..., protocol: QAbstractSocket.NetworkLayerProtocol = ...) -> None: ...
    @typing.overload
    def connectToHost(self, address: QHostAddress, port: int, mode: PySide2.QtCore.QIODevice.OpenMode | PySide2.QtCore.QIODevice.OpenModeFlag = ...) -> None: ...
    def disconnectFromHost(self) -> None: ...
    def flush(self) -> bool: ...
    def isSequential(self) -> bool: ...
    def isValid(self) -> bool: ...
    def localAddress(self) -> QHostAddress: ...
    def localPort(self) -> int: ...
    def pauseMode(self) -> QAbstractSocket.PauseModes | QAbstractSocket.PauseMode: ...
    def peerAddress(self) -> QHostAddress: ...
    def peerName(self) -> str: ...
    def peerPort(self) -> int: ...
    def protocolTag(self) -> str: ...
    def proxy(self) -> QNetworkProxy: ...
    def readBufferSize(self) -> int: ...
    def readData(self, data: bytes, maxlen: int) -> int: ...
    def readLineData(self, data: bytes, maxlen: int) -> int: ...
    def resume(self) -> None: ...
    def setLocalAddress(self, address: QHostAddress) -> None: ...
    def setLocalPort(self, port: int) -> None: ...
    def setPauseMode(self, pauseMode: QAbstractSocket.PauseModes | QAbstractSocket.PauseMode) -> None: ...
    def setPeerAddress(self, address: QHostAddress) -> None: ...
    def setPeerName(self, name: str) -> None: ...
    def setPeerPort(self, port: int) -> None: ...
    def setProtocolTag(self, tag: str) -> None: ...
    def setProxy(self, networkProxy: QNetworkProxy) -> None: ...
    def setReadBufferSize(self, size: int) -> None: ...
    def setSocketDescriptor(self, socketDescriptor: int, state: QAbstractSocket.SocketState = ..., openMode: PySide2.QtCore.QIODevice.OpenMode | PySide2.QtCore.QIODevice.OpenModeFlag = ...) -> bool: ...
    def setSocketError(self, socketError: QAbstractSocket.SocketError) -> None: ...
    def setSocketOption(self, option: QAbstractSocket.SocketOption, value: typing.Any) -> None: ...
    def setSocketState(self, state: QAbstractSocket.SocketState) -> None: ...
    def socketDescriptor(self) -> int: ...
    def socketOption(self, option: QAbstractSocket.SocketOption) -> typing.Any: ...
    def socketType(self) -> QAbstractSocket.SocketType: ...
    def state(self) -> QAbstractSocket.SocketState: ...
    def waitForBytesWritten(self, msecs: int = ...) -> bool: ...
    def waitForConnected(self, msecs: int = ...) -> bool: ...
    def waitForDisconnected(self, msecs: int = ...) -> bool: ...
    def waitForReadyRead(self, msecs: int = ...) -> bool: ...
    def writeData(self, data: bytes, len: int) -> int: ...

class QAuthenticator(shiboken2.Object):
    @typing.overload
    def __init__(self, other: QAuthenticator) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def isNull(self) -> bool: ...
    def option(self, opt: str) -> typing.Any: ...
    def options(self) -> typing.Dict[str, typing.Any]: ...
    def password(self) -> str: ...
    def realm(self) -> str: ...
    def setOption(self, opt: str, value: typing.Any) -> None: ...
    def setPassword(self, password: str) -> None: ...
    def setRealm(self, realm: str) -> None: ...
    def setUser(self, user: str) -> None: ...
    def user(self) -> str: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QDnsDomainNameRecord(shiboken2.Object):
    @typing.overload
    def __init__(self, other: QDnsDomainNameRecord) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def name(self) -> str: ...
    def swap(self, other: QDnsDomainNameRecord) -> None: ...
    def timeToLive(self) -> int: ...
    def value(self) -> str: ...
    def __copy__(self) -> None: ...

class QDnsHostAddressRecord(shiboken2.Object):
    @typing.overload
    def __init__(self, other: QDnsHostAddressRecord) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def name(self) -> str: ...
    def swap(self, other: QDnsHostAddressRecord) -> None: ...
    def timeToLive(self) -> int: ...
    def value(self) -> QHostAddress: ...
    def __copy__(self) -> None: ...

class QDnsLookup(PySide2.QtCore.QObject):
    class Error:
        InvalidReplyError: typing.ClassVar[QDnsLookup.Error] = ...
        InvalidRequestError: typing.ClassVar[QDnsLookup.Error] = ...
        NoError: typing.ClassVar[QDnsLookup.Error] = ...
        NotFoundError: typing.ClassVar[QDnsLookup.Error] = ...
        OperationCancelledError: typing.ClassVar[QDnsLookup.Error] = ...
        ResolverError: typing.ClassVar[QDnsLookup.Error] = ...
        ServerFailureError: typing.ClassVar[QDnsLookup.Error] = ...
        ServerRefusedError: typing.ClassVar[QDnsLookup.Error] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QDnsLookup.Error: ...
        def __and__(self, other: typing.SupportsInt) -> QDnsLookup.Error: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QDnsLookup.Error: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDnsLookup.Error: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QDnsLookup.Error: ...
        def __rand__(self, other: typing.SupportsInt) -> QDnsLookup.Error: ...
        def __rmul__(self, other: typing.SupportsInt) -> QDnsLookup.Error: ...
        def __ror__(self, other: typing.SupportsInt) -> QDnsLookup.Error: ...
        def __rsub__(self, other: typing.SupportsInt) -> QDnsLookup.Error: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDnsLookup.Error: ...
        def __sub__(self, other: typing.SupportsInt) -> QDnsLookup.Error: ...
        def __xor__(self, other: typing.SupportsInt) -> QDnsLookup.Error: ...

    class Type:
        A: typing.ClassVar[QDnsLookup.Type] = ...
        AAAA: typing.ClassVar[QDnsLookup.Type] = ...
        ANY: typing.ClassVar[QDnsLookup.Type] = ...
        CNAME: typing.ClassVar[QDnsLookup.Type] = ...
        MX: typing.ClassVar[QDnsLookup.Type] = ...
        NS: typing.ClassVar[QDnsLookup.Type] = ...
        PTR: typing.ClassVar[QDnsLookup.Type] = ...
        SRV: typing.ClassVar[QDnsLookup.Type] = ...
        TXT: typing.ClassVar[QDnsLookup.Type] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QDnsLookup.Type: ...
        def __and__(self, other: typing.SupportsInt) -> QDnsLookup.Type: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QDnsLookup.Type: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDnsLookup.Type: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QDnsLookup.Type: ...
        def __rand__(self, other: typing.SupportsInt) -> QDnsLookup.Type: ...
        def __rmul__(self, other: typing.SupportsInt) -> QDnsLookup.Type: ...
        def __ror__(self, other: typing.SupportsInt) -> QDnsLookup.Type: ...
        def __rsub__(self, other: typing.SupportsInt) -> QDnsLookup.Type: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDnsLookup.Type: ...
        def __sub__(self, other: typing.SupportsInt) -> QDnsLookup.Type: ...
        def __xor__(self, other: typing.SupportsInt) -> QDnsLookup.Type: ...
    A: typing.ClassVar[QDnsLookup.Type] = ...
    AAAA: typing.ClassVar[QDnsLookup.Type] = ...
    ANY: typing.ClassVar[QDnsLookup.Type] = ...
    CNAME: typing.ClassVar[QDnsLookup.Type] = ...
    InvalidReplyError: typing.ClassVar[QDnsLookup.Error] = ...
    InvalidRequestError: typing.ClassVar[QDnsLookup.Error] = ...
    MX: typing.ClassVar[QDnsLookup.Type] = ...
    NS: typing.ClassVar[QDnsLookup.Type] = ...
    NoError: typing.ClassVar[QDnsLookup.Error] = ...
    NotFoundError: typing.ClassVar[QDnsLookup.Error] = ...
    OperationCancelledError: typing.ClassVar[QDnsLookup.Error] = ...
    PTR: typing.ClassVar[QDnsLookup.Type] = ...
    ResolverError: typing.ClassVar[QDnsLookup.Error] = ...
    SRV: typing.ClassVar[QDnsLookup.Type] = ...
    ServerFailureError: typing.ClassVar[QDnsLookup.Error] = ...
    ServerRefusedError: typing.ClassVar[QDnsLookup.Error] = ...
    TXT: typing.ClassVar[QDnsLookup.Type] = ...
    finished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    nameChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    nameserverChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    typeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @typing.overload
    def __init__(self, type: QDnsLookup.Type, name: str, nameserver: QHostAddress, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., error: QDnsLookup.Error = ..., errorString: str = ..., finished: typing.Callable = ..., nameChanged: typing.Callable = ..., nameserverChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., typeChanged: typing.Callable = ...) -> None: ...
    @typing.overload
    def __init__(self, type: QDnsLookup.Type, name: str, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., error: QDnsLookup.Error = ..., errorString: str = ..., finished: typing.Callable = ..., nameChanged: typing.Callable = ..., nameserver: QHostAddress = ..., nameserverChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., typeChanged: typing.Callable = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., error: QDnsLookup.Error = ..., errorString: str = ..., finished: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., nameserver: QHostAddress = ..., nameserverChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., type: QDnsLookup.Type = ..., typeChanged: typing.Callable = ...) -> None: ...
    def abort(self) -> None: ...
    def canonicalNameRecords(self) -> typing.List[QDnsDomainNameRecord]: ...
    def error(self) -> QDnsLookup.Error: ...
    def errorString(self) -> str: ...
    def hostAddressRecords(self) -> typing.List[QDnsHostAddressRecord]: ...
    def isFinished(self) -> bool: ...
    def lookup(self) -> None: ...
    def mailExchangeRecords(self) -> typing.List[QDnsMailExchangeRecord]: ...
    def name(self) -> str: ...
    def nameServerRecords(self) -> typing.List[QDnsDomainNameRecord]: ...
    def nameserver(self) -> QHostAddress: ...
    def pointerRecords(self) -> typing.List[QDnsDomainNameRecord]: ...
    def serviceRecords(self) -> typing.List[QDnsServiceRecord]: ...
    def setName(self, name: str) -> None: ...
    def setNameserver(self, nameserver: QHostAddress) -> None: ...
    def setType(self, arg__1: QDnsLookup.Type) -> None: ...
    def textRecords(self) -> typing.List[QDnsTextRecord]: ...
    def type(self) -> QDnsLookup.Type: ...

class QDnsMailExchangeRecord(shiboken2.Object):
    @typing.overload
    def __init__(self, other: QDnsMailExchangeRecord) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def exchange(self) -> str: ...
    def name(self) -> str: ...
    def preference(self) -> int: ...
    def swap(self, other: QDnsMailExchangeRecord) -> None: ...
    def timeToLive(self) -> int: ...
    def __copy__(self) -> None: ...

class QDnsServiceRecord(shiboken2.Object):
    @typing.overload
    def __init__(self, other: QDnsServiceRecord) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def name(self) -> str: ...
    def port(self) -> int: ...
    def priority(self) -> int: ...
    def swap(self, other: QDnsServiceRecord) -> None: ...
    def target(self) -> str: ...
    def timeToLive(self) -> int: ...
    def weight(self) -> int: ...
    def __copy__(self) -> None: ...

class QDnsTextRecord(shiboken2.Object):
    @typing.overload
    def __init__(self, other: QDnsTextRecord) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def name(self) -> str: ...
    def swap(self, other: QDnsTextRecord) -> None: ...
    def timeToLive(self) -> int: ...
    def values(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def __copy__(self) -> None: ...

class QHostAddress(shiboken2.Object):
    class ConversionMode:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QHostAddress.ConversionMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QHostAddress.ConversionMode: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QHostAddress.ConversionMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QHostAddress.ConversionMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QHostAddress.ConversionMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QHostAddress.ConversionMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QHostAddress.ConversionMode: ...

    class ConversionModeFlag:
        ConvertLocalHost: typing.ClassVar[QHostAddress.ConversionModeFlag] = ...
        ConvertUnspecifiedAddress: typing.ClassVar[QHostAddress.ConversionModeFlag] = ...
        ConvertV4CompatToIPv4: typing.ClassVar[QHostAddress.ConversionModeFlag] = ...
        ConvertV4MappedToIPv4: typing.ClassVar[QHostAddress.ConversionModeFlag] = ...
        StrictConversion: typing.ClassVar[QHostAddress.ConversionModeFlag] = ...
        TolerantConversion: typing.ClassVar[QHostAddress.ConversionModeFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QHostAddress.ConversionMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QHostAddress.ConversionMode: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QHostAddress.ConversionMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QHostAddress.ConversionMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QHostAddress.ConversionMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QHostAddress.ConversionMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QHostAddress.ConversionMode: ...

    class SpecialAddress:
        Any: typing.ClassVar[QHostAddress.SpecialAddress] = ...
        AnyIPv4: typing.ClassVar[QHostAddress.SpecialAddress] = ...
        AnyIPv6: typing.ClassVar[QHostAddress.SpecialAddress] = ...
        Broadcast: typing.ClassVar[QHostAddress.SpecialAddress] = ...
        LocalHost: typing.ClassVar[QHostAddress.SpecialAddress] = ...
        LocalHostIPv6: typing.ClassVar[QHostAddress.SpecialAddress] = ...
        Null: typing.ClassVar[QHostAddress.SpecialAddress] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QHostAddress.SpecialAddress: ...
        def __and__(self, other: typing.SupportsInt) -> QHostAddress.SpecialAddress: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QHostAddress.SpecialAddress: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QHostAddress.SpecialAddress: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QHostAddress.SpecialAddress: ...
        def __rand__(self, other: typing.SupportsInt) -> QHostAddress.SpecialAddress: ...
        def __rmul__(self, other: typing.SupportsInt) -> QHostAddress.SpecialAddress: ...
        def __ror__(self, other: typing.SupportsInt) -> QHostAddress.SpecialAddress: ...
        def __rsub__(self, other: typing.SupportsInt) -> QHostAddress.SpecialAddress: ...
        def __rxor__(self, other: typing.SupportsInt) -> QHostAddress.SpecialAddress: ...
        def __sub__(self, other: typing.SupportsInt) -> QHostAddress.SpecialAddress: ...
        def __xor__(self, other: typing.SupportsInt) -> QHostAddress.SpecialAddress: ...
    Any: typing.ClassVar[QHostAddress.SpecialAddress] = ...
    AnyIPv4: typing.ClassVar[QHostAddress.SpecialAddress] = ...
    AnyIPv6: typing.ClassVar[QHostAddress.SpecialAddress] = ...
    Broadcast: typing.ClassVar[QHostAddress.SpecialAddress] = ...
    ConvertLocalHost: typing.ClassVar[QHostAddress.ConversionModeFlag] = ...
    ConvertUnspecifiedAddress: typing.ClassVar[QHostAddress.ConversionModeFlag] = ...
    ConvertV4CompatToIPv4: typing.ClassVar[QHostAddress.ConversionModeFlag] = ...
    ConvertV4MappedToIPv4: typing.ClassVar[QHostAddress.ConversionModeFlag] = ...
    LocalHost: typing.ClassVar[QHostAddress.SpecialAddress] = ...
    LocalHostIPv6: typing.ClassVar[QHostAddress.SpecialAddress] = ...
    Null: typing.ClassVar[QHostAddress.SpecialAddress] = ...
    StrictConversion: typing.ClassVar[QHostAddress.ConversionModeFlag] = ...
    TolerantConversion: typing.ClassVar[QHostAddress.ConversionModeFlag] = ...
    @typing.overload
    def __init__(self, ip6Addr: QIPv6Address) -> None: ...
    @typing.overload
    def __init__(self, ip4Addr: int) -> None: ...
    @typing.overload
    def __init__(self, copy: QHostAddress) -> None: ...
    @typing.overload
    def __init__(self, address: QHostAddress.SpecialAddress) -> None: ...
    @typing.overload
    def __init__(self, address: str) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def clear(self) -> None: ...
    def isBroadcast(self) -> bool: ...
    def isEqual(self, address: QHostAddress, mode: QHostAddress.ConversionMode | QHostAddress.ConversionModeFlag = ...) -> bool: ...
    def isGlobal(self) -> bool: ...
    @typing.overload
    def isInSubnet(self, subnet: QHostAddress, netmask: int) -> bool: ...
    @typing.overload
    def isInSubnet(self, subnet: typing.Tuple[QHostAddress, int]) -> bool: ...
    def isLinkLocal(self) -> bool: ...
    def isLoopback(self) -> bool: ...
    def isMulticast(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isSiteLocal(self) -> bool: ...
    def isUniqueLocalUnicast(self) -> bool: ...
    @staticmethod
    def parseSubnet(subnet: str) -> typing.Tuple[QHostAddress, int]: ...
    def protocol(self) -> QAbstractSocket.NetworkLayerProtocol: ...
    def scopeId(self) -> str: ...
    @typing.overload
    def setAddress(self, ip6Addr: QIPv6Address) -> None: ...
    @typing.overload
    def setAddress(self, ip4Addr: int) -> None: ...
    @typing.overload
    def setAddress(self, address: QHostAddress.SpecialAddress) -> None: ...
    @typing.overload
    def setAddress(self, address: str) -> bool: ...
    def setScopeId(self, id: str) -> None: ...
    def swap(self, other: QHostAddress) -> None: ...
    @typing.overload
    def toIPv4Address(self) -> int: ...
    @typing.overload
    def toIPv4Address(self) -> typing.Tuple[int, bool]: ...
    def toIPv6Address(self) -> QIPv6Address: ...
    def toString(self) -> str: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __rlshift__(self, other): ...
    def __rrshift__(self, other): ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QHostInfo(shiboken2.Object):
    class HostInfoError:
        HostNotFound: typing.ClassVar[QHostInfo.HostInfoError] = ...
        NoError: typing.ClassVar[QHostInfo.HostInfoError] = ...
        UnknownError: typing.ClassVar[QHostInfo.HostInfoError] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QHostInfo.HostInfoError: ...
        def __and__(self, other: typing.SupportsInt) -> QHostInfo.HostInfoError: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QHostInfo.HostInfoError: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QHostInfo.HostInfoError: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QHostInfo.HostInfoError: ...
        def __rand__(self, other: typing.SupportsInt) -> QHostInfo.HostInfoError: ...
        def __rmul__(self, other: typing.SupportsInt) -> QHostInfo.HostInfoError: ...
        def __ror__(self, other: typing.SupportsInt) -> QHostInfo.HostInfoError: ...
        def __rsub__(self, other: typing.SupportsInt) -> QHostInfo.HostInfoError: ...
        def __rxor__(self, other: typing.SupportsInt) -> QHostInfo.HostInfoError: ...
        def __sub__(self, other: typing.SupportsInt) -> QHostInfo.HostInfoError: ...
        def __xor__(self, other: typing.SupportsInt) -> QHostInfo.HostInfoError: ...
    HostNotFound: typing.ClassVar[QHostInfo.HostInfoError] = ...
    NoError: typing.ClassVar[QHostInfo.HostInfoError] = ...
    UnknownError: typing.ClassVar[QHostInfo.HostInfoError] = ...
    @typing.overload
    def __init__(self, lookupId: int = ...) -> None: ...
    @typing.overload
    def __init__(self, d: QHostInfo) -> None: ...
    @staticmethod
    def abortHostLookup(lookupId: int) -> None: ...
    def addresses(self) -> typing.List[QHostAddress]: ...
    def error(self) -> QHostInfo.HostInfoError: ...
    def errorString(self) -> str: ...
    @staticmethod
    def fromName(name: str) -> QHostInfo: ...
    def hostName(self) -> str: ...
    @staticmethod
    def localDomainName() -> str: ...
    @staticmethod
    def localHostName() -> str: ...
    def lookupId(self) -> int: ...
    def setAddresses(self, addresses: typing.Iterable[QHostAddress]) -> None: ...
    def setError(self, error: QHostInfo.HostInfoError) -> None: ...
    def setErrorString(self, errorString: str) -> None: ...
    def setHostName(self, name: str) -> None: ...
    def setLookupId(self, id: int) -> None: ...
    def swap(self, other: QHostInfo) -> None: ...
    def __copy__(self) -> None: ...

class QHstsPolicy(shiboken2.Object):
    class PolicyFlag:
        IncludeSubDomains: typing.ClassVar[QHstsPolicy.PolicyFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QHstsPolicy.PolicyFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QHstsPolicy.PolicyFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QHstsPolicy.PolicyFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QHstsPolicy.PolicyFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QHstsPolicy.PolicyFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QHstsPolicy.PolicyFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QHstsPolicy.PolicyFlags: ...

    class PolicyFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QHstsPolicy.PolicyFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QHstsPolicy.PolicyFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QHstsPolicy.PolicyFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QHstsPolicy.PolicyFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QHstsPolicy.PolicyFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QHstsPolicy.PolicyFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QHstsPolicy.PolicyFlags: ...
    IncludeSubDomains: typing.ClassVar[QHstsPolicy.PolicyFlag] = ...
    @typing.overload
    def __init__(self, expiry: PySide2.QtCore.QDateTime | datetime.datetime, flags: QHstsPolicy.PolicyFlags | QHstsPolicy.PolicyFlag, host: str, mode: PySide2.QtCore.QUrl.ParsingMode = ...) -> None: ...
    @typing.overload
    def __init__(self, rhs: QHstsPolicy) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def expiry(self) -> PySide2.QtCore.QDateTime: ...
    def host(self, options: PySide2.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    def includesSubDomains(self) -> bool: ...
    def isExpired(self) -> bool: ...
    def setExpiry(self, expiry: PySide2.QtCore.QDateTime | datetime.datetime) -> None: ...
    def setHost(self, host: str, mode: PySide2.QtCore.QUrl.ParsingMode = ...) -> None: ...
    def setIncludesSubDomains(self, include: bool) -> None: ...
    def swap(self, other: QHstsPolicy) -> None: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QHttpMultiPart(PySide2.QtCore.QObject):
    class ContentType:
        AlternativeType: typing.ClassVar[QHttpMultiPart.ContentType] = ...
        FormDataType: typing.ClassVar[QHttpMultiPart.ContentType] = ...
        MixedType: typing.ClassVar[QHttpMultiPart.ContentType] = ...
        RelatedType: typing.ClassVar[QHttpMultiPart.ContentType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QHttpMultiPart.ContentType: ...
        def __and__(self, other: typing.SupportsInt) -> QHttpMultiPart.ContentType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QHttpMultiPart.ContentType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QHttpMultiPart.ContentType: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QHttpMultiPart.ContentType: ...
        def __rand__(self, other: typing.SupportsInt) -> QHttpMultiPart.ContentType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QHttpMultiPart.ContentType: ...
        def __ror__(self, other: typing.SupportsInt) -> QHttpMultiPart.ContentType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QHttpMultiPart.ContentType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QHttpMultiPart.ContentType: ...
        def __sub__(self, other: typing.SupportsInt) -> QHttpMultiPart.ContentType: ...
        def __xor__(self, other: typing.SupportsInt) -> QHttpMultiPart.ContentType: ...
    AlternativeType: typing.ClassVar[QHttpMultiPart.ContentType] = ...
    FormDataType: typing.ClassVar[QHttpMultiPart.ContentType] = ...
    MixedType: typing.ClassVar[QHttpMultiPart.ContentType] = ...
    RelatedType: typing.ClassVar[QHttpMultiPart.ContentType] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @typing.overload
    def __init__(self, contentType: QHttpMultiPart.ContentType, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def append(self, httpPart: QHttpPart) -> None: ...
    def boundary(self) -> PySide2.QtCore.QByteArray: ...
    def setBoundary(self, boundary: PySide2.QtCore.QByteArray | bytes) -> None: ...
    def setContentType(self, contentType: QHttpMultiPart.ContentType) -> None: ...

class QHttpPart(shiboken2.Object):
    @typing.overload
    def __init__(self, other: QHttpPart) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def setBody(self, body: PySide2.QtCore.QByteArray | bytes) -> None: ...
    def setBodyDevice(self, device: PySide2.QtCore.QIODevice) -> None: ...
    def setHeader(self, header: QNetworkRequest.KnownHeaders, value: typing.Any) -> None: ...
    def setRawHeader(self, headerName: PySide2.QtCore.QByteArray | bytes, headerValue: PySide2.QtCore.QByteArray | bytes) -> None: ...
    def swap(self, other: QHttpPart) -> None: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QIPv6Address(shiboken2.Object):
    @typing.overload
    def __init__(self, QIPv6Address: QIPv6Address) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def __copy__(self) -> None: ...
    def __delitem__(self, other) -> None: ...
    def __getitem__(self, index): ...
    def __len__(self) -> int: ...
    def __setitem__(self, index, object) -> None: ...

class QLocalServer(PySide2.QtCore.QObject):
    class SocketOption:
        GroupAccessOption: typing.ClassVar[QLocalServer.SocketOption] = ...
        NoOptions: typing.ClassVar[QLocalServer.SocketOption] = ...
        OtherAccessOption: typing.ClassVar[QLocalServer.SocketOption] = ...
        UserAccessOption: typing.ClassVar[QLocalServer.SocketOption] = ...
        WorldAccessOption: typing.ClassVar[QLocalServer.SocketOption] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QLocalServer.SocketOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QLocalServer.SocketOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QLocalServer.SocketOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QLocalServer.SocketOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QLocalServer.SocketOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QLocalServer.SocketOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QLocalServer.SocketOptions: ...

    class SocketOptions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QLocalServer.SocketOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QLocalServer.SocketOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QLocalServer.SocketOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QLocalServer.SocketOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QLocalServer.SocketOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QLocalServer.SocketOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QLocalServer.SocketOptions: ...
    GroupAccessOption: typing.ClassVar[QLocalServer.SocketOption] = ...
    NoOptions: typing.ClassVar[QLocalServer.SocketOption] = ...
    OtherAccessOption: typing.ClassVar[QLocalServer.SocketOption] = ...
    UserAccessOption: typing.ClassVar[QLocalServer.SocketOption] = ...
    WorldAccessOption: typing.ClassVar[QLocalServer.SocketOption] = ...
    newConnection: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., newConnection: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., socketOptions: QLocalServer.SocketOptions | QLocalServer.SocketOption = ...) -> None: ...
    def close(self) -> None: ...
    def errorString(self) -> str: ...
    def fullServerName(self) -> str: ...
    def hasPendingConnections(self) -> bool: ...
    def incomingConnection(self, socketDescriptor: int) -> None: ...
    def isListening(self) -> bool: ...
    @typing.overload
    def listen(self, socketDescriptor: int) -> bool: ...
    @typing.overload
    def listen(self, name: str) -> bool: ...
    def maxPendingConnections(self) -> int: ...
    def nextPendingConnection(self) -> QLocalSocket: ...
    @staticmethod
    def removeServer(name: str) -> bool: ...
    def serverError(self) -> QAbstractSocket.SocketError: ...
    def serverName(self) -> str: ...
    def setMaxPendingConnections(self, numConnections: int) -> None: ...
    def setSocketOptions(self, options: QLocalServer.SocketOptions | QLocalServer.SocketOption) -> None: ...
    def socketDescriptor(self) -> int: ...
    def socketOptions(self) -> QLocalServer.SocketOptions | QLocalServer.SocketOption: ...
    def waitForNewConnection(self, msec: int) -> typing.Tuple[bool, bool]: ...

class QLocalSocket(PySide2.QtCore.QIODevice):
    class LocalSocketError:
        ConnectionError: typing.ClassVar[QLocalSocket.LocalSocketError] = ...
        ConnectionRefusedError: typing.ClassVar[QLocalSocket.LocalSocketError] = ...
        DatagramTooLargeError: typing.ClassVar[QLocalSocket.LocalSocketError] = ...
        OperationError: typing.ClassVar[QLocalSocket.LocalSocketError] = ...
        PeerClosedError: typing.ClassVar[QLocalSocket.LocalSocketError] = ...
        ServerNotFoundError: typing.ClassVar[QLocalSocket.LocalSocketError] = ...
        SocketAccessError: typing.ClassVar[QLocalSocket.LocalSocketError] = ...
        SocketResourceError: typing.ClassVar[QLocalSocket.LocalSocketError] = ...
        SocketTimeoutError: typing.ClassVar[QLocalSocket.LocalSocketError] = ...
        UnknownSocketError: typing.ClassVar[QLocalSocket.LocalSocketError] = ...
        UnsupportedSocketOperationError: typing.ClassVar[QLocalSocket.LocalSocketError] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QLocalSocket.LocalSocketError: ...
        def __and__(self, other: typing.SupportsInt) -> QLocalSocket.LocalSocketError: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QLocalSocket.LocalSocketError: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QLocalSocket.LocalSocketError: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QLocalSocket.LocalSocketError: ...
        def __rand__(self, other: typing.SupportsInt) -> QLocalSocket.LocalSocketError: ...
        def __rmul__(self, other: typing.SupportsInt) -> QLocalSocket.LocalSocketError: ...
        def __ror__(self, other: typing.SupportsInt) -> QLocalSocket.LocalSocketError: ...
        def __rsub__(self, other: typing.SupportsInt) -> QLocalSocket.LocalSocketError: ...
        def __rxor__(self, other: typing.SupportsInt) -> QLocalSocket.LocalSocketError: ...
        def __sub__(self, other: typing.SupportsInt) -> QLocalSocket.LocalSocketError: ...
        def __xor__(self, other: typing.SupportsInt) -> QLocalSocket.LocalSocketError: ...

    class LocalSocketState:
        ClosingState: typing.ClassVar[QLocalSocket.LocalSocketState] = ...
        ConnectedState: typing.ClassVar[QLocalSocket.LocalSocketState] = ...
        ConnectingState: typing.ClassVar[QLocalSocket.LocalSocketState] = ...
        UnconnectedState: typing.ClassVar[QLocalSocket.LocalSocketState] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QLocalSocket.LocalSocketState: ...
        def __and__(self, other: typing.SupportsInt) -> QLocalSocket.LocalSocketState: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QLocalSocket.LocalSocketState: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QLocalSocket.LocalSocketState: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QLocalSocket.LocalSocketState: ...
        def __rand__(self, other: typing.SupportsInt) -> QLocalSocket.LocalSocketState: ...
        def __rmul__(self, other: typing.SupportsInt) -> QLocalSocket.LocalSocketState: ...
        def __ror__(self, other: typing.SupportsInt) -> QLocalSocket.LocalSocketState: ...
        def __rsub__(self, other: typing.SupportsInt) -> QLocalSocket.LocalSocketState: ...
        def __rxor__(self, other: typing.SupportsInt) -> QLocalSocket.LocalSocketState: ...
        def __sub__(self, other: typing.SupportsInt) -> QLocalSocket.LocalSocketState: ...
        def __xor__(self, other: typing.SupportsInt) -> QLocalSocket.LocalSocketState: ...
    ClosingState: typing.ClassVar[QLocalSocket.LocalSocketState] = ...
    ConnectedState: typing.ClassVar[QLocalSocket.LocalSocketState] = ...
    ConnectingState: typing.ClassVar[QLocalSocket.LocalSocketState] = ...
    ConnectionError: typing.ClassVar[QLocalSocket.LocalSocketError] = ...
    ConnectionRefusedError: typing.ClassVar[QLocalSocket.LocalSocketError] = ...
    DatagramTooLargeError: typing.ClassVar[QLocalSocket.LocalSocketError] = ...
    OperationError: typing.ClassVar[QLocalSocket.LocalSocketError] = ...
    PeerClosedError: typing.ClassVar[QLocalSocket.LocalSocketError] = ...
    ServerNotFoundError: typing.ClassVar[QLocalSocket.LocalSocketError] = ...
    SocketAccessError: typing.ClassVar[QLocalSocket.LocalSocketError] = ...
    SocketResourceError: typing.ClassVar[QLocalSocket.LocalSocketError] = ...
    SocketTimeoutError: typing.ClassVar[QLocalSocket.LocalSocketError] = ...
    UnconnectedState: typing.ClassVar[QLocalSocket.LocalSocketState] = ...
    UnknownSocketError: typing.ClassVar[QLocalSocket.LocalSocketError] = ...
    UnsupportedSocketOperationError: typing.ClassVar[QLocalSocket.LocalSocketError] = ...
    connected: typing.ClassVar[PySide2.QtCore.Signal] = ...
    disconnected: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    errorOccurred: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., aboutToClose: typing.Callable = ..., bytesWritten: typing.Callable = ..., channelBytesWritten: typing.Callable = ..., channelReadyRead: typing.Callable = ..., connected: typing.Callable = ..., destroyed: typing.Callable = ..., disconnected: typing.Callable = ..., error: typing.Callable = ..., errorOccurred: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., readChannelFinished: typing.Callable = ..., readyRead: typing.Callable = ..., stateChanged: typing.Callable = ...) -> None: ...
    def abort(self) -> None: ...
    def bytesAvailable(self) -> int: ...
    def bytesToWrite(self) -> int: ...
    def canReadLine(self) -> bool: ...
    def close(self) -> None: ...
    @typing.overload
    def connectToServer(self, name: str, openMode: PySide2.QtCore.QIODevice.OpenMode | PySide2.QtCore.QIODevice.OpenModeFlag = ...) -> None: ...
    @typing.overload
    def connectToServer(self, openMode: PySide2.QtCore.QIODevice.OpenMode | PySide2.QtCore.QIODevice.OpenModeFlag = ...) -> None: ...
    def disconnectFromServer(self) -> None: ...
    def flush(self) -> bool: ...
    def fullServerName(self) -> str: ...
    def isSequential(self) -> bool: ...
    def isValid(self) -> bool: ...
    def open(self, openMode: PySide2.QtCore.QIODevice.OpenMode | PySide2.QtCore.QIODevice.OpenModeFlag = ...) -> bool: ...
    def readBufferSize(self) -> int: ...
    def readData(self, arg__1: bytes, arg__2: int) -> int: ...
    def serverName(self) -> str: ...
    def setReadBufferSize(self, size: int) -> None: ...
    def setServerName(self, name: str) -> None: ...
    def setSocketDescriptor(self, socketDescriptor: int, socketState: QLocalSocket.LocalSocketState = ..., openMode: PySide2.QtCore.QIODevice.OpenMode | PySide2.QtCore.QIODevice.OpenModeFlag = ...) -> bool: ...
    def socketDescriptor(self) -> int: ...
    def state(self) -> QLocalSocket.LocalSocketState: ...
    def waitForBytesWritten(self, msecs: int = ...) -> bool: ...
    def waitForConnected(self, msecs: int = ...) -> bool: ...
    def waitForDisconnected(self, msecs: int = ...) -> bool: ...
    def waitForReadyRead(self, msecs: int = ...) -> bool: ...
    def writeData(self, arg__1: bytes, arg__2: int) -> int: ...

class QNetworkAccessManager(PySide2.QtCore.QObject):
    class NetworkAccessibility:
        Accessible: typing.ClassVar[QNetworkAccessManager.NetworkAccessibility] = ...
        NotAccessible: typing.ClassVar[QNetworkAccessManager.NetworkAccessibility] = ...
        UnknownAccessibility: typing.ClassVar[QNetworkAccessManager.NetworkAccessibility] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QNetworkAccessManager.NetworkAccessibility: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkAccessManager.NetworkAccessibility: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QNetworkAccessManager.NetworkAccessibility: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkAccessManager.NetworkAccessibility: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QNetworkAccessManager.NetworkAccessibility: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkAccessManager.NetworkAccessibility: ...
        def __rmul__(self, other: typing.SupportsInt) -> QNetworkAccessManager.NetworkAccessibility: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkAccessManager.NetworkAccessibility: ...
        def __rsub__(self, other: typing.SupportsInt) -> QNetworkAccessManager.NetworkAccessibility: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkAccessManager.NetworkAccessibility: ...
        def __sub__(self, other: typing.SupportsInt) -> QNetworkAccessManager.NetworkAccessibility: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkAccessManager.NetworkAccessibility: ...

    class Operation:
        CustomOperation: typing.ClassVar[QNetworkAccessManager.Operation] = ...
        DeleteOperation: typing.ClassVar[QNetworkAccessManager.Operation] = ...
        GetOperation: typing.ClassVar[QNetworkAccessManager.Operation] = ...
        HeadOperation: typing.ClassVar[QNetworkAccessManager.Operation] = ...
        PostOperation: typing.ClassVar[QNetworkAccessManager.Operation] = ...
        PutOperation: typing.ClassVar[QNetworkAccessManager.Operation] = ...
        UnknownOperation: typing.ClassVar[QNetworkAccessManager.Operation] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QNetworkAccessManager.Operation: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkAccessManager.Operation: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QNetworkAccessManager.Operation: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkAccessManager.Operation: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QNetworkAccessManager.Operation: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkAccessManager.Operation: ...
        def __rmul__(self, other: typing.SupportsInt) -> QNetworkAccessManager.Operation: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkAccessManager.Operation: ...
        def __rsub__(self, other: typing.SupportsInt) -> QNetworkAccessManager.Operation: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkAccessManager.Operation: ...
        def __sub__(self, other: typing.SupportsInt) -> QNetworkAccessManager.Operation: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkAccessManager.Operation: ...
    Accessible: typing.ClassVar[QNetworkAccessManager.NetworkAccessibility] = ...
    CustomOperation: typing.ClassVar[QNetworkAccessManager.Operation] = ...
    DeleteOperation: typing.ClassVar[QNetworkAccessManager.Operation] = ...
    GetOperation: typing.ClassVar[QNetworkAccessManager.Operation] = ...
    HeadOperation: typing.ClassVar[QNetworkAccessManager.Operation] = ...
    NotAccessible: typing.ClassVar[QNetworkAccessManager.NetworkAccessibility] = ...
    PostOperation: typing.ClassVar[QNetworkAccessManager.Operation] = ...
    PutOperation: typing.ClassVar[QNetworkAccessManager.Operation] = ...
    UnknownAccessibility: typing.ClassVar[QNetworkAccessManager.NetworkAccessibility] = ...
    UnknownOperation: typing.ClassVar[QNetworkAccessManager.Operation] = ...
    authenticationRequired: typing.ClassVar[PySide2.QtCore.Signal] = ...
    encrypted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    finished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    networkAccessibleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    networkSessionConnected: typing.ClassVar[PySide2.QtCore.Signal] = ...
    preSharedKeyAuthenticationRequired: typing.ClassVar[PySide2.QtCore.Signal] = ...
    proxyAuthenticationRequired: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sslErrors: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., authenticationRequired: typing.Callable = ..., destroyed: typing.Callable = ..., encrypted: typing.Callable = ..., finished: typing.Callable = ..., networkAccessible: QNetworkAccessManager.NetworkAccessibility = ..., networkAccessibleChanged: typing.Callable = ..., networkSessionConnected: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., preSharedKeyAuthenticationRequired: typing.Callable = ..., proxyAuthenticationRequired: typing.Callable = ..., sslErrors: typing.Callable = ...) -> None: ...
    def activeConfiguration(self) -> QNetworkConfiguration: ...
    def addStrictTransportSecurityHosts(self, knownHosts: typing.List[QHstsPolicy]) -> None: ...
    def autoDeleteReplies(self) -> bool: ...
    def cache(self) -> QAbstractNetworkCache: ...
    def clearAccessCache(self) -> None: ...
    def clearConnectionCache(self) -> None: ...
    def configuration(self) -> QNetworkConfiguration: ...
    def connectToHost(self, hostName: str, port: int = ...) -> None: ...
    @typing.overload
    def connectToHostEncrypted(self, hostName: str, port: int, sslConfiguration: QSslConfiguration, peerName: str) -> None: ...
    @typing.overload
    def connectToHostEncrypted(self, hostName: str, port: int = ..., sslConfiguration: QSslConfiguration = ...) -> None: ...
    def cookieJar(self) -> QNetworkCookieJar: ...
    def createRequest(self, op: QNetworkAccessManager.Operation, request: QNetworkRequest, outgoingData: PySide2.QtCore.QIODevice | None = ...) -> QNetworkReply: ...
    def deleteResource(self, request: QNetworkRequest) -> QNetworkReply: ...
    def enableStrictTransportSecurityStore(self, enabled: bool, storeDir: str = ...) -> None: ...
    def get(self, request: QNetworkRequest) -> QNetworkReply: ...
    def head(self, request: QNetworkRequest) -> QNetworkReply: ...
    def isStrictTransportSecurityEnabled(self) -> bool: ...
    def isStrictTransportSecurityStoreEnabled(self) -> bool: ...
    def networkAccessible(self) -> QNetworkAccessManager.NetworkAccessibility: ...
    @typing.overload
    def post(self, request: QNetworkRequest, multiPart: QHttpMultiPart) -> QNetworkReply: ...
    @typing.overload
    def post(self, request: QNetworkRequest, data: PySide2.QtCore.QByteArray | bytes) -> QNetworkReply: ...
    @typing.overload
    def post(self, request: QNetworkRequest, data: PySide2.QtCore.QIODevice) -> QNetworkReply: ...
    def proxy(self) -> QNetworkProxy: ...
    def proxyFactory(self) -> QNetworkProxyFactory: ...
    @typing.overload
    def put(self, request: QNetworkRequest, multiPart: QHttpMultiPart) -> QNetworkReply: ...
    @typing.overload
    def put(self, request: QNetworkRequest, data: PySide2.QtCore.QByteArray | bytes) -> QNetworkReply: ...
    @typing.overload
    def put(self, request: QNetworkRequest, data: PySide2.QtCore.QIODevice) -> QNetworkReply: ...
    def redirectPolicy(self) -> QNetworkRequest.RedirectPolicy: ...
    @typing.overload
    def sendCustomRequest(self, request: QNetworkRequest, verb: PySide2.QtCore.QByteArray | bytes, multiPart: QHttpMultiPart) -> QNetworkReply: ...
    @typing.overload
    def sendCustomRequest(self, request: QNetworkRequest, verb: PySide2.QtCore.QByteArray | bytes, data: PySide2.QtCore.QByteArray | bytes) -> QNetworkReply: ...
    @typing.overload
    def sendCustomRequest(self, request: QNetworkRequest, verb: PySide2.QtCore.QByteArray | bytes, data: PySide2.QtCore.QIODevice | None = ...) -> QNetworkReply: ...
    def setAutoDeleteReplies(self, autoDelete: bool) -> None: ...
    def setCache(self, cache: QAbstractNetworkCache) -> None: ...
    def setConfiguration(self, config: QNetworkConfiguration) -> None: ...
    def setCookieJar(self, cookieJar: QNetworkCookieJar) -> None: ...
    def setNetworkAccessible(self, accessible: QNetworkAccessManager.NetworkAccessibility) -> None: ...
    def setProxy(self, proxy: QNetworkProxy) -> None: ...
    def setProxyFactory(self, factory: QNetworkProxyFactory) -> None: ...
    def setRedirectPolicy(self, policy: QNetworkRequest.RedirectPolicy) -> None: ...
    def setStrictTransportSecurityEnabled(self, enabled: bool) -> None: ...
    def setTransferTimeout(self, timeout: int = ...) -> None: ...
    def strictTransportSecurityHosts(self) -> typing.List[QHstsPolicy]: ...
    def supportedSchemes(self) -> typing.List[str]: ...
    def supportedSchemesImplementation(self) -> typing.List[str]: ...
    def transferTimeout(self) -> int: ...

class QNetworkAddressEntry(shiboken2.Object):
    class DnsEligibilityStatus:
        DnsEligibilityUnknown: typing.ClassVar[QNetworkAddressEntry.DnsEligibilityStatus] = ...
        DnsEligible: typing.ClassVar[QNetworkAddressEntry.DnsEligibilityStatus] = ...
        DnsIneligible: typing.ClassVar[QNetworkAddressEntry.DnsEligibilityStatus] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QNetworkAddressEntry.DnsEligibilityStatus: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkAddressEntry.DnsEligibilityStatus: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QNetworkAddressEntry.DnsEligibilityStatus: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkAddressEntry.DnsEligibilityStatus: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QNetworkAddressEntry.DnsEligibilityStatus: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkAddressEntry.DnsEligibilityStatus: ...
        def __rmul__(self, other: typing.SupportsInt) -> QNetworkAddressEntry.DnsEligibilityStatus: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkAddressEntry.DnsEligibilityStatus: ...
        def __rsub__(self, other: typing.SupportsInt) -> QNetworkAddressEntry.DnsEligibilityStatus: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkAddressEntry.DnsEligibilityStatus: ...
        def __sub__(self, other: typing.SupportsInt) -> QNetworkAddressEntry.DnsEligibilityStatus: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkAddressEntry.DnsEligibilityStatus: ...
    DnsEligibilityUnknown: typing.ClassVar[QNetworkAddressEntry.DnsEligibilityStatus] = ...
    DnsEligible: typing.ClassVar[QNetworkAddressEntry.DnsEligibilityStatus] = ...
    DnsIneligible: typing.ClassVar[QNetworkAddressEntry.DnsEligibilityStatus] = ...
    @typing.overload
    def __init__(self, other: QNetworkAddressEntry) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def broadcast(self) -> QHostAddress: ...
    def clearAddressLifetime(self) -> None: ...
    def dnsEligibility(self) -> QNetworkAddressEntry.DnsEligibilityStatus: ...
    def ip(self) -> QHostAddress: ...
    def isLifetimeKnown(self) -> bool: ...
    def isPermanent(self) -> bool: ...
    def isTemporary(self) -> bool: ...
    def netmask(self) -> QHostAddress: ...
    def preferredLifetime(self) -> PySide2.QtCore.QDeadlineTimer: ...
    def prefixLength(self) -> int: ...
    def setAddressLifetime(self, preferred: PySide2.QtCore.QDeadlineTimer, validity: PySide2.QtCore.QDeadlineTimer) -> None: ...
    def setBroadcast(self, newBroadcast: QHostAddress) -> None: ...
    def setDnsEligibility(self, status: QNetworkAddressEntry.DnsEligibilityStatus) -> None: ...
    def setIp(self, newIp: QHostAddress) -> None: ...
    def setNetmask(self, newNetmask: QHostAddress) -> None: ...
    def setPrefixLength(self, length: int) -> None: ...
    def swap(self, other: QNetworkAddressEntry) -> None: ...
    def validityLifetime(self) -> PySide2.QtCore.QDeadlineTimer: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QNetworkCacheMetaData(shiboken2.Object):
    @typing.overload
    def __init__(self, other: QNetworkCacheMetaData) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def attributes(self) -> typing.Dict[QNetworkRequest.Attribute, typing.Any]: ...
    def expirationDate(self) -> PySide2.QtCore.QDateTime: ...
    def isValid(self) -> bool: ...
    def lastModified(self) -> PySide2.QtCore.QDateTime: ...
    def rawHeaders(self) -> typing.List[typing.Tuple[PySide2.QtCore.QByteArray, PySide2.QtCore.QByteArray]]: ...
    def saveToDisk(self) -> bool: ...
    def setAttributes(self, attributes: typing.Dict[QNetworkRequest.Attribute, typing.Any]) -> None: ...
    def setExpirationDate(self, dateTime: PySide2.QtCore.QDateTime | datetime.datetime) -> None: ...
    def setLastModified(self, dateTime: PySide2.QtCore.QDateTime | datetime.datetime) -> None: ...
    def setRawHeaders(self, headers: typing.Iterable[typing.Tuple[PySide2.QtCore.QByteArray, PySide2.QtCore.QByteArray]]) -> None: ...
    def setSaveToDisk(self, allow: bool) -> None: ...
    def setUrl(self, url: PySide2.QtCore.QUrl) -> None: ...
    def swap(self, other: QNetworkCacheMetaData) -> None: ...
    def url(self) -> PySide2.QtCore.QUrl: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __rlshift__(self, other): ...
    def __rrshift__(self, other): ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QNetworkConfiguration(shiboken2.Object):
    class BearerType:
        Bearer2G: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
        Bearer3G: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
        Bearer4G: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
        BearerBluetooth: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
        BearerCDMA2000: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
        BearerEVDO: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
        BearerEthernet: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
        BearerHSPA: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
        BearerLTE: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
        BearerUnknown: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
        BearerWCDMA: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
        BearerWLAN: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
        BearerWiMAX: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QNetworkConfiguration.BearerType: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkConfiguration.BearerType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QNetworkConfiguration.BearerType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkConfiguration.BearerType: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QNetworkConfiguration.BearerType: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkConfiguration.BearerType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QNetworkConfiguration.BearerType: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkConfiguration.BearerType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QNetworkConfiguration.BearerType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkConfiguration.BearerType: ...
        def __sub__(self, other: typing.SupportsInt) -> QNetworkConfiguration.BearerType: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkConfiguration.BearerType: ...

    class Purpose:
        PrivatePurpose: typing.ClassVar[QNetworkConfiguration.Purpose] = ...
        PublicPurpose: typing.ClassVar[QNetworkConfiguration.Purpose] = ...
        ServiceSpecificPurpose: typing.ClassVar[QNetworkConfiguration.Purpose] = ...
        UnknownPurpose: typing.ClassVar[QNetworkConfiguration.Purpose] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QNetworkConfiguration.Purpose: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkConfiguration.Purpose: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QNetworkConfiguration.Purpose: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkConfiguration.Purpose: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QNetworkConfiguration.Purpose: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkConfiguration.Purpose: ...
        def __rmul__(self, other: typing.SupportsInt) -> QNetworkConfiguration.Purpose: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkConfiguration.Purpose: ...
        def __rsub__(self, other: typing.SupportsInt) -> QNetworkConfiguration.Purpose: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkConfiguration.Purpose: ...
        def __sub__(self, other: typing.SupportsInt) -> QNetworkConfiguration.Purpose: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkConfiguration.Purpose: ...

    class StateFlag:
        Active: typing.ClassVar[QNetworkConfiguration.StateFlag] = ...
        Defined: typing.ClassVar[QNetworkConfiguration.StateFlag] = ...
        Discovered: typing.ClassVar[QNetworkConfiguration.StateFlag] = ...
        Undefined: typing.ClassVar[QNetworkConfiguration.StateFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkConfiguration.StateFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QNetworkConfiguration.StateFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkConfiguration.StateFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkConfiguration.StateFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkConfiguration.StateFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkConfiguration.StateFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkConfiguration.StateFlags: ...

    class StateFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkConfiguration.StateFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QNetworkConfiguration.StateFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkConfiguration.StateFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkConfiguration.StateFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkConfiguration.StateFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkConfiguration.StateFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkConfiguration.StateFlags: ...

    class Type:
        InternetAccessPoint: typing.ClassVar[QNetworkConfiguration.Type] = ...
        Invalid: typing.ClassVar[QNetworkConfiguration.Type] = ...
        ServiceNetwork: typing.ClassVar[QNetworkConfiguration.Type] = ...
        UserChoice: typing.ClassVar[QNetworkConfiguration.Type] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QNetworkConfiguration.Type: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkConfiguration.Type: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QNetworkConfiguration.Type: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkConfiguration.Type: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QNetworkConfiguration.Type: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkConfiguration.Type: ...
        def __rmul__(self, other: typing.SupportsInt) -> QNetworkConfiguration.Type: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkConfiguration.Type: ...
        def __rsub__(self, other: typing.SupportsInt) -> QNetworkConfiguration.Type: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkConfiguration.Type: ...
        def __sub__(self, other: typing.SupportsInt) -> QNetworkConfiguration.Type: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkConfiguration.Type: ...
    Active: typing.ClassVar[QNetworkConfiguration.StateFlag] = ...
    Bearer2G: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
    Bearer3G: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
    Bearer4G: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
    BearerBluetooth: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
    BearerCDMA2000: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
    BearerEVDO: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
    BearerEthernet: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
    BearerHSPA: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
    BearerLTE: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
    BearerUnknown: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
    BearerWCDMA: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
    BearerWLAN: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
    BearerWiMAX: typing.ClassVar[QNetworkConfiguration.BearerType] = ...
    Defined: typing.ClassVar[QNetworkConfiguration.StateFlag] = ...
    Discovered: typing.ClassVar[QNetworkConfiguration.StateFlag] = ...
    InternetAccessPoint: typing.ClassVar[QNetworkConfiguration.Type] = ...
    Invalid: typing.ClassVar[QNetworkConfiguration.Type] = ...
    PrivatePurpose: typing.ClassVar[QNetworkConfiguration.Purpose] = ...
    PublicPurpose: typing.ClassVar[QNetworkConfiguration.Purpose] = ...
    ServiceNetwork: typing.ClassVar[QNetworkConfiguration.Type] = ...
    ServiceSpecificPurpose: typing.ClassVar[QNetworkConfiguration.Purpose] = ...
    Undefined: typing.ClassVar[QNetworkConfiguration.StateFlag] = ...
    UnknownPurpose: typing.ClassVar[QNetworkConfiguration.Purpose] = ...
    UserChoice: typing.ClassVar[QNetworkConfiguration.Type] = ...
    @typing.overload
    def __init__(self, other: QNetworkConfiguration) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def bearerType(self) -> QNetworkConfiguration.BearerType: ...
    def bearerTypeFamily(self) -> QNetworkConfiguration.BearerType: ...
    def bearerTypeName(self) -> str: ...
    def children(self) -> typing.List[QNetworkConfiguration]: ...
    def connectTimeout(self) -> int: ...
    def identifier(self) -> str: ...
    def isRoamingAvailable(self) -> bool: ...
    def isValid(self) -> bool: ...
    def name(self) -> str: ...
    def purpose(self) -> QNetworkConfiguration.Purpose: ...
    def setConnectTimeout(self, timeout: int) -> bool: ...
    def state(self) -> QNetworkConfiguration.StateFlags | QNetworkConfiguration.StateFlag: ...
    def swap(self, other: QNetworkConfiguration) -> None: ...
    def type(self) -> QNetworkConfiguration.Type: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QNetworkConfigurationManager(PySide2.QtCore.QObject):
    class Capabilities:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkConfigurationManager.Capabilities: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QNetworkConfigurationManager.Capabilities: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkConfigurationManager.Capabilities: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkConfigurationManager.Capabilities: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkConfigurationManager.Capabilities: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkConfigurationManager.Capabilities: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkConfigurationManager.Capabilities: ...

    class Capability:
        ApplicationLevelRoaming: typing.ClassVar[QNetworkConfigurationManager.Capability] = ...
        CanStartAndStopInterfaces: typing.ClassVar[QNetworkConfigurationManager.Capability] = ...
        DataStatistics: typing.ClassVar[QNetworkConfigurationManager.Capability] = ...
        DirectConnectionRouting: typing.ClassVar[QNetworkConfigurationManager.Capability] = ...
        ForcedRoaming: typing.ClassVar[QNetworkConfigurationManager.Capability] = ...
        NetworkSessionRequired: typing.ClassVar[QNetworkConfigurationManager.Capability] = ...
        SystemSessionSupport: typing.ClassVar[QNetworkConfigurationManager.Capability] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkConfigurationManager.Capabilities: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QNetworkConfigurationManager.Capabilities: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkConfigurationManager.Capabilities: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkConfigurationManager.Capabilities: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkConfigurationManager.Capabilities: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkConfigurationManager.Capabilities: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkConfigurationManager.Capabilities: ...
    ApplicationLevelRoaming: typing.ClassVar[QNetworkConfigurationManager.Capability] = ...
    CanStartAndStopInterfaces: typing.ClassVar[QNetworkConfigurationManager.Capability] = ...
    DataStatistics: typing.ClassVar[QNetworkConfigurationManager.Capability] = ...
    DirectConnectionRouting: typing.ClassVar[QNetworkConfigurationManager.Capability] = ...
    ForcedRoaming: typing.ClassVar[QNetworkConfigurationManager.Capability] = ...
    NetworkSessionRequired: typing.ClassVar[QNetworkConfigurationManager.Capability] = ...
    SystemSessionSupport: typing.ClassVar[QNetworkConfigurationManager.Capability] = ...
    configurationAdded: typing.ClassVar[PySide2.QtCore.Signal] = ...
    configurationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    configurationRemoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
    onlineStateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    updateCompleted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., configurationAdded: typing.Callable = ..., configurationChanged: typing.Callable = ..., configurationRemoved: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., onlineStateChanged: typing.Callable = ..., updateCompleted: typing.Callable = ...) -> None: ...
    def allConfigurations(self, flags: QNetworkConfiguration.StateFlags | QNetworkConfiguration.StateFlag = ...) -> typing.List[QNetworkConfiguration]: ...
    def capabilities(self) -> QNetworkConfigurationManager.Capabilities | QNetworkConfigurationManager.Capability: ...
    def configurationFromIdentifier(self, identifier: str) -> QNetworkConfiguration: ...
    def defaultConfiguration(self) -> QNetworkConfiguration: ...
    def isOnline(self) -> bool: ...
    def updateConfigurations(self) -> None: ...

class QNetworkCookie(shiboken2.Object):
    class RawForm:
        Full: typing.ClassVar[QNetworkCookie.RawForm] = ...
        NameAndValueOnly: typing.ClassVar[QNetworkCookie.RawForm] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QNetworkCookie.RawForm: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkCookie.RawForm: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QNetworkCookie.RawForm: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkCookie.RawForm: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QNetworkCookie.RawForm: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkCookie.RawForm: ...
        def __rmul__(self, other: typing.SupportsInt) -> QNetworkCookie.RawForm: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkCookie.RawForm: ...
        def __rsub__(self, other: typing.SupportsInt) -> QNetworkCookie.RawForm: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkCookie.RawForm: ...
        def __sub__(self, other: typing.SupportsInt) -> QNetworkCookie.RawForm: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkCookie.RawForm: ...
    Full: typing.ClassVar[QNetworkCookie.RawForm] = ...
    NameAndValueOnly: typing.ClassVar[QNetworkCookie.RawForm] = ...
    @typing.overload
    def __init__(self, name: PySide2.QtCore.QByteArray | bytes = ..., value: PySide2.QtCore.QByteArray | bytes = ...) -> None: ...
    @typing.overload
    def __init__(self, other: QNetworkCookie) -> None: ...
    def domain(self) -> str: ...
    def expirationDate(self) -> PySide2.QtCore.QDateTime: ...
    def hasSameIdentifier(self, other: QNetworkCookie) -> bool: ...
    def isHttpOnly(self) -> bool: ...
    def isSecure(self) -> bool: ...
    def isSessionCookie(self) -> bool: ...
    def name(self) -> PySide2.QtCore.QByteArray: ...
    def normalize(self, url: PySide2.QtCore.QUrl) -> None: ...
    @staticmethod
    def parseCookies(cookieString: PySide2.QtCore.QByteArray | bytes) -> typing.List[QNetworkCookie]: ...
    def path(self) -> str: ...
    def setDomain(self, domain: str) -> None: ...
    def setExpirationDate(self, date: PySide2.QtCore.QDateTime | datetime.datetime) -> None: ...
    def setHttpOnly(self, enable: bool) -> None: ...
    def setName(self, cookieName: PySide2.QtCore.QByteArray | bytes) -> None: ...
    def setPath(self, path: str) -> None: ...
    def setSecure(self, enable: bool) -> None: ...
    def setValue(self, value: PySide2.QtCore.QByteArray | bytes) -> None: ...
    def swap(self, other: QNetworkCookie) -> None: ...
    def toRawForm(self, form: QNetworkCookie.RawForm = ...) -> PySide2.QtCore.QByteArray: ...
    def value(self) -> PySide2.QtCore.QByteArray: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QNetworkCookieJar(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def allCookies(self) -> typing.List[QNetworkCookie]: ...
    def cookiesForUrl(self, url: PySide2.QtCore.QUrl) -> typing.List[QNetworkCookie]: ...
    def deleteCookie(self, cookie: QNetworkCookie) -> bool: ...
    def insertCookie(self, cookie: QNetworkCookie) -> bool: ...
    def setAllCookies(self, cookieList: typing.Iterable[QNetworkCookie]) -> None: ...
    def setCookiesFromUrl(self, cookieList: typing.Iterable[QNetworkCookie], url: PySide2.QtCore.QUrl) -> bool: ...
    def updateCookie(self, cookie: QNetworkCookie) -> bool: ...
    def validateCookie(self, cookie: QNetworkCookie, url: PySide2.QtCore.QUrl) -> bool: ...

class QNetworkDatagram(shiboken2.Object):
    @typing.overload
    def __init__(self, data: PySide2.QtCore.QByteArray | bytes, destinationAddress: QHostAddress = ..., port: int = ...) -> None: ...
    @typing.overload
    def __init__(self, other: QNetworkDatagram) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def clear(self) -> None: ...
    def data(self) -> PySide2.QtCore.QByteArray: ...
    def destinationAddress(self) -> QHostAddress: ...
    def destinationPort(self) -> int: ...
    def hopLimit(self) -> int: ...
    def interfaceIndex(self) -> int: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    def makeReply(self, payload: PySide2.QtCore.QByteArray | bytes) -> QNetworkDatagram: ...
    def senderAddress(self) -> QHostAddress: ...
    def senderPort(self) -> int: ...
    def setData(self, data: PySide2.QtCore.QByteArray | bytes) -> None: ...
    def setDestination(self, address: QHostAddress, port: int) -> None: ...
    def setHopLimit(self, count: int) -> None: ...
    def setInterfaceIndex(self, index: int) -> None: ...
    def setSender(self, address: QHostAddress, port: int = ...) -> None: ...
    def swap(self, other: QNetworkDatagram) -> None: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...

class QNetworkDiskCache(QAbstractNetworkCache):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def cacheDirectory(self) -> str: ...
    def cacheSize(self) -> int: ...
    def clear(self) -> None: ...
    def data(self, url: PySide2.QtCore.QUrl) -> PySide2.QtCore.QIODevice: ...
    def expire(self) -> int: ...
    def fileMetaData(self, fileName: str) -> QNetworkCacheMetaData: ...
    def insert(self, device: PySide2.QtCore.QIODevice) -> None: ...
    def maximumCacheSize(self) -> int: ...
    def metaData(self, url: PySide2.QtCore.QUrl) -> QNetworkCacheMetaData: ...
    def prepare(self, metaData: QNetworkCacheMetaData) -> PySide2.QtCore.QIODevice: ...
    def remove(self, url: PySide2.QtCore.QUrl) -> bool: ...
    def setCacheDirectory(self, cacheDir: str) -> None: ...
    def setMaximumCacheSize(self, size: int) -> None: ...
    def updateMetaData(self, metaData: QNetworkCacheMetaData) -> None: ...

class QNetworkInterface(shiboken2.Object):
    class InterfaceFlag:
        CanBroadcast: typing.ClassVar[QNetworkInterface.InterfaceFlag] = ...
        CanMulticast: typing.ClassVar[QNetworkInterface.InterfaceFlag] = ...
        IsLoopBack: typing.ClassVar[QNetworkInterface.InterfaceFlag] = ...
        IsPointToPoint: typing.ClassVar[QNetworkInterface.InterfaceFlag] = ...
        IsRunning: typing.ClassVar[QNetworkInterface.InterfaceFlag] = ...
        IsUp: typing.ClassVar[QNetworkInterface.InterfaceFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkInterface.InterfaceFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QNetworkInterface.InterfaceFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkInterface.InterfaceFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkInterface.InterfaceFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkInterface.InterfaceFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkInterface.InterfaceFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkInterface.InterfaceFlags: ...

    class InterfaceFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkInterface.InterfaceFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QNetworkInterface.InterfaceFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkInterface.InterfaceFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkInterface.InterfaceFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkInterface.InterfaceFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkInterface.InterfaceFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkInterface.InterfaceFlags: ...

    class InterfaceType:
        CanBus: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
        Ethernet: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
        Fddi: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
        Ieee1394: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
        Ieee80211: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
        Ieee802154: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
        Ieee80216: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
        Loopback: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
        Phonet: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
        Ppp: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
        SixLoWPAN: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
        Slip: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
        Unknown: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
        Virtual: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
        Wifi: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QNetworkInterface.InterfaceType: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkInterface.InterfaceType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QNetworkInterface.InterfaceType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkInterface.InterfaceType: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QNetworkInterface.InterfaceType: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkInterface.InterfaceType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QNetworkInterface.InterfaceType: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkInterface.InterfaceType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QNetworkInterface.InterfaceType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkInterface.InterfaceType: ...
        def __sub__(self, other: typing.SupportsInt) -> QNetworkInterface.InterfaceType: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkInterface.InterfaceType: ...
    CanBroadcast: typing.ClassVar[QNetworkInterface.InterfaceFlag] = ...
    CanBus: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
    CanMulticast: typing.ClassVar[QNetworkInterface.InterfaceFlag] = ...
    Ethernet: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
    Fddi: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
    Ieee1394: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
    Ieee80211: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
    Ieee802154: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
    Ieee80216: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
    IsLoopBack: typing.ClassVar[QNetworkInterface.InterfaceFlag] = ...
    IsPointToPoint: typing.ClassVar[QNetworkInterface.InterfaceFlag] = ...
    IsRunning: typing.ClassVar[QNetworkInterface.InterfaceFlag] = ...
    IsUp: typing.ClassVar[QNetworkInterface.InterfaceFlag] = ...
    Loopback: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
    Phonet: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
    Ppp: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
    SixLoWPAN: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
    Slip: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
    Unknown: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
    Virtual: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
    Wifi: typing.ClassVar[QNetworkInterface.InterfaceType] = ...
    @typing.overload
    def __init__(self, other: QNetworkInterface) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def addressEntries(self) -> typing.List[QNetworkAddressEntry]: ...
    @staticmethod
    def allAddresses() -> typing.List[QHostAddress]: ...
    @staticmethod
    def allInterfaces() -> typing.List[QNetworkInterface]: ...
    def flags(self) -> QNetworkInterface.InterfaceFlags | QNetworkInterface.InterfaceFlag: ...
    def hardwareAddress(self) -> str: ...
    def humanReadableName(self) -> str: ...
    def index(self) -> int: ...
    @staticmethod
    def interfaceFromIndex(index: int) -> QNetworkInterface: ...
    @staticmethod
    def interfaceFromName(name: str) -> QNetworkInterface: ...
    @staticmethod
    def interfaceIndexFromName(name: str) -> int: ...
    @staticmethod
    def interfaceNameFromIndex(index: int) -> str: ...
    def isValid(self) -> bool: ...
    def maximumTransmissionUnit(self) -> int: ...
    def name(self) -> str: ...
    def swap(self, other: QNetworkInterface) -> None: ...
    def type(self) -> QNetworkInterface.InterfaceType: ...
    def __copy__(self) -> None: ...

class QNetworkProxy(shiboken2.Object):
    class Capabilities:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkProxy.Capabilities: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QNetworkProxy.Capabilities: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkProxy.Capabilities: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkProxy.Capabilities: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkProxy.Capabilities: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkProxy.Capabilities: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkProxy.Capabilities: ...

    class Capability:
        CachingCapability: typing.ClassVar[QNetworkProxy.Capability] = ...
        HostNameLookupCapability: typing.ClassVar[QNetworkProxy.Capability] = ...
        ListeningCapability: typing.ClassVar[QNetworkProxy.Capability] = ...
        SctpListeningCapability: typing.ClassVar[QNetworkProxy.Capability] = ...
        SctpTunnelingCapability: typing.ClassVar[QNetworkProxy.Capability] = ...
        TunnelingCapability: typing.ClassVar[QNetworkProxy.Capability] = ...
        UdpTunnelingCapability: typing.ClassVar[QNetworkProxy.Capability] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkProxy.Capabilities: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QNetworkProxy.Capabilities: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkProxy.Capabilities: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkProxy.Capabilities: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkProxy.Capabilities: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkProxy.Capabilities: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkProxy.Capabilities: ...

    class ProxyType:
        DefaultProxy: typing.ClassVar[QNetworkProxy.ProxyType] = ...
        FtpCachingProxy: typing.ClassVar[QNetworkProxy.ProxyType] = ...
        HttpCachingProxy: typing.ClassVar[QNetworkProxy.ProxyType] = ...
        HttpProxy: typing.ClassVar[QNetworkProxy.ProxyType] = ...
        NoProxy: typing.ClassVar[QNetworkProxy.ProxyType] = ...
        Socks5Proxy: typing.ClassVar[QNetworkProxy.ProxyType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QNetworkProxy.ProxyType: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkProxy.ProxyType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QNetworkProxy.ProxyType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkProxy.ProxyType: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QNetworkProxy.ProxyType: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkProxy.ProxyType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QNetworkProxy.ProxyType: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkProxy.ProxyType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QNetworkProxy.ProxyType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkProxy.ProxyType: ...
        def __sub__(self, other: typing.SupportsInt) -> QNetworkProxy.ProxyType: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkProxy.ProxyType: ...
    CachingCapability: typing.ClassVar[QNetworkProxy.Capability] = ...
    DefaultProxy: typing.ClassVar[QNetworkProxy.ProxyType] = ...
    FtpCachingProxy: typing.ClassVar[QNetworkProxy.ProxyType] = ...
    HostNameLookupCapability: typing.ClassVar[QNetworkProxy.Capability] = ...
    HttpCachingProxy: typing.ClassVar[QNetworkProxy.ProxyType] = ...
    HttpProxy: typing.ClassVar[QNetworkProxy.ProxyType] = ...
    ListeningCapability: typing.ClassVar[QNetworkProxy.Capability] = ...
    NoProxy: typing.ClassVar[QNetworkProxy.ProxyType] = ...
    SctpListeningCapability: typing.ClassVar[QNetworkProxy.Capability] = ...
    SctpTunnelingCapability: typing.ClassVar[QNetworkProxy.Capability] = ...
    Socks5Proxy: typing.ClassVar[QNetworkProxy.ProxyType] = ...
    TunnelingCapability: typing.ClassVar[QNetworkProxy.Capability] = ...
    UdpTunnelingCapability: typing.ClassVar[QNetworkProxy.Capability] = ...
    @typing.overload
    def __init__(self, type: QNetworkProxy.ProxyType, hostName: str = ..., port: int = ..., user: str = ..., password: str = ...) -> None: ...
    @typing.overload
    def __init__(self, other: QNetworkProxy) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @staticmethod
    def applicationProxy() -> QNetworkProxy: ...
    def capabilities(self) -> QNetworkProxy.Capabilities | QNetworkProxy.Capability: ...
    def hasRawHeader(self, headerName: PySide2.QtCore.QByteArray | bytes) -> bool: ...
    def header(self, header: QNetworkRequest.KnownHeaders) -> typing.Any: ...
    def hostName(self) -> str: ...
    def isCachingProxy(self) -> bool: ...
    def isTransparentProxy(self) -> bool: ...
    def password(self) -> str: ...
    def port(self) -> int: ...
    def rawHeader(self, headerName: PySide2.QtCore.QByteArray | bytes) -> PySide2.QtCore.QByteArray: ...
    def rawHeaderList(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    @staticmethod
    def setApplicationProxy(proxy: QNetworkProxy) -> None: ...
    def setCapabilities(self, capab: QNetworkProxy.Capabilities | QNetworkProxy.Capability) -> None: ...
    def setHeader(self, header: QNetworkRequest.KnownHeaders, value: typing.Any) -> None: ...
    def setHostName(self, hostName: str) -> None: ...
    def setPassword(self, password: str) -> None: ...
    def setPort(self, port: int) -> None: ...
    def setRawHeader(self, headerName: PySide2.QtCore.QByteArray | bytes, value: PySide2.QtCore.QByteArray | bytes) -> None: ...
    def setType(self, type: QNetworkProxy.ProxyType) -> None: ...
    def setUser(self, userName: str) -> None: ...
    def swap(self, other: QNetworkProxy) -> None: ...
    def type(self) -> QNetworkProxy.ProxyType: ...
    def user(self) -> str: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QNetworkProxyFactory(shiboken2.Object):
    def __init__(self) -> None: ...
    @staticmethod
    def proxyForQuery(query: QNetworkProxyQuery) -> typing.List[QNetworkProxy]: ...
    def queryProxy(self, query: QNetworkProxyQuery = ...) -> typing.List[QNetworkProxy]: ...
    @staticmethod
    def setApplicationProxyFactory(factory: QNetworkProxyFactory) -> None: ...
    @staticmethod
    def setUseSystemConfiguration(enable: bool) -> None: ...
    @staticmethod
    def systemProxyForQuery(query: QNetworkProxyQuery = ...) -> typing.List[QNetworkProxy]: ...
    @staticmethod
    def usesSystemConfiguration() -> bool: ...

class QNetworkProxyQuery(shiboken2.Object):
    class QueryType:
        SctpServer: typing.ClassVar[QNetworkProxyQuery.QueryType] = ...
        SctpSocket: typing.ClassVar[QNetworkProxyQuery.QueryType] = ...
        TcpServer: typing.ClassVar[QNetworkProxyQuery.QueryType] = ...
        TcpSocket: typing.ClassVar[QNetworkProxyQuery.QueryType] = ...
        UdpSocket: typing.ClassVar[QNetworkProxyQuery.QueryType] = ...
        UrlRequest: typing.ClassVar[QNetworkProxyQuery.QueryType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QNetworkProxyQuery.QueryType: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkProxyQuery.QueryType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QNetworkProxyQuery.QueryType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkProxyQuery.QueryType: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QNetworkProxyQuery.QueryType: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkProxyQuery.QueryType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QNetworkProxyQuery.QueryType: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkProxyQuery.QueryType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QNetworkProxyQuery.QueryType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkProxyQuery.QueryType: ...
        def __sub__(self, other: typing.SupportsInt) -> QNetworkProxyQuery.QueryType: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkProxyQuery.QueryType: ...
    SctpServer: typing.ClassVar[QNetworkProxyQuery.QueryType] = ...
    SctpSocket: typing.ClassVar[QNetworkProxyQuery.QueryType] = ...
    TcpServer: typing.ClassVar[QNetworkProxyQuery.QueryType] = ...
    TcpSocket: typing.ClassVar[QNetworkProxyQuery.QueryType] = ...
    UdpSocket: typing.ClassVar[QNetworkProxyQuery.QueryType] = ...
    UrlRequest: typing.ClassVar[QNetworkProxyQuery.QueryType] = ...
    @typing.overload
    def __init__(self, networkConfiguration: QNetworkConfiguration, hostname: str, port: int, protocolTag: str = ..., queryType: QNetworkProxyQuery.QueryType = ...) -> None: ...
    @typing.overload
    def __init__(self, networkConfiguration: QNetworkConfiguration, bindPort: int, protocolTag: str = ..., queryType: QNetworkProxyQuery.QueryType = ...) -> None: ...
    @typing.overload
    def __init__(self, hostname: str, port: int, protocolTag: str = ..., queryType: QNetworkProxyQuery.QueryType = ...) -> None: ...
    @typing.overload
    def __init__(self, networkConfiguration: QNetworkConfiguration, requestUrl: PySide2.QtCore.QUrl, queryType: QNetworkProxyQuery.QueryType = ...) -> None: ...
    @typing.overload
    def __init__(self, bindPort: int, protocolTag: str = ..., queryType: QNetworkProxyQuery.QueryType = ...) -> None: ...
    @typing.overload
    def __init__(self, requestUrl: PySide2.QtCore.QUrl, queryType: QNetworkProxyQuery.QueryType = ...) -> None: ...
    @typing.overload
    def __init__(self, other: QNetworkProxyQuery) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def localPort(self) -> int: ...
    def networkConfiguration(self) -> QNetworkConfiguration: ...
    def peerHostName(self) -> str: ...
    def peerPort(self) -> int: ...
    def protocolTag(self) -> str: ...
    def queryType(self) -> QNetworkProxyQuery.QueryType: ...
    def setLocalPort(self, port: int) -> None: ...
    def setNetworkConfiguration(self, networkConfiguration: QNetworkConfiguration) -> None: ...
    def setPeerHostName(self, hostname: str) -> None: ...
    def setPeerPort(self, port: int) -> None: ...
    def setProtocolTag(self, protocolTag: str) -> None: ...
    def setQueryType(self, type: QNetworkProxyQuery.QueryType) -> None: ...
    def setUrl(self, url: PySide2.QtCore.QUrl) -> None: ...
    def swap(self, other: QNetworkProxyQuery) -> None: ...
    def url(self) -> PySide2.QtCore.QUrl: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QNetworkReply(PySide2.QtCore.QIODevice):
    class NetworkError:
        AuthenticationRequiredError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        BackgroundRequestNotAllowedError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        ConnectionRefusedError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        ContentAccessDenied: typing.ClassVar[QNetworkReply.NetworkError] = ...
        ContentConflictError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        ContentGoneError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        ContentNotFoundError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        ContentOperationNotPermittedError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        ContentReSendError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        HostNotFoundError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        InsecureRedirectError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        InternalServerError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        NetworkSessionFailedError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        NoError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        OperationCanceledError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        OperationNotImplementedError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        ProtocolFailure: typing.ClassVar[QNetworkReply.NetworkError] = ...
        ProtocolInvalidOperationError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        ProtocolUnknownError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        ProxyAuthenticationRequiredError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        ProxyConnectionClosedError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        ProxyConnectionRefusedError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        ProxyNotFoundError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        ProxyTimeoutError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        RemoteHostClosedError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        ServiceUnavailableError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        SslHandshakeFailedError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        TemporaryNetworkFailureError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        TimeoutError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        TooManyRedirectsError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        UnknownContentError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        UnknownNetworkError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        UnknownProxyError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        UnknownServerError: typing.ClassVar[QNetworkReply.NetworkError] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QNetworkReply.NetworkError: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkReply.NetworkError: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QNetworkReply.NetworkError: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkReply.NetworkError: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QNetworkReply.NetworkError: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkReply.NetworkError: ...
        def __rmul__(self, other: typing.SupportsInt) -> QNetworkReply.NetworkError: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkReply.NetworkError: ...
        def __rsub__(self, other: typing.SupportsInt) -> QNetworkReply.NetworkError: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkReply.NetworkError: ...
        def __sub__(self, other: typing.SupportsInt) -> QNetworkReply.NetworkError: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkReply.NetworkError: ...
    AuthenticationRequiredError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    BackgroundRequestNotAllowedError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    ConnectionRefusedError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    ContentAccessDenied: typing.ClassVar[QNetworkReply.NetworkError] = ...
    ContentConflictError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    ContentGoneError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    ContentNotFoundError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    ContentOperationNotPermittedError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    ContentReSendError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    HostNotFoundError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    InsecureRedirectError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    InternalServerError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    NetworkSessionFailedError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    NoError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    OperationCanceledError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    OperationNotImplementedError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    ProtocolFailure: typing.ClassVar[QNetworkReply.NetworkError] = ...
    ProtocolInvalidOperationError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    ProtocolUnknownError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    ProxyAuthenticationRequiredError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    ProxyConnectionClosedError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    ProxyConnectionRefusedError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    ProxyNotFoundError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    ProxyTimeoutError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    RemoteHostClosedError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    ServiceUnavailableError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    SslHandshakeFailedError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    TemporaryNetworkFailureError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    TimeoutError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    TooManyRedirectsError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    UnknownContentError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    UnknownNetworkError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    UnknownProxyError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    UnknownServerError: typing.ClassVar[QNetworkReply.NetworkError] = ...
    downloadProgress: typing.ClassVar[PySide2.QtCore.Signal] = ...
    encrypted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    errorOccurred: typing.ClassVar[PySide2.QtCore.Signal] = ...
    finished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    metaDataChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    preSharedKeyAuthenticationRequired: typing.ClassVar[PySide2.QtCore.Signal] = ...
    redirectAllowed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    redirected: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sslErrors: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    uploadProgress: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def abort(self) -> None: ...
    def attribute(self, code: QNetworkRequest.Attribute) -> typing.Any: ...
    def close(self) -> None: ...
    def hasRawHeader(self, headerName: PySide2.QtCore.QByteArray | bytes) -> bool: ...
    def header(self, header: QNetworkRequest.KnownHeaders) -> typing.Any: ...
    @typing.overload
    def ignoreSslErrors(self, errors: typing.Iterable[QSslError]) -> None: ...
    @typing.overload
    def ignoreSslErrors(self) -> None: ...
    def ignoreSslErrorsImplementation(self, arg__1: typing.Iterable[QSslError]) -> None: ...
    def isFinished(self) -> bool: ...
    def isRunning(self) -> bool: ...
    def isSequential(self) -> bool: ...
    def manager(self) -> QNetworkAccessManager: ...
    def operation(self) -> QNetworkAccessManager.Operation: ...
    def rawHeader(self, headerName: PySide2.QtCore.QByteArray | bytes) -> PySide2.QtCore.QByteArray: ...
    def rawHeaderList(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def rawHeaderPairs(self) -> typing.List[typing.Tuple[PySide2.QtCore.QByteArray, PySide2.QtCore.QByteArray]]: ...
    def readBufferSize(self) -> int: ...
    def request(self) -> QNetworkRequest: ...
    def setAttribute(self, code: QNetworkRequest.Attribute, value: typing.Any) -> None: ...
    def setError(self, errorCode: QNetworkReply.NetworkError, errorString: str) -> None: ...
    def setFinished(self, arg__1: bool) -> None: ...
    def setHeader(self, header: QNetworkRequest.KnownHeaders, value: typing.Any) -> None: ...
    def setOperation(self, operation: QNetworkAccessManager.Operation) -> None: ...
    def setRawHeader(self, headerName: PySide2.QtCore.QByteArray | bytes, value: PySide2.QtCore.QByteArray | bytes) -> None: ...
    def setReadBufferSize(self, size: int) -> None: ...
    def setRequest(self, request: QNetworkRequest) -> None: ...
    def setSslConfiguration(self, configuration: QSslConfiguration) -> None: ...
    def setSslConfigurationImplementation(self, arg__1: QSslConfiguration) -> None: ...
    def setUrl(self, url: PySide2.QtCore.QUrl) -> None: ...
    def sslConfiguration(self) -> QSslConfiguration: ...
    def sslConfigurationImplementation(self, arg__1: QSslConfiguration) -> None: ...
    def url(self) -> PySide2.QtCore.QUrl: ...
    def writeData(self, data: bytes, len: int) -> int: ...

class QNetworkRequest(shiboken2.Object):
    class Attribute:
        AuthenticationReuseAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        AutoDeleteReplyOnFinishAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        BackgroundRequestAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        CacheLoadControlAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        CacheSaveControlAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        ConnectionEncryptedAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        CookieLoadControlAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        CookieSaveControlAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        CustomVerbAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        DoNotBufferUploadDataAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        DownloadBufferAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        EmitAllUploadProgressSignalsAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        FollowRedirectsAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        HTTP2AllowedAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        HTTP2WasUsedAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        Http2AllowedAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        Http2DirectAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        Http2WasUsedAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        HttpPipeliningAllowedAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        HttpPipeliningWasUsedAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        HttpReasonPhraseAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        HttpStatusCodeAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        MaximumDownloadBufferSizeAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        OriginalContentLengthAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        RedirectPolicyAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        RedirectionTargetAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        ResourceTypeAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        SourceIsFromCacheAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        SpdyAllowedAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        SpdyWasUsedAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        SynchronousRequestAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
        User: typing.ClassVar[QNetworkRequest.Attribute] = ...
        UserMax: typing.ClassVar[QNetworkRequest.Attribute] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QNetworkRequest.Attribute: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkRequest.Attribute: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QNetworkRequest.Attribute: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkRequest.Attribute: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QNetworkRequest.Attribute: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkRequest.Attribute: ...
        def __rmul__(self, other: typing.SupportsInt) -> QNetworkRequest.Attribute: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkRequest.Attribute: ...
        def __rsub__(self, other: typing.SupportsInt) -> QNetworkRequest.Attribute: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkRequest.Attribute: ...
        def __sub__(self, other: typing.SupportsInt) -> QNetworkRequest.Attribute: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkRequest.Attribute: ...

    class CacheLoadControl:
        AlwaysCache: typing.ClassVar[QNetworkRequest.CacheLoadControl] = ...
        AlwaysNetwork: typing.ClassVar[QNetworkRequest.CacheLoadControl] = ...
        PreferCache: typing.ClassVar[QNetworkRequest.CacheLoadControl] = ...
        PreferNetwork: typing.ClassVar[QNetworkRequest.CacheLoadControl] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QNetworkRequest.CacheLoadControl: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkRequest.CacheLoadControl: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QNetworkRequest.CacheLoadControl: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkRequest.CacheLoadControl: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QNetworkRequest.CacheLoadControl: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkRequest.CacheLoadControl: ...
        def __rmul__(self, other: typing.SupportsInt) -> QNetworkRequest.CacheLoadControl: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkRequest.CacheLoadControl: ...
        def __rsub__(self, other: typing.SupportsInt) -> QNetworkRequest.CacheLoadControl: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkRequest.CacheLoadControl: ...
        def __sub__(self, other: typing.SupportsInt) -> QNetworkRequest.CacheLoadControl: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkRequest.CacheLoadControl: ...

    class KnownHeaders:
        ContentDispositionHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
        ContentLengthHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
        ContentTypeHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
        CookieHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
        ETagHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
        IfMatchHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
        IfModifiedSinceHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
        IfNoneMatchHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
        LastModifiedHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
        LocationHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
        ServerHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
        SetCookieHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
        UserAgentHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QNetworkRequest.KnownHeaders: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkRequest.KnownHeaders: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QNetworkRequest.KnownHeaders: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkRequest.KnownHeaders: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QNetworkRequest.KnownHeaders: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkRequest.KnownHeaders: ...
        def __rmul__(self, other: typing.SupportsInt) -> QNetworkRequest.KnownHeaders: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkRequest.KnownHeaders: ...
        def __rsub__(self, other: typing.SupportsInt) -> QNetworkRequest.KnownHeaders: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkRequest.KnownHeaders: ...
        def __sub__(self, other: typing.SupportsInt) -> QNetworkRequest.KnownHeaders: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkRequest.KnownHeaders: ...

    class LoadControl:
        Automatic: typing.ClassVar[QNetworkRequest.LoadControl] = ...
        Manual: typing.ClassVar[QNetworkRequest.LoadControl] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QNetworkRequest.LoadControl: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkRequest.LoadControl: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QNetworkRequest.LoadControl: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkRequest.LoadControl: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QNetworkRequest.LoadControl: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkRequest.LoadControl: ...
        def __rmul__(self, other: typing.SupportsInt) -> QNetworkRequest.LoadControl: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkRequest.LoadControl: ...
        def __rsub__(self, other: typing.SupportsInt) -> QNetworkRequest.LoadControl: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkRequest.LoadControl: ...
        def __sub__(self, other: typing.SupportsInt) -> QNetworkRequest.LoadControl: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkRequest.LoadControl: ...

    class Priority:
        HighPriority: typing.ClassVar[QNetworkRequest.Priority] = ...
        LowPriority: typing.ClassVar[QNetworkRequest.Priority] = ...
        NormalPriority: typing.ClassVar[QNetworkRequest.Priority] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QNetworkRequest.Priority: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkRequest.Priority: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QNetworkRequest.Priority: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkRequest.Priority: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QNetworkRequest.Priority: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkRequest.Priority: ...
        def __rmul__(self, other: typing.SupportsInt) -> QNetworkRequest.Priority: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkRequest.Priority: ...
        def __rsub__(self, other: typing.SupportsInt) -> QNetworkRequest.Priority: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkRequest.Priority: ...
        def __sub__(self, other: typing.SupportsInt) -> QNetworkRequest.Priority: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkRequest.Priority: ...

    class RedirectPolicy:
        ManualRedirectPolicy: typing.ClassVar[QNetworkRequest.RedirectPolicy] = ...
        NoLessSafeRedirectPolicy: typing.ClassVar[QNetworkRequest.RedirectPolicy] = ...
        SameOriginRedirectPolicy: typing.ClassVar[QNetworkRequest.RedirectPolicy] = ...
        UserVerifiedRedirectPolicy: typing.ClassVar[QNetworkRequest.RedirectPolicy] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QNetworkRequest.RedirectPolicy: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkRequest.RedirectPolicy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QNetworkRequest.RedirectPolicy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkRequest.RedirectPolicy: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QNetworkRequest.RedirectPolicy: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkRequest.RedirectPolicy: ...
        def __rmul__(self, other: typing.SupportsInt) -> QNetworkRequest.RedirectPolicy: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkRequest.RedirectPolicy: ...
        def __rsub__(self, other: typing.SupportsInt) -> QNetworkRequest.RedirectPolicy: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkRequest.RedirectPolicy: ...
        def __sub__(self, other: typing.SupportsInt) -> QNetworkRequest.RedirectPolicy: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkRequest.RedirectPolicy: ...

    class TransferTimeoutConstant:
        DefaultTransferTimeoutConstant: typing.ClassVar[QNetworkRequest.TransferTimeoutConstant] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QNetworkRequest.TransferTimeoutConstant: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkRequest.TransferTimeoutConstant: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QNetworkRequest.TransferTimeoutConstant: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkRequest.TransferTimeoutConstant: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QNetworkRequest.TransferTimeoutConstant: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkRequest.TransferTimeoutConstant: ...
        def __rmul__(self, other: typing.SupportsInt) -> QNetworkRequest.TransferTimeoutConstant: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkRequest.TransferTimeoutConstant: ...
        def __rsub__(self, other: typing.SupportsInt) -> QNetworkRequest.TransferTimeoutConstant: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkRequest.TransferTimeoutConstant: ...
        def __sub__(self, other: typing.SupportsInt) -> QNetworkRequest.TransferTimeoutConstant: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkRequest.TransferTimeoutConstant: ...
    AlwaysCache: typing.ClassVar[QNetworkRequest.CacheLoadControl] = ...
    AlwaysNetwork: typing.ClassVar[QNetworkRequest.CacheLoadControl] = ...
    AuthenticationReuseAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    AutoDeleteReplyOnFinishAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    Automatic: typing.ClassVar[QNetworkRequest.LoadControl] = ...
    BackgroundRequestAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    CacheLoadControlAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    CacheSaveControlAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    ConnectionEncryptedAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    ContentDispositionHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
    ContentLengthHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
    ContentTypeHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
    CookieHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
    CookieLoadControlAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    CookieSaveControlAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    CustomVerbAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    DefaultTransferTimeoutConstant: typing.ClassVar[QNetworkRequest.TransferTimeoutConstant] = ...
    DoNotBufferUploadDataAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    DownloadBufferAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    ETagHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
    EmitAllUploadProgressSignalsAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    FollowRedirectsAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    HTTP2AllowedAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    HTTP2WasUsedAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    HighPriority: typing.ClassVar[QNetworkRequest.Priority] = ...
    Http2AllowedAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    Http2DirectAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    Http2WasUsedAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    HttpPipeliningAllowedAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    HttpPipeliningWasUsedAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    HttpReasonPhraseAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    HttpStatusCodeAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    IfMatchHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
    IfModifiedSinceHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
    IfNoneMatchHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
    LastModifiedHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
    LocationHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
    LowPriority: typing.ClassVar[QNetworkRequest.Priority] = ...
    Manual: typing.ClassVar[QNetworkRequest.LoadControl] = ...
    ManualRedirectPolicy: typing.ClassVar[QNetworkRequest.RedirectPolicy] = ...
    MaximumDownloadBufferSizeAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    NoLessSafeRedirectPolicy: typing.ClassVar[QNetworkRequest.RedirectPolicy] = ...
    NormalPriority: typing.ClassVar[QNetworkRequest.Priority] = ...
    OriginalContentLengthAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    PreferCache: typing.ClassVar[QNetworkRequest.CacheLoadControl] = ...
    PreferNetwork: typing.ClassVar[QNetworkRequest.CacheLoadControl] = ...
    RedirectPolicyAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    RedirectionTargetAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    ResourceTypeAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    SameOriginRedirectPolicy: typing.ClassVar[QNetworkRequest.RedirectPolicy] = ...
    ServerHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
    SetCookieHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
    SourceIsFromCacheAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    SpdyAllowedAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    SpdyWasUsedAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    SynchronousRequestAttribute: typing.ClassVar[QNetworkRequest.Attribute] = ...
    User: typing.ClassVar[QNetworkRequest.Attribute] = ...
    UserAgentHeader: typing.ClassVar[QNetworkRequest.KnownHeaders] = ...
    UserMax: typing.ClassVar[QNetworkRequest.Attribute] = ...
    UserVerifiedRedirectPolicy: typing.ClassVar[QNetworkRequest.RedirectPolicy] = ...
    @typing.overload
    def __init__(self, url: PySide2.QtCore.QUrl) -> None: ...
    @typing.overload
    def __init__(self, other: QNetworkRequest) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def attribute(self, code: QNetworkRequest.Attribute, defaultValue: typing.Any = ...) -> typing.Any: ...
    def hasRawHeader(self, headerName: PySide2.QtCore.QByteArray | bytes) -> bool: ...
    def header(self, header: QNetworkRequest.KnownHeaders) -> typing.Any: ...
    def maximumRedirectsAllowed(self) -> int: ...
    def originatingObject(self) -> PySide2.QtCore.QObject: ...
    def peerVerifyName(self) -> str: ...
    def priority(self) -> QNetworkRequest.Priority: ...
    def rawHeader(self, headerName: PySide2.QtCore.QByteArray | bytes) -> PySide2.QtCore.QByteArray: ...
    def rawHeaderList(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def setAttribute(self, code: QNetworkRequest.Attribute, value: typing.Any) -> None: ...
    def setHeader(self, header: QNetworkRequest.KnownHeaders, value: typing.Any) -> None: ...
    def setMaximumRedirectsAllowed(self, maximumRedirectsAllowed: int) -> None: ...
    def setOriginatingObject(self, object: PySide2.QtCore.QObject) -> None: ...
    def setPeerVerifyName(self, peerName: str) -> None: ...
    def setPriority(self, priority: QNetworkRequest.Priority) -> None: ...
    def setRawHeader(self, headerName: PySide2.QtCore.QByteArray | bytes, value: PySide2.QtCore.QByteArray | bytes) -> None: ...
    def setSslConfiguration(self, configuration: QSslConfiguration) -> None: ...
    def setTransferTimeout(self, timeout: int = ...) -> None: ...
    def setUrl(self, url: PySide2.QtCore.QUrl) -> None: ...
    def sslConfiguration(self) -> QSslConfiguration: ...
    def swap(self, other: QNetworkRequest) -> None: ...
    def transferTimeout(self) -> int: ...
    def url(self) -> PySide2.QtCore.QUrl: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QNetworkSession(PySide2.QtCore.QObject):
    class SessionError:
        InvalidConfigurationError: typing.ClassVar[QNetworkSession.SessionError] = ...
        OperationNotSupportedError: typing.ClassVar[QNetworkSession.SessionError] = ...
        RoamingError: typing.ClassVar[QNetworkSession.SessionError] = ...
        SessionAbortedError: typing.ClassVar[QNetworkSession.SessionError] = ...
        UnknownSessionError: typing.ClassVar[QNetworkSession.SessionError] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QNetworkSession.SessionError: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkSession.SessionError: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QNetworkSession.SessionError: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkSession.SessionError: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QNetworkSession.SessionError: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkSession.SessionError: ...
        def __rmul__(self, other: typing.SupportsInt) -> QNetworkSession.SessionError: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkSession.SessionError: ...
        def __rsub__(self, other: typing.SupportsInt) -> QNetworkSession.SessionError: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkSession.SessionError: ...
        def __sub__(self, other: typing.SupportsInt) -> QNetworkSession.SessionError: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkSession.SessionError: ...

    class State:
        Closing: typing.ClassVar[QNetworkSession.State] = ...
        Connected: typing.ClassVar[QNetworkSession.State] = ...
        Connecting: typing.ClassVar[QNetworkSession.State] = ...
        Disconnected: typing.ClassVar[QNetworkSession.State] = ...
        Invalid: typing.ClassVar[QNetworkSession.State] = ...
        NotAvailable: typing.ClassVar[QNetworkSession.State] = ...
        Roaming: typing.ClassVar[QNetworkSession.State] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QNetworkSession.State: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkSession.State: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QNetworkSession.State: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkSession.State: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QNetworkSession.State: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkSession.State: ...
        def __rmul__(self, other: typing.SupportsInt) -> QNetworkSession.State: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkSession.State: ...
        def __rsub__(self, other: typing.SupportsInt) -> QNetworkSession.State: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkSession.State: ...
        def __sub__(self, other: typing.SupportsInt) -> QNetworkSession.State: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkSession.State: ...

    class UsagePolicies:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkSession.UsagePolicies: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QNetworkSession.UsagePolicies: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkSession.UsagePolicies: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkSession.UsagePolicies: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkSession.UsagePolicies: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkSession.UsagePolicies: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkSession.UsagePolicies: ...

    class UsagePolicy:
        NoBackgroundTrafficPolicy: typing.ClassVar[QNetworkSession.UsagePolicy] = ...
        NoPolicy: typing.ClassVar[QNetworkSession.UsagePolicy] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QNetworkSession.UsagePolicies: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QNetworkSession.UsagePolicies: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNetworkSession.UsagePolicies: ...
        def __rand__(self, other: typing.SupportsInt) -> QNetworkSession.UsagePolicies: ...
        def __ror__(self, other: typing.SupportsInt) -> QNetworkSession.UsagePolicies: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNetworkSession.UsagePolicies: ...
        def __xor__(self, other: typing.SupportsInt) -> QNetworkSession.UsagePolicies: ...
    Closing: typing.ClassVar[QNetworkSession.State] = ...
    Connected: typing.ClassVar[QNetworkSession.State] = ...
    Connecting: typing.ClassVar[QNetworkSession.State] = ...
    Disconnected: typing.ClassVar[QNetworkSession.State] = ...
    Invalid: typing.ClassVar[QNetworkSession.State] = ...
    InvalidConfigurationError: typing.ClassVar[QNetworkSession.SessionError] = ...
    NoBackgroundTrafficPolicy: typing.ClassVar[QNetworkSession.UsagePolicy] = ...
    NoPolicy: typing.ClassVar[QNetworkSession.UsagePolicy] = ...
    NotAvailable: typing.ClassVar[QNetworkSession.State] = ...
    OperationNotSupportedError: typing.ClassVar[QNetworkSession.SessionError] = ...
    Roaming: typing.ClassVar[QNetworkSession.State] = ...
    RoamingError: typing.ClassVar[QNetworkSession.SessionError] = ...
    SessionAbortedError: typing.ClassVar[QNetworkSession.SessionError] = ...
    UnknownSessionError: typing.ClassVar[QNetworkSession.SessionError] = ...
    closed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    newConfigurationActivated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    opened: typing.ClassVar[PySide2.QtCore.Signal] = ...
    preferredConfigurationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    usagePoliciesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, connConfig: QNetworkConfiguration, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def accept(self) -> None: ...
    def activeTime(self) -> int: ...
    def bytesReceived(self) -> int: ...
    def bytesWritten(self) -> int: ...
    def close(self) -> None: ...
    def configuration(self) -> QNetworkConfiguration: ...
    def connectNotify(self, signal: PySide2.QtCore.QMetaMethod) -> None: ...
    def disconnectNotify(self, signal: PySide2.QtCore.QMetaMethod) -> None: ...
    def errorString(self) -> str: ...
    def ignore(self) -> None: ...
    def interface(self) -> QNetworkInterface: ...
    def isOpen(self) -> bool: ...
    def migrate(self) -> None: ...
    def open(self) -> None: ...
    def reject(self) -> None: ...
    def sessionProperty(self, key: str) -> typing.Any: ...
    def setSessionProperty(self, key: str, value: typing.Any) -> None: ...
    def state(self) -> QNetworkSession.State: ...
    def stop(self) -> None: ...
    def usagePolicies(self) -> QNetworkSession.UsagePolicies | QNetworkSession.UsagePolicy: ...
    def waitForOpened(self, msecs: int = ...) -> bool: ...

class QOcspCertificateStatus:
    Good: typing.ClassVar[QOcspCertificateStatus] = ...
    Revoked: typing.ClassVar[QOcspCertificateStatus] = ...
    Unknown: typing.ClassVar[QOcspCertificateStatus] = ...
    values: typing.ClassVar[dict] = ...
    name: _typeshed.Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def __add__(self, other: typing.SupportsInt) -> QOcspCertificateStatus: ...
    def __and__(self, other: typing.SupportsInt) -> QOcspCertificateStatus: ...
    def __bool__(self) -> bool: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __mul__(self, other: typing.SupportsInt) -> QOcspCertificateStatus: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: typing.SupportsInt) -> QOcspCertificateStatus: ...
    def __pos__(self): ...
    def __radd__(self, other: typing.SupportsInt) -> QOcspCertificateStatus: ...
    def __rand__(self, other: typing.SupportsInt) -> QOcspCertificateStatus: ...
    def __rmul__(self, other: typing.SupportsInt) -> QOcspCertificateStatus: ...
    def __ror__(self, other: typing.SupportsInt) -> QOcspCertificateStatus: ...
    def __rsub__(self, other: typing.SupportsInt) -> QOcspCertificateStatus: ...
    def __rxor__(self, other: typing.SupportsInt) -> QOcspCertificateStatus: ...
    def __sub__(self, other: typing.SupportsInt) -> QOcspCertificateStatus: ...
    def __xor__(self, other: typing.SupportsInt) -> QOcspCertificateStatus: ...

class QOcspResponse(shiboken2.Object):
    @typing.overload
    def __init__(self, other: QOcspResponse) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def certificateStatus(self) -> QOcspCertificateStatus: ...
    def revocationReason(self) -> QOcspRevocationReason: ...
    def subject(self) -> QSslCertificate: ...
    def swap(self, other: QOcspResponse) -> None: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QOcspRevocationReason:
    AffiliationChanged: typing.ClassVar[QOcspRevocationReason] = ...
    CACompromise: typing.ClassVar[QOcspRevocationReason] = ...
    CertificateHold: typing.ClassVar[QOcspRevocationReason] = ...
    CessationOfOperation: typing.ClassVar[QOcspRevocationReason] = ...
    KeyCompromise: typing.ClassVar[QOcspRevocationReason] = ...
    None_: typing.ClassVar[QOcspRevocationReason] = ...
    RemoveFromCRL: typing.ClassVar[QOcspRevocationReason] = ...
    Superseded: typing.ClassVar[QOcspRevocationReason] = ...
    Unspecified: typing.ClassVar[QOcspRevocationReason] = ...
    values: typing.ClassVar[dict] = ...
    name: _typeshed.Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def __add__(self, other: typing.SupportsInt) -> QOcspRevocationReason: ...
    def __and__(self, other: typing.SupportsInt) -> QOcspRevocationReason: ...
    def __bool__(self) -> bool: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __mul__(self, other: typing.SupportsInt) -> QOcspRevocationReason: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: typing.SupportsInt) -> QOcspRevocationReason: ...
    def __pos__(self): ...
    def __radd__(self, other: typing.SupportsInt) -> QOcspRevocationReason: ...
    def __rand__(self, other: typing.SupportsInt) -> QOcspRevocationReason: ...
    def __rmul__(self, other: typing.SupportsInt) -> QOcspRevocationReason: ...
    def __ror__(self, other: typing.SupportsInt) -> QOcspRevocationReason: ...
    def __rsub__(self, other: typing.SupportsInt) -> QOcspRevocationReason: ...
    def __rxor__(self, other: typing.SupportsInt) -> QOcspRevocationReason: ...
    def __sub__(self, other: typing.SupportsInt) -> QOcspRevocationReason: ...
    def __xor__(self, other: typing.SupportsInt) -> QOcspRevocationReason: ...

class QPasswordDigestor(shiboken2.Object):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @staticmethod
    def deriveKeyPbkdf1(algorithm: PySide2.QtCore.QCryptographicHash.Algorithm, password: PySide2.QtCore.QByteArray | bytes, salt: PySide2.QtCore.QByteArray | bytes, iterations: int, dkLen: int) -> PySide2.QtCore.QByteArray: ...
    @staticmethod
    def deriveKeyPbkdf2(algorithm: PySide2.QtCore.QCryptographicHash.Algorithm, password: PySide2.QtCore.QByteArray | bytes, salt: PySide2.QtCore.QByteArray | bytes, iterations: int, dkLen: int) -> PySide2.QtCore.QByteArray: ...

class QSsl(shiboken2.Object):
    class AlternativeNameEntryType:
        DnsEntry: typing.ClassVar[QSsl.AlternativeNameEntryType] = ...
        EmailEntry: typing.ClassVar[QSsl.AlternativeNameEntryType] = ...
        IpAddressEntry: typing.ClassVar[QSsl.AlternativeNameEntryType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSsl.AlternativeNameEntryType: ...
        def __and__(self, other: typing.SupportsInt) -> QSsl.AlternativeNameEntryType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSsl.AlternativeNameEntryType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSsl.AlternativeNameEntryType: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSsl.AlternativeNameEntryType: ...
        def __rand__(self, other: typing.SupportsInt) -> QSsl.AlternativeNameEntryType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSsl.AlternativeNameEntryType: ...
        def __ror__(self, other: typing.SupportsInt) -> QSsl.AlternativeNameEntryType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSsl.AlternativeNameEntryType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSsl.AlternativeNameEntryType: ...
        def __sub__(self, other: typing.SupportsInt) -> QSsl.AlternativeNameEntryType: ...
        def __xor__(self, other: typing.SupportsInt) -> QSsl.AlternativeNameEntryType: ...

    class EncodingFormat:
        Der: typing.ClassVar[QSsl.EncodingFormat] = ...
        Pem: typing.ClassVar[QSsl.EncodingFormat] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSsl.EncodingFormat: ...
        def __and__(self, other: typing.SupportsInt) -> QSsl.EncodingFormat: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSsl.EncodingFormat: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSsl.EncodingFormat: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSsl.EncodingFormat: ...
        def __rand__(self, other: typing.SupportsInt) -> QSsl.EncodingFormat: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSsl.EncodingFormat: ...
        def __ror__(self, other: typing.SupportsInt) -> QSsl.EncodingFormat: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSsl.EncodingFormat: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSsl.EncodingFormat: ...
        def __sub__(self, other: typing.SupportsInt) -> QSsl.EncodingFormat: ...
        def __xor__(self, other: typing.SupportsInt) -> QSsl.EncodingFormat: ...

    class KeyAlgorithm:
        Dh: typing.ClassVar[QSsl.KeyAlgorithm] = ...
        Dsa: typing.ClassVar[QSsl.KeyAlgorithm] = ...
        Ec: typing.ClassVar[QSsl.KeyAlgorithm] = ...
        Opaque: typing.ClassVar[QSsl.KeyAlgorithm] = ...
        Rsa: typing.ClassVar[QSsl.KeyAlgorithm] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSsl.KeyAlgorithm: ...
        def __and__(self, other: typing.SupportsInt) -> QSsl.KeyAlgorithm: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSsl.KeyAlgorithm: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSsl.KeyAlgorithm: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSsl.KeyAlgorithm: ...
        def __rand__(self, other: typing.SupportsInt) -> QSsl.KeyAlgorithm: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSsl.KeyAlgorithm: ...
        def __ror__(self, other: typing.SupportsInt) -> QSsl.KeyAlgorithm: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSsl.KeyAlgorithm: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSsl.KeyAlgorithm: ...
        def __sub__(self, other: typing.SupportsInt) -> QSsl.KeyAlgorithm: ...
        def __xor__(self, other: typing.SupportsInt) -> QSsl.KeyAlgorithm: ...

    class KeyType:
        PrivateKey: typing.ClassVar[QSsl.KeyType] = ...
        PublicKey: typing.ClassVar[QSsl.KeyType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSsl.KeyType: ...
        def __and__(self, other: typing.SupportsInt) -> QSsl.KeyType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSsl.KeyType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSsl.KeyType: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSsl.KeyType: ...
        def __rand__(self, other: typing.SupportsInt) -> QSsl.KeyType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSsl.KeyType: ...
        def __ror__(self, other: typing.SupportsInt) -> QSsl.KeyType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSsl.KeyType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSsl.KeyType: ...
        def __sub__(self, other: typing.SupportsInt) -> QSsl.KeyType: ...
        def __xor__(self, other: typing.SupportsInt) -> QSsl.KeyType: ...

    class SslOption:
        SslOptionDisableCompression: typing.ClassVar[QSsl.SslOption] = ...
        SslOptionDisableEmptyFragments: typing.ClassVar[QSsl.SslOption] = ...
        SslOptionDisableLegacyRenegotiation: typing.ClassVar[QSsl.SslOption] = ...
        SslOptionDisableServerCipherPreference: typing.ClassVar[QSsl.SslOption] = ...
        SslOptionDisableServerNameIndication: typing.ClassVar[QSsl.SslOption] = ...
        SslOptionDisableSessionPersistence: typing.ClassVar[QSsl.SslOption] = ...
        SslOptionDisableSessionSharing: typing.ClassVar[QSsl.SslOption] = ...
        SslOptionDisableSessionTickets: typing.ClassVar[QSsl.SslOption] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QSsl.SslOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QSsl.SslOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSsl.SslOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QSsl.SslOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QSsl.SslOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSsl.SslOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QSsl.SslOptions: ...

    class SslOptions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QSsl.SslOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QSsl.SslOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSsl.SslOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QSsl.SslOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QSsl.SslOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSsl.SslOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QSsl.SslOptions: ...

    class SslProtocol:
        AnyProtocol: typing.ClassVar[QSsl.SslProtocol] = ...
        DtlsV1_0: typing.ClassVar[QSsl.SslProtocol] = ...
        DtlsV1_0OrLater: typing.ClassVar[QSsl.SslProtocol] = ...
        DtlsV1_2: typing.ClassVar[QSsl.SslProtocol] = ...
        DtlsV1_2OrLater: typing.ClassVar[QSsl.SslProtocol] = ...
        SecureProtocols: typing.ClassVar[QSsl.SslProtocol] = ...
        SslV2: typing.ClassVar[QSsl.SslProtocol] = ...
        SslV3: typing.ClassVar[QSsl.SslProtocol] = ...
        TlsV1SslV3: typing.ClassVar[QSsl.SslProtocol] = ...
        TlsV1_0: typing.ClassVar[QSsl.SslProtocol] = ...
        TlsV1_0OrLater: typing.ClassVar[QSsl.SslProtocol] = ...
        TlsV1_1: typing.ClassVar[QSsl.SslProtocol] = ...
        TlsV1_1OrLater: typing.ClassVar[QSsl.SslProtocol] = ...
        TlsV1_2: typing.ClassVar[QSsl.SslProtocol] = ...
        TlsV1_2OrLater: typing.ClassVar[QSsl.SslProtocol] = ...
        TlsV1_3: typing.ClassVar[QSsl.SslProtocol] = ...
        TlsV1_3OrLater: typing.ClassVar[QSsl.SslProtocol] = ...
        UnknownProtocol: typing.ClassVar[QSsl.SslProtocol] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSsl.SslProtocol: ...
        def __and__(self, other: typing.SupportsInt) -> QSsl.SslProtocol: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSsl.SslProtocol: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSsl.SslProtocol: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSsl.SslProtocol: ...
        def __rand__(self, other: typing.SupportsInt) -> QSsl.SslProtocol: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSsl.SslProtocol: ...
        def __ror__(self, other: typing.SupportsInt) -> QSsl.SslProtocol: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSsl.SslProtocol: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSsl.SslProtocol: ...
        def __sub__(self, other: typing.SupportsInt) -> QSsl.SslProtocol: ...
        def __xor__(self, other: typing.SupportsInt) -> QSsl.SslProtocol: ...
    AnyProtocol: typing.ClassVar[QSsl.SslProtocol] = ...
    Der: typing.ClassVar[QSsl.EncodingFormat] = ...
    Dh: typing.ClassVar[QSsl.KeyAlgorithm] = ...
    DnsEntry: typing.ClassVar[QSsl.AlternativeNameEntryType] = ...
    Dsa: typing.ClassVar[QSsl.KeyAlgorithm] = ...
    DtlsV1_0: typing.ClassVar[QSsl.SslProtocol] = ...
    DtlsV1_0OrLater: typing.ClassVar[QSsl.SslProtocol] = ...
    DtlsV1_2: typing.ClassVar[QSsl.SslProtocol] = ...
    DtlsV1_2OrLater: typing.ClassVar[QSsl.SslProtocol] = ...
    Ec: typing.ClassVar[QSsl.KeyAlgorithm] = ...
    EmailEntry: typing.ClassVar[QSsl.AlternativeNameEntryType] = ...
    IpAddressEntry: typing.ClassVar[QSsl.AlternativeNameEntryType] = ...
    Opaque: typing.ClassVar[QSsl.KeyAlgorithm] = ...
    Pem: typing.ClassVar[QSsl.EncodingFormat] = ...
    PrivateKey: typing.ClassVar[QSsl.KeyType] = ...
    PublicKey: typing.ClassVar[QSsl.KeyType] = ...
    Rsa: typing.ClassVar[QSsl.KeyAlgorithm] = ...
    SecureProtocols: typing.ClassVar[QSsl.SslProtocol] = ...
    SslOptionDisableCompression: typing.ClassVar[QSsl.SslOption] = ...
    SslOptionDisableEmptyFragments: typing.ClassVar[QSsl.SslOption] = ...
    SslOptionDisableLegacyRenegotiation: typing.ClassVar[QSsl.SslOption] = ...
    SslOptionDisableServerCipherPreference: typing.ClassVar[QSsl.SslOption] = ...
    SslOptionDisableServerNameIndication: typing.ClassVar[QSsl.SslOption] = ...
    SslOptionDisableSessionPersistence: typing.ClassVar[QSsl.SslOption] = ...
    SslOptionDisableSessionSharing: typing.ClassVar[QSsl.SslOption] = ...
    SslOptionDisableSessionTickets: typing.ClassVar[QSsl.SslOption] = ...
    SslV2: typing.ClassVar[QSsl.SslProtocol] = ...
    SslV3: typing.ClassVar[QSsl.SslProtocol] = ...
    TlsV1SslV3: typing.ClassVar[QSsl.SslProtocol] = ...
    TlsV1_0: typing.ClassVar[QSsl.SslProtocol] = ...
    TlsV1_0OrLater: typing.ClassVar[QSsl.SslProtocol] = ...
    TlsV1_1: typing.ClassVar[QSsl.SslProtocol] = ...
    TlsV1_1OrLater: typing.ClassVar[QSsl.SslProtocol] = ...
    TlsV1_2: typing.ClassVar[QSsl.SslProtocol] = ...
    TlsV1_2OrLater: typing.ClassVar[QSsl.SslProtocol] = ...
    TlsV1_3: typing.ClassVar[QSsl.SslProtocol] = ...
    TlsV1_3OrLater: typing.ClassVar[QSsl.SslProtocol] = ...
    UnknownProtocol: typing.ClassVar[QSsl.SslProtocol] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...

class QSslCertificate(shiboken2.Object):
    class PatternSyntax:
        FixedString: typing.ClassVar[QSslCertificate.PatternSyntax] = ...
        RegularExpression: typing.ClassVar[QSslCertificate.PatternSyntax] = ...
        Wildcard: typing.ClassVar[QSslCertificate.PatternSyntax] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSslCertificate.PatternSyntax: ...
        def __and__(self, other: typing.SupportsInt) -> QSslCertificate.PatternSyntax: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSslCertificate.PatternSyntax: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSslCertificate.PatternSyntax: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSslCertificate.PatternSyntax: ...
        def __rand__(self, other: typing.SupportsInt) -> QSslCertificate.PatternSyntax: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSslCertificate.PatternSyntax: ...
        def __ror__(self, other: typing.SupportsInt) -> QSslCertificate.PatternSyntax: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSslCertificate.PatternSyntax: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSslCertificate.PatternSyntax: ...
        def __sub__(self, other: typing.SupportsInt) -> QSslCertificate.PatternSyntax: ...
        def __xor__(self, other: typing.SupportsInt) -> QSslCertificate.PatternSyntax: ...

    class SubjectInfo:
        CommonName: typing.ClassVar[QSslCertificate.SubjectInfo] = ...
        CountryName: typing.ClassVar[QSslCertificate.SubjectInfo] = ...
        DistinguishedNameQualifier: typing.ClassVar[QSslCertificate.SubjectInfo] = ...
        EmailAddress: typing.ClassVar[QSslCertificate.SubjectInfo] = ...
        LocalityName: typing.ClassVar[QSslCertificate.SubjectInfo] = ...
        Organization: typing.ClassVar[QSslCertificate.SubjectInfo] = ...
        OrganizationalUnitName: typing.ClassVar[QSslCertificate.SubjectInfo] = ...
        SerialNumber: typing.ClassVar[QSslCertificate.SubjectInfo] = ...
        StateOrProvinceName: typing.ClassVar[QSslCertificate.SubjectInfo] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSslCertificate.SubjectInfo: ...
        def __and__(self, other: typing.SupportsInt) -> QSslCertificate.SubjectInfo: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSslCertificate.SubjectInfo: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSslCertificate.SubjectInfo: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSslCertificate.SubjectInfo: ...
        def __rand__(self, other: typing.SupportsInt) -> QSslCertificate.SubjectInfo: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSslCertificate.SubjectInfo: ...
        def __ror__(self, other: typing.SupportsInt) -> QSslCertificate.SubjectInfo: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSslCertificate.SubjectInfo: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSslCertificate.SubjectInfo: ...
        def __sub__(self, other: typing.SupportsInt) -> QSslCertificate.SubjectInfo: ...
        def __xor__(self, other: typing.SupportsInt) -> QSslCertificate.SubjectInfo: ...
    CommonName: typing.ClassVar[QSslCertificate.SubjectInfo] = ...
    CountryName: typing.ClassVar[QSslCertificate.SubjectInfo] = ...
    DistinguishedNameQualifier: typing.ClassVar[QSslCertificate.SubjectInfo] = ...
    EmailAddress: typing.ClassVar[QSslCertificate.SubjectInfo] = ...
    LocalityName: typing.ClassVar[QSslCertificate.SubjectInfo] = ...
    Organization: typing.ClassVar[QSslCertificate.SubjectInfo] = ...
    OrganizationalUnitName: typing.ClassVar[QSslCertificate.SubjectInfo] = ...
    SerialNumber: typing.ClassVar[QSslCertificate.SubjectInfo] = ...
    StateOrProvinceName: typing.ClassVar[QSslCertificate.SubjectInfo] = ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice, format: QSsl.EncodingFormat = ...) -> None: ...
    @typing.overload
    def __init__(self, data: PySide2.QtCore.QByteArray | bytes = ..., format: QSsl.EncodingFormat = ...) -> None: ...
    @typing.overload
    def __init__(self, other: QSslCertificate) -> None: ...
    def clear(self) -> None: ...
    def digest(self, algorithm: PySide2.QtCore.QCryptographicHash.Algorithm = ...) -> PySide2.QtCore.QByteArray: ...
    def effectiveDate(self) -> PySide2.QtCore.QDateTime: ...
    def expiryDate(self) -> PySide2.QtCore.QDateTime: ...
    def extensions(self) -> typing.List[QSslCertificateExtension]: ...
    @staticmethod
    def fromData(data: PySide2.QtCore.QByteArray | bytes, format: QSsl.EncodingFormat = ...) -> typing.List[QSslCertificate]: ...
    @staticmethod
    def fromDevice(device: PySide2.QtCore.QIODevice, format: QSsl.EncodingFormat = ...) -> typing.List[QSslCertificate]: ...
    @typing.overload
    @staticmethod
    def fromPath(path: str, format: QSsl.EncodingFormat, syntax: PySide2.QtCore.QRegExp.PatternSyntax) -> typing.List[QSslCertificate]: ...
    @typing.overload
    @staticmethod
    def fromPath(path: str, format: QSsl.EncodingFormat = ..., syntax: QSslCertificate.PatternSyntax = ...) -> typing.List[QSslCertificate]: ...
    def handle(self) -> int: ...
    @staticmethod
    def importPkcs12(device: PySide2.QtCore.QIODevice, key: QSslKey, cert: QSslCertificate, caCertificates: typing.Iterable[QSslCertificate] | None = ..., passPhrase: PySide2.QtCore.QByteArray | bytes = ...) -> bool: ...
    def isBlacklisted(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isSelfSigned(self) -> bool: ...
    def issuerDisplayName(self) -> str: ...
    @typing.overload
    def issuerInfo(self, info: QSslCertificate.SubjectInfo) -> typing.List[str]: ...
    @typing.overload
    def issuerInfo(self, attribute: PySide2.QtCore.QByteArray | bytes) -> typing.List[str]: ...
    def issuerInfoAttributes(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def publicKey(self) -> QSslKey: ...
    def serialNumber(self) -> PySide2.QtCore.QByteArray: ...
    def subjectAlternativeNames(self) -> typing.OrderedDict[QSsl.AlternativeNameEntryType, typing.List[str]]: ...
    def subjectDisplayName(self) -> str: ...
    @typing.overload
    def subjectInfo(self, info: QSslCertificate.SubjectInfo) -> typing.List[str]: ...
    @typing.overload
    def subjectInfo(self, attribute: PySide2.QtCore.QByteArray | bytes) -> typing.List[str]: ...
    def subjectInfoAttributes(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def swap(self, other: QSslCertificate) -> None: ...
    def toDer(self) -> PySide2.QtCore.QByteArray: ...
    def toPem(self) -> PySide2.QtCore.QByteArray: ...
    def toText(self) -> str: ...
    @staticmethod
    def verify(certificateChain: typing.Iterable[QSslCertificate], hostName: str = ...) -> typing.List[QSslError]: ...
    def version(self) -> PySide2.QtCore.QByteArray: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QSslCertificateExtension(shiboken2.Object):
    @typing.overload
    def __init__(self, other: QSslCertificateExtension) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def isCritical(self) -> bool: ...
    def isSupported(self) -> bool: ...
    def name(self) -> str: ...
    def oid(self) -> str: ...
    def swap(self, other: QSslCertificateExtension) -> None: ...
    def value(self) -> typing.Any: ...
    def __copy__(self) -> None: ...

class QSslCipher(shiboken2.Object):
    @typing.overload
    def __init__(self, name: str, protocol: QSsl.SslProtocol) -> None: ...
    @typing.overload
    def __init__(self, other: QSslCipher) -> None: ...
    @typing.overload
    def __init__(self, name: str) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def authenticationMethod(self) -> str: ...
    def encryptionMethod(self) -> str: ...
    def isNull(self) -> bool: ...
    def keyExchangeMethod(self) -> str: ...
    def name(self) -> str: ...
    def protocol(self) -> QSsl.SslProtocol: ...
    def protocolString(self) -> str: ...
    def supportedBits(self) -> int: ...
    def swap(self, other: QSslCipher) -> None: ...
    def usedBits(self) -> int: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QSslConfiguration(shiboken2.Object):
    class NextProtocolNegotiationStatus:
        NextProtocolNegotiationNegotiated: typing.ClassVar[QSslConfiguration.NextProtocolNegotiationStatus] = ...
        NextProtocolNegotiationNone: typing.ClassVar[QSslConfiguration.NextProtocolNegotiationStatus] = ...
        NextProtocolNegotiationUnsupported: typing.ClassVar[QSslConfiguration.NextProtocolNegotiationStatus] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSslConfiguration.NextProtocolNegotiationStatus: ...
        def __and__(self, other: typing.SupportsInt) -> QSslConfiguration.NextProtocolNegotiationStatus: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSslConfiguration.NextProtocolNegotiationStatus: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSslConfiguration.NextProtocolNegotiationStatus: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSslConfiguration.NextProtocolNegotiationStatus: ...
        def __rand__(self, other: typing.SupportsInt) -> QSslConfiguration.NextProtocolNegotiationStatus: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSslConfiguration.NextProtocolNegotiationStatus: ...
        def __ror__(self, other: typing.SupportsInt) -> QSslConfiguration.NextProtocolNegotiationStatus: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSslConfiguration.NextProtocolNegotiationStatus: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSslConfiguration.NextProtocolNegotiationStatus: ...
        def __sub__(self, other: typing.SupportsInt) -> QSslConfiguration.NextProtocolNegotiationStatus: ...
        def __xor__(self, other: typing.SupportsInt) -> QSslConfiguration.NextProtocolNegotiationStatus: ...
    ALPNProtocolHTTP2: typing.ClassVar[str] = ...
    NextProtocolHttp1_1: typing.ClassVar[str] = ...
    NextProtocolNegotiationNegotiated: typing.ClassVar[QSslConfiguration.NextProtocolNegotiationStatus] = ...
    NextProtocolNegotiationNone: typing.ClassVar[QSslConfiguration.NextProtocolNegotiationStatus] = ...
    NextProtocolNegotiationUnsupported: typing.ClassVar[QSslConfiguration.NextProtocolNegotiationStatus] = ...
    NextProtocolSpdy3_0: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self, other: QSslConfiguration) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def addCaCertificate(self, certificate: QSslCertificate) -> None: ...
    @typing.overload
    def addCaCertificates(self, path: str, format: QSsl.EncodingFormat = ..., syntax: QSslCertificate.PatternSyntax = ...) -> bool: ...
    @typing.overload
    def addCaCertificates(self, certificates: typing.Iterable[QSslCertificate]) -> None: ...
    def allowedNextProtocols(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def backendConfiguration(self) -> typing.Dict[PySide2.QtCore.QByteArray, typing.Any]: ...
    def caCertificates(self) -> typing.List[QSslCertificate]: ...
    def ciphers(self) -> typing.List[QSslCipher]: ...
    @staticmethod
    def defaultConfiguration() -> QSslConfiguration: ...
    def diffieHellmanParameters(self) -> QSslDiffieHellmanParameters: ...
    def ephemeralServerKey(self) -> QSslKey: ...
    def isNull(self) -> bool: ...
    def localCertificate(self) -> QSslCertificate: ...
    def localCertificateChain(self) -> typing.List[QSslCertificate]: ...
    def nextNegotiatedProtocol(self) -> PySide2.QtCore.QByteArray: ...
    def nextProtocolNegotiationStatus(self) -> QSslConfiguration.NextProtocolNegotiationStatus: ...
    def ocspStaplingEnabled(self) -> bool: ...
    def peerCertificate(self) -> QSslCertificate: ...
    def peerCertificateChain(self) -> typing.List[QSslCertificate]: ...
    def peerVerifyDepth(self) -> int: ...
    def peerVerifyMode(self) -> QSslSocket.PeerVerifyMode: ...
    def preSharedKeyIdentityHint(self) -> PySide2.QtCore.QByteArray: ...
    def privateKey(self) -> QSslKey: ...
    def protocol(self) -> QSsl.SslProtocol: ...
    def sessionCipher(self) -> QSslCipher: ...
    def sessionProtocol(self) -> QSsl.SslProtocol: ...
    def sessionTicket(self) -> PySide2.QtCore.QByteArray: ...
    def sessionTicketLifeTimeHint(self) -> int: ...
    def setAllowedNextProtocols(self, protocols: typing.Iterable[PySide2.QtCore.QByteArray]) -> None: ...
    def setBackendConfiguration(self, backendConfiguration: typing.Dict[PySide2.QtCore.QByteArray, typing.Any] = ...) -> None: ...
    def setBackendConfigurationOption(self, name: PySide2.QtCore.QByteArray | bytes, value: typing.Any) -> None: ...
    def setCaCertificates(self, certificates: typing.Iterable[QSslCertificate]) -> None: ...
    def setCiphers(self, ciphers: typing.Iterable[QSslCipher]) -> None: ...
    @staticmethod
    def setDefaultConfiguration(configuration: QSslConfiguration) -> None: ...
    def setDiffieHellmanParameters(self, dhparams: QSslDiffieHellmanParameters) -> None: ...
    def setLocalCertificate(self, certificate: QSslCertificate) -> None: ...
    def setLocalCertificateChain(self, localChain: typing.Iterable[QSslCertificate]) -> None: ...
    def setOcspStaplingEnabled(self, enable: bool) -> None: ...
    def setPeerVerifyDepth(self, depth: int) -> None: ...
    def setPeerVerifyMode(self, mode: QSslSocket.PeerVerifyMode) -> None: ...
    def setPreSharedKeyIdentityHint(self, hint: PySide2.QtCore.QByteArray | bytes) -> None: ...
    def setPrivateKey(self, key: QSslKey) -> None: ...
    def setProtocol(self, protocol: QSsl.SslProtocol) -> None: ...
    def setSessionTicket(self, sessionTicket: PySide2.QtCore.QByteArray | bytes) -> None: ...
    def setSslOption(self, option: QSsl.SslOption, on: bool) -> None: ...
    @staticmethod
    def supportedCiphers() -> typing.List[QSslCipher]: ...
    def swap(self, other: QSslConfiguration) -> None: ...
    @staticmethod
    def systemCaCertificates() -> typing.List[QSslCertificate]: ...
    def testSslOption(self, option: QSsl.SslOption) -> bool: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QSslDiffieHellmanParameters(shiboken2.Object):
    class Error:
        InvalidInputDataError: typing.ClassVar[QSslDiffieHellmanParameters.Error] = ...
        NoError: typing.ClassVar[QSslDiffieHellmanParameters.Error] = ...
        UnsafeParametersError: typing.ClassVar[QSslDiffieHellmanParameters.Error] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSslDiffieHellmanParameters.Error: ...
        def __and__(self, other: typing.SupportsInt) -> QSslDiffieHellmanParameters.Error: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSslDiffieHellmanParameters.Error: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSslDiffieHellmanParameters.Error: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSslDiffieHellmanParameters.Error: ...
        def __rand__(self, other: typing.SupportsInt) -> QSslDiffieHellmanParameters.Error: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSslDiffieHellmanParameters.Error: ...
        def __ror__(self, other: typing.SupportsInt) -> QSslDiffieHellmanParameters.Error: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSslDiffieHellmanParameters.Error: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSslDiffieHellmanParameters.Error: ...
        def __sub__(self, other: typing.SupportsInt) -> QSslDiffieHellmanParameters.Error: ...
        def __xor__(self, other: typing.SupportsInt) -> QSslDiffieHellmanParameters.Error: ...
    InvalidInputDataError: typing.ClassVar[QSslDiffieHellmanParameters.Error] = ...
    NoError: typing.ClassVar[QSslDiffieHellmanParameters.Error] = ...
    UnsafeParametersError: typing.ClassVar[QSslDiffieHellmanParameters.Error] = ...
    @typing.overload
    def __init__(self, other: QSslDiffieHellmanParameters) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @staticmethod
    def defaultParameters() -> QSslDiffieHellmanParameters: ...
    def error(self) -> QSslDiffieHellmanParameters.Error: ...
    def errorString(self) -> str: ...
    @typing.overload
    @staticmethod
    def fromEncoded(encoded: PySide2.QtCore.QByteArray | bytes, format: QSsl.EncodingFormat = ...) -> QSslDiffieHellmanParameters: ...
    @typing.overload
    @staticmethod
    def fromEncoded(device: PySide2.QtCore.QIODevice, format: QSsl.EncodingFormat = ...) -> QSslDiffieHellmanParameters: ...
    def isEmpty(self) -> bool: ...
    def isValid(self) -> bool: ...
    def swap(self, other: QSslDiffieHellmanParameters) -> None: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QSslError(shiboken2.Object):
    class SslError:
        AuthorityIssuerSerialNumberMismatch: typing.ClassVar[QSslError.SslError] = ...
        CertificateBlacklisted: typing.ClassVar[QSslError.SslError] = ...
        CertificateExpired: typing.ClassVar[QSslError.SslError] = ...
        CertificateNotYetValid: typing.ClassVar[QSslError.SslError] = ...
        CertificateRejected: typing.ClassVar[QSslError.SslError] = ...
        CertificateRevoked: typing.ClassVar[QSslError.SslError] = ...
        CertificateSignatureFailed: typing.ClassVar[QSslError.SslError] = ...
        CertificateStatusUnknown: typing.ClassVar[QSslError.SslError] = ...
        CertificateUntrusted: typing.ClassVar[QSslError.SslError] = ...
        HostNameMismatch: typing.ClassVar[QSslError.SslError] = ...
        InvalidCaCertificate: typing.ClassVar[QSslError.SslError] = ...
        InvalidNotAfterField: typing.ClassVar[QSslError.SslError] = ...
        InvalidNotBeforeField: typing.ClassVar[QSslError.SslError] = ...
        InvalidPurpose: typing.ClassVar[QSslError.SslError] = ...
        NoError: typing.ClassVar[QSslError.SslError] = ...
        NoPeerCertificate: typing.ClassVar[QSslError.SslError] = ...
        NoSslSupport: typing.ClassVar[QSslError.SslError] = ...
        OcspInternalError: typing.ClassVar[QSslError.SslError] = ...
        OcspMalformedRequest: typing.ClassVar[QSslError.SslError] = ...
        OcspMalformedResponse: typing.ClassVar[QSslError.SslError] = ...
        OcspNoResponseFound: typing.ClassVar[QSslError.SslError] = ...
        OcspResponseCannotBeTrusted: typing.ClassVar[QSslError.SslError] = ...
        OcspResponseCertIdUnknown: typing.ClassVar[QSslError.SslError] = ...
        OcspResponseExpired: typing.ClassVar[QSslError.SslError] = ...
        OcspSigRequred: typing.ClassVar[QSslError.SslError] = ...
        OcspStatusUnknown: typing.ClassVar[QSslError.SslError] = ...
        OcspTryLater: typing.ClassVar[QSslError.SslError] = ...
        OcspUnauthorized: typing.ClassVar[QSslError.SslError] = ...
        PathLengthExceeded: typing.ClassVar[QSslError.SslError] = ...
        SelfSignedCertificate: typing.ClassVar[QSslError.SslError] = ...
        SelfSignedCertificateInChain: typing.ClassVar[QSslError.SslError] = ...
        SubjectIssuerMismatch: typing.ClassVar[QSslError.SslError] = ...
        UnableToDecodeIssuerPublicKey: typing.ClassVar[QSslError.SslError] = ...
        UnableToDecryptCertificateSignature: typing.ClassVar[QSslError.SslError] = ...
        UnableToGetIssuerCertificate: typing.ClassVar[QSslError.SslError] = ...
        UnableToGetLocalIssuerCertificate: typing.ClassVar[QSslError.SslError] = ...
        UnableToVerifyFirstCertificate: typing.ClassVar[QSslError.SslError] = ...
        UnspecifiedError: typing.ClassVar[QSslError.SslError] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSslError.SslError: ...
        def __and__(self, other: typing.SupportsInt) -> QSslError.SslError: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSslError.SslError: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSslError.SslError: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSslError.SslError: ...
        def __rand__(self, other: typing.SupportsInt) -> QSslError.SslError: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSslError.SslError: ...
        def __ror__(self, other: typing.SupportsInt) -> QSslError.SslError: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSslError.SslError: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSslError.SslError: ...
        def __sub__(self, other: typing.SupportsInt) -> QSslError.SslError: ...
        def __xor__(self, other: typing.SupportsInt) -> QSslError.SslError: ...
    AuthorityIssuerSerialNumberMismatch: typing.ClassVar[QSslError.SslError] = ...
    CertificateBlacklisted: typing.ClassVar[QSslError.SslError] = ...
    CertificateExpired: typing.ClassVar[QSslError.SslError] = ...
    CertificateNotYetValid: typing.ClassVar[QSslError.SslError] = ...
    CertificateRejected: typing.ClassVar[QSslError.SslError] = ...
    CertificateRevoked: typing.ClassVar[QSslError.SslError] = ...
    CertificateSignatureFailed: typing.ClassVar[QSslError.SslError] = ...
    CertificateStatusUnknown: typing.ClassVar[QSslError.SslError] = ...
    CertificateUntrusted: typing.ClassVar[QSslError.SslError] = ...
    HostNameMismatch: typing.ClassVar[QSslError.SslError] = ...
    InvalidCaCertificate: typing.ClassVar[QSslError.SslError] = ...
    InvalidNotAfterField: typing.ClassVar[QSslError.SslError] = ...
    InvalidNotBeforeField: typing.ClassVar[QSslError.SslError] = ...
    InvalidPurpose: typing.ClassVar[QSslError.SslError] = ...
    NoError: typing.ClassVar[QSslError.SslError] = ...
    NoPeerCertificate: typing.ClassVar[QSslError.SslError] = ...
    NoSslSupport: typing.ClassVar[QSslError.SslError] = ...
    OcspInternalError: typing.ClassVar[QSslError.SslError] = ...
    OcspMalformedRequest: typing.ClassVar[QSslError.SslError] = ...
    OcspMalformedResponse: typing.ClassVar[QSslError.SslError] = ...
    OcspNoResponseFound: typing.ClassVar[QSslError.SslError] = ...
    OcspResponseCannotBeTrusted: typing.ClassVar[QSslError.SslError] = ...
    OcspResponseCertIdUnknown: typing.ClassVar[QSslError.SslError] = ...
    OcspResponseExpired: typing.ClassVar[QSslError.SslError] = ...
    OcspSigRequred: typing.ClassVar[QSslError.SslError] = ...
    OcspStatusUnknown: typing.ClassVar[QSslError.SslError] = ...
    OcspTryLater: typing.ClassVar[QSslError.SslError] = ...
    OcspUnauthorized: typing.ClassVar[QSslError.SslError] = ...
    PathLengthExceeded: typing.ClassVar[QSslError.SslError] = ...
    SelfSignedCertificate: typing.ClassVar[QSslError.SslError] = ...
    SelfSignedCertificateInChain: typing.ClassVar[QSslError.SslError] = ...
    SubjectIssuerMismatch: typing.ClassVar[QSslError.SslError] = ...
    UnableToDecodeIssuerPublicKey: typing.ClassVar[QSslError.SslError] = ...
    UnableToDecryptCertificateSignature: typing.ClassVar[QSslError.SslError] = ...
    UnableToGetIssuerCertificate: typing.ClassVar[QSslError.SslError] = ...
    UnableToGetLocalIssuerCertificate: typing.ClassVar[QSslError.SslError] = ...
    UnableToVerifyFirstCertificate: typing.ClassVar[QSslError.SslError] = ...
    UnspecifiedError: typing.ClassVar[QSslError.SslError] = ...
    @typing.overload
    def __init__(self, error: QSslError.SslError, certificate: QSslCertificate) -> None: ...
    @typing.overload
    def __init__(self, other: QSslError) -> None: ...
    @typing.overload
    def __init__(self, error: QSslError.SslError) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def certificate(self) -> QSslCertificate: ...
    def error(self) -> QSslError.SslError: ...
    def errorString(self) -> str: ...
    def swap(self, other: QSslError) -> None: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QSslKey(shiboken2.Object):
    @typing.overload
    def __init__(self, encoded: PySide2.QtCore.QByteArray | bytes, algorithm: QSsl.KeyAlgorithm, format: QSsl.EncodingFormat = ..., type: QSsl.KeyType = ..., passPhrase: PySide2.QtCore.QByteArray | bytes = ...) -> None: ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice, algorithm: QSsl.KeyAlgorithm, format: QSsl.EncodingFormat = ..., type: QSsl.KeyType = ..., passPhrase: PySide2.QtCore.QByteArray | bytes = ...) -> None: ...
    @typing.overload
    def __init__(self, handle: int, type: QSsl.KeyType = ...) -> None: ...
    @typing.overload
    def __init__(self, other: QSslKey) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def algorithm(self) -> QSsl.KeyAlgorithm: ...
    def clear(self) -> None: ...
    def handle(self) -> int: ...
    def isNull(self) -> bool: ...
    def length(self) -> int: ...
    def swap(self, other: QSslKey) -> None: ...
    def toDer(self, passPhrase: PySide2.QtCore.QByteArray | bytes = ...) -> PySide2.QtCore.QByteArray: ...
    def toPem(self, passPhrase: PySide2.QtCore.QByteArray | bytes = ...) -> PySide2.QtCore.QByteArray: ...
    def type(self) -> QSsl.KeyType: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QSslPreSharedKeyAuthenticator(shiboken2.Object):
    @typing.overload
    def __init__(self, authenticator: QSslPreSharedKeyAuthenticator) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def identity(self) -> PySide2.QtCore.QByteArray: ...
    def identityHint(self) -> PySide2.QtCore.QByteArray: ...
    def maximumIdentityLength(self) -> int: ...
    def maximumPreSharedKeyLength(self) -> int: ...
    def preSharedKey(self) -> PySide2.QtCore.QByteArray: ...
    def setIdentity(self, identity: PySide2.QtCore.QByteArray | bytes) -> None: ...
    def setPreSharedKey(self, preSharedKey: PySide2.QtCore.QByteArray | bytes) -> None: ...
    def swap(self, other: QSslPreSharedKeyAuthenticator) -> None: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QSslSocket(QTcpSocket):
    class PeerVerifyMode:
        AutoVerifyPeer: typing.ClassVar[QSslSocket.PeerVerifyMode] = ...
        QueryPeer: typing.ClassVar[QSslSocket.PeerVerifyMode] = ...
        VerifyNone: typing.ClassVar[QSslSocket.PeerVerifyMode] = ...
        VerifyPeer: typing.ClassVar[QSslSocket.PeerVerifyMode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSslSocket.PeerVerifyMode: ...
        def __and__(self, other: typing.SupportsInt) -> QSslSocket.PeerVerifyMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSslSocket.PeerVerifyMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSslSocket.PeerVerifyMode: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSslSocket.PeerVerifyMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QSslSocket.PeerVerifyMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSslSocket.PeerVerifyMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QSslSocket.PeerVerifyMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSslSocket.PeerVerifyMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSslSocket.PeerVerifyMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QSslSocket.PeerVerifyMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QSslSocket.PeerVerifyMode: ...

    class SslMode:
        SslClientMode: typing.ClassVar[QSslSocket.SslMode] = ...
        SslServerMode: typing.ClassVar[QSslSocket.SslMode] = ...
        UnencryptedMode: typing.ClassVar[QSslSocket.SslMode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSslSocket.SslMode: ...
        def __and__(self, other: typing.SupportsInt) -> QSslSocket.SslMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSslSocket.SslMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSslSocket.SslMode: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSslSocket.SslMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QSslSocket.SslMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSslSocket.SslMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QSslSocket.SslMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSslSocket.SslMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSslSocket.SslMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QSslSocket.SslMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QSslSocket.SslMode: ...
    AutoVerifyPeer: typing.ClassVar[QSslSocket.PeerVerifyMode] = ...
    QueryPeer: typing.ClassVar[QSslSocket.PeerVerifyMode] = ...
    SslClientMode: typing.ClassVar[QSslSocket.SslMode] = ...
    SslServerMode: typing.ClassVar[QSslSocket.SslMode] = ...
    UnencryptedMode: typing.ClassVar[QSslSocket.SslMode] = ...
    VerifyNone: typing.ClassVar[QSslSocket.PeerVerifyMode] = ...
    VerifyPeer: typing.ClassVar[QSslSocket.PeerVerifyMode] = ...
    encrypted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    encryptedBytesWritten: typing.ClassVar[PySide2.QtCore.Signal] = ...
    modeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    newSessionTicketReceived: typing.ClassVar[PySide2.QtCore.Signal] = ...
    peerVerifyError: typing.ClassVar[PySide2.QtCore.Signal] = ...
    preSharedKeyAuthenticationRequired: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sslErrors: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., aboutToClose: typing.Callable = ..., bytesWritten: typing.Callable = ..., channelBytesWritten: typing.Callable = ..., channelReadyRead: typing.Callable = ..., connected: typing.Callable = ..., destroyed: typing.Callable = ..., disconnected: typing.Callable = ..., encrypted: typing.Callable = ..., encryptedBytesWritten: typing.Callable = ..., error: typing.Callable = ..., errorOccurred: typing.Callable = ..., hostFound: typing.Callable = ..., modeChanged: typing.Callable = ..., newSessionTicketReceived: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., peerVerifyError: typing.Callable = ..., preSharedKeyAuthenticationRequired: typing.Callable = ..., proxyAuthenticationRequired: typing.Callable = ..., readChannelFinished: typing.Callable = ..., readyRead: typing.Callable = ..., sslErrors: typing.Callable = ..., stateChanged: typing.Callable = ...) -> None: ...
    def abort(self) -> None: ...
    def addCaCertificate(self, certificate: QSslCertificate) -> None: ...
    @typing.overload
    def addCaCertificates(self, path: str, format: QSsl.EncodingFormat = ..., syntax: PySide2.QtCore.QRegExp.PatternSyntax = ...) -> bool: ...
    @typing.overload
    def addCaCertificates(self, certificates: typing.Iterable[QSslCertificate]) -> None: ...
    @staticmethod
    def addDefaultCaCertificate(certificate: QSslCertificate) -> None: ...
    @typing.overload
    @staticmethod
    def addDefaultCaCertificates(path: str, format: QSsl.EncodingFormat = ..., syntax: PySide2.QtCore.QRegExp.PatternSyntax = ...) -> bool: ...
    @typing.overload
    @staticmethod
    def addDefaultCaCertificates(certificates: typing.Iterable[QSslCertificate]) -> None: ...
    def atEnd(self) -> bool: ...
    def bytesAvailable(self) -> int: ...
    def bytesToWrite(self) -> int: ...
    def caCertificates(self) -> typing.List[QSslCertificate]: ...
    def canReadLine(self) -> bool: ...
    def ciphers(self) -> typing.List[QSslCipher]: ...
    def close(self) -> None: ...
    @typing.overload
    def connectToHost(self, hostName: str, port: int, openMode: PySide2.QtCore.QIODevice.OpenMode | PySide2.QtCore.QIODevice.OpenModeFlag = ..., protocol: QAbstractSocket.NetworkLayerProtocol = ...) -> None: ...
    @typing.overload
    def connectToHost(self, address: QHostAddress, port: int, mode: PySide2.QtCore.QIODevice.OpenMode | PySide2.QtCore.QIODevice.OpenModeFlag = ...) -> None: ...
    @typing.overload
    def connectToHostEncrypted(self, hostName: str, port: int, sslPeerName: str, mode: PySide2.QtCore.QIODevice.OpenMode | PySide2.QtCore.QIODevice.OpenModeFlag = ..., protocol: QAbstractSocket.NetworkLayerProtocol = ...) -> None: ...
    @typing.overload
    def connectToHostEncrypted(self, hostName: str, port: int, mode: PySide2.QtCore.QIODevice.OpenMode | PySide2.QtCore.QIODevice.OpenModeFlag = ..., protocol: QAbstractSocket.NetworkLayerProtocol = ...) -> None: ...
    @staticmethod
    def defaultCaCertificates() -> typing.List[QSslCertificate]: ...
    @staticmethod
    def defaultCiphers() -> typing.List[QSslCipher]: ...
    def disconnectFromHost(self) -> None: ...
    def encryptedBytesAvailable(self) -> int: ...
    def encryptedBytesToWrite(self) -> int: ...
    def flush(self) -> bool: ...
    @typing.overload
    def ignoreSslErrors(self, errors: typing.Iterable[QSslError]) -> None: ...
    @typing.overload
    def ignoreSslErrors(self) -> None: ...
    def isEncrypted(self) -> bool: ...
    def localCertificate(self) -> QSslCertificate: ...
    def localCertificateChain(self) -> typing.List[QSslCertificate]: ...
    def mode(self) -> QSslSocket.SslMode: ...
    def ocspResponses(self) -> typing.List[QOcspResponse]: ...
    def peerCertificate(self) -> QSslCertificate: ...
    def peerCertificateChain(self) -> typing.List[QSslCertificate]: ...
    def peerVerifyDepth(self) -> int: ...
    def peerVerifyMode(self) -> QSslSocket.PeerVerifyMode: ...
    def peerVerifyName(self) -> str: ...
    def privateKey(self) -> QSslKey: ...
    def protocol(self) -> QSsl.SslProtocol: ...
    def readData(self, data: bytes, maxlen: int) -> int: ...
    def resume(self) -> None: ...
    def sessionCipher(self) -> QSslCipher: ...
    def sessionProtocol(self) -> QSsl.SslProtocol: ...
    def setCaCertificates(self, certificates: typing.Iterable[QSslCertificate]) -> None: ...
    @typing.overload
    def setCiphers(self, ciphers: typing.Iterable[QSslCipher]) -> None: ...
    @typing.overload
    def setCiphers(self, ciphers: str) -> None: ...
    @staticmethod
    def setDefaultCaCertificates(certificates: typing.Iterable[QSslCertificate]) -> None: ...
    @staticmethod
    def setDefaultCiphers(ciphers: typing.Iterable[QSslCipher]) -> None: ...
    @typing.overload
    def setLocalCertificate(self, fileName: str, format: QSsl.EncodingFormat = ...) -> None: ...
    @typing.overload
    def setLocalCertificate(self, certificate: QSslCertificate) -> None: ...
    def setLocalCertificateChain(self, localChain: typing.Iterable[QSslCertificate]) -> None: ...
    def setPeerVerifyDepth(self, depth: int) -> None: ...
    def setPeerVerifyMode(self, mode: QSslSocket.PeerVerifyMode) -> None: ...
    def setPeerVerifyName(self, hostName: str) -> None: ...
    @typing.overload
    def setPrivateKey(self, fileName: str, algorithm: QSsl.KeyAlgorithm = ..., format: QSsl.EncodingFormat = ..., passPhrase: PySide2.QtCore.QByteArray | bytes = ...) -> None: ...
    @typing.overload
    def setPrivateKey(self, key: QSslKey) -> None: ...
    def setProtocol(self, protocol: QSsl.SslProtocol) -> None: ...
    def setReadBufferSize(self, size: int) -> None: ...
    def setSocketDescriptor(self, socketDescriptor: int, state: QAbstractSocket.SocketState = ..., openMode: PySide2.QtCore.QIODevice.OpenMode | PySide2.QtCore.QIODevice.OpenModeFlag = ...) -> bool: ...
    def setSocketOption(self, option: QAbstractSocket.SocketOption, value: typing.Any) -> None: ...
    def setSslConfiguration(self, config: QSslConfiguration) -> None: ...
    def socketOption(self, option: QAbstractSocket.SocketOption) -> typing.Any: ...
    def sslConfiguration(self) -> QSslConfiguration: ...
    def sslHandshakeErrors(self) -> typing.List[QSslError]: ...
    @staticmethod
    def sslLibraryBuildVersionNumber() -> int: ...
    @staticmethod
    def sslLibraryBuildVersionString() -> str: ...
    @staticmethod
    def sslLibraryVersionNumber() -> int: ...
    @staticmethod
    def sslLibraryVersionString() -> str: ...
    def startClientEncryption(self) -> None: ...
    def startServerEncryption(self) -> None: ...
    @staticmethod
    def supportedCiphers() -> typing.List[QSslCipher]: ...
    @staticmethod
    def supportsSsl() -> bool: ...
    @staticmethod
    def systemCaCertificates() -> typing.List[QSslCertificate]: ...
    def waitForBytesWritten(self, msecs: int = ...) -> bool: ...
    def waitForConnected(self, msecs: int = ...) -> bool: ...
    def waitForDisconnected(self, msecs: int = ...) -> bool: ...
    def waitForEncrypted(self, msecs: int = ...) -> bool: ...
    def waitForReadyRead(self, msecs: int = ...) -> bool: ...
    def writeData(self, data: bytes, len: int) -> int: ...

class QTcpServer(PySide2.QtCore.QObject):
    acceptError: typing.ClassVar[PySide2.QtCore.Signal] = ...
    newConnection: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., acceptError: typing.Callable = ..., destroyed: typing.Callable = ..., newConnection: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def addPendingConnection(self, socket: QTcpSocket) -> None: ...
    def close(self) -> None: ...
    def errorString(self) -> str: ...
    def hasPendingConnections(self) -> bool: ...
    def incomingConnection(self, handle: int) -> None: ...
    def isListening(self) -> bool: ...
    def listen(self, address: QHostAddress = ..., port: int = ...) -> bool: ...
    def maxPendingConnections(self) -> int: ...
    def nextPendingConnection(self) -> QTcpSocket: ...
    def pauseAccepting(self) -> None: ...
    def proxy(self) -> QNetworkProxy: ...
    def resumeAccepting(self) -> None: ...
    def serverAddress(self) -> QHostAddress: ...
    def serverError(self) -> QAbstractSocket.SocketError: ...
    def serverPort(self) -> int: ...
    def setMaxPendingConnections(self, numConnections: int) -> None: ...
    def setProxy(self, networkProxy: QNetworkProxy) -> None: ...
    def setSocketDescriptor(self, socketDescriptor: int) -> bool: ...
    def socketDescriptor(self) -> int: ...
    def waitForNewConnection(self, msec: int) -> typing.Tuple[bool, bool]: ...

class QTcpSocket(QAbstractSocket):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., aboutToClose: typing.Callable = ..., bytesWritten: typing.Callable = ..., channelBytesWritten: typing.Callable = ..., channelReadyRead: typing.Callable = ..., connected: typing.Callable = ..., destroyed: typing.Callable = ..., disconnected: typing.Callable = ..., error: typing.Callable = ..., errorOccurred: typing.Callable = ..., hostFound: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., proxyAuthenticationRequired: typing.Callable = ..., readChannelFinished: typing.Callable = ..., readyRead: typing.Callable = ..., stateChanged: typing.Callable = ...) -> None: ...

class QUdpSocket(QAbstractSocket):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., aboutToClose: typing.Callable = ..., bytesWritten: typing.Callable = ..., channelBytesWritten: typing.Callable = ..., channelReadyRead: typing.Callable = ..., connected: typing.Callable = ..., destroyed: typing.Callable = ..., disconnected: typing.Callable = ..., error: typing.Callable = ..., errorOccurred: typing.Callable = ..., hostFound: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., proxyAuthenticationRequired: typing.Callable = ..., readChannelFinished: typing.Callable = ..., readyRead: typing.Callable = ..., stateChanged: typing.Callable = ...) -> None: ...
    def hasPendingDatagrams(self) -> bool: ...
    @typing.overload
    def joinMulticastGroup(self, groupAddress: QHostAddress, iface: QNetworkInterface) -> bool: ...
    @typing.overload
    def joinMulticastGroup(self, groupAddress: QHostAddress) -> bool: ...
    @typing.overload
    def leaveMulticastGroup(self, groupAddress: QHostAddress, iface: QNetworkInterface) -> bool: ...
    @typing.overload
    def leaveMulticastGroup(self, groupAddress: QHostAddress) -> bool: ...
    def multicastInterface(self) -> QNetworkInterface: ...
    def pendingDatagramSize(self) -> int: ...
    def readDatagram(self, data: bytes, maxlen: int, host: QHostAddress) -> typing.Tuple[int, int]: ...
    def receiveDatagram(self, maxSize: int = ...) -> QNetworkDatagram: ...
    def setMulticastInterface(self, iface: QNetworkInterface) -> None: ...
    @typing.overload
    def writeDatagram(self, datagram: PySide2.QtCore.QByteArray | bytes, host: QHostAddress, port: int) -> int: ...
    @typing.overload
    def writeDatagram(self, datagram: QNetworkDatagram) -> int: ...
