import PySide2.QtCore
import PySide2.QtGui
import PySide2.QtQml
import _typeshed
import collections
import shiboken2
import typing
T = typing.TypeVar('T')
import typing_extensions

class QQuickAsyncImageProvider(QQuickImageProvider):
    def __init__(self) -> None: ...
    def requestImageResponse(self, id: str, requestedSize: PySide2.QtCore.QSize) -> QQuickImageResponse: ...

class QQuickFramebufferObject(QQuickItem):
    class Renderer(shiboken2.Object):
        def __init__(self) -> None: ...
        def createFramebufferObject(self, size: PySide2.QtCore.QSize) -> PySide2.QtGui.QOpenGLFramebufferObject: ...
        def framebufferObject(self) -> PySide2.QtGui.QOpenGLFramebufferObject: ...
        def invalidateFramebufferObject(self) -> None: ...
        def render(self) -> None: ...
        def synchronize(self, arg__1: QQuickFramebufferObject) -> None: ...
        def update(self) -> None: ...
    mirrorVerticallyChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    textureFollowsItemSizeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: QQuickItem | None = ..., activeFocus: bool = ..., activeFocusChanged: typing.Callable = ..., activeFocusOnTab: bool = ..., activeFocusOnTabChanged: typing.Callable = ..., anchors: typing.Any = ..., antialiasing: bool = ..., antialiasingChanged: typing.Callable = ..., baseline: typing.Any = ..., baselineOffset: float = ..., baselineOffsetChanged: typing.Callable = ..., bottom: typing.Any = ..., children: typing.Any = ..., childrenChanged: typing.Callable = ..., childrenRect: PySide2.QtCore.QRectF = ..., childrenRectChanged: typing.Callable = ..., clip: bool = ..., clipChanged: typing.Callable = ..., containmentMask: PySide2.QtCore.QObject = ..., containmentMaskChanged: typing.Callable = ..., data: typing.Any = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., focus: bool = ..., focusChanged: typing.Callable = ..., height: float = ..., heightChanged: typing.Callable = ..., horizontalCenter: typing.Any = ..., implicitHeight: float = ..., implicitHeightChanged: typing.Callable = ..., implicitWidth: float = ..., implicitWidthChanged: typing.Callable = ..., layer: typing.Any = ..., left: typing.Any = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., resources: typing.Any = ..., right: typing.Any = ..., rotation: float = ..., rotationChanged: typing.Callable = ..., scale: float = ..., scaleChanged: typing.Callable = ..., smooth: bool = ..., smoothChanged: typing.Callable = ..., state: str = ..., stateChanged: typing.Callable = ..., states: typing.Any = ..., top: typing.Any = ..., transform: typing.Any = ..., transformOrigin: QQuickItem.TransformOrigin = ..., transformOriginChanged: typing.Callable = ..., transformOriginPoint: PySide2.QtCore.QPointF = ..., transitions: typing.Any = ..., verticalCenter: typing.Any = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., visibleChildren: typing.Any = ..., visibleChildrenChanged: typing.Callable = ..., width: float = ..., widthChanged: typing.Callable = ..., windowChanged: typing.Callable = ..., x: float = ..., xChanged: typing.Callable = ..., y: float = ..., yChanged: typing.Callable = ..., z: float = ..., zChanged: typing.Callable = ...) -> None: ...
    def createRenderer(self) -> QQuickFramebufferObject.Renderer: ...
    def geometryChanged(self, newGeometry: PySide2.QtCore.QRectF, oldGeometry: PySide2.QtCore.QRectF) -> None: ...
    def isTextureProvider(self) -> bool: ...
    def mirrorVertically(self) -> bool: ...
    def releaseResources(self) -> None: ...
    def setMirrorVertically(self, enable: bool) -> None: ...
    def setTextureFollowsItemSize(self, follows: bool) -> None: ...
    def textureFollowsItemSize(self) -> bool: ...
    def textureProvider(self) -> QSGTextureProvider: ...
    def updatePaintNode(self, arg__1: QSGNode, arg__2: QQuickItem.UpdatePaintNodeData) -> QSGNode: ...

class QQuickImageProvider(PySide2.QtQml.QQmlImageProviderBase):
    def __init__(self, type: PySide2.QtQml.QQmlImageProviderBase.ImageType, flags: PySide2.QtQml.QQmlImageProviderBase.Flags | PySide2.QtQml.QQmlImageProviderBase.Flag = ...) -> None: ...
    def flags(self) -> PySide2.QtQml.QQmlImageProviderBase.Flags | PySide2.QtQml.QQmlImageProviderBase.Flag: ...
    def imageType(self) -> PySide2.QtQml.QQmlImageProviderBase.ImageType: ...
    def requestImage(self, id: str, size: PySide2.QtCore.QSize, requestedSize: PySide2.QtCore.QSize) -> PySide2.QtGui.QImage: ...
    def requestPixmap(self, id: str, size: PySide2.QtCore.QSize, requestedSize: PySide2.QtCore.QSize) -> PySide2.QtGui.QPixmap: ...
    def requestTexture(self, id: str, size: PySide2.QtCore.QSize, requestedSize: PySide2.QtCore.QSize) -> QQuickTextureFactory: ...

class QQuickImageResponse(PySide2.QtCore.QObject):
    finished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def cancel(self) -> None: ...
    def errorString(self) -> str: ...
    def textureFactory(self) -> QQuickTextureFactory: ...

class QQuickItem(PySide2.QtCore.QObject, PySide2.QtQml.QQmlParserStatus):
    class Flag:
        ItemAcceptsDrops: typing.ClassVar[QQuickItem.Flag] = ...
        ItemAcceptsInputMethod: typing.ClassVar[QQuickItem.Flag] = ...
        ItemClipsChildrenToShape: typing.ClassVar[QQuickItem.Flag] = ...
        ItemHasContents: typing.ClassVar[QQuickItem.Flag] = ...
        ItemIsFocusScope: typing.ClassVar[QQuickItem.Flag] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QQuickItem.Flags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QQuickItem.Flags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQuickItem.Flags: ...
        def __rand__(self, other: typing.SupportsInt) -> QQuickItem.Flags: ...
        def __ror__(self, other: typing.SupportsInt) -> QQuickItem.Flags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQuickItem.Flags: ...
        def __xor__(self, other: typing.SupportsInt) -> QQuickItem.Flags: ...

    class Flags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QQuickItem.Flags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QQuickItem.Flags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQuickItem.Flags: ...
        def __rand__(self, other: typing.SupportsInt) -> QQuickItem.Flags: ...
        def __ror__(self, other: typing.SupportsInt) -> QQuickItem.Flags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQuickItem.Flags: ...
        def __xor__(self, other: typing.SupportsInt) -> QQuickItem.Flags: ...

    class ItemChange:
        ItemActiveFocusHasChanged: typing.ClassVar[QQuickItem.ItemChange] = ...
        ItemAntialiasingHasChanged: typing.ClassVar[QQuickItem.ItemChange] = ...
        ItemChildAddedChange: typing.ClassVar[QQuickItem.ItemChange] = ...
        ItemChildRemovedChange: typing.ClassVar[QQuickItem.ItemChange] = ...
        ItemDevicePixelRatioHasChanged: typing.ClassVar[QQuickItem.ItemChange] = ...
        ItemEnabledHasChanged: typing.ClassVar[QQuickItem.ItemChange] = ...
        ItemOpacityHasChanged: typing.ClassVar[QQuickItem.ItemChange] = ...
        ItemParentHasChanged: typing.ClassVar[QQuickItem.ItemChange] = ...
        ItemRotationHasChanged: typing.ClassVar[QQuickItem.ItemChange] = ...
        ItemSceneChange: typing.ClassVar[QQuickItem.ItemChange] = ...
        ItemVisibleHasChanged: typing.ClassVar[QQuickItem.ItemChange] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QQuickItem.ItemChange: ...
        def __and__(self, other: typing.SupportsInt) -> QQuickItem.ItemChange: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QQuickItem.ItemChange: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQuickItem.ItemChange: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QQuickItem.ItemChange: ...
        def __rand__(self, other: typing.SupportsInt) -> QQuickItem.ItemChange: ...
        def __rmul__(self, other: typing.SupportsInt) -> QQuickItem.ItemChange: ...
        def __ror__(self, other: typing.SupportsInt) -> QQuickItem.ItemChange: ...
        def __rsub__(self, other: typing.SupportsInt) -> QQuickItem.ItemChange: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQuickItem.ItemChange: ...
        def __sub__(self, other: typing.SupportsInt) -> QQuickItem.ItemChange: ...
        def __xor__(self, other: typing.SupportsInt) -> QQuickItem.ItemChange: ...

    class TransformOrigin:
        Bottom: typing.ClassVar[QQuickItem.TransformOrigin] = ...
        BottomLeft: typing.ClassVar[QQuickItem.TransformOrigin] = ...
        BottomRight: typing.ClassVar[QQuickItem.TransformOrigin] = ...
        Center: typing.ClassVar[QQuickItem.TransformOrigin] = ...
        Left: typing.ClassVar[QQuickItem.TransformOrigin] = ...
        Right: typing.ClassVar[QQuickItem.TransformOrigin] = ...
        Top: typing.ClassVar[QQuickItem.TransformOrigin] = ...
        TopLeft: typing.ClassVar[QQuickItem.TransformOrigin] = ...
        TopRight: typing.ClassVar[QQuickItem.TransformOrigin] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QQuickItem.TransformOrigin: ...
        def __and__(self, other: typing.SupportsInt) -> QQuickItem.TransformOrigin: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QQuickItem.TransformOrigin: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQuickItem.TransformOrigin: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QQuickItem.TransformOrigin: ...
        def __rand__(self, other: typing.SupportsInt) -> QQuickItem.TransformOrigin: ...
        def __rmul__(self, other: typing.SupportsInt) -> QQuickItem.TransformOrigin: ...
        def __ror__(self, other: typing.SupportsInt) -> QQuickItem.TransformOrigin: ...
        def __rsub__(self, other: typing.SupportsInt) -> QQuickItem.TransformOrigin: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQuickItem.TransformOrigin: ...
        def __sub__(self, other: typing.SupportsInt) -> QQuickItem.TransformOrigin: ...
        def __xor__(self, other: typing.SupportsInt) -> QQuickItem.TransformOrigin: ...

    class UpdatePaintNodeData(shiboken2.Object):
        transformNode: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __copy__(self) -> None: ...
    Bottom: typing.ClassVar[QQuickItem.TransformOrigin] = ...
    BottomLeft: typing.ClassVar[QQuickItem.TransformOrigin] = ...
    BottomRight: typing.ClassVar[QQuickItem.TransformOrigin] = ...
    Center: typing.ClassVar[QQuickItem.TransformOrigin] = ...
    ItemAcceptsDrops: typing.ClassVar[QQuickItem.Flag] = ...
    ItemAcceptsInputMethod: typing.ClassVar[QQuickItem.Flag] = ...
    ItemActiveFocusHasChanged: typing.ClassVar[QQuickItem.ItemChange] = ...
    ItemAntialiasingHasChanged: typing.ClassVar[QQuickItem.ItemChange] = ...
    ItemChildAddedChange: typing.ClassVar[QQuickItem.ItemChange] = ...
    ItemChildRemovedChange: typing.ClassVar[QQuickItem.ItemChange] = ...
    ItemClipsChildrenToShape: typing.ClassVar[QQuickItem.Flag] = ...
    ItemDevicePixelRatioHasChanged: typing.ClassVar[QQuickItem.ItemChange] = ...
    ItemEnabledHasChanged: typing.ClassVar[QQuickItem.ItemChange] = ...
    ItemHasContents: typing.ClassVar[QQuickItem.Flag] = ...
    ItemIsFocusScope: typing.ClassVar[QQuickItem.Flag] = ...
    ItemOpacityHasChanged: typing.ClassVar[QQuickItem.ItemChange] = ...
    ItemParentHasChanged: typing.ClassVar[QQuickItem.ItemChange] = ...
    ItemRotationHasChanged: typing.ClassVar[QQuickItem.ItemChange] = ...
    ItemSceneChange: typing.ClassVar[QQuickItem.ItemChange] = ...
    ItemVisibleHasChanged: typing.ClassVar[QQuickItem.ItemChange] = ...
    Left: typing.ClassVar[QQuickItem.TransformOrigin] = ...
    Right: typing.ClassVar[QQuickItem.TransformOrigin] = ...
    Top: typing.ClassVar[QQuickItem.TransformOrigin] = ...
    TopLeft: typing.ClassVar[QQuickItem.TransformOrigin] = ...
    TopRight: typing.ClassVar[QQuickItem.TransformOrigin] = ...
    activeFocusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    activeFocusOnTabChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    antialiasingChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    baselineOffsetChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    childrenChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    childrenRectChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    clipChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    containmentMaskChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    enabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    focusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    heightChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    implicitHeightChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    implicitWidthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    opacityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    parentChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    rotationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    scaleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    smoothChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    transformOriginChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    visibleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    visibleChildrenChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    widthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    windowChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    xChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    yChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    zChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: QQuickItem | None = ..., activeFocus: bool = ..., activeFocusChanged: typing.Callable = ..., activeFocusOnTab: bool = ..., activeFocusOnTabChanged: typing.Callable = ..., anchors: typing.Any = ..., antialiasing: bool = ..., antialiasingChanged: typing.Callable = ..., baseline: typing.Any = ..., baselineOffset: float = ..., baselineOffsetChanged: typing.Callable = ..., bottom: typing.Any = ..., children: typing.Any = ..., childrenChanged: typing.Callable = ..., childrenRect: PySide2.QtCore.QRectF = ..., childrenRectChanged: typing.Callable = ..., clip: bool = ..., clipChanged: typing.Callable = ..., containmentMask: PySide2.QtCore.QObject = ..., containmentMaskChanged: typing.Callable = ..., data: typing.Any = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., focus: bool = ..., focusChanged: typing.Callable = ..., height: float = ..., heightChanged: typing.Callable = ..., horizontalCenter: typing.Any = ..., implicitHeight: float = ..., implicitHeightChanged: typing.Callable = ..., implicitWidth: float = ..., implicitWidthChanged: typing.Callable = ..., layer: typing.Any = ..., left: typing.Any = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., resources: typing.Any = ..., right: typing.Any = ..., rotation: float = ..., rotationChanged: typing.Callable = ..., scale: float = ..., scaleChanged: typing.Callable = ..., smooth: bool = ..., smoothChanged: typing.Callable = ..., state: str = ..., stateChanged: typing.Callable = ..., states: typing.Any = ..., top: typing.Any = ..., transform: typing.Any = ..., transformOrigin: QQuickItem.TransformOrigin = ..., transformOriginChanged: typing.Callable = ..., transformOriginPoint: PySide2.QtCore.QPointF = ..., transitions: typing.Any = ..., verticalCenter: typing.Any = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., visibleChildren: typing.Any = ..., visibleChildrenChanged: typing.Callable = ..., width: float = ..., widthChanged: typing.Callable = ..., windowChanged: typing.Callable = ..., x: float = ..., xChanged: typing.Callable = ..., y: float = ..., yChanged: typing.Callable = ..., z: float = ..., zChanged: typing.Callable = ...) -> None: ...
    def acceptHoverEvents(self) -> bool: ...
    def acceptTouchEvents(self) -> bool: ...
    def acceptedMouseButtons(self) -> PySide2.QtCore.Qt.MouseButtons | PySide2.QtCore.Qt.MouseButton: ...
    def activeFocusOnTab(self) -> bool: ...
    def antialiasing(self) -> bool: ...
    def baselineOffset(self) -> float: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def childAt(self, x: float, y: float) -> QQuickItem: ...
    def childItems(self) -> typing.List[QQuickItem]: ...
    def childMouseEventFilter(self, arg__1: QQuickItem, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    def childrenRect(self) -> PySide2.QtCore.QRectF: ...
    def classBegin(self) -> None: ...
    def clip(self) -> bool: ...
    def clipRect(self) -> PySide2.QtCore.QRectF: ...
    def componentComplete(self) -> None: ...
    def containmentMask(self) -> PySide2.QtCore.QObject: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def cursor(self) -> PySide2.QtGui.QCursor: ...
    def dragEnterEvent(self, arg__1: PySide2.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, arg__1: PySide2.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, arg__1: PySide2.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, arg__1: PySide2.QtGui.QDropEvent) -> None: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def filtersChildMouseEvents(self) -> bool: ...
    def flags(self) -> QQuickItem.Flags | QQuickItem.Flag: ...
    def focusInEvent(self, arg__1: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, arg__1: PySide2.QtGui.QFocusEvent) -> None: ...
    @typing.overload
    def forceActiveFocus(self, reason: PySide2.QtCore.Qt.FocusReason) -> None: ...
    @typing.overload
    def forceActiveFocus(self) -> None: ...
    def geometryChanged(self, newGeometry: PySide2.QtCore.QRectF, oldGeometry: PySide2.QtCore.QRectF) -> None: ...
    def grabMouse(self) -> None: ...
    @typing.overload
    def grabToImage(self, callback: PySide2.QtQml.QJSValue, targetSize: PySide2.QtCore.QSize = ...) -> bool: ...
    @typing.overload
    def grabToImage(self, targetSize: PySide2.QtCore.QSize = ...) -> typing.Tuple[QQuickItemGrabResult]: ...
    def grabTouchPoints(self, ids: typing.List[int]) -> None: ...
    def hasActiveFocus(self) -> bool: ...
    def hasFocus(self) -> bool: ...
    def height(self) -> float: ...
    def heightValid(self) -> bool: ...
    def hoverEnterEvent(self, event: PySide2.QtGui.QHoverEvent) -> None: ...
    def hoverLeaveEvent(self, event: PySide2.QtGui.QHoverEvent) -> None: ...
    def hoverMoveEvent(self, event: PySide2.QtGui.QHoverEvent) -> None: ...
    def implicitHeight(self) -> float: ...
    def implicitWidth(self) -> float: ...
    def inputMethodEvent(self, arg__1: PySide2.QtGui.QInputMethodEvent) -> None: ...
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def isAncestorOf(self, child: QQuickItem) -> bool: ...
    def isComponentComplete(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isFocusScope(self) -> bool: ...
    def isTextureProvider(self) -> bool: ...
    def isUnderMouse(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def itemTransform(self, arg__1: QQuickItem) -> typing.Tuple[PySide2.QtGui.QTransform, bool]: ...
    def keepMouseGrab(self) -> bool: ...
    def keepTouchGrab(self) -> bool: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def mapFromGlobal(self, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    def mapFromItem(self, item: QQuickItem, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    def mapFromScene(self, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    def mapRectFromItem(self, item: QQuickItem, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def mapRectFromScene(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def mapRectToItem(self, item: QQuickItem, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def mapRectToScene(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def mapToGlobal(self, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    def mapToItem(self, item: QQuickItem, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    def mapToScene(self, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    def mouseDoubleClickEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseUngrabEvent(self) -> None: ...
    def nextItemInFocusChain(self, forward: bool = ...) -> QQuickItem: ...
    def opacity(self) -> float: ...
    def parentItem(self) -> QQuickItem: ...
    def polish(self) -> None: ...
    def position(self) -> PySide2.QtCore.QPointF: ...
    def releaseResources(self) -> None: ...
    def resetAntialiasing(self) -> None: ...
    def resetHeight(self) -> None: ...
    def resetWidth(self) -> None: ...
    def rotation(self) -> float: ...
    def scale(self) -> float: ...
    def scopedFocusItem(self) -> QQuickItem: ...
    def setAcceptHoverEvents(self, enabled: bool) -> None: ...
    def setAcceptTouchEvents(self, accept: bool) -> None: ...
    def setAcceptedMouseButtons(self, buttons: PySide2.QtCore.Qt.MouseButtons | PySide2.QtCore.Qt.MouseButton) -> None: ...
    def setActiveFocusOnTab(self, arg__1: bool) -> None: ...
    def setAntialiasing(self, arg__1: bool) -> None: ...
    def setBaselineOffset(self, arg__1: float) -> None: ...
    def setClip(self, arg__1: bool) -> None: ...
    def setContainmentMask(self, mask: PySide2.QtCore.QObject) -> None: ...
    def setCursor(self, cursor: PySide2.QtGui.QCursor | PySide2.QtCore.Qt.CursorShape) -> None: ...
    def setEnabled(self, arg__1: bool) -> None: ...
    def setFiltersChildMouseEvents(self, filter: bool) -> None: ...
    def setFlag(self, flag: QQuickItem.Flag, enabled: bool = ...) -> None: ...
    def setFlags(self, flags: QQuickItem.Flags | QQuickItem.Flag) -> None: ...
    @typing.overload
    def setFocus(self, focus: bool, reason: PySide2.QtCore.Qt.FocusReason) -> None: ...
    @typing.overload
    def setFocus(self, arg__1: bool) -> None: ...
    def setHeight(self, arg__1: float) -> None: ...
    def setImplicitHeight(self, arg__1: float) -> None: ...
    def setImplicitSize(self, arg__1: float, arg__2: float) -> None: ...
    def setImplicitWidth(self, arg__1: float) -> None: ...
    def setKeepMouseGrab(self, arg__1: bool) -> None: ...
    def setKeepTouchGrab(self, arg__1: bool) -> None: ...
    def setOpacity(self, arg__1: float) -> None: ...
    def setParentItem(self, parent: QQuickItem) -> None: ...
    def setPosition(self, arg__1: PySide2.QtCore.QPointF) -> None: ...
    def setRotation(self, arg__1: float) -> None: ...
    def setScale(self, arg__1: float) -> None: ...
    def setSize(self, size: PySide2.QtCore.QSizeF) -> None: ...
    def setSmooth(self, arg__1: bool) -> None: ...
    def setState(self, arg__1: str) -> None: ...
    def setTransformOrigin(self, arg__1: QQuickItem.TransformOrigin) -> None: ...
    def setTransformOriginPoint(self, arg__1: PySide2.QtCore.QPointF) -> None: ...
    def setVisible(self, arg__1: bool) -> None: ...
    def setWidth(self, arg__1: float) -> None: ...
    def setX(self, arg__1: float) -> None: ...
    def setY(self, arg__1: float) -> None: ...
    def setZ(self, arg__1: float) -> None: ...
    def size(self) -> PySide2.QtCore.QSizeF: ...
    def smooth(self) -> bool: ...
    def stackAfter(self, arg__1: QQuickItem) -> None: ...
    def stackBefore(self, arg__1: QQuickItem) -> None: ...
    def state(self) -> str: ...
    def textureProvider(self) -> QSGTextureProvider: ...
    def touchEvent(self, event: PySide2.QtGui.QTouchEvent) -> None: ...
    def touchUngrabEvent(self) -> None: ...
    def transformOrigin(self) -> QQuickItem.TransformOrigin: ...
    def transformOriginPoint(self) -> PySide2.QtCore.QPointF: ...
    def ungrabMouse(self) -> None: ...
    def ungrabTouchPoints(self) -> None: ...
    def unsetCursor(self) -> None: ...
    def update(self) -> None: ...
    def updateInputMethod(self, queries: PySide2.QtCore.Qt.InputMethodQueries | PySide2.QtCore.Qt.InputMethodQuery = ...) -> None: ...
    def updatePaintNode(self, arg__1: QSGNode, arg__2: QQuickItem.UpdatePaintNodeData) -> QSGNode: ...
    def updatePolish(self) -> None: ...
    def wheelEvent(self, event: PySide2.QtGui.QWheelEvent) -> None: ...
    def width(self) -> float: ...
    def widthValid(self) -> bool: ...
    def window(self) -> QQuickWindow: ...
    def windowDeactivateEvent(self) -> None: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...

class QQuickItemGrabResult(PySide2.QtCore.QObject):
    ready: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, destroyed: typing.Callable = ..., image: PySide2.QtGui.QImage = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., ready: typing.Callable = ..., url: PySide2.QtCore.QUrl = ..., **kwargs) -> None: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def image(self) -> PySide2.QtGui.QImage: ...
    def saveToFile(self, fileName: str) -> bool: ...
    def url(self) -> PySide2.QtCore.QUrl: ...

class QQuickPaintedItem(QQuickItem):
    class PerformanceHint:
        FastFBOResizing: typing.ClassVar[QQuickPaintedItem.PerformanceHint] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QQuickPaintedItem.PerformanceHints: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QQuickPaintedItem.PerformanceHints: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQuickPaintedItem.PerformanceHints: ...
        def __rand__(self, other: typing.SupportsInt) -> QQuickPaintedItem.PerformanceHints: ...
        def __ror__(self, other: typing.SupportsInt) -> QQuickPaintedItem.PerformanceHints: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQuickPaintedItem.PerformanceHints: ...
        def __xor__(self, other: typing.SupportsInt) -> QQuickPaintedItem.PerformanceHints: ...

    class PerformanceHints:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QQuickPaintedItem.PerformanceHints: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QQuickPaintedItem.PerformanceHints: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQuickPaintedItem.PerformanceHints: ...
        def __rand__(self, other: typing.SupportsInt) -> QQuickPaintedItem.PerformanceHints: ...
        def __ror__(self, other: typing.SupportsInt) -> QQuickPaintedItem.PerformanceHints: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQuickPaintedItem.PerformanceHints: ...
        def __xor__(self, other: typing.SupportsInt) -> QQuickPaintedItem.PerformanceHints: ...

    class RenderTarget:
        FramebufferObject: typing.ClassVar[QQuickPaintedItem.RenderTarget] = ...
        Image: typing.ClassVar[QQuickPaintedItem.RenderTarget] = ...
        InvertedYFramebufferObject: typing.ClassVar[QQuickPaintedItem.RenderTarget] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QQuickPaintedItem.RenderTarget: ...
        def __and__(self, other: typing.SupportsInt) -> QQuickPaintedItem.RenderTarget: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QQuickPaintedItem.RenderTarget: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQuickPaintedItem.RenderTarget: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QQuickPaintedItem.RenderTarget: ...
        def __rand__(self, other: typing.SupportsInt) -> QQuickPaintedItem.RenderTarget: ...
        def __rmul__(self, other: typing.SupportsInt) -> QQuickPaintedItem.RenderTarget: ...
        def __ror__(self, other: typing.SupportsInt) -> QQuickPaintedItem.RenderTarget: ...
        def __rsub__(self, other: typing.SupportsInt) -> QQuickPaintedItem.RenderTarget: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQuickPaintedItem.RenderTarget: ...
        def __sub__(self, other: typing.SupportsInt) -> QQuickPaintedItem.RenderTarget: ...
        def __xor__(self, other: typing.SupportsInt) -> QQuickPaintedItem.RenderTarget: ...
    FastFBOResizing: typing.ClassVar[QQuickPaintedItem.PerformanceHint] = ...
    FramebufferObject: typing.ClassVar[QQuickPaintedItem.RenderTarget] = ...
    Image: typing.ClassVar[QQuickPaintedItem.RenderTarget] = ...
    InvertedYFramebufferObject: typing.ClassVar[QQuickPaintedItem.RenderTarget] = ...
    contentsScaleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    contentsSizeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    fillColorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    renderTargetChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    textureSizeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: QQuickItem | None = ..., activeFocus: bool = ..., activeFocusChanged: typing.Callable = ..., activeFocusOnTab: bool = ..., activeFocusOnTabChanged: typing.Callable = ..., anchors: typing.Any = ..., antialiasing: bool = ..., antialiasingChanged: typing.Callable = ..., baseline: typing.Any = ..., baselineOffset: float = ..., baselineOffsetChanged: typing.Callable = ..., bottom: typing.Any = ..., children: typing.Any = ..., childrenChanged: typing.Callable = ..., childrenRect: PySide2.QtCore.QRectF = ..., childrenRectChanged: typing.Callable = ..., clip: bool = ..., clipChanged: typing.Callable = ..., containmentMask: PySide2.QtCore.QObject = ..., containmentMaskChanged: typing.Callable = ..., data: typing.Any = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., focus: bool = ..., focusChanged: typing.Callable = ..., height: float = ..., heightChanged: typing.Callable = ..., horizontalCenter: typing.Any = ..., implicitHeight: float = ..., implicitHeightChanged: typing.Callable = ..., implicitWidth: float = ..., implicitWidthChanged: typing.Callable = ..., layer: typing.Any = ..., left: typing.Any = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., resources: typing.Any = ..., right: typing.Any = ..., rotation: float = ..., rotationChanged: typing.Callable = ..., scale: float = ..., scaleChanged: typing.Callable = ..., smooth: bool = ..., smoothChanged: typing.Callable = ..., state: str = ..., stateChanged: typing.Callable = ..., states: typing.Any = ..., top: typing.Any = ..., transform: typing.Any = ..., transformOrigin: QQuickItem.TransformOrigin = ..., transformOriginChanged: typing.Callable = ..., transformOriginPoint: PySide2.QtCore.QPointF = ..., transitions: typing.Any = ..., verticalCenter: typing.Any = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., visibleChildren: typing.Any = ..., visibleChildrenChanged: typing.Callable = ..., width: float = ..., widthChanged: typing.Callable = ..., windowChanged: typing.Callable = ..., x: float = ..., xChanged: typing.Callable = ..., y: float = ..., yChanged: typing.Callable = ..., z: float = ..., zChanged: typing.Callable = ...) -> None: ...
    def antialiasing(self) -> bool: ...
    def contentsBoundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contentsScale(self) -> float: ...
    def contentsSize(self) -> PySide2.QtCore.QSize: ...
    def fillColor(self) -> PySide2.QtGui.QColor: ...
    def isTextureProvider(self) -> bool: ...
    def mipmap(self) -> bool: ...
    def opaquePainting(self) -> bool: ...
    def paint(self, painter: PySide2.QtGui.QPainter) -> None: ...
    def performanceHints(self) -> QQuickPaintedItem.PerformanceHints | QQuickPaintedItem.PerformanceHint: ...
    def releaseResources(self) -> None: ...
    def renderTarget(self) -> QQuickPaintedItem.RenderTarget: ...
    def resetContentsSize(self) -> None: ...
    def setAntialiasing(self, enable: bool) -> None: ...
    def setContentsScale(self, arg__1: float) -> None: ...
    def setContentsSize(self, arg__1: PySide2.QtCore.QSize) -> None: ...
    def setFillColor(self, arg__1: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
    def setMipmap(self, enable: bool) -> None: ...
    def setOpaquePainting(self, opaque: bool) -> None: ...
    def setPerformanceHint(self, hint: QQuickPaintedItem.PerformanceHint, enabled: bool = ...) -> None: ...
    def setPerformanceHints(self, hints: QQuickPaintedItem.PerformanceHints | QQuickPaintedItem.PerformanceHint) -> None: ...
    def setRenderTarget(self, target: QQuickPaintedItem.RenderTarget) -> None: ...
    def setTextureSize(self, size: PySide2.QtCore.QSize) -> None: ...
    def textureProvider(self) -> QSGTextureProvider: ...
    def textureSize(self) -> PySide2.QtCore.QSize: ...
    def update(self, rect: PySide2.QtCore.QRect = ...) -> None: ...
    def updatePaintNode(self, arg__1: QSGNode, arg__2: QQuickItem.UpdatePaintNodeData) -> QSGNode: ...

class QQuickRenderControl(PySide2.QtCore.QObject):
    renderRequested: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sceneChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., renderRequested: typing.Callable = ..., sceneChanged: typing.Callable = ...) -> None: ...
    def grab(self) -> PySide2.QtGui.QImage: ...
    def initialize(self, gl: PySide2.QtGui.QOpenGLContext) -> None: ...
    def invalidate(self) -> None: ...
    def polishItems(self) -> None: ...
    def prepareThread(self, targetThread: PySide2.QtCore.QThread) -> None: ...
    def render(self) -> None: ...
    def renderWindow(self, offset: PySide2.QtCore.QPoint) -> PySide2.QtGui.QWindow: ...
    @staticmethod
    def renderWindowFor(win: QQuickWindow, offset: PySide2.QtCore.QPoint | None = ...) -> PySide2.QtGui.QWindow: ...
    def sync(self) -> bool: ...

class QQuickTextDocument(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: QQuickItem, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def textDocument(self) -> PySide2.QtGui.QTextDocument: ...

class QQuickTextureFactory(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def createTexture(self, window: QQuickWindow) -> QSGTexture: ...
    def image(self) -> PySide2.QtGui.QImage: ...
    def textureByteCount(self) -> int: ...
    @staticmethod
    def textureFactoryForImage(image: PySide2.QtGui.QImage) -> QQuickTextureFactory: ...
    def textureSize(self) -> PySide2.QtCore.QSize: ...

class QQuickTransform(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def appendToItem(self, arg__1: QQuickItem) -> None: ...
    def applyTo(self, matrix: PySide2.QtGui.QMatrix4x4) -> None: ...
    def prependToItem(self, arg__1: QQuickItem) -> None: ...
    def update(self) -> None: ...

class QQuickView(QQuickWindow):
    class ResizeMode:
        SizeRootObjectToView: typing.ClassVar[QQuickView.ResizeMode] = ...
        SizeViewToRootObject: typing.ClassVar[QQuickView.ResizeMode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QQuickView.ResizeMode: ...
        def __and__(self, other: typing.SupportsInt) -> QQuickView.ResizeMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QQuickView.ResizeMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQuickView.ResizeMode: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QQuickView.ResizeMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QQuickView.ResizeMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QQuickView.ResizeMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QQuickView.ResizeMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QQuickView.ResizeMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQuickView.ResizeMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QQuickView.ResizeMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QQuickView.ResizeMode: ...

    class Status:
        Error: typing.ClassVar[QQuickView.Status] = ...
        Loading: typing.ClassVar[QQuickView.Status] = ...
        Null: typing.ClassVar[QQuickView.Status] = ...
        Ready: typing.ClassVar[QQuickView.Status] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QQuickView.Status: ...
        def __and__(self, other: typing.SupportsInt) -> QQuickView.Status: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QQuickView.Status: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQuickView.Status: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QQuickView.Status: ...
        def __rand__(self, other: typing.SupportsInt) -> QQuickView.Status: ...
        def __rmul__(self, other: typing.SupportsInt) -> QQuickView.Status: ...
        def __ror__(self, other: typing.SupportsInt) -> QQuickView.Status: ...
        def __rsub__(self, other: typing.SupportsInt) -> QQuickView.Status: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQuickView.Status: ...
        def __sub__(self, other: typing.SupportsInt) -> QQuickView.Status: ...
        def __xor__(self, other: typing.SupportsInt) -> QQuickView.Status: ...
    Error: typing.ClassVar[QQuickView.Status] = ...
    Loading: typing.ClassVar[QQuickView.Status] = ...
    Null: typing.ClassVar[QQuickView.Status] = ...
    Ready: typing.ClassVar[QQuickView.Status] = ...
    SizeRootObjectToView: typing.ClassVar[QQuickView.ResizeMode] = ...
    SizeViewToRootObject: typing.ClassVar[QQuickView.ResizeMode] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    statusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @typing.overload
    def __init__(self, source: PySide2.QtCore.QUrl, renderControl: QQuickRenderControl, active: bool = ..., activeChanged: typing.Callable = ..., activeFocusItem: typing.Any = ..., activeFocusItemChanged: typing.Callable = ..., afterAnimating: typing.Callable = ..., afterRenderPassRecording: typing.Callable = ..., afterRendering: typing.Callable = ..., afterSynchronizing: typing.Callable = ..., beforeRenderPassRecording: typing.Callable = ..., beforeRendering: typing.Callable = ..., beforeSynchronizing: typing.Callable = ..., closing: typing.Callable = ..., color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., colorChanged: typing.Callable = ..., contentItem: typing.Any = ..., contentOrientation: PySide2.QtCore.Qt.ScreenOrientation = ..., contentOrientationChanged: typing.Callable = ..., data: typing.Any = ..., destroyed: typing.Callable = ..., flags: PySide2.QtCore.Qt.WindowFlags | PySide2.QtCore.Qt.WindowType = ..., focusObjectChanged: typing.Callable = ..., frameSwapped: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., maximumHeight: int = ..., maximumHeightChanged: typing.Callable = ..., maximumWidth: int = ..., maximumWidthChanged: typing.Callable = ..., minimumHeight: int = ..., minimumHeightChanged: typing.Callable = ..., minimumWidth: int = ..., minimumWidthChanged: typing.Callable = ..., modality: PySide2.QtCore.Qt.WindowModality = ..., modalityChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., openglContextCreated: typing.Callable = ..., resizeMode: QQuickView.ResizeMode = ..., sceneGraphAboutToStop: typing.Callable = ..., sceneGraphError: typing.Callable = ..., sceneGraphInitialized: typing.Callable = ..., sceneGraphInvalidated: typing.Callable = ..., screenChanged: typing.Callable = ..., status: QQuickView.Status = ..., statusChanged: typing.Callable = ..., title: str = ..., transientParent: typing.Any = ..., transientParentChanged: typing.Callable = ..., visibility: QQuickView.Visibility = ..., visibilityChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: int = ..., widthChanged: typing.Callable = ..., windowStateChanged: typing.Callable = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., xChanged: typing.Callable = ..., y: int = ..., yChanged: typing.Callable = ...) -> None: ...
    @typing.overload
    def __init__(self, source: PySide2.QtCore.QUrl, parent: PySide2.QtGui.QWindow | None = ..., active: bool = ..., activeChanged: typing.Callable = ..., activeFocusItem: typing.Any = ..., activeFocusItemChanged: typing.Callable = ..., afterAnimating: typing.Callable = ..., afterRenderPassRecording: typing.Callable = ..., afterRendering: typing.Callable = ..., afterSynchronizing: typing.Callable = ..., beforeRenderPassRecording: typing.Callable = ..., beforeRendering: typing.Callable = ..., beforeSynchronizing: typing.Callable = ..., closing: typing.Callable = ..., color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., colorChanged: typing.Callable = ..., contentItem: typing.Any = ..., contentOrientation: PySide2.QtCore.Qt.ScreenOrientation = ..., contentOrientationChanged: typing.Callable = ..., data: typing.Any = ..., destroyed: typing.Callable = ..., flags: PySide2.QtCore.Qt.WindowFlags | PySide2.QtCore.Qt.WindowType = ..., focusObjectChanged: typing.Callable = ..., frameSwapped: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., maximumHeight: int = ..., maximumHeightChanged: typing.Callable = ..., maximumWidth: int = ..., maximumWidthChanged: typing.Callable = ..., minimumHeight: int = ..., minimumHeightChanged: typing.Callable = ..., minimumWidth: int = ..., minimumWidthChanged: typing.Callable = ..., modality: PySide2.QtCore.Qt.WindowModality = ..., modalityChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., openglContextCreated: typing.Callable = ..., resizeMode: QQuickView.ResizeMode = ..., sceneGraphAboutToStop: typing.Callable = ..., sceneGraphError: typing.Callable = ..., sceneGraphInitialized: typing.Callable = ..., sceneGraphInvalidated: typing.Callable = ..., screenChanged: typing.Callable = ..., status: QQuickView.Status = ..., statusChanged: typing.Callable = ..., title: str = ..., transientParent: typing.Any = ..., transientParentChanged: typing.Callable = ..., visibility: QQuickView.Visibility = ..., visibilityChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: int = ..., widthChanged: typing.Callable = ..., windowStateChanged: typing.Callable = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., xChanged: typing.Callable = ..., y: int = ..., yChanged: typing.Callable = ...) -> None: ...
    @typing.overload
    def __init__(self, engine: PySide2.QtQml.QQmlEngine, parent: PySide2.QtGui.QWindow, active: bool = ..., activeChanged: typing.Callable = ..., activeFocusItem: typing.Any = ..., activeFocusItemChanged: typing.Callable = ..., afterAnimating: typing.Callable = ..., afterRenderPassRecording: typing.Callable = ..., afterRendering: typing.Callable = ..., afterSynchronizing: typing.Callable = ..., beforeRenderPassRecording: typing.Callable = ..., beforeRendering: typing.Callable = ..., beforeSynchronizing: typing.Callable = ..., closing: typing.Callable = ..., color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., colorChanged: typing.Callable = ..., contentItem: typing.Any = ..., contentOrientation: PySide2.QtCore.Qt.ScreenOrientation = ..., contentOrientationChanged: typing.Callable = ..., data: typing.Any = ..., destroyed: typing.Callable = ..., flags: PySide2.QtCore.Qt.WindowFlags | PySide2.QtCore.Qt.WindowType = ..., focusObjectChanged: typing.Callable = ..., frameSwapped: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., maximumHeight: int = ..., maximumHeightChanged: typing.Callable = ..., maximumWidth: int = ..., maximumWidthChanged: typing.Callable = ..., minimumHeight: int = ..., minimumHeightChanged: typing.Callable = ..., minimumWidth: int = ..., minimumWidthChanged: typing.Callable = ..., modality: PySide2.QtCore.Qt.WindowModality = ..., modalityChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., openglContextCreated: typing.Callable = ..., resizeMode: QQuickView.ResizeMode = ..., sceneGraphAboutToStop: typing.Callable = ..., sceneGraphError: typing.Callable = ..., sceneGraphInitialized: typing.Callable = ..., sceneGraphInvalidated: typing.Callable = ..., screenChanged: typing.Callable = ..., source: PySide2.QtCore.QUrl = ..., status: QQuickView.Status = ..., statusChanged: typing.Callable = ..., title: str = ..., transientParent: typing.Any = ..., transientParentChanged: typing.Callable = ..., visibility: QQuickView.Visibility = ..., visibilityChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: int = ..., widthChanged: typing.Callable = ..., windowStateChanged: typing.Callable = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., xChanged: typing.Callable = ..., y: int = ..., yChanged: typing.Callable = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtGui.QWindow | None = ..., active: bool = ..., activeChanged: typing.Callable = ..., activeFocusItem: typing.Any = ..., activeFocusItemChanged: typing.Callable = ..., afterAnimating: typing.Callable = ..., afterRenderPassRecording: typing.Callable = ..., afterRendering: typing.Callable = ..., afterSynchronizing: typing.Callable = ..., beforeRenderPassRecording: typing.Callable = ..., beforeRendering: typing.Callable = ..., beforeSynchronizing: typing.Callable = ..., closing: typing.Callable = ..., color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., colorChanged: typing.Callable = ..., contentItem: typing.Any = ..., contentOrientation: PySide2.QtCore.Qt.ScreenOrientation = ..., contentOrientationChanged: typing.Callable = ..., data: typing.Any = ..., destroyed: typing.Callable = ..., flags: PySide2.QtCore.Qt.WindowFlags | PySide2.QtCore.Qt.WindowType = ..., focusObjectChanged: typing.Callable = ..., frameSwapped: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., maximumHeight: int = ..., maximumHeightChanged: typing.Callable = ..., maximumWidth: int = ..., maximumWidthChanged: typing.Callable = ..., minimumHeight: int = ..., minimumHeightChanged: typing.Callable = ..., minimumWidth: int = ..., minimumWidthChanged: typing.Callable = ..., modality: PySide2.QtCore.Qt.WindowModality = ..., modalityChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., openglContextCreated: typing.Callable = ..., resizeMode: QQuickView.ResizeMode = ..., sceneGraphAboutToStop: typing.Callable = ..., sceneGraphError: typing.Callable = ..., sceneGraphInitialized: typing.Callable = ..., sceneGraphInvalidated: typing.Callable = ..., screenChanged: typing.Callable = ..., source: PySide2.QtCore.QUrl = ..., status: QQuickView.Status = ..., statusChanged: typing.Callable = ..., title: str = ..., transientParent: typing.Any = ..., transientParentChanged: typing.Callable = ..., visibility: QQuickView.Visibility = ..., visibilityChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: int = ..., widthChanged: typing.Callable = ..., windowStateChanged: typing.Callable = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., xChanged: typing.Callable = ..., y: int = ..., yChanged: typing.Callable = ...) -> None: ...
    def engine(self) -> PySide2.QtQml.QQmlEngine: ...
    def errors(self) -> typing.List[PySide2.QtQml.QQmlError]: ...
    def initialSize(self) -> PySide2.QtCore.QSize: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, arg__1: PySide2.QtGui.QKeyEvent) -> None: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent) -> None: ...
    def resizeMode(self) -> QQuickView.ResizeMode: ...
    def rootContext(self) -> PySide2.QtQml.QQmlContext: ...
    def rootObject(self) -> QQuickItem: ...
    def setContent(self, url: PySide2.QtCore.QUrl, component: PySide2.QtQml.QQmlComponent, item: PySide2.QtCore.QObject) -> None: ...
    def setInitialProperties(self, initialProperties: typing.Dict[str, typing.Any]) -> None: ...
    def setResizeMode(self, arg__1: QQuickView.ResizeMode) -> None: ...
    def setSource(self, arg__1: PySide2.QtCore.QUrl) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def source(self) -> PySide2.QtCore.QUrl: ...
    def status(self) -> QQuickView.Status: ...
    def timerEvent(self, arg__1: PySide2.QtCore.QTimerEvent) -> None: ...

class QQuickWindow(PySide2.QtGui.QWindow):
    class CreateTextureOption:
        TextureCanUseAtlas: typing.ClassVar[QQuickWindow.CreateTextureOption] = ...
        TextureHasAlphaChannel: typing.ClassVar[QQuickWindow.CreateTextureOption] = ...
        TextureHasMipmaps: typing.ClassVar[QQuickWindow.CreateTextureOption] = ...
        TextureIsOpaque: typing.ClassVar[QQuickWindow.CreateTextureOption] = ...
        TextureOwnsGLTexture: typing.ClassVar[QQuickWindow.CreateTextureOption] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QQuickWindow.CreateTextureOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QQuickWindow.CreateTextureOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQuickWindow.CreateTextureOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QQuickWindow.CreateTextureOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QQuickWindow.CreateTextureOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQuickWindow.CreateTextureOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QQuickWindow.CreateTextureOptions: ...

    class CreateTextureOptions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QQuickWindow.CreateTextureOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QQuickWindow.CreateTextureOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQuickWindow.CreateTextureOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QQuickWindow.CreateTextureOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QQuickWindow.CreateTextureOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQuickWindow.CreateTextureOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QQuickWindow.CreateTextureOptions: ...

    class NativeObjectType:
        NativeObjectTexture: typing.ClassVar[QQuickWindow.NativeObjectType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QQuickWindow.NativeObjectType: ...
        def __and__(self, other: typing.SupportsInt) -> QQuickWindow.NativeObjectType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QQuickWindow.NativeObjectType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQuickWindow.NativeObjectType: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QQuickWindow.NativeObjectType: ...
        def __rand__(self, other: typing.SupportsInt) -> QQuickWindow.NativeObjectType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QQuickWindow.NativeObjectType: ...
        def __ror__(self, other: typing.SupportsInt) -> QQuickWindow.NativeObjectType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QQuickWindow.NativeObjectType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQuickWindow.NativeObjectType: ...
        def __sub__(self, other: typing.SupportsInt) -> QQuickWindow.NativeObjectType: ...
        def __xor__(self, other: typing.SupportsInt) -> QQuickWindow.NativeObjectType: ...

    class RenderStage:
        AfterRenderingStage: typing.ClassVar[QQuickWindow.RenderStage] = ...
        AfterSwapStage: typing.ClassVar[QQuickWindow.RenderStage] = ...
        AfterSynchronizingStage: typing.ClassVar[QQuickWindow.RenderStage] = ...
        BeforeRenderingStage: typing.ClassVar[QQuickWindow.RenderStage] = ...
        BeforeSynchronizingStage: typing.ClassVar[QQuickWindow.RenderStage] = ...
        NoStage: typing.ClassVar[QQuickWindow.RenderStage] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QQuickWindow.RenderStage: ...
        def __and__(self, other: typing.SupportsInt) -> QQuickWindow.RenderStage: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QQuickWindow.RenderStage: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQuickWindow.RenderStage: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QQuickWindow.RenderStage: ...
        def __rand__(self, other: typing.SupportsInt) -> QQuickWindow.RenderStage: ...
        def __rmul__(self, other: typing.SupportsInt) -> QQuickWindow.RenderStage: ...
        def __ror__(self, other: typing.SupportsInt) -> QQuickWindow.RenderStage: ...
        def __rsub__(self, other: typing.SupportsInt) -> QQuickWindow.RenderStage: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQuickWindow.RenderStage: ...
        def __sub__(self, other: typing.SupportsInt) -> QQuickWindow.RenderStage: ...
        def __xor__(self, other: typing.SupportsInt) -> QQuickWindow.RenderStage: ...

    class SceneGraphError:
        ContextNotAvailable: typing.ClassVar[QQuickWindow.SceneGraphError] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QQuickWindow.SceneGraphError: ...
        def __and__(self, other: typing.SupportsInt) -> QQuickWindow.SceneGraphError: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QQuickWindow.SceneGraphError: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQuickWindow.SceneGraphError: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QQuickWindow.SceneGraphError: ...
        def __rand__(self, other: typing.SupportsInt) -> QQuickWindow.SceneGraphError: ...
        def __rmul__(self, other: typing.SupportsInt) -> QQuickWindow.SceneGraphError: ...
        def __ror__(self, other: typing.SupportsInt) -> QQuickWindow.SceneGraphError: ...
        def __rsub__(self, other: typing.SupportsInt) -> QQuickWindow.SceneGraphError: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQuickWindow.SceneGraphError: ...
        def __sub__(self, other: typing.SupportsInt) -> QQuickWindow.SceneGraphError: ...
        def __xor__(self, other: typing.SupportsInt) -> QQuickWindow.SceneGraphError: ...

    class TextRenderType:
        NativeTextRendering: typing.ClassVar[QQuickWindow.TextRenderType] = ...
        QtTextRendering: typing.ClassVar[QQuickWindow.TextRenderType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QQuickWindow.TextRenderType: ...
        def __and__(self, other: typing.SupportsInt) -> QQuickWindow.TextRenderType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QQuickWindow.TextRenderType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQuickWindow.TextRenderType: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QQuickWindow.TextRenderType: ...
        def __rand__(self, other: typing.SupportsInt) -> QQuickWindow.TextRenderType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QQuickWindow.TextRenderType: ...
        def __ror__(self, other: typing.SupportsInt) -> QQuickWindow.TextRenderType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QQuickWindow.TextRenderType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQuickWindow.TextRenderType: ...
        def __sub__(self, other: typing.SupportsInt) -> QQuickWindow.TextRenderType: ...
        def __xor__(self, other: typing.SupportsInt) -> QQuickWindow.TextRenderType: ...
    AfterRenderingStage: typing.ClassVar[QQuickWindow.RenderStage] = ...
    AfterSwapStage: typing.ClassVar[QQuickWindow.RenderStage] = ...
    AfterSynchronizingStage: typing.ClassVar[QQuickWindow.RenderStage] = ...
    BeforeRenderingStage: typing.ClassVar[QQuickWindow.RenderStage] = ...
    BeforeSynchronizingStage: typing.ClassVar[QQuickWindow.RenderStage] = ...
    ContextNotAvailable: typing.ClassVar[QQuickWindow.SceneGraphError] = ...
    NativeObjectTexture: typing.ClassVar[QQuickWindow.NativeObjectType] = ...
    NativeTextRendering: typing.ClassVar[QQuickWindow.TextRenderType] = ...
    NoStage: typing.ClassVar[QQuickWindow.RenderStage] = ...
    QtTextRendering: typing.ClassVar[QQuickWindow.TextRenderType] = ...
    TextureCanUseAtlas: typing.ClassVar[QQuickWindow.CreateTextureOption] = ...
    TextureHasAlphaChannel: typing.ClassVar[QQuickWindow.CreateTextureOption] = ...
    TextureHasMipmaps: typing.ClassVar[QQuickWindow.CreateTextureOption] = ...
    TextureIsOpaque: typing.ClassVar[QQuickWindow.CreateTextureOption] = ...
    TextureOwnsGLTexture: typing.ClassVar[QQuickWindow.CreateTextureOption] = ...
    activeFocusItemChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    afterAnimating: typing.ClassVar[PySide2.QtCore.Signal] = ...
    afterRenderPassRecording: typing.ClassVar[PySide2.QtCore.Signal] = ...
    afterRendering: typing.ClassVar[PySide2.QtCore.Signal] = ...
    afterSynchronizing: typing.ClassVar[PySide2.QtCore.Signal] = ...
    beforeRenderPassRecording: typing.ClassVar[PySide2.QtCore.Signal] = ...
    beforeRendering: typing.ClassVar[PySide2.QtCore.Signal] = ...
    beforeSynchronizing: typing.ClassVar[PySide2.QtCore.Signal] = ...
    closing: typing.ClassVar[PySide2.QtCore.Signal] = ...
    colorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    frameSwapped: typing.ClassVar[PySide2.QtCore.Signal] = ...
    openglContextCreated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sceneGraphAboutToStop: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sceneGraphError: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sceneGraphInitialized: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sceneGraphInvalidated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @typing.overload
    def __init__(self, renderControl: QQuickRenderControl, active: bool = ..., activeChanged: typing.Callable = ..., activeFocusItem: QQuickItem = ..., activeFocusItemChanged: typing.Callable = ..., afterAnimating: typing.Callable = ..., afterRenderPassRecording: typing.Callable = ..., afterRendering: typing.Callable = ..., afterSynchronizing: typing.Callable = ..., beforeRenderPassRecording: typing.Callable = ..., beforeRendering: typing.Callable = ..., beforeSynchronizing: typing.Callable = ..., closing: typing.Callable = ..., color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., colorChanged: typing.Callable = ..., contentItem: QQuickItem = ..., contentOrientation: PySide2.QtCore.Qt.ScreenOrientation = ..., contentOrientationChanged: typing.Callable = ..., data: typing.Any = ..., destroyed: typing.Callable = ..., flags: PySide2.QtCore.Qt.WindowFlags | PySide2.QtCore.Qt.WindowType = ..., focusObjectChanged: typing.Callable = ..., frameSwapped: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., maximumHeight: int = ..., maximumHeightChanged: typing.Callable = ..., maximumWidth: int = ..., maximumWidthChanged: typing.Callable = ..., minimumHeight: int = ..., minimumHeightChanged: typing.Callable = ..., minimumWidth: int = ..., minimumWidthChanged: typing.Callable = ..., modality: PySide2.QtCore.Qt.WindowModality = ..., modalityChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., openglContextCreated: typing.Callable = ..., sceneGraphAboutToStop: typing.Callable = ..., sceneGraphError: typing.Callable = ..., sceneGraphInitialized: typing.Callable = ..., sceneGraphInvalidated: typing.Callable = ..., screenChanged: typing.Callable = ..., title: str = ..., transientParent: typing.Any = ..., transientParentChanged: typing.Callable = ..., visibility: QQuickWindow.Visibility = ..., visibilityChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: int = ..., widthChanged: typing.Callable = ..., windowStateChanged: typing.Callable = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., xChanged: typing.Callable = ..., y: int = ..., yChanged: typing.Callable = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtGui.QWindow | None = ..., active: bool = ..., activeChanged: typing.Callable = ..., activeFocusItem: QQuickItem = ..., activeFocusItemChanged: typing.Callable = ..., afterAnimating: typing.Callable = ..., afterRenderPassRecording: typing.Callable = ..., afterRendering: typing.Callable = ..., afterSynchronizing: typing.Callable = ..., beforeRenderPassRecording: typing.Callable = ..., beforeRendering: typing.Callable = ..., beforeSynchronizing: typing.Callable = ..., closing: typing.Callable = ..., color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int = ..., colorChanged: typing.Callable = ..., contentItem: QQuickItem = ..., contentOrientation: PySide2.QtCore.Qt.ScreenOrientation = ..., contentOrientationChanged: typing.Callable = ..., data: typing.Any = ..., destroyed: typing.Callable = ..., flags: PySide2.QtCore.Qt.WindowFlags | PySide2.QtCore.Qt.WindowType = ..., focusObjectChanged: typing.Callable = ..., frameSwapped: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., maximumHeight: int = ..., maximumHeightChanged: typing.Callable = ..., maximumWidth: int = ..., maximumWidthChanged: typing.Callable = ..., minimumHeight: int = ..., minimumHeightChanged: typing.Callable = ..., minimumWidth: int = ..., minimumWidthChanged: typing.Callable = ..., modality: PySide2.QtCore.Qt.WindowModality = ..., modalityChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., openglContextCreated: typing.Callable = ..., sceneGraphAboutToStop: typing.Callable = ..., sceneGraphError: typing.Callable = ..., sceneGraphInitialized: typing.Callable = ..., sceneGraphInvalidated: typing.Callable = ..., screenChanged: typing.Callable = ..., title: str = ..., transientParent: typing.Any = ..., transientParentChanged: typing.Callable = ..., visibility: QQuickWindow.Visibility = ..., visibilityChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: int = ..., widthChanged: typing.Callable = ..., windowStateChanged: typing.Callable = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., xChanged: typing.Callable = ..., y: int = ..., yChanged: typing.Callable = ...) -> None: ...
    def accessibleRoot(self) -> PySide2.QtGui.QAccessibleInterface: ...
    def activeFocusItem(self) -> QQuickItem: ...
    def beginExternalCommands(self) -> None: ...
    def clearBeforeRendering(self) -> bool: ...
    def color(self) -> PySide2.QtGui.QColor: ...
    def contentItem(self) -> QQuickItem: ...
    def createTextureFromId(self, id: int, size: PySide2.QtCore.QSize, options: QQuickWindow.CreateTextureOptions | QQuickWindow.CreateTextureOption = ...) -> QSGTexture: ...
    @typing.overload
    def createTextureFromImage(self, image: PySide2.QtGui.QImage, options: QQuickWindow.CreateTextureOptions | QQuickWindow.CreateTextureOption) -> QSGTexture: ...
    @typing.overload
    def createTextureFromImage(self, image: PySide2.QtGui.QImage) -> QSGTexture: ...
    def createTextureFromNativeObject(self, type: QQuickWindow.NativeObjectType, nativeObjectPtr: int, nativeLayout: int, size: PySide2.QtCore.QSize, options: QQuickWindow.CreateTextureOptions | QQuickWindow.CreateTextureOption = ...) -> QSGTexture: ...
    def effectiveDevicePixelRatio(self) -> float: ...
    def endExternalCommands(self) -> None: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def exposeEvent(self, arg__1: PySide2.QtGui.QExposeEvent) -> None: ...
    def focusInEvent(self, arg__1: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusObject(self) -> PySide2.QtCore.QObject: ...
    def focusOutEvent(self, arg__1: PySide2.QtGui.QFocusEvent) -> None: ...
    def grabWindow(self) -> PySide2.QtGui.QImage: ...
    @staticmethod
    def hasDefaultAlphaBuffer() -> bool: ...
    def hideEvent(self, arg__1: PySide2.QtGui.QHideEvent) -> None: ...
    def incubationController(self) -> PySide2.QtQml.QQmlIncubationController: ...
    def isPersistentOpenGLContext(self) -> bool: ...
    def isPersistentSceneGraph(self) -> bool: ...
    def isSceneGraphInitialized(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, arg__1: PySide2.QtGui.QKeyEvent) -> None: ...
    def mouseDoubleClickEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseGrabberItem(self) -> QQuickItem: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def openglContext(self) -> PySide2.QtGui.QOpenGLContext: ...
    def releaseResources(self) -> None: ...
    def renderTarget(self) -> PySide2.QtGui.QOpenGLFramebufferObject: ...
    def renderTargetId(self) -> int: ...
    def renderTargetSize(self) -> PySide2.QtCore.QSize: ...
    def resetOpenGLState(self) -> None: ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent) -> None: ...
    @staticmethod
    def sceneGraphBackend() -> str: ...
    def scheduleRenderJob(self, job: PySide2.QtCore.QRunnable, schedule: QQuickWindow.RenderStage) -> None: ...
    def sendEvent(self, arg__1: QQuickItem, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    def setClearBeforeRendering(self, enabled: bool) -> None: ...
    def setColor(self, color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
    @staticmethod
    def setDefaultAlphaBuffer(useAlpha: bool) -> None: ...
    def setPersistentOpenGLContext(self, persistent: bool) -> None: ...
    def setPersistentSceneGraph(self, persistent: bool) -> None: ...
    @typing.overload
    def setRenderTarget(self, fboId: int, size: PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def setRenderTarget(self, fbo: PySide2.QtGui.QOpenGLFramebufferObject) -> None: ...
    @staticmethod
    def setSceneGraphBackend(backend: str) -> None: ...
    @staticmethod
    def setTextRenderType(renderType: QQuickWindow.TextRenderType) -> None: ...
    def showEvent(self, arg__1: PySide2.QtGui.QShowEvent) -> None: ...
    def tabletEvent(self, arg__1: PySide2.QtGui.QTabletEvent) -> None: ...
    @staticmethod
    def textRenderType() -> QQuickWindow.TextRenderType: ...
    def update(self) -> None: ...
    def wheelEvent(self, arg__1: PySide2.QtGui.QWheelEvent) -> None: ...

class QSGAbstractRenderer(PySide2.QtCore.QObject):
    class ClearMode:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QSGAbstractRenderer.ClearMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QSGAbstractRenderer.ClearMode: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSGAbstractRenderer.ClearMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QSGAbstractRenderer.ClearMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QSGAbstractRenderer.ClearMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSGAbstractRenderer.ClearMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QSGAbstractRenderer.ClearMode: ...

    class ClearModeBit:
        ClearColorBuffer: typing.ClassVar[QSGAbstractRenderer.ClearModeBit] = ...
        ClearDepthBuffer: typing.ClassVar[QSGAbstractRenderer.ClearModeBit] = ...
        ClearStencilBuffer: typing.ClassVar[QSGAbstractRenderer.ClearModeBit] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QSGAbstractRenderer.ClearMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QSGAbstractRenderer.ClearMode: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSGAbstractRenderer.ClearMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QSGAbstractRenderer.ClearMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QSGAbstractRenderer.ClearMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSGAbstractRenderer.ClearMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QSGAbstractRenderer.ClearMode: ...

    class MatrixTransformFlag:
        MatrixTransformFlipY: typing.ClassVar[QSGAbstractRenderer.MatrixTransformFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QSGAbstractRenderer.MatrixTransformFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QSGAbstractRenderer.MatrixTransformFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSGAbstractRenderer.MatrixTransformFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QSGAbstractRenderer.MatrixTransformFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QSGAbstractRenderer.MatrixTransformFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSGAbstractRenderer.MatrixTransformFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QSGAbstractRenderer.MatrixTransformFlags: ...

    class MatrixTransformFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QSGAbstractRenderer.MatrixTransformFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QSGAbstractRenderer.MatrixTransformFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSGAbstractRenderer.MatrixTransformFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QSGAbstractRenderer.MatrixTransformFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QSGAbstractRenderer.MatrixTransformFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSGAbstractRenderer.MatrixTransformFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QSGAbstractRenderer.MatrixTransformFlags: ...
    ClearColorBuffer: typing.ClassVar[QSGAbstractRenderer.ClearModeBit] = ...
    ClearDepthBuffer: typing.ClassVar[QSGAbstractRenderer.ClearModeBit] = ...
    ClearStencilBuffer: typing.ClassVar[QSGAbstractRenderer.ClearModeBit] = ...
    MatrixTransformFlipY: typing.ClassVar[QSGAbstractRenderer.MatrixTransformFlag] = ...
    sceneGraphChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def clearColor(self) -> PySide2.QtGui.QColor: ...
    def clearMode(self) -> QSGAbstractRenderer.ClearMode | QSGAbstractRenderer.ClearModeBit: ...
    def deviceRect(self) -> PySide2.QtCore.QRect: ...
    def nodeChanged(self, node: QSGNode, state: QSGNode.DirtyState | QSGNode.DirtyStateBit) -> None: ...
    def projectionMatrix(self) -> PySide2.QtGui.QMatrix4x4: ...
    def projectionMatrixWithNativeNDC(self) -> PySide2.QtGui.QMatrix4x4: ...
    def renderScene(self, fboId: int = ...) -> None: ...
    def setClearColor(self, color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
    def setClearMode(self, mode: QSGAbstractRenderer.ClearMode | QSGAbstractRenderer.ClearModeBit) -> None: ...
    @typing.overload
    def setDeviceRect(self, size: PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def setDeviceRect(self, rect: PySide2.QtCore.QRect) -> None: ...
    def setProjectionMatrix(self, matrix: PySide2.QtGui.QMatrix4x4) -> None: ...
    @typing.overload
    def setProjectionMatrixToRect(self, rect: PySide2.QtCore.QRectF, flags: QSGAbstractRenderer.MatrixTransformFlags | QSGAbstractRenderer.MatrixTransformFlag) -> None: ...
    @typing.overload
    def setProjectionMatrixToRect(self, rect: PySide2.QtCore.QRectF) -> None: ...
    def setProjectionMatrixWithNativeNDC(self, matrix: PySide2.QtGui.QMatrix4x4) -> None: ...
    @typing.overload
    def setViewportRect(self, size: PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def setViewportRect(self, rect: PySide2.QtCore.QRect) -> None: ...
    def viewportRect(self) -> PySide2.QtCore.QRect: ...

class QSGBasicGeometryNode(QSGNode):
    def __init__(self, type: QSGNode.NodeType) -> None: ...
    def clipList(self) -> QSGClipNode: ...
    def geometry(self) -> QSGGeometry: ...
    def matrix(self) -> PySide2.QtGui.QMatrix4x4: ...
    def setGeometry(self, geometry: QSGGeometry) -> None: ...
    def setRendererClipList(self, c: QSGClipNode) -> None: ...
    def setRendererMatrix(self, m: PySide2.QtGui.QMatrix4x4) -> None: ...

class QSGClipNode(QSGBasicGeometryNode):
    def __init__(self) -> None: ...
    def clipRect(self) -> PySide2.QtCore.QRectF: ...
    def isRectangular(self) -> bool: ...
    def setClipRect(self, arg__1: PySide2.QtCore.QRectF) -> None: ...
    def setIsRectangular(self, rectHint: bool) -> None: ...

class QSGDynamicTexture(QSGTexture):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def updateTexture(self) -> bool: ...

class QSGEngine(PySide2.QtCore.QObject):
    class CreateTextureOption:
        TextureCanUseAtlas: typing.ClassVar[QSGEngine.CreateTextureOption] = ...
        TextureHasAlphaChannel: typing.ClassVar[QSGEngine.CreateTextureOption] = ...
        TextureIsOpaque: typing.ClassVar[QSGEngine.CreateTextureOption] = ...
        TextureOwnsGLTexture: typing.ClassVar[QSGEngine.CreateTextureOption] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QSGEngine.CreateTextureOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QSGEngine.CreateTextureOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSGEngine.CreateTextureOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QSGEngine.CreateTextureOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QSGEngine.CreateTextureOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSGEngine.CreateTextureOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QSGEngine.CreateTextureOptions: ...

    class CreateTextureOptions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QSGEngine.CreateTextureOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QSGEngine.CreateTextureOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSGEngine.CreateTextureOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QSGEngine.CreateTextureOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QSGEngine.CreateTextureOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSGEngine.CreateTextureOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QSGEngine.CreateTextureOptions: ...
    TextureCanUseAtlas: typing.ClassVar[QSGEngine.CreateTextureOption] = ...
    TextureHasAlphaChannel: typing.ClassVar[QSGEngine.CreateTextureOption] = ...
    TextureIsOpaque: typing.ClassVar[QSGEngine.CreateTextureOption] = ...
    TextureOwnsGLTexture: typing.ClassVar[QSGEngine.CreateTextureOption] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def createRenderer(self) -> QSGAbstractRenderer: ...
    def createTextureFromId(self, id: int, size: PySide2.QtCore.QSize, options: QSGEngine.CreateTextureOptions | QSGEngine.CreateTextureOption = ...) -> QSGTexture: ...
    def createTextureFromImage(self, image: PySide2.QtGui.QImage, options: QSGEngine.CreateTextureOptions | QSGEngine.CreateTextureOption = ...) -> QSGTexture: ...
    def initialize(self, context: PySide2.QtGui.QOpenGLContext) -> None: ...
    def invalidate(self) -> None: ...

class QSGGeometry(shiboken2.Object):
    class Attribute(shiboken2.Object):
        attributeType: _typeshed.Incomplete
        isVertexCoordinate: _typeshed.Incomplete
        position: _typeshed.Incomplete
        reserved: _typeshed.Incomplete
        tupleSize: _typeshed.Incomplete
        type: _typeshed.Incomplete
        @typing.overload
        def __init__(self, Attribute: QSGGeometry.Attribute) -> None: ...
        @typing.overload
        def __init__(self) -> None: ...
        @staticmethod
        def create(pos: int, tupleSize: int, primitiveType: int, isPosition: bool = ...) -> QSGGeometry.Attribute: ...
        @staticmethod
        def createWithAttributeType(pos: int, tupleSize: int, primitiveType: int, attributeType: QSGGeometry.AttributeType) -> QSGGeometry.Attribute: ...
        def __copy__(self) -> None: ...

    class AttributeSet(shiboken2.Object):
        attributes: _typeshed.Incomplete
        count: _typeshed.Incomplete
        stride: _typeshed.Incomplete
        @typing.overload
        def __init__(self, AttributeSet: QSGGeometry.AttributeSet) -> None: ...
        @typing.overload
        def __init__(self) -> None: ...
        def __copy__(self) -> None: ...

    class AttributeType:
        ColorAttribute: typing.ClassVar[QSGGeometry.AttributeType] = ...
        PositionAttribute: typing.ClassVar[QSGGeometry.AttributeType] = ...
        TexCoord1Attribute: typing.ClassVar[QSGGeometry.AttributeType] = ...
        TexCoord2Attribute: typing.ClassVar[QSGGeometry.AttributeType] = ...
        TexCoordAttribute: typing.ClassVar[QSGGeometry.AttributeType] = ...
        UnknownAttribute: typing.ClassVar[QSGGeometry.AttributeType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSGGeometry.AttributeType: ...
        def __and__(self, other: typing.SupportsInt) -> QSGGeometry.AttributeType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSGGeometry.AttributeType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSGGeometry.AttributeType: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSGGeometry.AttributeType: ...
        def __rand__(self, other: typing.SupportsInt) -> QSGGeometry.AttributeType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSGGeometry.AttributeType: ...
        def __ror__(self, other: typing.SupportsInt) -> QSGGeometry.AttributeType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSGGeometry.AttributeType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSGGeometry.AttributeType: ...
        def __sub__(self, other: typing.SupportsInt) -> QSGGeometry.AttributeType: ...
        def __xor__(self, other: typing.SupportsInt) -> QSGGeometry.AttributeType: ...

    class ColoredPoint2D(shiboken2.Object):
        a: _typeshed.Incomplete
        b: _typeshed.Incomplete
        g: _typeshed.Incomplete
        r: _typeshed.Incomplete
        x: _typeshed.Incomplete
        y: _typeshed.Incomplete
        @typing.overload
        def __init__(self, ColoredPoint2D: QSGGeometry.ColoredPoint2D) -> None: ...
        @typing.overload
        def __init__(self) -> None: ...
        def set(self, nx: float, ny: float, nr: int, ng: int, nb: int, na: int) -> None: ...
        def __copy__(self) -> None: ...

    class DataPattern:
        AlwaysUploadPattern: typing.ClassVar[QSGGeometry.DataPattern] = ...
        DynamicPattern: typing.ClassVar[QSGGeometry.DataPattern] = ...
        StaticPattern: typing.ClassVar[QSGGeometry.DataPattern] = ...
        StreamPattern: typing.ClassVar[QSGGeometry.DataPattern] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSGGeometry.DataPattern: ...
        def __and__(self, other: typing.SupportsInt) -> QSGGeometry.DataPattern: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSGGeometry.DataPattern: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSGGeometry.DataPattern: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSGGeometry.DataPattern: ...
        def __rand__(self, other: typing.SupportsInt) -> QSGGeometry.DataPattern: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSGGeometry.DataPattern: ...
        def __ror__(self, other: typing.SupportsInt) -> QSGGeometry.DataPattern: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSGGeometry.DataPattern: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSGGeometry.DataPattern: ...
        def __sub__(self, other: typing.SupportsInt) -> QSGGeometry.DataPattern: ...
        def __xor__(self, other: typing.SupportsInt) -> QSGGeometry.DataPattern: ...

    class DrawingMode:
        DrawLineLoop: typing.ClassVar[QSGGeometry.DrawingMode] = ...
        DrawLineStrip: typing.ClassVar[QSGGeometry.DrawingMode] = ...
        DrawLines: typing.ClassVar[QSGGeometry.DrawingMode] = ...
        DrawPoints: typing.ClassVar[QSGGeometry.DrawingMode] = ...
        DrawTriangleFan: typing.ClassVar[QSGGeometry.DrawingMode] = ...
        DrawTriangleStrip: typing.ClassVar[QSGGeometry.DrawingMode] = ...
        DrawTriangles: typing.ClassVar[QSGGeometry.DrawingMode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSGGeometry.DrawingMode: ...
        def __and__(self, other: typing.SupportsInt) -> QSGGeometry.DrawingMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSGGeometry.DrawingMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSGGeometry.DrawingMode: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSGGeometry.DrawingMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QSGGeometry.DrawingMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSGGeometry.DrawingMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QSGGeometry.DrawingMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSGGeometry.DrawingMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSGGeometry.DrawingMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QSGGeometry.DrawingMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QSGGeometry.DrawingMode: ...

    class Point2D(shiboken2.Object):
        x: _typeshed.Incomplete
        y: _typeshed.Incomplete
        @typing.overload
        def __init__(self, Point2D: QSGGeometry.Point2D) -> None: ...
        @typing.overload
        def __init__(self) -> None: ...
        def set(self, nx: float, ny: float) -> None: ...
        def __copy__(self) -> None: ...

    class TexturedPoint2D(shiboken2.Object):
        tx: _typeshed.Incomplete
        ty: _typeshed.Incomplete
        x: _typeshed.Incomplete
        y: _typeshed.Incomplete
        @typing.overload
        def __init__(self, TexturedPoint2D: QSGGeometry.TexturedPoint2D) -> None: ...
        @typing.overload
        def __init__(self) -> None: ...
        def set(self, nx: float, ny: float, ntx: float, nty: float) -> None: ...
        def __copy__(self) -> None: ...

    class Type:
        ByteType: typing.ClassVar[QSGGeometry.Type] = ...
        Bytes2Type: typing.ClassVar[QSGGeometry.Type] = ...
        Bytes3Type: typing.ClassVar[QSGGeometry.Type] = ...
        Bytes4Type: typing.ClassVar[QSGGeometry.Type] = ...
        DoubleType: typing.ClassVar[QSGGeometry.Type] = ...
        FloatType: typing.ClassVar[QSGGeometry.Type] = ...
        IntType: typing.ClassVar[QSGGeometry.Type] = ...
        ShortType: typing.ClassVar[QSGGeometry.Type] = ...
        UnsignedByteType: typing.ClassVar[QSGGeometry.Type] = ...
        UnsignedIntType: typing.ClassVar[QSGGeometry.Type] = ...
        UnsignedShortType: typing.ClassVar[QSGGeometry.Type] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSGGeometry.Type: ...
        def __and__(self, other: typing.SupportsInt) -> QSGGeometry.Type: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSGGeometry.Type: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSGGeometry.Type: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSGGeometry.Type: ...
        def __rand__(self, other: typing.SupportsInt) -> QSGGeometry.Type: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSGGeometry.Type: ...
        def __ror__(self, other: typing.SupportsInt) -> QSGGeometry.Type: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSGGeometry.Type: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSGGeometry.Type: ...
        def __sub__(self, other: typing.SupportsInt) -> QSGGeometry.Type: ...
        def __xor__(self, other: typing.SupportsInt) -> QSGGeometry.Type: ...
    AlwaysUploadPattern: typing.ClassVar[QSGGeometry.DataPattern] = ...
    ByteType: typing.ClassVar[QSGGeometry.Type] = ...
    Bytes2Type: typing.ClassVar[QSGGeometry.Type] = ...
    Bytes3Type: typing.ClassVar[QSGGeometry.Type] = ...
    Bytes4Type: typing.ClassVar[QSGGeometry.Type] = ...
    ColorAttribute: typing.ClassVar[QSGGeometry.AttributeType] = ...
    DoubleType: typing.ClassVar[QSGGeometry.Type] = ...
    DrawLineLoop: typing.ClassVar[QSGGeometry.DrawingMode] = ...
    DrawLineStrip: typing.ClassVar[QSGGeometry.DrawingMode] = ...
    DrawLines: typing.ClassVar[QSGGeometry.DrawingMode] = ...
    DrawPoints: typing.ClassVar[QSGGeometry.DrawingMode] = ...
    DrawTriangleFan: typing.ClassVar[QSGGeometry.DrawingMode] = ...
    DrawTriangleStrip: typing.ClassVar[QSGGeometry.DrawingMode] = ...
    DrawTriangles: typing.ClassVar[QSGGeometry.DrawingMode] = ...
    DynamicPattern: typing.ClassVar[QSGGeometry.DataPattern] = ...
    FloatType: typing.ClassVar[QSGGeometry.Type] = ...
    IntType: typing.ClassVar[QSGGeometry.Type] = ...
    PositionAttribute: typing.ClassVar[QSGGeometry.AttributeType] = ...
    ShortType: typing.ClassVar[QSGGeometry.Type] = ...
    StaticPattern: typing.ClassVar[QSGGeometry.DataPattern] = ...
    StreamPattern: typing.ClassVar[QSGGeometry.DataPattern] = ...
    TexCoord1Attribute: typing.ClassVar[QSGGeometry.AttributeType] = ...
    TexCoord2Attribute: typing.ClassVar[QSGGeometry.AttributeType] = ...
    TexCoordAttribute: typing.ClassVar[QSGGeometry.AttributeType] = ...
    UnknownAttribute: typing.ClassVar[QSGGeometry.AttributeType] = ...
    UnsignedByteType: typing.ClassVar[QSGGeometry.Type] = ...
    UnsignedIntType: typing.ClassVar[QSGGeometry.Type] = ...
    UnsignedShortType: typing.ClassVar[QSGGeometry.Type] = ...
    def __init__(self, attribs: QSGGeometry.AttributeSet, vertexCount: int, indexCount: int = ..., indexType: int = ...) -> None: ...
    def allocate(self, vertexCount: int, indexCount: int = ...) -> None: ...
    def attributeCount(self) -> int: ...
    def attributes(self) -> QSGGeometry.Attribute: ...
    @staticmethod
    def defaultAttributes_ColoredPoint2D() -> QSGGeometry.AttributeSet: ...
    @staticmethod
    def defaultAttributes_Point2D() -> QSGGeometry.AttributeSet: ...
    @staticmethod
    def defaultAttributes_TexturedPoint2D() -> QSGGeometry.AttributeSet: ...
    def drawingMode(self) -> int: ...
    def indexCount(self) -> int: ...
    def indexData(self) -> int: ...
    def indexDataAsUInt(self) -> typing.List[int]: ...
    def indexDataAsUShort(self) -> typing.List[int]: ...
    def indexDataPattern(self) -> QSGGeometry.DataPattern: ...
    def indexType(self) -> int: ...
    def lineWidth(self) -> float: ...
    def markIndexDataDirty(self) -> None: ...
    def markVertexDataDirty(self) -> None: ...
    def setDrawingMode(self, mode: int) -> None: ...
    def setIndexDataPattern(self, p: QSGGeometry.DataPattern) -> None: ...
    def setLineWidth(self, w: float) -> None: ...
    def setVertexDataPattern(self, p: QSGGeometry.DataPattern) -> None: ...
    def sizeOfIndex(self) -> int: ...
    def sizeOfVertex(self) -> int: ...
    @staticmethod
    def updateColoredRectGeometry(g: QSGGeometry, rect: PySide2.QtCore.QRectF) -> None: ...
    @staticmethod
    def updateRectGeometry(g: QSGGeometry, rect: PySide2.QtCore.QRectF) -> None: ...
    @staticmethod
    def updateTexturedRectGeometry(g: QSGGeometry, rect: PySide2.QtCore.QRectF, sourceRect: PySide2.QtCore.QRectF) -> None: ...
    def vertexCount(self) -> int: ...
    def vertexData(self) -> int: ...
    def vertexDataAsColoredPoint2D(self) -> QSGGeometry.ColoredPoint2D: ...
    def vertexDataAsPoint2D(self) -> QSGGeometry.Point2D: ...
    def vertexDataAsTexturedPoint2D(self) -> QSGGeometry.TexturedPoint2D: ...
    def vertexDataPattern(self) -> QSGGeometry.DataPattern: ...

class QSGGeometryNode(QSGBasicGeometryNode):
    def __init__(self) -> None: ...
    def inheritedOpacity(self) -> float: ...
    def renderOrder(self) -> int: ...
    def setInheritedOpacity(self, opacity: float) -> None: ...
    def setRenderOrder(self, order: int) -> None: ...

class QSGMaterialType(shiboken2.Object):
    def __init__(self) -> None: ...

class QSGNode(shiboken2.Object):
    class DirtyState:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QSGNode.DirtyState: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QSGNode.DirtyState: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSGNode.DirtyState: ...
        def __rand__(self, other: typing.SupportsInt) -> QSGNode.DirtyState: ...
        def __ror__(self, other: typing.SupportsInt) -> QSGNode.DirtyState: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSGNode.DirtyState: ...
        def __xor__(self, other: typing.SupportsInt) -> QSGNode.DirtyState: ...

    class DirtyStateBit:
        DirtyForceUpdate: typing.ClassVar[QSGNode.DirtyStateBit] = ...
        DirtyGeometry: typing.ClassVar[QSGNode.DirtyStateBit] = ...
        DirtyMaterial: typing.ClassVar[QSGNode.DirtyStateBit] = ...
        DirtyMatrix: typing.ClassVar[QSGNode.DirtyStateBit] = ...
        DirtyNodeAdded: typing.ClassVar[QSGNode.DirtyStateBit] = ...
        DirtyNodeRemoved: typing.ClassVar[QSGNode.DirtyStateBit] = ...
        DirtyOpacity: typing.ClassVar[QSGNode.DirtyStateBit] = ...
        DirtyPropagationMask: typing.ClassVar[QSGNode.DirtyStateBit] = ...
        DirtySubtreeBlocked: typing.ClassVar[QSGNode.DirtyStateBit] = ...
        DirtyUsePreprocess: typing.ClassVar[QSGNode.DirtyStateBit] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QSGNode.DirtyState: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QSGNode.DirtyState: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSGNode.DirtyState: ...
        def __rand__(self, other: typing.SupportsInt) -> QSGNode.DirtyState: ...
        def __ror__(self, other: typing.SupportsInt) -> QSGNode.DirtyState: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSGNode.DirtyState: ...
        def __xor__(self, other: typing.SupportsInt) -> QSGNode.DirtyState: ...

    class Flag:
        IsVisitableNode: typing.ClassVar[QSGNode.Flag] = ...
        OwnedByParent: typing.ClassVar[QSGNode.Flag] = ...
        OwnsGeometry: typing.ClassVar[QSGNode.Flag] = ...
        OwnsMaterial: typing.ClassVar[QSGNode.Flag] = ...
        OwnsOpaqueMaterial: typing.ClassVar[QSGNode.Flag] = ...
        UsePreprocess: typing.ClassVar[QSGNode.Flag] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QSGNode.Flags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QSGNode.Flags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSGNode.Flags: ...
        def __rand__(self, other: typing.SupportsInt) -> QSGNode.Flags: ...
        def __ror__(self, other: typing.SupportsInt) -> QSGNode.Flags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSGNode.Flags: ...
        def __xor__(self, other: typing.SupportsInt) -> QSGNode.Flags: ...

    class Flags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QSGNode.Flags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QSGNode.Flags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSGNode.Flags: ...
        def __rand__(self, other: typing.SupportsInt) -> QSGNode.Flags: ...
        def __ror__(self, other: typing.SupportsInt) -> QSGNode.Flags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSGNode.Flags: ...
        def __xor__(self, other: typing.SupportsInt) -> QSGNode.Flags: ...

    class NodeType:
        BasicNodeType: typing.ClassVar[QSGNode.NodeType] = ...
        ClipNodeType: typing.ClassVar[QSGNode.NodeType] = ...
        GeometryNodeType: typing.ClassVar[QSGNode.NodeType] = ...
        OpacityNodeType: typing.ClassVar[QSGNode.NodeType] = ...
        RenderNodeType: typing.ClassVar[QSGNode.NodeType] = ...
        RootNodeType: typing.ClassVar[QSGNode.NodeType] = ...
        TransformNodeType: typing.ClassVar[QSGNode.NodeType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSGNode.NodeType: ...
        def __and__(self, other: typing.SupportsInt) -> QSGNode.NodeType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSGNode.NodeType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSGNode.NodeType: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSGNode.NodeType: ...
        def __rand__(self, other: typing.SupportsInt) -> QSGNode.NodeType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSGNode.NodeType: ...
        def __ror__(self, other: typing.SupportsInt) -> QSGNode.NodeType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSGNode.NodeType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSGNode.NodeType: ...
        def __sub__(self, other: typing.SupportsInt) -> QSGNode.NodeType: ...
        def __xor__(self, other: typing.SupportsInt) -> QSGNode.NodeType: ...
    BasicNodeType: typing.ClassVar[QSGNode.NodeType] = ...
    ClipNodeType: typing.ClassVar[QSGNode.NodeType] = ...
    DirtyForceUpdate: typing.ClassVar[QSGNode.DirtyStateBit] = ...
    DirtyGeometry: typing.ClassVar[QSGNode.DirtyStateBit] = ...
    DirtyMaterial: typing.ClassVar[QSGNode.DirtyStateBit] = ...
    DirtyMatrix: typing.ClassVar[QSGNode.DirtyStateBit] = ...
    DirtyNodeAdded: typing.ClassVar[QSGNode.DirtyStateBit] = ...
    DirtyNodeRemoved: typing.ClassVar[QSGNode.DirtyStateBit] = ...
    DirtyOpacity: typing.ClassVar[QSGNode.DirtyStateBit] = ...
    DirtyPropagationMask: typing.ClassVar[QSGNode.DirtyStateBit] = ...
    DirtySubtreeBlocked: typing.ClassVar[QSGNode.DirtyStateBit] = ...
    DirtyUsePreprocess: typing.ClassVar[QSGNode.DirtyStateBit] = ...
    GeometryNodeType: typing.ClassVar[QSGNode.NodeType] = ...
    IsVisitableNode: typing.ClassVar[QSGNode.Flag] = ...
    OpacityNodeType: typing.ClassVar[QSGNode.NodeType] = ...
    OwnedByParent: typing.ClassVar[QSGNode.Flag] = ...
    OwnsGeometry: typing.ClassVar[QSGNode.Flag] = ...
    OwnsMaterial: typing.ClassVar[QSGNode.Flag] = ...
    OwnsOpaqueMaterial: typing.ClassVar[QSGNode.Flag] = ...
    RenderNodeType: typing.ClassVar[QSGNode.NodeType] = ...
    RootNodeType: typing.ClassVar[QSGNode.NodeType] = ...
    TransformNodeType: typing.ClassVar[QSGNode.NodeType] = ...
    UsePreprocess: typing.ClassVar[QSGNode.Flag] = ...
    @typing.overload
    def __init__(self, type: QSGNode.NodeType) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def appendChildNode(self, node: QSGNode) -> None: ...
    def childAtIndex(self, i: int) -> QSGNode: ...
    def childCount(self) -> int: ...
    def clearDirty(self) -> None: ...
    def dirtyState(self) -> QSGNode.DirtyState | QSGNode.DirtyStateBit: ...
    def firstChild(self) -> QSGNode: ...
    def flags(self) -> QSGNode.Flags | QSGNode.Flag: ...
    def insertChildNodeAfter(self, node: QSGNode, after: QSGNode) -> None: ...
    def insertChildNodeBefore(self, node: QSGNode, before: QSGNode) -> None: ...
    def isSubtreeBlocked(self) -> bool: ...
    def lastChild(self) -> QSGNode: ...
    def markDirty(self, bits: QSGNode.DirtyState | QSGNode.DirtyStateBit) -> None: ...
    def nextSibling(self) -> QSGNode: ...
    def parent(self) -> QSGNode: ...
    def prependChildNode(self, node: QSGNode) -> None: ...
    def preprocess(self) -> None: ...
    def previousSibling(self) -> QSGNode: ...
    def removeAllChildNodes(self) -> None: ...
    def removeChildNode(self, node: QSGNode) -> None: ...
    def reparentChildNodesTo(self, newParent: QSGNode) -> None: ...
    def setFlag(self, arg__1: QSGNode.Flag, arg__2: bool = ...) -> None: ...
    def setFlags(self, arg__1: QSGNode.Flags | QSGNode.Flag, arg__2: bool = ...) -> None: ...
    def type(self) -> QSGNode.NodeType: ...

class QSGOpacityNode(QSGNode):
    def __init__(self) -> None: ...
    def combinedOpacity(self) -> float: ...
    def isSubtreeBlocked(self) -> bool: ...
    def opacity(self) -> float: ...
    def setCombinedOpacity(self, opacity: float) -> None: ...
    def setOpacity(self, opacity: float) -> None: ...

class QSGSimpleRectNode(QSGGeometryNode):
    @typing.overload
    def __init__(self, rect: PySide2.QtCore.QRectF, color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def color(self) -> PySide2.QtGui.QColor: ...
    def rect(self) -> PySide2.QtCore.QRectF: ...
    def setColor(self, color: PySide2.QtGui.QColor | PySide2.QtCore.Qt.GlobalColor | int) -> None: ...
    @typing.overload
    def setRect(self, x: float, y: float, w: float, h: float) -> None: ...
    @typing.overload
    def setRect(self, rect: PySide2.QtCore.QRectF) -> None: ...

class QSGSimpleTextureNode(QSGGeometryNode):
    class TextureCoordinatesTransformFlag:
        MirrorHorizontally: typing.ClassVar[QSGSimpleTextureNode.TextureCoordinatesTransformFlag] = ...
        MirrorVertically: typing.ClassVar[QSGSimpleTextureNode.TextureCoordinatesTransformFlag] = ...
        NoTransform: typing.ClassVar[QSGSimpleTextureNode.TextureCoordinatesTransformFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QSGSimpleTextureNode.TextureCoordinatesTransformMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QSGSimpleTextureNode.TextureCoordinatesTransformMode: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSGSimpleTextureNode.TextureCoordinatesTransformMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QSGSimpleTextureNode.TextureCoordinatesTransformMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QSGSimpleTextureNode.TextureCoordinatesTransformMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSGSimpleTextureNode.TextureCoordinatesTransformMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QSGSimpleTextureNode.TextureCoordinatesTransformMode: ...

    class TextureCoordinatesTransformMode:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QSGSimpleTextureNode.TextureCoordinatesTransformMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QSGSimpleTextureNode.TextureCoordinatesTransformMode: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSGSimpleTextureNode.TextureCoordinatesTransformMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QSGSimpleTextureNode.TextureCoordinatesTransformMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QSGSimpleTextureNode.TextureCoordinatesTransformMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSGSimpleTextureNode.TextureCoordinatesTransformMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QSGSimpleTextureNode.TextureCoordinatesTransformMode: ...
    MirrorHorizontally: typing.ClassVar[QSGSimpleTextureNode.TextureCoordinatesTransformFlag] = ...
    MirrorVertically: typing.ClassVar[QSGSimpleTextureNode.TextureCoordinatesTransformFlag] = ...
    NoTransform: typing.ClassVar[QSGSimpleTextureNode.TextureCoordinatesTransformFlag] = ...
    def __init__(self) -> None: ...
    def filtering(self) -> QSGTexture.Filtering: ...
    def ownsTexture(self) -> bool: ...
    def rect(self) -> PySide2.QtCore.QRectF: ...
    def setFiltering(self, filtering: QSGTexture.Filtering) -> None: ...
    def setOwnsTexture(self, owns: bool) -> None: ...
    @typing.overload
    def setRect(self, x: float, y: float, w: float, h: float) -> None: ...
    @typing.overload
    def setRect(self, rect: PySide2.QtCore.QRectF) -> None: ...
    @typing.overload
    def setSourceRect(self, x: float, y: float, w: float, h: float) -> None: ...
    @typing.overload
    def setSourceRect(self, r: PySide2.QtCore.QRectF) -> None: ...
    def setTexture(self, texture: QSGTexture) -> None: ...
    def setTextureCoordinatesTransform(self, mode: QSGSimpleTextureNode.TextureCoordinatesTransformMode | QSGSimpleTextureNode.TextureCoordinatesTransformFlag) -> None: ...
    def sourceRect(self) -> PySide2.QtCore.QRectF: ...
    def texture(self) -> QSGTexture: ...
    def textureCoordinatesTransform(self) -> QSGSimpleTextureNode.TextureCoordinatesTransformMode | QSGSimpleTextureNode.TextureCoordinatesTransformFlag: ...

class QSGTexture(PySide2.QtCore.QObject):
    class AnisotropyLevel:
        Anisotropy16x: typing.ClassVar[QSGTexture.AnisotropyLevel] = ...
        Anisotropy2x: typing.ClassVar[QSGTexture.AnisotropyLevel] = ...
        Anisotropy4x: typing.ClassVar[QSGTexture.AnisotropyLevel] = ...
        Anisotropy8x: typing.ClassVar[QSGTexture.AnisotropyLevel] = ...
        AnisotropyNone: typing.ClassVar[QSGTexture.AnisotropyLevel] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSGTexture.AnisotropyLevel: ...
        def __and__(self, other: typing.SupportsInt) -> QSGTexture.AnisotropyLevel: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSGTexture.AnisotropyLevel: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSGTexture.AnisotropyLevel: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSGTexture.AnisotropyLevel: ...
        def __rand__(self, other: typing.SupportsInt) -> QSGTexture.AnisotropyLevel: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSGTexture.AnisotropyLevel: ...
        def __ror__(self, other: typing.SupportsInt) -> QSGTexture.AnisotropyLevel: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSGTexture.AnisotropyLevel: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSGTexture.AnisotropyLevel: ...
        def __sub__(self, other: typing.SupportsInt) -> QSGTexture.AnisotropyLevel: ...
        def __xor__(self, other: typing.SupportsInt) -> QSGTexture.AnisotropyLevel: ...

    class Filtering:
        Linear: typing.ClassVar[QSGTexture.Filtering] = ...
        Nearest: typing.ClassVar[QSGTexture.Filtering] = ...
        None_: typing.ClassVar[QSGTexture.Filtering] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSGTexture.Filtering: ...
        def __and__(self, other: typing.SupportsInt) -> QSGTexture.Filtering: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSGTexture.Filtering: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSGTexture.Filtering: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSGTexture.Filtering: ...
        def __rand__(self, other: typing.SupportsInt) -> QSGTexture.Filtering: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSGTexture.Filtering: ...
        def __ror__(self, other: typing.SupportsInt) -> QSGTexture.Filtering: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSGTexture.Filtering: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSGTexture.Filtering: ...
        def __sub__(self, other: typing.SupportsInt) -> QSGTexture.Filtering: ...
        def __xor__(self, other: typing.SupportsInt) -> QSGTexture.Filtering: ...

    class WrapMode:
        ClampToEdge: typing.ClassVar[QSGTexture.WrapMode] = ...
        MirroredRepeat: typing.ClassVar[QSGTexture.WrapMode] = ...
        Repeat: typing.ClassVar[QSGTexture.WrapMode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSGTexture.WrapMode: ...
        def __and__(self, other: typing.SupportsInt) -> QSGTexture.WrapMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSGTexture.WrapMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSGTexture.WrapMode: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSGTexture.WrapMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QSGTexture.WrapMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSGTexture.WrapMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QSGTexture.WrapMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSGTexture.WrapMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSGTexture.WrapMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QSGTexture.WrapMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QSGTexture.WrapMode: ...
    Anisotropy16x: typing.ClassVar[QSGTexture.AnisotropyLevel] = ...
    Anisotropy2x: typing.ClassVar[QSGTexture.AnisotropyLevel] = ...
    Anisotropy4x: typing.ClassVar[QSGTexture.AnisotropyLevel] = ...
    Anisotropy8x: typing.ClassVar[QSGTexture.AnisotropyLevel] = ...
    AnisotropyNone: typing.ClassVar[QSGTexture.AnisotropyLevel] = ...
    ClampToEdge: typing.ClassVar[QSGTexture.WrapMode] = ...
    Linear: typing.ClassVar[QSGTexture.Filtering] = ...
    MirroredRepeat: typing.ClassVar[QSGTexture.WrapMode] = ...
    Nearest: typing.ClassVar[QSGTexture.Filtering] = ...
    None_: typing.ClassVar[QSGTexture.Filtering] = ...
    Repeat: typing.ClassVar[QSGTexture.WrapMode] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def anisotropyLevel(self) -> QSGTexture.AnisotropyLevel: ...
    def bind(self) -> None: ...
    def comparisonKey(self) -> int: ...
    def convertToNormalizedSourceRect(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def filtering(self) -> QSGTexture.Filtering: ...
    def hasAlphaChannel(self) -> bool: ...
    def hasMipmaps(self) -> bool: ...
    def horizontalWrapMode(self) -> QSGTexture.WrapMode: ...
    def isAtlasTexture(self) -> bool: ...
    def mipmapFiltering(self) -> QSGTexture.Filtering: ...
    def normalizedTextureSubRect(self) -> PySide2.QtCore.QRectF: ...
    def removedFromAtlas(self) -> QSGTexture: ...
    def setAnisotropyLevel(self, level: QSGTexture.AnisotropyLevel) -> None: ...
    def setFiltering(self, filter: QSGTexture.Filtering) -> None: ...
    def setHorizontalWrapMode(self, hwrap: QSGTexture.WrapMode) -> None: ...
    def setMipmapFiltering(self, filter: QSGTexture.Filtering) -> None: ...
    def setVerticalWrapMode(self, vwrap: QSGTexture.WrapMode) -> None: ...
    def textureId(self) -> int: ...
    def textureSize(self) -> PySide2.QtCore.QSize: ...
    def updateBindOptions(self, force: bool = ...) -> None: ...
    def verticalWrapMode(self) -> QSGTexture.WrapMode: ...

class QSGTextureProvider(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    textureChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def texture(self) -> QSGTexture: ...

class QSGTransformNode(QSGNode):
    def __init__(self) -> None: ...
    def combinedMatrix(self) -> PySide2.QtGui.QMatrix4x4: ...
    def matrix(self) -> PySide2.QtGui.QMatrix4x4: ...
    def setCombinedMatrix(self, matrix: PySide2.QtGui.QMatrix4x4) -> None: ...
    def setMatrix(self, matrix: PySide2.QtGui.QMatrix4x4) -> None: ...
