import PySide2.QtCore
import _typeshed
import collections
import shiboken2
import typing
T = typing.TypeVar('T')
import typing_extensions

class QAccelerometer(QSensor):
    class AccelerationMode:
        Combined: typing.ClassVar[QAccelerometer.AccelerationMode] = ...
        Gravity: typing.ClassVar[QAccelerometer.AccelerationMode] = ...
        User: typing.ClassVar[QAccelerometer.AccelerationMode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAccelerometer.AccelerationMode: ...
        def __and__(self, other: typing.SupportsInt) -> QAccelerometer.AccelerationMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAccelerometer.AccelerationMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAccelerometer.AccelerationMode: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QAccelerometer.AccelerationMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QAccelerometer.AccelerationMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAccelerometer.AccelerationMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QAccelerometer.AccelerationMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAccelerometer.AccelerationMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAccelerometer.AccelerationMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QAccelerometer.AccelerationMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QAccelerometer.AccelerationMode: ...
    Combined: typing.ClassVar[QAccelerometer.AccelerationMode] = ...
    Gravity: typing.ClassVar[QAccelerometer.AccelerationMode] = ...
    User: typing.ClassVar[QAccelerometer.AccelerationMode] = ...
    accelerationModeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    type: typing.ClassVar[str] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., accelerationMode: QAccelerometer.AccelerationMode = ..., accelerationModeChanged: typing.Callable = ..., active: bool = ..., activeChanged: typing.Callable = ..., alwaysOn: bool = ..., alwaysOnChanged: typing.Callable = ..., availableDataRates: typing.Any = ..., availableSensorsChanged: typing.Callable = ..., axesOrientationMode: QAccelerometer.AxesOrientationMode = ..., axesOrientationModeChanged: typing.Callable = ..., bufferSize: int = ..., bufferSizeChanged: typing.Callable = ..., busy: bool = ..., busyChanged: typing.Callable = ..., connectedToBackend: bool = ..., currentOrientation: int = ..., currentOrientationChanged: typing.Callable = ..., dataRate: int = ..., dataRateChanged: typing.Callable = ..., description: str = ..., destroyed: typing.Callable = ..., efficientBufferSize: int = ..., efficientBufferSizeChanged: typing.Callable = ..., error: int = ..., identifier: PySide2.QtCore.QByteArray | bytes = ..., maxBufferSize: int = ..., maxBufferSizeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., outputRange: int = ..., outputRanges: typing.Any = ..., reading: QAccelerometerReading = ..., readingChanged: typing.Callable = ..., sensorError: typing.Callable = ..., skipDuplicates: bool = ..., skipDuplicatesChanged: typing.Callable = ..., type: PySide2.QtCore.QByteArray | bytes = ..., userOrientation: int = ..., userOrientationChanged: typing.Callable = ...) -> None: ...
    def accelerationMode(self) -> QAccelerometer.AccelerationMode: ...
    def reading(self) -> QAccelerometerReading: ...
    def setAccelerationMode(self, accelerationMode: QAccelerometer.AccelerationMode) -> None: ...

class QAccelerometerFilter(QSensorFilter):
    def __init__(self) -> None: ...
    @typing.overload
    def filter(self, reading: QAccelerometerReading) -> bool: ...
    @typing.overload
    def filter(self, reading: QSensorReading) -> bool: ...

class QAccelerometerReading(QSensorReading):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., timestamp: int = ...) -> None: ...
    def copyValuesFrom(self, other: QSensorReading) -> None: ...
    def setX(self, x: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def setZ(self, z: float) -> None: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...

class QAltimeter(QSensor):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    type: typing.ClassVar[str] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., active: bool = ..., activeChanged: typing.Callable = ..., alwaysOn: bool = ..., alwaysOnChanged: typing.Callable = ..., availableDataRates: typing.Any = ..., availableSensorsChanged: typing.Callable = ..., axesOrientationMode: QAltimeter.AxesOrientationMode = ..., axesOrientationModeChanged: typing.Callable = ..., bufferSize: int = ..., bufferSizeChanged: typing.Callable = ..., busy: bool = ..., busyChanged: typing.Callable = ..., connectedToBackend: bool = ..., currentOrientation: int = ..., currentOrientationChanged: typing.Callable = ..., dataRate: int = ..., dataRateChanged: typing.Callable = ..., description: str = ..., destroyed: typing.Callable = ..., efficientBufferSize: int = ..., efficientBufferSizeChanged: typing.Callable = ..., error: int = ..., identifier: PySide2.QtCore.QByteArray | bytes = ..., maxBufferSize: int = ..., maxBufferSizeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., outputRange: int = ..., outputRanges: typing.Any = ..., reading: QAltimeterReading = ..., readingChanged: typing.Callable = ..., sensorError: typing.Callable = ..., skipDuplicates: bool = ..., skipDuplicatesChanged: typing.Callable = ..., type: PySide2.QtCore.QByteArray | bytes = ..., userOrientation: int = ..., userOrientationChanged: typing.Callable = ...) -> None: ...
    def reading(self) -> QAltimeterReading: ...

class QAltimeterFilter(QSensorFilter):
    def __init__(self) -> None: ...
    @typing.overload
    def filter(self, reading: QAltimeterReading) -> bool: ...
    @typing.overload
    def filter(self, reading: QSensorReading) -> bool: ...

class QAltimeterReading(QSensorReading):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., timestamp: int = ...) -> None: ...
    def altitude(self) -> float: ...
    def copyValuesFrom(self, other: QSensorReading) -> None: ...
    def setAltitude(self, altitude: float) -> None: ...

class QAmbientLightFilter(QSensorFilter):
    def __init__(self) -> None: ...
    @typing.overload
    def filter(self, reading: QAmbientLightReading) -> bool: ...
    @typing.overload
    def filter(self, reading: QSensorReading) -> bool: ...

class QAmbientLightReading(QSensorReading):
    class LightLevel:
        Bright: typing.ClassVar[QAmbientLightReading.LightLevel] = ...
        Dark: typing.ClassVar[QAmbientLightReading.LightLevel] = ...
        Light: typing.ClassVar[QAmbientLightReading.LightLevel] = ...
        Sunny: typing.ClassVar[QAmbientLightReading.LightLevel] = ...
        Twilight: typing.ClassVar[QAmbientLightReading.LightLevel] = ...
        Undefined: typing.ClassVar[QAmbientLightReading.LightLevel] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAmbientLightReading.LightLevel: ...
        def __and__(self, other: typing.SupportsInt) -> QAmbientLightReading.LightLevel: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAmbientLightReading.LightLevel: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAmbientLightReading.LightLevel: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QAmbientLightReading.LightLevel: ...
        def __rand__(self, other: typing.SupportsInt) -> QAmbientLightReading.LightLevel: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAmbientLightReading.LightLevel: ...
        def __ror__(self, other: typing.SupportsInt) -> QAmbientLightReading.LightLevel: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAmbientLightReading.LightLevel: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAmbientLightReading.LightLevel: ...
        def __sub__(self, other: typing.SupportsInt) -> QAmbientLightReading.LightLevel: ...
        def __xor__(self, other: typing.SupportsInt) -> QAmbientLightReading.LightLevel: ...
    Bright: typing.ClassVar[QAmbientLightReading.LightLevel] = ...
    Dark: typing.ClassVar[QAmbientLightReading.LightLevel] = ...
    Light: typing.ClassVar[QAmbientLightReading.LightLevel] = ...
    Sunny: typing.ClassVar[QAmbientLightReading.LightLevel] = ...
    Twilight: typing.ClassVar[QAmbientLightReading.LightLevel] = ...
    Undefined: typing.ClassVar[QAmbientLightReading.LightLevel] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., timestamp: int = ...) -> None: ...
    def copyValuesFrom(self, other: QSensorReading) -> None: ...
    def lightLevel(self) -> QAmbientLightReading.LightLevel: ...
    def setLightLevel(self, lightLevel: QAmbientLightReading.LightLevel) -> None: ...

class QAmbientLightSensor(QSensor):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    type: typing.ClassVar[str] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., active: bool = ..., activeChanged: typing.Callable = ..., alwaysOn: bool = ..., alwaysOnChanged: typing.Callable = ..., availableDataRates: typing.Any = ..., availableSensorsChanged: typing.Callable = ..., axesOrientationMode: QAmbientLightSensor.AxesOrientationMode = ..., axesOrientationModeChanged: typing.Callable = ..., bufferSize: int = ..., bufferSizeChanged: typing.Callable = ..., busy: bool = ..., busyChanged: typing.Callable = ..., connectedToBackend: bool = ..., currentOrientation: int = ..., currentOrientationChanged: typing.Callable = ..., dataRate: int = ..., dataRateChanged: typing.Callable = ..., description: str = ..., destroyed: typing.Callable = ..., efficientBufferSize: int = ..., efficientBufferSizeChanged: typing.Callable = ..., error: int = ..., identifier: PySide2.QtCore.QByteArray | bytes = ..., maxBufferSize: int = ..., maxBufferSizeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., outputRange: int = ..., outputRanges: typing.Any = ..., reading: QAmbientLightReading = ..., readingChanged: typing.Callable = ..., sensorError: typing.Callable = ..., skipDuplicates: bool = ..., skipDuplicatesChanged: typing.Callable = ..., type: PySide2.QtCore.QByteArray | bytes = ..., userOrientation: int = ..., userOrientationChanged: typing.Callable = ...) -> None: ...
    def reading(self) -> QAmbientLightReading: ...

class QAmbientTemperatureFilter(QSensorFilter):
    def __init__(self) -> None: ...
    @typing.overload
    def filter(self, reading: QAmbientTemperatureReading) -> bool: ...
    @typing.overload
    def filter(self, reading: QSensorReading) -> bool: ...

class QAmbientTemperatureReading(QSensorReading):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., timestamp: int = ...) -> None: ...
    def copyValuesFrom(self, other: QSensorReading) -> None: ...
    def setTemperature(self, temperature: float) -> None: ...
    def temperature(self) -> float: ...

class QAmbientTemperatureSensor(QSensor):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    type: typing.ClassVar[str] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., active: bool = ..., activeChanged: typing.Callable = ..., alwaysOn: bool = ..., alwaysOnChanged: typing.Callable = ..., availableDataRates: typing.Any = ..., availableSensorsChanged: typing.Callable = ..., axesOrientationMode: QAmbientTemperatureSensor.AxesOrientationMode = ..., axesOrientationModeChanged: typing.Callable = ..., bufferSize: int = ..., bufferSizeChanged: typing.Callable = ..., busy: bool = ..., busyChanged: typing.Callable = ..., connectedToBackend: bool = ..., currentOrientation: int = ..., currentOrientationChanged: typing.Callable = ..., dataRate: int = ..., dataRateChanged: typing.Callable = ..., description: str = ..., destroyed: typing.Callable = ..., efficientBufferSize: int = ..., efficientBufferSizeChanged: typing.Callable = ..., error: int = ..., identifier: PySide2.QtCore.QByteArray | bytes = ..., maxBufferSize: int = ..., maxBufferSizeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., outputRange: int = ..., outputRanges: typing.Any = ..., reading: QAmbientTemperatureReading = ..., readingChanged: typing.Callable = ..., sensorError: typing.Callable = ..., skipDuplicates: bool = ..., skipDuplicatesChanged: typing.Callable = ..., type: PySide2.QtCore.QByteArray | bytes = ..., userOrientation: int = ..., userOrientationChanged: typing.Callable = ...) -> None: ...
    def reading(self) -> QAmbientTemperatureReading: ...

class QCompass(QSensor):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    type: typing.ClassVar[str] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., active: bool = ..., activeChanged: typing.Callable = ..., alwaysOn: bool = ..., alwaysOnChanged: typing.Callable = ..., availableDataRates: typing.Any = ..., availableSensorsChanged: typing.Callable = ..., axesOrientationMode: QCompass.AxesOrientationMode = ..., axesOrientationModeChanged: typing.Callable = ..., bufferSize: int = ..., bufferSizeChanged: typing.Callable = ..., busy: bool = ..., busyChanged: typing.Callable = ..., connectedToBackend: bool = ..., currentOrientation: int = ..., currentOrientationChanged: typing.Callable = ..., dataRate: int = ..., dataRateChanged: typing.Callable = ..., description: str = ..., destroyed: typing.Callable = ..., efficientBufferSize: int = ..., efficientBufferSizeChanged: typing.Callable = ..., error: int = ..., identifier: PySide2.QtCore.QByteArray | bytes = ..., maxBufferSize: int = ..., maxBufferSizeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., outputRange: int = ..., outputRanges: typing.Any = ..., reading: QCompassReading = ..., readingChanged: typing.Callable = ..., sensorError: typing.Callable = ..., skipDuplicates: bool = ..., skipDuplicatesChanged: typing.Callable = ..., type: PySide2.QtCore.QByteArray | bytes = ..., userOrientation: int = ..., userOrientationChanged: typing.Callable = ...) -> None: ...
    def reading(self) -> QCompassReading: ...

class QCompassFilter(QSensorFilter):
    def __init__(self) -> None: ...
    @typing.overload
    def filter(self, reading: QCompassReading) -> bool: ...
    @typing.overload
    def filter(self, reading: QSensorReading) -> bool: ...

class QCompassReading(QSensorReading):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., timestamp: int = ...) -> None: ...
    def azimuth(self) -> float: ...
    def calibrationLevel(self) -> float: ...
    def copyValuesFrom(self, other: QSensorReading) -> None: ...
    def setAzimuth(self, azimuth: float) -> None: ...
    def setCalibrationLevel(self, calibrationLevel: float) -> None: ...

class QDistanceFilter(QSensorFilter):
    def __init__(self) -> None: ...
    @typing.overload
    def filter(self, reading: QDistanceReading) -> bool: ...
    @typing.overload
    def filter(self, reading: QSensorReading) -> bool: ...

class QDistanceReading(QSensorReading):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., timestamp: int = ...) -> None: ...
    def copyValuesFrom(self, other: QSensorReading) -> None: ...
    def distance(self) -> float: ...
    def setDistance(self, distance: float) -> None: ...

class QDistanceSensor(QSensor):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    type: typing.ClassVar[str] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., active: bool = ..., activeChanged: typing.Callable = ..., alwaysOn: bool = ..., alwaysOnChanged: typing.Callable = ..., availableDataRates: typing.Any = ..., availableSensorsChanged: typing.Callable = ..., axesOrientationMode: QDistanceSensor.AxesOrientationMode = ..., axesOrientationModeChanged: typing.Callable = ..., bufferSize: int = ..., bufferSizeChanged: typing.Callable = ..., busy: bool = ..., busyChanged: typing.Callable = ..., connectedToBackend: bool = ..., currentOrientation: int = ..., currentOrientationChanged: typing.Callable = ..., dataRate: int = ..., dataRateChanged: typing.Callable = ..., description: str = ..., destroyed: typing.Callable = ..., efficientBufferSize: int = ..., efficientBufferSizeChanged: typing.Callable = ..., error: int = ..., identifier: PySide2.QtCore.QByteArray | bytes = ..., maxBufferSize: int = ..., maxBufferSizeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., outputRange: int = ..., outputRanges: typing.Any = ..., reading: QDistanceReading = ..., readingChanged: typing.Callable = ..., sensorError: typing.Callable = ..., skipDuplicates: bool = ..., skipDuplicatesChanged: typing.Callable = ..., type: PySide2.QtCore.QByteArray | bytes = ..., userOrientation: int = ..., userOrientationChanged: typing.Callable = ...) -> None: ...
    def reading(self) -> QDistanceReading: ...

class QGyroscope(QSensor):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    type: typing.ClassVar[str] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., active: bool = ..., activeChanged: typing.Callable = ..., alwaysOn: bool = ..., alwaysOnChanged: typing.Callable = ..., availableDataRates: typing.Any = ..., availableSensorsChanged: typing.Callable = ..., axesOrientationMode: QGyroscope.AxesOrientationMode = ..., axesOrientationModeChanged: typing.Callable = ..., bufferSize: int = ..., bufferSizeChanged: typing.Callable = ..., busy: bool = ..., busyChanged: typing.Callable = ..., connectedToBackend: bool = ..., currentOrientation: int = ..., currentOrientationChanged: typing.Callable = ..., dataRate: int = ..., dataRateChanged: typing.Callable = ..., description: str = ..., destroyed: typing.Callable = ..., efficientBufferSize: int = ..., efficientBufferSizeChanged: typing.Callable = ..., error: int = ..., identifier: PySide2.QtCore.QByteArray | bytes = ..., maxBufferSize: int = ..., maxBufferSizeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., outputRange: int = ..., outputRanges: typing.Any = ..., reading: QGyroscopeReading = ..., readingChanged: typing.Callable = ..., sensorError: typing.Callable = ..., skipDuplicates: bool = ..., skipDuplicatesChanged: typing.Callable = ..., type: PySide2.QtCore.QByteArray | bytes = ..., userOrientation: int = ..., userOrientationChanged: typing.Callable = ...) -> None: ...
    def reading(self) -> QGyroscopeReading: ...

class QGyroscopeFilter(QSensorFilter):
    def __init__(self) -> None: ...
    @typing.overload
    def filter(self, reading: QGyroscopeReading) -> bool: ...
    @typing.overload
    def filter(self, reading: QSensorReading) -> bool: ...

class QGyroscopeReading(QSensorReading):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., timestamp: int = ...) -> None: ...
    def copyValuesFrom(self, other: QSensorReading) -> None: ...
    def setX(self, x: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def setZ(self, z: float) -> None: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...

class QHolsterFilter(QSensorFilter):
    def __init__(self) -> None: ...
    @typing.overload
    def filter(self, reading: QHolsterReading) -> bool: ...
    @typing.overload
    def filter(self, reading: QSensorReading) -> bool: ...

class QHolsterReading(QSensorReading):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., timestamp: int = ...) -> None: ...
    def copyValuesFrom(self, other: QSensorReading) -> None: ...
    def holstered(self) -> bool: ...
    def setHolstered(self, holstered: bool) -> None: ...

class QHolsterSensor(QSensor):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    type: typing.ClassVar[str] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., active: bool = ..., activeChanged: typing.Callable = ..., alwaysOn: bool = ..., alwaysOnChanged: typing.Callable = ..., availableDataRates: typing.Any = ..., availableSensorsChanged: typing.Callable = ..., axesOrientationMode: QHolsterSensor.AxesOrientationMode = ..., axesOrientationModeChanged: typing.Callable = ..., bufferSize: int = ..., bufferSizeChanged: typing.Callable = ..., busy: bool = ..., busyChanged: typing.Callable = ..., connectedToBackend: bool = ..., currentOrientation: int = ..., currentOrientationChanged: typing.Callable = ..., dataRate: int = ..., dataRateChanged: typing.Callable = ..., description: str = ..., destroyed: typing.Callable = ..., efficientBufferSize: int = ..., efficientBufferSizeChanged: typing.Callable = ..., error: int = ..., identifier: PySide2.QtCore.QByteArray | bytes = ..., maxBufferSize: int = ..., maxBufferSizeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., outputRange: int = ..., outputRanges: typing.Any = ..., reading: QHolsterReading = ..., readingChanged: typing.Callable = ..., sensorError: typing.Callable = ..., skipDuplicates: bool = ..., skipDuplicatesChanged: typing.Callable = ..., type: PySide2.QtCore.QByteArray | bytes = ..., userOrientation: int = ..., userOrientationChanged: typing.Callable = ...) -> None: ...
    def reading(self) -> QHolsterReading: ...

class QHumidityFilter(QSensorFilter):
    def __init__(self) -> None: ...
    @typing.overload
    def filter(self, reading: QHumidityReading) -> bool: ...
    @typing.overload
    def filter(self, reading: QSensorReading) -> bool: ...

class QHumidityReading(QSensorReading):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., timestamp: int = ...) -> None: ...
    def absoluteHumidity(self) -> float: ...
    def copyValuesFrom(self, other: QSensorReading) -> None: ...
    def relativeHumidity(self) -> float: ...
    def setAbsoluteHumidity(self, value: float) -> None: ...
    def setRelativeHumidity(self, percent: float) -> None: ...

class QHumiditySensor(QSensor):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    type: typing.ClassVar[str] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., active: bool = ..., activeChanged: typing.Callable = ..., alwaysOn: bool = ..., alwaysOnChanged: typing.Callable = ..., availableDataRates: typing.Any = ..., availableSensorsChanged: typing.Callable = ..., axesOrientationMode: QHumiditySensor.AxesOrientationMode = ..., axesOrientationModeChanged: typing.Callable = ..., bufferSize: int = ..., bufferSizeChanged: typing.Callable = ..., busy: bool = ..., busyChanged: typing.Callable = ..., connectedToBackend: bool = ..., currentOrientation: int = ..., currentOrientationChanged: typing.Callable = ..., dataRate: int = ..., dataRateChanged: typing.Callable = ..., description: str = ..., destroyed: typing.Callable = ..., efficientBufferSize: int = ..., efficientBufferSizeChanged: typing.Callable = ..., error: int = ..., identifier: PySide2.QtCore.QByteArray | bytes = ..., maxBufferSize: int = ..., maxBufferSizeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., outputRange: int = ..., outputRanges: typing.Any = ..., reading: QHumidityReading = ..., readingChanged: typing.Callable = ..., sensorError: typing.Callable = ..., skipDuplicates: bool = ..., skipDuplicatesChanged: typing.Callable = ..., type: PySide2.QtCore.QByteArray | bytes = ..., userOrientation: int = ..., userOrientationChanged: typing.Callable = ...) -> None: ...
    def reading(self) -> QHumidityReading: ...

class QIRProximityFilter(QSensorFilter):
    def __init__(self) -> None: ...
    @typing.overload
    def filter(self, reading: QIRProximityReading) -> bool: ...
    @typing.overload
    def filter(self, reading: QSensorReading) -> bool: ...

class QIRProximityReading(QSensorReading):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., timestamp: int = ...) -> None: ...
    def copyValuesFrom(self, other: QSensorReading) -> None: ...
    def reflectance(self) -> float: ...
    def setReflectance(self, reflectance: float) -> None: ...

class QIRProximitySensor(QSensor):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    type: typing.ClassVar[str] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., active: bool = ..., activeChanged: typing.Callable = ..., alwaysOn: bool = ..., alwaysOnChanged: typing.Callable = ..., availableDataRates: typing.Any = ..., availableSensorsChanged: typing.Callable = ..., axesOrientationMode: QIRProximitySensor.AxesOrientationMode = ..., axesOrientationModeChanged: typing.Callable = ..., bufferSize: int = ..., bufferSizeChanged: typing.Callable = ..., busy: bool = ..., busyChanged: typing.Callable = ..., connectedToBackend: bool = ..., currentOrientation: int = ..., currentOrientationChanged: typing.Callable = ..., dataRate: int = ..., dataRateChanged: typing.Callable = ..., description: str = ..., destroyed: typing.Callable = ..., efficientBufferSize: int = ..., efficientBufferSizeChanged: typing.Callable = ..., error: int = ..., identifier: PySide2.QtCore.QByteArray | bytes = ..., maxBufferSize: int = ..., maxBufferSizeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., outputRange: int = ..., outputRanges: typing.Any = ..., reading: QIRProximityReading = ..., readingChanged: typing.Callable = ..., sensorError: typing.Callable = ..., skipDuplicates: bool = ..., skipDuplicatesChanged: typing.Callable = ..., type: PySide2.QtCore.QByteArray | bytes = ..., userOrientation: int = ..., userOrientationChanged: typing.Callable = ...) -> None: ...
    def reading(self) -> QIRProximityReading: ...

class QLidFilter(QSensorFilter):
    def __init__(self) -> None: ...
    @typing.overload
    def filter(self, reading: QLidReading) -> bool: ...
    @typing.overload
    def filter(self, reading: QSensorReading) -> bool: ...

class QLidReading(QSensorReading):
    backLidChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    frontLidChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., timestamp: int = ...) -> None: ...
    def backLidClosed(self) -> bool: ...
    def copyValuesFrom(self, other: QSensorReading) -> None: ...
    def frontLidClosed(self) -> bool: ...
    def setBackLidClosed(self, closed: bool) -> None: ...
    def setFrontLidClosed(self, closed: bool) -> None: ...

class QLidSensor(QSensor):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    type: typing.ClassVar[str] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., active: bool = ..., activeChanged: typing.Callable = ..., alwaysOn: bool = ..., alwaysOnChanged: typing.Callable = ..., availableDataRates: typing.Any = ..., availableSensorsChanged: typing.Callable = ..., axesOrientationMode: QLidSensor.AxesOrientationMode = ..., axesOrientationModeChanged: typing.Callable = ..., bufferSize: int = ..., bufferSizeChanged: typing.Callable = ..., busy: bool = ..., busyChanged: typing.Callable = ..., connectedToBackend: bool = ..., currentOrientation: int = ..., currentOrientationChanged: typing.Callable = ..., dataRate: int = ..., dataRateChanged: typing.Callable = ..., description: str = ..., destroyed: typing.Callable = ..., efficientBufferSize: int = ..., efficientBufferSizeChanged: typing.Callable = ..., error: int = ..., identifier: PySide2.QtCore.QByteArray | bytes = ..., maxBufferSize: int = ..., maxBufferSizeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., outputRange: int = ..., outputRanges: typing.Any = ..., reading: QLidReading = ..., readingChanged: typing.Callable = ..., sensorError: typing.Callable = ..., skipDuplicates: bool = ..., skipDuplicatesChanged: typing.Callable = ..., type: PySide2.QtCore.QByteArray | bytes = ..., userOrientation: int = ..., userOrientationChanged: typing.Callable = ...) -> None: ...
    def reading(self) -> QLidReading: ...

class QLightFilter(QSensorFilter):
    def __init__(self) -> None: ...
    @typing.overload
    def filter(self, reading: QLightReading) -> bool: ...
    @typing.overload
    def filter(self, reading: QSensorReading) -> bool: ...

class QLightReading(QSensorReading):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., timestamp: int = ...) -> None: ...
    def copyValuesFrom(self, other: QSensorReading) -> None: ...
    def lux(self) -> float: ...
    def setLux(self, lux: float) -> None: ...

class QLightSensor(QSensor):
    fieldOfViewChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    type: typing.ClassVar[str] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., active: bool = ..., activeChanged: typing.Callable = ..., alwaysOn: bool = ..., alwaysOnChanged: typing.Callable = ..., availableDataRates: typing.Any = ..., availableSensorsChanged: typing.Callable = ..., axesOrientationMode: QLightSensor.AxesOrientationMode = ..., axesOrientationModeChanged: typing.Callable = ..., bufferSize: int = ..., bufferSizeChanged: typing.Callable = ..., busy: bool = ..., busyChanged: typing.Callable = ..., connectedToBackend: bool = ..., currentOrientation: int = ..., currentOrientationChanged: typing.Callable = ..., dataRate: int = ..., dataRateChanged: typing.Callable = ..., description: str = ..., destroyed: typing.Callable = ..., efficientBufferSize: int = ..., efficientBufferSizeChanged: typing.Callable = ..., error: int = ..., fieldOfView: float = ..., fieldOfViewChanged: typing.Callable = ..., identifier: PySide2.QtCore.QByteArray | bytes = ..., maxBufferSize: int = ..., maxBufferSizeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., outputRange: int = ..., outputRanges: typing.Any = ..., reading: QLightReading = ..., readingChanged: typing.Callable = ..., sensorError: typing.Callable = ..., skipDuplicates: bool = ..., skipDuplicatesChanged: typing.Callable = ..., type: PySide2.QtCore.QByteArray | bytes = ..., userOrientation: int = ..., userOrientationChanged: typing.Callable = ...) -> None: ...
    def fieldOfView(self) -> float: ...
    def reading(self) -> QLightReading: ...
    def setFieldOfView(self, fieldOfView: float) -> None: ...

class QMagnetometer(QSensor):
    returnGeoValuesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    type: typing.ClassVar[str] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., active: bool = ..., activeChanged: typing.Callable = ..., alwaysOn: bool = ..., alwaysOnChanged: typing.Callable = ..., availableDataRates: typing.Any = ..., availableSensorsChanged: typing.Callable = ..., axesOrientationMode: QMagnetometer.AxesOrientationMode = ..., axesOrientationModeChanged: typing.Callable = ..., bufferSize: int = ..., bufferSizeChanged: typing.Callable = ..., busy: bool = ..., busyChanged: typing.Callable = ..., connectedToBackend: bool = ..., currentOrientation: int = ..., currentOrientationChanged: typing.Callable = ..., dataRate: int = ..., dataRateChanged: typing.Callable = ..., description: str = ..., destroyed: typing.Callable = ..., efficientBufferSize: int = ..., efficientBufferSizeChanged: typing.Callable = ..., error: int = ..., identifier: PySide2.QtCore.QByteArray | bytes = ..., maxBufferSize: int = ..., maxBufferSizeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., outputRange: int = ..., outputRanges: typing.Any = ..., reading: QMagnetometerReading = ..., readingChanged: typing.Callable = ..., returnGeoValues: bool = ..., returnGeoValuesChanged: typing.Callable = ..., sensorError: typing.Callable = ..., skipDuplicates: bool = ..., skipDuplicatesChanged: typing.Callable = ..., type: PySide2.QtCore.QByteArray | bytes = ..., userOrientation: int = ..., userOrientationChanged: typing.Callable = ...) -> None: ...
    def reading(self) -> QMagnetometerReading: ...
    def returnGeoValues(self) -> bool: ...
    def setReturnGeoValues(self, returnGeoValues: bool) -> None: ...

class QMagnetometerFilter(QSensorFilter):
    def __init__(self) -> None: ...
    @typing.overload
    def filter(self, reading: QMagnetometerReading) -> bool: ...
    @typing.overload
    def filter(self, reading: QSensorReading) -> bool: ...

class QMagnetometerReading(QSensorReading):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., timestamp: int = ...) -> None: ...
    def calibrationLevel(self) -> float: ...
    def copyValuesFrom(self, other: QSensorReading) -> None: ...
    def setCalibrationLevel(self, calibrationLevel: float) -> None: ...
    def setX(self, x: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def setZ(self, z: float) -> None: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...

class QOrientationFilter(QSensorFilter):
    def __init__(self) -> None: ...
    @typing.overload
    def filter(self, reading: QOrientationReading) -> bool: ...
    @typing.overload
    def filter(self, reading: QSensorReading) -> bool: ...

class QOrientationReading(QSensorReading):
    class Orientation:
        FaceDown: typing.ClassVar[QOrientationReading.Orientation] = ...
        FaceUp: typing.ClassVar[QOrientationReading.Orientation] = ...
        LeftUp: typing.ClassVar[QOrientationReading.Orientation] = ...
        RightUp: typing.ClassVar[QOrientationReading.Orientation] = ...
        TopDown: typing.ClassVar[QOrientationReading.Orientation] = ...
        TopUp: typing.ClassVar[QOrientationReading.Orientation] = ...
        Undefined: typing.ClassVar[QOrientationReading.Orientation] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOrientationReading.Orientation: ...
        def __and__(self, other: typing.SupportsInt) -> QOrientationReading.Orientation: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOrientationReading.Orientation: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOrientationReading.Orientation: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QOrientationReading.Orientation: ...
        def __rand__(self, other: typing.SupportsInt) -> QOrientationReading.Orientation: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOrientationReading.Orientation: ...
        def __ror__(self, other: typing.SupportsInt) -> QOrientationReading.Orientation: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOrientationReading.Orientation: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOrientationReading.Orientation: ...
        def __sub__(self, other: typing.SupportsInt) -> QOrientationReading.Orientation: ...
        def __xor__(self, other: typing.SupportsInt) -> QOrientationReading.Orientation: ...
    FaceDown: typing.ClassVar[QOrientationReading.Orientation] = ...
    FaceUp: typing.ClassVar[QOrientationReading.Orientation] = ...
    LeftUp: typing.ClassVar[QOrientationReading.Orientation] = ...
    RightUp: typing.ClassVar[QOrientationReading.Orientation] = ...
    TopDown: typing.ClassVar[QOrientationReading.Orientation] = ...
    TopUp: typing.ClassVar[QOrientationReading.Orientation] = ...
    Undefined: typing.ClassVar[QOrientationReading.Orientation] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., timestamp: int = ...) -> None: ...
    def copyValuesFrom(self, other: QSensorReading) -> None: ...
    def orientation(self) -> QOrientationReading.Orientation: ...
    def setOrientation(self, orientation: QOrientationReading.Orientation) -> None: ...

class QOrientationSensor(QSensor):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    type: typing.ClassVar[str] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., active: bool = ..., activeChanged: typing.Callable = ..., alwaysOn: bool = ..., alwaysOnChanged: typing.Callable = ..., availableDataRates: typing.Any = ..., availableSensorsChanged: typing.Callable = ..., axesOrientationMode: QOrientationSensor.AxesOrientationMode = ..., axesOrientationModeChanged: typing.Callable = ..., bufferSize: int = ..., bufferSizeChanged: typing.Callable = ..., busy: bool = ..., busyChanged: typing.Callable = ..., connectedToBackend: bool = ..., currentOrientation: int = ..., currentOrientationChanged: typing.Callable = ..., dataRate: int = ..., dataRateChanged: typing.Callable = ..., description: str = ..., destroyed: typing.Callable = ..., efficientBufferSize: int = ..., efficientBufferSizeChanged: typing.Callable = ..., error: int = ..., identifier: PySide2.QtCore.QByteArray | bytes = ..., maxBufferSize: int = ..., maxBufferSizeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., outputRange: int = ..., outputRanges: typing.Any = ..., reading: QOrientationReading = ..., readingChanged: typing.Callable = ..., sensorError: typing.Callable = ..., skipDuplicates: bool = ..., skipDuplicatesChanged: typing.Callable = ..., type: PySide2.QtCore.QByteArray | bytes = ..., userOrientation: int = ..., userOrientationChanged: typing.Callable = ...) -> None: ...
    def reading(self) -> QOrientationReading: ...

class QPressureFilter(QSensorFilter):
    def __init__(self) -> None: ...
    @typing.overload
    def filter(self, reading: QPressureReading) -> bool: ...
    @typing.overload
    def filter(self, reading: QSensorReading) -> bool: ...

class QPressureReading(QSensorReading):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., timestamp: int = ...) -> None: ...
    def copyValuesFrom(self, other: QSensorReading) -> None: ...
    def pressure(self) -> float: ...
    def setPressure(self, pressure: float) -> None: ...
    def setTemperature(self, temperature: float) -> None: ...
    def temperature(self) -> float: ...

class QPressureSensor(QSensor):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    type: typing.ClassVar[str] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., active: bool = ..., activeChanged: typing.Callable = ..., alwaysOn: bool = ..., alwaysOnChanged: typing.Callable = ..., availableDataRates: typing.Any = ..., availableSensorsChanged: typing.Callable = ..., axesOrientationMode: QPressureSensor.AxesOrientationMode = ..., axesOrientationModeChanged: typing.Callable = ..., bufferSize: int = ..., bufferSizeChanged: typing.Callable = ..., busy: bool = ..., busyChanged: typing.Callable = ..., connectedToBackend: bool = ..., currentOrientation: int = ..., currentOrientationChanged: typing.Callable = ..., dataRate: int = ..., dataRateChanged: typing.Callable = ..., description: str = ..., destroyed: typing.Callable = ..., efficientBufferSize: int = ..., efficientBufferSizeChanged: typing.Callable = ..., error: int = ..., identifier: PySide2.QtCore.QByteArray | bytes = ..., maxBufferSize: int = ..., maxBufferSizeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., outputRange: int = ..., outputRanges: typing.Any = ..., reading: QPressureReading = ..., readingChanged: typing.Callable = ..., sensorError: typing.Callable = ..., skipDuplicates: bool = ..., skipDuplicatesChanged: typing.Callable = ..., type: PySide2.QtCore.QByteArray | bytes = ..., userOrientation: int = ..., userOrientationChanged: typing.Callable = ...) -> None: ...
    def reading(self) -> QPressureReading: ...

class QProximityFilter(QSensorFilter):
    def __init__(self) -> None: ...
    @typing.overload
    def filter(self, reading: QProximityReading) -> bool: ...
    @typing.overload
    def filter(self, reading: QSensorReading) -> bool: ...

class QProximityReading(QSensorReading):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., timestamp: int = ...) -> None: ...
    def close(self) -> bool: ...
    def copyValuesFrom(self, other: QSensorReading) -> None: ...
    def setClose(self, close: bool) -> None: ...

class QProximitySensor(QSensor):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    type: typing.ClassVar[str] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., active: bool = ..., activeChanged: typing.Callable = ..., alwaysOn: bool = ..., alwaysOnChanged: typing.Callable = ..., availableDataRates: typing.Any = ..., availableSensorsChanged: typing.Callable = ..., axesOrientationMode: QProximitySensor.AxesOrientationMode = ..., axesOrientationModeChanged: typing.Callable = ..., bufferSize: int = ..., bufferSizeChanged: typing.Callable = ..., busy: bool = ..., busyChanged: typing.Callable = ..., connectedToBackend: bool = ..., currentOrientation: int = ..., currentOrientationChanged: typing.Callable = ..., dataRate: int = ..., dataRateChanged: typing.Callable = ..., description: str = ..., destroyed: typing.Callable = ..., efficientBufferSize: int = ..., efficientBufferSizeChanged: typing.Callable = ..., error: int = ..., identifier: PySide2.QtCore.QByteArray | bytes = ..., maxBufferSize: int = ..., maxBufferSizeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., outputRange: int = ..., outputRanges: typing.Any = ..., reading: QProximityReading = ..., readingChanged: typing.Callable = ..., sensorError: typing.Callable = ..., skipDuplicates: bool = ..., skipDuplicatesChanged: typing.Callable = ..., type: PySide2.QtCore.QByteArray | bytes = ..., userOrientation: int = ..., userOrientationChanged: typing.Callable = ...) -> None: ...
    def reading(self) -> QProximityReading: ...

class QRotationFilter(QSensorFilter):
    def __init__(self) -> None: ...
    @typing.overload
    def filter(self, reading: QRotationReading) -> bool: ...
    @typing.overload
    def filter(self, reading: QSensorReading) -> bool: ...

class QRotationReading(QSensorReading):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., timestamp: int = ...) -> None: ...
    def copyValuesFrom(self, other: QSensorReading) -> None: ...
    def setFromEuler(self, x: float, y: float, z: float) -> None: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...

class QRotationSensor(QSensor):
    hasZChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    type: typing.ClassVar[str] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., active: bool = ..., activeChanged: typing.Callable = ..., alwaysOn: bool = ..., alwaysOnChanged: typing.Callable = ..., availableDataRates: typing.Any = ..., availableSensorsChanged: typing.Callable = ..., axesOrientationMode: QRotationSensor.AxesOrientationMode = ..., axesOrientationModeChanged: typing.Callable = ..., bufferSize: int = ..., bufferSizeChanged: typing.Callable = ..., busy: bool = ..., busyChanged: typing.Callable = ..., connectedToBackend: bool = ..., currentOrientation: int = ..., currentOrientationChanged: typing.Callable = ..., dataRate: int = ..., dataRateChanged: typing.Callable = ..., description: str = ..., destroyed: typing.Callable = ..., efficientBufferSize: int = ..., efficientBufferSizeChanged: typing.Callable = ..., error: int = ..., hasZ: bool = ..., hasZChanged: typing.Callable = ..., identifier: PySide2.QtCore.QByteArray | bytes = ..., maxBufferSize: int = ..., maxBufferSizeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., outputRange: int = ..., outputRanges: typing.Any = ..., reading: QRotationReading = ..., readingChanged: typing.Callable = ..., sensorError: typing.Callable = ..., skipDuplicates: bool = ..., skipDuplicatesChanged: typing.Callable = ..., type: PySide2.QtCore.QByteArray | bytes = ..., userOrientation: int = ..., userOrientationChanged: typing.Callable = ...) -> None: ...
    def hasZ(self) -> bool: ...
    def reading(self) -> QRotationReading: ...
    def setHasZ(self, hasZ: bool) -> None: ...

class QSensor(PySide2.QtCore.QObject):
    class AxesOrientationMode:
        AutomaticOrientation: typing.ClassVar[QSensor.AxesOrientationMode] = ...
        FixedOrientation: typing.ClassVar[QSensor.AxesOrientationMode] = ...
        UserOrientation: typing.ClassVar[QSensor.AxesOrientationMode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSensor.AxesOrientationMode: ...
        def __and__(self, other: typing.SupportsInt) -> QSensor.AxesOrientationMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSensor.AxesOrientationMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSensor.AxesOrientationMode: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSensor.AxesOrientationMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QSensor.AxesOrientationMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSensor.AxesOrientationMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QSensor.AxesOrientationMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSensor.AxesOrientationMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSensor.AxesOrientationMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QSensor.AxesOrientationMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QSensor.AxesOrientationMode: ...

    class Feature:
        AccelerationMode: typing.ClassVar[QSensor.Feature] = ...
        AlwaysOn: typing.ClassVar[QSensor.Feature] = ...
        AxesOrientation: typing.ClassVar[QSensor.Feature] = ...
        Buffering: typing.ClassVar[QSensor.Feature] = ...
        FieldOfView: typing.ClassVar[QSensor.Feature] = ...
        GeoValues: typing.ClassVar[QSensor.Feature] = ...
        PressureSensorTemperature: typing.ClassVar[QSensor.Feature] = ...
        Reserved: typing.ClassVar[QSensor.Feature] = ...
        SkipDuplicates: typing.ClassVar[QSensor.Feature] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSensor.Feature: ...
        def __and__(self, other: typing.SupportsInt) -> QSensor.Feature: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSensor.Feature: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSensor.Feature: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSensor.Feature: ...
        def __rand__(self, other: typing.SupportsInt) -> QSensor.Feature: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSensor.Feature: ...
        def __ror__(self, other: typing.SupportsInt) -> QSensor.Feature: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSensor.Feature: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSensor.Feature: ...
        def __sub__(self, other: typing.SupportsInt) -> QSensor.Feature: ...
        def __xor__(self, other: typing.SupportsInt) -> QSensor.Feature: ...
    AccelerationMode: typing.ClassVar[QSensor.Feature] = ...
    AlwaysOn: typing.ClassVar[QSensor.Feature] = ...
    AutomaticOrientation: typing.ClassVar[QSensor.AxesOrientationMode] = ...
    AxesOrientation: typing.ClassVar[QSensor.Feature] = ...
    Buffering: typing.ClassVar[QSensor.Feature] = ...
    FieldOfView: typing.ClassVar[QSensor.Feature] = ...
    FixedOrientation: typing.ClassVar[QSensor.AxesOrientationMode] = ...
    GeoValues: typing.ClassVar[QSensor.Feature] = ...
    PressureSensorTemperature: typing.ClassVar[QSensor.Feature] = ...
    Reserved: typing.ClassVar[QSensor.Feature] = ...
    SkipDuplicates: typing.ClassVar[QSensor.Feature] = ...
    UserOrientation: typing.ClassVar[QSensor.AxesOrientationMode] = ...
    activeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    alwaysOnChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    availableSensorsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    axesOrientationModeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    bufferSizeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    busyChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    currentOrientationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    dataRateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    efficientBufferSizeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    maxBufferSizeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    readingChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sensorError: typing.ClassVar[PySide2.QtCore.Signal] = ...
    skipDuplicatesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    userOrientationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, type: PySide2.QtCore.QByteArray | bytes, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def addFilter(self, filter: QSensorFilter) -> None: ...
    def availableDataRates(self) -> typing.List[typing.Tuple[int, int]]: ...
    def axesOrientationMode(self) -> QSensor.AxesOrientationMode: ...
    def backend(self) -> QSensorBackend: ...
    def bufferSize(self) -> int: ...
    def connectToBackend(self) -> bool: ...
    def currentOrientation(self) -> int: ...
    def dataRate(self) -> int: ...
    @staticmethod
    def defaultSensorForType(type: PySide2.QtCore.QByteArray | bytes) -> PySide2.QtCore.QByteArray: ...
    def description(self) -> str: ...
    def efficientBufferSize(self) -> int: ...
    def error(self) -> int: ...
    def filters(self) -> typing.List[QSensorFilter]: ...
    def identifier(self) -> PySide2.QtCore.QByteArray: ...
    def isActive(self) -> bool: ...
    def isAlwaysOn(self) -> bool: ...
    def isBusy(self) -> bool: ...
    def isConnectedToBackend(self) -> bool: ...
    def isFeatureSupported(self, feature: QSensor.Feature) -> bool: ...
    def maxBufferSize(self) -> int: ...
    def outputRange(self) -> int: ...
    def outputRanges(self) -> typing.List[qoutputrange]: ...
    def reading(self) -> QSensorReading: ...
    def removeFilter(self, filter: QSensorFilter) -> None: ...
    @staticmethod
    def sensorTypes() -> typing.List[PySide2.QtCore.QByteArray]: ...
    @staticmethod
    def sensorsForType(type: PySide2.QtCore.QByteArray | bytes) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def setActive(self, active: bool) -> None: ...
    def setAlwaysOn(self, alwaysOn: bool) -> None: ...
    def setAxesOrientationMode(self, axesOrientationMode: QSensor.AxesOrientationMode) -> None: ...
    def setBufferSize(self, bufferSize: int) -> None: ...
    def setCurrentOrientation(self, currentOrientation: int) -> None: ...
    def setDataRate(self, rate: int) -> None: ...
    def setEfficientBufferSize(self, efficientBufferSize: int) -> None: ...
    def setIdentifier(self, identifier: PySide2.QtCore.QByteArray | bytes) -> None: ...
    def setMaxBufferSize(self, maxBufferSize: int) -> None: ...
    def setOutputRange(self, index: int) -> None: ...
    def setSkipDuplicates(self, skipDuplicates: bool) -> None: ...
    def setUserOrientation(self, userOrientation: int) -> None: ...
    def skipDuplicates(self) -> bool: ...
    def start(self) -> bool: ...
    def stop(self) -> None: ...
    def type(self) -> PySide2.QtCore.QByteArray: ...
    def userOrientation(self) -> int: ...

class QSensorBackend(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, sensor: QSensor, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def addDataRate(self, min: float, max: float) -> None: ...
    def addOutputRange(self, min: float, max: float, accuracy: float) -> None: ...
    def isFeatureSupported(self, feature: QSensor.Feature) -> bool: ...
    def newReadingAvailable(self) -> None: ...
    def reading(self) -> QSensorReading: ...
    def sensor(self) -> QSensor: ...
    def sensorBusy(self) -> None: ...
    def sensorError(self, error: int) -> None: ...
    def sensorStopped(self) -> None: ...
    def setDataRates(self, otherSensor: QSensor) -> None: ...
    def setDescription(self, description: str) -> None: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...

class QSensorBackendFactory(shiboken2.Object):
    def __init__(self) -> None: ...
    def createBackend(self, sensor: QSensor) -> QSensorBackend: ...

class QSensorChangesInterface(shiboken2.Object):
    def __init__(self) -> None: ...
    def sensorsChanged(self) -> None: ...

class QSensorFilter(shiboken2.Object):
    m_sensor: _typeshed.Incomplete
    def __init__(self) -> None: ...
    def filter(self, reading: QSensorReading) -> bool: ...
    def setSensor(self, sensor: QSensor) -> None: ...

class QSensorGestureManager(PySide2.QtCore.QObject):
    newSensorGestureAvailable: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., newSensorGestureAvailable: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def gestureIds(self) -> typing.List[str]: ...
    def recognizerSignals(self, recognizerId: str) -> typing.List[str]: ...
    def registerSensorGestureRecognizer(self, recognizer: QSensorGestureRecognizer) -> bool: ...
    @staticmethod
    def sensorGestureRecognizer(id: str) -> QSensorGestureRecognizer: ...

class QSensorGesturePluginInterface(shiboken2.Object):
    def __init__(self) -> None: ...
    def createRecognizers(self) -> typing.List[QSensorGestureRecognizer]: ...
    def name(self) -> str: ...
    def supportedIds(self) -> typing.List[str]: ...

class QSensorGestureRecognizer(PySide2.QtCore.QObject):
    detected: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def create(self) -> None: ...
    def createBackend(self) -> None: ...
    def gestureSignals(self) -> typing.List[str]: ...
    def id(self) -> str: ...
    def isActive(self) -> bool: ...
    def start(self) -> bool: ...
    def startBackend(self) -> None: ...
    def stop(self) -> bool: ...
    def stopBackend(self) -> None: ...

class QSensorManager(shiboken2.Object):
    def __init__(self) -> None: ...
    @staticmethod
    def createBackend(sensor: QSensor) -> QSensorBackend: ...
    @staticmethod
    def isBackendRegistered(type: PySide2.QtCore.QByteArray | bytes, identifier: PySide2.QtCore.QByteArray | bytes) -> bool: ...
    @staticmethod
    def registerBackend(type: PySide2.QtCore.QByteArray | bytes, identifier: PySide2.QtCore.QByteArray | bytes, factory: QSensorBackendFactory) -> None: ...
    @staticmethod
    def setDefaultBackend(type: PySide2.QtCore.QByteArray | bytes, identifier: PySide2.QtCore.QByteArray | bytes) -> None: ...
    @staticmethod
    def unregisterBackend(type: PySide2.QtCore.QByteArray | bytes, identifier: PySide2.QtCore.QByteArray | bytes) -> None: ...

class QSensorPluginInterface(shiboken2.Object):
    def __init__(self) -> None: ...
    def registerSensors(self) -> None: ...

class QSensorReading(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., timestamp: int = ..., **kwargs) -> None: ...
    def copyValuesFrom(self, other: QSensorReading) -> None: ...
    def setTimestamp(self, timestamp: int) -> None: ...
    def timestamp(self) -> int: ...
    def value(self, index: int) -> typing.Any: ...
    def valueCount(self) -> int: ...

class QTapFilter(QSensorFilter):
    def __init__(self) -> None: ...
    @typing.overload
    def filter(self, reading: QSensorReading) -> bool: ...
    @typing.overload
    def filter(self, reading: QTapReading) -> bool: ...

class QTapReading(QSensorReading):
    class TapDirection:
        Undefined: typing.ClassVar[QTapReading.TapDirection] = ...
        X: typing.ClassVar[QTapReading.TapDirection] = ...
        X_Both: typing.ClassVar[QTapReading.TapDirection] = ...
        X_Neg: typing.ClassVar[QTapReading.TapDirection] = ...
        X_Pos: typing.ClassVar[QTapReading.TapDirection] = ...
        Y: typing.ClassVar[QTapReading.TapDirection] = ...
        Y_Both: typing.ClassVar[QTapReading.TapDirection] = ...
        Y_Neg: typing.ClassVar[QTapReading.TapDirection] = ...
        Y_Pos: typing.ClassVar[QTapReading.TapDirection] = ...
        Z: typing.ClassVar[QTapReading.TapDirection] = ...
        Z_Both: typing.ClassVar[QTapReading.TapDirection] = ...
        Z_Neg: typing.ClassVar[QTapReading.TapDirection] = ...
        Z_Pos: typing.ClassVar[QTapReading.TapDirection] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTapReading.TapDirection: ...
        def __and__(self, other: typing.SupportsInt) -> QTapReading.TapDirection: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTapReading.TapDirection: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTapReading.TapDirection: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QTapReading.TapDirection: ...
        def __rand__(self, other: typing.SupportsInt) -> QTapReading.TapDirection: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTapReading.TapDirection: ...
        def __ror__(self, other: typing.SupportsInt) -> QTapReading.TapDirection: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTapReading.TapDirection: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTapReading.TapDirection: ...
        def __sub__(self, other: typing.SupportsInt) -> QTapReading.TapDirection: ...
        def __xor__(self, other: typing.SupportsInt) -> QTapReading.TapDirection: ...
    Undefined: typing.ClassVar[QTapReading.TapDirection] = ...
    X: typing.ClassVar[QTapReading.TapDirection] = ...
    X_Both: typing.ClassVar[QTapReading.TapDirection] = ...
    X_Neg: typing.ClassVar[QTapReading.TapDirection] = ...
    X_Pos: typing.ClassVar[QTapReading.TapDirection] = ...
    Y: typing.ClassVar[QTapReading.TapDirection] = ...
    Y_Both: typing.ClassVar[QTapReading.TapDirection] = ...
    Y_Neg: typing.ClassVar[QTapReading.TapDirection] = ...
    Y_Pos: typing.ClassVar[QTapReading.TapDirection] = ...
    Z: typing.ClassVar[QTapReading.TapDirection] = ...
    Z_Both: typing.ClassVar[QTapReading.TapDirection] = ...
    Z_Neg: typing.ClassVar[QTapReading.TapDirection] = ...
    Z_Pos: typing.ClassVar[QTapReading.TapDirection] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., timestamp: int = ...) -> None: ...
    def copyValuesFrom(self, other: QSensorReading) -> None: ...
    def isDoubleTap(self) -> bool: ...
    def setDoubleTap(self, doubleTap: bool) -> None: ...
    def setTapDirection(self, tapDirection: QTapReading.TapDirection) -> None: ...
    def tapDirection(self) -> QTapReading.TapDirection: ...

class QTapSensor(QSensor):
    returnDoubleTapEventsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    type: typing.ClassVar[str] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., active: bool = ..., activeChanged: typing.Callable = ..., alwaysOn: bool = ..., alwaysOnChanged: typing.Callable = ..., availableDataRates: typing.Any = ..., availableSensorsChanged: typing.Callable = ..., axesOrientationMode: QTapSensor.AxesOrientationMode = ..., axesOrientationModeChanged: typing.Callable = ..., bufferSize: int = ..., bufferSizeChanged: typing.Callable = ..., busy: bool = ..., busyChanged: typing.Callable = ..., connectedToBackend: bool = ..., currentOrientation: int = ..., currentOrientationChanged: typing.Callable = ..., dataRate: int = ..., dataRateChanged: typing.Callable = ..., description: str = ..., destroyed: typing.Callable = ..., efficientBufferSize: int = ..., efficientBufferSizeChanged: typing.Callable = ..., error: int = ..., identifier: PySide2.QtCore.QByteArray | bytes = ..., maxBufferSize: int = ..., maxBufferSizeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., outputRange: int = ..., outputRanges: typing.Any = ..., reading: QTapReading = ..., readingChanged: typing.Callable = ..., returnDoubleTapEvents: bool = ..., returnDoubleTapEventsChanged: typing.Callable = ..., sensorError: typing.Callable = ..., skipDuplicates: bool = ..., skipDuplicatesChanged: typing.Callable = ..., type: PySide2.QtCore.QByteArray | bytes = ..., userOrientation: int = ..., userOrientationChanged: typing.Callable = ...) -> None: ...
    def reading(self) -> QTapReading: ...
    def returnDoubleTapEvents(self) -> bool: ...
    def setReturnDoubleTapEvents(self, returnDoubleTapEvents: bool) -> None: ...

class QTiltFilter(QSensorFilter):
    def __init__(self) -> None: ...
    @typing.overload
    def filter(self, reading: QSensorReading) -> bool: ...
    @typing.overload
    def filter(self, reading: QTiltReading) -> bool: ...

class QTiltReading(QSensorReading):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., timestamp: int = ...) -> None: ...
    def copyValuesFrom(self, other: QSensorReading) -> None: ...
    def setXRotation(self, x: float) -> None: ...
    def setYRotation(self, y: float) -> None: ...
    def xRotation(self) -> float: ...
    def yRotation(self) -> float: ...

class QTiltSensor(QSensor):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    type: typing.ClassVar[str] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., active: bool = ..., activeChanged: typing.Callable = ..., alwaysOn: bool = ..., alwaysOnChanged: typing.Callable = ..., availableDataRates: typing.Any = ..., availableSensorsChanged: typing.Callable = ..., axesOrientationMode: QTiltSensor.AxesOrientationMode = ..., axesOrientationModeChanged: typing.Callable = ..., bufferSize: int = ..., bufferSizeChanged: typing.Callable = ..., busy: bool = ..., busyChanged: typing.Callable = ..., connectedToBackend: bool = ..., currentOrientation: int = ..., currentOrientationChanged: typing.Callable = ..., dataRate: int = ..., dataRateChanged: typing.Callable = ..., description: str = ..., destroyed: typing.Callable = ..., efficientBufferSize: int = ..., efficientBufferSizeChanged: typing.Callable = ..., error: int = ..., identifier: PySide2.QtCore.QByteArray | bytes = ..., maxBufferSize: int = ..., maxBufferSizeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., outputRange: int = ..., outputRanges: typing.Any = ..., reading: QTiltReading = ..., readingChanged: typing.Callable = ..., sensorError: typing.Callable = ..., skipDuplicates: bool = ..., skipDuplicatesChanged: typing.Callable = ..., type: PySide2.QtCore.QByteArray | bytes = ..., userOrientation: int = ..., userOrientationChanged: typing.Callable = ...) -> None: ...
    def calibrate(self) -> None: ...
    def reading(self) -> QTiltReading: ...

class qoutputrange(shiboken2.Object):
    accuracy: _typeshed.Incomplete
    maximum: _typeshed.Incomplete
    minimum: _typeshed.Incomplete
    @typing.overload
    def __init__(self, qoutputrange: qoutputrange) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def __copy__(self) -> None: ...
