import PySide2.QtCore
import PySide2.QtWidgets
import _typeshed
import collections
import shiboken2
import typing
T = typing.TypeVar('T')
import typing_extensions

class QSql(shiboken2.Object):
    class Location:
        AfterLastRow: typing.ClassVar[QSql.Location] = ...
        BeforeFirstRow: typing.ClassVar[QSql.Location] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSql.Location: ...
        def __and__(self, other: typing.SupportsInt) -> QSql.Location: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSql.Location: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSql.Location: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSql.Location: ...
        def __rand__(self, other: typing.SupportsInt) -> QSql.Location: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSql.Location: ...
        def __ror__(self, other: typing.SupportsInt) -> QSql.Location: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSql.Location: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSql.Location: ...
        def __sub__(self, other: typing.SupportsInt) -> QSql.Location: ...
        def __xor__(self, other: typing.SupportsInt) -> QSql.Location: ...

    class NumericalPrecisionPolicy:
        HighPrecision: typing.ClassVar[QSql.NumericalPrecisionPolicy] = ...
        LowPrecisionDouble: typing.ClassVar[QSql.NumericalPrecisionPolicy] = ...
        LowPrecisionInt32: typing.ClassVar[QSql.NumericalPrecisionPolicy] = ...
        LowPrecisionInt64: typing.ClassVar[QSql.NumericalPrecisionPolicy] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSql.NumericalPrecisionPolicy: ...
        def __and__(self, other: typing.SupportsInt) -> QSql.NumericalPrecisionPolicy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSql.NumericalPrecisionPolicy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSql.NumericalPrecisionPolicy: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSql.NumericalPrecisionPolicy: ...
        def __rand__(self, other: typing.SupportsInt) -> QSql.NumericalPrecisionPolicy: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSql.NumericalPrecisionPolicy: ...
        def __ror__(self, other: typing.SupportsInt) -> QSql.NumericalPrecisionPolicy: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSql.NumericalPrecisionPolicy: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSql.NumericalPrecisionPolicy: ...
        def __sub__(self, other: typing.SupportsInt) -> QSql.NumericalPrecisionPolicy: ...
        def __xor__(self, other: typing.SupportsInt) -> QSql.NumericalPrecisionPolicy: ...

    class ParamType:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QSql.ParamType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QSql.ParamType: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSql.ParamType: ...
        def __rand__(self, other: typing.SupportsInt) -> QSql.ParamType: ...
        def __ror__(self, other: typing.SupportsInt) -> QSql.ParamType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSql.ParamType: ...
        def __xor__(self, other: typing.SupportsInt) -> QSql.ParamType: ...

    class ParamTypeFlag:
        Binary: typing.ClassVar[QSql.ParamTypeFlag] = ...
        In: typing.ClassVar[QSql.ParamTypeFlag] = ...
        InOut: typing.ClassVar[QSql.ParamTypeFlag] = ...
        Out: typing.ClassVar[QSql.ParamTypeFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QSql.ParamType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QSql.ParamType: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSql.ParamType: ...
        def __rand__(self, other: typing.SupportsInt) -> QSql.ParamType: ...
        def __ror__(self, other: typing.SupportsInt) -> QSql.ParamType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSql.ParamType: ...
        def __xor__(self, other: typing.SupportsInt) -> QSql.ParamType: ...

    class TableType:
        AllTables: typing.ClassVar[QSql.TableType] = ...
        SystemTables: typing.ClassVar[QSql.TableType] = ...
        Tables: typing.ClassVar[QSql.TableType] = ...
        Views: typing.ClassVar[QSql.TableType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSql.TableType: ...
        def __and__(self, other: typing.SupportsInt) -> QSql.TableType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSql.TableType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSql.TableType: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSql.TableType: ...
        def __rand__(self, other: typing.SupportsInt) -> QSql.TableType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSql.TableType: ...
        def __ror__(self, other: typing.SupportsInt) -> QSql.TableType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSql.TableType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSql.TableType: ...
        def __sub__(self, other: typing.SupportsInt) -> QSql.TableType: ...
        def __xor__(self, other: typing.SupportsInt) -> QSql.TableType: ...
    AfterLastRow: typing.ClassVar[QSql.Location] = ...
    AllTables: typing.ClassVar[QSql.TableType] = ...
    BeforeFirstRow: typing.ClassVar[QSql.Location] = ...
    Binary: typing.ClassVar[QSql.ParamTypeFlag] = ...
    HighPrecision: typing.ClassVar[QSql.NumericalPrecisionPolicy] = ...
    In: typing.ClassVar[QSql.ParamTypeFlag] = ...
    InOut: typing.ClassVar[QSql.ParamTypeFlag] = ...
    LowPrecisionDouble: typing.ClassVar[QSql.NumericalPrecisionPolicy] = ...
    LowPrecisionInt32: typing.ClassVar[QSql.NumericalPrecisionPolicy] = ...
    LowPrecisionInt64: typing.ClassVar[QSql.NumericalPrecisionPolicy] = ...
    Out: typing.ClassVar[QSql.ParamTypeFlag] = ...
    SystemTables: typing.ClassVar[QSql.TableType] = ...
    Tables: typing.ClassVar[QSql.TableType] = ...
    Views: typing.ClassVar[QSql.TableType] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...

class QSqlDatabase(shiboken2.Object):
    defaultConnection: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self, type: str) -> None: ...
    @typing.overload
    def __init__(self, other: QSqlDatabase) -> None: ...
    @typing.overload
    def __init__(self, driver: QSqlDriver) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    @staticmethod
    def addDatabase(type: str, connectionName: str = ...) -> QSqlDatabase: ...
    @typing.overload
    @staticmethod
    def addDatabase(driver: QSqlDriver, connectionName: str = ...) -> QSqlDatabase: ...
    @typing.overload
    @staticmethod
    def cloneDatabase(other: QSqlDatabase, connectionName: str) -> QSqlDatabase: ...
    @typing.overload
    @staticmethod
    def cloneDatabase(other: str, connectionName: str) -> QSqlDatabase: ...
    def close(self) -> None: ...
    def commit(self) -> bool: ...
    def connectOptions(self) -> str: ...
    def connectionName(self) -> str: ...
    @staticmethod
    def connectionNames() -> typing.List[str]: ...
    @staticmethod
    def contains(connectionName: str = ...) -> bool: ...
    @staticmethod
    def database(connectionName: str = ..., open: bool = ...) -> QSqlDatabase: ...
    def databaseName(self) -> str: ...
    def driver(self) -> QSqlDriver: ...
    def driverName(self) -> str: ...
    @staticmethod
    def drivers() -> typing.List[str]: ...
    def exec_(self, query: str = ...) -> QSqlQuery: ...
    def hostName(self) -> str: ...
    @staticmethod
    def isDriverAvailable(name: str) -> bool: ...
    def isOpen(self) -> bool: ...
    def isOpenError(self) -> bool: ...
    def isValid(self) -> bool: ...
    def lastError(self) -> QSqlError: ...
    def numericalPrecisionPolicy(self) -> QSql.NumericalPrecisionPolicy: ...
    @typing.overload
    def open(self, user: str, password: str) -> bool: ...
    @typing.overload
    def open(self) -> bool: ...
    def password(self) -> str: ...
    def port(self) -> int: ...
    def primaryIndex(self, tablename: str) -> QSqlIndex: ...
    def record(self, tablename: str) -> QSqlRecord: ...
    @staticmethod
    def registerSqlDriver(name: str, creator: QSqlDriverCreatorBase) -> None: ...
    @staticmethod
    def removeDatabase(connectionName: str) -> None: ...
    def rollback(self) -> bool: ...
    def setConnectOptions(self, options: str = ...) -> None: ...
    def setDatabaseName(self, name: str) -> None: ...
    def setHostName(self, host: str) -> None: ...
    def setNumericalPrecisionPolicy(self, precisionPolicy: QSql.NumericalPrecisionPolicy) -> None: ...
    def setPassword(self, password: str) -> None: ...
    def setPort(self, p: int) -> None: ...
    def setUserName(self, name: str) -> None: ...
    def tables(self, type: QSql.TableType = ...) -> typing.List[str]: ...
    def transaction(self) -> bool: ...
    def userName(self) -> str: ...
    def __copy__(self) -> None: ...

class QSqlDriver(PySide2.QtCore.QObject):
    class DbmsType:
        DB2: typing.ClassVar[QSqlDriver.DbmsType] = ...
        Interbase: typing.ClassVar[QSqlDriver.DbmsType] = ...
        MSSqlServer: typing.ClassVar[QSqlDriver.DbmsType] = ...
        MySqlServer: typing.ClassVar[QSqlDriver.DbmsType] = ...
        Oracle: typing.ClassVar[QSqlDriver.DbmsType] = ...
        PostgreSQL: typing.ClassVar[QSqlDriver.DbmsType] = ...
        SQLite: typing.ClassVar[QSqlDriver.DbmsType] = ...
        Sybase: typing.ClassVar[QSqlDriver.DbmsType] = ...
        UnknownDbms: typing.ClassVar[QSqlDriver.DbmsType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSqlDriver.DbmsType: ...
        def __and__(self, other: typing.SupportsInt) -> QSqlDriver.DbmsType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSqlDriver.DbmsType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSqlDriver.DbmsType: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSqlDriver.DbmsType: ...
        def __rand__(self, other: typing.SupportsInt) -> QSqlDriver.DbmsType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSqlDriver.DbmsType: ...
        def __ror__(self, other: typing.SupportsInt) -> QSqlDriver.DbmsType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSqlDriver.DbmsType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSqlDriver.DbmsType: ...
        def __sub__(self, other: typing.SupportsInt) -> QSqlDriver.DbmsType: ...
        def __xor__(self, other: typing.SupportsInt) -> QSqlDriver.DbmsType: ...

    class DriverFeature:
        BLOB: typing.ClassVar[QSqlDriver.DriverFeature] = ...
        BatchOperations: typing.ClassVar[QSqlDriver.DriverFeature] = ...
        CancelQuery: typing.ClassVar[QSqlDriver.DriverFeature] = ...
        EventNotifications: typing.ClassVar[QSqlDriver.DriverFeature] = ...
        FinishQuery: typing.ClassVar[QSqlDriver.DriverFeature] = ...
        LastInsertId: typing.ClassVar[QSqlDriver.DriverFeature] = ...
        LowPrecisionNumbers: typing.ClassVar[QSqlDriver.DriverFeature] = ...
        MultipleResultSets: typing.ClassVar[QSqlDriver.DriverFeature] = ...
        NamedPlaceholders: typing.ClassVar[QSqlDriver.DriverFeature] = ...
        PositionalPlaceholders: typing.ClassVar[QSqlDriver.DriverFeature] = ...
        PreparedQueries: typing.ClassVar[QSqlDriver.DriverFeature] = ...
        QuerySize: typing.ClassVar[QSqlDriver.DriverFeature] = ...
        SimpleLocking: typing.ClassVar[QSqlDriver.DriverFeature] = ...
        Transactions: typing.ClassVar[QSqlDriver.DriverFeature] = ...
        Unicode: typing.ClassVar[QSqlDriver.DriverFeature] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSqlDriver.DriverFeature: ...
        def __and__(self, other: typing.SupportsInt) -> QSqlDriver.DriverFeature: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSqlDriver.DriverFeature: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSqlDriver.DriverFeature: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSqlDriver.DriverFeature: ...
        def __rand__(self, other: typing.SupportsInt) -> QSqlDriver.DriverFeature: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSqlDriver.DriverFeature: ...
        def __ror__(self, other: typing.SupportsInt) -> QSqlDriver.DriverFeature: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSqlDriver.DriverFeature: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSqlDriver.DriverFeature: ...
        def __sub__(self, other: typing.SupportsInt) -> QSqlDriver.DriverFeature: ...
        def __xor__(self, other: typing.SupportsInt) -> QSqlDriver.DriverFeature: ...

    class IdentifierType:
        FieldName: typing.ClassVar[QSqlDriver.IdentifierType] = ...
        TableName: typing.ClassVar[QSqlDriver.IdentifierType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSqlDriver.IdentifierType: ...
        def __and__(self, other: typing.SupportsInt) -> QSqlDriver.IdentifierType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSqlDriver.IdentifierType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSqlDriver.IdentifierType: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSqlDriver.IdentifierType: ...
        def __rand__(self, other: typing.SupportsInt) -> QSqlDriver.IdentifierType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSqlDriver.IdentifierType: ...
        def __ror__(self, other: typing.SupportsInt) -> QSqlDriver.IdentifierType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSqlDriver.IdentifierType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSqlDriver.IdentifierType: ...
        def __sub__(self, other: typing.SupportsInt) -> QSqlDriver.IdentifierType: ...
        def __xor__(self, other: typing.SupportsInt) -> QSqlDriver.IdentifierType: ...

    class NotificationSource:
        OtherSource: typing.ClassVar[QSqlDriver.NotificationSource] = ...
        SelfSource: typing.ClassVar[QSqlDriver.NotificationSource] = ...
        UnknownSource: typing.ClassVar[QSqlDriver.NotificationSource] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSqlDriver.NotificationSource: ...
        def __and__(self, other: typing.SupportsInt) -> QSqlDriver.NotificationSource: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSqlDriver.NotificationSource: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSqlDriver.NotificationSource: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSqlDriver.NotificationSource: ...
        def __rand__(self, other: typing.SupportsInt) -> QSqlDriver.NotificationSource: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSqlDriver.NotificationSource: ...
        def __ror__(self, other: typing.SupportsInt) -> QSqlDriver.NotificationSource: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSqlDriver.NotificationSource: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSqlDriver.NotificationSource: ...
        def __sub__(self, other: typing.SupportsInt) -> QSqlDriver.NotificationSource: ...
        def __xor__(self, other: typing.SupportsInt) -> QSqlDriver.NotificationSource: ...

    class StatementType:
        DeleteStatement: typing.ClassVar[QSqlDriver.StatementType] = ...
        InsertStatement: typing.ClassVar[QSqlDriver.StatementType] = ...
        SelectStatement: typing.ClassVar[QSqlDriver.StatementType] = ...
        UpdateStatement: typing.ClassVar[QSqlDriver.StatementType] = ...
        WhereStatement: typing.ClassVar[QSqlDriver.StatementType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSqlDriver.StatementType: ...
        def __and__(self, other: typing.SupportsInt) -> QSqlDriver.StatementType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSqlDriver.StatementType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSqlDriver.StatementType: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSqlDriver.StatementType: ...
        def __rand__(self, other: typing.SupportsInt) -> QSqlDriver.StatementType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSqlDriver.StatementType: ...
        def __ror__(self, other: typing.SupportsInt) -> QSqlDriver.StatementType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSqlDriver.StatementType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSqlDriver.StatementType: ...
        def __sub__(self, other: typing.SupportsInt) -> QSqlDriver.StatementType: ...
        def __xor__(self, other: typing.SupportsInt) -> QSqlDriver.StatementType: ...
    BLOB: typing.ClassVar[QSqlDriver.DriverFeature] = ...
    BatchOperations: typing.ClassVar[QSqlDriver.DriverFeature] = ...
    CancelQuery: typing.ClassVar[QSqlDriver.DriverFeature] = ...
    DB2: typing.ClassVar[QSqlDriver.DbmsType] = ...
    DeleteStatement: typing.ClassVar[QSqlDriver.StatementType] = ...
    EventNotifications: typing.ClassVar[QSqlDriver.DriverFeature] = ...
    FieldName: typing.ClassVar[QSqlDriver.IdentifierType] = ...
    FinishQuery: typing.ClassVar[QSqlDriver.DriverFeature] = ...
    InsertStatement: typing.ClassVar[QSqlDriver.StatementType] = ...
    Interbase: typing.ClassVar[QSqlDriver.DbmsType] = ...
    LastInsertId: typing.ClassVar[QSqlDriver.DriverFeature] = ...
    LowPrecisionNumbers: typing.ClassVar[QSqlDriver.DriverFeature] = ...
    MSSqlServer: typing.ClassVar[QSqlDriver.DbmsType] = ...
    MultipleResultSets: typing.ClassVar[QSqlDriver.DriverFeature] = ...
    MySqlServer: typing.ClassVar[QSqlDriver.DbmsType] = ...
    NamedPlaceholders: typing.ClassVar[QSqlDriver.DriverFeature] = ...
    Oracle: typing.ClassVar[QSqlDriver.DbmsType] = ...
    OtherSource: typing.ClassVar[QSqlDriver.NotificationSource] = ...
    PositionalPlaceholders: typing.ClassVar[QSqlDriver.DriverFeature] = ...
    PostgreSQL: typing.ClassVar[QSqlDriver.DbmsType] = ...
    PreparedQueries: typing.ClassVar[QSqlDriver.DriverFeature] = ...
    QuerySize: typing.ClassVar[QSqlDriver.DriverFeature] = ...
    SQLite: typing.ClassVar[QSqlDriver.DbmsType] = ...
    SelectStatement: typing.ClassVar[QSqlDriver.StatementType] = ...
    SelfSource: typing.ClassVar[QSqlDriver.NotificationSource] = ...
    SimpleLocking: typing.ClassVar[QSqlDriver.DriverFeature] = ...
    Sybase: typing.ClassVar[QSqlDriver.DbmsType] = ...
    TableName: typing.ClassVar[QSqlDriver.IdentifierType] = ...
    Transactions: typing.ClassVar[QSqlDriver.DriverFeature] = ...
    Unicode: typing.ClassVar[QSqlDriver.DriverFeature] = ...
    UnknownDbms: typing.ClassVar[QSqlDriver.DbmsType] = ...
    UnknownSource: typing.ClassVar[QSqlDriver.NotificationSource] = ...
    UpdateStatement: typing.ClassVar[QSqlDriver.StatementType] = ...
    WhereStatement: typing.ClassVar[QSqlDriver.StatementType] = ...
    notification: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def beginTransaction(self) -> bool: ...
    def cancelQuery(self) -> bool: ...
    def close(self) -> None: ...
    def commitTransaction(self) -> bool: ...
    def createResult(self) -> QSqlResult: ...
    def dbmsType(self) -> QSqlDriver.DbmsType: ...
    def escapeIdentifier(self, identifier: str, type: QSqlDriver.IdentifierType) -> str: ...
    def formatValue(self, field: QSqlField, trimStrings: bool = ...) -> str: ...
    def hasFeature(self, f: QSqlDriver.DriverFeature) -> bool: ...
    def isIdentifierEscaped(self, identifier: str, type: QSqlDriver.IdentifierType) -> bool: ...
    def isOpen(self) -> bool: ...
    def isOpenError(self) -> bool: ...
    def lastError(self) -> QSqlError: ...
    def numericalPrecisionPolicy(self) -> QSql.NumericalPrecisionPolicy: ...
    def open(self, db: str, user: str = ..., password: str = ..., host: str = ..., port: int = ..., connOpts: str = ...) -> bool: ...
    def primaryIndex(self, tableName: str) -> QSqlIndex: ...
    def record(self, tableName: str) -> QSqlRecord: ...
    def rollbackTransaction(self) -> bool: ...
    def setLastError(self, e: QSqlError) -> None: ...
    def setNumericalPrecisionPolicy(self, precisionPolicy: QSql.NumericalPrecisionPolicy) -> None: ...
    def setOpen(self, o: bool) -> None: ...
    def setOpenError(self, e: bool) -> None: ...
    def sqlStatement(self, type: QSqlDriver.StatementType, tableName: str, rec: QSqlRecord, preparedStatement: bool) -> str: ...
    def stripDelimiters(self, identifier: str, type: QSqlDriver.IdentifierType) -> str: ...
    def subscribeToNotification(self, name: str) -> bool: ...
    def subscribedToNotifications(self) -> typing.List[str]: ...
    def tables(self, tableType: QSql.TableType) -> typing.List[str]: ...
    def unsubscribeFromNotification(self, name: str) -> bool: ...

class QSqlDriverCreatorBase(shiboken2.Object):
    def __init__(self) -> None: ...
    def createObject(self) -> QSqlDriver: ...

class QSqlError(shiboken2.Object):
    class ErrorType:
        ConnectionError: typing.ClassVar[QSqlError.ErrorType] = ...
        NoError: typing.ClassVar[QSqlError.ErrorType] = ...
        StatementError: typing.ClassVar[QSqlError.ErrorType] = ...
        TransactionError: typing.ClassVar[QSqlError.ErrorType] = ...
        UnknownError: typing.ClassVar[QSqlError.ErrorType] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSqlError.ErrorType: ...
        def __and__(self, other: typing.SupportsInt) -> QSqlError.ErrorType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSqlError.ErrorType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSqlError.ErrorType: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSqlError.ErrorType: ...
        def __rand__(self, other: typing.SupportsInt) -> QSqlError.ErrorType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSqlError.ErrorType: ...
        def __ror__(self, other: typing.SupportsInt) -> QSqlError.ErrorType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSqlError.ErrorType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSqlError.ErrorType: ...
        def __sub__(self, other: typing.SupportsInt) -> QSqlError.ErrorType: ...
        def __xor__(self, other: typing.SupportsInt) -> QSqlError.ErrorType: ...
    ConnectionError: typing.ClassVar[QSqlError.ErrorType] = ...
    NoError: typing.ClassVar[QSqlError.ErrorType] = ...
    StatementError: typing.ClassVar[QSqlError.ErrorType] = ...
    TransactionError: typing.ClassVar[QSqlError.ErrorType] = ...
    UnknownError: typing.ClassVar[QSqlError.ErrorType] = ...
    @typing.overload
    def __init__(self, driverText: str, databaseText: str, type: QSqlError.ErrorType, number: int) -> None: ...
    @typing.overload
    def __init__(self, driverText: str = ..., databaseText: str = ..., type: QSqlError.ErrorType = ..., errorCode: str = ...) -> None: ...
    @typing.overload
    def __init__(self, other: QSqlError) -> None: ...
    def databaseText(self) -> str: ...
    def driverText(self) -> str: ...
    def isValid(self) -> bool: ...
    def nativeErrorCode(self) -> str: ...
    def number(self) -> int: ...
    def setDatabaseText(self, databaseText: str) -> None: ...
    def setDriverText(self, driverText: str) -> None: ...
    def setNumber(self, number: int) -> None: ...
    def setType(self, type: QSqlError.ErrorType) -> None: ...
    def swap(self, other: QSqlError) -> None: ...
    def text(self) -> str: ...
    def type(self) -> QSqlError.ErrorType: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QSqlField(shiboken2.Object):
    class RequiredStatus:
        Optional: typing.ClassVar[QSqlField.RequiredStatus] = ...
        Required: typing.ClassVar[QSqlField.RequiredStatus] = ...
        Unknown: typing.ClassVar[QSqlField.RequiredStatus] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSqlField.RequiredStatus: ...
        def __and__(self, other: typing.SupportsInt) -> QSqlField.RequiredStatus: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSqlField.RequiredStatus: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSqlField.RequiredStatus: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSqlField.RequiredStatus: ...
        def __rand__(self, other: typing.SupportsInt) -> QSqlField.RequiredStatus: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSqlField.RequiredStatus: ...
        def __ror__(self, other: typing.SupportsInt) -> QSqlField.RequiredStatus: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSqlField.RequiredStatus: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSqlField.RequiredStatus: ...
        def __sub__(self, other: typing.SupportsInt) -> QSqlField.RequiredStatus: ...
        def __xor__(self, other: typing.SupportsInt) -> QSqlField.RequiredStatus: ...
    Optional: typing.ClassVar[QSqlField.RequiredStatus] = ...
    Required: typing.ClassVar[QSqlField.RequiredStatus] = ...
    Unknown: typing.ClassVar[QSqlField.RequiredStatus] = ...
    @typing.overload
    def __init__(self, fieldName: str, type: type, tableName: str) -> None: ...
    @typing.overload
    def __init__(self, fieldName: str = ..., type: type = ...) -> None: ...
    @typing.overload
    def __init__(self, other: QSqlField) -> None: ...
    def clear(self) -> None: ...
    def defaultValue(self) -> typing.Any: ...
    def isAutoValue(self) -> bool: ...
    def isGenerated(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def isValid(self) -> bool: ...
    def length(self) -> int: ...
    def name(self) -> str: ...
    def precision(self) -> int: ...
    def requiredStatus(self) -> QSqlField.RequiredStatus: ...
    def setAutoValue(self, autoVal: bool) -> None: ...
    def setDefaultValue(self, value: typing.Any) -> None: ...
    def setGenerated(self, gen: bool) -> None: ...
    def setLength(self, fieldLength: int) -> None: ...
    def setName(self, name: str) -> None: ...
    def setPrecision(self, precision: int) -> None: ...
    def setReadOnly(self, readOnly: bool) -> None: ...
    def setRequired(self, required: bool) -> None: ...
    def setRequiredStatus(self, status: QSqlField.RequiredStatus) -> None: ...
    def setSqlType(self, type: int) -> None: ...
    def setTableName(self, tableName: str) -> None: ...
    def setType(self, type: type) -> None: ...
    def setValue(self, value: typing.Any) -> None: ...
    def tableName(self) -> str: ...
    def type(self) -> type: ...
    def typeID(self) -> int: ...
    def value(self) -> typing.Any: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QSqlIndex(QSqlRecord):
    @typing.overload
    def __init__(self, cursorName: str = ..., name: str = ...) -> None: ...
    @typing.overload
    def __init__(self, other: QSqlIndex) -> None: ...
    @typing.overload
    def append(self, field: QSqlField, desc: bool) -> None: ...
    @typing.overload
    def append(self, field: QSqlField) -> None: ...
    def cursorName(self) -> str: ...
    def isDescending(self, i: int) -> bool: ...
    def name(self) -> str: ...
    def setCursorName(self, cursorName: str) -> None: ...
    def setDescending(self, i: int, desc: bool) -> None: ...
    def setName(self, name: str) -> None: ...
    def __copy__(self) -> None: ...

class QSqlQuery(shiboken2.Object):
    class BatchExecutionMode:
        ValuesAsColumns: typing.ClassVar[QSqlQuery.BatchExecutionMode] = ...
        ValuesAsRows: typing.ClassVar[QSqlQuery.BatchExecutionMode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSqlQuery.BatchExecutionMode: ...
        def __and__(self, other: typing.SupportsInt) -> QSqlQuery.BatchExecutionMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSqlQuery.BatchExecutionMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSqlQuery.BatchExecutionMode: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSqlQuery.BatchExecutionMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QSqlQuery.BatchExecutionMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSqlQuery.BatchExecutionMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QSqlQuery.BatchExecutionMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSqlQuery.BatchExecutionMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSqlQuery.BatchExecutionMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QSqlQuery.BatchExecutionMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QSqlQuery.BatchExecutionMode: ...
    ValuesAsColumns: typing.ClassVar[QSqlQuery.BatchExecutionMode] = ...
    ValuesAsRows: typing.ClassVar[QSqlQuery.BatchExecutionMode] = ...
    @typing.overload
    def __init__(self, query: str = ..., db: QSqlDatabase = ...) -> None: ...
    @typing.overload
    def __init__(self, r: QSqlResult) -> None: ...
    @typing.overload
    def __init__(self, other: QSqlQuery) -> None: ...
    @typing.overload
    def __init__(self, db: QSqlDatabase) -> None: ...
    def addBindValue(self, val: typing.Any, type: QSql.ParamType | QSql.ParamTypeFlag = ...) -> None: ...
    def at(self) -> int: ...
    @typing.overload
    def bindValue(self, pos: int, val: typing.Any, type: QSql.ParamType | QSql.ParamTypeFlag = ...) -> None: ...
    @typing.overload
    def bindValue(self, placeholder: str, val: typing.Any, type: QSql.ParamType | QSql.ParamTypeFlag = ...) -> None: ...
    @typing.overload
    def boundValue(self, pos: int) -> typing.Any: ...
    @typing.overload
    def boundValue(self, placeholder: str) -> typing.Any: ...
    def boundValues(self) -> typing.Dict[str, typing.Any]: ...
    def clear(self) -> None: ...
    def driver(self) -> QSqlDriver: ...
    def execBatch(self, mode: QSqlQuery.BatchExecutionMode = ...) -> bool: ...
    @typing.overload
    def exec_(self, query: str) -> bool: ...
    @typing.overload
    def exec_(self) -> bool: ...
    def executedQuery(self) -> str: ...
    def finish(self) -> None: ...
    def first(self) -> bool: ...
    def isActive(self) -> bool: ...
    def isForwardOnly(self) -> bool: ...
    @typing.overload
    def isNull(self, name: str) -> bool: ...
    @typing.overload
    def isNull(self, field: int) -> bool: ...
    def isSelect(self) -> bool: ...
    def isValid(self) -> bool: ...
    def last(self) -> bool: ...
    def lastError(self) -> QSqlError: ...
    def lastInsertId(self) -> typing.Any: ...
    def lastQuery(self) -> str: ...
    def next(self) -> bool: ...
    def nextResult(self) -> bool: ...
    def numRowsAffected(self) -> int: ...
    def numericalPrecisionPolicy(self) -> QSql.NumericalPrecisionPolicy: ...
    def prepare(self, query: str) -> bool: ...
    def previous(self) -> bool: ...
    def record(self) -> QSqlRecord: ...
    def result(self) -> QSqlResult: ...
    def seek(self, i: int, relative: bool = ...) -> bool: ...
    def setForwardOnly(self, forward: bool) -> None: ...
    def setNumericalPrecisionPolicy(self, precisionPolicy: QSql.NumericalPrecisionPolicy) -> None: ...
    def size(self) -> int: ...
    @typing.overload
    def value(self, name: str) -> typing.Any: ...
    @typing.overload
    def value(self, i: int) -> typing.Any: ...
    def __copy__(self) -> None: ...

class QSqlQueryModel(PySide2.QtCore.QAbstractTableModel):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., columnsAboutToBeInserted: typing.Callable = ..., columnsAboutToBeMoved: typing.Callable = ..., columnsAboutToBeRemoved: typing.Callable = ..., columnsInserted: typing.Callable = ..., columnsMoved: typing.Callable = ..., columnsRemoved: typing.Callable = ..., dataChanged: typing.Callable = ..., destroyed: typing.Callable = ..., headerDataChanged: typing.Callable = ..., layoutAboutToBeChanged: typing.Callable = ..., layoutChanged: typing.Callable = ..., modelAboutToBeReset: typing.Callable = ..., modelReset: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowsAboutToBeInserted: typing.Callable = ..., rowsAboutToBeMoved: typing.Callable = ..., rowsAboutToBeRemoved: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsMoved: typing.Callable = ..., rowsRemoved: typing.Callable = ...) -> None: ...
    def beginInsertColumns(self, parent: PySide2.QtCore.QModelIndex, first: int, last: int) -> None: ...
    def beginInsertRows(self, parent: PySide2.QtCore.QModelIndex, first: int, last: int) -> None: ...
    def beginRemoveColumns(self, parent: PySide2.QtCore.QModelIndex, first: int, last: int) -> None: ...
    def beginRemoveRows(self, parent: PySide2.QtCore.QModelIndex, first: int, last: int) -> None: ...
    def beginResetModel(self) -> None: ...
    def canFetchMore(self, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def clear(self) -> None: ...
    def columnCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def data(self, item: PySide2.QtCore.QModelIndex, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> typing.Any: ...
    def endInsertColumns(self) -> None: ...
    def endInsertRows(self) -> None: ...
    def endRemoveColumns(self) -> None: ...
    def endRemoveRows(self) -> None: ...
    def endResetModel(self) -> None: ...
    def fetchMore(self, parent: PySide2.QtCore.QModelIndex = ...) -> None: ...
    def headerData(self, section: int, orientation: PySide2.QtCore.Qt.Orientation, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> typing.Any: ...
    def indexInQuery(self, item: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def insertColumns(self, column: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def lastError(self) -> QSqlError: ...
    def query(self) -> QSqlQuery: ...
    def queryChange(self) -> None: ...
    @typing.overload
    def record(self, row: int) -> QSqlRecord: ...
    @typing.overload
    def record(self) -> QSqlRecord: ...
    def removeColumns(self, column: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def roleNames(self) -> typing.Dict[int, PySide2.QtCore.QByteArray]: ...
    def rowCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def setHeaderData(self, section: int, orientation: PySide2.QtCore.Qt.Orientation, value: typing.Any, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> bool: ...
    def setLastError(self, error: QSqlError) -> None: ...
    @typing.overload
    def setQuery(self, query: str, db: QSqlDatabase = ...) -> None: ...
    @typing.overload
    def setQuery(self, query: QSqlQuery) -> None: ...

class QSqlRecord(shiboken2.Object):
    @typing.overload
    def __init__(self, other: QSqlRecord) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def append(self, field: QSqlField) -> None: ...
    def clear(self) -> None: ...
    def clearValues(self) -> None: ...
    def contains(self, name: str) -> bool: ...
    def count(self) -> int: ...
    @typing.overload
    def field(self, name: str) -> QSqlField: ...
    @typing.overload
    def field(self, i: int) -> QSqlField: ...
    def fieldName(self, i: int) -> str: ...
    def indexOf(self, name: str) -> int: ...
    def insert(self, pos: int, field: QSqlField) -> None: ...
    def isEmpty(self) -> bool: ...
    @typing.overload
    def isGenerated(self, name: str) -> bool: ...
    @typing.overload
    def isGenerated(self, i: int) -> bool: ...
    @typing.overload
    def isNull(self, name: str) -> bool: ...
    @typing.overload
    def isNull(self, i: int) -> bool: ...
    def keyValues(self, keyFields: QSqlRecord) -> QSqlRecord: ...
    def remove(self, pos: int) -> None: ...
    def replace(self, pos: int, field: QSqlField) -> None: ...
    @typing.overload
    def setGenerated(self, name: str, generated: bool) -> None: ...
    @typing.overload
    def setGenerated(self, i: int, generated: bool) -> None: ...
    @typing.overload
    def setNull(self, name: str) -> None: ...
    @typing.overload
    def setNull(self, i: int) -> None: ...
    @typing.overload
    def setValue(self, name: str, val: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, i: int, val: typing.Any) -> None: ...
    @typing.overload
    def value(self, name: str) -> typing.Any: ...
    @typing.overload
    def value(self, i: int) -> typing.Any: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QSqlRelation(shiboken2.Object):
    @typing.overload
    def __init__(self, aTableName: str, indexCol: str, displayCol: str) -> None: ...
    @typing.overload
    def __init__(self, QSqlRelation: QSqlRelation) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    def displayColumn(self) -> str: ...
    def indexColumn(self) -> str: ...
    def isValid(self) -> bool: ...
    def swap(self, other: QSqlRelation) -> None: ...
    def tableName(self) -> str: ...
    def __copy__(self) -> None: ...

class QSqlRelationalDelegate(PySide2.QtWidgets.QItemDelegate):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, aParent: PySide2.QtCore.QObject | None = ..., clipping: bool = ..., closeEditor: typing.Callable = ..., commitData: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., sizeHintChanged: typing.Callable = ...) -> None: ...
    def createEditor(self, aParent: PySide2.QtWidgets.QWidget, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QWidget: ...
    def setEditorData(self, editor: PySide2.QtWidgets.QWidget, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setModelData(self, editor: PySide2.QtWidgets.QWidget, model: PySide2.QtCore.QAbstractItemModel, index: PySide2.QtCore.QModelIndex) -> None: ...

class QSqlRelationalTableModel(QSqlTableModel):
    class JoinMode:
        InnerJoin: typing.ClassVar[QSqlRelationalTableModel.JoinMode] = ...
        LeftJoin: typing.ClassVar[QSqlRelationalTableModel.JoinMode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSqlRelationalTableModel.JoinMode: ...
        def __and__(self, other: typing.SupportsInt) -> QSqlRelationalTableModel.JoinMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSqlRelationalTableModel.JoinMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSqlRelationalTableModel.JoinMode: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSqlRelationalTableModel.JoinMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QSqlRelationalTableModel.JoinMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSqlRelationalTableModel.JoinMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QSqlRelationalTableModel.JoinMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSqlRelationalTableModel.JoinMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSqlRelationalTableModel.JoinMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QSqlRelationalTableModel.JoinMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QSqlRelationalTableModel.JoinMode: ...
    InnerJoin: typing.ClassVar[QSqlRelationalTableModel.JoinMode] = ...
    LeftJoin: typing.ClassVar[QSqlRelationalTableModel.JoinMode] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., db: QSqlDatabase = ..., beforeDelete: typing.Callable = ..., beforeInsert: typing.Callable = ..., beforeUpdate: typing.Callable = ..., columnsAboutToBeInserted: typing.Callable = ..., columnsAboutToBeMoved: typing.Callable = ..., columnsAboutToBeRemoved: typing.Callable = ..., columnsInserted: typing.Callable = ..., columnsMoved: typing.Callable = ..., columnsRemoved: typing.Callable = ..., dataChanged: typing.Callable = ..., destroyed: typing.Callable = ..., headerDataChanged: typing.Callable = ..., layoutAboutToBeChanged: typing.Callable = ..., layoutChanged: typing.Callable = ..., modelAboutToBeReset: typing.Callable = ..., modelReset: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., primeInsert: typing.Callable = ..., rowsAboutToBeInserted: typing.Callable = ..., rowsAboutToBeMoved: typing.Callable = ..., rowsAboutToBeRemoved: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsMoved: typing.Callable = ..., rowsRemoved: typing.Callable = ...) -> None: ...
    def clear(self) -> None: ...
    def data(self, item: PySide2.QtCore.QModelIndex, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> typing.Any: ...
    def insertRowIntoTable(self, values: QSqlRecord) -> bool: ...
    def orderByClause(self) -> str: ...
    def relation(self, column: int) -> QSqlRelation: ...
    def relationModel(self, column: int) -> QSqlTableModel: ...
    def removeColumns(self, column: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def revertRow(self, row: int) -> None: ...
    def select(self) -> bool: ...
    def selectStatement(self) -> str: ...
    def setData(self, item: PySide2.QtCore.QModelIndex, value: typing.Any, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> bool: ...
    def setJoinMode(self, joinMode: QSqlRelationalTableModel.JoinMode) -> None: ...
    def setRelation(self, column: int, relation: QSqlRelation) -> None: ...
    def setTable(self, tableName: str) -> None: ...
    def updateRowInTable(self, row: int, values: QSqlRecord) -> bool: ...

class QSqlResult(shiboken2.Object):
    class BindingSyntax:
        NamedBinding: typing.ClassVar[QSqlResult.BindingSyntax] = ...
        PositionalBinding: typing.ClassVar[QSqlResult.BindingSyntax] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSqlResult.BindingSyntax: ...
        def __and__(self, other: typing.SupportsInt) -> QSqlResult.BindingSyntax: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSqlResult.BindingSyntax: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSqlResult.BindingSyntax: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSqlResult.BindingSyntax: ...
        def __rand__(self, other: typing.SupportsInt) -> QSqlResult.BindingSyntax: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSqlResult.BindingSyntax: ...
        def __ror__(self, other: typing.SupportsInt) -> QSqlResult.BindingSyntax: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSqlResult.BindingSyntax: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSqlResult.BindingSyntax: ...
        def __sub__(self, other: typing.SupportsInt) -> QSqlResult.BindingSyntax: ...
        def __xor__(self, other: typing.SupportsInt) -> QSqlResult.BindingSyntax: ...
    NamedBinding: typing.ClassVar[QSqlResult.BindingSyntax] = ...
    PositionalBinding: typing.ClassVar[QSqlResult.BindingSyntax] = ...
    def __init__(self, db: QSqlDriver) -> None: ...
    def addBindValue(self, val: typing.Any, type: QSql.ParamType | QSql.ParamTypeFlag) -> None: ...
    def at(self) -> int: ...
    @typing.overload
    def bindValue(self, pos: int, val: typing.Any, type: QSql.ParamType | QSql.ParamTypeFlag) -> None: ...
    @typing.overload
    def bindValue(self, placeholder: str, val: typing.Any, type: QSql.ParamType | QSql.ParamTypeFlag) -> None: ...
    @typing.overload
    def bindValueType(self, pos: int) -> QSql.ParamType | QSql.ParamTypeFlag: ...
    @typing.overload
    def bindValueType(self, placeholder: str) -> QSql.ParamType | QSql.ParamTypeFlag: ...
    def bindingSyntax(self) -> QSqlResult.BindingSyntax: ...
    @typing.overload
    def boundValue(self, pos: int) -> typing.Any: ...
    @typing.overload
    def boundValue(self, placeholder: str) -> typing.Any: ...
    def boundValueCount(self) -> int: ...
    def boundValueName(self, pos: int) -> str: ...
    def boundValues(self) -> typing.List[typing.Any]: ...
    def clear(self) -> None: ...
    def data(self, i: int) -> typing.Any: ...
    def detachFromResultSet(self) -> None: ...
    def driver(self) -> QSqlDriver: ...
    def execBatch(self, arrayBind: bool = ...) -> bool: ...
    def exec_(self) -> bool: ...
    def executedQuery(self) -> str: ...
    def fetch(self, i: int) -> bool: ...
    def fetchFirst(self) -> bool: ...
    def fetchLast(self) -> bool: ...
    def fetchNext(self) -> bool: ...
    def fetchPrevious(self) -> bool: ...
    def handle(self) -> typing.Any: ...
    def hasOutValues(self) -> bool: ...
    def isActive(self) -> bool: ...
    def isForwardOnly(self) -> bool: ...
    def isNull(self, i: int) -> bool: ...
    def isSelect(self) -> bool: ...
    def isValid(self) -> bool: ...
    def lastError(self) -> QSqlError: ...
    def lastInsertId(self) -> typing.Any: ...
    def lastQuery(self) -> str: ...
    def nextResult(self) -> bool: ...
    def numRowsAffected(self) -> int: ...
    def numericalPrecisionPolicy(self) -> QSql.NumericalPrecisionPolicy: ...
    def prepare(self, query: str) -> bool: ...
    def record(self) -> QSqlRecord: ...
    def reset(self, sqlquery: str) -> bool: ...
    def resetBindCount(self) -> None: ...
    def savePrepare(self, sqlquery: str) -> bool: ...
    def setActive(self, a: bool) -> None: ...
    def setAt(self, at: int) -> None: ...
    def setForwardOnly(self, forward: bool) -> None: ...
    def setLastError(self, e: QSqlError) -> None: ...
    def setNumericalPrecisionPolicy(self, policy: QSql.NumericalPrecisionPolicy) -> None: ...
    def setQuery(self, query: str) -> None: ...
    def setSelect(self, s: bool) -> None: ...
    def size(self) -> int: ...

class QSqlTableModel(QSqlQueryModel):
    class EditStrategy:
        OnFieldChange: typing.ClassVar[QSqlTableModel.EditStrategy] = ...
        OnManualSubmit: typing.ClassVar[QSqlTableModel.EditStrategy] = ...
        OnRowChange: typing.ClassVar[QSqlTableModel.EditStrategy] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSqlTableModel.EditStrategy: ...
        def __and__(self, other: typing.SupportsInt) -> QSqlTableModel.EditStrategy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSqlTableModel.EditStrategy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSqlTableModel.EditStrategy: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QSqlTableModel.EditStrategy: ...
        def __rand__(self, other: typing.SupportsInt) -> QSqlTableModel.EditStrategy: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSqlTableModel.EditStrategy: ...
        def __ror__(self, other: typing.SupportsInt) -> QSqlTableModel.EditStrategy: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSqlTableModel.EditStrategy: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSqlTableModel.EditStrategy: ...
        def __sub__(self, other: typing.SupportsInt) -> QSqlTableModel.EditStrategy: ...
        def __xor__(self, other: typing.SupportsInt) -> QSqlTableModel.EditStrategy: ...
    OnFieldChange: typing.ClassVar[QSqlTableModel.EditStrategy] = ...
    OnManualSubmit: typing.ClassVar[QSqlTableModel.EditStrategy] = ...
    OnRowChange: typing.ClassVar[QSqlTableModel.EditStrategy] = ...
    beforeDelete: typing.ClassVar[PySide2.QtCore.Signal] = ...
    beforeInsert: typing.ClassVar[PySide2.QtCore.Signal] = ...
    beforeUpdate: typing.ClassVar[PySide2.QtCore.Signal] = ...
    primeInsert: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: PySide2.QtCore.QObject | None = ..., db: QSqlDatabase = ..., beforeDelete: typing.Callable = ..., beforeInsert: typing.Callable = ..., beforeUpdate: typing.Callable = ..., columnsAboutToBeInserted: typing.Callable = ..., columnsAboutToBeMoved: typing.Callable = ..., columnsAboutToBeRemoved: typing.Callable = ..., columnsInserted: typing.Callable = ..., columnsMoved: typing.Callable = ..., columnsRemoved: typing.Callable = ..., dataChanged: typing.Callable = ..., destroyed: typing.Callable = ..., headerDataChanged: typing.Callable = ..., layoutAboutToBeChanged: typing.Callable = ..., layoutChanged: typing.Callable = ..., modelAboutToBeReset: typing.Callable = ..., modelReset: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., primeInsert: typing.Callable = ..., rowsAboutToBeInserted: typing.Callable = ..., rowsAboutToBeMoved: typing.Callable = ..., rowsAboutToBeRemoved: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsMoved: typing.Callable = ..., rowsRemoved: typing.Callable = ...) -> None: ...
    def clear(self) -> None: ...
    def data(self, idx: PySide2.QtCore.QModelIndex, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> typing.Any: ...
    def database(self) -> QSqlDatabase: ...
    def deleteRowFromTable(self, row: int) -> bool: ...
    def editStrategy(self) -> QSqlTableModel.EditStrategy: ...
    def fieldIndex(self, fieldName: str) -> int: ...
    def filter(self) -> str: ...
    def flags(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.Qt.ItemFlags | PySide2.QtCore.Qt.ItemFlag: ...
    def headerData(self, section: int, orientation: PySide2.QtCore.Qt.Orientation, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> typing.Any: ...
    def indexInQuery(self, item: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def insertRecord(self, row: int, record: QSqlRecord) -> bool: ...
    def insertRowIntoTable(self, values: QSqlRecord) -> bool: ...
    def insertRows(self, row: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    @typing.overload
    def isDirty(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    @typing.overload
    def isDirty(self) -> bool: ...
    def orderByClause(self) -> str: ...
    def primaryKey(self) -> QSqlIndex: ...
    def primaryValues(self, row: int) -> QSqlRecord: ...
    @typing.overload
    def record(self, row: int) -> QSqlRecord: ...
    @typing.overload
    def record(self) -> QSqlRecord: ...
    def removeColumns(self, column: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def removeRows(self, row: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def revert(self) -> None: ...
    def revertAll(self) -> None: ...
    def revertRow(self, row: int) -> None: ...
    def rowCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def select(self) -> bool: ...
    def selectRow(self, row: int) -> bool: ...
    def selectStatement(self) -> str: ...
    def setData(self, index: PySide2.QtCore.QModelIndex, value: typing.Any, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> bool: ...
    def setEditStrategy(self, strategy: QSqlTableModel.EditStrategy) -> None: ...
    def setFilter(self, filter: str) -> None: ...
    def setPrimaryKey(self, key: QSqlIndex) -> None: ...
    def setQuery(self, query: QSqlQuery) -> None: ...
    def setRecord(self, row: int, record: QSqlRecord) -> bool: ...
    def setSort(self, column: int, order: PySide2.QtCore.Qt.SortOrder) -> None: ...
    def setTable(self, tableName: str) -> None: ...
    def sort(self, column: int, order: PySide2.QtCore.Qt.SortOrder) -> None: ...
    def submit(self) -> bool: ...
    def submitAll(self) -> bool: ...
    def tableName(self) -> str: ...
    def updateRowInTable(self, row: int, values: QSqlRecord) -> bool: ...
