import PySide2.QtCore
import PySide2.QtGui
import PySide2.QtWidgets
import _typeshed
import collections
import shiboken2
import typing
T = typing.TypeVar('T')
import typing_extensions

class QTest(shiboken2.Object):
    class KeyAction:
        Click: typing.ClassVar[QTest.KeyAction] = ...
        Press: typing.ClassVar[QTest.KeyAction] = ...
        Release: typing.ClassVar[QTest.KeyAction] = ...
        Shortcut: typing.ClassVar[QTest.KeyAction] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTest.KeyAction: ...
        def __and__(self, other: typing.SupportsInt) -> QTest.KeyAction: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTest.KeyAction: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTest.KeyAction: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QTest.KeyAction: ...
        def __rand__(self, other: typing.SupportsInt) -> QTest.KeyAction: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTest.KeyAction: ...
        def __ror__(self, other: typing.SupportsInt) -> QTest.KeyAction: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTest.KeyAction: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTest.KeyAction: ...
        def __sub__(self, other: typing.SupportsInt) -> QTest.KeyAction: ...
        def __xor__(self, other: typing.SupportsInt) -> QTest.KeyAction: ...

    class MouseAction:
        MouseClick: typing.ClassVar[QTest.MouseAction] = ...
        MouseDClick: typing.ClassVar[QTest.MouseAction] = ...
        MouseMove: typing.ClassVar[QTest.MouseAction] = ...
        MousePress: typing.ClassVar[QTest.MouseAction] = ...
        MouseRelease: typing.ClassVar[QTest.MouseAction] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTest.MouseAction: ...
        def __and__(self, other: typing.SupportsInt) -> QTest.MouseAction: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTest.MouseAction: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTest.MouseAction: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QTest.MouseAction: ...
        def __rand__(self, other: typing.SupportsInt) -> QTest.MouseAction: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTest.MouseAction: ...
        def __ror__(self, other: typing.SupportsInt) -> QTest.MouseAction: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTest.MouseAction: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTest.MouseAction: ...
        def __sub__(self, other: typing.SupportsInt) -> QTest.MouseAction: ...
        def __xor__(self, other: typing.SupportsInt) -> QTest.MouseAction: ...

    class QBenchmarkMetric:
        AlignmentFaults: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        BitsPerSecond: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        BranchInstructions: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        BranchMisses: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        BusCycles: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        BytesAllocated: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        BytesPerSecond: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        CPUCycles: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        CPUMigrations: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        CPUTicks: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        CacheMisses: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        CachePrefetchMisses: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        CachePrefetches: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        CacheReadMisses: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        CacheReads: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        CacheReferences: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        CacheWriteMisses: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        CacheWrites: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        ContextSwitches: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        EmulationFaults: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        Events: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        FramesPerSecond: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        InstructionReads: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        Instructions: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        MajorPageFaults: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        MinorPageFaults: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        PageFaults: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        RefCPUCycles: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        StalledCycles: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        WalltimeMilliseconds: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        WalltimeNanoseconds: typing.ClassVar[QTest.QBenchmarkMetric] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTest.QBenchmarkMetric: ...
        def __and__(self, other: typing.SupportsInt) -> QTest.QBenchmarkMetric: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTest.QBenchmarkMetric: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTest.QBenchmarkMetric: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QTest.QBenchmarkMetric: ...
        def __rand__(self, other: typing.SupportsInt) -> QTest.QBenchmarkMetric: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTest.QBenchmarkMetric: ...
        def __ror__(self, other: typing.SupportsInt) -> QTest.QBenchmarkMetric: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTest.QBenchmarkMetric: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTest.QBenchmarkMetric: ...
        def __sub__(self, other: typing.SupportsInt) -> QTest.QBenchmarkMetric: ...
        def __xor__(self, other: typing.SupportsInt) -> QTest.QBenchmarkMetric: ...

    class QTouchEventSequence(shiboken2.Object):
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def commit(self, processEvents: bool = ...) -> None: ...
        @typing.overload
        def move(self, touchId: int, pt: PySide2.QtCore.QPoint, window: PySide2.QtGui.QWindow | None = ...) -> QTest.QTouchEventSequence: ...
        @typing.overload
        def move(self, touchId: int, pt: PySide2.QtCore.QPoint, widget: PySide2.QtWidgets.QWidget | None = ...) -> QTest.QTouchEventSequence: ...
        @typing.overload
        def press(self, touchId: int, pt: PySide2.QtCore.QPoint, window: PySide2.QtGui.QWindow | None = ...) -> QTest.QTouchEventSequence: ...
        @typing.overload
        def press(self, touchId: int, pt: PySide2.QtCore.QPoint, widget: PySide2.QtWidgets.QWidget | None = ...) -> QTest.QTouchEventSequence: ...
        @typing.overload
        def release(self, touchId: int, pt: PySide2.QtCore.QPoint, window: PySide2.QtGui.QWindow | None = ...) -> QTest.QTouchEventSequence: ...
        @typing.overload
        def release(self, touchId: int, pt: PySide2.QtCore.QPoint, widget: PySide2.QtWidgets.QWidget | None = ...) -> QTest.QTouchEventSequence: ...
        def stationary(self, touchId: int) -> QTest.QTouchEventSequence: ...

    class TestFailMode:
        Abort: typing.ClassVar[QTest.TestFailMode] = ...
        Continue: typing.ClassVar[QTest.TestFailMode] = ...
        values: typing.ClassVar[dict] = ...
        name: _typeshed.Incomplete
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTest.TestFailMode: ...
        def __and__(self, other: typing.SupportsInt) -> QTest.TestFailMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTest.TestFailMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTest.TestFailMode: ...
        def __pos__(self): ...
        def __radd__(self, other: typing.SupportsInt) -> QTest.TestFailMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QTest.TestFailMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTest.TestFailMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QTest.TestFailMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTest.TestFailMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTest.TestFailMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QTest.TestFailMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QTest.TestFailMode: ...
    Abort: typing.ClassVar[QTest.TestFailMode] = ...
    AlignmentFaults: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    BitsPerSecond: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    BranchInstructions: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    BranchMisses: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    BusCycles: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    BytesAllocated: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    BytesPerSecond: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    CPUCycles: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    CPUMigrations: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    CPUTicks: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    CacheMisses: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    CachePrefetchMisses: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    CachePrefetches: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    CacheReadMisses: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    CacheReads: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    CacheReferences: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    CacheWriteMisses: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    CacheWrites: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    Click: typing.ClassVar[QTest.KeyAction] = ...
    ContextSwitches: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    Continue: typing.ClassVar[QTest.TestFailMode] = ...
    EmulationFaults: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    Events: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    FramesPerSecond: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    InstructionReads: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    Instructions: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    MajorPageFaults: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    MinorPageFaults: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    MouseClick: typing.ClassVar[QTest.MouseAction] = ...
    MouseDClick: typing.ClassVar[QTest.MouseAction] = ...
    MouseMove: typing.ClassVar[QTest.MouseAction] = ...
    MousePress: typing.ClassVar[QTest.MouseAction] = ...
    MouseRelease: typing.ClassVar[QTest.MouseAction] = ...
    PageFaults: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    Press: typing.ClassVar[QTest.KeyAction] = ...
    RefCPUCycles: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    Release: typing.ClassVar[QTest.KeyAction] = ...
    Shortcut: typing.ClassVar[QTest.KeyAction] = ...
    StalledCycles: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    WalltimeMilliseconds: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    WalltimeNanoseconds: typing.ClassVar[QTest.QBenchmarkMetric] = ...
    mouseDoubleClickInterval: typing.ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @staticmethod
    def addColumnInternal(id: int, name: bytes) -> None: ...
    @staticmethod
    def asciiToKey(ascii: int) -> PySide2.QtCore.Qt.Key: ...
    @staticmethod
    def compare_ptr_helper(t1: int, t2: int, actual: bytes, expected: bytes, file: bytes, line: int) -> bool: ...
    @staticmethod
    def compare_string_helper(t1: bytes, t2: bytes, actual: bytes, expected: bytes, file: bytes, line: int) -> bool: ...
    @staticmethod
    def createTouchDevice(devType: PySide2.QtGui.QTouchDevice.DeviceType = ...) -> PySide2.QtGui.QTouchDevice: ...
    @staticmethod
    def currentAppName() -> bytes: ...
    @staticmethod
    def currentDataTag() -> bytes: ...
    @staticmethod
    def currentTestFailed() -> bool: ...
    @staticmethod
    def currentTestFunction() -> bytes: ...
    @typing.overload
    @staticmethod
    def ignoreMessage(type: PySide2.QtCore.QtMsgType, messagePattern: PySide2.QtCore.QRegularExpression) -> None: ...
    @typing.overload
    @staticmethod
    def ignoreMessage(type: PySide2.QtCore.QtMsgType, message: bytes) -> None: ...
    @typing.overload
    @staticmethod
    def keyClick(window: PySide2.QtGui.QWindow, key: PySide2.QtCore.Qt.Key, modifier: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def keyClick(window: PySide2.QtGui.QWindow, key: int, modifier: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def keyClick(widget: PySide2.QtWidgets.QWidget, key: PySide2.QtCore.Qt.Key, modifier: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def keyClick(widget: PySide2.QtWidgets.QWidget, key: int, modifier: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., delay: int = ...) -> None: ...
    @staticmethod
    def keyClicks(widget: PySide2.QtWidgets.QWidget, sequence: str, modifier: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def keyEvent(action: QTest.KeyAction, window: PySide2.QtGui.QWindow, key: PySide2.QtCore.Qt.Key, modifier: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def keyEvent(action: QTest.KeyAction, window: PySide2.QtGui.QWindow, ascii: int, modifier: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def keyEvent(action: QTest.KeyAction, widget: PySide2.QtWidgets.QWidget, key: PySide2.QtCore.Qt.Key, modifier: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def keyEvent(action: QTest.KeyAction, widget: PySide2.QtWidgets.QWidget, ascii: int, modifier: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def keyPress(window: PySide2.QtGui.QWindow, key: PySide2.QtCore.Qt.Key, modifier: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def keyPress(window: PySide2.QtGui.QWindow, key: int, modifier: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def keyPress(widget: PySide2.QtWidgets.QWidget, key: PySide2.QtCore.Qt.Key, modifier: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def keyPress(widget: PySide2.QtWidgets.QWidget, key: int, modifier: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def keyRelease(window: PySide2.QtGui.QWindow, key: PySide2.QtCore.Qt.Key, modifier: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def keyRelease(window: PySide2.QtGui.QWindow, key: int, modifier: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def keyRelease(widget: PySide2.QtWidgets.QWidget, key: PySide2.QtCore.Qt.Key, modifier: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def keyRelease(widget: PySide2.QtWidgets.QWidget, key: int, modifier: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def keySequence(window: PySide2.QtGui.QWindow, keySequence: PySide2.QtGui.QKeySequence | str) -> None: ...
    @typing.overload
    @staticmethod
    def keySequence(widget: PySide2.QtWidgets.QWidget, keySequence: PySide2.QtGui.QKeySequence | str) -> None: ...
    @staticmethod
    def keyToAscii(key: PySide2.QtCore.Qt.Key) -> int: ...
    @typing.overload
    @staticmethod
    def mouseClick(window: PySide2.QtGui.QWindow, button: PySide2.QtCore.Qt.MouseButton, stateKey: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., pos: PySide2.QtCore.QPoint = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def mouseClick(widget: PySide2.QtWidgets.QWidget, button: PySide2.QtCore.Qt.MouseButton, stateKey: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., pos: PySide2.QtCore.QPoint = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def mouseDClick(window: PySide2.QtGui.QWindow, button: PySide2.QtCore.Qt.MouseButton, stateKey: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., pos: PySide2.QtCore.QPoint = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def mouseDClick(widget: PySide2.QtWidgets.QWidget, button: PySide2.QtCore.Qt.MouseButton, stateKey: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., pos: PySide2.QtCore.QPoint = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def mouseEvent(action: QTest.MouseAction, window: PySide2.QtGui.QWindow, button: PySide2.QtCore.Qt.MouseButton, stateKey: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier, pos: PySide2.QtCore.QPoint, delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def mouseEvent(action: QTest.MouseAction, widget: PySide2.QtWidgets.QWidget, button: PySide2.QtCore.Qt.MouseButton, stateKey: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier, pos: PySide2.QtCore.QPoint, delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def mouseMove(window: PySide2.QtGui.QWindow, pos: PySide2.QtCore.QPoint = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def mouseMove(widget: PySide2.QtWidgets.QWidget, pos: PySide2.QtCore.QPoint = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def mousePress(window: PySide2.QtGui.QWindow, button: PySide2.QtCore.Qt.MouseButton, stateKey: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., pos: PySide2.QtCore.QPoint = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def mousePress(widget: PySide2.QtWidgets.QWidget, button: PySide2.QtCore.Qt.MouseButton, stateKey: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., pos: PySide2.QtCore.QPoint = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def mouseRelease(window: PySide2.QtGui.QWindow, button: PySide2.QtCore.Qt.MouseButton, stateKey: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., pos: PySide2.QtCore.QPoint = ..., delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def mouseRelease(widget: PySide2.QtWidgets.QWidget, button: PySide2.QtCore.Qt.MouseButton, stateKey: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier = ..., pos: PySide2.QtCore.QPoint = ..., delay: int = ...) -> None: ...
    @staticmethod
    def qCleanup() -> None: ...
    @staticmethod
    def qElementData(elementName: bytes, metaTypeId: int) -> int: ...
    @staticmethod
    def qExpectFail(dataIndex: bytes, comment: bytes, mode: QTest.TestFailMode, file: bytes, line: int) -> bool: ...
    @typing.overload
    @staticmethod
    def qFindTestData(basepath: str, file: bytes | None = ..., line: int = ..., builddir: bytes | None = ...) -> str: ...
    @typing.overload
    @staticmethod
    def qFindTestData(basepath: bytes, file: bytes | None = ..., line: int = ..., builddir: bytes | None = ...) -> str: ...
    @staticmethod
    def qGlobalData(tagName: bytes, typeId: int) -> int: ...
    @staticmethod
    def qRun() -> int: ...
    @staticmethod
    def qSkip(message: bytes, file: bytes, line: int) -> None: ...
    @staticmethod
    def qWaitForWindowActive(widget: PySide2.QtWidgets.QWidget, timeout: int = ...) -> bool: ...
    @staticmethod
    def qWaitForWindowExposed(widget: PySide2.QtWidgets.QWidget, timeout: int = ...) -> bool: ...
    @typing.overload
    @staticmethod
    def sendKeyEvent(action: QTest.KeyAction, window: PySide2.QtGui.QWindow, code: PySide2.QtCore.Qt.Key, text: str, modifier: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier, delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def sendKeyEvent(action: QTest.KeyAction, window: PySide2.QtGui.QWindow, code: PySide2.QtCore.Qt.Key, ascii: int, modifier: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier, delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def sendKeyEvent(action: QTest.KeyAction, widget: PySide2.QtWidgets.QWidget, code: PySide2.QtCore.Qt.Key, text: str, modifier: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier, delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def sendKeyEvent(action: QTest.KeyAction, widget: PySide2.QtWidgets.QWidget, code: PySide2.QtCore.Qt.Key, ascii: int, modifier: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier, delay: int = ...) -> None: ...
    @staticmethod
    def setBenchmarkResult(result: float, metric: QTest.QBenchmarkMetric) -> None: ...
    @staticmethod
    def setMainSourcePath(file: bytes, builddir: bytes | None = ...) -> None: ...
    @typing.overload
    @staticmethod
    def simulateEvent(window: PySide2.QtGui.QWindow, press: bool, code: int, modifier: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier, text: str, repeat: bool, delay: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def simulateEvent(widget: PySide2.QtWidgets.QWidget, press: bool, code: int, modifier: PySide2.QtCore.Qt.KeyboardModifiers | PySide2.QtCore.Qt.KeyboardModifier, text: str, repeat: bool, delay: int = ...) -> None: ...
    @staticmethod
    def testObject() -> PySide2.QtCore.QObject: ...
    @staticmethod
    def toPrettyCString(unicode: bytes, length: int) -> bytes: ...
    @typing.overload
    @staticmethod
    def touchEvent(window: PySide2.QtGui.QWindow, device: PySide2.QtGui.QTouchDevice, autoCommit: bool = ...) -> QTest.QTouchEventSequence: ...
    @typing.overload
    @staticmethod
    def touchEvent(widget: PySide2.QtWidgets.QWidget, device: PySide2.QtGui.QTouchDevice, autoCommit: bool = ...) -> QTest.QTouchEventSequence: ...
