import pytest
from jsonschema import ValidationError

from qblox_scheduler.analysis.types import AnalysisSettings


def test_analysis_settings_valid() -> None:
    _ = AnalysisSettings(
        {
            "mpl_dpi": 450,
            "mpl_fig_formats": ["svg", "png"],
            "mpl_exclude_fig_titles": False,
            "mpl_transparent_background": False,
            "bla": 123,
            "save_fit_results": True,
        }
    )


def test_analysis_settings_invalid() -> None:
    with pytest.raises(ValidationError):
        _ = AnalysisSettings(
            {
                "mpl_fig_formats": ["svg"],
                "mpl_exclude_fig_titles": False,
                "mpl_transparent_background": False,
                "save_fit_results": True,
            }
        )

    with pytest.raises(ValidationError):
        _ = AnalysisSettings(
            {
                "mpl_dpi": "450",
                "mpl_fig_formats": ["svg"],
                "mpl_exclude_fig_titles": False,
                "mpl_transparent_background": False,
                "save_fit_results": True,
            }
        )

    with pytest.raises(ValidationError):
        _ = AnalysisSettings(
            {
                "mpl_dpi": "450",
                "mpl_fig_formats": "svg",
                "mpl_exclude_fig_titles": False,
                "mpl_transparent_background": False,
                "save_fit_results": True,
            }
        )
