from qblox_scheduler.operations.expressions import DType
from qblox_scheduler.operations.loop_domains import LinearDomain, linspace


def test_float_linspace():
    start = 1.0
    stop = 5.5
    nsteps = 10
    domain = linspace(start, stop, nsteps, dtype=DType.AMPLITUDE)
    assert isinstance(domain, LinearDomain)

    assert domain.start == start
    assert domain.stop == stop
    assert domain.num_steps == nsteps
    assert len(domain) == nsteps
    assert domain.step_size == 0.5
    assert domain[1] == 1.5
    assert list(domain.values()) == [
        1.0,
        1.5,
        2.0,
        2.5,
        3.0,
        3.5,
        4.0,
        4.5,
        5.0,
        5.5,
    ]


def test_complex_linspace():
    start = 1.0 + 2j
    stop = 5.5 + 11j
    nsteps = 10
    domain = linspace(start, stop, nsteps, dtype=DType.AMPLITUDE)
    assert isinstance(domain, LinearDomain)

    assert domain.start == start
    assert domain.stop == stop
    assert domain.num_steps == nsteps
    assert len(domain) == nsteps
    assert domain.step_size == 0.5 + 1j
    assert domain[1] == 1.5 + 3j
    assert list(domain.values()) == [
        1.0 + 2j,
        1.5 + 3j,
        2.0 + 4j,
        2.5 + 5j,
        3.0 + 6j,
        3.5 + 7j,
        4.0 + 8j,
        4.5 + 9j,
        5.0 + 10j,
        5.5 + 11j,
    ]
