# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from qanswer_sdk.models.qa_context import QaContext
from typing import Optional, Set
from typing_extensions import Self

class Aggregate(BaseModel):
    """
    Aggregate
    """ # noqa: E501
    uri: Optional[StrictStr] = None
    answer_context: Optional[QaContext] = Field(default=None, alias="answerContext")
    occurance: Optional[StrictInt] = None
    excluded: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["uri", "answerContext", "occurance", "excluded"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Aggregate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of answer_context
        if self.answer_context:
            _dict['answerContext'] = self.answer_context.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Aggregate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "uri": obj.get("uri"),
            "answerContext": QaContext.from_dict(obj["answerContext"]) if obj.get("answerContext") is not None else None,
            "occurance": obj.get("occurance"),
            "excluded": obj.get("excluded")
        })
        return _obj


