# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from qanswer_sdk.models.applied_metadata_filter import AppliedMetadataFilter
from qanswer_sdk.models.terms_bucket import TermsBucket
from typing import Optional, Set
from typing_extensions import Self

class Aggregation(BaseModel):
    """
    Aggregation
    """ # noqa: E501
    display_name: StrictStr
    type: StrictStr
    applied_filters: List[AppliedMetadataFilter]
    buckets: List[TermsBucket]
    __properties: ClassVar[List[str]] = ["display_name", "type", "applied_filters", "buckets"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['keyword', 'text', 'long', 'date', 'freetext', 'boolean']):
            raise ValueError("must be one of enum values ('keyword', 'text', 'long', 'date', 'freetext', 'boolean')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Aggregation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in applied_filters (list)
        _items = []
        if self.applied_filters:
            for _item_applied_filters in self.applied_filters:
                if _item_applied_filters:
                    _items.append(_item_applied_filters.to_dict())
            _dict['applied_filters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in buckets (list)
        _items = []
        if self.buckets:
            for _item_buckets in self.buckets:
                if _item_buckets:
                    _items.append(_item_buckets.to_dict())
            _dict['buckets'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Aggregation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "display_name": obj.get("display_name"),
            "type": obj.get("type"),
            "applied_filters": [AppliedMetadataFilter.from_dict(_item) for _item in obj["applied_filters"]] if obj.get("applied_filters") is not None else None,
            "buckets": [TermsBucket.from_dict(_item) for _item in obj["buckets"]] if obj.get("buckets") is not None else None
        })
        return _obj


