# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from qanswer_sdk.models.conversation_message import ConversationMessage
from typing import Optional, Set
from typing_extensions import Self

class ConversationModel(BaseModel):
    """
    ConversationModel
    """ # noqa: E501
    conversation_id: StrictStr
    title: StrictStr
    username: StrictStr
    dataset: StrictStr
    creation_date: StrictStr
    last_updated: StrictStr
    has_feedback: StrictBool
    has_human_takeover_accepted: StrictBool = Field(description="Is true if the user requested human help")
    has_human_helped: StrictBool = Field(description="Is true if the user requested human help and another user chatted with the person")
    origin: Optional[StrictStr] = None
    conversation: List[ConversationMessage]
    interface_origin: Optional[StrictStr] = None
    number_of_files: Optional[StrictInt] = None
    size_of_files: Optional[Union[StrictFloat, StrictInt]] = None
    __properties: ClassVar[List[str]] = ["conversation_id", "title", "username", "dataset", "creation_date", "last_updated", "has_feedback", "has_human_takeover_accepted", "has_human_helped", "origin", "conversation", "interface_origin", "number_of_files", "size_of_files"]

    @field_validator('interface_origin')
    def interface_origin_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['search', 'chat', 'widget', 'microsoft_teams', 'discord', 'slack', 'chatbot_playground', 'undefined', 'report_copilot']):
            raise ValueError("must be one of enum values ('search', 'chat', 'widget', 'microsoft_teams', 'discord', 'slack', 'chatbot_playground', 'undefined', 'report_copilot')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConversationModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in conversation (list)
        _items = []
        if self.conversation:
            for _item_conversation in self.conversation:
                if _item_conversation:
                    _items.append(_item_conversation.to_dict())
            _dict['conversation'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConversationModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "conversation_id": obj.get("conversation_id"),
            "title": obj.get("title"),
            "username": obj.get("username"),
            "dataset": obj.get("dataset"),
            "creation_date": obj.get("creation_date"),
            "last_updated": obj.get("last_updated"),
            "has_feedback": obj.get("has_feedback"),
            "has_human_takeover_accepted": obj.get("has_human_takeover_accepted"),
            "has_human_helped": obj.get("has_human_helped"),
            "origin": obj.get("origin"),
            "conversation": [ConversationMessage.from_dict(_item) for _item in obj["conversation"]] if obj.get("conversation") is not None else None,
            "interface_origin": obj.get("interface_origin"),
            "number_of_files": obj.get("number_of_files"),
            "size_of_files": obj.get("size_of_files")
        })
        return _obj


