# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CreateSharepointConnectorFromCertificateRequest(BaseModel):
    """
    CreateSharepointConnectorFromCertificateRequest
    """ # noqa: E501
    username: StrictStr
    dataset: StrictStr
    connector_name: Optional[StrictStr] = Field(default=None, description="Connector name")
    conversation_id: Optional[StrictStr] = Field(default=None, description="Conversation ID for the connector creation")
    username_origin: Optional[StrictStr] = Field(default=None, description="Origin of the connector creation")
    tenant_id: Optional[StrictStr] = Field(default=None, description="Tenant ID")
    client_id: Optional[StrictStr] = Field(default=None, description="Client ID")
    thumbprint: Optional[StrictStr] = Field(default=None, description="Thumbprint")
    certificate_password: Optional[StrictStr] = Field(default=None, description="Certificate Password")
    site_ids: Optional[List[Dict[str, Any]]] = Field(default=None, description="Site IDs Supported")
    __properties: ClassVar[List[str]] = ["username", "dataset", "connector_name", "conversation_id", "username_origin", "tenant_id", "client_id", "thumbprint", "certificate_password", "site_ids"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateSharepointConnectorFromCertificateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateSharepointConnectorFromCertificateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "username": obj.get("username"),
            "dataset": obj.get("dataset"),
            "connector_name": obj.get("connector_name"),
            "conversation_id": obj.get("conversation_id"),
            "username_origin": obj.get("username_origin"),
            "tenant_id": obj.get("tenant_id"),
            "client_id": obj.get("client_id"),
            "thumbprint": obj.get("thumbprint"),
            "certificate_password": obj.get("certificate_password"),
            "site_ids": obj.get("site_ids")
        })
        return _obj


