# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class DatasetDefaultValuesModel(BaseModel):
    """
    DatasetDefaultValuesModel
    """ # noqa: E501
    language: Optional[StrictStr] = Field(default=None, description="Language preference")
    split_by: Optional[StrictStr] = Field(default=None, description="Split method")
    split_length: Optional[StrictInt] = Field(default=None, description="Split length")
    split_overlap: Optional[StrictInt] = Field(default=None, description="Split overlap")
    llm_choice: Optional[StrictStr] = Field(default=None, description="Choice of language model")
    bot_name: Optional[StrictStr] = Field(default=None, description="Bot name")
    bot_description: Optional[StrictStr] = Field(default=None, description="Bot description")
    bot_mode: Optional[StrictStr] = Field(default=None, description="Bot mode")
    bot_knowledge: Optional[StrictStr] = Field(default=None, description="Bot knowledge settings")
    bot_answer_length: Optional[StrictStr] = Field(default=None, description="Bot answer length")
    bot_temperature: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Temperature for bot responses")
    bot_seed: Optional[StrictInt] = Field(default=None, description="Seed for bot randomness")
    prompt: Optional[StrictStr] = Field(default=None, description="Prompt to give the bot")
    number_of_references: Optional[StrictInt] = Field(default=None, description="Number of references used in answering questions")
    data_storage_preference: Optional[StrictStr] = None
    stream_speed: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Stream speed")
    top_k_retriever: Optional[StrictInt] = Field(default=None, description="Number of retriever results")
    weight_title: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Weight of title in ranking")
    weight_text: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Weight of text in ranking")
    track_geo: Optional[StrictBool] = Field(default=None, description="Flag to track geo location")
    use_training: Optional[StrictBool] = Field(default=None, description="Flag to use training data")
    embedding_model: Optional[StrictStr] = Field(default=None, description="Embedding model to use")
    __properties: ClassVar[List[str]] = ["language", "split_by", "split_length", "split_overlap", "llm_choice", "bot_name", "bot_description", "bot_mode", "bot_knowledge", "bot_answer_length", "bot_temperature", "bot_seed", "prompt", "number_of_references", "data_storage_preference", "stream_speed", "top_k_retriever", "weight_title", "weight_text", "track_geo", "use_training", "embedding_model"]

    @field_validator('data_storage_preference')
    def data_storage_preference_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['store_all', 'discard_all', 'store_anonymized']):
            raise ValueError("must be one of enum values ('store_all', 'discard_all', 'store_anonymized')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DatasetDefaultValuesModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DatasetDefaultValuesModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "language": obj.get("language"),
            "split_by": obj.get("split_by"),
            "split_length": obj.get("split_length"),
            "split_overlap": obj.get("split_overlap"),
            "llm_choice": obj.get("llm_choice"),
            "bot_name": obj.get("bot_name"),
            "bot_description": obj.get("bot_description"),
            "bot_mode": obj.get("bot_mode"),
            "bot_knowledge": obj.get("bot_knowledge"),
            "bot_answer_length": obj.get("bot_answer_length"),
            "bot_temperature": obj.get("bot_temperature"),
            "bot_seed": obj.get("bot_seed"),
            "prompt": obj.get("prompt"),
            "number_of_references": obj.get("number_of_references"),
            "data_storage_preference": obj.get("data_storage_preference"),
            "stream_speed": obj.get("stream_speed"),
            "top_k_retriever": obj.get("top_k_retriever"),
            "weight_title": obj.get("weight_title"),
            "weight_text": obj.get("weight_text"),
            "track_geo": obj.get("track_geo"),
            "use_training": obj.get("use_training"),
            "embedding_model": obj.get("embedding_model")
        })
        return _obj


