# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from qanswer_sdk.models.dataset_detail_kg import DatasetDetailKg
from qanswer_sdk.models.dataset_schema import DatasetSchema
from typing import Optional, Set
from typing_extensions import Self

class DatasetDetail(BaseModel):
    """
    DatasetDetail
    """ # noqa: E501
    id: Optional[StrictInt] = None
    dataset: Optional[StrictStr] = None
    username: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    access_type_open: Optional[StrictStr] = Field(default=None, alias="accessTypeOpen")
    access_type_shared: Optional[StrictStr] = Field(default=None, alias="accessTypeShared")
    free_text_details: Optional[DatasetSchema] = Field(default=None, alias="freeTextDetails")
    kg_details: Optional[DatasetDetailKg] = Field(default=None, alias="kgDetails")
    question_quota_available: Optional[StrictBool] = Field(default=None, alias="questionQuotaAvailable")
    __properties: ClassVar[List[str]] = ["id", "dataset", "username", "name", "description", "accessTypeOpen", "accessTypeShared", "freeTextDetails", "kgDetails", "questionQuotaAvailable"]

    @field_validator('access_type_open')
    def access_type_open_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['LoggedIn', 'Open', 'None']):
            raise ValueError("must be one of enum values ('LoggedIn', 'Open', 'None')")
        return value

    @field_validator('access_type_shared')
    def access_type_shared_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['SharedWrite', 'SharedRead', 'UseOnly']):
            raise ValueError("must be one of enum values ('SharedWrite', 'SharedRead', 'UseOnly')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DatasetDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of free_text_details
        if self.free_text_details:
            _dict['freeTextDetails'] = self.free_text_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of kg_details
        if self.kg_details:
            _dict['kgDetails'] = self.kg_details.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DatasetDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "dataset": obj.get("dataset"),
            "username": obj.get("username"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "accessTypeOpen": obj.get("accessTypeOpen"),
            "accessTypeShared": obj.get("accessTypeShared"),
            "freeTextDetails": DatasetSchema.from_dict(obj["freeTextDetails"]) if obj.get("freeTextDetails") is not None else None,
            "kgDetails": DatasetDetailKg.from_dict(obj["kgDetails"]) if obj.get("kgDetails") is not None else None,
            "questionQuotaAvailable": obj.get("questionQuotaAvailable")
        })
        return _obj


