# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class DatasetUpdateObject(BaseModel):
    """
    DatasetUpdateObject
    """ # noqa: E501
    dataset: StrictStr = Field(description="Dataset identifier")
    username: StrictStr = Field(description="Username associated with the dataset")
    is_updating: Optional[StrictBool] = Field(default=None, description="Flag to check if updating")
    use_reader: Optional[StrictBool] = Field(default=None, description="Flag to use reader")
    use_ranker: Optional[StrictBool] = Field(default=None, description="Flag to use ranker")
    use_fallback: Optional[StrictBool] = Field(default=None, description="Use fallback option")
    top_k_retriever: Optional[StrictInt] = Field(default=None, description="Number of retriever results")
    top_k_reader: Optional[StrictInt] = Field(default=None, description="Number of reader results")
    return_no_ans: Optional[StrictBool] = Field(default=None, description="Return no answer flag")
    no_ans_boost: Optional[StrictInt] = Field(default=None, description="No answer boost")
    max_seq_len: Optional[StrictInt] = Field(default=None, description="Maximum sequence length")
    doc_stride: Optional[StrictInt] = Field(default=None, description="Document stride")
    max_ans_len: Optional[StrictInt] = Field(default=None, description="Maximum answer length")
    weight_title: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Weight of title in ranking")
    weight_text: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Weight of text in ranking")
    llm_choice: Optional[StrictStr] = Field(default=None, description="Choice of language model")
    bot_name: Optional[StrictStr] = Field(default=None, description="Bot name")
    bot_description: Optional[StrictStr] = Field(default=None, description="Bot description")
    bot_mode: Optional[StrictStr] = Field(default=None, description="Bot mode")
    bot_knowledge: Optional[StrictStr] = Field(default=None, description="Bot knowledge settings")
    bot_answer_length: Optional[StrictStr] = Field(default=None, description="Bot answer length")
    bot_seed: Optional[StrictInt] = Field(default=None, description="Seed for bot randomness")
    bot_temperature: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Temperature for bot responses")
    prompt: Optional[StrictStr] = Field(default=None, description="Prompt to give the bot")
    number_of_references: Optional[StrictInt] = Field(default=None, description="Number of references used in answering questions")
    data_storage_preference: Optional[StrictStr] = None
    stream_speed: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Stream speed")
    initial_message: Optional[StrictStr] = Field(default=None, description="Initial message displayed")
    widget_init_msg: Optional[StrictStr] = Field(default=None, description="Widget&#39;s initial message")
    widget_theme: Optional[StrictStr] = Field(default=None, description="Widget theme")
    widget_open_default: Optional[StrictBool] = Field(default=None, description="Flag to open widget by default")
    widget_font: Optional[StrictStr] = Field(default=None, description="Font used in the widget")
    widget_color_primary: Optional[StrictStr] = Field(default=None, description="Primary color of the widget", alias="widget_colorPrimary")
    widget_color_secondary: Optional[StrictStr] = Field(default=None, description="Secondary color of the widget", alias="widget_colorSecondary")
    widget_align: Optional[StrictStr] = Field(default=None, description="Widget alignment")
    widget_offset_x: Optional[StrictInt] = Field(default=None, description="Widget offset X", alias="widget_offsetX")
    widget_offset_y: Optional[StrictInt] = Field(default=None, description="Widget offset Y", alias="widget_offsetY")
    widget_show_powered_by: Optional[StrictBool] = Field(default=None, description="Show powered by label in the widget")
    widget_show_export_conversation: Optional[StrictBool] = Field(default=None, description="Show export conversation button in the widget")
    track_geo: Optional[StrictBool] = Field(default=None, description="Flag to track geo location")
    use_training: Optional[StrictBool] = Field(default=None, description="Flag to use training data")
    split_by: Optional[StrictStr] = Field(default=None, description="Split method")
    split_len: Optional[StrictInt] = Field(default=None, description="Split length")
    split_overlap: Optional[StrictInt] = Field(default=None, description="Split overlap")
    __properties: ClassVar[List[str]] = ["dataset", "username", "is_updating", "use_reader", "use_ranker", "use_fallback", "top_k_retriever", "top_k_reader", "return_no_ans", "no_ans_boost", "max_seq_len", "doc_stride", "max_ans_len", "weight_title", "weight_text", "llm_choice", "bot_name", "bot_description", "bot_mode", "bot_knowledge", "bot_answer_length", "bot_seed", "bot_temperature", "prompt", "number_of_references", "data_storage_preference", "stream_speed", "initial_message", "widget_init_msg", "widget_theme", "widget_open_default", "widget_font", "widget_colorPrimary", "widget_colorSecondary", "widget_align", "widget_offsetX", "widget_offsetY", "widget_show_powered_by", "widget_show_export_conversation", "track_geo", "use_training", "split_by", "split_len", "split_overlap"]

    @field_validator('data_storage_preference')
    def data_storage_preference_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['store_all', 'discard_all', 'store_anonymized']):
            raise ValueError("must be one of enum values ('store_all', 'discard_all', 'store_anonymized')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DatasetUpdateObject from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DatasetUpdateObject from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dataset": obj.get("dataset"),
            "username": obj.get("username"),
            "is_updating": obj.get("is_updating"),
            "use_reader": obj.get("use_reader"),
            "use_ranker": obj.get("use_ranker"),
            "use_fallback": obj.get("use_fallback"),
            "top_k_retriever": obj.get("top_k_retriever"),
            "top_k_reader": obj.get("top_k_reader"),
            "return_no_ans": obj.get("return_no_ans"),
            "no_ans_boost": obj.get("no_ans_boost"),
            "max_seq_len": obj.get("max_seq_len"),
            "doc_stride": obj.get("doc_stride"),
            "max_ans_len": obj.get("max_ans_len"),
            "weight_title": obj.get("weight_title"),
            "weight_text": obj.get("weight_text"),
            "llm_choice": obj.get("llm_choice"),
            "bot_name": obj.get("bot_name"),
            "bot_description": obj.get("bot_description"),
            "bot_mode": obj.get("bot_mode"),
            "bot_knowledge": obj.get("bot_knowledge"),
            "bot_answer_length": obj.get("bot_answer_length"),
            "bot_seed": obj.get("bot_seed"),
            "bot_temperature": obj.get("bot_temperature"),
            "prompt": obj.get("prompt"),
            "number_of_references": obj.get("number_of_references"),
            "data_storage_preference": obj.get("data_storage_preference"),
            "stream_speed": obj.get("stream_speed"),
            "initial_message": obj.get("initial_message"),
            "widget_init_msg": obj.get("widget_init_msg"),
            "widget_theme": obj.get("widget_theme"),
            "widget_open_default": obj.get("widget_open_default"),
            "widget_font": obj.get("widget_font"),
            "widget_colorPrimary": obj.get("widget_colorPrimary"),
            "widget_colorSecondary": obj.get("widget_colorSecondary"),
            "widget_align": obj.get("widget_align"),
            "widget_offsetX": obj.get("widget_offsetX"),
            "widget_offsetY": obj.get("widget_offsetY"),
            "widget_show_powered_by": obj.get("widget_show_powered_by"),
            "widget_show_export_conversation": obj.get("widget_show_export_conversation"),
            "track_geo": obj.get("track_geo"),
            "use_training": obj.get("use_training"),
            "split_by": obj.get("split_by"),
            "split_len": obj.get("split_len"),
            "split_overlap": obj.get("split_overlap")
        })
        return _obj


