# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from qanswer_sdk.models.slot_in_prompt import SlotInPrompt
from typing import Optional, Set
from typing_extensions import Self

class DefaultPrompt(BaseModel):
    """
    DefaultPrompt
    """ # noqa: E501
    text: StrictStr = Field(description="The default prompt text.")
    slots: Optional[List[SlotInPrompt]] = Field(default=None, description="Fields in the prompt and their descriptions.")
    type: StrictStr = Field(description="The type of the prompt.")
    __properties: ClassVar[List[str]] = ["text", "slots", "type"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['search', 'chat', 'data_extraction', 'report_copilot', 'text2sparql', 'sparql2text', 'chatbot', 'query_expansion', 'chat_map_prompt', 'chat_reduce_prompt', 'search_map_prompt', 'search_reduce_prompt']):
            raise ValueError("must be one of enum values ('search', 'chat', 'data_extraction', 'report_copilot', 'text2sparql', 'sparql2text', 'chatbot', 'query_expansion', 'chat_map_prompt', 'chat_reduce_prompt', 'search_map_prompt', 'search_reduce_prompt')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DefaultPrompt from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in slots (list)
        _items = []
        if self.slots:
            for _item_slots in self.slots:
                if _item_slots:
                    _items.append(_item_slots.to_dict())
            _dict['slots'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DefaultPrompt from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "text": obj.get("text"),
            "slots": [SlotInPrompt.from_dict(_item) for _item in obj["slots"]] if obj.get("slots") is not None else None,
            "type": obj.get("type")
        })
        return _obj


