# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class GuardrailEndpoint(BaseModel):
    """
    GuardrailEndpoint
    """ # noqa: E501
    disabled: Optional[StrictBool] = None
    io_guardrail_disabled: Optional[StrictBool] = None
    io_guardrail_mode: Optional[StrictStr] = None
    io_guardrail_level: Optional[StrictStr] = None
    io_guardrail_prompt: Optional[StrictStr] = None
    jailbreak_guardrail_disabled: Optional[StrictBool] = None
    jailbreak_guardrail_prompt: Optional[StrictStr] = None
    endpoint_id: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["disabled", "io_guardrail_disabled", "io_guardrail_mode", "io_guardrail_level", "io_guardrail_prompt", "jailbreak_guardrail_disabled", "jailbreak_guardrail_prompt", "endpoint_id"]

    @field_validator('io_guardrail_mode')
    def io_guardrail_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['in', 'out', 'in-out']):
            raise ValueError("must be one of enum values ('in', 'out', 'in-out')")
        return value

    @field_validator('io_guardrail_level')
    def io_guardrail_level_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['warning', 'error']):
            raise ValueError("must be one of enum values ('warning', 'error')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GuardrailEndpoint from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GuardrailEndpoint from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "disabled": obj.get("disabled"),
            "io_guardrail_disabled": obj.get("io_guardrail_disabled"),
            "io_guardrail_mode": obj.get("io_guardrail_mode"),
            "io_guardrail_level": obj.get("io_guardrail_level"),
            "io_guardrail_prompt": obj.get("io_guardrail_prompt"),
            "jailbreak_guardrail_disabled": obj.get("jailbreak_guardrail_disabled"),
            "jailbreak_guardrail_prompt": obj.get("jailbreak_guardrail_prompt"),
            "endpoint_id": obj.get("endpoint_id")
        })
        return _obj


