# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from qanswer_sdk.models.imap_additional_fields import ImapAdditionalFields
from typing import Optional, Set
from typing_extensions import Self

class ImapFileMetadata(BaseModel):
    """
    ImapFileMetadata
    """ # noqa: E501
    file_id: StrictStr
    title: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    file_name: StrictStr
    display_name: Optional[StrictStr] = None
    original_file_name: StrictStr
    file_extension: StrictStr
    type: StrictStr
    additional_fields: ImapAdditionalFields
    __properties: ClassVar[List[str]] = ["file_id", "title", "name", "file_name", "display_name", "original_file_name", "file_extension", "type", "additional_fields"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['folder', 'email']):
            raise ValueError("must be one of enum values ('folder', 'email')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ImapFileMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of additional_fields
        if self.additional_fields:
            _dict['additional_fields'] = self.additional_fields.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ImapFileMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "file_id": obj.get("file_id"),
            "title": obj.get("title"),
            "name": obj.get("name"),
            "file_name": obj.get("file_name"),
            "display_name": obj.get("display_name"),
            "original_file_name": obj.get("original_file_name"),
            "file_extension": obj.get("file_extension"),
            "type": obj.get("type"),
            "additional_fields": ImapAdditionalFields.from_dict(obj["additional_fields"]) if obj.get("additional_fields") is not None else None
        })
        return _obj


