# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from qanswer_sdk.models.chatbot_conversation_model import ChatbotConversationModel
from typing import Optional, Set
from typing_extensions import Self

class ListChatbotConversationResponse(BaseModel):
    """
    ListChatbotConversationResponse
    """ # noqa: E501
    status: Optional[StrictBool] = None
    message: StrictStr
    conversations: List[ChatbotConversationModel]
    total: Optional[StrictInt] = None
    limit: Optional[StrictInt] = None
    offset: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["status", "message", "conversations", "total", "limit", "offset"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListChatbotConversationResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in conversations (list)
        _items = []
        if self.conversations:
            for _item_conversations in self.conversations:
                if _item_conversations:
                    _items.append(_item_conversations.to_dict())
            _dict['conversations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListChatbotConversationResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "status": obj.get("status"),
            "message": obj.get("message"),
            "conversations": [ChatbotConversationModel.from_dict(_item) for _item in obj["conversations"]] if obj.get("conversations") is not None else None,
            "total": obj.get("total"),
            "limit": obj.get("limit"),
            "offset": obj.get("offset")
        })
        return _obj


