# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from qanswer_sdk.models.extra_body import ExtraBody
from qanswer_sdk.models.generation_params import GenerationParams
from qanswer_sdk.models.guardrail_endpoint import GuardrailEndpoint
from qanswer_sdk.models.llm_context_ranges import LLMContextRanges
from qanswer_sdk.models.rag_params import RAGParams
from qanswer_sdk.models.retry_params import RetryParams
from typing import Optional, Set
from typing_extensions import Self

class LLMEndpointReadOutput(BaseModel):
    """
    The LLM endpoint details. This field is populated based on the llm_choice.
    """ # noqa: E501
    modality: Optional[StrictStr] = None
    provider: Optional[StrictStr] = None
    api_version: Optional[StrictStr] = None
    aws_access_key_id: Optional[StrictStr] = None
    aws_secret_access_key: Optional[StrictStr] = None
    aws_region_name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    onpremise: Optional[StrictBool] = None
    sensitivity_label: Optional[StrictStr] = None
    guardrail: Optional[GuardrailEndpoint] = None
    retry_params: Optional[RetryParams] = None
    extra_body: Optional[ExtraBody] = None
    tags: Optional[List[StrictStr]] = None
    display_name: StrictStr
    engine: StrictStr
    api_key: StrictStr
    endpoint_url: StrictStr
    rag_params: Optional[RAGParams] = None
    generation_params: GenerationParams
    name: StrictStr
    id: Optional[StrictInt] = None
    context_ranges: Optional[LLMContextRanges] = None
    __properties: ClassVar[List[str]] = ["modality", "provider", "api_version", "aws_access_key_id", "aws_secret_access_key", "aws_region_name", "description", "onpremise", "sensitivity_label", "guardrail", "retry_params", "extra_body", "tags", "display_name", "engine", "api_key", "endpoint_url", "rag_params", "generation_params", "name", "id", "context_ranges"]

    @field_validator('modality')
    def modality_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['text', 'text-image']):
            raise ValueError("must be one of enum values ('text', 'text-image')")
        return value

    @field_validator('provider')
    def provider_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['openai', 'azure', 'bedrock', 'mistral', 'anthropic', 'openrouter']):
            raise ValueError("must be one of enum values ('openai', 'azure', 'bedrock', 'mistral', 'anthropic', 'openrouter')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LLMEndpointReadOutput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of guardrail
        if self.guardrail:
            _dict['guardrail'] = self.guardrail.to_dict()
        # override the default output from pydantic by calling `to_dict()` of retry_params
        if self.retry_params:
            _dict['retry_params'] = self.retry_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of extra_body
        if self.extra_body:
            _dict['extra_body'] = self.extra_body.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rag_params
        if self.rag_params:
            _dict['rag_params'] = self.rag_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of generation_params
        if self.generation_params:
            _dict['generation_params'] = self.generation_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of context_ranges
        if self.context_ranges:
            _dict['context_ranges'] = self.context_ranges.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LLMEndpointReadOutput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "modality": obj.get("modality"),
            "provider": obj.get("provider"),
            "api_version": obj.get("api_version"),
            "aws_access_key_id": obj.get("aws_access_key_id"),
            "aws_secret_access_key": obj.get("aws_secret_access_key"),
            "aws_region_name": obj.get("aws_region_name"),
            "description": obj.get("description"),
            "onpremise": obj.get("onpremise"),
            "sensitivity_label": obj.get("sensitivity_label"),
            "guardrail": GuardrailEndpoint.from_dict(obj["guardrail"]) if obj.get("guardrail") is not None else None,
            "retry_params": RetryParams.from_dict(obj["retry_params"]) if obj.get("retry_params") is not None else None,
            "extra_body": ExtraBody.from_dict(obj["extra_body"]) if obj.get("extra_body") is not None else None,
            "tags": obj.get("tags"),
            "display_name": obj.get("display_name"),
            "engine": obj.get("engine"),
            "api_key": obj.get("api_key"),
            "endpoint_url": obj.get("endpoint_url"),
            "rag_params": RAGParams.from_dict(obj["rag_params"]) if obj.get("rag_params") is not None else None,
            "generation_params": GenerationParams.from_dict(obj["generation_params"]) if obj.get("generation_params") is not None else None,
            "name": obj.get("name"),
            "id": obj.get("id"),
            "context_ranges": LLMContextRanges.from_dict(obj["context_ranges"]) if obj.get("context_ranges") is not None else None
        })
        return _obj


