# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class SignUpRequest(BaseModel):
    """
    SignUpRequest
    """ # noqa: E501
    name: Annotated[str, Field(min_length=4, strict=True, max_length=40)] = Field(description="User's full name for the new account")
    username: Annotated[str, Field(min_length=3, strict=True, max_length=40)] = Field(description="User's username for the new account")
    email: Annotated[str, Field(min_length=0, strict=True, max_length=100)] = Field(description="User's e-mail for the new account")
    password: Annotated[str, Field(min_length=6, strict=True, max_length=20)] = Field(description="User's password for the new account")
    origin: Optional[StrictStr] = Field(default=None, description="Can be used to indicate where the user is coming from")
    __properties: ClassVar[List[str]] = ["name", "username", "email", "password", "origin"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SignUpRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SignUpRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "username": obj.get("username"),
            "email": obj.get("email"),
            "password": obj.get("password"),
            "origin": obj.get("origin")
        })
        return _obj


