# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from qanswer_sdk.models.source import Source
from typing import Optional, Set
from typing_extensions import Self

class SlotHistoryEntry(BaseModel):
    """
    Chronological history of prompt/completion pairs for this slot.
    """ # noqa: E501
    user_message_id: Optional[StrictStr] = None
    assistant_message_id: Optional[StrictStr] = None
    prompt: StrictStr
    completion: Optional[StrictStr] = None
    sources: Optional[List[Source]] = None
    prompt_used: Optional[StrictStr] = None
    llm_choice: Optional[StrictStr] = None
    mode: Optional[StrictStr] = Field(default=None, description="The mode used to generate the slot completion.")
    is_input_data_cropped: Optional[StrictBool] = Field(default=None, description="Whether the input data was cropped while prompting the LLM.")
    created_at: Optional[StrictStr] = Field(default=None, description="UTC timestamp of when the slot version was created.")
    feedback: Optional[StrictInt] = None
    comment: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["user_message_id", "assistant_message_id", "prompt", "completion", "sources", "prompt_used", "llm_choice", "mode", "is_input_data_cropped", "created_at", "feedback", "comment"]

    @field_validator('mode')
    def mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['rag', 'full-context', 'rag-with-map-reduce', 'full_context_with_map_reduce']):
            raise ValueError("must be one of enum values ('rag', 'full-context', 'rag-with-map-reduce', 'full_context_with_map_reduce')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SlotHistoryEntry from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in sources (list)
        _items = []
        if self.sources:
            for _item_sources in self.sources:
                if _item_sources:
                    _items.append(_item_sources.to_dict())
            _dict['sources'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SlotHistoryEntry from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "user_message_id": obj.get("user_message_id"),
            "assistant_message_id": obj.get("assistant_message_id"),
            "prompt": obj.get("prompt"),
            "completion": obj.get("completion"),
            "sources": [Source.from_dict(_item) for _item in obj["sources"]] if obj.get("sources") is not None else None,
            "prompt_used": obj.get("prompt_used"),
            "llm_choice": obj.get("llm_choice"),
            "mode": obj.get("mode"),
            "is_input_data_cropped": obj.get("is_input_data_cropped"),
            "created_at": obj.get("created_at"),
            "feedback": obj.get("feedback"),
            "comment": obj.get("comment")
        })
        return _obj


