# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from qanswer_sdk.models.entity_model import EntityModel
from qanswer_sdk.models.subject_model import SubjectModel
from typing import Optional, Set
from typing_extensions import Self

class SocketDataExtraction(BaseModel):
    """
    SocketDataExtraction
    """ # noqa: E501
    username: StrictStr = Field(description="Username of the dataset")
    dataset: StrictStr = Field(description="Name of the dataset")
    jwt: StrictStr = Field(description="JTW token for authentification to join the conversation.")
    api_key: Optional[StrictStr] = Field(default=None, description="Api ley for authentification to join the conversation.")
    subject: SubjectModel
    subject_relations: List[EntityModel]
    __properties: ClassVar[List[str]] = ["username", "dataset", "jwt", "api_key", "subject", "subject_relations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SocketDataExtraction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of subject
        if self.subject:
            _dict['subject'] = self.subject.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in subject_relations (list)
        _items = []
        if self.subject_relations:
            for _item_subject_relations in self.subject_relations:
                if _item_subject_relations:
                    _items.append(_item_subject_relations.to_dict())
            _dict['subject_relations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SocketDataExtraction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "username": obj.get("username"),
            "dataset": obj.get("dataset"),
            "jwt": obj.get("jwt"),
            "api_key": obj.get("api_key"),
            "subject": SubjectModel.from_dict(obj["subject"]) if obj.get("subject") is not None else None,
            "subject_relations": [EntityModel.from_dict(_item) for _item in obj["subject_relations"]] if obj.get("subject_relations") is not None else None
        })
        return _obj


