# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from qanswer_sdk.models.slot_info_with_latest_version import SlotInfoWithLatestVersion
from typing import Optional, Set
from typing_extensions import Self

class SocketReportCopilotGenerationFromSlotsResponse(BaseModel):
    """
    SocketReportCopilotGenerationFromSlotsResponse
    """ # noqa: E501
    slot_versions: List[SlotInfoWithLatestVersion]
    username: StrictStr = Field(description="Username of the dataset")
    dataset: StrictStr = Field(description="Name of the dataset")
    jwt: StrictStr = Field(description="JTW token for authentification to join the conversation.")
    api_key: Optional[StrictStr] = Field(default=None, description="Api ley for authentification to join the conversation.")
    conversation_id: StrictStr = Field(description="ID of the conversation")
    user: Optional[StrictStr] = Field(default=None, description="User that is joining the conversation")
    status: StrictStr
    done: StrictInt
    total: StrictInt
    __properties: ClassVar[List[str]] = ["slot_versions", "username", "dataset", "jwt", "api_key", "conversation_id", "user", "status", "done", "total"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['COMPLETING', 'COMPLETED', 'THINKING', 'THINKING_COMPLETED', 'SOMETHING_WENT_WRONG']):
            raise ValueError("must be one of enum values ('COMPLETING', 'COMPLETED', 'THINKING', 'THINKING_COMPLETED', 'SOMETHING_WENT_WRONG')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SocketReportCopilotGenerationFromSlotsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in slot_versions (list)
        _items = []
        if self.slot_versions:
            for _item_slot_versions in self.slot_versions:
                if _item_slot_versions:
                    _items.append(_item_slot_versions.to_dict())
            _dict['slot_versions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SocketReportCopilotGenerationFromSlotsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "slot_versions": [SlotInfoWithLatestVersion.from_dict(_item) for _item in obj["slot_versions"]] if obj.get("slot_versions") is not None else None,
            "username": obj.get("username"),
            "dataset": obj.get("dataset"),
            "jwt": obj.get("jwt"),
            "api_key": obj.get("api_key"),
            "conversation_id": obj.get("conversation_id"),
            "user": obj.get("user"),
            "status": obj.get("status"),
            "done": obj.get("done"),
            "total": obj.get("total")
        })
        return _obj


