# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.collection import Collection
from ..types.filter import Filter
from ..types.query_expansion_strategy import QueryExpansionStrategy
from ..types.response_type import ResponseType
from ..types.search_response import SearchResponse
from ..types.source_connection_job import SourceConnectionJob
from .raw_client import AsyncRawCollectionsClient, RawCollectionsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CollectionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCollectionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCollectionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCollectionsClient
        """
        return self._raw_client

    def list_collections(
        self,
        *,
        skip: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Collection]:
        """
        List all collections that belong to your organization.

        Parameters
        ----------
        skip : typing.Optional[int]
            Number of collections to skip for pagination

        limit : typing.Optional[int]
            Maximum number of collections to return (1-1000)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Collection]
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
        )
        client.collections.list_collections()
        """
        _response = self._raw_client.list_collections(skip=skip, limit=limit, request_options=request_options)
        return _response.data

    def create_collection(
        self,
        *,
        name: str,
        readable_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Collection:
        """
        Create a new collection.

        <br/><br/>
        The newly created collection is initially empty and does not contain any data
        until you explicitly add source connections to it.

        Parameters
        ----------
        name : str
            Human-readable display name for the collection. This appears in the UI and should clearly describe the data contained within (e.g., 'Finance Data').

        readable_id : typing.Optional[str]
            URL-safe unique identifier used in API endpoints. Must contain only lowercase letters, numbers, and hyphens. If not provided, it will be automatically generated from the collection name with a random suffix for uniqueness (e.g., 'finance-data-ab123').

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
        )
        client.collections.create_collection(
            name="Finance Data",
            readable_id="finance-data-reports",
        )
        """
        _response = self._raw_client.create_collection(
            name=name, readable_id=readable_id, request_options=request_options
        )
        return _response.data

    def get_collection(
        self, readable_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Collection:
        """
        Retrieve a specific collection by its readable ID.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection (e.g., 'finance-data-ab123')

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
        )
        client.collections.get_collection(
            readable_id="readable_id",
        )
        """
        _response = self._raw_client.get_collection(readable_id, request_options=request_options)
        return _response.data

    def update_collection(
        self,
        readable_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Collection:
        """
        Update a collection's properties.

        <br/><br/>
        Modifies the display name of an existing collection.
        Note that the readable ID cannot be changed after creation to maintain stable
        API endpoints and preserve any existing integrations or bookmarks.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to update

        name : typing.Optional[str]
            Updated display name for the collection. Must be between 4 and 64 characters.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
        )
        client.collections.update_collection(
            readable_id="readable_id",
            name="Updated Finance Data",
        )
        """
        _response = self._raw_client.update_collection(readable_id, name=name, request_options=request_options)
        return _response.data

    def delete_collection(
        self, readable_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Collection:
        """
        Delete a collection and all associated data.

        Permanently removes a collection from your organization including all synced data
        from the destination systems. All source connections within this collection
        will also be deleted as part of the cleanup process. This action cannot be undone.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
        )
        client.collections.delete_collection(
            readable_id="readable_id",
        )
        """
        _response = self._raw_client.delete_collection(readable_id, request_options=request_options)
        return _response.data

    def search_collection(
        self,
        readable_id: str,
        *,
        query: str,
        response_type: typing.Optional[ResponseType] = None,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        score_threshold: typing.Optional[float] = None,
        expansion_strategy: typing.Optional[QueryExpansionStrategy] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SearchResponse:
        """
        Search across all data sources within the specified collection.

        This GET endpoint provides basic search functionality. For advanced filtering
        and options, use the POST /search endpoint.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to search

        query : str
            The search query text to find relevant documents and data

        response_type : typing.Optional[ResponseType]
            Format of the response: 'raw' returns search results, 'completion' returns AI-generated answers

        limit : typing.Optional[int]
            Maximum number of results to return

        offset : typing.Optional[int]
            Number of results to skip for pagination

        score_threshold : typing.Optional[float]
            Minimum similarity score threshold

        expansion_strategy : typing.Optional[QueryExpansionStrategy]
            Query expansion strategy (auto, llm, or no_expansion)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SearchResponse
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
        )
        client.collections.search_collection(
            readable_id="readable_id",
            query="customer payment issues",
        )
        """
        _response = self._raw_client.search_collection(
            readable_id,
            query=query,
            response_type=response_type,
            limit=limit,
            offset=offset,
            score_threshold=score_threshold,
            expansion_strategy=expansion_strategy,
            request_options=request_options,
        )
        return _response.data

    def search_collection_advanced(
        self,
        readable_id: str,
        *,
        query: str,
        filter: typing.Optional[Filter] = OMIT,
        offset: typing.Optional[int] = OMIT,
        limit: typing.Optional[int] = OMIT,
        score_threshold: typing.Optional[float] = OMIT,
        summarize: typing.Optional[bool] = OMIT,
        response_type: typing.Optional[ResponseType] = OMIT,
        expansion_strategy: typing.Optional[QueryExpansionStrategy] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SearchResponse:
        """
        Advanced search with comprehensive filtering and options.

        This endpoint supports:
        - Metadata filtering using Qdrant's native filter syntax
        - Pagination with offset and limit
        - Score threshold filtering
        - Query expansion strategies

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to search

        query : str
            The search query text

        filter : typing.Optional[Filter]
            Qdrant native filter for metadata-based filtering

        offset : typing.Optional[int]
            Number of results to skip

        limit : typing.Optional[int]
            Maximum number of results to return

        score_threshold : typing.Optional[float]
            Minimum similarity score threshold

        summarize : typing.Optional[bool]
            Whether to summarize results

        response_type : typing.Optional[ResponseType]
            Type of response (raw or completion)

        expansion_strategy : typing.Optional[QueryExpansionStrategy]
            Query expansion strategy. Enhances recall by expanding the query with synonyms, related terms, and other variations, but increases latency.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SearchResponse
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK, FieldCondition, Filter

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
        )
        client.collections.search_collection_advanced(
            readable_id="readable_id",
            query="customer payment issues",
            filter=Filter(
                must=FieldCondition(
                    key="key",
                ),
            ),
            limit=50,
            score_threshold=0.7,
            response_type="completion",
        )
        """
        _response = self._raw_client.search_collection_advanced(
            readable_id,
            query=query,
            filter=filter,
            offset=offset,
            limit=limit,
            score_threshold=score_threshold,
            summarize=summarize,
            response_type=response_type,
            expansion_strategy=expansion_strategy,
            request_options=request_options,
        )
        return _response.data

    def refresh_all_source_connections(
        self, readable_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[SourceConnectionJob]:
        """
        Trigger data synchronization for all source connections in the collection.

        <br/><br/>The sync jobs run asynchronously in the background, so this endpoint
        returns immediately with job details that you can use to track progress. You can
        monitor the status of individual data synchronization using the source connection
        endpoints.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to refresh

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[SourceConnectionJob]
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
        )
        client.collections.refresh_all_source_connections(
            readable_id="readable_id",
        )
        """
        _response = self._raw_client.refresh_all_source_connections(readable_id, request_options=request_options)
        return _response.data


class AsyncCollectionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCollectionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCollectionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCollectionsClient
        """
        return self._raw_client

    async def list_collections(
        self,
        *,
        skip: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Collection]:
        """
        List all collections that belong to your organization.

        Parameters
        ----------
        skip : typing.Optional[int]
            Number of collections to skip for pagination

        limit : typing.Optional[int]
            Maximum number of collections to return (1-1000)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Collection]
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.list_collections()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_collections(skip=skip, limit=limit, request_options=request_options)
        return _response.data

    async def create_collection(
        self,
        *,
        name: str,
        readable_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Collection:
        """
        Create a new collection.

        <br/><br/>
        The newly created collection is initially empty and does not contain any data
        until you explicitly add source connections to it.

        Parameters
        ----------
        name : str
            Human-readable display name for the collection. This appears in the UI and should clearly describe the data contained within (e.g., 'Finance Data').

        readable_id : typing.Optional[str]
            URL-safe unique identifier used in API endpoints. Must contain only lowercase letters, numbers, and hyphens. If not provided, it will be automatically generated from the collection name with a random suffix for uniqueness (e.g., 'finance-data-ab123').

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.create_collection(
                name="Finance Data",
                readable_id="finance-data-reports",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_collection(
            name=name, readable_id=readable_id, request_options=request_options
        )
        return _response.data

    async def get_collection(
        self, readable_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Collection:
        """
        Retrieve a specific collection by its readable ID.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection (e.g., 'finance-data-ab123')

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.get_collection(
                readable_id="readable_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_collection(readable_id, request_options=request_options)
        return _response.data

    async def update_collection(
        self,
        readable_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Collection:
        """
        Update a collection's properties.

        <br/><br/>
        Modifies the display name of an existing collection.
        Note that the readable ID cannot be changed after creation to maintain stable
        API endpoints and preserve any existing integrations or bookmarks.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to update

        name : typing.Optional[str]
            Updated display name for the collection. Must be between 4 and 64 characters.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.update_collection(
                readable_id="readable_id",
                name="Updated Finance Data",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_collection(readable_id, name=name, request_options=request_options)
        return _response.data

    async def delete_collection(
        self, readable_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Collection:
        """
        Delete a collection and all associated data.

        Permanently removes a collection from your organization including all synced data
        from the destination systems. All source connections within this collection
        will also be deleted as part of the cleanup process. This action cannot be undone.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.delete_collection(
                readable_id="readable_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_collection(readable_id, request_options=request_options)
        return _response.data

    async def search_collection(
        self,
        readable_id: str,
        *,
        query: str,
        response_type: typing.Optional[ResponseType] = None,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        score_threshold: typing.Optional[float] = None,
        expansion_strategy: typing.Optional[QueryExpansionStrategy] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SearchResponse:
        """
        Search across all data sources within the specified collection.

        This GET endpoint provides basic search functionality. For advanced filtering
        and options, use the POST /search endpoint.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to search

        query : str
            The search query text to find relevant documents and data

        response_type : typing.Optional[ResponseType]
            Format of the response: 'raw' returns search results, 'completion' returns AI-generated answers

        limit : typing.Optional[int]
            Maximum number of results to return

        offset : typing.Optional[int]
            Number of results to skip for pagination

        score_threshold : typing.Optional[float]
            Minimum similarity score threshold

        expansion_strategy : typing.Optional[QueryExpansionStrategy]
            Query expansion strategy (auto, llm, or no_expansion)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SearchResponse
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.search_collection(
                readable_id="readable_id",
                query="customer payment issues",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.search_collection(
            readable_id,
            query=query,
            response_type=response_type,
            limit=limit,
            offset=offset,
            score_threshold=score_threshold,
            expansion_strategy=expansion_strategy,
            request_options=request_options,
        )
        return _response.data

    async def search_collection_advanced(
        self,
        readable_id: str,
        *,
        query: str,
        filter: typing.Optional[Filter] = OMIT,
        offset: typing.Optional[int] = OMIT,
        limit: typing.Optional[int] = OMIT,
        score_threshold: typing.Optional[float] = OMIT,
        summarize: typing.Optional[bool] = OMIT,
        response_type: typing.Optional[ResponseType] = OMIT,
        expansion_strategy: typing.Optional[QueryExpansionStrategy] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SearchResponse:
        """
        Advanced search with comprehensive filtering and options.

        This endpoint supports:
        - Metadata filtering using Qdrant's native filter syntax
        - Pagination with offset and limit
        - Score threshold filtering
        - Query expansion strategies

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to search

        query : str
            The search query text

        filter : typing.Optional[Filter]
            Qdrant native filter for metadata-based filtering

        offset : typing.Optional[int]
            Number of results to skip

        limit : typing.Optional[int]
            Maximum number of results to return

        score_threshold : typing.Optional[float]
            Minimum similarity score threshold

        summarize : typing.Optional[bool]
            Whether to summarize results

        response_type : typing.Optional[ResponseType]
            Type of response (raw or completion)

        expansion_strategy : typing.Optional[QueryExpansionStrategy]
            Query expansion strategy. Enhances recall by expanding the query with synonyms, related terms, and other variations, but increases latency.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SearchResponse
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK, FieldCondition, Filter

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.search_collection_advanced(
                readable_id="readable_id",
                query="customer payment issues",
                filter=Filter(
                    must=FieldCondition(
                        key="key",
                    ),
                ),
                limit=50,
                score_threshold=0.7,
                response_type="completion",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.search_collection_advanced(
            readable_id,
            query=query,
            filter=filter,
            offset=offset,
            limit=limit,
            score_threshold=score_threshold,
            summarize=summarize,
            response_type=response_type,
            expansion_strategy=expansion_strategy,
            request_options=request_options,
        )
        return _response.data

    async def refresh_all_source_connections(
        self, readable_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[SourceConnectionJob]:
        """
        Trigger data synchronization for all source connections in the collection.

        <br/><br/>The sync jobs run asynchronously in the background, so this endpoint
        returns immediately with job details that you can use to track progress. You can
        monitor the status of individual data synchronization using the source connection
        endpoints.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to refresh

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[SourceConnectionJob]
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.refresh_all_source_connections(
                readable_id="readable_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.refresh_all_source_connections(readable_id, request_options=request_options)
        return _response.data
