# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .entity_definition_entity_schema import EntityDefinitionEntitySchema
from .entity_type import EntityType


class EntityDefinition(UniversalBaseModel):
    """
    Schema for an entity definition.
    """

    name: str
    description: typing.Optional[str] = None
    type: EntityType
    entity_schema: EntityDefinitionEntitySchema
    parent_id: typing.Optional[str] = None
    module_name: str
    class_name: str
    id: str
    organization_id: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
