# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class OrganizationCreate(UniversalBaseModel):
    """
    Organization creation schema.
    """

    name: str = pydantic.Field()
    """
    Organization name
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Organization description
    """

    auth_0_org_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="auth0_org_id")] = (
        pydantic.Field(default=None)
    )
    """
    Auth0 organization ID
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
