
<p align="center"><img src="https://raw.githubusercontent.com/gist/DogsTailFarmer/167eaf65cebfe95d954082c7f181a2cc/raw/a67270de8663ad3de4733330ff64c9ba3153f87d/Logo%202v3.svg" width="300"></p>

***
<h1 align="center">Crypto exchanges API/WSS wrapper with grpc powered server</h1>

<h2 align="center">Binance, FTX, Bitfinex</h2>

<h3 align="center">For SPOT markets</h2>

***
<a href="https://badge.fury.io/py/exchanges-wrapper"><img src="https://badge.fury.io/py/exchanges-wrapper.svg" alt="PyPI version"></a>
<a href="https://codeclimate.com/github/DogsTailFarmer/exchanges-wrapper/maintainability"><img src="https://api.codeclimate.com/v1/badges/f333ab9b1f3024699e09/maintainability" /></a>
<a href="https://deepsource.io/gh/DogsTailFarmer/exchanges-wrapper/?ref=repository-badge}" target="_blank"><img alt="DeepSource" title="DeepSource" src="https://deepsource.io/gh/DogsTailFarmer/exchanges-wrapper.svg/?label=resolved+issues&token=XuG5PmzMiKlDL921-qREIuX_"/></a>
<a href="https://deepsource.io/gh/DogsTailFarmer/exchanges-wrapper/?ref=repository-badge}" target="_blank"><img alt="DeepSource" title="DeepSource" src="https://deepsource.io/gh/DogsTailFarmer/exchanges-wrapper.svg/?label=active+issues&token=XuG5PmzMiKlDL921-qREIuX_"/></a>
<a href="https://sonarcloud.io/summary/new_code?id=DogsTailFarmer_exchanges-wrapper" target="_blank"><img alt="sonarcloud" title="sonarcloud" src="https://sonarcloud.io/api/project_badges/measure?project=DogsTailFarmer_exchanges-wrapper&metric=alert_status"/></a>
***
Format ```exchanges_wrapper/exch_srv_cfg.toml``` changed from 1.2.0 version. Before update, save old file and transfer
configuration data into new.
***

## exchanges-wrapper vs binance.py
The main difference is the development of the project for trading with many exchanges, including DeFi platforms shortly.

Next is adding a new module ```exchanges_wrapper/exch_srv.py``` as a multiplexer layer, providing simultaneous async interaction for many accounts
and many trading pairs through one connection. It's powered by [gRPC](https://grpc.io/about/)
Remote Procedure Call framework.

Warning. Coverage of overridden binance.py packages is significant but not complete.
Served methods describes into ```example/exch_client.py```

### Initial capabilities (inherited from binance.py)
- Covers general endpoints (test connectivity and get exchange information's)
- Covers market data endpoints
- Covers Account endpoints (create and manage orders)
- Covers user data stream (receive real time user updates)
- Covers web socket streams (receive real time market updates)
- Async support
- Auto reconnect after exchanges API or network failure
- Completely free and without limitations

### Added Features
- Multi exchanges support
- Adaptive algorithm to ensure maximum performance and avoid exceeding the rates limits
- Passthrough logging

## FTX Implementation features
- Binance REST API and WSS are accepted as basic, connection of FTX and other exchanges
wrapped their API to Binance compatible
- For FTX, some data cannot be obtained by directly calling one method, it is generated by a synthetic or calculation
method
- FTX have not any testing or "paper trading" features, therefore, application development and testing is possible only
at real bidding. First, run applications on the [Binance Spot Test Network](https://testnet.binance.vision/).

## Get started
### Install
To install the library, you can just run the following command:
```console
pip install exchanges-wrapper
```
### Prepare exchange account
* Create account on [Binance](https://accounts.binance.com/en/register?ref=QCS4OGWR) and get 10% discount on all trading
fee
* Create account on [Bitfinex](https://www.bitfinex.com/sign-up?refcode=v_4az2nCP) and get 6% rebate fee
* Create account on [FTX](https://ftx.com/profile#a=62025440)
* For test purpose log in at [Binance Spot Test Network](https://testnet.binance.vision/)
* Create API Key

### Startup
* Specify api_key and api_secret in ```exchanges_wrapper/exch_srv_cfg.toml```
* Run ```exchanges_wrapper/exch_srv.py``` in terminal window
* In ```example/ms_cfg.toml``` select desired exchange. Don't change exchange name.
* Run ```example/exch_client.py``` in other terminal window

### Documentations
* For [binance.py](https://th0rgal.gitbook.io/binance-py/) use original
* Served methods and examples of their use are described at ```example/exch_client.py```
* For [Protocol Buffers](https://developers.google.com/protocol-buffers/docs/overview) serializing structured data
see ```proto/exchanges_wrapper/api.proto```

## Donate
*BNB*, *BUSD*, *USDT* (BEP20) 0x5b52c6ba862b11318616ee6cef64388618318b92

*USDT* (TRC20) TP1Y43dpY7rrRyTSLaSKDZmFirqvRcpopC

## Powered by exchanges-wrapper
<p align="left"><a href="https://github.com/DogsTailFarmer/martin-binance"></a><img src="https://github.com/DogsTailFarmer/martin-binance/raw/public/doc/Modified%20martingale.svg" width="50"></p>

[martin-binance](https://github.com/DogsTailFarmer/martin-binance)
Free trading system for crypto exchanges SPOT markets. Adaptive customizable reverse grid strategy based on martingale.
