"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImportedTaskDefinition = void 0;
const core_1 = require("@aws-cdk/core");
const task_definition_1 = require("./task-definition");
/**
 * Task definition reference of an imported task
 */
class ImportedTaskDefinition extends core_1.Resource {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        /**
         * Execution role for this task definition
         */
        this.executionRole = undefined;
        this.compatibility = (_a = props.compatibility) !== null && _a !== void 0 ? _a : task_definition_1.Compatibility.EC2_AND_FARGATE;
        this.taskDefinitionArn = props.taskDefinitionArn;
        this._taskRole = props.taskRole;
        this._networkMode = props.networkMode;
    }
    get networkMode() {
        if (this._networkMode == undefined) {
            throw new Error('This operation requires the networkMode in ImportedTaskDefinition to be defined. ' +
                'Add the \'networkMode\' in ImportedTaskDefinitionProps to instantiate ImportedTaskDefinition');
        }
        else {
            return this._networkMode;
        }
    }
    get taskRole() {
        if (this._taskRole == undefined) {
            throw new Error('This operation requires the taskRole in ImportedTaskDefinition to be defined. ' +
                'Add the \'taskRole\' in ImportedTaskDefinitionProps to instantiate ImportedTaskDefinition');
        }
        else {
            return this._taskRole;
        }
    }
    /**
     * Return true if the task definition can be run on an EC2 cluster
     */
    get isEc2Compatible() {
        return task_definition_1.isEc2Compatible(this.compatibility);
    }
    /**
     * Return true if the task definition can be run on a Fargate cluster
     */
    get isFargateCompatible() {
        return task_definition_1.isFargateCompatible(this.compatibility);
    }
}
exports.ImportedTaskDefinition = ImportedTaskDefinition;
//# sourceMappingURL=data:application/json;base64,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