"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2TaskDefinition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _imported_task_definition_1 = require("../base/_imported-task-definition");
const task_definition_1 = require("../base/task-definition");
/**
 * The details of a task definition run on an EC2 cluster.
 *
 * @stability stable
 * @resource AWS::ECS::TaskDefinition
 */
class Ec2TaskDefinition extends task_definition_1.TaskDefinition {
    /**
     * Constructs a new instance of the Ec2TaskDefinition class.
     *
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            ...props,
            compatibility: task_definition_1.Compatibility.EC2,
            placementConstraints: props.placementConstraints,
            ipcMode: props.ipcMode,
            pidMode: props.pidMode,
            inferenceAccelerators: props.inferenceAccelerators,
        });
    }
    /**
     * Imports a task definition from the specified task definition ARN.
     *
     * @stability stable
     */
    static fromEc2TaskDefinitionArn(scope, id, ec2TaskDefinitionArn) {
        return new _imported_task_definition_1.ImportedTaskDefinition(scope, id, {
            taskDefinitionArn: ec2TaskDefinitionArn,
        });
    }
    /**
     * Imports an existing Ec2 task definition from its attributes.
     *
     * @stability stable
     */
    static fromEc2TaskDefinitionAttributes(scope, id, attrs) {
        return new _imported_task_definition_1.ImportedTaskDefinition(scope, id, {
            taskDefinitionArn: attrs.taskDefinitionArn,
            compatibility: task_definition_1.Compatibility.EC2,
            networkMode: attrs.networkMode,
            taskRole: attrs.taskRole,
        });
    }
}
exports.Ec2TaskDefinition = Ec2TaskDefinition;
_a = JSII_RTTI_SYMBOL_1;
Ec2TaskDefinition[_a] = { fqn: "@aws-cdk/aws-ecs.Ec2TaskDefinition", version: "1.106.0" };
//# sourceMappingURL=data:application/json;base64,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