"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnvironmentFileType = exports.S3EnvironmentFile = exports.AssetEnvironmentFile = exports.EnvironmentFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_s3_assets_1 = require("@aws-cdk/aws-s3-assets");
/**
 * Constructs for types of environment files.
 *
 * @stability stable
 */
class EnvironmentFile {
    /**
     * Loads the environment file from a local disk path.
     *
     * @param path Local disk path.
     * @stability stable
     */
    static fromAsset(path, options) {
        return new AssetEnvironmentFile(path, options);
    }
    /**
     * Loads the environment file from an S3 bucket.
     *
     * @param bucket The S3 bucket.
     * @param key The object key.
     * @param objectVersion Optional S3 object version.
     * @returns `S3EnvironmentFile` associated with the specified S3 object.
     * @stability stable
     */
    static fromBucket(bucket, key, objectVersion) {
        return new S3EnvironmentFile(bucket, key, objectVersion);
    }
}
exports.EnvironmentFile = EnvironmentFile;
_a = JSII_RTTI_SYMBOL_1;
EnvironmentFile[_a] = { fqn: "@aws-cdk/aws-ecs.EnvironmentFile", version: "1.106.0" };
/**
 * Environment file from a local directory.
 *
 * @stability stable
 */
class AssetEnvironmentFile extends EnvironmentFile {
    /**
     * @param path The path to the asset file or directory.
     * @stability stable
     */
    constructor(path, options = {}) {
        super();
        this.path = path;
        this.options = options;
    }
    /**
     * Called when the container is initialized to allow this object to bind to the stack.
     *
     * @stability stable
     */
    bind(scope) {
        // If the same AssetCode is used multiple times, retain only the first instantiation.
        if (!this.asset) {
            this.asset = new aws_s3_assets_1.Asset(scope, 'EnvironmentFile', {
                path: this.path,
                ...this.options,
            });
        }
        if (!this.asset.isFile) {
            throw new Error(`Asset must be a single file (${this.path})`);
        }
        return {
            fileType: EnvironmentFileType.S3,
            s3Location: {
                bucketName: this.asset.s3BucketName,
                objectKey: this.asset.s3ObjectKey,
            },
        };
    }
}
exports.AssetEnvironmentFile = AssetEnvironmentFile;
_b = JSII_RTTI_SYMBOL_1;
AssetEnvironmentFile[_b] = { fqn: "@aws-cdk/aws-ecs.AssetEnvironmentFile", version: "1.106.0" };
/**
 * Environment file from S3.
 *
 * @stability stable
 */
class S3EnvironmentFile extends EnvironmentFile {
    /**
     * @stability stable
     */
    constructor(bucket, key, objectVersion) {
        super();
        this.key = key;
        this.objectVersion = objectVersion;
        if (!bucket.bucketName) {
            throw new Error('bucketName is undefined for the provided bucket');
        }
        this.bucketName = bucket.bucketName;
    }
    /**
     * Called when the container is initialized to allow this object to bind to the stack.
     *
     * @stability stable
     */
    bind(_scope) {
        return {
            fileType: EnvironmentFileType.S3,
            s3Location: {
                bucketName: this.bucketName,
                objectKey: this.key,
                objectVersion: this.objectVersion,
            },
        };
    }
}
exports.S3EnvironmentFile = S3EnvironmentFile;
_c = JSII_RTTI_SYMBOL_1;
S3EnvironmentFile[_c] = { fqn: "@aws-cdk/aws-ecs.S3EnvironmentFile", version: "1.106.0" };
/**
 * Type of environment file to be included in the container definition
 */
var EnvironmentFileType;
(function (EnvironmentFileType) {
    EnvironmentFileType["S3"] = "s3";
})(EnvironmentFileType = exports.EnvironmentFileType || (exports.EnvironmentFileType = {}));
//# sourceMappingURL=data:application/json;base64,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