import { DockerImageAssetOptions } from '@aws-cdk/aws-ecr-assets';
import { ContainerDefinition } from '../container-definition';
import { ContainerImage, ContainerImageConfig } from '../container-image';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * The properties for building an AssetImage.
 *
 * @stability stable
 */
export interface AssetImageProps extends DockerImageAssetOptions {
}
/**
 * An image that will be built from a local directory with a Dockerfile.
 *
 * @stability stable
 */
export declare class AssetImage extends ContainerImage {
    private readonly directory;
    private readonly props;
    /**
     * Constructs a new instance of the AssetImage class.
     *
     * @param directory The directory containing the Dockerfile.
     * @stability stable
     */
    constructor(directory: string, props?: AssetImageProps);
    /**
     * Called when the image is used by a ContainerDefinition.
     *
     * @stability stable
     */
    bind(scope: CoreConstruct, containerDefinition: ContainerDefinition): ContainerImageConfig;
}
