import * as ecr from '@aws-cdk/aws-ecr';
import { ContainerDefinition } from '../container-definition';
import { ContainerImage, ContainerImageConfig } from '../container-image';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * An image from an Amazon ECR repository.
 *
 * @stability stable
 */
export declare class EcrImage extends ContainerImage {
    private readonly repository;
    private readonly tagOrDigest;
    /**
     * The image name. Images in Amazon ECR repositories can be specified by either using the full registry/repository:tag or registry/repository@digest.
     *
     * For example, 012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>:latest or
     * 012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>@sha256:94afd1f2e64d908bc90dbca0035a5b567EXAMPLE.
     *
     * @stability stable
     */
    readonly imageName: string;
    /**
     * Constructs a new instance of the EcrImage class.
     *
     * @stability stable
     */
    constructor(repository: ecr.IRepository, tagOrDigest: string);
    /**
     * Called when the image is used by a ContainerDefinition.
     *
     * @stability stable
     */
    bind(_scope: CoreConstruct, containerDefinition: ContainerDefinition): ContainerImageConfig;
}
