import * as secretsmanager from '@aws-cdk/aws-secretsmanager';
import { ContainerDefinition } from '../container-definition';
import { ContainerImage, ContainerImageConfig } from '../container-image';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * The properties for an image hosted in a public or private repository.
 *
 * @stability stable
 */
export interface RepositoryImageProps {
    /**
     * The secret to expose to the container that contains the credentials for the image repository.
     *
     * The supported value is the full ARN of an AWS Secrets Manager secret.
     *
     * @stability stable
     */
    readonly credentials?: secretsmanager.ISecret;
}
/**
 * An image hosted in a public or private repository.
 *
 * For images hosted in Amazon ECR, see
 * [EcrImage](https://docs.aws.amazon.com/AmazonECR/latest/userguide/images.html).
 *
 * @stability stable
 */
export declare class RepositoryImage extends ContainerImage {
    private readonly imageName;
    private readonly props;
    /**
     * Constructs a new instance of the RepositoryImage class.
     *
     * @stability stable
     */
    constructor(imageName: string, props?: RepositoryImageProps);
    /**
     * Called when the image is used by a ContainerDefinition.
     *
     * @stability stable
     */
    bind(scope: CoreConstruct, containerDefinition: ContainerDefinition): ContainerImageConfig;
}
