"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TagParameterContainerImage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const container_image_1 = require("../container-image");
/**
 * A special type of {@link ContainerImage} that uses an ECR repository for the image, but a CloudFormation Parameter for the tag of the image in that repository.
 *
 * This allows providing this tag through the Parameter at deploy time,
 * for example in a CodePipeline that pushes a new tag of the image to the repository during a build step,
 * and then provides that new tag through the CloudFormation Parameter in the deploy step.
 *
 * @see #tagParameterName
 * @stability stable
 */
class TagParameterContainerImage extends container_image_1.ContainerImage {
    /**
     * @stability stable
     */
    constructor(repository) {
        super();
        this.repository = repository;
    }
    /**
     * Called when the image is used by a ContainerDefinition.
     *
     * @stability stable
     */
    bind(scope, containerDefinition) {
        this.repository.grantPull(containerDefinition.taskDefinition.obtainExecutionRole());
        const imageTagParameter = new cdk.CfnParameter(scope, 'ImageTagParam');
        this.imageTagParameter = imageTagParameter;
        return {
            imageName: this.repository.repositoryUriForTag(imageTagParameter.valueAsString),
        };
    }
    /**
     * Returns the name of the CloudFormation Parameter that represents the tag of the image in the ECR repository.
     *
     * @stability stable
     */
    get tagParameterName() {
        return cdk.Lazy.string({
            produce: () => {
                if (this.imageTagParameter) {
                    return this.imageTagParameter.logicalId;
                }
                else {
                    throw new Error('TagParameterContainerImage must be used in a container definition when using tagParameterName');
                }
            },
        });
    }
    /**
     * Returns the value of the CloudFormation Parameter that represents the tag of the image in the ECR repository.
     *
     * @stability stable
     */
    get tagParameterValue() {
        return cdk.Lazy.string({
            produce: () => {
                if (this.imageTagParameter) {
                    return this.imageTagParameter.valueAsString;
                }
                else {
                    throw new Error('TagParameterContainerImage must be used in a container definition when using tagParameterValue');
                }
            },
        });
    }
}
exports.TagParameterContainerImage = TagParameterContainerImage;
_a = JSII_RTTI_SYMBOL_1;
TagParameterContainerImage[_a] = { fqn: "@aws-cdk/aws-ecs.TagParameterContainerImage", version: "1.106.0" };
//# sourceMappingURL=data:application/json;base64,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