import { ContainerDefinition } from '../container-definition';
import { BaseLogDriverProps } from './base-log-driver';
import { LogDriver, LogDriverConfig } from './log-driver';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * Specifies the firelens log driver configuration options.
 *
 * @stability stable
 */
export interface FireLensLogDriverProps extends BaseLogDriverProps {
    /**
     * The configuration options to send to the log driver.
     *
     * @default - the log driver options
     * @stability stable
     */
    readonly options?: {
        [key: string]: string;
    };
}
/**
 * FireLens enables you to use task definition parameters to route logs to an AWS service   or AWS Partner Network (APN) destination for log storage and analytics.
 *
 * @stability stable
 */
export declare class FireLensLogDriver extends LogDriver {
    /**
     * The configuration options to send to the log driver.
     * @default - the log driver options
     */
    private options?;
    /**
     * Constructs a new instance of the FireLensLogDriver class.
     *
     * @param props the awsfirelens log driver configuration options.
     * @stability stable
     */
    constructor(props: FireLensLogDriverProps);
    /**
     * Called when the log driver is configured on a container.
     *
     * @stability stable
     */
    bind(_scope: CoreConstruct, _containerDefinition: ContainerDefinition): LogDriverConfig;
}
