import { Duration } from '@aws-cdk/core';
import { ContainerDefinition } from '../container-definition';
import { BaseLogDriverProps } from './base-log-driver';
import { LogDriver, LogDriverConfig } from './log-driver';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * The type of compression the GELF driver uses to compress each log message.
 *
 * @stability stable
 */
export declare enum GelfCompressionType {
    /**
     * @stability stable
     */
    GZIP = "gzip",
    /**
     * @stability stable
     */
    ZLIB = "zlib",
    /**
     * @stability stable
     */
    NONE = "none"
}
/**
 * Specifies the journald log driver configuration options.
 *
 * [Source](https://docs.docker.com/config/containers/logging/gelf/)
 *
 * @stability stable
 */
export interface GelfLogDriverProps extends BaseLogDriverProps {
    /**
     * The address of the GELF server.
     *
     * tcp and udp are the only supported URI
     * specifier and you must specify the port.
     *
     * @stability stable
     */
    readonly address: string;
    /**
     * UDP Only The type of compression the GELF driver uses to compress each log message.
     *
     * Allowed values are gzip, zlib and none.
     *
     * @default - gzip
     * @stability stable
     */
    readonly compressionType?: GelfCompressionType;
    /**
     * UDP Only The level of compression when gzip or zlib is the gelf-compression-type.
     *
     * An integer in the range of -1 to 9 (BestCompression). Higher levels provide more
     * compression at lower speed. Either -1 or 0 disables compression.
     *
     * @default - 1
     * @stability stable
     */
    readonly compressionLevel?: number;
    /**
     * TCP Only The maximum number of reconnection attempts when the connection drop.
     *
     * A positive integer.
     *
     * @default - 3
     * @stability stable
     */
    readonly tcpMaxReconnect?: number;
    /**
     * TCP Only The number of seconds to wait between reconnection attempts.
     *
     * A positive integer.
     *
     * @default - 1
     * @stability stable
     */
    readonly tcpReconnectDelay?: Duration;
}
/**
 * A log driver that sends log information to journald Logs.
 *
 * @stability stable
 */
export declare class GelfLogDriver extends LogDriver {
    private readonly props;
    /**
     * Constructs a new instance of the GelfLogDriver class.
     *
     * @param props the gelf log driver configuration options.
     * @stability stable
     */
    constructor(props: GelfLogDriverProps);
    /**
     * Called when the log driver is configured on a container.
     *
     * @stability stable
     */
    bind(_scope: CoreConstruct, _containerDefinition: ContainerDefinition): LogDriverConfig;
}
