import { ContainerDefinition } from '../container-definition';
import { BaseLogDriverProps } from './base-log-driver';
import { LogDriver, LogDriverConfig } from './log-driver';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * Specifies the json-file log driver configuration options.
 *
 * [Source](https://docs.docker.com/config/containers/logging/json-file/)
 *
 * @stability stable
 */
export interface JsonFileLogDriverProps extends BaseLogDriverProps {
    /**
     * The maximum size of the log before it is rolled.
     *
     * A positive integer plus a modifier
     * representing the unit of measure (k, m, or g).
     *
     * @default - -1 (unlimited)
     * @stability stable
     */
    readonly maxSize?: string;
    /**
     * The maximum number of log files that can be present.
     *
     * If rolling the logs creates
     * excess files, the oldest file is removed. Only effective when max-size is also set.
     * A positive integer.
     *
     * @default - 1
     * @stability stable
     */
    readonly maxFile?: number;
    /**
     * Toggles compression for rotated logs.
     *
     * @default - false
     * @stability stable
     */
    readonly compress?: boolean;
}
/**
 * A log driver that sends log information to json-file Logs.
 *
 * @stability stable
 */
export declare class JsonFileLogDriver extends LogDriver {
    private readonly props;
    /**
     * Constructs a new instance of the JsonFileLogDriver class.
     *
     * @param props the json-file log driver configuration options.
     * @stability stable
     */
    constructor(props?: JsonFileLogDriverProps);
    /**
     * Called when the log driver is configured on a container.
     *
     * @stability stable
     */
    bind(_scope: CoreConstruct, _containerDefinition: ContainerDefinition): LogDriverConfig;
}
