import { AwsLogDriverProps } from './aws-log-driver';
import { FireLensLogDriverProps } from './firelens-log-driver';
import { FluentdLogDriverProps } from './fluentd-log-driver';
import { GelfLogDriverProps } from './gelf-log-driver';
import { JournaldLogDriverProps } from './journald-log-driver';
import { JsonFileLogDriverProps } from './json-file-log-driver';
import { LogDriver } from './log-driver';
import { SplunkLogDriverProps } from './splunk-log-driver';
import { SyslogLogDriverProps } from './syslog-log-driver';
/**
 * The base class for log drivers.
 *
 * @stability stable
 */
export declare class LogDrivers {
    /**
     * Creates a log driver configuration that sends log information to CloudWatch Logs.
     *
     * @stability stable
     */
    static awsLogs(props: AwsLogDriverProps): LogDriver;
    /**
     * Creates a log driver configuration that sends log information to fluentd Logs.
     *
     * @stability stable
     */
    static fluentd(props?: FluentdLogDriverProps): LogDriver;
    /**
     * Creates a log driver configuration that sends log information to gelf Logs.
     *
     * @stability stable
     */
    static gelf(props: GelfLogDriverProps): LogDriver;
    /**
     * Creates a log driver configuration that sends log information to journald Logs.
     *
     * @stability stable
     */
    static journald(props?: JournaldLogDriverProps): LogDriver;
    /**
     * Creates a log driver configuration that sends log information to json-file Logs.
     *
     * @stability stable
     */
    static jsonFile(props?: JsonFileLogDriverProps): LogDriver;
    /**
     * Creates a log driver configuration that sends log information to splunk Logs.
     *
     * @stability stable
     */
    static splunk(props: SplunkLogDriverProps): LogDriver;
    /**
     * Creates a log driver configuration that sends log information to syslog Logs.
     *
     * @stability stable
     */
    static syslog(props?: SyslogLogDriverProps): LogDriver;
    /**
     * Creates a log driver configuration that sends log information to firelens log router.
     *
     * For detail configurations, please refer to Amazon ECS FireLens Examples:
     * https://github.com/aws-samples/amazon-ecs-firelens-examples
     *
     * @stability stable
     */
    static firelens(props: FireLensLogDriverProps): LogDriver;
}
